import { Cluster, Event, EventList, Host } from '../api';
export declare type EventsEntityKind = 'cluster' | 'host';
export declare type ClusterEventsFiltersType = {
    fulltext: string;
    hosts: Host['id'][];
    severity: Event['severity'][];
    clusterLevel: boolean;
    orphanedHosts: boolean;
    selectAll: boolean;
};
export declare type EventFetchProps = {
    hostId: Event['hostId'];
    cluster: Cluster;
};
export declare type EventListFetchProps = EventFetchProps & {
    entityKind: EventsEntityKind;
    onFetchEvents: (params: {
        clusterId: Cluster['id'];
        hostId?: Host['id'];
    }, onSuccess: (data: EventList) => void, onError: (message: string) => void) => Promise<void>;
    className?: string;
};
