import { PayloadAction } from '@reduxjs/toolkit';
import { Cluster, Host } from '../../../common';
import { ResourceUIState } from '../../../common';
export declare type RetrievalErrorType = {
    code: string;
};
declare type CurrentClusterStateSlice = {
    data?: Cluster;
    uiState: ResourceUIState;
    isReloadScheduled: number;
    errorDetail?: RetrievalErrorType;
};
export declare const fetchClusterAsync: import("@reduxjs/toolkit").AsyncThunk<void | Cluster, string, {
    rejectValue: RetrievalErrorType;
}>;
export declare const currentClusterSlice: import("@reduxjs/toolkit").Slice<CurrentClusterStateSlice, {
    updateCluster: (state: import("immer/dist/internal").WritableDraft<CurrentClusterStateSlice>, action: PayloadAction<Cluster>) => {
        data: Cluster;
        uiState: ResourceUIState;
        isReloadScheduled: number;
        errorDetail?: import("immer/dist/internal").WritableDraft<RetrievalErrorType> | undefined;
    };
    updateHost: (state: import("immer/dist/internal").WritableDraft<CurrentClusterStateSlice>, action: PayloadAction<Host>) => import("immer/dist/internal").WritableDraft<CurrentClusterStateSlice>;
    cleanCluster: () => CurrentClusterStateSlice;
    forceReload: (state: import("immer/dist/internal").WritableDraft<CurrentClusterStateSlice>) => {
        isReloadScheduled: number;
        data?: import("immer/dist/internal").WritableDraft<Cluster> | undefined;
        uiState: ResourceUIState;
        errorDetail?: import("immer/dist/internal").WritableDraft<RetrievalErrorType> | undefined;
    };
    cancelForceReload: (state: import("immer/dist/internal").WritableDraft<CurrentClusterStateSlice>) => {
        isReloadScheduled: number;
        data?: import("immer/dist/internal").WritableDraft<Cluster> | undefined;
        uiState: ResourceUIState;
        errorDetail?: import("immer/dist/internal").WritableDraft<RetrievalErrorType> | undefined;
    };
}, "currentCluster">;
export declare const updateCluster: import("@reduxjs/toolkit").ActionCreatorWithPayload<Cluster, string>, updateHost: import("@reduxjs/toolkit").ActionCreatorWithPayload<Host, string>, cleanCluster: import("@reduxjs/toolkit").ActionCreatorWithoutPayload<string>, forceReload: import("@reduxjs/toolkit").ActionCreatorWithoutPayload<string>, cancelForceReload: import("@reduxjs/toolkit").ActionCreatorWithoutPayload<string>;
declare const _default: import("redux").Reducer<CurrentClusterStateSlice, import("redux").AnyAction>;
export default _default;
