function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React from 'react';
import { storiesOf } from '@storybook/react';
import { action } from '@storybook/addon-actions';
import { withKnobs, boolean, select, text } from '@storybook/addon-knobs';
import Modal from '../Modal';
import TextInput from '../TextInput';
import { settings } from 'carbon-components';
var prefix = settings.prefix;
var sizes = {
  Default: '',
  'Extra small (xs)': 'xs',
  'Small (sm)': 'sm',
  'Large (lg)': 'lg'
};

var props = function props() {
  return {
    className: 'some-class',
    open: boolean('Open (open)', true),
    passiveModal: boolean('Without footer (passiveModal)', false),
    danger: boolean('Danger mode (danger)', false),
    shouldSubmitOnEnter: boolean('Enter key to submit (shouldSubmitOnEnter)', false),
    focusTrap: boolean('Trap focus (focusTrap)', false),
    hasScrollingContent: boolean('Modal contains scrollable content (hasScrollingContent)', false),
    modalHeading: text('Modal heading (modalHeading)', 'Modal heading'),
    modalLabel: text('Optional label (modalLabel)', 'Label'),
    modalAriaLabel: text('ARIA label, used only if modalLabel not provided (modalAriaLabel)', 'A label to be read by screen readers on the modal root node'),
    primaryButtonText: text('Primary button text (primaryButtonText)', 'Primary Button'),
    secondaryButtonText: text('Secondary button text (secondaryButtonText)', 'Secondary Button'),
    selectorPrimaryFocus: text('Primary focus element selector (selectorPrimaryFocus)', '[data-modal-primary-focus]'),
    size: select('Size (size)', sizes),
    iconDescription: text('Close icon description (iconDescription)', 'Close the modal'),
    onBlur: action('onBlur'),
    onClick: action('onClick'),
    onFocus: action('onFocus'),
    onRequestClose: action('onRequestClose'),
    onRequestSubmit: action('onRequestSubmit'),
    onSecondarySubmit: action('onSecondarySubmit')
  };
};

var titleOnlyProps = function titleOnlyProps() {
  var passiveModal = boolean('Without footer (passiveModal)', false);
  return {
    className: 'some-class',
    open: boolean('Open (open)', true),
    passiveModal: passiveModal,
    danger: !passiveModal && boolean('Danger mode (danger)', false),
    modalHeading: text('Modal heading (modalHeading)', "\n      Passive modal title as the message. Should be direct and 3 lines or less.\n    ".trim()),
    modalAriaLabel: text('ARIA label, used only if modalLabel not provided (modalAriaLabel)', 'A label to be read by screen readers on the modal root node'),
    primaryButtonText: text('Primary button text (primaryButtonText)', 'Primary Button'),
    secondaryButtonText: text('Secondary button text (secondaryButtonText)', 'Secondary Button'),
    size: select('Size (size)', sizes, 'sm'),
    iconDescription: text('Close icon description (iconDescription)', 'Close the modal'),
    onBlur: action('onBlur'),
    onClick: action('onClick'),
    onFocus: action('onFocus'),
    onRequestClose: action('onRequestClose')
  };
};

storiesOf('Modal', module).addDecorator(withKnobs).add('Default', function () {
  var _props = props(),
      size = _props.size,
      rest = _objectWithoutProperties(_props, ["size"]);

  return React.createElement(Modal, _extends({}, rest, {
    size: size || undefined
  }), React.createElement("p", {
    className: "".concat(prefix, "--modal-content__text")
  }, "Please see ModalWrapper for more examples and demo of the functionality."), rest.hasScrollingContent && React.createElement(React.Fragment, null, React.createElement("p", null, "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean id accumsan augue. Phasellus consequat augue vitae tellus tincidunt posuere. Curabitur justo urna, consectetur vel elit iaculis, ultrices condimentum risus. Nulla facilisi. Etiam venenatis molestie tellus. Quisque consectetur non risus eu rutrum.", ' '), React.createElement("p", null, "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean id accumsan augue. Phasellus consequat augue vitae tellus tincidunt posuere. Curabitur justo urna, consectetur vel elit iaculis, ultrices condimentum risus. Nulla facilisi. Etiam venenatis molestie tellus. Quisque consectetur non risus eu rutrum.", ' '), React.createElement("p", null, "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean id accumsan augue. Phasellus consequat augue vitae tellus tincidunt posuere. Curabitur justo urna, consectetur vel elit iaculis, ultrices condimentum risus. Nulla facilisi. Etiam venenatis molestie tellus. Quisque consectetur non risus eu rutrum.", ' '), React.createElement("h3", null, "Lorem ipsum"), React.createElement("p", null, "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean id accumsan augue. Phasellus consequat augue vitae tellus tincidunt posuere. Curabitur justo urna, consectetur vel elit iaculis, ultrices condimentum risus. Nulla facilisi. Etiam venenatis molestie tellus. Quisque consectetur non risus eu rutrum.", ' '), React.createElement("p", null, "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean id accumsan augue. Phasellus consequat augue vitae tellus tincidunt posuere. Curabitur justo urna, consectetur vel elit iaculis, ultrices condimentum risus. Nulla facilisi. Etiam venenatis molestie tellus. Quisque consectetur non risus eu rutrum.", ' '), React.createElement("p", null, "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean id accumsan augue. Phasellus consequat augue vitae tellus tincidunt posuere. Curabitur justo urna, consectetur vel elit iaculis, ultrices condimentum risus. Nulla facilisi. Etiam venenatis molestie tellus. Quisque consectetur non risus eu rutrum.", ' '), React.createElement("p", null, "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean id accumsan augue. Phasellus consequat augue vitae tellus tincidunt posuere. Curabitur justo urna, consectetur vel elit iaculis, ultrices condimentum risus. Nulla facilisi. Etiam venenatis molestie tellus. Quisque consectetur non risus eu rutrum.", ' ')));
}, {
  info: {
    text: "\n            Modals communicate information via a secondary window and allow the user to maintain the context of a particular task.\n            Use the Modal Wrapper component to encapsulate your Modal within a button.\n          "
  }
}).add('Title only', function () {
  var _titleOnlyProps = titleOnlyProps(),
      size = _titleOnlyProps.size,
      rest = _objectWithoutProperties(_titleOnlyProps, ["size"]);

  return React.createElement(React.Fragment, null, React.createElement(Modal, _extends({}, rest, {
    size: size || undefined
  })));
}, {
  info: {
    text: "\n          In \"small\" and \"xs\" modals size, the title is allowed to span multiple lines and be used for the main message.\n          It should be less than 3 lines of text. If more room is required then use the standard body copy format.\n        "
  }
}).add('Trap Focus', function () {
  var _props2 = props(),
      size = _props2.size,
      rest = _objectWithoutProperties(_props2, ["size"]);

  return React.createElement(React.Fragment, null, React.createElement(Modal, _extends({}, rest, {
    hasForm: true,
    size: size || undefined,
    selectorPrimaryFocus: "#text-input-2"
  }), React.createElement(TextInput, {
    id: "text-input-1",
    labelText: "Text Input 1",
    placeholder: "Enter text...",
    style: {
      marginBottom: '1rem'
    }
  }), React.createElement(TextInput, {
    id: "text-input-2",
    labelText: "Text Input 2",
    placeholder: "Enter text..."
  })));
}, {
  info: {
    text: "\n            Specify a selector for the primary element to focus when opening a modal.\n          "
  }
});