"use strict";

var _react = _interopRequireWildcard(require("react"));

var _react2 = require("@storybook/react");

var _addonActions = require("@storybook/addon-actions");

var _addonKnobs = require("@storybook/addon-knobs");

var _ComboBox = _interopRequireDefault(require("../ComboBox"));

var _Button = _interopRequireDefault(require("../Button"));

var _withState = _interopRequireDefault(require("../../tools/withState"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(source, true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(source).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance"); }

function _iterableToArrayLimit(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

var items = [{
  id: 'option-0',
  text: 'Option 1'
}, {
  id: 'option-1',
  text: 'Option 2'
}, {
  id: 'option-2',
  text: 'Option 3',
  selected: true
}, {
  id: 'option-3',
  text: 'Option 4'
}, {
  id: 'option-4',
  text: 'An example option that is really long to show what should be done to handle long text'
}];
var sizes = {
  'Extra large size (xl)': 'xl',
  'Regular size (lg)': '',
  'Small size (sm)': 'sm'
};

var props = function props() {
  return {
    id: (0, _addonKnobs.text)('Combobox ID (id)', 'carbon-combobox-example'),
    placeholder: (0, _addonKnobs.text)('Placeholder text (placeholder)', 'Filter...'),
    titleText: (0, _addonKnobs.text)('Title (titleText)', 'Combobox title'),
    helperText: (0, _addonKnobs.text)('Helper text (helperText)', 'Optional helper text here'),
    light: (0, _addonKnobs.boolean)('Light (light)', false),
    disabled: (0, _addonKnobs.boolean)('Disabled (disabled)', false),
    invalid: (0, _addonKnobs.boolean)('Invalid (invalid)', false),
    invalidText: (0, _addonKnobs.text)('Invalid text (invalidText)', 'A valid value is required'),
    size: (0, _addonKnobs.select)('Field size (size)', sizes, '') || undefined,
    onChange: (0, _addonActions.action)('onChange')
  };
};

var itemToElement = function itemToElement(item) {
  var itemAsArray = item.text.split(' ');
  return _react.default.createElement("div", null, _react.default.createElement("span", null, itemAsArray[0]), _react.default.createElement("span", {
    style: {
      color: 'blue'
    }
  }, " ", itemAsArray[1]));
};

var ControlledComboBoxApp = function ControlledComboBoxApp(props) {
  var _useState = (0, _react.useState)(items[0]),
      _useState2 = _slicedToArray(_useState, 2),
      selectedItem = _useState2[0],
      setSelectedItem = _useState2[1];

  var uid = items.length;
  return _react.default.createElement(_react.default.Fragment, null, _react.default.createElement(_ComboBox.default, _extends({}, props, {
    items: items,
    itemToString: function itemToString(item) {
      return item ? item.text : '';
    },
    onChange: function onChange(_ref) {
      var selectedItem = _ref.selectedItem;
      return setSelectedItem(selectedItem);
    },
    initialSelectedItem: items[0],
    selectedItem: selectedItem
  })), _react.default.createElement(_Button.default, {
    style: {
      marginTop: '1rem'
    },
    onClick: function onClick() {
      items.push({
        id: "id-".concat(uid++),
        text: "Option ".concat(uid)
      });
      setSelectedItem(items[items.length - 1]);
    }
  }, "Add new item"));
};

ControlledComboBoxApp.__docgenInfo = _objectSpread({}, _ComboBox.default.__docgenInfo, {
  props: _objectSpread({}, _ComboBox.default.__docgenInfo.props)
});
(0, _react2.storiesOf)('ComboBox', module).addDecorator(_addonKnobs.withKnobs).add('Default', function () {
  return _react.default.createElement("div", {
    style: {
      width: 300
    }
  }, _react.default.createElement(_ComboBox.default, _extends({
    items: items,
    itemToString: function itemToString(item) {
      return item ? item.text : '';
    }
  }, props())));
}, {
  info: {
    text: 'ComboBox'
  }
}).add('items as components', function () {
  return _react.default.createElement("div", {
    style: {
      width: 300
    }
  }, _react.default.createElement(_ComboBox.default, _extends({
    items: items,
    itemToString: function itemToString(item) {
      return item ? item.text : '';
    },
    itemToElement: itemToElement
  }, props())));
}, {
  info: {
    text: 'ComboBox'
  }
}).add('custom text input handling', function () {
  return _react.default.createElement(_withState.default, {
    initialState: {
      inputText: ''
    }
  }, function (_ref2) {
    var state = _ref2.state,
        setState = _ref2.setState;
    return _react.default.createElement("div", {
      style: {
        width: 300
      }
    }, _react.default.createElement(_ComboBox.default, _extends({
      items: items,
      itemToString: function itemToString(item) {
        return item ? "".concat(item.text, " queried with ").concat(state.inputText) : '';
      },
      shouldFilterItem: function shouldFilterItem() {
        return true;
      },
      onInputChange: function onInputChange(text) {
        return setState({
          inputText: text
        });
      }
    }, props())));
  });
}, {
  info: {
    text: "Sometimes you want to perform an async action to trigger a backend call on input change."
  }
}).add('application-level control for selection', function () {
  return _react.default.createElement(ControlledComboBoxApp, props());
}, {
  info: {
    text: "Controlled ComboBox example application"
  }
});