# Rule Descriptions

## Table of Contents

- [WCAG 2.0 Level A & AA Rules](#wcag-20-level-a--aa-rules)
- [WCAG 2.1 Level A & AA Rules](#wcag-21-level-a--aa-rules)
- [Best Practices Rules](#best-practices-rules)
- [Experimental Rules](#experimental-rules)
- [Deprecated Rules](#deprecated-rules)

## WCAG 2.0 Level A & AA Rules

| Rule ID                                                                                                                          | Description                                                                                                   | Impact            | Tags                                                                                  | Issue Type                 |
| :------------------------------------------------------------------------------------------------------------------------------- | :------------------------------------------------------------------------------------------------------------ | :---------------- | :------------------------------------------------------------------------------------ | :------------------------- |
| [area-alt](https://dequeuniversity.com/rules/axe/3.5/area-alt?application=RuleDescription)                                       | Ensures &lt;area&gt; elements of image maps have alternate text                                               | Critical          | cat.text-alternatives, wcag2a, wcag111, wcag244, wcag412, section508, section508.22.a | failure                    |
| [aria-allowed-attr](https://dequeuniversity.com/rules/axe/3.5/aria-allowed-attr?application=RuleDescription)                     | Ensures ARIA attributes are allowed for an element&apos;s role                                                | Critical          | cat.aria, wcag2a, wcag412                                                             | failure                    |
| [aria-hidden-body](https://dequeuniversity.com/rules/axe/3.5/aria-hidden-body?application=RuleDescription)                       | Ensures aria-hidden=&apos;true&apos; is not present on the document body.                                     | Critical          | cat.aria, wcag2a, wcag412                                                             | failure                    |
| [aria-hidden-focus](https://dequeuniversity.com/rules/axe/3.5/aria-hidden-focus?application=RuleDescription)                     | Ensures aria-hidden elements do not contain focusable elements                                                | Serious           | cat.name-role-value, wcag2a, wcag412, wcag131                                         | failure, needs&nbsp;review |
| [aria-input-field-name](https://dequeuniversity.com/rules/axe/3.5/aria-input-field-name?application=RuleDescription)             | Ensures every ARIA input field has an accessible name                                                         | Moderate, Serious | wcag2a, wcag412                                                                       | failure, needs&nbsp;review |
| [aria-required-attr](https://dequeuniversity.com/rules/axe/3.5/aria-required-attr?application=RuleDescription)                   | Ensures elements with ARIA roles have all required ARIA attributes                                            | Critical          | cat.aria, wcag2a, wcag412                                                             | failure                    |
| [aria-required-children](https://dequeuniversity.com/rules/axe/3.5/aria-required-children?application=RuleDescription)           | Ensures elements with an ARIA role that require child roles contain them                                      | Critical          | cat.aria, wcag2a, wcag131                                                             | failure, needs&nbsp;review |
| [aria-required-parent](https://dequeuniversity.com/rules/axe/3.5/aria-required-parent?application=RuleDescription)               | Ensures elements with an ARIA role that require parent roles are contained by them                            | Critical          | cat.aria, wcag2a, wcag131                                                             | failure                    |
| [aria-roledescription](https://dequeuniversity.com/rules/axe/3.5/aria-roledescription?application=RuleDescription)               | Ensure aria-roledescription is only used on elements with an implicit or explicit role                        | Serious           | cat.aria, wcag2a, wcag412                                                             | failure, needs&nbsp;review |
| [aria-roles](https://dequeuniversity.com/rules/axe/3.5/aria-roles?application=RuleDescription)                                   | Ensures all elements with a role attribute use a valid value                                                  | Serious, Critical | cat.aria, wcag2a, wcag412                                                             | failure                    |
| [aria-toggle-field-name](https://dequeuniversity.com/rules/axe/3.5/aria-toggle-field-name?application=RuleDescription)           | Ensures every ARIA toggle field has an accessible name                                                        | Moderate, Serious | wcag2a, wcag412                                                                       | failure, needs&nbsp;review |
| [aria-valid-attr-value](https://dequeuniversity.com/rules/axe/3.5/aria-valid-attr-value?application=RuleDescription)             | Ensures all ARIA attributes have valid values                                                                 | Critical          | cat.aria, wcag2a, wcag412                                                             | failure, needs&nbsp;review |
| [aria-valid-attr](https://dequeuniversity.com/rules/axe/3.5/aria-valid-attr?application=RuleDescription)                         | Ensures attributes that begin with aria- are valid ARIA attributes                                            | Critical          | cat.aria, wcag2a, wcag412                                                             | failure                    |
| [audio-caption](https://dequeuniversity.com/rules/axe/3.5/audio-caption?application=RuleDescription)                             | Ensures &lt;audio&gt; elements have captions                                                                  | Critical          | cat.time-and-media, wcag2a, wcag121, section508, section508.22.a                      | needs&nbsp;review          |
| [blink](https://dequeuniversity.com/rules/axe/3.5/blink?application=RuleDescription)                                             | Ensures &lt;blink&gt; elements are not used                                                                   | Serious           | cat.time-and-media, wcag2a, wcag222, section508, section508.22.j                      | failure                    |
| [button-name](https://dequeuniversity.com/rules/axe/3.5/button-name?application=RuleDescription)                                 | Ensures buttons have discernible text                                                                         | Critical          | cat.name-role-value, wcag2a, wcag412, section508, section508.22.a                     | failure                    |
| [bypass](https://dequeuniversity.com/rules/axe/3.5/bypass?application=RuleDescription)                                           | Ensures each page has at least one mechanism for a user to bypass navigation and jump straight to the content | Serious           | cat.keyboard, wcag2a, wcag241, section508, section508.22.o                            | failure                    |
| [color-contrast](https://dequeuniversity.com/rules/axe/3.5/color-contrast?application=RuleDescription)                           | Ensures the contrast between foreground and background colors meets WCAG 2 AA contrast ratio thresholds       | Serious           | cat.color, wcag2aa, wcag143                                                           | failure, needs&nbsp;review |
| [definition-list](https://dequeuniversity.com/rules/axe/3.5/definition-list?application=RuleDescription)                         | Ensures &lt;dl&gt; elements are structured correctly                                                          | Serious           | cat.structure, wcag2a, wcag131                                                        | failure                    |
| [dlitem](https://dequeuniversity.com/rules/axe/3.5/dlitem?application=RuleDescription)                                           | Ensures &lt;dt&gt; and &lt;dd&gt; elements are contained by a &lt;dl&gt;                                      | Serious           | cat.structure, wcag2a, wcag131                                                        | failure                    |
| [document-title](https://dequeuniversity.com/rules/axe/3.5/document-title?application=RuleDescription)                           | Ensures each HTML document contains a non-empty &lt;title&gt; element                                         | Serious           | cat.text-alternatives, wcag2a, wcag242                                                | failure                    |
| [duplicate-id-active](https://dequeuniversity.com/rules/axe/3.5/duplicate-id-active?application=RuleDescription)                 | Ensures every id attribute value of active elements is unique                                                 | Serious           | cat.parsing, wcag2a, wcag411                                                          | failure                    |
| [duplicate-id-aria](https://dequeuniversity.com/rules/axe/3.5/duplicate-id-aria?application=RuleDescription)                     | Ensures every id attribute value used in ARIA and in labels is unique                                         | Critical          | cat.parsing, wcag2a, wcag411                                                          | failure                    |
| [duplicate-id](https://dequeuniversity.com/rules/axe/3.5/duplicate-id?application=RuleDescription)                               | Ensures every id attribute value is unique                                                                    | Minor             | cat.parsing, wcag2a, wcag411                                                          | failure                    |
| [form-field-multiple-labels](https://dequeuniversity.com/rules/axe/3.5/form-field-multiple-labels?application=RuleDescription)   | Ensures form field does not have multiple label elements                                                      | Moderate          | cat.forms, wcag2a, wcag332                                                            | needs&nbsp;review          |
| [frame-title](https://dequeuniversity.com/rules/axe/3.5/frame-title?application=RuleDescription)                                 | Ensures &lt;iframe&gt; and &lt;frame&gt; elements contain a non-empty title attribute                         | Serious           | cat.text-alternatives, wcag2a, wcag241, wcag412, section508, section508.22.i          | failure                    |
| [html-has-lang](https://dequeuniversity.com/rules/axe/3.5/html-has-lang?application=RuleDescription)                             | Ensures every HTML document has a lang attribute                                                              | Serious           | cat.language, wcag2a, wcag311                                                         | failure                    |
| [html-lang-valid](https://dequeuniversity.com/rules/axe/3.5/html-lang-valid?application=RuleDescription)                         | Ensures the lang attribute of the &lt;html&gt; element has a valid value                                      | Serious           | cat.language, wcag2a, wcag311                                                         | failure                    |
| [html-xml-lang-mismatch](https://dequeuniversity.com/rules/axe/3.5/html-xml-lang-mismatch?application=RuleDescription)           | Ensure that HTML elements with both valid lang and xml:lang attributes agree on the base language of the page | Moderate          | cat.language, wcag2a, wcag311                                                         | failure                    |
| [image-alt](https://dequeuniversity.com/rules/axe/3.5/image-alt?application=RuleDescription)                                     | Ensures &lt;img&gt; elements have alternate text or a role of none or presentation                            | Critical          | cat.text-alternatives, wcag2a, wcag111, section508, section508.22.a                   | failure                    |
| [input-button-name](https://dequeuniversity.com/rules/axe/3.5/input-button-name?application=RuleDescription)                     | Ensures input buttons have discernible text                                                                   | Critical          | cat.name-role-value, wcag2a, wcag412, section508, section508.22.a                     | failure                    |
| [input-image-alt](https://dequeuniversity.com/rules/axe/3.5/input-image-alt?application=RuleDescription)                         | Ensures &lt;input type=&quot;image&quot;&gt; elements have alternate text                                     | Critical          | cat.text-alternatives, wcag2a, wcag111, section508, section508.22.a                   | failure                    |
| [label](https://dequeuniversity.com/rules/axe/3.5/label?application=RuleDescription)                                             | Ensures every form element has a label                                                                        | Minor, Critical   | cat.forms, wcag2a, wcag412, wcag131, section508, section508.22.n                      | failure                    |
| [link-name](https://dequeuniversity.com/rules/axe/3.5/link-name?application=RuleDescription)                                     | Ensures links have discernible text                                                                           | Serious           | cat.name-role-value, wcag2a, wcag412, wcag244, section508, section508.22.a            | failure                    |
| [list](https://dequeuniversity.com/rules/axe/3.5/list?application=RuleDescription)                                               | Ensures that lists are structured correctly                                                                   | Serious           | cat.structure, wcag2a, wcag131                                                        | failure                    |
| [listitem](https://dequeuniversity.com/rules/axe/3.5/listitem?application=RuleDescription)                                       | Ensures &lt;li&gt; elements are used semantically                                                             | Serious           | cat.structure, wcag2a, wcag131                                                        | failure                    |
| [marquee](https://dequeuniversity.com/rules/axe/3.5/marquee?application=RuleDescription)                                         | Ensures &lt;marquee&gt; elements are not used                                                                 | Serious           | cat.parsing, wcag2a, wcag222                                                          | failure                    |
| [meta-refresh](https://dequeuniversity.com/rules/axe/3.5/meta-refresh?application=RuleDescription)                               | Ensures &lt;meta http-equiv=&quot;refresh&quot;&gt; is not used                                               | Critical          | cat.time-and-media, wcag2a, wcag2aaa, wcag221, wcag224, wcag325                       | failure                    |
| [object-alt](https://dequeuniversity.com/rules/axe/3.5/object-alt?application=RuleDescription)                                   | Ensures &lt;object&gt; elements have alternate text                                                           | Serious           | cat.text-alternatives, wcag2a, wcag111, section508, section508.22.a                   | failure                    |
| [role-img-alt](https://dequeuniversity.com/rules/axe/3.5/role-img-alt?application=RuleDescription)                               | Ensures [role=&apos;img&apos;] elements have alternate text                                                   | Serious           | cat.text-alternatives, wcag2a, wcag111, section508, section508.22.a                   | failure                    |
| [scrollable-region-focusable](https://dequeuniversity.com/rules/axe/3.5/scrollable-region-focusable?application=RuleDescription) | Elements that have scrollable content should be accessible by keyboard                                        | Moderate          | wcag2a, wcag211                                                                       | failure                    |
| [server-side-image-map](https://dequeuniversity.com/rules/axe/3.5/server-side-image-map?application=RuleDescription)             | Ensures that server-side image maps are not used                                                              | Minor             | cat.text-alternatives, wcag2a, wcag211, section508, section508.22.f                   | needs&nbsp;review          |
| [svg-img-alt](https://dequeuniversity.com/rules/axe/3.5/svg-img-alt?application=RuleDescription)                                 | Ensures svg elements with an img, graphics-document or graphics-symbol role have an accessible text           | Serious           | cat.text-alternatives, wcag2a, wcag111, section508, section508.22.a                   | failure                    |
| [td-headers-attr](https://dequeuniversity.com/rules/axe/3.5/td-headers-attr?application=RuleDescription)                         | Ensure that each cell in a table using the headers refers to another cell in that table                       | Serious           | cat.tables, wcag2a, wcag131, section508, section508.22.g                              | failure, needs&nbsp;review |
| [th-has-data-cells](https://dequeuniversity.com/rules/axe/3.5/th-has-data-cells?application=RuleDescription)                     | Ensure that each table header in a data table refers to data cells                                            | Serious           | cat.tables, wcag2a, wcag131, section508, section508.22.g                              | failure, needs&nbsp;review |
| [valid-lang](https://dequeuniversity.com/rules/axe/3.5/valid-lang?application=RuleDescription)                                   | Ensures lang attributes have valid values                                                                     | Serious           | cat.language, wcag2aa, wcag312                                                        | failure                    |
| [video-caption](https://dequeuniversity.com/rules/axe/3.5/video-caption?application=RuleDescription)                             | Ensures &lt;video&gt; elements have captions                                                                  | Critical          | cat.text-alternatives, wcag2a, wcag122, section508, section508.22.a                   | needs&nbsp;review          |

## WCAG 2.1 Level A & AA Rules

| Rule ID                                                                                                            | Description                                                                                   | Impact  | Tags                         | Issue Type |
| :----------------------------------------------------------------------------------------------------------------- | :-------------------------------------------------------------------------------------------- | :------ | :--------------------------- | :--------- |
| [autocomplete-valid](https://dequeuniversity.com/rules/axe/3.5/autocomplete-valid?application=RuleDescription)     | Ensure the autocomplete attribute is correct and suitable for the form field                  | Serious | cat.forms, wcag21aa, wcag135 | failure    |
| [avoid-inline-spacing](https://dequeuniversity.com/rules/axe/3.5/avoid-inline-spacing?application=RuleDescription) | Ensure that text spacing set through style attributes can be adjusted with custom stylesheets | Serious | wcag21aa, wcag1412           | failure    |

## Best Practices Rules

Rules that do not necessarily conform to WCAG success criterion but are industry accepted practices that improve the user experience.

| Rule ID                                                                                                                                          | Description                                                                                          | Impact             | Tags                                       | Issue Type                 |
| :----------------------------------------------------------------------------------------------------------------------------------------------- | :--------------------------------------------------------------------------------------------------- | :----------------- | :----------------------------------------- | :------------------------- |
| [accesskeys](https://dequeuniversity.com/rules/axe/3.5/accesskeys?application=RuleDescription)                                                   | Ensures every accesskey attribute value is unique                                                    | Serious            | best-practice, cat.keyboard                | failure                    |
| [aria-allowed-role](https://dequeuniversity.com/rules/axe/3.5/aria-allowed-role?application=RuleDescription)                                     | Ensures role attribute has an appropriate value for the element                                      | Minor              | cat.aria, best-practice                    | failure, needs&nbsp;review |
| [empty-heading](https://dequeuniversity.com/rules/axe/3.5/empty-heading?application=RuleDescription)                                             | Ensures headings have discernible text                                                               | Minor              | cat.name-role-value, best-practice         | failure                    |
| [frame-tested](https://dequeuniversity.com/rules/axe/3.5/frame-tested?application=RuleDescription)                                               | Ensures &lt;iframe&gt; and &lt;frame&gt; elements contain the axe-core script                        | Critical           | cat.structure, review-item, best-practice  | failure, needs&nbsp;review |
| [frame-title-unique](https://dequeuniversity.com/rules/axe/3.5/frame-title-unique?application=RuleDescription)                                   | Ensures &lt;iframe&gt; and &lt;frame&gt; elements contain a unique title attribute                   | Serious            | cat.text-alternatives, best-practice       | failure                    |
| [heading-order](https://dequeuniversity.com/rules/axe/3.5/heading-order?application=RuleDescription)                                             | Ensures the order of headings is semantically correct                                                | Moderate           | cat.semantics, best-practice               | failure                    |
| [identical-links-same-purpose](https://dequeuniversity.com/rules/axe/3.5/identical-links-same-purpose?application=RuleDescription)               | Ensure that links with the same accessible name serve a similar purpose                              | Minor              | wcag2aaa, wcag249, best-practice           | needs&nbsp;review          |
| [image-redundant-alt](https://dequeuniversity.com/rules/axe/3.5/image-redundant-alt?application=RuleDescription)                                 | Ensure image alternative is not repeated as text                                                     | Minor              | cat.text-alternatives, best-practice       | failure                    |
| [label-title-only](https://dequeuniversity.com/rules/axe/3.5/label-title-only?application=RuleDescription)                                       | Ensures that every form element is not solely labeled using the title or aria-describedby attributes | Serious            | cat.forms, best-practice                   | failure                    |
| [landmark-banner-is-top-level](https://dequeuniversity.com/rules/axe/3.5/landmark-banner-is-top-level?application=RuleDescription)               | Ensures the banner landmark is at top level                                                          | Moderate           | cat.semantics, best-practice               | failure                    |
| [landmark-complementary-is-top-level](https://dequeuniversity.com/rules/axe/3.5/landmark-complementary-is-top-level?application=RuleDescription) | Ensures the complementary landmark or aside is at top level                                          | Moderate           | cat.semantics, best-practice               | failure                    |
| [landmark-contentinfo-is-top-level](https://dequeuniversity.com/rules/axe/3.5/landmark-contentinfo-is-top-level?application=RuleDescription)     | Ensures the contentinfo landmark is at top level                                                     | Moderate           | cat.semantics, best-practice               | failure                    |
| [landmark-main-is-top-level](https://dequeuniversity.com/rules/axe/3.5/landmark-main-is-top-level?application=RuleDescription)                   | Ensures the main landmark is at top level                                                            | Moderate           | cat.semantics, best-practice               | failure                    |
| [landmark-no-duplicate-banner](https://dequeuniversity.com/rules/axe/3.5/landmark-no-duplicate-banner?application=RuleDescription)               | Ensures the document has at most one banner landmark                                                 | Moderate           | cat.semantics, best-practice               | failure                    |
| [landmark-no-duplicate-contentinfo](https://dequeuniversity.com/rules/axe/3.5/landmark-no-duplicate-contentinfo?application=RuleDescription)     | Ensures the document has at most one contentinfo landmark                                            | Moderate           | cat.semantics, best-practice               | failure                    |
| [landmark-no-duplicate-main](https://dequeuniversity.com/rules/axe/3.5/landmark-no-duplicate-main?application=RuleDescription)                   | Ensures the document has at most one main landmark                                                   | Moderate           | cat.semantics, best-practice               | failure                    |
| [landmark-one-main](https://dequeuniversity.com/rules/axe/3.5/landmark-one-main?application=RuleDescription)                                     | Ensures the document has a main landmark                                                             | Moderate           | cat.semantics, best-practice               | failure                    |
| [landmark-unique](https://dequeuniversity.com/rules/axe/3.5/landmark-unique?application=RuleDescription)                                         | Landmarks must have a unique role or role/label/title (i.e. accessible name) combination             | Moderate           | cat.semantics, best-practice               | failure                    |
| [meta-viewport-large](https://dequeuniversity.com/rules/axe/3.5/meta-viewport-large?application=RuleDescription)                                 | Ensures &lt;meta name=&quot;viewport&quot;&gt; can scale a significant amount                        | Minor              | cat.sensory-and-visual-cues, best-practice | failure                    |
| [meta-viewport](https://dequeuniversity.com/rules/axe/3.5/meta-viewport?application=RuleDescription)                                             | Ensures &lt;meta name=&quot;viewport&quot;&gt; does not disable text scaling and zooming             | Critical           | cat.sensory-and-visual-cues, best-practice | failure                    |
| [page-has-heading-one](https://dequeuniversity.com/rules/axe/3.5/page-has-heading-one?application=RuleDescription)                               | Ensure that the page, or at least one of its frames contains a level-one heading                     | Moderate           | cat.semantics, best-practice               | failure                    |
| [region](https://dequeuniversity.com/rules/axe/3.5/region?application=RuleDescription)                                                           | Ensures all page content is contained by landmarks                                                   | Moderate           | cat.keyboard, best-practice                | failure                    |
| [scope-attr-valid](https://dequeuniversity.com/rules/axe/3.5/scope-attr-valid?application=RuleDescription)                                       | Ensures the scope attribute is used correctly on tables                                              | Moderate, Critical | cat.tables, best-practice                  | failure                    |
| [skip-link](https://dequeuniversity.com/rules/axe/3.5/skip-link?application=RuleDescription)                                                     | Ensure all skip links have a focusable target                                                        | Moderate           | cat.keyboard, best-practice                | failure, needs&nbsp;review |
| [tabindex](https://dequeuniversity.com/rules/axe/3.5/tabindex?application=RuleDescription)                                                       | Ensures tabindex attribute values are not greater than 0                                             | Serious            | cat.keyboard, best-practice                | failure                    |
| [table-duplicate-name](https://dequeuniversity.com/rules/axe/3.5/table-duplicate-name?application=RuleDescription)                               | Ensure that tables do not have the same summary and caption                                          | Minor              | cat.tables, best-practice                  | failure                    |

## Experimental Rules

Rules we are still testing and developing. They are not enabled by default in axe-core, but are enabled for the axe browser extensions.

| Rule ID                                                                                                                          | Description                                                                                                                                         | Impact   | Tags                                                                   | Issue Type                 |
| :------------------------------------------------------------------------------------------------------------------------------- | :-------------------------------------------------------------------------------------------------------------------------------------------------- | :------- | :--------------------------------------------------------------------- | :------------------------- |
| [css-orientation-lock](https://dequeuniversity.com/rules/axe/3.5/css-orientation-lock?application=RuleDescription)               | Ensures content is not locked to any specific display orientation, and the content is operable in all display orientations                          | Serious  | cat.structure, wcag134, wcag21aa, experimental                         | failure, needs&nbsp;review |
| [focus-order-semantics](https://dequeuniversity.com/rules/axe/3.5/focus-order-semantics?application=RuleDescription)             | Ensures elements in the focus order have an appropriate role                                                                                        | Minor    | cat.keyboard, best-practice, experimental                              | failure                    |
| [hidden-content](https://dequeuniversity.com/rules/axe/3.5/hidden-content?application=RuleDescription)                           | Informs users about hidden content.                                                                                                                 | Minor    | cat.structure, experimental, review-item, best-practice                | failure, needs&nbsp;review |
| [label-content-name-mismatch](https://dequeuniversity.com/rules/axe/3.5/label-content-name-mismatch?application=RuleDescription) | Ensures that elements labelled through their content must have their visible text as part of their accessible name                                  | Serious  | wcag21a, wcag253, experimental                                         | failure                    |
| [link-in-text-block](https://dequeuniversity.com/rules/axe/3.5/link-in-text-block?application=RuleDescription)                   | Links can be distinguished without relying on color                                                                                                 | Serious  | cat.color, experimental, wcag2a, wcag141                               | failure, needs&nbsp;review |
| [no-autoplay-audio](https://dequeuniversity.com/rules/axe/3.5/no-autoplay-audio?application=RuleDescription)                     | Ensures &lt;video&gt; or &lt;audio&gt; elements do not autoplay audio for more than 3 seconds without a control mechanism to stop or mute the audio | Moderate | wcag2a, wcag142, experimental                                          | failure, needs&nbsp;review |
| [p-as-heading](https://dequeuniversity.com/rules/axe/3.5/p-as-heading?application=RuleDescription)                               | Ensure p elements are not used to style headings                                                                                                    | Serious  | cat.semantics, wcag2a, wcag131, experimental                           | failure                    |
| [table-fake-caption](https://dequeuniversity.com/rules/axe/3.5/table-fake-caption?application=RuleDescription)                   | Ensure that tables with a caption use the &lt;caption&gt; element.                                                                                  | Serious  | cat.tables, experimental, wcag2a, wcag131, section508, section508.22.g | failure                    |
| [td-has-header](https://dequeuniversity.com/rules/axe/3.5/td-has-header?application=RuleDescription)                             | Ensure that each non-empty data cell in a large table has one or more table headers                                                                 | Critical | cat.tables, experimental, wcag2a, wcag131, section508, section508.22.g | failure                    |

## Deprecated Rules

Deprecated rules are not enabled by default and will be removed in the next major release.

| Rule ID                                                                                                                  | Description                                                                                                                | Impact   | Tags                                                                             | Issue Type        |
| :----------------------------------------------------------------------------------------------------------------------- | :------------------------------------------------------------------------------------------------------------------------- | :------- | :------------------------------------------------------------------------------- | :---------------- |
| [aria-dpub-role-fallback](https://dequeuniversity.com/rules/axe/3.5/aria-dpub-role-fallback?application=RuleDescription) | Ensures unsupported DPUB roles are only used on elements with implicit fallback roles                                      | Moderate | cat.aria, wcag2a, wcag131, deprecated                                            | failure           |
| [checkboxgroup](https://dequeuniversity.com/rules/axe/3.5/checkboxgroup?application=RuleDescription)                     | Ensures related &lt;input type=&quot;checkbox&quot;&gt; elements have a group and that the group designation is consistent | Critical | cat.forms, best-practice, deprecated                                             | failure           |
| [layout-table](https://dequeuniversity.com/rules/axe/3.5/layout-table?application=RuleDescription)                       | Ensures presentational &lt;table&gt; elements do not use &lt;th&gt;, &lt;caption&gt; elements or the summary attribute     | Serious  | cat.semantics, wcag2a, wcag131, deprecated                                       | failure           |
| [radiogroup](https://dequeuniversity.com/rules/axe/3.5/radiogroup?application=RuleDescription)                           | Ensures related &lt;input type=&quot;radio&quot;&gt; elements have a group and that the group designation is consistent    | Critical | cat.forms, best-practice, deprecated                                             | failure           |
| [video-description](https://dequeuniversity.com/rules/axe/3.5/video-description?application=RuleDescription)             | Ensures &lt;video&gt; elements have audio descriptions                                                                     | Critical | cat.text-alternatives, wcag2aa, wcag125, section508, section508.22.b, deprecated | needs&nbsp;review |
