define(["require", "exports", "vscode-languageclient/lib/client", "vscode-languageclient/lib/typeDefinition", "vscode-languageclient/lib/configuration", "vscode-languageclient/lib/implementation", "vscode-languageclient/lib/colorProvider", "vscode-languageclient/lib/workspaceFolders", "vscode-languageclient/lib/foldingRange", "vscode-languageclient/lib/declaration", "vscode-languageclient/lib/client"], function (require, exports, client_1, typeDefinition_1, configuration_1, implementation_1, colorProvider_1, workspaceFolders_1, foldingRange_1, declaration_1, client_2) {
    "use strict";
    function __export(m) {
        for (var p in m) if (!exports.hasOwnProperty(p)) exports[p] = m[p];
    }
    Object.defineProperty(exports, "__esModule", { value: true });
    __export(client_2);
    class MonacoLanguageClient extends client_1.BaseLanguageClient {
        constructor({ id, name, clientOptions, connectionProvider }) {
            super(id || name.toLowerCase(), name, clientOptions);
            this.connectionProvider = connectionProvider;
            this.createConnection = this.doCreateConnection.bind(this);
            // bypass LSP <=> VS Code conversion
            const self = this;
            self._p2c = new Proxy(self._p2c, {
                get: (target, prop) => {
                    if (prop === 'asUri') {
                        return target[prop];
                    }
                    return MonacoLanguageClient.bypassConversion;
                }
            });
            self._c2p = new Proxy(self._c2p, {
                get: (target, prop) => {
                    if (prop === 'asUri') {
                        return target[prop];
                    }
                    if (prop === 'asCompletionParams') {
                        return (textDocument, position, context) => {
                            return {
                                textDocument: target.asTextDocumentIdentifier(textDocument),
                                position,
                                context
                            };
                        };
                    }
                    if (prop === 'asWillSaveTextDocumentParams') {
                        return (event) => {
                            return {
                                textDocument: target.asTextDocumentIdentifier(event.document),
                                reason: event.reason
                            };
                        };
                    }
                    if (prop.endsWith('Params')) {
                        return target[prop];
                    }
                    return MonacoLanguageClient.bypassConversion;
                }
            });
        }
        doCreateConnection() {
            const errorHandler = this.handleConnectionError.bind(this);
            const closeHandler = this.handleConnectionClosed.bind(this);
            return this.connectionProvider.get(errorHandler, closeHandler, this.outputChannel);
        }
        createMessageTransports(encoding) {
            throw new Error('Unsupported');
        }
        registerBuiltinFeatures() {
            super.registerBuiltinFeatures();
            this.registerFeature(new configuration_1.ConfigurationFeature(this));
            this.registerFeature(new typeDefinition_1.TypeDefinitionFeature(this));
            this.registerFeature(new implementation_1.ImplementationFeature(this));
            this.registerFeature(new colorProvider_1.ColorProviderFeature(this));
            this.registerFeature(new workspaceFolders_1.WorkspaceFoldersFeature(this));
            const foldingRangeFeature = new foldingRange_1.FoldingRangeFeature(this);
            foldingRangeFeature['asFoldingRanges'] = MonacoLanguageClient.bypassConversion;
            this.registerFeature(foldingRangeFeature);
            this.registerFeature(new declaration_1.DeclarationFeature(this));
            const features = this['_features'];
            for (const feature of features) {
                if (feature instanceof colorProvider_1.ColorProviderFeature) {
                    feature['asColor'] = MonacoLanguageClient.bypassConversion;
                    feature['asColorInformations'] = MonacoLanguageClient.bypassConversion;
                    feature['asColorPresentations'] = MonacoLanguageClient.bypassConversion;
                }
            }
        }
    }
    exports.MonacoLanguageClient = MonacoLanguageClient;
    MonacoLanguageClient.bypassConversion = (result) => result || undefined;
});
//# sourceMappingURL=monaco-language-client.js.map