/* --------------------------------------------------------------------------------------------
 * Copyright (c) 2018 TypeFox GmbH (http://www.typefox.io). All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for license information.
 * ------------------------------------------------------------------------------------------ */
'use strict';
Object.defineProperty(exports, "__esModule", { value: true });
const main_1 = require("vscode-languageserver-protocol/lib/main");
const Is = require("vscode-languageserver-protocol/lib/utils/is");
function createConnection(connection, errorHandler, closeHandler) {
    connection.onError((data) => { errorHandler(data[0], data[1], data[2]); });
    connection.onClose(closeHandler);
    return {
        listen: () => connection.listen(),
        sendRequest: (type, ...params) => connection.sendRequest(Is.string(type) ? type : type.method, ...params),
        onRequest: (type, handler) => connection.onRequest(Is.string(type) ? type : type.method, handler),
        sendNotification: (type, params) => connection.sendNotification(Is.string(type) ? type : type.method, params),
        onNotification: (type, handler) => connection.onNotification(Is.string(type) ? type : type.method, handler),
        trace: (value, tracer, sendNotification = false) => connection.trace(value, tracer, sendNotification),
        initialize: (params) => connection.sendRequest(main_1.InitializeRequest.type, params),
        shutdown: () => connection.sendRequest(main_1.ShutdownRequest.type, undefined),
        exit: () => connection.sendNotification(main_1.ExitNotification.type),
        onLogMessage: (handler) => connection.onNotification(main_1.LogMessageNotification.type, handler),
        onShowMessage: (handler) => connection.onNotification(main_1.ShowMessageNotification.type, handler),
        onTelemetry: (handler) => connection.onNotification(main_1.TelemetryEventNotification.type, handler),
        didChangeConfiguration: (params) => connection.sendNotification(main_1.DidChangeConfigurationNotification.type, params),
        didChangeWatchedFiles: (params) => connection.sendNotification(main_1.DidChangeWatchedFilesNotification.type, params),
        didOpenTextDocument: (params) => connection.sendNotification(main_1.DidOpenTextDocumentNotification.type, params),
        didChangeTextDocument: (params) => connection.sendNotification(main_1.DidChangeTextDocumentNotification.type, params),
        didCloseTextDocument: (params) => connection.sendNotification(main_1.DidCloseTextDocumentNotification.type, params),
        didSaveTextDocument: (params) => connection.sendNotification(main_1.DidSaveTextDocumentNotification.type, params),
        onDiagnostics: (handler) => connection.onNotification(main_1.PublishDiagnosticsNotification.type, handler),
        dispose: () => connection.dispose()
    };
}
exports.createConnection = createConnection;
//# sourceMappingURL=connection.js.map