/// <reference types="monaco-editor-core/monaco" />
import { MonacoToProtocolConverter, ProtocolToMonacoConverter } from './monaco-converter';
import { Workspace, WorkspaceEdit, TextDocumentDidChangeEvent, TextDocument, Event, Emitter } from './services';
import IModel = monaco.editor.IModel;
export declare class MonacoWorkspace implements Workspace {
    protected readonly p2m: ProtocolToMonacoConverter;
    protected readonly m2p: MonacoToProtocolConverter;
    protected _rootUri: string | null;
    protected readonly documents: Map<string, TextDocument>;
    protected readonly onDidOpenTextDocumentEmitter: Emitter<TextDocument>;
    protected readonly onDidCloseTextDocumentEmitter: Emitter<TextDocument>;
    protected readonly onDidChangeTextDocumentEmitter: Emitter<TextDocumentDidChangeEvent>;
    constructor(p2m: ProtocolToMonacoConverter, m2p: MonacoToProtocolConverter, _rootUri?: string | null);
    get rootUri(): string | null;
    protected removeModel(model: IModel): void;
    protected addModel(model: IModel): void;
    protected onDidChangeContent(uri: string, model: IModel, event: monaco.editor.IModelContentChangedEvent): void;
    protected setModel(uri: string, model: IModel): TextDocument;
    get textDocuments(): TextDocument[];
    get onDidOpenTextDocument(): Event<TextDocument>;
    get onDidCloseTextDocument(): Event<TextDocument>;
    get onDidChangeTextDocument(): Event<TextDocumentDidChangeEvent>;
    applyEdit(workspaceEdit: WorkspaceEdit): Promise<boolean>;
}
//# sourceMappingURL=monaco-workspace.d.ts.map