"use strict";

var _react = _interopRequireDefault(require("react"));

var _Copy = _interopRequireDefault(require("../Copy"));

var _enzyme = require("enzyme");

var _carbonComponents = require("carbon-components");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
var prefix = _carbonComponents.settings.prefix;
jest.useFakeTimers();
describe('Copy', function () {
  describe('Renders common props as expected', function () {
    var wrapper = (0, _enzyme.shallow)( // eslint-disable-next-line jsx-a11y/tabindex-no-positive
    _react.default.createElement(_Copy.default, {
      tabIndex: 2,
      className: "extra-class"
    }));
    it('Should set tabIndex if one is passed via props', function () {
      expect(wrapper.props().tabIndex).toEqual(2);
    });
    it('Should add extra classes via className', function () {
      expect(wrapper.hasClass('extra-class')).toBe(true);
    });
  });
  describe('Renders button props as expected', function () {
    var wrapper = (0, _enzyme.shallow)(_react.default.createElement(_Copy.default, null));
    it('Should be able to disable the button', function () {
      wrapper.setProps({
        disabled: true
      });
      expect(wrapper.props().disabled).toBe(true);
      wrapper.setProps({
        disabled: false
      });
    });
    it('Should have a default feedback timeout', function () {
      var timeoutWrapper = (0, _enzyme.mount)(_react.default.createElement(_Copy.default, null));
      expect(timeoutWrapper.props().feedbackTimeout).toBe(2000);
    });
    it('Should be able to set the timeout for displaying feedback', function () {
      var timeoutWrapper = (0, _enzyme.mount)(_react.default.createElement(_Copy.default, {
        feedbackTimeout: 5000
      }));
      expect(timeoutWrapper.props().feedbackTimeout).toBe(5000);
    });
    it('Should be able to specify the feedback message', function () {
      var feedbackWrapper = (0, _enzyme.mount)(_react.default.createElement(_Copy.default, {
        feedback: "Copied!"
      }));
      expect(feedbackWrapper.find(".".concat(prefix, "--copy-btn__feedback")).text()).toBe('Copied!');
    });
  });
  describe('Renders feedback as expected', function () {
    it('Should make the feedback visible', function () {
      var feedbackWrapper = (0, _enzyme.mount)(_react.default.createElement(_Copy.default, {
        feedback: "Copied!"
      }));
      var feedback = feedbackWrapper.find(".".concat(prefix, "--copy-btn__feedback"));
      expect(feedback).toBeFalsy;
      feedbackWrapper.simulate('click');
      expect(feedback).toBeTruthy;
    });
    it('Should show feedback for a limited amount of time', function () {
      var feedbackWrapper = (0, _enzyme.mount)(_react.default.createElement(_Copy.default, {
        feedback: "Copied!",
        feedbackTimeout: 5000
      }));
      feedbackWrapper.simulate('click');
      var copyButton = feedbackWrapper.find('button');
      expect(copyButton.hasClass("".concat(prefix, "--copy-btn--animating"))).toBe(true);
      setTimeout(function () {
        expect(copyButton.hasClass("".concat(prefix, "--copy-btn--animating"))).toBe(false);
      }, 5220); // 5000 + 2 * 110 (transition duration)
    });
  });
  describe('Triggers appropriate events', function () {
    it('should call the click handler', function () {
      var onClick = jest.fn();
      var clickWrapper = (0, _enzyme.mount)(_react.default.createElement(_Copy.default, {
        onClick: onClick
      }));
      clickWrapper.simulate('click');
      expect(onClick).toBeCalled();
    });
  });
});