"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.batchActionClick = exports.headers = exports.initialRows = void 0;

var _addonActions = require("@storybook/addon-actions");

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
var initialRows = [{
  id: 'a',
  name: 'Load Balancer 3',
  protocol: 'HTTP',
  port: 3000,
  rule: 'Round robin',
  attached_groups: 'Kevins VM Groups',
  status: 'Disabled'
}, {
  id: 'b',
  name: 'Load Balancer 1',
  protocol: 'HTTP',
  port: 443,
  rule: 'Round robin',
  attached_groups: 'Maureens VM Groups',
  status: 'Starting'
}, {
  id: 'c',
  name: 'Load Balancer 2',
  protocol: 'HTTP',
  port: 80,
  rule: 'DNS delegation',
  attached_groups: 'Andrews VM Groups',
  status: 'Active'
}, {
  id: 'd',
  name: 'Load Balancer 6',
  protocol: 'HTTP',
  port: 3000,
  rule: 'Round robin',
  attached_groups: 'Marcs VM Groups',
  status: 'Disabled'
}, {
  id: 'e',
  name: 'Load Balancer 4',
  protocol: 'HTTP',
  port: 443,
  rule: 'Round robin',
  attached_groups: 'Mels VM Groups',
  status: 'Starting'
}, {
  id: 'f',
  name: 'Load Balancer 5',
  protocol: 'HTTP',
  port: 80,
  rule: 'DNS delegation',
  attached_groups: 'Ronjas VM Groups',
  status: 'Active'
}];
exports.initialRows = initialRows;
var headers = [{
  key: 'name',
  header: 'Name'
}, {
  key: 'protocol',
  header: 'Protocol'
}, {
  key: 'port',
  header: 'Port'
}, {
  key: 'rule',
  header: 'Rule'
}, {
  key: 'attached_groups',
  header: 'Attached Groups'
}, {
  key: 'status',
  header: 'Status'
}];
exports.headers = headers;

var batchActionClick = function batchActionClick(selectedRows) {
  return function () {
    return (0, _addonActions.action)('batch action click')(selectedRows);
  };
};

exports.batchActionClick = batchActionClick;