function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance"); }

function _iterableToArrayLimit(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React, { useState } from 'react';
import { storiesOf } from '@storybook/react';
import { action } from '@storybook/addon-actions';
import { ErrorBoundary, ErrorBoundaryContext } from './';
import Button from '../Button';
storiesOf('ErrorBoundary', module).add('default', function () {
  function DemoComponent() {
    var _useState = useState(false),
        _useState2 = _slicedToArray(_useState, 2),
        shouldThrowError = _useState2[0],
        setShouldThrowError = _useState2[1];

    function onClick() {
      setShouldThrowError(!shouldThrowError);
    }

    return React.createElement(React.Fragment, null, React.createElement(Button, {
      onClick: onClick
    }, "Toggle throwing error"), React.createElement("div", null, React.createElement(ErrorBoundary, {
      fallback: React.createElement(Fallback, null)
    }, React.createElement(ThrowError, {
      shouldThrowError: shouldThrowError
    }))));
  }

  function Fallback() {
    return 'Whoops';
  }

  function ThrowError(_ref) {
    var shouldThrowError = _ref.shouldThrowError;

    if (shouldThrowError) {
      throw new Error('Component threw error');
    }

    return 'Successfully rendered';
  }

  return React.createElement(DemoComponent, null);
}).add('with custom context', function () {
  function DemoComponent() {
    var _useState3 = useState(false),
        _useState4 = _slicedToArray(_useState3, 2),
        shouldThrowError = _useState4[0],
        setShouldThrowError = _useState4[1];

    function onClick() {
      setShouldThrowError(!shouldThrowError);
    }

    return React.createElement(ErrorBoundaryContext.Provider, {
      value: {
        log: action('log')
      }
    }, React.createElement(Button, {
      onClick: onClick
    }, "Toggle throwing error"), React.createElement("div", null, React.createElement(ErrorBoundary, {
      fallback: React.createElement(Fallback, null)
    }, React.createElement(ThrowError, {
      shouldThrowError: shouldThrowError
    }))));
  }

  function Fallback() {
    return 'Whoops';
  }

  function ThrowError(_ref2) {
    var shouldThrowError = _ref2.shouldThrowError;

    if (shouldThrowError) {
      throw new Error('Component threw error');
    }

    return 'Successfully rendered';
  }

  return React.createElement(DemoComponent, null);
});