"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/* --------------------------------------------------------------------------------------------
 * Copyright (c) 2018 TypeFox GmbH (http://www.typefox.io). All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for license information.
 * ------------------------------------------------------------------------------------------ */
const monaco_converter_1 = require("./monaco-converter");
const monaco_commands_1 = require("./monaco-commands");
const monaco_languages_1 = require("./monaco-languages");
const monaco_workspace_1 = require("./monaco-workspace");
const console_window_1 = require("./console-window");
const services_1 = require("./services");
var MonacoServices;
(function (MonacoServices) {
    function create(editor, options = {}) {
        const m2p = new monaco_converter_1.MonacoToProtocolConverter();
        const p2m = new monaco_converter_1.ProtocolToMonacoConverter();
        return {
            commands: new monaco_commands_1.MonacoCommands(editor),
            languages: new monaco_languages_1.MonacoLanguages(p2m, m2p),
            workspace: new monaco_workspace_1.MonacoWorkspace(p2m, m2p, options.rootUri),
            window: new console_window_1.ConsoleWindow()
        };
    }
    MonacoServices.create = create;
    function install(editor, options = {}) {
        const services = create(editor, options);
        services_1.Services.install(services);
        return services;
    }
    MonacoServices.install = install;
    function get() {
        return services_1.Services.get();
    }
    MonacoServices.get = get;
})(MonacoServices = exports.MonacoServices || (exports.MonacoServices = {}));
//# sourceMappingURL=monaco-services.js.map