"use strict";

var _react = _interopRequireWildcard(require("react"));

var _react2 = require("@storybook/react");

var _addonActions = require("@storybook/addon-actions");

var _ = require("./");

var _Button = _interopRequireDefault(require("../Button"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance"); }

function _iterableToArrayLimit(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

(0, _react2.storiesOf)('ErrorBoundary', module).add('default', function () {
  function DemoComponent() {
    var _useState = (0, _react.useState)(false),
        _useState2 = _slicedToArray(_useState, 2),
        shouldThrowError = _useState2[0],
        setShouldThrowError = _useState2[1];

    function onClick() {
      setShouldThrowError(!shouldThrowError);
    }

    return _react.default.createElement(_react.default.Fragment, null, _react.default.createElement(_Button.default, {
      onClick: onClick
    }, "Toggle throwing error"), _react.default.createElement("div", null, _react.default.createElement(_.ErrorBoundary, {
      fallback: _react.default.createElement(Fallback, null)
    }, _react.default.createElement(ThrowError, {
      shouldThrowError: shouldThrowError
    }))));
  }

  function Fallback() {
    return 'Whoops';
  }

  function ThrowError(_ref) {
    var shouldThrowError = _ref.shouldThrowError;

    if (shouldThrowError) {
      throw new Error('Component threw error');
    }

    return 'Successfully rendered';
  }

  return _react.default.createElement(DemoComponent, null);
}).add('with custom context', function () {
  function DemoComponent() {
    var _useState3 = (0, _react.useState)(false),
        _useState4 = _slicedToArray(_useState3, 2),
        shouldThrowError = _useState4[0],
        setShouldThrowError = _useState4[1];

    function onClick() {
      setShouldThrowError(!shouldThrowError);
    }

    return _react.default.createElement(_.ErrorBoundaryContext.Provider, {
      value: {
        log: (0, _addonActions.action)('log')
      }
    }, _react.default.createElement(_Button.default, {
      onClick: onClick
    }, "Toggle throwing error"), _react.default.createElement("div", null, _react.default.createElement(_.ErrorBoundary, {
      fallback: _react.default.createElement(Fallback, null)
    }, _react.default.createElement(ThrowError, {
      shouldThrowError: shouldThrowError
    }))));
  }

  function Fallback() {
    return 'Whoops';
  }

  function ThrowError(_ref2) {
    var shouldThrowError = _ref2.shouldThrowError;

    if (shouldThrowError) {
      throw new Error('Component threw error');
    }

    return 'Successfully rendered';
  }

  return _react.default.createElement(DemoComponent, null);
});