/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React from 'react';
import { storiesOf } from '@storybook/react';
import { withKnobs, number } from '@storybook/addon-knobs';
import { action } from '@storybook/addon-actions';
import { ProgressIndicator, ProgressStep } from '../ProgressIndicator';
import ProgressIndicatorSkeleton from '../ProgressIndicator/ProgressIndicator.Skeleton';
import Tooltip from '../Tooltip';
import { settings } from 'carbon-components';
var prefix = settings.prefix;
storiesOf('ProgressIndicator', module).addDecorator(withKnobs).add('Default', function () {
  return React.createElement(ProgressIndicator, {
    currentIndex: number('Current progress (currentIndex)', 1)
  }, React.createElement(ProgressStep, {
    label: "First step",
    description: "Step 1: Getting started with Carbon Design System",
    secondaryLabel: "Optional label"
  }), React.createElement(ProgressStep, {
    label: "Second step with tooltip",
    description: "Step 2: Getting started with Carbon Design System",
    renderLabel: function renderLabel() {
      return React.createElement(Tooltip, {
        direction: "bottom",
        showIcon: false,
        triggerClassName: "".concat(prefix, "--progress-label"),
        triggerText: 'Second step with tooltip',
        tooltipId: "tooltipId-0"
      }, React.createElement("p", null, "Overflow tooltip content."));
    }
  }), React.createElement(ProgressStep, {
    label: "Third step with tooltip",
    description: "Step 3: Getting started with Carbon Design System",
    renderLabel: function renderLabel() {
      return React.createElement(Tooltip, {
        direction: "bottom",
        showIcon: false,
        triggerClassName: "".concat(prefix, "--progress-label"),
        triggerText: 'Third step with tooltip',
        tooltipId: "tooltipId-1"
      }, React.createElement("p", null, "Lorem ipsum dolor, sit amet consectetur adipisicing elit. Animi consequuntur hic ratione aliquid cupiditate, nesciunt saepe iste blanditiis cumque maxime tenetur veniam est illo deserunt sint quae pariatur. Laboriosam, consequatur."));
    }
  }), React.createElement(ProgressStep, {
    label: "Fourth step",
    description: "Step 4: Getting started with Carbon Design System",
    invalid: true,
    secondaryLabel: "Example invalid step"
  }), React.createElement(ProgressStep, {
    label: "Fifth step",
    description: "Step 5: Getting started with Carbon Design System",
    disabled: true
  }));
}, {
  info: {
    text: "\n            For React usage, ProgressIndicator holds the currentIndex state to indicate which ProgressStep is the current step. The ProgressIndicator component should always be used with ProgressStep components as its children. Changing currentIndex prop will automatically set the ProgressStep components props (complete, incomplete, current).\n            For general usage, Progress Indicators display steps in a process. It should indicate when steps have been complete, the active step,\n            and the steps to come.\n          "
  }
}).add('interactive', function () {
  return React.createElement(ProgressIndicator, {
    currentIndex: number('Current progress (currentIndex)', 1),
    onChange: action('onChange')
  }, React.createElement(ProgressStep, {
    label: "Click me",
    description: "Step 1: Register a onChange event"
  }), React.createElement(ProgressStep, {
    label: "Really long label",
    description: "The progress indicator will listen for clicks on the steps"
  }), React.createElement(ProgressStep, {
    label: "Tooltip and really long label",
    description: "The progress indicator will listen for clicks on the steps",
    renderLabel: function renderLabel() {
      return React.createElement(Tooltip, {
        direction: "bottom",
        showIcon: false,
        triggerClassName: "".concat(prefix, "--progress-label"),
        triggerText: "Tooltip and really long label",
        tooltipId: "tooltipId-1"
      }, React.createElement("p", null, "Lorem ipsum dolor, sit amet consectetur adipisicing elit. Animi consequuntur hic ratione aliquid cupiditate, nesciunt saepe iste blanditiis cumque maxime tenetur veniam est illo deserunt sint quae pariatur. Laboriosam, consequatur."));
    }
  }));
}, {
  info: {
    text: "\n           If you register an onChange handler, the Progress Indicator will become interactive.  Your parent component should update the currentIndex prop within the onChange handler.\n          "
  }
}).add('skeleton', function () {
  return React.createElement(ProgressIndicatorSkeleton, null);
}, {
  info: {
    text: "\n            Placeholder skeleton state to use when content is loading.\n        "
  }
});