'use strict';

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _AccordionItem = require('../AccordionItem');

var _AccordionItem2 = _interopRequireDefault(_AccordionItem);

var _Icon = require('../Icon');

var _Icon2 = _interopRequireDefault(_Icon);

var _enzyme = require('enzyme');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

describe('AccordionItem', function () {
  describe('Renders as expected', function () {
    var wrapper = (0, _enzyme.shallow)(_react2.default.createElement(
      _AccordionItem2.default,
      { title: 'A heading', className: 'extra-class' },
      'Lorem ipsum.'
    ));

    it('renders children as expected', function () {
      expect(wrapper.find('.bx--accordion__content').text()).toBe('Lorem ipsum.');
    });

    it('renders heading as expected', function () {
      var heading = wrapper.find('.bx--accordion__heading');
      expect(heading.length).toBe(1);
      expect(heading.find(_Icon2.default).length).toBe(1);
      expect(heading.find('.bx--accordion__title').text()).toBe('A heading');
    });

    it('should use correct icon', function () {
      var heading = wrapper.find('.bx--accordion__heading');
      expect(heading.find(_Icon2.default).props().name).toEqual('chevron--right');
    });

    it('has the expected classes', function () {
      expect(wrapper.hasClass('bx--accordion__item')).toEqual(true);
      expect(wrapper.hasClass('bx--accordion__item--active')).toEqual(false);
    });

    it('renders extra classes passed in via className', function () {
      expect(wrapper.hasClass('extra-class')).toEqual(true);
    });

    it('can be open by default', function () {
      var openItem = (0, _enzyme.shallow)(_react2.default.createElement(
        _AccordionItem2.default,
        { title: 'A heading', open: true },
        'Lorem ipsum.'
      ));
      expect(openItem.hasClass('bx--accordion__item--active')).toEqual(true);
      expect(openItem.state().open).toEqual(true);
    });

    it('should apply the active class when the state is open', function () {
      var toggler = (0, _enzyme.mount)(_react2.default.createElement(_AccordionItem2.default, null));
      var item = toggler.find('li');
      expect(item.hasClass('bx--accordion__item--active')).toEqual(false);
      toggler.setState({ open: true });
      expect(toggler.find('li').hasClass('bx--accordion__item--active')).toEqual(true);
    });
  });

  describe('Check that functions passed in as props are called', function () {
    var onClick = jest.fn();
    var onHeadingClick = jest.fn();
    var wrapper = (0, _enzyme.mount)(_react2.default.createElement(_AccordionItem2.default, { onClick: onClick, onHeadingClick: onHeadingClick }));
    var heading = wrapper.find('.bx--accordion__heading');

    it('should call onClick', function () {
      wrapper.simulate('click');
      expect(onClick).toBeCalled();
    });

    it('should call onHeadingClick', function () {
      heading.simulate('click');
      expect(onHeadingClick).toBeCalled();
    });
  });

  describe('Check that clicking the item toggles its open state', function () {
    var toggler = (0, _enzyme.mount)(_react2.default.createElement(
      _AccordionItem2.default,
      { title: 'A heading' },
      'Lorem ipsum.'
    ));
    var heading = toggler.find('.bx--accordion__heading');

    it('should set state to open when clicked', function () {
      expect(toggler.state().open).toEqual(false);
      heading.simulate('click');
      expect(toggler.state().open).toEqual(true);
    });
  });

  describe('Check that the keyboard toggles its open state', function () {
    var toggler = void 0;

    beforeEach(function () {
      toggler = (0, _enzyme.mount)(_react2.default.createElement(
        _AccordionItem2.default,
        { title: 'A heading' },
        'Lorem ipsum.',
        _react2.default.createElement('input', { className: 'testInput' })
      ));
    });

    it('should toggle state when using enter or space', function () {
      expect(toggler.state().open).toEqual(false);
      toggler.simulate('keypress', { which: 32 });
      expect(toggler.state().open).toEqual(true);
      toggler.simulate('keypress', { which: 13 });
      expect(toggler.state().open).toEqual(false);
      toggler.simulate('keypress', { which: 97 });
      expect(toggler.state().open).toEqual(false);
    });

    it('should not toggle if a keypress is made in a child element', function () {
      var input = toggler.find('.testInput');
      expect(toggler.state().open).toEqual(false);
      toggler.simulate('keypress', { which: 32 });
      expect(toggler.state().open).toEqual(true);
      input.simulate('keypress', { which: 32 });
      expect(toggler.state().open).toEqual(true);
    });
  });
});