'use strict';

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _CardStatus = require('../CardStatus');

var _CardStatus2 = _interopRequireDefault(_CardStatus);

var _enzyme = require('enzyme');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

describe('CardStatus', function () {
  describe('Renders as expected with defaultProps', function () {
    var wrapper = (0, _enzyme.shallow)(_react2.default.createElement(_CardStatus2.default, { className: 'extra-class' }));

    it('has the expected classes', function () {
      expect(wrapper.hasClass('bx--card-footer__app-status')).toEqual(true);
    });

    it('renders extra classes passed in via className', function () {
      expect(wrapper.hasClass('extra-class')).toEqual(true);
    });

    it('renders status div', function () {
      var statusDiv = wrapper.childAt(0);
      expect(statusDiv.hasClass('bx--card-footer__app-status--running active')).toBe(true);

      var status = statusDiv.childAt(0);
      expect(status.hasClass('bx--running__text')).toBe(true);
      expect(status.props().children).toBe('Running');
    });
  });

  describe('Renders as expected with specified props', function () {
    var wrapper = (0, _enzyme.shallow)(_react2.default.createElement(_CardStatus2.default, { status: 1 }));

    it('renders status div', function () {
      var statusDiv = wrapper.childAt(0);
      expect(statusDiv.hasClass('bx--card-footer__app-status--not-running active')).toBe(true);

      var status = statusDiv.childAt(0);
      expect(status.hasClass('bx--not-running__text')).toBe(true);
      expect(status.props().children).toBe('Not Running');
    });

    it('renders nothing for invalid status (not between 0-2)', function () {
      wrapper.setProps({ status: 3 });
      expect(wrapper.props().children).toBe('');
    });
  });

  describe('updates appropriately on prop changes', function () {
    var wrapper = (0, _enzyme.shallow)(_react2.default.createElement(_CardStatus2.default, null));

    it('updates from Running to Not Running', function () {
      var oldStatus = wrapper.childAt(0).childAt(0);
      expect(oldStatus.hasClass('bx--running__text')).toBe(true);
      expect(oldStatus.props().children).toBe('Running');

      wrapper.setProps({ status: 1 });
      var newStatus = wrapper.childAt(0).childAt(0);
      expect(newStatus.hasClass('bx--not-running__text')).toBe(true);
      expect(newStatus.props().children).toBe('Not Running');
    });

    it('updates from Not Running to Stopped', function () {
      var oldStatus = wrapper.childAt(0).childAt(0);
      expect(oldStatus.hasClass('bx--not-running__text')).toBe(true);
      expect(oldStatus.props().children).toBe('Not Running');

      wrapper.setProps({ status: 2 });
      var newStatus = wrapper.childAt(0).childAt(0);
      expect(newStatus.hasClass('bx--stopped__text')).toBe(true);
      expect(newStatus.props().children).toBe('Stopped');
    });
  });

  describe('Renders as expected with specified status text', function () {
    var wrapper = (0, _enzyme.shallow)(_react2.default.createElement(_CardStatus2.default, {
      runningText: '[[Running]]',
      notRunningText: '[[Not Running]]',
      stoppedText: '[[Stopped]]'
    }));

    it('Shows running text', function () {
      wrapper.setProps({ status: 0 });
      var statusDiv = wrapper.childAt(0);
      var status = statusDiv.childAt(0);
      expect(status.props().children).toBe('[[Running]]');
    });

    it('Shows not running text', function () {
      wrapper.setProps({ status: 1 });
      var statusDiv = wrapper.childAt(0);
      var status = statusDiv.childAt(0);
      expect(status.props().children).toBe('[[Not Running]]');
    });

    it('Shows stopped text', function () {
      wrapper.setProps({ status: 2 });
      var statusDiv = wrapper.childAt(0);
      var status = statusDiv.childAt(0);
      expect(status.props().children).toBe('[[Stopped]]');
    });
  });
});