'use strict';

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _Checkbox = require('../Checkbox');

var _Checkbox2 = _interopRequireDefault(_Checkbox);

var _enzyme = require('enzyme');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

describe('Checkbox', function () {
  describe('Renders as expected', function () {
    var wrapper = (0, _enzyme.mount)(_react2.default.createElement(_Checkbox2.default, { id: 'testing', labelText: 'testingLabel', className: 'extra-class' }));
    var label = wrapper.find('label');

    describe('label', function () {
      it('renders a label', function () {
        expect(label.length).toEqual(1);
      });

      it('has the expected classes', function () {
        expect(label.hasClass('bx--checkbox-label')).toEqual(true);
      });

      it('has the expected htmlFor value', function () {
        expect(label.props().htmlFor).toEqual('testing');
      });

      it('applies extra classes to label', function () {
        expect(label.hasClass('extra-class')).toEqual(true);
      });

      describe('input', function () {
        var input = function input() {
          return wrapper.find('input');
        };

        it('has id set as expected', function () {
          expect(input().props().id).toEqual('testing');
        });

        it('defaultChecked prop sets defaultChecked on input', function () {
          expect(input().props().defaultChecked).toBeUndefined();
          wrapper.setProps({ defaultChecked: true });
          expect(input().props().defaultChecked).toEqual(true);
        });
      });
    });
  });

  it('disabled prop on component sets disabled prop on input', function () {
    var wrapper = (0, _enzyme.mount)(_react2.default.createElement(_Checkbox2.default, { id: 'test', labelText: 'testlabel', disabled: true }));

    var input = function input() {
      return wrapper.find('input');
    };
    expect(input().props().disabled).toEqual(true);

    wrapper.setProps({ disabled: false });
    expect(input().props().disabled).toEqual(false);
  });

  it('checked prop on component sets checked prop on input', function () {
    var wrapper = (0, _enzyme.mount)(_react2.default.createElement(_Checkbox2.default, { id: 'test', labelText: 'testlabel', checked: true }));

    var input = function input() {
      return wrapper.find('input');
    };
    expect(input().props().checked).toEqual(true);

    wrapper.setProps({ checked: false });
    expect(input().props().checked).toEqual(false);
  });

  describe('events', function () {
    it('should invoke onChange with expected arguments', function () {
      var onChange = jest.fn();
      var id = 'test-input';
      var wrapper = (0, _enzyme.mount)(_react2.default.createElement(_Checkbox2.default, { labelText: 'testlabel', id: id, onChange: onChange }));

      var input = wrapper.find('input');
      var inputElement = input.instance();

      inputElement.checked = true;
      wrapper.find('input').simulate('change');

      var call = onChange.mock.calls[0];

      expect(call[0]).toEqual(true);
      expect(call[1]).toEqual(id);
      expect(call[2].target).toBe(inputElement);
    });
  });
});