'use strict';

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _react3 = require('@storybook/react');

var _ComboBox = require('../ComboBox');

var _ComboBox2 = _interopRequireDefault(_ComboBox);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var items = [{
  id: 'option-1',
  text: 'Option 1'
}, {
  id: 'option-2',
  text: 'Option 2'
}, {
  id: 'option-3',
  text: 'Option 3'
}, {
  id: 'option-4',
  text: 'Option 4'
}];

(0, _react3.storiesOf)('ComboBox', module).addWithInfo('default', '\n    ComboBox\n  ', function () {
  return _react2.default.createElement(
    'div',
    { style: { width: 300 } },
    _react2.default.createElement(_ComboBox2.default, {
      items: items,
      itemToString: function itemToString(item) {
        return item ? item.text : '';
      },
      onChange: (0, _react3.action)('onChange - ComboBox'),
      placeholder: 'Filter...'
    })
  );
}).addWithInfo('disabled', '\n    Disabled ComboBox\n  ', function () {
  return _react2.default.createElement(
    'div',
    { style: { width: 300 } },
    _react2.default.createElement(_ComboBox2.default, {
      items: items,
      itemToString: function itemToString(item) {
        return item ? item.text : '';
      },
      onChange: (0, _react3.action)('onChange - ComboBox'),
      placeholder: 'Filter...',
      disabled: true
    })
  );
});