'use strict';

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _DatePicker = require('../DatePicker');

var _DatePicker2 = _interopRequireDefault(_DatePicker);

var _enzyme = require('enzyme');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

describe('DatePicker', function () {
  describe('Renders as expected', function () {
    var wrapper = (0, _enzyme.mount)(_react2.default.createElement(
      _DatePicker2.default,
      { onChange: function onChange() {}, className: 'extra-class' },
      _react2.default.createElement('div', { className: 'test-child' }),
      _react2.default.createElement('div', { className: 'test-child' })
    ));
    var datepicker = wrapper.childAt(0);

    it('has the expected classes', function () {
      expect(datepicker.children().hasClass('bx--date-picker')).toBe(true);
    });

    it('should add extra classes that are passed via className', function () {
      expect(datepicker.children().hasClass('extra-class')).toBe(true);
    });

    it('should add the date picker type as expected', function () {
      expect(wrapper.props().datePickerType).toEqual(undefined);
      wrapper.setProps({ datePickerType: 'simple' });
      expect(wrapper.props().datePickerType).toEqual('simple');
    });

    it('should specify short date picker as expected', function () {
      expect(wrapper.props().short).toEqual(false);
      wrapper.setProps({ short: true });
      expect(wrapper.props().short).toEqual(true);
    });

    it('should add the date format as expected', function () {
      expect(wrapper.props().dateFormat).toEqual('m/d/Y');
      wrapper.setProps({ dateFormat: 'd/m/Y' });
      expect(wrapper.props().dateFormat).toEqual('d/m/Y');
    });

    it('has the value as expected', function () {
      expect(wrapper.props().value).toEqual(undefined);
      wrapper.setProps({ value: '11/08/2017' });
      expect(wrapper.props().value).toEqual('11/08/2017');
    });

    it('should render the children as expected', function () {
      expect(wrapper.props().children.length).toEqual(2);
    });
  });

  describe('Simple date picker', function () {
    var wrapper = (0, _enzyme.mount)(_react2.default.createElement(
      _DatePicker2.default,
      { datePickerType: 'simple', className: 'extra-class' },
      _react2.default.createElement('div', { className: 'test-child' })
    ));
    var datepicker = wrapper.childAt(0);

    it('has the simple date picker class', function () {
      expect(datepicker.children().hasClass('bx--date-picker--simple')).toBe(true);
    });

    it('has the value as expected', function () {
      expect(wrapper.props().value).toEqual(undefined);
      wrapper.setProps({ value: '11/08/2017' });
      expect(wrapper.props().value).toEqual('11/08/2017');
    });

    it('should not initalize a calendar', function () {
      expect(wrapper.cal).toEqual(undefined);
    });
  });

  describe('Single date picker', function () {
    var wrapper = (0, _enzyme.mount)(_react2.default.createElement(
      _DatePicker2.default,
      {
        onChange: function onChange() {},
        datePickerType: 'single',
        className: 'extra-class' },
      _react2.default.createElement(
        'div',
        { className: 'test-child' },
        _react2.default.createElement('input', { type: 'text', className: 'bx--date-picker__input' })
      )
    ));
    var datepicker = wrapper.childAt(0);
    var input = wrapper.find('.bx--date-picker__input');
    var icon = wrapper.find('svg');

    it('has the single date picker class', function () {
      expect(datepicker.children().hasClass('bx--date-picker--single')).toBe(true);
    });

    it('should initalize a calendar', function () {
      expect(wrapper.instance().cal).toBeDefined();
    });

    it('should update the classnames', function () {
      expect(wrapper.instance().cal.calendarContainer.classList.contains('bx--date-picker__calendar')).toBe(true);
    });

    it('has the value as expected', function () {
      expect(wrapper.props().value).toEqual(undefined);
      wrapper.setProps({ value: '11/08/2017' });
      expect(wrapper.props().value).toEqual('11/08/2017');
    });

    it('should not render an icon', function () {
      expect(icon.length).toEqual(0);
    });
  });

  describe('Range date picker', function () {
    var wrapper = (0, _enzyme.mount)(_react2.default.createElement(
      _DatePicker2.default,
      {
        onChange: function onChange() {},
        datePickerType: 'range',
        className: 'extra-class' },
      _react2.default.createElement(
        'div',
        { className: 'test-child' },
        _react2.default.createElement('input', {
          type: 'text',
          className: 'bx--date-picker__input',
          id: 'input-from'
        })
      ),
      _react2.default.createElement(
        'div',
        { className: 'test-child' },
        _react2.default.createElement('input', { type: 'text', className: 'bx--date-picker__input', id: 'input-to' })
      )
    ));
    var datepicker = wrapper.childAt(0);
    var icon = wrapper.find('svg');

    it('has the range date picker class', function () {
      expect(datepicker.children().hasClass('bx--date-picker--range')).toBe(true);
    });

    it('should initalize a calendar', function () {
      expect(wrapper.instance().cal).toBeDefined();
    });

    it('should update the classnames', function () {
      expect(wrapper.instance().cal.calendarContainer.classList.contains('bx--date-picker__calendar')).toBe(true);
    });

    it('has the value as expected', function () {
      expect(wrapper.props().value).toEqual(undefined);
      wrapper.setProps({ value: '11/08/2017' });
      expect(wrapper.props().value).toEqual('11/08/2017');
    });

    it('should render an icon', function () {
      expect(icon.length).toEqual(1);
    });
  });
});