'use strict';

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _react3 = require('@storybook/react');

var _DropdownV = require('../DropdownV2');

var _DropdownV2 = _interopRequireDefault(_DropdownV);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var items = [{
  id: 'option-1',
  text: 'Option 1'
}, {
  id: 'option-2',
  text: 'Option 2'
}, {
  id: 'option-3',
  text: 'Option 3'
}, {
  id: 'option-4',
  text: 'Option 4'
}];

(0, _react3.storiesOf)('DropdownV2', module).addWithInfo('default', '\n    DropdownV2\n  ', function () {
  return _react2.default.createElement(
    'div',
    { style: { width: 300 } },
    _react2.default.createElement(_DropdownV2.default, {
      label: 'Label',
      items: items,
      itemToString: function itemToString(item) {
        return item ? item.text : '';
      },
      onChange: (0, _react3.action)('onChange')
    })
  );
}).addWithInfo('inline', '\n    Disabled DropdownV2\n  ', function () {
  return _react2.default.createElement(
    'div',
    { style: { width: 300 } },
    _react2.default.createElement(_DropdownV2.default, {
      type: 'inline',
      label: 'Label',
      items: items,
      itemToString: function itemToString(item) {
        return item ? item.text : '';
      },
      onChange: (0, _react3.action)('onChange')
    })
  );
}).addWithInfo('disabled', '\n    Disabled DropdownV2\n  ', function () {
  return _react2.default.createElement(
    'div',
    { style: { width: 300 } },
    _react2.default.createElement(_DropdownV2.default, {
      label: 'Label',
      items: items,
      itemToString: function itemToString(item) {
        return item ? item.text : '';
      },
      onChange: (0, _react3.action)('onChange'),
      disabled: true
    })
  );
}).addWithInfo('disabled - inline', '\n    Disabled Inline DropdownV2\n  ', function () {
  return _react2.default.createElement(
    'div',
    { style: { width: 300 } },
    _react2.default.createElement(_DropdownV2.default, {
      type: 'inline',
      label: 'Label',
      items: items,
      itemToString: function itemToString(item) {
        return item ? item.text : '';
      },
      onChange: (0, _react3.action)('onChange'),
      disabled: true
    })
  );
});