'use strict';

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _FileUploader = require('../FileUploader');

var _FileUploader2 = _interopRequireDefault(_FileUploader);

var _enzyme = require('enzyme');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

describe('Filename', function () {
  var mountWrapper = (0, _enzyme.mount)(_react2.default.createElement(_FileUploader.Filename, { name: 'trees.jpg' }));

  describe('click on edit icon (close--glyph)', function () {
    it('should have a click event', function () {
      var onClick = jest.fn();
      mountWrapper.setProps({ onClick: onClick, status: 'edit' });
      mountWrapper.find('Icon').simulate('click');
      expect(onClick).toBeCalled();
    });
  });
});

describe('FileUploaderButton', function () {
  var button = _react2.default.createElement(_FileUploader.FileUploaderButton, { className: 'extra-class' });
  var mountWrapper = (0, _enzyme.mount)(button);

  describe('Renders as expected with default props', function () {
    it('renders with expected className', function () {
      expect(mountWrapper.children().hasClass('bx--file')).toBe(true);
    });

    it('renders with given className', function () {
      expect(mountWrapper.hasClass('extra-class')).toBe(true);
    });

    it('renders with default labelText prop', function () {
      expect(mountWrapper.props().labelText).toEqual('Add file');
    });

    it('renders with default buttonKind prop', function () {
      expect(mountWrapper.props().buttonKind).toEqual('primary');
    });

    it('renders with expected button className', function () {
      expect(mountWrapper.find('.bx--btn--primary').exists()).toBe(true);
    });

    it('renders with default multiple prop', function () {
      expect(mountWrapper.props().multiple).toEqual(false);
    });

    it('renders with default disableLabelChanges prop', function () {
      expect(mountWrapper.props().disableLabelChanges).toEqual(false);
    });

    it('does not have default role', function () {
      expect(mountWrapper.props().role).not.toBeTruthy();
    });
  });

  describe('Unique id props', function () {
    it('each FileUploaderButton should have a unique ID', function () {
      var mountedButtons = (0, _enzyme.mount)(_react2.default.createElement(
        'div',
        null,
        _react2.default.createElement(_FileUploader.FileUploaderButton, { className: 'extra-class' }),
        _react2.default.createElement(_FileUploader.FileUploaderButton, { className: 'extra-class' })
      ));
      var firstButton = mountedButtons.find(_FileUploader.FileUploaderButton).at(0);
      var lastButton = mountedButtons.find(_FileUploader.FileUploaderButton).at(1);
      var isEqual = firstButton === lastButton;
      expect(isEqual).toBe(false);
    });
  });

  describe('Update labelText', function () {
    it('should have equal state and props', function () {
      expect(mountWrapper.state().labelText).toEqual(mountWrapper.props().labelText);
    });

    it('should update state with props', function () {
      mountWrapper.setProps({ labelText: 'new label' });
      expect(mountWrapper.state().labelText).toEqual(mountWrapper.props().labelText);
    });
  });
});

describe('FileUploader', function () {
  var fileUploader = _react2.default.createElement(_FileUploader2.default, { className: 'extra-class' });
  var mountWrapper = (0, _enzyme.mount)(fileUploader);

  describe('Renders as expected with defaults', function () {
    it('should render with default className', function () {
      expect(mountWrapper.children().hasClass('bx--form-item')).toEqual(true);
    });

    it('should render with given className', function () {
      expect(mountWrapper.hasClass('extra-class')).toEqual(true);
    });

    it('renders with FileUploaderButton with disableLabelChanges set to true', function () {
      expect(mountWrapper.find('FileUploaderButton').props().disableLabelChanges).toEqual(true);
    });
    it('renders input with hidden prop', function () {
      expect(mountWrapper.find('input').props().className).toEqual('bx--visually-hidden');
    });
    it('renders with empty div.bx--file-container by default', function () {
      expect(mountWrapper.find('div.bx--file-container').text()).toEqual('');
    });
  });
});