'use strict';

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _enzyme = require('enzyme');

var _ModalWrapper = require('../ModalWrapper');

var _ModalWrapper2 = _interopRequireDefault(_ModalWrapper);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

describe('ModalWrapper', function () {
  var mockProps = {};

  beforeEach(function () {
    mockProps = {
      id: 'modal',
      buttonTriggerText: 'Test Modal',
      modalHeading: 'Transactional Modal',
      modalLabel: 'Test Modal Label',
      primaryButtonText: 'Save',
      secondaryButtonText: 'Cancel',
      handleSubmit: jest.fn(function () {
        return true;
      }),
      shouldCloseAfterSubmit: true
    };
  });

  it('should render', function () {
    var wrapper = (0, _enzyme.mount)(_react2.default.createElement(
      _ModalWrapper2.default,
      mockProps,
      _react2.default.createElement(
        'p',
        { className: 'bx--modal-content__text' },
        'Text'
      )
    ));
    expect(wrapper).toMatchSnapshot();
  });

  it('should close after a successful submit action', function () {
    var wrapper = (0, _enzyme.mount)(_react2.default.createElement(
      _ModalWrapper2.default,
      mockProps,
      _react2.default.createElement(
        'p',
        { className: 'bx--modal-content__text' },
        'Text'
      )
    ));
    wrapper.find({ children: mockProps.buttonTriggerText }).simulate('click');
    expect(wrapper.state('isOpen')).toBe(true);

    wrapper.find({ children: mockProps.primaryButtonText }).simulate('click');
    expect(wrapper.state('isOpen')).toBe(false);
  });

  it('should not close after an unsuccessful submit action', function () {
    mockProps.handleSubmit = jest.fn(function () {
      return false;
    });
    var wrapper = (0, _enzyme.mount)(_react2.default.createElement(
      _ModalWrapper2.default,
      mockProps,
      _react2.default.createElement(
        'p',
        { className: 'bx--modal-content__text' },
        'Text'
      )
    ));
    wrapper.find({ children: mockProps.buttonTriggerText }).simulate('click');
    expect(wrapper.state('isOpen')).toBe(true);

    wrapper.find({ children: mockProps.primaryButtonText }).simulate('click');
    expect(wrapper.state('isOpen')).toBe(true);
  });
});