'use strict';

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _OrderSummary = require('../OrderSummary');

var _enzyme = require('enzyme');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

describe('OrderSummaryList', function () {
  describe('Renders as expected', function () {
    var orderSummaryList = (0, _enzyme.shallow)(_react2.default.createElement(
      _OrderSummary.OrderSummaryList,
      { className: 'some-class' },
      _react2.default.createElement(_OrderSummary.OrderSummaryListItem, null),
      _react2.default.createElement(_OrderSummary.OrderSummaryListItem, null),
      _react2.default.createElement(_OrderSummary.OrderSummaryListItem, null)
    ));

    it('renders Order Summary List', function () {
      expect(orderSummaryList.length).toEqual(1);
    });

    it('should render with the appropriate classes', function () {
      expect(orderSummaryList.hasClass('bx--order-list')).toEqual(true);
      expect(orderSummaryList.hasClass('some-class')).toEqual(true);
    });

    it('should render children as expected', function () {
      expect(orderSummaryList.find(_OrderSummary.OrderSummaryListItem).length).toEqual(3);
    });
  });
});