'use strict';

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _OrderSummary = require('../OrderSummary');

var _enzyme = require('enzyme');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

describe('OrderSummaryListItem', function () {
  describe('Renders as expected', function () {
    var orderSummaryListItem = (0, _enzyme.shallow)(_react2.default.createElement(_OrderSummary.OrderSummaryListItem, {
      className: 'some-class',
      text: 'Item 1',
      price: '$50.00'
    }));

    it('renders Order Summary List Item', function () {
      expect(orderSummaryListItem.length).toEqual(1);
    });

    it('should render with the appropriate classes', function () {
      expect(orderSummaryListItem.hasClass('bx--order-item')).toEqual(true);
      expect(orderSummaryListItem.hasClass('some-class')).toEqual(true);
    });

    it('should render with the correct label', function () {
      expect(orderSummaryListItem.find('.bx--order-detail').text()).toEqual('Item 1');
    });

    it('should render with the correct price', function () {
      expect(orderSummaryListItem.find('.bx--order-price').text()).toEqual('$50.00');
    });
  });
});