'use strict';

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _TableHead = require('../TableHead');

var _TableHead2 = _interopRequireDefault(_TableHead);

var _enzyme = require('enzyme');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

describe('TableHead', function () {
  describe('Renders as expected', function () {
    var thead = (0, _enzyme.shallow)(_react2.default.createElement(
      _TableHead2.default,
      null,
      _react2.default.createElement('tr', null)
    ));

    it('has the expected classes', function () {
      expect(thead.hasClass('bx--table-head')).toEqual(true);
    });

    it('should render a thead with the appropriate class', function () {
      var theadEl = thead.find('thead');
      expect(theadEl.hasClass('bx--table-head')).toEqual(true);
    });

    it('should add extra classes that are passed via className for the table', function () {
      thead.setProps({ className: 'extra-class' });
      var tableEl = thead.find('thead');
      expect(tableEl.hasClass('extra-class')).toEqual(true);
    });

    it('should render children as expected', function () {
      expect(thead.find('tr').length).toEqual(1);
    });
  });
});