'use strict';

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _TableHeader = require('../TableHeader');

var _TableHeader2 = _interopRequireDefault(_TableHeader);

var _Icon = require('../Icon');

var _Icon2 = _interopRequireDefault(_Icon);

var _enzyme = require('enzyme');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

describe('TableHeader', function () {
  describe('Renders as expected', function () {
    var theader = (0, _enzyme.shallow)(_react2.default.createElement(
      _TableHeader2.default,
      null,
      _react2.default.createElement(
        'p',
        null,
        'Content'
      )
    ));

    it('should render a th with the appropriate class', function () {
      var thEl = theader.find('th');
      expect(thEl.hasClass('bx--table-header')).toEqual(true);
    });

    it('should add extra classes that are passed via className for the th', function () {
      theader.setProps({ className: 'extra-class' });
      expect(theader.hasClass('extra-class')).toEqual(true);
    });

    it('should render children as expected', function () {
      expect(theader.find('p').length).toEqual(1);
    });

    it('should render a down icon if sortDir is passed in', function () {
      theader.setProps({ sortDir: 'DESC' });
      var icon = theader.find(_Icon2.default);
      expect(icon.length).toEqual(1);
      expect(icon.hasClass('bx--table-sort__svg')).toEqual(true);
      expect(icon.props().name).toEqual('caret--down');
    });
  });
});