var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

import warning from 'warning';
import debounce from 'lodash.debounce';
import settings from '../../globals/js/settings';
import mixin from '../../globals/js/misc/mixin';
import createComponent from '../../globals/js/mixins/create-component';
import initComponentBySearch from '../../globals/js/mixins/init-component-by-search';
import handles from '../../globals/js/mixins/handles';
import on from '../../globals/js/misc/on';

var didWarnAboutDeprecation = false;

var DetailPageHeader = function (_mixin) {
  _inherits(DetailPageHeader, _mixin);

  /**
   * The Detail Page Header.
   * @extends CreateComponent
   * @extends InitComponentBySearch
   * @extends Handles
   * @param {HTMLElement} element The element working as a page header.
   * @param {Object} [options] The component options.
   */
  function DetailPageHeader(element, options) {
    _classCallCheck(this, DetailPageHeader);

    var _this = _possibleConstructorReturn(this, (DetailPageHeader.__proto__ || Object.getPrototypeOf(DetailPageHeader)).call(this, element, options));

    _this.previousScrollY = 0;
    // Debounce scroll event calls to handleScroll (default: 50)
    var debouncedScroll = debounce(_this._handleScroll.bind(_this), 25);
    _this.manage(on(_this.element.ownerDocument.defaultView, 'scroll', debouncedScroll));
    if (process.env.NODE_ENV !== 'production') {
      process.env.NODE_ENV !== 'production' ? warning(didWarnAboutDeprecation, 'Accessing the `detail-page-header` component from the ' + '`carbon-components` package is deprecated. Use the ' + '`carbon-addons-cloud` package instead.') : void 0;
      didWarnAboutDeprecation = true;
    }
    return _this;
  }

  /**
   * Adds class to header based on users position on the page
   */


  _createClass(DetailPageHeader, [{
    key: '_handleScroll',
    value: function _handleScroll() {
      var scrollPosition = void 0;
      if (this.element.ownerDocument.defaultView.pageYOffset) {
        scrollPosition = this.element.ownerDocument.defaultView.pageYOffset;
      } else {
        scrollPosition = this.element.ownerDocument.defaultView.pageYOffset;
      }

      if (scrollPosition > 86) {
        this.element.dataset.headerActive = true;
        if (scrollPosition < this.previousScrollY) {
          this.element.classList.remove(this.options.scroll);
        } else {
          this.element.classList.add(this.options.scroll);
        }
      } else {
        this.element.classList.remove(this.options.scroll);
        this.element.dataset.headerActive = false;
      }

      this.previousScrollY = scrollPosition;
    }

    /**
     * The map associating DOM element and detail page header instance.
     * @member DetailPageHeader.components
     * @type {WeakMap}
     */

  }], [{
    key: 'options',


    /**
     * The component options.
     * If `options` is specified in the constructor,
     * {@linkcode DetailPageHeader.create .create()}, or {@linkcode DetailPageHeader.init .init()},
     * properties in this object are overriden for the instance being created
     * and how {@linkcode DetailPageHeader.init .init()} works.
     * @member DetailPageHeader.options
     * @type {Object}
     * @property {string} selectorInit The CSS selector to find detail page headers.
     */
    get: function get() {
      var prefix = settings.prefix;

      return {
        selectorInit: '[data-detail-page-header]',
        scroll: prefix + '--detail-page-header--scroll'
      };
    }
  }]);

  return DetailPageHeader;
}(mixin(createComponent, initComponentBySearch, handles));

DetailPageHeader.components = new WeakMap();


export default DetailPageHeader;