function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

/* eslint-disable no-console */
import React from 'react';
import { storiesOf } from '@storybook/react';
import { action } from '@storybook/addon-actions';
import { withKnobs, boolean, text } from '@storybook/addon-knobs';
import Search from '../Search';
import SearchSkeleton from '../Search/Search.Skeleton';
import SearchFilterButton from '../SearchFilterButton';
import SearchLayoutButton from '../SearchLayoutButton';

var props = function props() {
  return {
    className: 'some-class',
    small: boolean('Small UI (small)', false),
    light: boolean('Light variant (light)', false),
    name: text('Form item name (name)', ''),
    value: text('Value (value)', 'Default value knob'),
    labelText: text('Label text (labelText)', 'Search'),
    closeButtonLabelText: text('The label text for the close button (closeButtonLabelText)', ''),
    placeHolderText: text('Placeholder text (placeHolderText)', 'Search'),
    onChange: action('onChange')
  };
};

storiesOf('Search', module).addDecorator(withKnobs).add('Default', function () {
  return React.createElement(Search, _extends({}, props(), {
    id: "search-1"
  }));
}, {
  info: {
    text: "\n            Search enables users to specify a word or a phrase to find particular relevant pieces of content\n            without the use of navigation. Search can be used as the primary means of discovering content,\n            or as a filter to aid the user in finding content.\n          "
  }
}).add('custom buttons', function () {
  return React.createElement("div", {
    style: {
      display: 'flex'
    }
  }, React.createElement(Search, _extends({}, props(), {
    id: "search-1"
  })), React.createElement(SearchFilterButton, {
    onClick: action('onClick')
  }), React.createElement(SearchLayoutButton, {
    onClick: action('onClick')
  }));
}, {
  info: {
    text: "\n            You can control what set of buttons you want.\n          "
  }
}).add('skeleton', function () {
  return React.createElement("div", {
    style: {
      width: '200px'
    }
  }, React.createElement(SearchSkeleton, null), "\xA0", React.createElement(SearchSkeleton, {
    small: true
  }));
}, {
  info: {
    text: "\n            Placeholder skeleton state to use when content is loading.\n          "
  }
});