"use strict";

var _react = _interopRequireDefault(require("react"));

var _enzyme = require("enzyme");

var _ModalWrapper = _interopRequireDefault(require("../ModalWrapper"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

describe('ModalWrapper', function () {
  var mockProps = {};
  beforeEach(function () {
    mockProps = {
      id: 'modal',
      buttonTriggerText: 'Test Modal',
      buttonTriggerClassName: 'btn-trigger',
      modalHeading: 'Transactional Modal',
      modalLabel: 'Test Modal Label',
      primaryButtonText: 'Save',
      secondaryButtonText: 'Cancel',
      handleSubmit: jest.fn(function () {
        return true;
      }),
      shouldCloseAfterSubmit: true
    };
  });
  it('should render', function () {
    var wrapper = (0, _enzyme.mount)(_react.default.createElement(_ModalWrapper.default, mockProps, _react.default.createElement("p", {
      className: "bx--modal-content__text"
    }, "Text")));
    expect(wrapper).toMatchSnapshot();
  });
  it('should close after a successful submit action', function () {
    var wrapper = (0, _enzyme.mount)(_react.default.createElement(_ModalWrapper.default, mockProps, _react.default.createElement("p", {
      className: "bx--modal-content__text"
    }, "Text")));
    wrapper.find({
      children: mockProps.buttonTriggerText
    }).simulate('click');
    expect(wrapper.state('isOpen')).toBe(true);
    wrapper.find({
      children: mockProps.primaryButtonText
    }).simulate('click');
    expect(wrapper.state('isOpen')).toBe(false);
  });
  it('should return focus to the trigger button after closing', function () {
    var wrapper = (0, _enzyme.mount)(_react.default.createElement(_ModalWrapper.default, mockProps, _react.default.createElement("p", {
      className: "bx--modal-content__text"
    }, "Text")));

    var _wrapper$instance = wrapper.instance(),
        triggerButton = _wrapper$instance.triggerButton;

    jest.spyOn(triggerButton.current, 'focus');
    wrapper.find({
      children: mockProps.buttonTriggerText
    }).simulate('click');
    wrapper.find({
      children: mockProps.primaryButtonText
    }).simulate('click');
    expect(triggerButton.current.focus).toHaveBeenCalledTimes(1);
  });
  it('should not close after an unsuccessful submit action', function () {
    mockProps.handleSubmit = jest.fn(function () {
      return false;
    });
    var wrapper = (0, _enzyme.mount)(_react.default.createElement(_ModalWrapper.default, mockProps, _react.default.createElement("p", {
      className: "bx--modal-content__text"
    }, "Text")));
    wrapper.find({
      children: mockProps.buttonTriggerText
    }).simulate('click');
    expect(wrapper.state('isOpen')).toBe(true);
    wrapper.find({
      children: mockProps.primaryButtonText
    }).simulate('click');
    expect(wrapper.state('isOpen')).toBe(true);
  });
});