import * as code from 'vscode';
import * as ls from 'vscode-languageserver-protocol';
import ProtocolCompletionItem from './protocolCompletionItem';
export interface Converter {
    asUri(value: string): code.Uri;
    asDiagnostic(diagnostic: ls.Diagnostic): code.Diagnostic;
    asDiagnostics(diagnostics: ls.Diagnostic[]): code.Diagnostic[];
    asPosition(value: undefined | null): undefined;
    asPosition(value: ls.Position): code.Position;
    asPosition(value: ls.Position | undefined | null): code.Position | undefined;
    asRange(value: undefined | null): undefined;
    asRange(value: ls.Range): code.Range;
    asRange(value: ls.Range | undefined | null): code.Range | undefined;
    asRanges(values: ls.Range[]): code.Range[];
    asDiagnosticSeverity(value: number | undefined | null): code.DiagnosticSeverity;
    asDiagnosticTag(tag: ls.DiagnosticTag): code.DiagnosticTag | undefined;
    asHover(hover: ls.Hover): code.Hover;
    asHover(hover: undefined | null): undefined;
    asHover(hover: ls.Hover | undefined | null): code.Hover | undefined;
    asCompletionResult(result: ls.CompletionList): code.CompletionList;
    asCompletionResult(result: ls.CompletionItem[]): code.CompletionItem[];
    asCompletionResult(result: undefined | null): undefined;
    asCompletionResult(result: ls.CompletionItem[] | ls.CompletionList | undefined | null): code.CompletionItem[] | code.CompletionList | undefined;
    asCompletionItem(item: ls.CompletionItem): ProtocolCompletionItem;
    asTextEdit(edit: undefined | null): undefined;
    asTextEdit(edit: ls.TextEdit): code.TextEdit;
    asTextEdit(edit: ls.TextEdit | undefined | null): code.TextEdit | undefined;
    asTextEdits(items: ls.TextEdit[]): code.TextEdit[];
    asTextEdits(items: undefined | null): undefined;
    asTextEdits(items: ls.TextEdit[] | undefined | null): code.TextEdit[] | undefined;
    asSignatureHelp(item: undefined | null): undefined;
    asSignatureHelp(item: ls.SignatureHelp): code.SignatureHelp;
    asSignatureHelp(item: ls.SignatureHelp | undefined | null): code.SignatureHelp | undefined;
    asSignatureInformation(item: ls.SignatureInformation): code.SignatureInformation;
    asSignatureInformations(items: ls.SignatureInformation[]): code.SignatureInformation[];
    asParameterInformation(item: ls.ParameterInformation): code.ParameterInformation;
    asParameterInformations(item: ls.ParameterInformation[]): code.ParameterInformation[];
    asLocation(item: ls.Location): code.Location;
    asLocation(item: undefined | null): undefined;
    asLocation(item: ls.Location | undefined | null): code.Location | undefined;
    asDeclarationResult(item: ls.Declaration): code.Location | code.Location[];
    asDeclarationResult(item: ls.DeclarationLink[]): code.LocationLink[];
    asDeclarationResult(item: undefined | null): undefined;
    asDeclarationResult(item: ls.Declaration | ls.DeclarationLink[] | undefined | null): code.Declaration | undefined;
    asDefinitionResult(item: ls.Definition): code.Definition;
    asDefinitionResult(item: ls.DefinitionLink[]): code.DefinitionLink[];
    asDefinitionResult(item: undefined | null): undefined;
    asDefinitionResult(item: ls.Definition | ls.DefinitionLink[] | undefined | null): code.Definition | code.DefinitionLink[] | undefined;
    asReferences(values: ls.Location[]): code.Location[];
    asReferences(values: undefined | null): code.Location[] | undefined;
    asReferences(values: ls.Location[] | undefined | null): code.Location[] | undefined;
    asDocumentHighlightKind(item: number): code.DocumentHighlightKind;
    asDocumentHighlight(item: ls.DocumentHighlight): code.DocumentHighlight;
    asDocumentHighlights(values: ls.DocumentHighlight[]): code.DocumentHighlight[];
    asDocumentHighlights(values: undefined | null): undefined;
    asDocumentHighlights(values: ls.DocumentHighlight[] | undefined | null): code.DocumentHighlight[] | undefined;
    asSymbolKind(item: ls.SymbolKind): code.SymbolKind;
    asSymbolTag(item: ls.SymbolTag): code.SymbolTag;
    asSymbolTags(items: undefined | null): undefined;
    asSymbolTags(items: ReadonlyArray<ls.SymbolTag>): code.SymbolTag[];
    asSymbolTags(items: ReadonlyArray<ls.SymbolTag> | undefined | null): code.SymbolTag[] | undefined;
    asSymbolInformation(item: ls.SymbolInformation, uri?: code.Uri): code.SymbolInformation;
    asSymbolInformations(values: ls.SymbolInformation[], uri?: code.Uri): code.SymbolInformation[];
    asSymbolInformations(values: undefined | null, uri?: code.Uri): undefined;
    asSymbolInformations(values: ls.SymbolInformation[] | undefined | null, uri?: code.Uri): code.SymbolInformation[] | undefined;
    asDocumentSymbol(value: ls.DocumentSymbol): code.DocumentSymbol;
    asDocumentSymbols(value: undefined | null): undefined;
    asDocumentSymbols(value: ls.DocumentSymbol[]): code.DocumentSymbol[];
    asDocumentSymbols(value: ls.DocumentSymbol[] | undefined | null): code.DocumentSymbol[] | undefined;
    asCommand(item: ls.Command): code.Command;
    asCommands(items: ls.Command[]): code.Command[];
    asCommands(items: undefined | null): undefined;
    asCommands(items: ls.Command[] | undefined | null): code.Command[] | undefined;
    asCodeAction(item: ls.CodeAction): code.CodeAction;
    asCodeAction(item: undefined | null): undefined;
    asCodeAction(item: ls.CodeAction | undefined | null): code.CodeAction | undefined;
    asCodeActionKind(item: null | undefined): undefined;
    asCodeActionKind(item: ls.CodeActionKind): code.CodeActionKind;
    asCodeActionKind(item: ls.CodeActionKind | null | undefined): code.CodeActionKind | undefined;
    asCodeActionKinds(item: null | undefined): undefined;
    asCodeActionKinds(items: ls.CodeActionKind[]): code.CodeActionKind[];
    asCodeActionKinds(item: ls.CodeActionKind[] | null | undefined): code.CodeActionKind[] | undefined;
    asCodeLens(item: ls.CodeLens): code.CodeLens;
    asCodeLens(item: undefined | null): undefined;
    asCodeLens(item: ls.CodeLens | undefined | null): code.CodeLens | undefined;
    asCodeLenses(items: ls.CodeLens[]): code.CodeLens[];
    asCodeLenses(items: undefined | null): undefined;
    asCodeLenses(items: ls.CodeLens[] | undefined | null): code.CodeLens[] | undefined;
    asWorkspaceEdit(item: ls.WorkspaceEdit): code.WorkspaceEdit;
    asWorkspaceEdit(item: undefined | null): undefined;
    asWorkspaceEdit(item: ls.WorkspaceEdit | undefined | null): code.WorkspaceEdit | undefined;
    asDocumentLink(item: ls.DocumentLink): code.DocumentLink;
    asDocumentLinks(items: ls.DocumentLink[]): code.DocumentLink[];
    asDocumentLinks(items: undefined | null): undefined;
    asDocumentLinks(items: ls.DocumentLink[] | undefined | null): code.DocumentLink[] | undefined;
    asColor(color: ls.Color): code.Color;
    asColorInformation(ci: ls.ColorInformation): code.ColorInformation;
    asColorInformations(colorPresentations: ls.ColorInformation[]): code.ColorInformation[];
    asColorInformations(colorPresentations: undefined | null): undefined;
    asColorInformations(colorInformation: ls.ColorInformation[] | undefined | null): code.ColorInformation[];
    asColorPresentation(cp: ls.ColorPresentation): code.ColorPresentation;
    asColorPresentations(colorPresentations: ls.ColorPresentation[]): code.ColorPresentation[];
    asColorPresentations(colorPresentations: undefined | null): undefined;
    asColorPresentations(colorPresentations: ls.ColorPresentation[] | undefined | null): undefined;
    asFoldingRangeKind(kind: string | undefined): code.FoldingRangeKind | undefined;
    asFoldingRange(r: ls.FoldingRange): code.FoldingRange;
    asFoldingRanges(foldingRanges: ls.FoldingRange[]): code.FoldingRange[];
    asFoldingRanges(foldingRanges: undefined | null): undefined;
    asFoldingRanges(foldingRanges: ls.FoldingRange[] | undefined | null): code.FoldingRange[] | undefined;
    asFoldingRanges(foldingRanges: ls.FoldingRange[] | undefined | null): code.FoldingRange[] | undefined;
    asSelectionRange(selectionRange: ls.SelectionRange): code.SelectionRange;
    asSelectionRanges(selectionRanges: ls.SelectionRange[]): code.SelectionRange[];
    asSelectionRanges(selectionRanges: undefined | null): undefined;
    asSelectionRanges(selectionRanges: ls.SelectionRange[] | undefined | null): code.SelectionRange[] | undefined;
    asSelectionRanges(selectionRanges: ls.SelectionRange[] | undefined | null): code.SelectionRange[] | undefined;
}
export interface URIConverter {
    (value: string): code.Uri;
}
export declare function createConverter(uriConverter?: URIConverter): Converter;
