"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var invariant = require('invariant');
var isCallingCanDrop = false;
var TargetMonitor = /** @class */ (function () {
    function TargetMonitor(manager) {
        this.internalMonitor = manager.getMonitor();
    }
    TargetMonitor.prototype.receiveHandlerId = function (targetId) {
        this.targetId = targetId;
    };
    TargetMonitor.prototype.canDrop = function () {
        invariant(!isCallingCanDrop, 'You may not call monitor.canDrop() inside your canDrop() implementation. ' +
            'Read more: http://react-dnd.github.io/react-dnd/docs-drop-target-monitor.html');
        try {
            isCallingCanDrop = true;
            return this.internalMonitor.canDropOnTarget(this.targetId);
        }
        finally {
            isCallingCanDrop = false;
        }
    };
    TargetMonitor.prototype.isOver = function (options) {
        return this.internalMonitor.isOverTarget(this.targetId, options);
    };
    TargetMonitor.prototype.getItemType = function () {
        return this.internalMonitor.getItemType();
    };
    TargetMonitor.prototype.getItem = function () {
        return this.internalMonitor.getItem();
    };
    TargetMonitor.prototype.getDropResult = function () {
        return this.internalMonitor.getDropResult();
    };
    TargetMonitor.prototype.didDrop = function () {
        return this.internalMonitor.didDrop();
    };
    TargetMonitor.prototype.getInitialClientOffset = function () {
        return this.internalMonitor.getInitialClientOffset();
    };
    TargetMonitor.prototype.getInitialSourceClientOffset = function () {
        return this.internalMonitor.getInitialSourceClientOffset();
    };
    TargetMonitor.prototype.getSourceClientOffset = function () {
        return this.internalMonitor.getSourceClientOffset();
    };
    TargetMonitor.prototype.getClientOffset = function () {
        return this.internalMonitor.getClientOffset();
    };
    TargetMonitor.prototype.getDifferenceFromInitialOffset = function () {
        return this.internalMonitor.getDifferenceFromInitialOffset();
    };
    return TargetMonitor;
}());
exports.TargetMonitor = TargetMonitor;
function createTargetMonitor(manager) {
    return new TargetMonitor(manager);
}
exports.default = createTargetMonitor;
