/* eslint-disable no-console */
import React from 'react';
import { storiesOf } from '@storybook/react';
import { withKnobs, boolean, number, select } from '@storybook/addon-knobs';
import SkeletonText from '../SkeletonText';
var widths = {
  '100%': '100%',
  '250px': '250px'
};

var props = function props() {
  return {
    heading: boolean('Skeleton text at a larger size (heading)'),
    paragraph: boolean('Use multiple lines of text (paragraph)'),
    lineCount: number('The number of lines in a paragraph (lineCount)', 3),
    width: select('Width (in px or %) of single line of text or max-width of paragraph lines (width)', widths, '100%')
  };
};

storiesOf('SkeletonText', module).addDecorator(withKnobs).add('Default', function () {
  return React.createElement("div", {
    style: {
      width: '300px'
    }
  }, React.createElement(SkeletonText, props()));
}, {
  info: {
    text: "\n            Skeleton states are used as a progressive loading state while the user waits for content to load.\n          "
  }
});