import React from 'react';
import DataTable, { Table, TableBody, TableCell, TableContainer, TableExpandHeader, TableExpandRow, TableExpandedRow, TableHead, TableHeader, TableRow } from '../../DataTable';
import { initialRows, headers } from './shared';
export default (function () {
  return React.createElement(DataTable, {
    rows: initialRows,
    headers: headers,
    render: function render(_ref) {
      var rows = _ref.rows,
          headers = _ref.headers,
          getHeaderProps = _ref.getHeaderProps,
          getRowProps = _ref.getRowProps;
      return React.createElement(TableContainer, {
        title: "DataTable with expansion"
      }, React.createElement(Table, null, React.createElement(TableHead, null, React.createElement(TableRow, null, React.createElement(TableExpandHeader, null), headers.map(function (header) {
        return React.createElement(TableHeader, getHeaderProps({
          header: header
        }), header.header);
      }))), React.createElement(TableBody, null, rows.map(function (row) {
        return React.createElement(React.Fragment, {
          key: row.id
        }, React.createElement(TableExpandRow, getRowProps({
          row: row
        }), row.cells.map(function (cell) {
          return React.createElement(TableCell, {
            key: cell.id
          }, cell.value);
        })), row.isExpanded && React.createElement(TableExpandedRow, null, React.createElement(TableCell, {
          colSpan: headers.length + 1
        }, React.createElement("h1", null, "Expandable row content"), React.createElement("p", null, "Description here"))));
      }))));
    }
  });
});