// Copyright 2019 Google LLC.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0
// 	protoc        v3.13.0
// source: google/cloud/vision/v1/product_search_service.proto

package vision

import (
	context "context"
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	status "google.golang.org/genproto/googleapis/rpc/status"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// Enumerates the possible states that the batch request can be in.
type BatchOperationMetadata_State int32

const (
	// Invalid.
	BatchOperationMetadata_STATE_UNSPECIFIED BatchOperationMetadata_State = 0
	// Request is actively being processed.
	BatchOperationMetadata_PROCESSING BatchOperationMetadata_State = 1
	// The request is done and at least one item has been successfully
	// processed.
	BatchOperationMetadata_SUCCESSFUL BatchOperationMetadata_State = 2
	// The request is done and no item has been successfully processed.
	BatchOperationMetadata_FAILED BatchOperationMetadata_State = 3
	// The request is done after the longrunning.Operations.CancelOperation has
	// been called by the user.  Any records that were processed before the
	// cancel command are output as specified in the request.
	BatchOperationMetadata_CANCELLED BatchOperationMetadata_State = 4
)

// Enum value maps for BatchOperationMetadata_State.
var (
	BatchOperationMetadata_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "PROCESSING",
		2: "SUCCESSFUL",
		3: "FAILED",
		4: "CANCELLED",
	}
	BatchOperationMetadata_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"PROCESSING":        1,
		"SUCCESSFUL":        2,
		"FAILED":            3,
		"CANCELLED":         4,
	}
)

func (x BatchOperationMetadata_State) Enum() *BatchOperationMetadata_State {
	p := new(BatchOperationMetadata_State)
	*p = x
	return p
}

func (x BatchOperationMetadata_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BatchOperationMetadata_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vision_v1_product_search_service_proto_enumTypes[0].Descriptor()
}

func (BatchOperationMetadata_State) Type() protoreflect.EnumType {
	return &file_google_cloud_vision_v1_product_search_service_proto_enumTypes[0]
}

func (x BatchOperationMetadata_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BatchOperationMetadata_State.Descriptor instead.
func (BatchOperationMetadata_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1_product_search_service_proto_rawDescGZIP(), []int{28, 0}
}

// A Product contains ReferenceImages.
type Product struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the product.
	//
	// Format is:
	// `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID`.
	//
	// This field is ignored when creating a product.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The user-provided name for this Product. Must not be empty. Must be at most
	// 4096 characters long.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// User-provided metadata to be stored with this product. Must be at most 4096
	// characters long.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Immutable. The category for the product identified by the reference image. This should
	// be either "homegoods-v2", "apparel-v2", or "toys-v2". The legacy categories
	// "homegoods", "apparel", and "toys" are still supported, but these should
	// not be used for new products.
	ProductCategory string `protobuf:"bytes,4,opt,name=product_category,json=productCategory,proto3" json:"product_category,omitempty"`
	// Key-value pairs that can be attached to a product. At query time,
	// constraints can be specified based on the product_labels.
	//
	// Note that integer values can be provided as strings, e.g. "1199". Only
	// strings with integer values can match a range-based restriction which is
	// to be supported soon.
	//
	// Multiple values can be assigned to the same key. One product may have up to
	// 500 product_labels.
	//
	// Notice that the total number of distinct product_labels over all products
	// in one ProductSet cannot exceed 1M, otherwise the product search pipeline
	// will refuse to work for that ProductSet.
	ProductLabels []*Product_KeyValue `protobuf:"bytes,5,rep,name=product_labels,json=productLabels,proto3" json:"product_labels,omitempty"`
}

func (x *Product) Reset() {
	*x = Product{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vision_v1_product_search_service_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Product) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Product) ProtoMessage() {}

func (x *Product) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vision_v1_product_search_service_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Product.ProtoReflect.Descriptor instead.
func (*Product) Descriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1_product_search_service_proto_rawDescGZIP(), []int{0}
}

func (x *Product) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Product) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Product) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Product) GetProductCategory() string {
	if x != nil {
		return x.ProductCategory
	}
	return ""
}

func (x *Product) GetProductLabels() []*Product_KeyValue {
	if x != nil {
		return x.ProductLabels
	}
	return nil
}

// A ProductSet contains Products. A ProductSet can contain a maximum of 1
// million reference images. If the limit is exceeded, periodic indexing will
// fail.
type ProductSet struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the ProductSet.
	//
	// Format is:
	// `projects/PROJECT_ID/locations/LOC_ID/productSets/PRODUCT_SET_ID`.
	//
	// This field is ignored when creating a ProductSet.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The user-provided name for this ProductSet. Must not be empty. Must be at
	// most 4096 characters long.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Output only. The time at which this ProductSet was last indexed. Query
	// results will reflect all updates before this time. If this ProductSet has
	// never been indexed, this timestamp is the default value
	// "1970-01-01T00:00:00Z".
	//
	// This field is ignored when creating a ProductSet.
	IndexTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=index_time,json=indexTime,proto3" json:"index_time,omitempty"`
	// Output only. If there was an error with indexing the product set, the field
	// is populated.
	//
	// This field is ignored when creating a ProductSet.
	IndexError *status.Status `protobuf:"bytes,4,opt,name=index_error,json=indexError,proto3" json:"index_error,omitempty"`
}

func (x *ProductSet) Reset() {
	*x = ProductSet{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vision_v1_product_search_service_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ProductSet) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProductSet) ProtoMessage() {}

func (x *ProductSet) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vision_v1_product_search_service_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProductSet.ProtoReflect.Descriptor instead.
func (*ProductSet) Descriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1_product_search_service_proto_rawDescGZIP(), []int{1}
}

func (x *ProductSet) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ProductSet) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *ProductSet) GetIndexTime() *timestamppb.Timestamp {
	if x != nil {
		return x.IndexTime
	}
	return nil
}

func (x *ProductSet) GetIndexError() *status.Status {
	if x != nil {
		return x.IndexError
	}
	return nil
}

// A `ReferenceImage` represents a product image and its associated metadata,
// such as bounding boxes.
type ReferenceImage struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the reference image.
	//
	// Format is:
	//
	// `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID/referenceImages/IMAGE_ID`.
	//
	// This field is ignored when creating a reference image.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The Google Cloud Storage URI of the reference image.
	//
	// The URI must start with `gs://`.
	Uri string `protobuf:"bytes,2,opt,name=uri,proto3" json:"uri,omitempty"`
	// Optional. Bounding polygons around the areas of interest in the reference image.
	// If this field is empty, the system will try to detect regions of
	// interest. At most 10 bounding polygons will be used.
	//
	// The provided shape is converted into a non-rotated rectangle. Once
	// converted, the small edge of the rectangle must be greater than or equal
	// to 300 pixels. The aspect ratio must be 1:4 or less (i.e. 1:3 is ok; 1:5
	// is not).
	BoundingPolys []*BoundingPoly `protobuf:"bytes,3,rep,name=bounding_polys,json=boundingPolys,proto3" json:"bounding_polys,omitempty"`
}

func (x *ReferenceImage) Reset() {
	*x = ReferenceImage{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vision_v1_product_search_service_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReferenceImage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReferenceImage) ProtoMessage() {}

func (x *ReferenceImage) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vision_v1_product_search_service_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReferenceImage.ProtoReflect.Descriptor instead.
func (*ReferenceImage) Descriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1_product_search_service_proto_rawDescGZIP(), []int{2}
}

func (x *ReferenceImage) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ReferenceImage) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

func (x *ReferenceImage) GetBoundingPolys() []*BoundingPoly {
	if x != nil {
		return x.BoundingPolys
	}
	return nil
}

// Request message for the `CreateProduct` method.
type CreateProductRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The project in which the Product should be created.
	//
	// Format is
	// `projects/PROJECT_ID/locations/LOC_ID`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The product to create.
	Product *Product `protobuf:"bytes,2,opt,name=product,proto3" json:"product,omitempty"`
	// A user-supplied resource id for this Product. If set, the server will
	// attempt to use this value as the resource id. If it is already in use, an
	// error is returned with code ALREADY_EXISTS. Must be at most 128 characters
	// long. It cannot contain the character `/`.
	ProductId string `protobuf:"bytes,3,opt,name=product_id,json=productId,proto3" json:"product_id,omitempty"`
}

func (x *CreateProductRequest) Reset() {
	*x = CreateProductRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vision_v1_product_search_service_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateProductRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateProductRequest) ProtoMessage() {}

func (x *CreateProductRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vision_v1_product_search_service_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateProductRequest.ProtoReflect.Descriptor instead.
func (*CreateProductRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1_product_search_service_proto_rawDescGZIP(), []int{3}
}

func (x *CreateProductRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateProductRequest) GetProduct() *Product {
	if x != nil {
		return x.Product
	}
	return nil
}

func (x *CreateProductRequest) GetProductId() string {
	if x != nil {
		return x.ProductId
	}
	return ""
}

// Request message for the `ListProducts` method.
type ListProductsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The project OR ProductSet from which Products should be listed.
	//
	// Format:
	// `projects/PROJECT_ID/locations/LOC_ID`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of items to return. Default 10, maximum 100.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The next_page_token returned from a previous List request, if any.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListProductsRequest) Reset() {
	*x = ListProductsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vision_v1_product_search_service_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListProductsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListProductsRequest) ProtoMessage() {}

func (x *ListProductsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vision_v1_product_search_service_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListProductsRequest.ProtoReflect.Descriptor instead.
func (*ListProductsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1_product_search_service_proto_rawDescGZIP(), []int{4}
}

func (x *ListProductsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListProductsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListProductsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for the `ListProducts` method.
type ListProductsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of products.
	Products []*Product `protobuf:"bytes,1,rep,name=products,proto3" json:"products,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListProductsResponse) Reset() {
	*x = ListProductsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vision_v1_product_search_service_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListProductsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListProductsResponse) ProtoMessage() {}

func (x *ListProductsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vision_v1_product_search_service_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListProductsResponse.ProtoReflect.Descriptor instead.
func (*ListProductsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1_product_search_service_proto_rawDescGZIP(), []int{5}
}

func (x *ListProductsResponse) GetProducts() []*Product {
	if x != nil {
		return x.Products
	}
	return nil
}

func (x *ListProductsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for the `GetProduct` method.
type GetProductRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the Product to get.
	//
	// Format is:
	// `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetProductRequest) Reset() {
	*x = GetProductRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vision_v1_product_search_service_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetProductRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetProductRequest) ProtoMessage() {}

func (x *GetProductRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vision_v1_product_search_service_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetProductRequest.ProtoReflect.Descriptor instead.
func (*GetProductRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1_product_search_service_proto_rawDescGZIP(), []int{6}
}

func (x *GetProductRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for the `UpdateProduct` method.
type UpdateProductRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The Product resource which replaces the one on the server.
	// product.name is immutable.
	Product *Product `protobuf:"bytes,1,opt,name=product,proto3" json:"product,omitempty"`
	// The [FieldMask][google.protobuf.FieldMask] that specifies which fields
	// to update.
	// If update_mask isn't specified, all mutable fields are to be updated.
	// Valid mask paths include `product_labels`, `display_name`, and
	// `description`.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateProductRequest) Reset() {
	*x = UpdateProductRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vision_v1_product_search_service_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateProductRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateProductRequest) ProtoMessage() {}

func (x *UpdateProductRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vision_v1_product_search_service_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateProductRequest.ProtoReflect.Descriptor instead.
func (*UpdateProductRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1_product_search_service_proto_rawDescGZIP(), []int{7}
}

func (x *UpdateProductRequest) GetProduct() *Product {
	if x != nil {
		return x.Product
	}
	return nil
}

func (x *UpdateProductRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for the `DeleteProduct` method.
type DeleteProductRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of product to delete.
	//
	// Format is:
	// `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteProductRequest) Reset() {
	*x = DeleteProductRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vision_v1_product_search_service_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteProductRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteProductRequest) ProtoMessage() {}

func (x *DeleteProductRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vision_v1_product_search_service_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteProductRequest.ProtoReflect.Descriptor instead.
func (*DeleteProductRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1_product_search_service_proto_rawDescGZIP(), []int{8}
}

func (x *DeleteProductRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for the `CreateProductSet` method.
type CreateProductSetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The project in which the ProductSet should be created.
	//
	// Format is `projects/PROJECT_ID/locations/LOC_ID`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The ProductSet to create.
	ProductSet *ProductSet `protobuf:"bytes,2,opt,name=product_set,json=productSet,proto3" json:"product_set,omitempty"`
	// A user-supplied resource id for this ProductSet. If set, the server will
	// attempt to use this value as the resource id. If it is already in use, an
	// error is returned with code ALREADY_EXISTS. Must be at most 128 characters
	// long. It cannot contain the character `/`.
	ProductSetId string `protobuf:"bytes,3,opt,name=product_set_id,json=productSetId,proto3" json:"product_set_id,omitempty"`
}

func (x *CreateProductSetRequest) Reset() {
	*x = CreateProductSetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vision_v1_product_search_service_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateProductSetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateProductSetRequest) ProtoMessage() {}

func (x *CreateProductSetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vision_v1_product_search_service_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateProductSetRequest.ProtoReflect.Descriptor instead.
func (*CreateProductSetRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1_product_search_service_proto_rawDescGZIP(), []int{9}
}

func (x *CreateProductSetRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateProductSetRequest) GetProductSet() *ProductSet {
	if x != nil {
		return x.ProductSet
	}
	return nil
}

func (x *CreateProductSetRequest) GetProductSetId() string {
	if x != nil {
		return x.ProductSetId
	}
	return ""
}

// Request message for the `ListProductSets` method.
type ListProductSetsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The project from which ProductSets should be listed.
	//
	// Format is `projects/PROJECT_ID/locations/LOC_ID`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of items to return. Default 10, maximum 100.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The next_page_token returned from a previous List request, if any.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListProductSetsRequest) Reset() {
	*x = ListProductSetsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vision_v1_product_search_service_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListProductSetsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListProductSetsRequest) ProtoMessage() {}

func (x *ListProductSetsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vision_v1_product_search_service_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListProductSetsRequest.ProtoReflect.Descriptor instead.
func (*ListProductSetsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1_product_search_service_proto_rawDescGZIP(), []int{10}
}

func (x *ListProductSetsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListProductSetsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListProductSetsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for the `ListProductSets` method.
type ListProductSetsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of ProductSets.
	ProductSets []*ProductSet `protobuf:"bytes,1,rep,name=product_sets,json=productSets,proto3" json:"product_sets,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListProductSetsResponse) Reset() {
	*x = ListProductSetsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vision_v1_product_search_service_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListProductSetsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListProductSetsResponse) ProtoMessage() {}

func (x *ListProductSetsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vision_v1_product_search_service_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListProductSetsResponse.ProtoReflect.Descriptor instead.
func (*ListProductSetsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1_product_search_service_proto_rawDescGZIP(), []int{11}
}

func (x *ListProductSetsResponse) GetProductSets() []*ProductSet {
	if x != nil {
		return x.ProductSets
	}
	return nil
}

func (x *ListProductSetsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for the `GetProductSet` method.
type GetProductSetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the ProductSet to get.
	//
	// Format is:
	// `projects/PROJECT_ID/locations/LOG_ID/productSets/PRODUCT_SET_ID`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetProductSetRequest) Reset() {
	*x = GetProductSetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vision_v1_product_search_service_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetProductSetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetProductSetRequest) ProtoMessage() {}

func (x *GetProductSetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vision_v1_product_search_service_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetProductSetRequest.ProtoReflect.Descriptor instead.
func (*GetProductSetRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1_product_search_service_proto_rawDescGZIP(), []int{12}
}

func (x *GetProductSetRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for the `UpdateProductSet` method.
type UpdateProductSetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The ProductSet resource which replaces the one on the server.
	ProductSet *ProductSet `protobuf:"bytes,1,opt,name=product_set,json=productSet,proto3" json:"product_set,omitempty"`
	// The [FieldMask][google.protobuf.FieldMask] that specifies which fields to
	// update.
	// If update_mask isn't specified, all mutable fields are to be updated.
	// Valid mask path is `display_name`.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateProductSetRequest) Reset() {
	*x = UpdateProductSetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vision_v1_product_search_service_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateProductSetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateProductSetRequest) ProtoMessage() {}

func (x *UpdateProductSetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vision_v1_product_search_service_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateProductSetRequest.ProtoReflect.Descriptor instead.
func (*UpdateProductSetRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1_product_search_service_proto_rawDescGZIP(), []int{13}
}

func (x *UpdateProductSetRequest) GetProductSet() *ProductSet {
	if x != nil {
		return x.ProductSet
	}
	return nil
}

func (x *UpdateProductSetRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for the `DeleteProductSet` method.
type DeleteProductSetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the ProductSet to delete.
	//
	// Format is:
	// `projects/PROJECT_ID/locations/LOC_ID/productSets/PRODUCT_SET_ID`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteProductSetRequest) Reset() {
	*x = DeleteProductSetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vision_v1_product_search_service_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteProductSetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteProductSetRequest) ProtoMessage() {}

func (x *DeleteProductSetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vision_v1_product_search_service_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteProductSetRequest.ProtoReflect.Descriptor instead.
func (*DeleteProductSetRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1_product_search_service_proto_rawDescGZIP(), []int{14}
}

func (x *DeleteProductSetRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for the `CreateReferenceImage` method.
type CreateReferenceImageRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the product in which to create the reference image.
	//
	// Format is
	// `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The reference image to create.
	// If an image ID is specified, it is ignored.
	ReferenceImage *ReferenceImage `protobuf:"bytes,2,opt,name=reference_image,json=referenceImage,proto3" json:"reference_image,omitempty"`
	// A user-supplied resource id for the ReferenceImage to be added. If set,
	// the server will attempt to use this value as the resource id. If it is
	// already in use, an error is returned with code ALREADY_EXISTS. Must be at
	// most 128 characters long. It cannot contain the character `/`.
	ReferenceImageId string `protobuf:"bytes,3,opt,name=reference_image_id,json=referenceImageId,proto3" json:"reference_image_id,omitempty"`
}

func (x *CreateReferenceImageRequest) Reset() {
	*x = CreateReferenceImageRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vision_v1_product_search_service_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateReferenceImageRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateReferenceImageRequest) ProtoMessage() {}

func (x *CreateReferenceImageRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vision_v1_product_search_service_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateReferenceImageRequest.ProtoReflect.Descriptor instead.
func (*CreateReferenceImageRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1_product_search_service_proto_rawDescGZIP(), []int{15}
}

func (x *CreateReferenceImageRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateReferenceImageRequest) GetReferenceImage() *ReferenceImage {
	if x != nil {
		return x.ReferenceImage
	}
	return nil
}

func (x *CreateReferenceImageRequest) GetReferenceImageId() string {
	if x != nil {
		return x.ReferenceImageId
	}
	return ""
}

// Request message for the `ListReferenceImages` method.
type ListReferenceImagesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the product containing the reference images.
	//
	// Format is
	// `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of items to return. Default 10, maximum 100.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A token identifying a page of results to be returned. This is the value
	// of `nextPageToken` returned in a previous reference image list request.
	//
	// Defaults to the first page if not specified.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListReferenceImagesRequest) Reset() {
	*x = ListReferenceImagesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vision_v1_product_search_service_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListReferenceImagesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListReferenceImagesRequest) ProtoMessage() {}

func (x *ListReferenceImagesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vision_v1_product_search_service_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListReferenceImagesRequest.ProtoReflect.Descriptor instead.
func (*ListReferenceImagesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1_product_search_service_proto_rawDescGZIP(), []int{16}
}

func (x *ListReferenceImagesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListReferenceImagesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListReferenceImagesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for the `ListReferenceImages` method.
type ListReferenceImagesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of reference images.
	ReferenceImages []*ReferenceImage `protobuf:"bytes,1,rep,name=reference_images,json=referenceImages,proto3" json:"reference_images,omitempty"`
	// The maximum number of items to return. Default 10, maximum 100.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The next_page_token returned from a previous List request, if any.
	NextPageToken string `protobuf:"bytes,3,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListReferenceImagesResponse) Reset() {
	*x = ListReferenceImagesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vision_v1_product_search_service_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListReferenceImagesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListReferenceImagesResponse) ProtoMessage() {}

func (x *ListReferenceImagesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vision_v1_product_search_service_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListReferenceImagesResponse.ProtoReflect.Descriptor instead.
func (*ListReferenceImagesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1_product_search_service_proto_rawDescGZIP(), []int{17}
}

func (x *ListReferenceImagesResponse) GetReferenceImages() []*ReferenceImage {
	if x != nil {
		return x.ReferenceImages
	}
	return nil
}

func (x *ListReferenceImagesResponse) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListReferenceImagesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for the `GetReferenceImage` method.
type GetReferenceImageRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the ReferenceImage to get.
	//
	// Format is:
	//
	// `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID/referenceImages/IMAGE_ID`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetReferenceImageRequest) Reset() {
	*x = GetReferenceImageRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vision_v1_product_search_service_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetReferenceImageRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetReferenceImageRequest) ProtoMessage() {}

func (x *GetReferenceImageRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vision_v1_product_search_service_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetReferenceImageRequest.ProtoReflect.Descriptor instead.
func (*GetReferenceImageRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1_product_search_service_proto_rawDescGZIP(), []int{18}
}

func (x *GetReferenceImageRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for the `DeleteReferenceImage` method.
type DeleteReferenceImageRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the reference image to delete.
	//
	// Format is:
	//
	// `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID/referenceImages/IMAGE_ID`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteReferenceImageRequest) Reset() {
	*x = DeleteReferenceImageRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vision_v1_product_search_service_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteReferenceImageRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteReferenceImageRequest) ProtoMessage() {}

func (x *DeleteReferenceImageRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vision_v1_product_search_service_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteReferenceImageRequest.ProtoReflect.Descriptor instead.
func (*DeleteReferenceImageRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1_product_search_service_proto_rawDescGZIP(), []int{19}
}

func (x *DeleteReferenceImageRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for the `AddProductToProductSet` method.
type AddProductToProductSetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name for the ProductSet to modify.
	//
	// Format is:
	// `projects/PROJECT_ID/locations/LOC_ID/productSets/PRODUCT_SET_ID`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The resource name for the Product to be added to this ProductSet.
	//
	// Format is:
	// `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID`
	Product string `protobuf:"bytes,2,opt,name=product,proto3" json:"product,omitempty"`
}

func (x *AddProductToProductSetRequest) Reset() {
	*x = AddProductToProductSetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vision_v1_product_search_service_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AddProductToProductSetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddProductToProductSetRequest) ProtoMessage() {}

func (x *AddProductToProductSetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vision_v1_product_search_service_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddProductToProductSetRequest.ProtoReflect.Descriptor instead.
func (*AddProductToProductSetRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1_product_search_service_proto_rawDescGZIP(), []int{20}
}

func (x *AddProductToProductSetRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *AddProductToProductSetRequest) GetProduct() string {
	if x != nil {
		return x.Product
	}
	return ""
}

// Request message for the `RemoveProductFromProductSet` method.
type RemoveProductFromProductSetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name for the ProductSet to modify.
	//
	// Format is:
	// `projects/PROJECT_ID/locations/LOC_ID/productSets/PRODUCT_SET_ID`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The resource name for the Product to be removed from this ProductSet.
	//
	// Format is:
	// `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID`
	Product string `protobuf:"bytes,2,opt,name=product,proto3" json:"product,omitempty"`
}

func (x *RemoveProductFromProductSetRequest) Reset() {
	*x = RemoveProductFromProductSetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vision_v1_product_search_service_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RemoveProductFromProductSetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RemoveProductFromProductSetRequest) ProtoMessage() {}

func (x *RemoveProductFromProductSetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vision_v1_product_search_service_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RemoveProductFromProductSetRequest.ProtoReflect.Descriptor instead.
func (*RemoveProductFromProductSetRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1_product_search_service_proto_rawDescGZIP(), []int{21}
}

func (x *RemoveProductFromProductSetRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *RemoveProductFromProductSetRequest) GetProduct() string {
	if x != nil {
		return x.Product
	}
	return ""
}

// Request message for the `ListProductsInProductSet` method.
type ListProductsInProductSetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The ProductSet resource for which to retrieve Products.
	//
	// Format is:
	// `projects/PROJECT_ID/locations/LOC_ID/productSets/PRODUCT_SET_ID`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The maximum number of items to return. Default 10, maximum 100.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The next_page_token returned from a previous List request, if any.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListProductsInProductSetRequest) Reset() {
	*x = ListProductsInProductSetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vision_v1_product_search_service_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListProductsInProductSetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListProductsInProductSetRequest) ProtoMessage() {}

func (x *ListProductsInProductSetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vision_v1_product_search_service_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListProductsInProductSetRequest.ProtoReflect.Descriptor instead.
func (*ListProductsInProductSetRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1_product_search_service_proto_rawDescGZIP(), []int{22}
}

func (x *ListProductsInProductSetRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ListProductsInProductSetRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListProductsInProductSetRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for the `ListProductsInProductSet` method.
type ListProductsInProductSetResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of Products.
	Products []*Product `protobuf:"bytes,1,rep,name=products,proto3" json:"products,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListProductsInProductSetResponse) Reset() {
	*x = ListProductsInProductSetResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vision_v1_product_search_service_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListProductsInProductSetResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListProductsInProductSetResponse) ProtoMessage() {}

func (x *ListProductsInProductSetResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vision_v1_product_search_service_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListProductsInProductSetResponse.ProtoReflect.Descriptor instead.
func (*ListProductsInProductSetResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1_product_search_service_proto_rawDescGZIP(), []int{23}
}

func (x *ListProductsInProductSetResponse) GetProducts() []*Product {
	if x != nil {
		return x.Products
	}
	return nil
}

func (x *ListProductsInProductSetResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The Google Cloud Storage location for a csv file which preserves a list of
// ImportProductSetRequests in each line.
type ImportProductSetsGcsSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Google Cloud Storage URI of the input csv file.
	//
	// The URI must start with `gs://`.
	//
	// The format of the input csv file should be one image per line.
	// In each line, there are 8 columns.
	//
	// 1.  image-uri
	// 2.  image-id
	// 3.  product-set-id
	// 4.  product-id
	// 5.  product-category
	// 6.  product-display-name
	// 7.  labels
	// 8.  bounding-poly
	//
	// The `image-uri`, `product-set-id`, `product-id`, and `product-category`
	// columns are required. All other columns are optional.
	//
	// If the `ProductSet` or `Product` specified by the `product-set-id` and
	// `product-id` values does not exist, then the system will create a new
	// `ProductSet` or `Product` for the image. In this case, the
	// `product-display-name` column refers to
	// [display_name][google.cloud.vision.v1.Product.display_name], the
	// `product-category` column refers to
	// [product_category][google.cloud.vision.v1.Product.product_category], and the
	// `labels` column refers to [product_labels][google.cloud.vision.v1.Product.product_labels].
	//
	// The `image-id` column is optional but must be unique if provided. If it is
	// empty, the system will automatically assign a unique id to the image.
	//
	// The `product-display-name` column is optional. If it is empty, the system
	// sets the [display_name][google.cloud.vision.v1.Product.display_name] field for the product to a
	// space (" "). You can update the `display_name` later by using the API.
	//
	// If a `Product` with the specified `product-id` already exists, then the
	// system ignores the `product-display-name`, `product-category`, and `labels`
	// columns.
	//
	// The `labels` column (optional) is a line containing a list of
	// comma-separated key-value pairs, in the following format:
	//
	//     "key_1=value_1,key_2=value_2,...,key_n=value_n"
	//
	// The `bounding-poly` column (optional) identifies one region of
	// interest from the image in the same manner as `CreateReferenceImage`. If
	// you do not specify the `bounding-poly` column, then the system will try to
	// detect regions of interest automatically.
	//
	// At most one `bounding-poly` column is allowed per line. If the image
	// contains multiple regions of interest, add a line to the CSV file that
	// includes the same product information, and the `bounding-poly` values for
	// each region of interest.
	//
	// The `bounding-poly` column must contain an even number of comma-separated
	// numbers, in the format "p1_x,p1_y,p2_x,p2_y,...,pn_x,pn_y". Use
	// non-negative integers for absolute bounding polygons, and float values
	// in [0, 1] for normalized bounding polygons.
	//
	// The system will resize the image if the image resolution is too
	// large to process (larger than 20MP).
	CsvFileUri string `protobuf:"bytes,1,opt,name=csv_file_uri,json=csvFileUri,proto3" json:"csv_file_uri,omitempty"`
}

func (x *ImportProductSetsGcsSource) Reset() {
	*x = ImportProductSetsGcsSource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vision_v1_product_search_service_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImportProductSetsGcsSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportProductSetsGcsSource) ProtoMessage() {}

func (x *ImportProductSetsGcsSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vision_v1_product_search_service_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportProductSetsGcsSource.ProtoReflect.Descriptor instead.
func (*ImportProductSetsGcsSource) Descriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1_product_search_service_proto_rawDescGZIP(), []int{24}
}

func (x *ImportProductSetsGcsSource) GetCsvFileUri() string {
	if x != nil {
		return x.CsvFileUri
	}
	return ""
}

// The input content for the `ImportProductSets` method.
type ImportProductSetsInputConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The source of the input.
	//
	// Types that are assignable to Source:
	//	*ImportProductSetsInputConfig_GcsSource
	Source isImportProductSetsInputConfig_Source `protobuf_oneof:"source"`
}

func (x *ImportProductSetsInputConfig) Reset() {
	*x = ImportProductSetsInputConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vision_v1_product_search_service_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImportProductSetsInputConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportProductSetsInputConfig) ProtoMessage() {}

func (x *ImportProductSetsInputConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vision_v1_product_search_service_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportProductSetsInputConfig.ProtoReflect.Descriptor instead.
func (*ImportProductSetsInputConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1_product_search_service_proto_rawDescGZIP(), []int{25}
}

func (m *ImportProductSetsInputConfig) GetSource() isImportProductSetsInputConfig_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (x *ImportProductSetsInputConfig) GetGcsSource() *ImportProductSetsGcsSource {
	if x, ok := x.GetSource().(*ImportProductSetsInputConfig_GcsSource); ok {
		return x.GcsSource
	}
	return nil
}

type isImportProductSetsInputConfig_Source interface {
	isImportProductSetsInputConfig_Source()
}

type ImportProductSetsInputConfig_GcsSource struct {
	// The Google Cloud Storage location for a csv file which preserves a list
	// of ImportProductSetRequests in each line.
	GcsSource *ImportProductSetsGcsSource `protobuf:"bytes,1,opt,name=gcs_source,json=gcsSource,proto3,oneof"`
}

func (*ImportProductSetsInputConfig_GcsSource) isImportProductSetsInputConfig_Source() {}

// Request message for the `ImportProductSets` method.
type ImportProductSetsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The project in which the ProductSets should be imported.
	//
	// Format is `projects/PROJECT_ID/locations/LOC_ID`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The input content for the list of requests.
	InputConfig *ImportProductSetsInputConfig `protobuf:"bytes,2,opt,name=input_config,json=inputConfig,proto3" json:"input_config,omitempty"`
}

func (x *ImportProductSetsRequest) Reset() {
	*x = ImportProductSetsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vision_v1_product_search_service_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImportProductSetsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportProductSetsRequest) ProtoMessage() {}

func (x *ImportProductSetsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vision_v1_product_search_service_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportProductSetsRequest.ProtoReflect.Descriptor instead.
func (*ImportProductSetsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1_product_search_service_proto_rawDescGZIP(), []int{26}
}

func (x *ImportProductSetsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ImportProductSetsRequest) GetInputConfig() *ImportProductSetsInputConfig {
	if x != nil {
		return x.InputConfig
	}
	return nil
}

// Response message for the `ImportProductSets` method.
//
// This message is returned by the
// [google.longrunning.Operations.GetOperation][google.longrunning.Operations.GetOperation] method in the returned
// [google.longrunning.Operation.response][google.longrunning.Operation.response] field.
type ImportProductSetsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of reference_images that are imported successfully.
	ReferenceImages []*ReferenceImage `protobuf:"bytes,1,rep,name=reference_images,json=referenceImages,proto3" json:"reference_images,omitempty"`
	// The rpc status for each ImportProductSet request, including both successes
	// and errors.
	//
	// The number of statuses here matches the number of lines in the csv file,
	// and statuses[i] stores the success or failure status of processing the i-th
	// line of the csv, starting from line 0.
	Statuses []*status.Status `protobuf:"bytes,2,rep,name=statuses,proto3" json:"statuses,omitempty"`
}

func (x *ImportProductSetsResponse) Reset() {
	*x = ImportProductSetsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vision_v1_product_search_service_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImportProductSetsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportProductSetsResponse) ProtoMessage() {}

func (x *ImportProductSetsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vision_v1_product_search_service_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportProductSetsResponse.ProtoReflect.Descriptor instead.
func (*ImportProductSetsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1_product_search_service_proto_rawDescGZIP(), []int{27}
}

func (x *ImportProductSetsResponse) GetReferenceImages() []*ReferenceImage {
	if x != nil {
		return x.ReferenceImages
	}
	return nil
}

func (x *ImportProductSetsResponse) GetStatuses() []*status.Status {
	if x != nil {
		return x.Statuses
	}
	return nil
}

// Metadata for the batch operations such as the current state.
//
// This is included in the `metadata` field of the `Operation` returned by the
// `GetOperation` call of the `google::longrunning::Operations` service.
type BatchOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The current state of the batch operation.
	State BatchOperationMetadata_State `protobuf:"varint,1,opt,name=state,proto3,enum=google.cloud.vision.v1.BatchOperationMetadata_State" json:"state,omitempty"`
	// The time when the batch request was submitted to the server.
	SubmitTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=submit_time,json=submitTime,proto3" json:"submit_time,omitempty"`
	// The time when the batch request is finished and
	// [google.longrunning.Operation.done][google.longrunning.Operation.done] is set to true.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
}

func (x *BatchOperationMetadata) Reset() {
	*x = BatchOperationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vision_v1_product_search_service_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchOperationMetadata) ProtoMessage() {}

func (x *BatchOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vision_v1_product_search_service_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchOperationMetadata.ProtoReflect.Descriptor instead.
func (*BatchOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1_product_search_service_proto_rawDescGZIP(), []int{28}
}

func (x *BatchOperationMetadata) GetState() BatchOperationMetadata_State {
	if x != nil {
		return x.State
	}
	return BatchOperationMetadata_STATE_UNSPECIFIED
}

func (x *BatchOperationMetadata) GetSubmitTime() *timestamppb.Timestamp {
	if x != nil {
		return x.SubmitTime
	}
	return nil
}

func (x *BatchOperationMetadata) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

// Config to control which ProductSet contains the Products to be deleted.
type ProductSetPurgeConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ProductSet that contains the Products to delete. If a Product is a
	// member of product_set_id in addition to other ProductSets, the Product will
	// still be deleted.
	ProductSetId string `protobuf:"bytes,1,opt,name=product_set_id,json=productSetId,proto3" json:"product_set_id,omitempty"`
}

func (x *ProductSetPurgeConfig) Reset() {
	*x = ProductSetPurgeConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vision_v1_product_search_service_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ProductSetPurgeConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProductSetPurgeConfig) ProtoMessage() {}

func (x *ProductSetPurgeConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vision_v1_product_search_service_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProductSetPurgeConfig.ProtoReflect.Descriptor instead.
func (*ProductSetPurgeConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1_product_search_service_proto_rawDescGZIP(), []int{29}
}

func (x *ProductSetPurgeConfig) GetProductSetId() string {
	if x != nil {
		return x.ProductSetId
	}
	return ""
}

// Request message for the `PurgeProducts` method.
type PurgeProductsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Products to delete.
	//
	// Types that are assignable to Target:
	//	*PurgeProductsRequest_ProductSetPurgeConfig
	//	*PurgeProductsRequest_DeleteOrphanProducts
	Target isPurgeProductsRequest_Target `protobuf_oneof:"target"`
	// Required. The project and location in which the Products should be deleted.
	//
	// Format is `projects/PROJECT_ID/locations/LOC_ID`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The default value is false. Override this value to true to actually perform
	// the purge.
	Force bool `protobuf:"varint,4,opt,name=force,proto3" json:"force,omitempty"`
}

func (x *PurgeProductsRequest) Reset() {
	*x = PurgeProductsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vision_v1_product_search_service_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PurgeProductsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PurgeProductsRequest) ProtoMessage() {}

func (x *PurgeProductsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vision_v1_product_search_service_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PurgeProductsRequest.ProtoReflect.Descriptor instead.
func (*PurgeProductsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1_product_search_service_proto_rawDescGZIP(), []int{30}
}

func (m *PurgeProductsRequest) GetTarget() isPurgeProductsRequest_Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (x *PurgeProductsRequest) GetProductSetPurgeConfig() *ProductSetPurgeConfig {
	if x, ok := x.GetTarget().(*PurgeProductsRequest_ProductSetPurgeConfig); ok {
		return x.ProductSetPurgeConfig
	}
	return nil
}

func (x *PurgeProductsRequest) GetDeleteOrphanProducts() bool {
	if x, ok := x.GetTarget().(*PurgeProductsRequest_DeleteOrphanProducts); ok {
		return x.DeleteOrphanProducts
	}
	return false
}

func (x *PurgeProductsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *PurgeProductsRequest) GetForce() bool {
	if x != nil {
		return x.Force
	}
	return false
}

type isPurgeProductsRequest_Target interface {
	isPurgeProductsRequest_Target()
}

type PurgeProductsRequest_ProductSetPurgeConfig struct {
	// Specify which ProductSet contains the Products to be deleted.
	ProductSetPurgeConfig *ProductSetPurgeConfig `protobuf:"bytes,2,opt,name=product_set_purge_config,json=productSetPurgeConfig,proto3,oneof"`
}

type PurgeProductsRequest_DeleteOrphanProducts struct {
	// If delete_orphan_products is true, all Products that are not in any
	// ProductSet will be deleted.
	DeleteOrphanProducts bool `protobuf:"varint,3,opt,name=delete_orphan_products,json=deleteOrphanProducts,proto3,oneof"`
}

func (*PurgeProductsRequest_ProductSetPurgeConfig) isPurgeProductsRequest_Target() {}

func (*PurgeProductsRequest_DeleteOrphanProducts) isPurgeProductsRequest_Target() {}

// A product label represented as a key-value pair.
type Product_KeyValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The key of the label attached to the product. Cannot be empty and cannot
	// exceed 128 bytes.
	Key string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// The value of the label attached to the product. Cannot be empty and
	// cannot exceed 128 bytes.
	Value string `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *Product_KeyValue) Reset() {
	*x = Product_KeyValue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vision_v1_product_search_service_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Product_KeyValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Product_KeyValue) ProtoMessage() {}

func (x *Product_KeyValue) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vision_v1_product_search_service_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Product_KeyValue.ProtoReflect.Descriptor instead.
func (*Product_KeyValue) Descriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1_product_search_service_proto_rawDescGZIP(), []int{0, 0}
}

func (x *Product_KeyValue) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *Product_KeyValue) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

var File_google_cloud_vision_v1_product_search_service_proto protoreflect.FileDescriptor

var file_google_cloud_vision_v1_product_search_service_proto_rawDesc = []byte{
	0x0a, 0x33, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74,
	0x5f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x16, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x25, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2f, 0x76, 0x31, 0x2f, 0x67, 0x65, 0x6f, 0x6d, 0x65, 0x74, 0x72,
	0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d,
	0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64,
	0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xf7, 0x02, 0x0a, 0x07, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63,
	0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64,
	0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2e, 0x0a, 0x10, 0x70, 0x72,
	0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x0f, 0x70, 0x72, 0x6f, 0x64, 0x75,
	0x63, 0x74, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x12, 0x4f, 0x0a, 0x0e, 0x70, 0x72,
	0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x05, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x6f, 0x64,
	0x75, 0x63, 0x74, 0x2e, 0x4b, 0x65, 0x79, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0d, 0x70, 0x72,
	0x6f, 0x64, 0x75, 0x63, 0x74, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x1a, 0x32, 0x0a, 0x08, 0x4b,
	0x65, 0x79, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a,
	0x5e, 0xea, 0x41, 0x5b, 0x0a, 0x1d, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x64,
	0x75, 0x63, 0x74, 0x12, 0x3a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x70, 0x72, 0x6f,
	0x64, 0x75, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x7d, 0x22,
	0xa7, 0x02, 0x0a, 0x0a, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x53, 0x65, 0x74, 0x12, 0x12,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61,
	0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x3e, 0x0a, 0x0a, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x69, 0x6e, 0x64, 0x65,
	0x78, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x38, 0x0a, 0x0b, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x5f, 0x65,
	0x72, 0x72, 0x6f, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0a, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x3a,
	0x68, 0xea, 0x41, 0x65, 0x0a, 0x20, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x64,
	0x75, 0x63, 0x74, 0x53, 0x65, 0x74, 0x12, 0x41, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f,
	0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x53, 0x65, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f,
	0x64, 0x75, 0x63, 0x74, 0x5f, 0x73, 0x65, 0x74, 0x7d, 0x22, 0x98, 0x02, 0x0a, 0x0e, 0x52, 0x65,
	0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x12, 0x12, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x15, 0x0a, 0x03, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x03, 0x75, 0x72, 0x69, 0x12, 0x50, 0x0a, 0x0e, 0x62, 0x6f, 0x75, 0x6e, 0x64,
	0x69, 0x6e, 0x67, 0x5f, 0x70, 0x6f, 0x6c, 0x79, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e,
	0x67, 0x50, 0x6f, 0x6c, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x62, 0x6f, 0x75, 0x6e,
	0x64, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x79, 0x73, 0x3a, 0x88, 0x01, 0xea, 0x41, 0x84, 0x01,
	0x0a, 0x24, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63,
	0x65, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x12, 0x5c, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f,
	0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63,
	0x74, 0x7d, 0x2f, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x49, 0x6d, 0x61, 0x67,
	0x65, 0x73, 0x2f, 0x7b, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x69, 0x6d,
	0x61, 0x67, 0x65, 0x7d, 0x22, 0xb8, 0x01, 0x0a, 0x14, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x50,
	0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x12, 0x3e, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x6f, 0x64, 0x75,
	0x63, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74,
	0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x49, 0x64, 0x22,
	0x94, 0x01, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a,
	0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70,
	0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x7b, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72,
	0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3b,
	0x0a, 0x08, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63,
	0x74, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e,
	0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x22, 0x4e, 0x0a, 0x11, 0x47, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x39, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x25, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1f, 0x0a, 0x1d,
	0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x22, 0x93, 0x01, 0x0a, 0x14, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x50, 0x72,
	0x6f, 0x64, 0x75, 0x63, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3e, 0x0a, 0x07,
	0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x12, 0x3b, 0x0a, 0x0b,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x51, 0x0a, 0x14, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x39, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x25, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1f, 0x0a, 0x1d, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50,
	0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xcc, 0x01, 0x0a,
	0x17, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x53, 0x65,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23,
	0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x48, 0x0a, 0x0b, 0x70,
	0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x73, 0x65, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63,
	0x74, 0x53, 0x65, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x70, 0x72, 0x6f, 0x64, 0x75,
	0x63, 0x74, 0x53, 0x65, 0x74, 0x12, 0x24, 0x0a, 0x0e, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74,
	0x5f, 0x73, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x70,
	0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x53, 0x65, 0x74, 0x49, 0x64, 0x22, 0x97, 0x01, 0x0a, 0x16,
	0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x53, 0x65, 0x74, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61,
	0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x88, 0x01, 0x0a, 0x17, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72,
	0x6f, 0x64, 0x75, 0x63, 0x74, 0x53, 0x65, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x45, 0x0a, 0x0c, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x73, 0x65, 0x74,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x2e, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x53, 0x65, 0x74, 0x52, 0x0b, 0x70, 0x72, 0x6f,
	0x64, 0x75, 0x63, 0x74, 0x53, 0x65, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74,
	0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x22, 0x54, 0x0a, 0x14, 0x47, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x53, 0x65,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3c, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x28, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x22, 0x0a, 0x20,
	0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x53, 0x65, 0x74,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xa0, 0x01, 0x0a, 0x17, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x53, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x48, 0x0a, 0x0b, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x73, 0x65,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x2e, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x53, 0x65, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0a, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x53, 0x65, 0x74, 0x12, 0x3b, 0x0a, 0x0b,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x57, 0x0a, 0x17, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x53, 0x65, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x3c, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x28, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x22, 0x0a, 0x20, 0x76, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x53, 0x65, 0x74, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x22, 0xe0, 0x01, 0x0a, 0x1b, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x65, 0x66,
	0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x3d, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x25, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1f, 0x0a, 0x1d, 0x76, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x12, 0x54, 0x0a, 0x0f, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x69,
	0x6d, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x49, 0x6d, 0x61,
	0x67, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x12, 0x2c, 0x0a, 0x12, 0x72, 0x65, 0x66, 0x65, 0x72,
	0x65, 0x6e, 0x63, 0x65, 0x5f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x10, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x49, 0x6d,
	0x61, 0x67, 0x65, 0x49, 0x64, 0x22, 0x97, 0x01, 0x0a, 0x1a, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65,
	0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x3d, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x25, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1f, 0x0a, 0x1d, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65,
	0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22,
	0xb5, 0x01, 0x0a, 0x1b, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63,
	0x65, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x51, 0x0a, 0x10, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x69, 0x6d, 0x61,
	0x67, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x2e, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x49, 0x6d, 0x61, 0x67,
	0x65, 0x52, 0x0f, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x49, 0x6d, 0x61, 0x67,
	0x65, 0x73, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12,
	0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x5c, 0x0a, 0x18, 0x47, 0x65, 0x74, 0x52, 0x65,
	0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x26, 0x0a, 0x24, 0x76, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x5f, 0x0a, 0x1b, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52,
	0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x26, 0x0a, 0x24, 0x76, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x49, 0x6d, 0x61, 0x67, 0x65,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x9e, 0x01, 0x0a, 0x1d, 0x41, 0x64, 0x64, 0x50, 0x72,
	0x6f, 0x64, 0x75, 0x63, 0x74, 0x54, 0x6f, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x53, 0x65,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3c, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x28, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x22, 0x0a, 0x20,
	0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x53, 0x65, 0x74,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x3f, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63,
	0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x25, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1f, 0x0a,
	0x1d, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x52, 0x07,
	0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x22, 0xa3, 0x01, 0x0a, 0x22, 0x52, 0x65, 0x6d, 0x6f,
	0x76, 0x65, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x46, 0x72, 0x6f, 0x6d, 0x50, 0x72, 0x6f,
	0x64, 0x75, 0x63, 0x74, 0x53, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3c,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x28, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x22, 0x0a, 0x20, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x64,
	0x75, 0x63, 0x74, 0x53, 0x65, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x3f, 0x0a, 0x07,
	0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x25, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x1f, 0x0a, 0x1d, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f,
	0x64, 0x75, 0x63, 0x74, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x22, 0x9b, 0x01,
	0x0a, 0x1f, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0x49, 0x6e,
	0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x53, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x3c, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x28, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x22, 0x0a, 0x20, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50,
	0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x53, 0x65, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x87, 0x01, 0x0a, 0x20,
	0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0x49, 0x6e, 0x50, 0x72,
	0x6f, 0x64, 0x75, 0x63, 0x74, 0x53, 0x65, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x3b, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x6f, 0x64,
	0x75, 0x63, 0x74, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0x12, 0x26, 0x0a,
	0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x3e, 0x0a, 0x1a, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x50,
	0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x53, 0x65, 0x74, 0x73, 0x47, 0x63, 0x73, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x12, 0x20, 0x0a, 0x0c, 0x63, 0x73, 0x76, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x5f,
	0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x63, 0x73, 0x76, 0x46, 0x69,
	0x6c, 0x65, 0x55, 0x72, 0x69, 0x22, 0x7d, 0x0a, 0x1c, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x50,
	0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x53, 0x65, 0x74, 0x73, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x53, 0x0a, 0x0a, 0x67, 0x63, 0x73, 0x5f, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74,
	0x53, 0x65, 0x74, 0x73, 0x47, 0x63, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x48, 0x00, 0x52,
	0x09, 0x67, 0x63, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x08, 0x0a, 0x06, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x22, 0xbb, 0x01, 0x0a, 0x18, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x50,
	0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x53, 0x65, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x5c, 0x0a, 0x0c, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63,
	0x74, 0x53, 0x65, 0x74, 0x73, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x22, 0x9e, 0x01, 0x0a, 0x19, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x50, 0x72, 0x6f,
	0x64, 0x75, 0x63, 0x74, 0x53, 0x65, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x51, 0x0a, 0x10, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x69, 0x6d,
	0x61, 0x67, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x49, 0x6d, 0x61,
	0x67, 0x65, 0x52, 0x0f, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x49, 0x6d, 0x61,
	0x67, 0x65, 0x73, 0x12, 0x2e, 0x0a, 0x08, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x65, 0x73, 0x18,
	0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72,
	0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x08, 0x73, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x65, 0x73, 0x22, 0xb3, 0x02, 0x0a, 0x16, 0x42, 0x61, 0x74, 0x63, 0x68, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x4a,
	0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x34, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x73, 0x75,
	0x62, 0x6d, 0x69, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x73, 0x75, 0x62,
	0x6d, 0x69, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x35, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x22, 0x59,
	0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0e,
	0x0a, 0x0a, 0x50, 0x52, 0x4f, 0x43, 0x45, 0x53, 0x53, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0e,
	0x0a, 0x0a, 0x53, 0x55, 0x43, 0x43, 0x45, 0x53, 0x53, 0x46, 0x55, 0x4c, 0x10, 0x02, 0x12, 0x0a,
	0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x03, 0x12, 0x0d, 0x0a, 0x09, 0x43, 0x41,
	0x4e, 0x43, 0x45, 0x4c, 0x4c, 0x45, 0x44, 0x10, 0x04, 0x22, 0x3d, 0x0a, 0x15, 0x50, 0x72, 0x6f,
	0x64, 0x75, 0x63, 0x74, 0x53, 0x65, 0x74, 0x50, 0x75, 0x72, 0x67, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x24, 0x0a, 0x0e, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x73, 0x65,
	0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x70, 0x72, 0x6f, 0x64,
	0x75, 0x63, 0x74, 0x53, 0x65, 0x74, 0x49, 0x64, 0x22, 0x9b, 0x02, 0x0a, 0x14, 0x50, 0x75, 0x72,
	0x67, 0x65, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x68, 0x0a, 0x18, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x73, 0x65, 0x74,
	0x5f, 0x70, 0x75, 0x72, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x6f,
	0x64, 0x75, 0x63, 0x74, 0x53, 0x65, 0x74, 0x50, 0x75, 0x72, 0x67, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x48, 0x00, 0x52, 0x15, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x53, 0x65, 0x74,
	0x50, 0x75, 0x72, 0x67, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x36, 0x0a, 0x16, 0x64,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x5f, 0x6f, 0x72, 0x70, 0x68, 0x61, 0x6e, 0x5f, 0x70, 0x72, 0x6f,
	0x64, 0x75, 0x63, 0x74, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x48, 0x00, 0x52, 0x14, 0x64,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x4f, 0x72, 0x70, 0x68, 0x61, 0x6e, 0x50, 0x72, 0x6f, 0x64, 0x75,
	0x63, 0x74, 0x73, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x42, 0x08, 0x0a, 0x06,
	0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x32, 0xf4, 0x1d, 0x0a, 0x0d, 0x50, 0x72, 0x6f, 0x64, 0x75,
	0x63, 0x74, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x12, 0xd1, 0x01, 0x0a, 0x10, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x53, 0x65, 0x74, 0x12, 0x2f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x50, 0x72, 0x6f,
	0x64, 0x75, 0x63, 0x74, 0x53, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x22,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x53,
	0x65, 0x74, 0x22, 0x68, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3e, 0x22, 0x2f, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x53, 0x65, 0x74, 0x73, 0x3a, 0x0b, 0x70, 0x72, 0x6f,
	0x64, 0x75, 0x63, 0x74, 0x5f, 0x73, 0x65, 0x74, 0xda, 0x41, 0x21, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x2c, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x73, 0x65, 0x74, 0x2c, 0x70, 0x72,
	0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x73, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x12, 0xb4, 0x01, 0x0a,
	0x0f, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x53, 0x65, 0x74, 0x73,
	0x12, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72,
	0x6f, 0x64, 0x75, 0x63, 0x74, 0x53, 0x65, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72,
	0x6f, 0x64, 0x75, 0x63, 0x74, 0x53, 0x65, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x40, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x31, 0x12, 0x2f, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x70,
	0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x53, 0x65, 0x74, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x12, 0xa1, 0x01, 0x0a, 0x0d, 0x47, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x64, 0x75,
	0x63, 0x74, 0x53, 0x65, 0x74, 0x12, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x47,
	0x65, 0x74, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x53, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x6f,
	0x64, 0x75, 0x63, 0x74, 0x53, 0x65, 0x74, 0x22, 0x3e, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x31, 0x12,
	0x2f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x53, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x7d,
	0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xd3, 0x01, 0x0a, 0x10, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x53, 0x65, 0x74, 0x12, 0x2f, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x64,
	0x75, 0x63, 0x74, 0x53, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x22, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x53, 0x65,
	0x74, 0x22, 0x6a, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4a, 0x32, 0x3b, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x73, 0x65, 0x74, 0x2e, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x53,
	0x65, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x0b, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f,
	0x73, 0x65, 0x74, 0xda, 0x41, 0x17, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x73, 0x65,
	0x74, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x12, 0x9b, 0x01,
	0x0a, 0x10, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x53,
	0x65, 0x74, 0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x53, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x3e, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x31, 0x2a, 0x2f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x53, 0x65, 0x74,
	0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xb9, 0x01, 0x0a, 0x0d,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x12, 0x2c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x50, 0x72, 0x6f,
	0x64, 0x75, 0x63, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x22, 0x59, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x37, 0x22, 0x2c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63,
	0x74, 0x73, 0x3a, 0x07, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0xda, 0x41, 0x19, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x2c, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x2c, 0x70, 0x72, 0x6f,
	0x64, 0x75, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x12, 0xa8, 0x01, 0x0a, 0x0c, 0x4c, 0x69, 0x73, 0x74,
	0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0x12, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x3d, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2e, 0x12, 0x2c, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x12, 0x95, 0x01, 0x0a, 0x0a, 0x47, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63,
	0x74, 0x12, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x50, 0x72,
	0x6f, 0x64, 0x75, 0x63, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1f, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x22, 0x3b, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x2e, 0x12, 0x2c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xbb, 0x01, 0x0a, 0x0d, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x12, 0x2c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x64,
	0x75, 0x63, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1f, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x22, 0x5b, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x3f, 0x32, 0x34, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63,
	0x74, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72,
	0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x07, 0x70, 0x72, 0x6f, 0x64, 0x75,
	0x63, 0x74, 0xda, 0x41, 0x13, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x2c, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x12, 0x92, 0x01, 0x0a, 0x0d, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x12, 0x2c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79,
	0x22, 0x3b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2e, 0x2a, 0x2c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x6f, 0x64, 0x75,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xf9, 0x01,
	0x0a, 0x14, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63,
	0x65, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x49,
	0x6d, 0x61, 0x67, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x26, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x49, 0x6d,
	0x61, 0x67, 0x65, 0x22, 0x83, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x51, 0x22, 0x3e, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x72, 0x65, 0x66,
	0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x73, 0x3a, 0x0f, 0x72, 0x65,
	0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0xda, 0x41, 0x29,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65,
	0x5f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x2c, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65,
	0x5f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x69, 0x64, 0x12, 0xb2, 0x01, 0x0a, 0x14, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x49, 0x6d, 0x61,
	0x67, 0x65, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x49, 0x6d, 0x61, 0x67, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22,
	0x4d, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x40, 0x2a, 0x3e, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x49, 0x6d,
	0x61, 0x67, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xcf,
	0x01, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65,
	0x49, 0x6d, 0x61, 0x67, 0x65, 0x73, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x49, 0x6d, 0x61,
	0x67, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63,
	0x65, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x4f, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x40, 0x12, 0x3e, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x6f, 0x64,
	0x75, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63,
	0x65, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x12, 0xbc, 0x01, 0x0a, 0x11, 0x47, 0x65, 0x74, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63,
	0x65, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e,
	0x47, 0x65, 0x74, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x49, 0x6d, 0x61, 0x67,
	0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x31, 0x2e, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x49, 0x6d, 0x61, 0x67, 0x65,
	0x22, 0x4d, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x40, 0x12, 0x3e, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x6f, 0x64, 0x75,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x49,
	0x6d, 0x61, 0x67, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0xbd, 0x01, 0x0a, 0x16, 0x41, 0x64, 0x64, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x54, 0x6f,
	0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x53, 0x65, 0x74, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x31, 0x2e, 0x41, 0x64, 0x64, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x54, 0x6f,
	0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x53, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x54, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x3f, 0x22, 0x3a, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x53, 0x65, 0x74, 0x73, 0x2f,
	0x2a, 0x7d, 0x3a, 0x61, 0x64, 0x64, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x3a, 0x01, 0x2a,
	0xda, 0x41, 0x0c, 0x6e, 0x61, 0x6d, 0x65, 0x2c, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x12,
	0xca, 0x01, 0x0a, 0x1b, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63,
	0x74, 0x46, 0x72, 0x6f, 0x6d, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x53, 0x65, 0x74, 0x12,
	0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x50,
	0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x46, 0x72, 0x6f, 0x6d, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63,
	0x74, 0x53, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d,
	0x70, 0x74, 0x79, 0x22, 0x57, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x42, 0x22, 0x3d, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72,
	0x6f, 0x64, 0x75, 0x63, 0x74, 0x53, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x72, 0x65, 0x6d,
	0x6f, 0x76, 0x65, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x0c,
	0x6e, 0x61, 0x6d, 0x65, 0x2c, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x12, 0xd6, 0x01, 0x0a,
	0x18, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0x49, 0x6e, 0x50,
	0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x53, 0x65, 0x74, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0x49,
	0x6e, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x53, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0x49, 0x6e, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63,
	0x74, 0x53, 0x65, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x47, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x3a, 0x12, 0x38, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x53, 0x65,
	0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0xda, 0x41,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xf4, 0x01, 0x0a, 0x11, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74,
	0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x53, 0x65, 0x74, 0x73, 0x12, 0x30, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x50, 0x72, 0x6f, 0x64, 0x75,
	0x63, 0x74, 0x53, 0x65, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69,
	0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x8d, 0x01, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x3b, 0x22, 0x36, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x70, 0x72, 0x6f, 0x64, 0x75,
	0x63, 0x74, 0x53, 0x65, 0x74, 0x73, 0x3a, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x3a, 0x01, 0x2a,
	0xda, 0x41, 0x13, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0xca, 0x41, 0x33, 0x0a, 0x19, 0x49, 0x6d, 0x70, 0x6f, 0x72,
	0x74, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x53, 0x65, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x16, 0x42, 0x61, 0x74, 0x63, 0x68, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0xd6, 0x01, 0x0a,
	0x0d, 0x50, 0x75, 0x72, 0x67, 0x65, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0x12, 0x2c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x75, 0x72, 0x67, 0x65, 0x50, 0x72, 0x6f,
	0x64, 0x75, 0x63, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e,
	0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x78, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x37, 0x22, 0x32, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74,
	0x73, 0x3a, 0x70, 0x75, 0x72, 0x67, 0x65, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0xca, 0x41, 0x2f, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x16, 0x42,
	0x61, 0x74, 0x63, 0x68, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x1a, 0x76, 0xca, 0x41, 0x15, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2,
	0x41, 0x5b, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74,
	0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x42, 0x81, 0x01,
	0x0a, 0x1a, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x42, 0x19, 0x50, 0x72,
	0x6f, 0x64, 0x75, 0x63, 0x74, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x3c, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2f, 0x76, 0x31,
	0x3b, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0xf8, 0x01, 0x01, 0xa2, 0x02, 0x04, 0x47, 0x43, 0x56,
	0x4e, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_vision_v1_product_search_service_proto_rawDescOnce sync.Once
	file_google_cloud_vision_v1_product_search_service_proto_rawDescData = file_google_cloud_vision_v1_product_search_service_proto_rawDesc
)

func file_google_cloud_vision_v1_product_search_service_proto_rawDescGZIP() []byte {
	file_google_cloud_vision_v1_product_search_service_proto_rawDescOnce.Do(func() {
		file_google_cloud_vision_v1_product_search_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_vision_v1_product_search_service_proto_rawDescData)
	})
	return file_google_cloud_vision_v1_product_search_service_proto_rawDescData
}

var file_google_cloud_vision_v1_product_search_service_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_vision_v1_product_search_service_proto_msgTypes = make([]protoimpl.MessageInfo, 32)
var file_google_cloud_vision_v1_product_search_service_proto_goTypes = []interface{}{
	(BatchOperationMetadata_State)(0),          // 0: google.cloud.vision.v1.BatchOperationMetadata.State
	(*Product)(nil),                            // 1: google.cloud.vision.v1.Product
	(*ProductSet)(nil),                         // 2: google.cloud.vision.v1.ProductSet
	(*ReferenceImage)(nil),                     // 3: google.cloud.vision.v1.ReferenceImage
	(*CreateProductRequest)(nil),               // 4: google.cloud.vision.v1.CreateProductRequest
	(*ListProductsRequest)(nil),                // 5: google.cloud.vision.v1.ListProductsRequest
	(*ListProductsResponse)(nil),               // 6: google.cloud.vision.v1.ListProductsResponse
	(*GetProductRequest)(nil),                  // 7: google.cloud.vision.v1.GetProductRequest
	(*UpdateProductRequest)(nil),               // 8: google.cloud.vision.v1.UpdateProductRequest
	(*DeleteProductRequest)(nil),               // 9: google.cloud.vision.v1.DeleteProductRequest
	(*CreateProductSetRequest)(nil),            // 10: google.cloud.vision.v1.CreateProductSetRequest
	(*ListProductSetsRequest)(nil),             // 11: google.cloud.vision.v1.ListProductSetsRequest
	(*ListProductSetsResponse)(nil),            // 12: google.cloud.vision.v1.ListProductSetsResponse
	(*GetProductSetRequest)(nil),               // 13: google.cloud.vision.v1.GetProductSetRequest
	(*UpdateProductSetRequest)(nil),            // 14: google.cloud.vision.v1.UpdateProductSetRequest
	(*DeleteProductSetRequest)(nil),            // 15: google.cloud.vision.v1.DeleteProductSetRequest
	(*CreateReferenceImageRequest)(nil),        // 16: google.cloud.vision.v1.CreateReferenceImageRequest
	(*ListReferenceImagesRequest)(nil),         // 17: google.cloud.vision.v1.ListReferenceImagesRequest
	(*ListReferenceImagesResponse)(nil),        // 18: google.cloud.vision.v1.ListReferenceImagesResponse
	(*GetReferenceImageRequest)(nil),           // 19: google.cloud.vision.v1.GetReferenceImageRequest
	(*DeleteReferenceImageRequest)(nil),        // 20: google.cloud.vision.v1.DeleteReferenceImageRequest
	(*AddProductToProductSetRequest)(nil),      // 21: google.cloud.vision.v1.AddProductToProductSetRequest
	(*RemoveProductFromProductSetRequest)(nil), // 22: google.cloud.vision.v1.RemoveProductFromProductSetRequest
	(*ListProductsInProductSetRequest)(nil),    // 23: google.cloud.vision.v1.ListProductsInProductSetRequest
	(*ListProductsInProductSetResponse)(nil),   // 24: google.cloud.vision.v1.ListProductsInProductSetResponse
	(*ImportProductSetsGcsSource)(nil),         // 25: google.cloud.vision.v1.ImportProductSetsGcsSource
	(*ImportProductSetsInputConfig)(nil),       // 26: google.cloud.vision.v1.ImportProductSetsInputConfig
	(*ImportProductSetsRequest)(nil),           // 27: google.cloud.vision.v1.ImportProductSetsRequest
	(*ImportProductSetsResponse)(nil),          // 28: google.cloud.vision.v1.ImportProductSetsResponse
	(*BatchOperationMetadata)(nil),             // 29: google.cloud.vision.v1.BatchOperationMetadata
	(*ProductSetPurgeConfig)(nil),              // 30: google.cloud.vision.v1.ProductSetPurgeConfig
	(*PurgeProductsRequest)(nil),               // 31: google.cloud.vision.v1.PurgeProductsRequest
	(*Product_KeyValue)(nil),                   // 32: google.cloud.vision.v1.Product.KeyValue
	(*timestamppb.Timestamp)(nil),              // 33: google.protobuf.Timestamp
	(*status.Status)(nil),                      // 34: google.rpc.Status
	(*BoundingPoly)(nil),                       // 35: google.cloud.vision.v1.BoundingPoly
	(*fieldmaskpb.FieldMask)(nil),              // 36: google.protobuf.FieldMask
	(*emptypb.Empty)(nil),                      // 37: google.protobuf.Empty
	(*longrunning.Operation)(nil),              // 38: google.longrunning.Operation
}
var file_google_cloud_vision_v1_product_search_service_proto_depIdxs = []int32{
	32, // 0: google.cloud.vision.v1.Product.product_labels:type_name -> google.cloud.vision.v1.Product.KeyValue
	33, // 1: google.cloud.vision.v1.ProductSet.index_time:type_name -> google.protobuf.Timestamp
	34, // 2: google.cloud.vision.v1.ProductSet.index_error:type_name -> google.rpc.Status
	35, // 3: google.cloud.vision.v1.ReferenceImage.bounding_polys:type_name -> google.cloud.vision.v1.BoundingPoly
	1,  // 4: google.cloud.vision.v1.CreateProductRequest.product:type_name -> google.cloud.vision.v1.Product
	1,  // 5: google.cloud.vision.v1.ListProductsResponse.products:type_name -> google.cloud.vision.v1.Product
	1,  // 6: google.cloud.vision.v1.UpdateProductRequest.product:type_name -> google.cloud.vision.v1.Product
	36, // 7: google.cloud.vision.v1.UpdateProductRequest.update_mask:type_name -> google.protobuf.FieldMask
	2,  // 8: google.cloud.vision.v1.CreateProductSetRequest.product_set:type_name -> google.cloud.vision.v1.ProductSet
	2,  // 9: google.cloud.vision.v1.ListProductSetsResponse.product_sets:type_name -> google.cloud.vision.v1.ProductSet
	2,  // 10: google.cloud.vision.v1.UpdateProductSetRequest.product_set:type_name -> google.cloud.vision.v1.ProductSet
	36, // 11: google.cloud.vision.v1.UpdateProductSetRequest.update_mask:type_name -> google.protobuf.FieldMask
	3,  // 12: google.cloud.vision.v1.CreateReferenceImageRequest.reference_image:type_name -> google.cloud.vision.v1.ReferenceImage
	3,  // 13: google.cloud.vision.v1.ListReferenceImagesResponse.reference_images:type_name -> google.cloud.vision.v1.ReferenceImage
	1,  // 14: google.cloud.vision.v1.ListProductsInProductSetResponse.products:type_name -> google.cloud.vision.v1.Product
	25, // 15: google.cloud.vision.v1.ImportProductSetsInputConfig.gcs_source:type_name -> google.cloud.vision.v1.ImportProductSetsGcsSource
	26, // 16: google.cloud.vision.v1.ImportProductSetsRequest.input_config:type_name -> google.cloud.vision.v1.ImportProductSetsInputConfig
	3,  // 17: google.cloud.vision.v1.ImportProductSetsResponse.reference_images:type_name -> google.cloud.vision.v1.ReferenceImage
	34, // 18: google.cloud.vision.v1.ImportProductSetsResponse.statuses:type_name -> google.rpc.Status
	0,  // 19: google.cloud.vision.v1.BatchOperationMetadata.state:type_name -> google.cloud.vision.v1.BatchOperationMetadata.State
	33, // 20: google.cloud.vision.v1.BatchOperationMetadata.submit_time:type_name -> google.protobuf.Timestamp
	33, // 21: google.cloud.vision.v1.BatchOperationMetadata.end_time:type_name -> google.protobuf.Timestamp
	30, // 22: google.cloud.vision.v1.PurgeProductsRequest.product_set_purge_config:type_name -> google.cloud.vision.v1.ProductSetPurgeConfig
	10, // 23: google.cloud.vision.v1.ProductSearch.CreateProductSet:input_type -> google.cloud.vision.v1.CreateProductSetRequest
	11, // 24: google.cloud.vision.v1.ProductSearch.ListProductSets:input_type -> google.cloud.vision.v1.ListProductSetsRequest
	13, // 25: google.cloud.vision.v1.ProductSearch.GetProductSet:input_type -> google.cloud.vision.v1.GetProductSetRequest
	14, // 26: google.cloud.vision.v1.ProductSearch.UpdateProductSet:input_type -> google.cloud.vision.v1.UpdateProductSetRequest
	15, // 27: google.cloud.vision.v1.ProductSearch.DeleteProductSet:input_type -> google.cloud.vision.v1.DeleteProductSetRequest
	4,  // 28: google.cloud.vision.v1.ProductSearch.CreateProduct:input_type -> google.cloud.vision.v1.CreateProductRequest
	5,  // 29: google.cloud.vision.v1.ProductSearch.ListProducts:input_type -> google.cloud.vision.v1.ListProductsRequest
	7,  // 30: google.cloud.vision.v1.ProductSearch.GetProduct:input_type -> google.cloud.vision.v1.GetProductRequest
	8,  // 31: google.cloud.vision.v1.ProductSearch.UpdateProduct:input_type -> google.cloud.vision.v1.UpdateProductRequest
	9,  // 32: google.cloud.vision.v1.ProductSearch.DeleteProduct:input_type -> google.cloud.vision.v1.DeleteProductRequest
	16, // 33: google.cloud.vision.v1.ProductSearch.CreateReferenceImage:input_type -> google.cloud.vision.v1.CreateReferenceImageRequest
	20, // 34: google.cloud.vision.v1.ProductSearch.DeleteReferenceImage:input_type -> google.cloud.vision.v1.DeleteReferenceImageRequest
	17, // 35: google.cloud.vision.v1.ProductSearch.ListReferenceImages:input_type -> google.cloud.vision.v1.ListReferenceImagesRequest
	19, // 36: google.cloud.vision.v1.ProductSearch.GetReferenceImage:input_type -> google.cloud.vision.v1.GetReferenceImageRequest
	21, // 37: google.cloud.vision.v1.ProductSearch.AddProductToProductSet:input_type -> google.cloud.vision.v1.AddProductToProductSetRequest
	22, // 38: google.cloud.vision.v1.ProductSearch.RemoveProductFromProductSet:input_type -> google.cloud.vision.v1.RemoveProductFromProductSetRequest
	23, // 39: google.cloud.vision.v1.ProductSearch.ListProductsInProductSet:input_type -> google.cloud.vision.v1.ListProductsInProductSetRequest
	27, // 40: google.cloud.vision.v1.ProductSearch.ImportProductSets:input_type -> google.cloud.vision.v1.ImportProductSetsRequest
	31, // 41: google.cloud.vision.v1.ProductSearch.PurgeProducts:input_type -> google.cloud.vision.v1.PurgeProductsRequest
	2,  // 42: google.cloud.vision.v1.ProductSearch.CreateProductSet:output_type -> google.cloud.vision.v1.ProductSet
	12, // 43: google.cloud.vision.v1.ProductSearch.ListProductSets:output_type -> google.cloud.vision.v1.ListProductSetsResponse
	2,  // 44: google.cloud.vision.v1.ProductSearch.GetProductSet:output_type -> google.cloud.vision.v1.ProductSet
	2,  // 45: google.cloud.vision.v1.ProductSearch.UpdateProductSet:output_type -> google.cloud.vision.v1.ProductSet
	37, // 46: google.cloud.vision.v1.ProductSearch.DeleteProductSet:output_type -> google.protobuf.Empty
	1,  // 47: google.cloud.vision.v1.ProductSearch.CreateProduct:output_type -> google.cloud.vision.v1.Product
	6,  // 48: google.cloud.vision.v1.ProductSearch.ListProducts:output_type -> google.cloud.vision.v1.ListProductsResponse
	1,  // 49: google.cloud.vision.v1.ProductSearch.GetProduct:output_type -> google.cloud.vision.v1.Product
	1,  // 50: google.cloud.vision.v1.ProductSearch.UpdateProduct:output_type -> google.cloud.vision.v1.Product
	37, // 51: google.cloud.vision.v1.ProductSearch.DeleteProduct:output_type -> google.protobuf.Empty
	3,  // 52: google.cloud.vision.v1.ProductSearch.CreateReferenceImage:output_type -> google.cloud.vision.v1.ReferenceImage
	37, // 53: google.cloud.vision.v1.ProductSearch.DeleteReferenceImage:output_type -> google.protobuf.Empty
	18, // 54: google.cloud.vision.v1.ProductSearch.ListReferenceImages:output_type -> google.cloud.vision.v1.ListReferenceImagesResponse
	3,  // 55: google.cloud.vision.v1.ProductSearch.GetReferenceImage:output_type -> google.cloud.vision.v1.ReferenceImage
	37, // 56: google.cloud.vision.v1.ProductSearch.AddProductToProductSet:output_type -> google.protobuf.Empty
	37, // 57: google.cloud.vision.v1.ProductSearch.RemoveProductFromProductSet:output_type -> google.protobuf.Empty
	24, // 58: google.cloud.vision.v1.ProductSearch.ListProductsInProductSet:output_type -> google.cloud.vision.v1.ListProductsInProductSetResponse
	38, // 59: google.cloud.vision.v1.ProductSearch.ImportProductSets:output_type -> google.longrunning.Operation
	38, // 60: google.cloud.vision.v1.ProductSearch.PurgeProducts:output_type -> google.longrunning.Operation
	42, // [42:61] is the sub-list for method output_type
	23, // [23:42] is the sub-list for method input_type
	23, // [23:23] is the sub-list for extension type_name
	23, // [23:23] is the sub-list for extension extendee
	0,  // [0:23] is the sub-list for field type_name
}

func init() { file_google_cloud_vision_v1_product_search_service_proto_init() }
func file_google_cloud_vision_v1_product_search_service_proto_init() {
	if File_google_cloud_vision_v1_product_search_service_proto != nil {
		return
	}
	file_google_cloud_vision_v1_geometry_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_vision_v1_product_search_service_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Product); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vision_v1_product_search_service_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ProductSet); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vision_v1_product_search_service_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReferenceImage); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vision_v1_product_search_service_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateProductRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vision_v1_product_search_service_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListProductsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vision_v1_product_search_service_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListProductsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vision_v1_product_search_service_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetProductRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vision_v1_product_search_service_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateProductRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vision_v1_product_search_service_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteProductRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vision_v1_product_search_service_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateProductSetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vision_v1_product_search_service_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListProductSetsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vision_v1_product_search_service_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListProductSetsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vision_v1_product_search_service_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetProductSetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vision_v1_product_search_service_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateProductSetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vision_v1_product_search_service_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteProductSetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vision_v1_product_search_service_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateReferenceImageRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vision_v1_product_search_service_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListReferenceImagesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vision_v1_product_search_service_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListReferenceImagesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vision_v1_product_search_service_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetReferenceImageRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vision_v1_product_search_service_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteReferenceImageRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vision_v1_product_search_service_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AddProductToProductSetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vision_v1_product_search_service_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RemoveProductFromProductSetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vision_v1_product_search_service_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListProductsInProductSetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vision_v1_product_search_service_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListProductsInProductSetResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vision_v1_product_search_service_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImportProductSetsGcsSource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vision_v1_product_search_service_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImportProductSetsInputConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vision_v1_product_search_service_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImportProductSetsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vision_v1_product_search_service_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImportProductSetsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vision_v1_product_search_service_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchOperationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vision_v1_product_search_service_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ProductSetPurgeConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vision_v1_product_search_service_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PurgeProductsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vision_v1_product_search_service_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Product_KeyValue); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_vision_v1_product_search_service_proto_msgTypes[25].OneofWrappers = []interface{}{
		(*ImportProductSetsInputConfig_GcsSource)(nil),
	}
	file_google_cloud_vision_v1_product_search_service_proto_msgTypes[30].OneofWrappers = []interface{}{
		(*PurgeProductsRequest_ProductSetPurgeConfig)(nil),
		(*PurgeProductsRequest_DeleteOrphanProducts)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_vision_v1_product_search_service_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   32,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_vision_v1_product_search_service_proto_goTypes,
		DependencyIndexes: file_google_cloud_vision_v1_product_search_service_proto_depIdxs,
		EnumInfos:         file_google_cloud_vision_v1_product_search_service_proto_enumTypes,
		MessageInfos:      file_google_cloud_vision_v1_product_search_service_proto_msgTypes,
	}.Build()
	File_google_cloud_vision_v1_product_search_service_proto = out.File
	file_google_cloud_vision_v1_product_search_service_proto_rawDesc = nil
	file_google_cloud_vision_v1_product_search_service_proto_goTypes = nil
	file_google_cloud_vision_v1_product_search_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// ProductSearchClient is the client API for ProductSearch service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ProductSearchClient interface {
	// Creates and returns a new ProductSet resource.
	//
	// Possible errors:
	//
	// * Returns INVALID_ARGUMENT if display_name is missing, or is longer than
	//   4096 characters.
	CreateProductSet(ctx context.Context, in *CreateProductSetRequest, opts ...grpc.CallOption) (*ProductSet, error)
	// Lists ProductSets in an unspecified order.
	//
	// Possible errors:
	//
	// * Returns INVALID_ARGUMENT if page_size is greater than 100, or less
	//   than 1.
	ListProductSets(ctx context.Context, in *ListProductSetsRequest, opts ...grpc.CallOption) (*ListProductSetsResponse, error)
	// Gets information associated with a ProductSet.
	//
	// Possible errors:
	//
	// * Returns NOT_FOUND if the ProductSet does not exist.
	GetProductSet(ctx context.Context, in *GetProductSetRequest, opts ...grpc.CallOption) (*ProductSet, error)
	// Makes changes to a ProductSet resource.
	// Only display_name can be updated currently.
	//
	// Possible errors:
	//
	// * Returns NOT_FOUND if the ProductSet does not exist.
	// * Returns INVALID_ARGUMENT if display_name is present in update_mask but
	//   missing from the request or longer than 4096 characters.
	UpdateProductSet(ctx context.Context, in *UpdateProductSetRequest, opts ...grpc.CallOption) (*ProductSet, error)
	// Permanently deletes a ProductSet. Products and ReferenceImages in the
	// ProductSet are not deleted.
	//
	// The actual image files are not deleted from Google Cloud Storage.
	DeleteProductSet(ctx context.Context, in *DeleteProductSetRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Creates and returns a new product resource.
	//
	// Possible errors:
	//
	// * Returns INVALID_ARGUMENT if display_name is missing or longer than 4096
	//   characters.
	// * Returns INVALID_ARGUMENT if description is longer than 4096 characters.
	// * Returns INVALID_ARGUMENT if product_category is missing or invalid.
	CreateProduct(ctx context.Context, in *CreateProductRequest, opts ...grpc.CallOption) (*Product, error)
	// Lists products in an unspecified order.
	//
	// Possible errors:
	//
	// * Returns INVALID_ARGUMENT if page_size is greater than 100 or less than 1.
	ListProducts(ctx context.Context, in *ListProductsRequest, opts ...grpc.CallOption) (*ListProductsResponse, error)
	// Gets information associated with a Product.
	//
	// Possible errors:
	//
	// * Returns NOT_FOUND if the Product does not exist.
	GetProduct(ctx context.Context, in *GetProductRequest, opts ...grpc.CallOption) (*Product, error)
	// Makes changes to a Product resource.
	// Only the `display_name`, `description`, and `labels` fields can be updated
	// right now.
	//
	// If labels are updated, the change will not be reflected in queries until
	// the next index time.
	//
	// Possible errors:
	//
	// * Returns NOT_FOUND if the Product does not exist.
	// * Returns INVALID_ARGUMENT if display_name is present in update_mask but is
	//   missing from the request or longer than 4096 characters.
	// * Returns INVALID_ARGUMENT if description is present in update_mask but is
	//   longer than 4096 characters.
	// * Returns INVALID_ARGUMENT if product_category is present in update_mask.
	UpdateProduct(ctx context.Context, in *UpdateProductRequest, opts ...grpc.CallOption) (*Product, error)
	// Permanently deletes a product and its reference images.
	//
	// Metadata of the product and all its images will be deleted right away, but
	// search queries against ProductSets containing the product may still work
	// until all related caches are refreshed.
	DeleteProduct(ctx context.Context, in *DeleteProductRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Creates and returns a new ReferenceImage resource.
	//
	// The `bounding_poly` field is optional. If `bounding_poly` is not specified,
	// the system will try to detect regions of interest in the image that are
	// compatible with the product_category on the parent product. If it is
	// specified, detection is ALWAYS skipped. The system converts polygons into
	// non-rotated rectangles.
	//
	// Note that the pipeline will resize the image if the image resolution is too
	// large to process (above 50MP).
	//
	// Possible errors:
	//
	// * Returns INVALID_ARGUMENT if the image_uri is missing or longer than 4096
	//   characters.
	// * Returns INVALID_ARGUMENT if the product does not exist.
	// * Returns INVALID_ARGUMENT if bounding_poly is not provided, and nothing
	//   compatible with the parent product's product_category is detected.
	// * Returns INVALID_ARGUMENT if bounding_poly contains more than 10 polygons.
	CreateReferenceImage(ctx context.Context, in *CreateReferenceImageRequest, opts ...grpc.CallOption) (*ReferenceImage, error)
	// Permanently deletes a reference image.
	//
	// The image metadata will be deleted right away, but search queries
	// against ProductSets containing the image may still work until all related
	// caches are refreshed.
	//
	// The actual image files are not deleted from Google Cloud Storage.
	DeleteReferenceImage(ctx context.Context, in *DeleteReferenceImageRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Lists reference images.
	//
	// Possible errors:
	//
	// * Returns NOT_FOUND if the parent product does not exist.
	// * Returns INVALID_ARGUMENT if the page_size is greater than 100, or less
	//   than 1.
	ListReferenceImages(ctx context.Context, in *ListReferenceImagesRequest, opts ...grpc.CallOption) (*ListReferenceImagesResponse, error)
	// Gets information associated with a ReferenceImage.
	//
	// Possible errors:
	//
	// * Returns NOT_FOUND if the specified image does not exist.
	GetReferenceImage(ctx context.Context, in *GetReferenceImageRequest, opts ...grpc.CallOption) (*ReferenceImage, error)
	// Adds a Product to the specified ProductSet. If the Product is already
	// present, no change is made.
	//
	// One Product can be added to at most 100 ProductSets.
	//
	// Possible errors:
	//
	// * Returns NOT_FOUND if the Product or the ProductSet doesn't exist.
	AddProductToProductSet(ctx context.Context, in *AddProductToProductSetRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Removes a Product from the specified ProductSet.
	RemoveProductFromProductSet(ctx context.Context, in *RemoveProductFromProductSetRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Lists the Products in a ProductSet, in an unspecified order. If the
	// ProductSet does not exist, the products field of the response will be
	// empty.
	//
	// Possible errors:
	//
	// * Returns INVALID_ARGUMENT if page_size is greater than 100 or less than 1.
	ListProductsInProductSet(ctx context.Context, in *ListProductsInProductSetRequest, opts ...grpc.CallOption) (*ListProductsInProductSetResponse, error)
	// Asynchronous API that imports a list of reference images to specified
	// product sets based on a list of image information.
	//
	// The [google.longrunning.Operation][google.longrunning.Operation] API can be used to keep track of the
	// progress and results of the request.
	// `Operation.metadata` contains `BatchOperationMetadata`. (progress)
	// `Operation.response` contains `ImportProductSetsResponse`. (results)
	//
	// The input source of this method is a csv file on Google Cloud Storage.
	// For the format of the csv file please see
	// [ImportProductSetsGcsSource.csv_file_uri][google.cloud.vision.v1.ImportProductSetsGcsSource.csv_file_uri].
	ImportProductSets(ctx context.Context, in *ImportProductSetsRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Asynchronous API to delete all Products in a ProductSet or all Products
	// that are in no ProductSet.
	//
	// If a Product is a member of the specified ProductSet in addition to other
	// ProductSets, the Product will still be deleted.
	//
	// It is recommended to not delete the specified ProductSet until after this
	// operation has completed. It is also recommended to not add any of the
	// Products involved in the batch delete to a new ProductSet while this
	// operation is running because those Products may still end up deleted.
	//
	// It's not possible to undo the PurgeProducts operation. Therefore, it is
	// recommended to keep the csv files used in ImportProductSets (if that was
	// how you originally built the Product Set) before starting PurgeProducts, in
	// case you need to re-import the data after deletion.
	//
	// If the plan is to purge all of the Products from a ProductSet and then
	// re-use the empty ProductSet to re-import new Products into the empty
	// ProductSet, you must wait until the PurgeProducts operation has finished
	// for that ProductSet.
	//
	// The [google.longrunning.Operation][google.longrunning.Operation] API can be used to keep track of the
	// progress and results of the request.
	// `Operation.metadata` contains `BatchOperationMetadata`. (progress)
	PurgeProducts(ctx context.Context, in *PurgeProductsRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
}

type productSearchClient struct {
	cc grpc.ClientConnInterface
}

func NewProductSearchClient(cc grpc.ClientConnInterface) ProductSearchClient {
	return &productSearchClient{cc}
}

func (c *productSearchClient) CreateProductSet(ctx context.Context, in *CreateProductSetRequest, opts ...grpc.CallOption) (*ProductSet, error) {
	out := new(ProductSet)
	err := c.cc.Invoke(ctx, "/google.cloud.vision.v1.ProductSearch/CreateProductSet", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *productSearchClient) ListProductSets(ctx context.Context, in *ListProductSetsRequest, opts ...grpc.CallOption) (*ListProductSetsResponse, error) {
	out := new(ListProductSetsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.vision.v1.ProductSearch/ListProductSets", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *productSearchClient) GetProductSet(ctx context.Context, in *GetProductSetRequest, opts ...grpc.CallOption) (*ProductSet, error) {
	out := new(ProductSet)
	err := c.cc.Invoke(ctx, "/google.cloud.vision.v1.ProductSearch/GetProductSet", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *productSearchClient) UpdateProductSet(ctx context.Context, in *UpdateProductSetRequest, opts ...grpc.CallOption) (*ProductSet, error) {
	out := new(ProductSet)
	err := c.cc.Invoke(ctx, "/google.cloud.vision.v1.ProductSearch/UpdateProductSet", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *productSearchClient) DeleteProductSet(ctx context.Context, in *DeleteProductSetRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.vision.v1.ProductSearch/DeleteProductSet", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *productSearchClient) CreateProduct(ctx context.Context, in *CreateProductRequest, opts ...grpc.CallOption) (*Product, error) {
	out := new(Product)
	err := c.cc.Invoke(ctx, "/google.cloud.vision.v1.ProductSearch/CreateProduct", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *productSearchClient) ListProducts(ctx context.Context, in *ListProductsRequest, opts ...grpc.CallOption) (*ListProductsResponse, error) {
	out := new(ListProductsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.vision.v1.ProductSearch/ListProducts", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *productSearchClient) GetProduct(ctx context.Context, in *GetProductRequest, opts ...grpc.CallOption) (*Product, error) {
	out := new(Product)
	err := c.cc.Invoke(ctx, "/google.cloud.vision.v1.ProductSearch/GetProduct", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *productSearchClient) UpdateProduct(ctx context.Context, in *UpdateProductRequest, opts ...grpc.CallOption) (*Product, error) {
	out := new(Product)
	err := c.cc.Invoke(ctx, "/google.cloud.vision.v1.ProductSearch/UpdateProduct", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *productSearchClient) DeleteProduct(ctx context.Context, in *DeleteProductRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.vision.v1.ProductSearch/DeleteProduct", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *productSearchClient) CreateReferenceImage(ctx context.Context, in *CreateReferenceImageRequest, opts ...grpc.CallOption) (*ReferenceImage, error) {
	out := new(ReferenceImage)
	err := c.cc.Invoke(ctx, "/google.cloud.vision.v1.ProductSearch/CreateReferenceImage", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *productSearchClient) DeleteReferenceImage(ctx context.Context, in *DeleteReferenceImageRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.vision.v1.ProductSearch/DeleteReferenceImage", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *productSearchClient) ListReferenceImages(ctx context.Context, in *ListReferenceImagesRequest, opts ...grpc.CallOption) (*ListReferenceImagesResponse, error) {
	out := new(ListReferenceImagesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.vision.v1.ProductSearch/ListReferenceImages", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *productSearchClient) GetReferenceImage(ctx context.Context, in *GetReferenceImageRequest, opts ...grpc.CallOption) (*ReferenceImage, error) {
	out := new(ReferenceImage)
	err := c.cc.Invoke(ctx, "/google.cloud.vision.v1.ProductSearch/GetReferenceImage", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *productSearchClient) AddProductToProductSet(ctx context.Context, in *AddProductToProductSetRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.vision.v1.ProductSearch/AddProductToProductSet", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *productSearchClient) RemoveProductFromProductSet(ctx context.Context, in *RemoveProductFromProductSetRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.vision.v1.ProductSearch/RemoveProductFromProductSet", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *productSearchClient) ListProductsInProductSet(ctx context.Context, in *ListProductsInProductSetRequest, opts ...grpc.CallOption) (*ListProductsInProductSetResponse, error) {
	out := new(ListProductsInProductSetResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.vision.v1.ProductSearch/ListProductsInProductSet", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *productSearchClient) ImportProductSets(ctx context.Context, in *ImportProductSetsRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.vision.v1.ProductSearch/ImportProductSets", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *productSearchClient) PurgeProducts(ctx context.Context, in *PurgeProductsRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.vision.v1.ProductSearch/PurgeProducts", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ProductSearchServer is the server API for ProductSearch service.
type ProductSearchServer interface {
	// Creates and returns a new ProductSet resource.
	//
	// Possible errors:
	//
	// * Returns INVALID_ARGUMENT if display_name is missing, or is longer than
	//   4096 characters.
	CreateProductSet(context.Context, *CreateProductSetRequest) (*ProductSet, error)
	// Lists ProductSets in an unspecified order.
	//
	// Possible errors:
	//
	// * Returns INVALID_ARGUMENT if page_size is greater than 100, or less
	//   than 1.
	ListProductSets(context.Context, *ListProductSetsRequest) (*ListProductSetsResponse, error)
	// Gets information associated with a ProductSet.
	//
	// Possible errors:
	//
	// * Returns NOT_FOUND if the ProductSet does not exist.
	GetProductSet(context.Context, *GetProductSetRequest) (*ProductSet, error)
	// Makes changes to a ProductSet resource.
	// Only display_name can be updated currently.
	//
	// Possible errors:
	//
	// * Returns NOT_FOUND if the ProductSet does not exist.
	// * Returns INVALID_ARGUMENT if display_name is present in update_mask but
	//   missing from the request or longer than 4096 characters.
	UpdateProductSet(context.Context, *UpdateProductSetRequest) (*ProductSet, error)
	// Permanently deletes a ProductSet. Products and ReferenceImages in the
	// ProductSet are not deleted.
	//
	// The actual image files are not deleted from Google Cloud Storage.
	DeleteProductSet(context.Context, *DeleteProductSetRequest) (*emptypb.Empty, error)
	// Creates and returns a new product resource.
	//
	// Possible errors:
	//
	// * Returns INVALID_ARGUMENT if display_name is missing or longer than 4096
	//   characters.
	// * Returns INVALID_ARGUMENT if description is longer than 4096 characters.
	// * Returns INVALID_ARGUMENT if product_category is missing or invalid.
	CreateProduct(context.Context, *CreateProductRequest) (*Product, error)
	// Lists products in an unspecified order.
	//
	// Possible errors:
	//
	// * Returns INVALID_ARGUMENT if page_size is greater than 100 or less than 1.
	ListProducts(context.Context, *ListProductsRequest) (*ListProductsResponse, error)
	// Gets information associated with a Product.
	//
	// Possible errors:
	//
	// * Returns NOT_FOUND if the Product does not exist.
	GetProduct(context.Context, *GetProductRequest) (*Product, error)
	// Makes changes to a Product resource.
	// Only the `display_name`, `description`, and `labels` fields can be updated
	// right now.
	//
	// If labels are updated, the change will not be reflected in queries until
	// the next index time.
	//
	// Possible errors:
	//
	// * Returns NOT_FOUND if the Product does not exist.
	// * Returns INVALID_ARGUMENT if display_name is present in update_mask but is
	//   missing from the request or longer than 4096 characters.
	// * Returns INVALID_ARGUMENT if description is present in update_mask but is
	//   longer than 4096 characters.
	// * Returns INVALID_ARGUMENT if product_category is present in update_mask.
	UpdateProduct(context.Context, *UpdateProductRequest) (*Product, error)
	// Permanently deletes a product and its reference images.
	//
	// Metadata of the product and all its images will be deleted right away, but
	// search queries against ProductSets containing the product may still work
	// until all related caches are refreshed.
	DeleteProduct(context.Context, *DeleteProductRequest) (*emptypb.Empty, error)
	// Creates and returns a new ReferenceImage resource.
	//
	// The `bounding_poly` field is optional. If `bounding_poly` is not specified,
	// the system will try to detect regions of interest in the image that are
	// compatible with the product_category on the parent product. If it is
	// specified, detection is ALWAYS skipped. The system converts polygons into
	// non-rotated rectangles.
	//
	// Note that the pipeline will resize the image if the image resolution is too
	// large to process (above 50MP).
	//
	// Possible errors:
	//
	// * Returns INVALID_ARGUMENT if the image_uri is missing or longer than 4096
	//   characters.
	// * Returns INVALID_ARGUMENT if the product does not exist.
	// * Returns INVALID_ARGUMENT if bounding_poly is not provided, and nothing
	//   compatible with the parent product's product_category is detected.
	// * Returns INVALID_ARGUMENT if bounding_poly contains more than 10 polygons.
	CreateReferenceImage(context.Context, *CreateReferenceImageRequest) (*ReferenceImage, error)
	// Permanently deletes a reference image.
	//
	// The image metadata will be deleted right away, but search queries
	// against ProductSets containing the image may still work until all related
	// caches are refreshed.
	//
	// The actual image files are not deleted from Google Cloud Storage.
	DeleteReferenceImage(context.Context, *DeleteReferenceImageRequest) (*emptypb.Empty, error)
	// Lists reference images.
	//
	// Possible errors:
	//
	// * Returns NOT_FOUND if the parent product does not exist.
	// * Returns INVALID_ARGUMENT if the page_size is greater than 100, or less
	//   than 1.
	ListReferenceImages(context.Context, *ListReferenceImagesRequest) (*ListReferenceImagesResponse, error)
	// Gets information associated with a ReferenceImage.
	//
	// Possible errors:
	//
	// * Returns NOT_FOUND if the specified image does not exist.
	GetReferenceImage(context.Context, *GetReferenceImageRequest) (*ReferenceImage, error)
	// Adds a Product to the specified ProductSet. If the Product is already
	// present, no change is made.
	//
	// One Product can be added to at most 100 ProductSets.
	//
	// Possible errors:
	//
	// * Returns NOT_FOUND if the Product or the ProductSet doesn't exist.
	AddProductToProductSet(context.Context, *AddProductToProductSetRequest) (*emptypb.Empty, error)
	// Removes a Product from the specified ProductSet.
	RemoveProductFromProductSet(context.Context, *RemoveProductFromProductSetRequest) (*emptypb.Empty, error)
	// Lists the Products in a ProductSet, in an unspecified order. If the
	// ProductSet does not exist, the products field of the response will be
	// empty.
	//
	// Possible errors:
	//
	// * Returns INVALID_ARGUMENT if page_size is greater than 100 or less than 1.
	ListProductsInProductSet(context.Context, *ListProductsInProductSetRequest) (*ListProductsInProductSetResponse, error)
	// Asynchronous API that imports a list of reference images to specified
	// product sets based on a list of image information.
	//
	// The [google.longrunning.Operation][google.longrunning.Operation] API can be used to keep track of the
	// progress and results of the request.
	// `Operation.metadata` contains `BatchOperationMetadata`. (progress)
	// `Operation.response` contains `ImportProductSetsResponse`. (results)
	//
	// The input source of this method is a csv file on Google Cloud Storage.
	// For the format of the csv file please see
	// [ImportProductSetsGcsSource.csv_file_uri][google.cloud.vision.v1.ImportProductSetsGcsSource.csv_file_uri].
	ImportProductSets(context.Context, *ImportProductSetsRequest) (*longrunning.Operation, error)
	// Asynchronous API to delete all Products in a ProductSet or all Products
	// that are in no ProductSet.
	//
	// If a Product is a member of the specified ProductSet in addition to other
	// ProductSets, the Product will still be deleted.
	//
	// It is recommended to not delete the specified ProductSet until after this
	// operation has completed. It is also recommended to not add any of the
	// Products involved in the batch delete to a new ProductSet while this
	// operation is running because those Products may still end up deleted.
	//
	// It's not possible to undo the PurgeProducts operation. Therefore, it is
	// recommended to keep the csv files used in ImportProductSets (if that was
	// how you originally built the Product Set) before starting PurgeProducts, in
	// case you need to re-import the data after deletion.
	//
	// If the plan is to purge all of the Products from a ProductSet and then
	// re-use the empty ProductSet to re-import new Products into the empty
	// ProductSet, you must wait until the PurgeProducts operation has finished
	// for that ProductSet.
	//
	// The [google.longrunning.Operation][google.longrunning.Operation] API can be used to keep track of the
	// progress and results of the request.
	// `Operation.metadata` contains `BatchOperationMetadata`. (progress)
	PurgeProducts(context.Context, *PurgeProductsRequest) (*longrunning.Operation, error)
}

// UnimplementedProductSearchServer can be embedded to have forward compatible implementations.
type UnimplementedProductSearchServer struct {
}

func (*UnimplementedProductSearchServer) CreateProductSet(context.Context, *CreateProductSetRequest) (*ProductSet, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateProductSet not implemented")
}
func (*UnimplementedProductSearchServer) ListProductSets(context.Context, *ListProductSetsRequest) (*ListProductSetsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListProductSets not implemented")
}
func (*UnimplementedProductSearchServer) GetProductSet(context.Context, *GetProductSetRequest) (*ProductSet, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetProductSet not implemented")
}
func (*UnimplementedProductSearchServer) UpdateProductSet(context.Context, *UpdateProductSetRequest) (*ProductSet, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UpdateProductSet not implemented")
}
func (*UnimplementedProductSearchServer) DeleteProductSet(context.Context, *DeleteProductSetRequest) (*emptypb.Empty, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeleteProductSet not implemented")
}
func (*UnimplementedProductSearchServer) CreateProduct(context.Context, *CreateProductRequest) (*Product, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateProduct not implemented")
}
func (*UnimplementedProductSearchServer) ListProducts(context.Context, *ListProductsRequest) (*ListProductsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListProducts not implemented")
}
func (*UnimplementedProductSearchServer) GetProduct(context.Context, *GetProductRequest) (*Product, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetProduct not implemented")
}
func (*UnimplementedProductSearchServer) UpdateProduct(context.Context, *UpdateProductRequest) (*Product, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UpdateProduct not implemented")
}
func (*UnimplementedProductSearchServer) DeleteProduct(context.Context, *DeleteProductRequest) (*emptypb.Empty, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeleteProduct not implemented")
}
func (*UnimplementedProductSearchServer) CreateReferenceImage(context.Context, *CreateReferenceImageRequest) (*ReferenceImage, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateReferenceImage not implemented")
}
func (*UnimplementedProductSearchServer) DeleteReferenceImage(context.Context, *DeleteReferenceImageRequest) (*emptypb.Empty, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeleteReferenceImage not implemented")
}
func (*UnimplementedProductSearchServer) ListReferenceImages(context.Context, *ListReferenceImagesRequest) (*ListReferenceImagesResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListReferenceImages not implemented")
}
func (*UnimplementedProductSearchServer) GetReferenceImage(context.Context, *GetReferenceImageRequest) (*ReferenceImage, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetReferenceImage not implemented")
}
func (*UnimplementedProductSearchServer) AddProductToProductSet(context.Context, *AddProductToProductSetRequest) (*emptypb.Empty, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method AddProductToProductSet not implemented")
}
func (*UnimplementedProductSearchServer) RemoveProductFromProductSet(context.Context, *RemoveProductFromProductSetRequest) (*emptypb.Empty, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method RemoveProductFromProductSet not implemented")
}
func (*UnimplementedProductSearchServer) ListProductsInProductSet(context.Context, *ListProductsInProductSetRequest) (*ListProductsInProductSetResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListProductsInProductSet not implemented")
}
func (*UnimplementedProductSearchServer) ImportProductSets(context.Context, *ImportProductSetsRequest) (*longrunning.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ImportProductSets not implemented")
}
func (*UnimplementedProductSearchServer) PurgeProducts(context.Context, *PurgeProductsRequest) (*longrunning.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method PurgeProducts not implemented")
}

func RegisterProductSearchServer(s *grpc.Server, srv ProductSearchServer) {
	s.RegisterService(&_ProductSearch_serviceDesc, srv)
}

func _ProductSearch_CreateProductSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateProductSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProductSearchServer).CreateProductSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vision.v1.ProductSearch/CreateProductSet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProductSearchServer).CreateProductSet(ctx, req.(*CreateProductSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProductSearch_ListProductSets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListProductSetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProductSearchServer).ListProductSets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vision.v1.ProductSearch/ListProductSets",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProductSearchServer).ListProductSets(ctx, req.(*ListProductSetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProductSearch_GetProductSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetProductSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProductSearchServer).GetProductSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vision.v1.ProductSearch/GetProductSet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProductSearchServer).GetProductSet(ctx, req.(*GetProductSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProductSearch_UpdateProductSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateProductSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProductSearchServer).UpdateProductSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vision.v1.ProductSearch/UpdateProductSet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProductSearchServer).UpdateProductSet(ctx, req.(*UpdateProductSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProductSearch_DeleteProductSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteProductSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProductSearchServer).DeleteProductSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vision.v1.ProductSearch/DeleteProductSet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProductSearchServer).DeleteProductSet(ctx, req.(*DeleteProductSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProductSearch_CreateProduct_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateProductRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProductSearchServer).CreateProduct(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vision.v1.ProductSearch/CreateProduct",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProductSearchServer).CreateProduct(ctx, req.(*CreateProductRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProductSearch_ListProducts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListProductsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProductSearchServer).ListProducts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vision.v1.ProductSearch/ListProducts",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProductSearchServer).ListProducts(ctx, req.(*ListProductsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProductSearch_GetProduct_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetProductRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProductSearchServer).GetProduct(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vision.v1.ProductSearch/GetProduct",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProductSearchServer).GetProduct(ctx, req.(*GetProductRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProductSearch_UpdateProduct_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateProductRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProductSearchServer).UpdateProduct(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vision.v1.ProductSearch/UpdateProduct",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProductSearchServer).UpdateProduct(ctx, req.(*UpdateProductRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProductSearch_DeleteProduct_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteProductRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProductSearchServer).DeleteProduct(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vision.v1.ProductSearch/DeleteProduct",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProductSearchServer).DeleteProduct(ctx, req.(*DeleteProductRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProductSearch_CreateReferenceImage_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateReferenceImageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProductSearchServer).CreateReferenceImage(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vision.v1.ProductSearch/CreateReferenceImage",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProductSearchServer).CreateReferenceImage(ctx, req.(*CreateReferenceImageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProductSearch_DeleteReferenceImage_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteReferenceImageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProductSearchServer).DeleteReferenceImage(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vision.v1.ProductSearch/DeleteReferenceImage",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProductSearchServer).DeleteReferenceImage(ctx, req.(*DeleteReferenceImageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProductSearch_ListReferenceImages_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListReferenceImagesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProductSearchServer).ListReferenceImages(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vision.v1.ProductSearch/ListReferenceImages",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProductSearchServer).ListReferenceImages(ctx, req.(*ListReferenceImagesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProductSearch_GetReferenceImage_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetReferenceImageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProductSearchServer).GetReferenceImage(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vision.v1.ProductSearch/GetReferenceImage",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProductSearchServer).GetReferenceImage(ctx, req.(*GetReferenceImageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProductSearch_AddProductToProductSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddProductToProductSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProductSearchServer).AddProductToProductSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vision.v1.ProductSearch/AddProductToProductSet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProductSearchServer).AddProductToProductSet(ctx, req.(*AddProductToProductSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProductSearch_RemoveProductFromProductSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RemoveProductFromProductSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProductSearchServer).RemoveProductFromProductSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vision.v1.ProductSearch/RemoveProductFromProductSet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProductSearchServer).RemoveProductFromProductSet(ctx, req.(*RemoveProductFromProductSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProductSearch_ListProductsInProductSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListProductsInProductSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProductSearchServer).ListProductsInProductSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vision.v1.ProductSearch/ListProductsInProductSet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProductSearchServer).ListProductsInProductSet(ctx, req.(*ListProductsInProductSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProductSearch_ImportProductSets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImportProductSetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProductSearchServer).ImportProductSets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vision.v1.ProductSearch/ImportProductSets",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProductSearchServer).ImportProductSets(ctx, req.(*ImportProductSetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProductSearch_PurgeProducts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PurgeProductsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProductSearchServer).PurgeProducts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vision.v1.ProductSearch/PurgeProducts",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProductSearchServer).PurgeProducts(ctx, req.(*PurgeProductsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ProductSearch_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.vision.v1.ProductSearch",
	HandlerType: (*ProductSearchServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateProductSet",
			Handler:    _ProductSearch_CreateProductSet_Handler,
		},
		{
			MethodName: "ListProductSets",
			Handler:    _ProductSearch_ListProductSets_Handler,
		},
		{
			MethodName: "GetProductSet",
			Handler:    _ProductSearch_GetProductSet_Handler,
		},
		{
			MethodName: "UpdateProductSet",
			Handler:    _ProductSearch_UpdateProductSet_Handler,
		},
		{
			MethodName: "DeleteProductSet",
			Handler:    _ProductSearch_DeleteProductSet_Handler,
		},
		{
			MethodName: "CreateProduct",
			Handler:    _ProductSearch_CreateProduct_Handler,
		},
		{
			MethodName: "ListProducts",
			Handler:    _ProductSearch_ListProducts_Handler,
		},
		{
			MethodName: "GetProduct",
			Handler:    _ProductSearch_GetProduct_Handler,
		},
		{
			MethodName: "UpdateProduct",
			Handler:    _ProductSearch_UpdateProduct_Handler,
		},
		{
			MethodName: "DeleteProduct",
			Handler:    _ProductSearch_DeleteProduct_Handler,
		},
		{
			MethodName: "CreateReferenceImage",
			Handler:    _ProductSearch_CreateReferenceImage_Handler,
		},
		{
			MethodName: "DeleteReferenceImage",
			Handler:    _ProductSearch_DeleteReferenceImage_Handler,
		},
		{
			MethodName: "ListReferenceImages",
			Handler:    _ProductSearch_ListReferenceImages_Handler,
		},
		{
			MethodName: "GetReferenceImage",
			Handler:    _ProductSearch_GetReferenceImage_Handler,
		},
		{
			MethodName: "AddProductToProductSet",
			Handler:    _ProductSearch_AddProductToProductSet_Handler,
		},
		{
			MethodName: "RemoveProductFromProductSet",
			Handler:    _ProductSearch_RemoveProductFromProductSet_Handler,
		},
		{
			MethodName: "ListProductsInProductSet",
			Handler:    _ProductSearch_ListProductsInProductSet_Handler,
		},
		{
			MethodName: "ImportProductSets",
			Handler:    _ProductSearch_ImportProductSets_Handler,
		},
		{
			MethodName: "PurgeProducts",
			Handler:    _ProductSearch_PurgeProducts_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/vision/v1/product_search_service.proto",
}
