## helm version

Print the client/server version information

### Synopsis


Show the client and server versions for Helm and tiller.

This will print a representation of the client and server versions of Helm and
Tiller. The output will look something like this:

Client: &version.Version{SemVer:"v2.0.0", GitCommit:"ff52399e51bb880526e9cd0ed8386f6433b74da1", GitTreeState:"clean"}
Server: &version.Version{SemVer:"v2.0.0", GitCommit:"b0c113dfb9f612a9add796549da66c0d294508a3", GitTreeState:"clean"}

- SemVer is the semantic version of the release.
- GitCommit is the SHA for the commit that this version was built from.
- GitTreeState is "clean" if there are no local code changes when this binary was
  built, and "dirty" if the binary was built from locally modified code.

To print just the client version, use '--client'. To print just the server version,
use '--server'.


```
helm version [flags]
```

### Options

```
  -c, --client                Client version only
  -h, --help                  help for version
  -s, --server                Server version only
      --short                 Print the version number
      --template string       Template for version string format
      --tls                   Enable TLS for request
      --tls-ca-cert string    Path to TLS CA certificate file (default "$HELM_HOME/ca.pem")
      --tls-cert string       Path to TLS certificate file (default "$HELM_HOME/cert.pem")
      --tls-hostname string   The server name used to verify the hostname on the returned certificates from the server
      --tls-key string        Path to TLS key file (default "$HELM_HOME/key.pem")
      --tls-verify            Enable TLS for request and verify remote
```

### Options inherited from parent commands

```
      --debug                           Enable verbose output
      --home string                     Location of your Helm config. Overrides $HELM_HOME (default "~/.helm")
      --host string                     Address of Tiller. Overrides $HELM_HOST
      --kube-context string             Name of the kubeconfig context to use
      --kubeconfig string               Absolute path of the kubeconfig file to be used
      --tiller-connection-timeout int   The duration (in seconds) Helm will wait to establish a connection to Tiller (default 300)
      --tiller-namespace string         Namespace of Tiller (default "kube-system")
```

### SEE ALSO

* [helm](helm.md)	 - The Helm package manager for Kubernetes.

###### Auto generated by spf13/cobra on 16-May-2019
