## helm delete

Given a release name, delete the release from Kubernetes

### Synopsis


This command takes a release name, and then deletes the release from Kubernetes.
It removes all of the resources associated with the last release of the chart.

Use the '--dry-run' flag to see which releases will be deleted without actually
deleting them.


```
helm delete [flags] RELEASE_NAME [...]
```

### Options

```
      --description string    Specify a description for the release
      --dry-run               Simulate a delete
  -h, --help                  help for delete
      --no-hooks              Prevent hooks from running during deletion
      --purge                 Remove the release from the store and make its name free for later use
      --timeout int           Time in seconds to wait for any individual Kubernetes operation (like Jobs for hooks) (default 300)
      --tls                   Enable TLS for request
      --tls-ca-cert string    Path to TLS CA certificate file (default "$HELM_HOME/ca.pem")
      --tls-cert string       Path to TLS certificate file (default "$HELM_HOME/cert.pem")
      --tls-hostname string   The server name used to verify the hostname on the returned certificates from the server
      --tls-key string        Path to TLS key file (default "$HELM_HOME/key.pem")
      --tls-verify            Enable TLS for request and verify remote
```

### Options inherited from parent commands

```
      --debug                           Enable verbose output
      --home string                     Location of your Helm config. Overrides $HELM_HOME (default "~/.helm")
      --host string                     Address of Tiller. Overrides $HELM_HOST
      --kube-context string             Name of the kubeconfig context to use
      --kubeconfig string               Absolute path of the kubeconfig file to be used
      --tiller-connection-timeout int   The duration (in seconds) Helm will wait to establish a connection to Tiller (default 300)
      --tiller-namespace string         Namespace of Tiller (default "kube-system")
```

### SEE ALSO

* [helm](helm.md)	 - The Helm package manager for Kubernetes.

###### Auto generated by spf13/cobra on 16-May-2019
