// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/binaryauthorization/v1beta1/resources.proto

package binaryauthorization

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type Policy_GlobalPolicyEvaluationMode int32

const (
	// Not specified: DISABLE is assumed.
	Policy_GLOBAL_POLICY_EVALUATION_MODE_UNSPECIFIED Policy_GlobalPolicyEvaluationMode = 0
	// Enables global policy evaluation.
	Policy_ENABLE Policy_GlobalPolicyEvaluationMode = 1
	// Disables global policy evaluation.
	Policy_DISABLE Policy_GlobalPolicyEvaluationMode = 2
)

var Policy_GlobalPolicyEvaluationMode_name = map[int32]string{
	0: "GLOBAL_POLICY_EVALUATION_MODE_UNSPECIFIED",
	1: "ENABLE",
	2: "DISABLE",
}

var Policy_GlobalPolicyEvaluationMode_value = map[string]int32{
	"GLOBAL_POLICY_EVALUATION_MODE_UNSPECIFIED": 0,
	"ENABLE":  1,
	"DISABLE": 2,
}

func (x Policy_GlobalPolicyEvaluationMode) String() string {
	return proto.EnumName(Policy_GlobalPolicyEvaluationMode_name, int32(x))
}

func (Policy_GlobalPolicyEvaluationMode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_1b83e716c45ff98c, []int{0, 0}
}

type AdmissionRule_EvaluationMode int32

const (
	// Do not use.
	AdmissionRule_EVALUATION_MODE_UNSPECIFIED AdmissionRule_EvaluationMode = 0
	// This rule allows all all pod creations.
	AdmissionRule_ALWAYS_ALLOW AdmissionRule_EvaluationMode = 1
	// This rule allows a pod creation if all the attestors listed in
	// 'require_attestations_by' have valid attestations for all of the
	// images in the pod spec.
	AdmissionRule_REQUIRE_ATTESTATION AdmissionRule_EvaluationMode = 2
	// This rule denies all pod creations.
	AdmissionRule_ALWAYS_DENY AdmissionRule_EvaluationMode = 3
)

var AdmissionRule_EvaluationMode_name = map[int32]string{
	0: "EVALUATION_MODE_UNSPECIFIED",
	1: "ALWAYS_ALLOW",
	2: "REQUIRE_ATTESTATION",
	3: "ALWAYS_DENY",
}

var AdmissionRule_EvaluationMode_value = map[string]int32{
	"EVALUATION_MODE_UNSPECIFIED": 0,
	"ALWAYS_ALLOW":                1,
	"REQUIRE_ATTESTATION":         2,
	"ALWAYS_DENY":                 3,
}

func (x AdmissionRule_EvaluationMode) String() string {
	return proto.EnumName(AdmissionRule_EvaluationMode_name, int32(x))
}

func (AdmissionRule_EvaluationMode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_1b83e716c45ff98c, []int{2, 0}
}

// Defines the possible actions when a pod creation is denied by an admission
// rule.
type AdmissionRule_EnforcementMode int32

const (
	// Do not use.
	AdmissionRule_ENFORCEMENT_MODE_UNSPECIFIED AdmissionRule_EnforcementMode = 0
	// Enforce the admission rule by blocking the pod creation.
	AdmissionRule_ENFORCED_BLOCK_AND_AUDIT_LOG AdmissionRule_EnforcementMode = 1
	// Dryrun mode: Audit logging only.  This will allow the pod creation as if
	// the admission request had specified break-glass.
	AdmissionRule_DRYRUN_AUDIT_LOG_ONLY AdmissionRule_EnforcementMode = 2
)

var AdmissionRule_EnforcementMode_name = map[int32]string{
	0: "ENFORCEMENT_MODE_UNSPECIFIED",
	1: "ENFORCED_BLOCK_AND_AUDIT_LOG",
	2: "DRYRUN_AUDIT_LOG_ONLY",
}

var AdmissionRule_EnforcementMode_value = map[string]int32{
	"ENFORCEMENT_MODE_UNSPECIFIED": 0,
	"ENFORCED_BLOCK_AND_AUDIT_LOG": 1,
	"DRYRUN_AUDIT_LOG_ONLY":        2,
}

func (x AdmissionRule_EnforcementMode) String() string {
	return proto.EnumName(AdmissionRule_EnforcementMode_name, int32(x))
}

func (AdmissionRule_EnforcementMode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_1b83e716c45ff98c, []int{2, 1}
}

// Represents a signature algorithm and other information necessary to verify
// signatures with a given public key.
// This is based primarily on the public key types supported by Tink's
// PemKeyType, which is in turn based on KMS's supported signing algorithms.
// See https://cloud.google.com/kms/docs/algorithms. In the future, BinAuthz
// might support additional public key types independently of Tink and/or KMS.
type PkixPublicKey_SignatureAlgorithm int32

const (
	// Not specified.
	PkixPublicKey_SIGNATURE_ALGORITHM_UNSPECIFIED PkixPublicKey_SignatureAlgorithm = 0
	// RSASSA-PSS 2048 bit key with a SHA256 digest.
	PkixPublicKey_RSA_PSS_2048_SHA256 PkixPublicKey_SignatureAlgorithm = 1
	// RSASSA-PSS 3072 bit key with a SHA256 digest.
	PkixPublicKey_RSA_PSS_3072_SHA256 PkixPublicKey_SignatureAlgorithm = 2
	// RSASSA-PSS 4096 bit key with a SHA256 digest.
	PkixPublicKey_RSA_PSS_4096_SHA256 PkixPublicKey_SignatureAlgorithm = 3
	// RSASSA-PSS 4096 bit key with a SHA512 digest.
	PkixPublicKey_RSA_PSS_4096_SHA512 PkixPublicKey_SignatureAlgorithm = 4
	// RSASSA-PKCS1-v1_5 with a 2048 bit key and a SHA256 digest.
	PkixPublicKey_RSA_SIGN_PKCS1_2048_SHA256 PkixPublicKey_SignatureAlgorithm = 5
	// RSASSA-PKCS1-v1_5 with a 3072 bit key and a SHA256 digest.
	PkixPublicKey_RSA_SIGN_PKCS1_3072_SHA256 PkixPublicKey_SignatureAlgorithm = 6
	// RSASSA-PKCS1-v1_5 with a 4096 bit key and a SHA256 digest.
	PkixPublicKey_RSA_SIGN_PKCS1_4096_SHA256 PkixPublicKey_SignatureAlgorithm = 7
	// RSASSA-PKCS1-v1_5 with a 4096 bit key and a SHA512 digest.
	PkixPublicKey_RSA_SIGN_PKCS1_4096_SHA512 PkixPublicKey_SignatureAlgorithm = 8
	// ECDSA on the NIST P-256 curve with a SHA256 digest.
	PkixPublicKey_ECDSA_P256_SHA256 PkixPublicKey_SignatureAlgorithm = 9
	// ECDSA on the NIST P-384 curve with a SHA384 digest.
	PkixPublicKey_ECDSA_P384_SHA384 PkixPublicKey_SignatureAlgorithm = 10
	// ECDSA on the NIST P-521 curve with a SHA512 digest.
	PkixPublicKey_ECDSA_P521_SHA512 PkixPublicKey_SignatureAlgorithm = 11
)

var PkixPublicKey_SignatureAlgorithm_name = map[int32]string{
	0:  "SIGNATURE_ALGORITHM_UNSPECIFIED",
	1:  "RSA_PSS_2048_SHA256",
	2:  "RSA_PSS_3072_SHA256",
	3:  "RSA_PSS_4096_SHA256",
	4:  "RSA_PSS_4096_SHA512",
	5:  "RSA_SIGN_PKCS1_2048_SHA256",
	6:  "RSA_SIGN_PKCS1_3072_SHA256",
	7:  "RSA_SIGN_PKCS1_4096_SHA256",
	8:  "RSA_SIGN_PKCS1_4096_SHA512",
	9:  "ECDSA_P256_SHA256",
	10: "ECDSA_P384_SHA384",
	11: "ECDSA_P521_SHA512",
}

var PkixPublicKey_SignatureAlgorithm_value = map[string]int32{
	"SIGNATURE_ALGORITHM_UNSPECIFIED": 0,
	"RSA_PSS_2048_SHA256":             1,
	"RSA_PSS_3072_SHA256":             2,
	"RSA_PSS_4096_SHA256":             3,
	"RSA_PSS_4096_SHA512":             4,
	"RSA_SIGN_PKCS1_2048_SHA256":      5,
	"RSA_SIGN_PKCS1_3072_SHA256":      6,
	"RSA_SIGN_PKCS1_4096_SHA256":      7,
	"RSA_SIGN_PKCS1_4096_SHA512":      8,
	"ECDSA_P256_SHA256":               9,
	"ECDSA_P384_SHA384":               10,
	"ECDSA_P521_SHA512":               11,
}

func (x PkixPublicKey_SignatureAlgorithm) String() string {
	return proto.EnumName(PkixPublicKey_SignatureAlgorithm_name, int32(x))
}

func (PkixPublicKey_SignatureAlgorithm) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_1b83e716c45ff98c, []int{5, 0}
}

// A [policy][google.cloud.binaryauthorization.v1beta1.Policy] for container image binary authorization.
type Policy struct {
	// Output only. The resource name, in the format `projects/*/policy`. There is
	// at most one policy per project.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. A descriptive comment.
	Description string `protobuf:"bytes,6,opt,name=description,proto3" json:"description,omitempty"`
	// Optional. Controls the evaluation of a Google-maintained global admission
	// policy for common system-level images. Images not covered by the global
	// policy will be subject to the project admission policy. This setting
	// has no effect when specified inside a global admission policy.
	GlobalPolicyEvaluationMode Policy_GlobalPolicyEvaluationMode `protobuf:"varint,7,opt,name=global_policy_evaluation_mode,json=globalPolicyEvaluationMode,proto3,enum=google.cloud.binaryauthorization.v1beta1.Policy_GlobalPolicyEvaluationMode" json:"global_policy_evaluation_mode,omitempty"`
	// Optional. Admission policy whitelisting. A matching admission request will
	// always be permitted. This feature is typically used to exclude Google or
	// third-party infrastructure images from Binary Authorization policies.
	AdmissionWhitelistPatterns []*AdmissionWhitelistPattern `protobuf:"bytes,2,rep,name=admission_whitelist_patterns,json=admissionWhitelistPatterns,proto3" json:"admission_whitelist_patterns,omitempty"`
	// Optional. Per-cluster admission rules. Cluster spec format:
	// `location.clusterId`. There can be at most one admission rule per cluster
	// spec.
	// A `location` is either a compute zone (e.g. us-central1-a) or a region
	// (e.g. us-central1).
	// For `clusterId` syntax restrictions see
	// https://cloud.google.com/container-engine/reference/rest/v1/projects.zones.clusters.
	ClusterAdmissionRules map[string]*AdmissionRule `protobuf:"bytes,3,rep,name=cluster_admission_rules,json=clusterAdmissionRules,proto3" json:"cluster_admission_rules,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Required. Default admission rule for a cluster without a per-cluster, per-
	// kubernetes-service-account, or per-istio-service-identity admission rule.
	DefaultAdmissionRule *AdmissionRule `protobuf:"bytes,4,opt,name=default_admission_rule,json=defaultAdmissionRule,proto3" json:"default_admission_rule,omitempty"`
	// Output only. Time when the policy was last updated.
	UpdateTime           *timestamp.Timestamp `protobuf:"bytes,5,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *Policy) Reset()         { *m = Policy{} }
func (m *Policy) String() string { return proto.CompactTextString(m) }
func (*Policy) ProtoMessage()    {}
func (*Policy) Descriptor() ([]byte, []int) {
	return fileDescriptor_1b83e716c45ff98c, []int{0}
}

func (m *Policy) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Policy.Unmarshal(m, b)
}
func (m *Policy) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Policy.Marshal(b, m, deterministic)
}
func (m *Policy) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Policy.Merge(m, src)
}
func (m *Policy) XXX_Size() int {
	return xxx_messageInfo_Policy.Size(m)
}
func (m *Policy) XXX_DiscardUnknown() {
	xxx_messageInfo_Policy.DiscardUnknown(m)
}

var xxx_messageInfo_Policy proto.InternalMessageInfo

func (m *Policy) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Policy) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Policy) GetGlobalPolicyEvaluationMode() Policy_GlobalPolicyEvaluationMode {
	if m != nil {
		return m.GlobalPolicyEvaluationMode
	}
	return Policy_GLOBAL_POLICY_EVALUATION_MODE_UNSPECIFIED
}

func (m *Policy) GetAdmissionWhitelistPatterns() []*AdmissionWhitelistPattern {
	if m != nil {
		return m.AdmissionWhitelistPatterns
	}
	return nil
}

func (m *Policy) GetClusterAdmissionRules() map[string]*AdmissionRule {
	if m != nil {
		return m.ClusterAdmissionRules
	}
	return nil
}

func (m *Policy) GetDefaultAdmissionRule() *AdmissionRule {
	if m != nil {
		return m.DefaultAdmissionRule
	}
	return nil
}

func (m *Policy) GetUpdateTime() *timestamp.Timestamp {
	if m != nil {
		return m.UpdateTime
	}
	return nil
}

// An [admission whitelist pattern][google.cloud.binaryauthorization.v1beta1.AdmissionWhitelistPattern] exempts images
// from checks by [admission rules][google.cloud.binaryauthorization.v1beta1.AdmissionRule].
type AdmissionWhitelistPattern struct {
	// An image name pattern to whitelist, in the form `registry/path/to/image`.
	// This supports a trailing `*` as a wildcard, but this is allowed only in
	// text after the `registry/` part.
	NamePattern          string   `protobuf:"bytes,1,opt,name=name_pattern,json=namePattern,proto3" json:"name_pattern,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AdmissionWhitelistPattern) Reset()         { *m = AdmissionWhitelistPattern{} }
func (m *AdmissionWhitelistPattern) String() string { return proto.CompactTextString(m) }
func (*AdmissionWhitelistPattern) ProtoMessage()    {}
func (*AdmissionWhitelistPattern) Descriptor() ([]byte, []int) {
	return fileDescriptor_1b83e716c45ff98c, []int{1}
}

func (m *AdmissionWhitelistPattern) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AdmissionWhitelistPattern.Unmarshal(m, b)
}
func (m *AdmissionWhitelistPattern) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AdmissionWhitelistPattern.Marshal(b, m, deterministic)
}
func (m *AdmissionWhitelistPattern) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AdmissionWhitelistPattern.Merge(m, src)
}
func (m *AdmissionWhitelistPattern) XXX_Size() int {
	return xxx_messageInfo_AdmissionWhitelistPattern.Size(m)
}
func (m *AdmissionWhitelistPattern) XXX_DiscardUnknown() {
	xxx_messageInfo_AdmissionWhitelistPattern.DiscardUnknown(m)
}

var xxx_messageInfo_AdmissionWhitelistPattern proto.InternalMessageInfo

func (m *AdmissionWhitelistPattern) GetNamePattern() string {
	if m != nil {
		return m.NamePattern
	}
	return ""
}

// An [admission rule][google.cloud.binaryauthorization.v1beta1.AdmissionRule] specifies either that all container images
// used in a pod creation request must be attested to by one or more
// [attestors][google.cloud.binaryauthorization.v1beta1.Attestor], that all pod creations will be allowed, or that all
// pod creations will be denied.
//
// Images matching an [admission whitelist pattern][google.cloud.binaryauthorization.v1beta1.AdmissionWhitelistPattern]
// are exempted from admission rules and will never block a pod creation.
type AdmissionRule struct {
	// Required. How this admission rule will be evaluated.
	EvaluationMode AdmissionRule_EvaluationMode `protobuf:"varint,1,opt,name=evaluation_mode,json=evaluationMode,proto3,enum=google.cloud.binaryauthorization.v1beta1.AdmissionRule_EvaluationMode" json:"evaluation_mode,omitempty"`
	// Optional. The resource names of the attestors that must attest to
	// a container image, in the format `projects/*/attestors/*`. Each
	// attestor must exist before a policy can reference it.  To add an attestor
	// to a policy the principal issuing the policy change request must be able
	// to read the attestor resource.
	//
	// Note: this field must be non-empty when the evaluation_mode field specifies
	// REQUIRE_ATTESTATION, otherwise it must be empty.
	RequireAttestationsBy []string `protobuf:"bytes,2,rep,name=require_attestations_by,json=requireAttestationsBy,proto3" json:"require_attestations_by,omitempty"`
	// Required. The action when a pod creation is denied by the admission rule.
	EnforcementMode      AdmissionRule_EnforcementMode `protobuf:"varint,3,opt,name=enforcement_mode,json=enforcementMode,proto3,enum=google.cloud.binaryauthorization.v1beta1.AdmissionRule_EnforcementMode" json:"enforcement_mode,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                      `json:"-"`
	XXX_unrecognized     []byte                        `json:"-"`
	XXX_sizecache        int32                         `json:"-"`
}

func (m *AdmissionRule) Reset()         { *m = AdmissionRule{} }
func (m *AdmissionRule) String() string { return proto.CompactTextString(m) }
func (*AdmissionRule) ProtoMessage()    {}
func (*AdmissionRule) Descriptor() ([]byte, []int) {
	return fileDescriptor_1b83e716c45ff98c, []int{2}
}

func (m *AdmissionRule) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AdmissionRule.Unmarshal(m, b)
}
func (m *AdmissionRule) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AdmissionRule.Marshal(b, m, deterministic)
}
func (m *AdmissionRule) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AdmissionRule.Merge(m, src)
}
func (m *AdmissionRule) XXX_Size() int {
	return xxx_messageInfo_AdmissionRule.Size(m)
}
func (m *AdmissionRule) XXX_DiscardUnknown() {
	xxx_messageInfo_AdmissionRule.DiscardUnknown(m)
}

var xxx_messageInfo_AdmissionRule proto.InternalMessageInfo

func (m *AdmissionRule) GetEvaluationMode() AdmissionRule_EvaluationMode {
	if m != nil {
		return m.EvaluationMode
	}
	return AdmissionRule_EVALUATION_MODE_UNSPECIFIED
}

func (m *AdmissionRule) GetRequireAttestationsBy() []string {
	if m != nil {
		return m.RequireAttestationsBy
	}
	return nil
}

func (m *AdmissionRule) GetEnforcementMode() AdmissionRule_EnforcementMode {
	if m != nil {
		return m.EnforcementMode
	}
	return AdmissionRule_ENFORCEMENT_MODE_UNSPECIFIED
}

// An [attestor][google.cloud.binaryauthorization.v1beta1.Attestor] that attests to container image
// artifacts. An existing attestor cannot be modified except where
// indicated.
type Attestor struct {
	// Required. The resource name, in the format:
	// `projects/*/attestors/*`. This field may not be updated.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. A descriptive comment.  This field may be updated.
	// The field may be displayed in chooser dialogs.
	Description string `protobuf:"bytes,6,opt,name=description,proto3" json:"description,omitempty"`
	// Required. Identifies an [attestor][google.cloud.binaryauthorization.v1beta1.Attestor] that attests to a
	// container image artifact. This determines how an attestation will
	// be stored, and how it will be used during policy
	// enforcement. Updates may not change the attestor type, but individual
	// attestor fields may be updated
	//
	// Types that are valid to be assigned to AttestorType:
	//	*Attestor_UserOwnedDrydockNote
	AttestorType isAttestor_AttestorType `protobuf_oneof:"attestor_type"`
	// Output only. Time when the attestor was last updated.
	UpdateTime           *timestamp.Timestamp `protobuf:"bytes,4,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *Attestor) Reset()         { *m = Attestor{} }
func (m *Attestor) String() string { return proto.CompactTextString(m) }
func (*Attestor) ProtoMessage()    {}
func (*Attestor) Descriptor() ([]byte, []int) {
	return fileDescriptor_1b83e716c45ff98c, []int{3}
}

func (m *Attestor) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Attestor.Unmarshal(m, b)
}
func (m *Attestor) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Attestor.Marshal(b, m, deterministic)
}
func (m *Attestor) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Attestor.Merge(m, src)
}
func (m *Attestor) XXX_Size() int {
	return xxx_messageInfo_Attestor.Size(m)
}
func (m *Attestor) XXX_DiscardUnknown() {
	xxx_messageInfo_Attestor.DiscardUnknown(m)
}

var xxx_messageInfo_Attestor proto.InternalMessageInfo

func (m *Attestor) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Attestor) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

type isAttestor_AttestorType interface {
	isAttestor_AttestorType()
}

type Attestor_UserOwnedDrydockNote struct {
	UserOwnedDrydockNote *UserOwnedDrydockNote `protobuf:"bytes,3,opt,name=user_owned_drydock_note,json=userOwnedDrydockNote,proto3,oneof"`
}

func (*Attestor_UserOwnedDrydockNote) isAttestor_AttestorType() {}

func (m *Attestor) GetAttestorType() isAttestor_AttestorType {
	if m != nil {
		return m.AttestorType
	}
	return nil
}

func (m *Attestor) GetUserOwnedDrydockNote() *UserOwnedDrydockNote {
	if x, ok := m.GetAttestorType().(*Attestor_UserOwnedDrydockNote); ok {
		return x.UserOwnedDrydockNote
	}
	return nil
}

func (m *Attestor) GetUpdateTime() *timestamp.Timestamp {
	if m != nil {
		return m.UpdateTime
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Attestor) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Attestor_UserOwnedDrydockNote)(nil),
	}
}

// An [user owned drydock note][google.cloud.binaryauthorization.v1beta1.UserOwnedDrydockNote] references a Drydock
// ATTESTATION_AUTHORITY Note created by the user.
type UserOwnedDrydockNote struct {
	// Required. The Drydock resource name of a ATTESTATION_AUTHORITY Note,
	// created by the user, in the format: `projects/*/notes/*` (or the legacy
	// `providers/*/notes/*`). This field may not be updated.
	//
	// An attestation by this attestor is stored as a Drydock
	// ATTESTATION_AUTHORITY Occurrence that names a container image and that
	// links to this Note. Drydock is an external dependency.
	NoteReference string `protobuf:"bytes,1,opt,name=note_reference,json=noteReference,proto3" json:"note_reference,omitempty"`
	// Optional. Public keys that verify attestations signed by this
	// attestor.  This field may be updated.
	//
	// If this field is non-empty, one of the specified public keys must
	// verify that an attestation was signed by this attestor for the
	// image specified in the admission request.
	//
	// If this field is empty, this attestor always returns that no
	// valid attestations exist.
	PublicKeys []*AttestorPublicKey `protobuf:"bytes,2,rep,name=public_keys,json=publicKeys,proto3" json:"public_keys,omitempty"`
	// Output only. This field will contain the service account email address
	// that this Attestor will use as the principal when querying Container
	// Analysis. Attestor administrators must grant this service account the
	// IAM role needed to read attestations from the [note_reference][Note] in
	// Container Analysis (`containeranalysis.notes.occurrences.viewer`).
	//
	// This email address is fixed for the lifetime of the Attestor, but callers
	// should not make any other assumptions about the service account email;
	// future versions may use an email based on a different naming pattern.
	DelegationServiceAccountEmail string   `protobuf:"bytes,3,opt,name=delegation_service_account_email,json=delegationServiceAccountEmail,proto3" json:"delegation_service_account_email,omitempty"`
	XXX_NoUnkeyedLiteral          struct{} `json:"-"`
	XXX_unrecognized              []byte   `json:"-"`
	XXX_sizecache                 int32    `json:"-"`
}

func (m *UserOwnedDrydockNote) Reset()         { *m = UserOwnedDrydockNote{} }
func (m *UserOwnedDrydockNote) String() string { return proto.CompactTextString(m) }
func (*UserOwnedDrydockNote) ProtoMessage()    {}
func (*UserOwnedDrydockNote) Descriptor() ([]byte, []int) {
	return fileDescriptor_1b83e716c45ff98c, []int{4}
}

func (m *UserOwnedDrydockNote) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UserOwnedDrydockNote.Unmarshal(m, b)
}
func (m *UserOwnedDrydockNote) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UserOwnedDrydockNote.Marshal(b, m, deterministic)
}
func (m *UserOwnedDrydockNote) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UserOwnedDrydockNote.Merge(m, src)
}
func (m *UserOwnedDrydockNote) XXX_Size() int {
	return xxx_messageInfo_UserOwnedDrydockNote.Size(m)
}
func (m *UserOwnedDrydockNote) XXX_DiscardUnknown() {
	xxx_messageInfo_UserOwnedDrydockNote.DiscardUnknown(m)
}

var xxx_messageInfo_UserOwnedDrydockNote proto.InternalMessageInfo

func (m *UserOwnedDrydockNote) GetNoteReference() string {
	if m != nil {
		return m.NoteReference
	}
	return ""
}

func (m *UserOwnedDrydockNote) GetPublicKeys() []*AttestorPublicKey {
	if m != nil {
		return m.PublicKeys
	}
	return nil
}

func (m *UserOwnedDrydockNote) GetDelegationServiceAccountEmail() string {
	if m != nil {
		return m.DelegationServiceAccountEmail
	}
	return ""
}

// A public key in the PkixPublicKey format (see
// https://tools.ietf.org/html/rfc5280#section-4.1.2.7 for details).
// Public keys of this type are typically textually encoded using the PEM
// format.
type PkixPublicKey struct {
	// A PEM-encoded public key, as described in
	// https://tools.ietf.org/html/rfc7468#section-13
	PublicKeyPem string `protobuf:"bytes,1,opt,name=public_key_pem,json=publicKeyPem,proto3" json:"public_key_pem,omitempty"`
	// The signature algorithm used to verify a message against a signature using
	// this key.
	// These signature algorithm must match the structure and any object
	// identifiers encoded in `public_key_pem` (i.e. this algorithm must match
	// that of the public key).
	SignatureAlgorithm   PkixPublicKey_SignatureAlgorithm `protobuf:"varint,2,opt,name=signature_algorithm,json=signatureAlgorithm,proto3,enum=google.cloud.binaryauthorization.v1beta1.PkixPublicKey_SignatureAlgorithm" json:"signature_algorithm,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                         `json:"-"`
	XXX_unrecognized     []byte                           `json:"-"`
	XXX_sizecache        int32                            `json:"-"`
}

func (m *PkixPublicKey) Reset()         { *m = PkixPublicKey{} }
func (m *PkixPublicKey) String() string { return proto.CompactTextString(m) }
func (*PkixPublicKey) ProtoMessage()    {}
func (*PkixPublicKey) Descriptor() ([]byte, []int) {
	return fileDescriptor_1b83e716c45ff98c, []int{5}
}

func (m *PkixPublicKey) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PkixPublicKey.Unmarshal(m, b)
}
func (m *PkixPublicKey) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PkixPublicKey.Marshal(b, m, deterministic)
}
func (m *PkixPublicKey) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PkixPublicKey.Merge(m, src)
}
func (m *PkixPublicKey) XXX_Size() int {
	return xxx_messageInfo_PkixPublicKey.Size(m)
}
func (m *PkixPublicKey) XXX_DiscardUnknown() {
	xxx_messageInfo_PkixPublicKey.DiscardUnknown(m)
}

var xxx_messageInfo_PkixPublicKey proto.InternalMessageInfo

func (m *PkixPublicKey) GetPublicKeyPem() string {
	if m != nil {
		return m.PublicKeyPem
	}
	return ""
}

func (m *PkixPublicKey) GetSignatureAlgorithm() PkixPublicKey_SignatureAlgorithm {
	if m != nil {
		return m.SignatureAlgorithm
	}
	return PkixPublicKey_SIGNATURE_ALGORITHM_UNSPECIFIED
}

// An [attestor public key][google.cloud.binaryauthorization.v1beta1.AttestorPublicKey] that will be used to verify
// attestations signed by this attestor.
type AttestorPublicKey struct {
	// Optional. A descriptive comment. This field may be updated.
	Comment string `protobuf:"bytes,1,opt,name=comment,proto3" json:"comment,omitempty"`
	// The ID of this public key.
	// Signatures verified by BinAuthz must include the ID of the public key that
	// can be used to verify them, and that ID must match the contents of this
	// field exactly.
	// Additional restrictions on this field can be imposed based on which public
	// key type is encapsulated. See the documentation on `public_key` cases below
	// for details.
	Id string `protobuf:"bytes,2,opt,name=id,proto3" json:"id,omitempty"`
	// Required. A public key reference or serialized instance. This field may be
	// updated.
	//
	// Types that are valid to be assigned to PublicKey:
	//	*AttestorPublicKey_AsciiArmoredPgpPublicKey
	//	*AttestorPublicKey_PkixPublicKey
	PublicKey            isAttestorPublicKey_PublicKey `protobuf_oneof:"public_key"`
	XXX_NoUnkeyedLiteral struct{}                      `json:"-"`
	XXX_unrecognized     []byte                        `json:"-"`
	XXX_sizecache        int32                         `json:"-"`
}

func (m *AttestorPublicKey) Reset()         { *m = AttestorPublicKey{} }
func (m *AttestorPublicKey) String() string { return proto.CompactTextString(m) }
func (*AttestorPublicKey) ProtoMessage()    {}
func (*AttestorPublicKey) Descriptor() ([]byte, []int) {
	return fileDescriptor_1b83e716c45ff98c, []int{6}
}

func (m *AttestorPublicKey) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AttestorPublicKey.Unmarshal(m, b)
}
func (m *AttestorPublicKey) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AttestorPublicKey.Marshal(b, m, deterministic)
}
func (m *AttestorPublicKey) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AttestorPublicKey.Merge(m, src)
}
func (m *AttestorPublicKey) XXX_Size() int {
	return xxx_messageInfo_AttestorPublicKey.Size(m)
}
func (m *AttestorPublicKey) XXX_DiscardUnknown() {
	xxx_messageInfo_AttestorPublicKey.DiscardUnknown(m)
}

var xxx_messageInfo_AttestorPublicKey proto.InternalMessageInfo

func (m *AttestorPublicKey) GetComment() string {
	if m != nil {
		return m.Comment
	}
	return ""
}

func (m *AttestorPublicKey) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

type isAttestorPublicKey_PublicKey interface {
	isAttestorPublicKey_PublicKey()
}

type AttestorPublicKey_AsciiArmoredPgpPublicKey struct {
	AsciiArmoredPgpPublicKey string `protobuf:"bytes,3,opt,name=ascii_armored_pgp_public_key,json=asciiArmoredPgpPublicKey,proto3,oneof"`
}

type AttestorPublicKey_PkixPublicKey struct {
	PkixPublicKey *PkixPublicKey `protobuf:"bytes,5,opt,name=pkix_public_key,json=pkixPublicKey,proto3,oneof"`
}

func (*AttestorPublicKey_AsciiArmoredPgpPublicKey) isAttestorPublicKey_PublicKey() {}

func (*AttestorPublicKey_PkixPublicKey) isAttestorPublicKey_PublicKey() {}

func (m *AttestorPublicKey) GetPublicKey() isAttestorPublicKey_PublicKey {
	if m != nil {
		return m.PublicKey
	}
	return nil
}

func (m *AttestorPublicKey) GetAsciiArmoredPgpPublicKey() string {
	if x, ok := m.GetPublicKey().(*AttestorPublicKey_AsciiArmoredPgpPublicKey); ok {
		return x.AsciiArmoredPgpPublicKey
	}
	return ""
}

func (m *AttestorPublicKey) GetPkixPublicKey() *PkixPublicKey {
	if x, ok := m.GetPublicKey().(*AttestorPublicKey_PkixPublicKey); ok {
		return x.PkixPublicKey
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*AttestorPublicKey) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*AttestorPublicKey_AsciiArmoredPgpPublicKey)(nil),
		(*AttestorPublicKey_PkixPublicKey)(nil),
	}
}

func init() {
	proto.RegisterEnum("google.cloud.binaryauthorization.v1beta1.Policy_GlobalPolicyEvaluationMode", Policy_GlobalPolicyEvaluationMode_name, Policy_GlobalPolicyEvaluationMode_value)
	proto.RegisterEnum("google.cloud.binaryauthorization.v1beta1.AdmissionRule_EvaluationMode", AdmissionRule_EvaluationMode_name, AdmissionRule_EvaluationMode_value)
	proto.RegisterEnum("google.cloud.binaryauthorization.v1beta1.AdmissionRule_EnforcementMode", AdmissionRule_EnforcementMode_name, AdmissionRule_EnforcementMode_value)
	proto.RegisterEnum("google.cloud.binaryauthorization.v1beta1.PkixPublicKey_SignatureAlgorithm", PkixPublicKey_SignatureAlgorithm_name, PkixPublicKey_SignatureAlgorithm_value)
	proto.RegisterType((*Policy)(nil), "google.cloud.binaryauthorization.v1beta1.Policy")
	proto.RegisterMapType((map[string]*AdmissionRule)(nil), "google.cloud.binaryauthorization.v1beta1.Policy.ClusterAdmissionRulesEntry")
	proto.RegisterType((*AdmissionWhitelistPattern)(nil), "google.cloud.binaryauthorization.v1beta1.AdmissionWhitelistPattern")
	proto.RegisterType((*AdmissionRule)(nil), "google.cloud.binaryauthorization.v1beta1.AdmissionRule")
	proto.RegisterType((*Attestor)(nil), "google.cloud.binaryauthorization.v1beta1.Attestor")
	proto.RegisterType((*UserOwnedDrydockNote)(nil), "google.cloud.binaryauthorization.v1beta1.UserOwnedDrydockNote")
	proto.RegisterType((*PkixPublicKey)(nil), "google.cloud.binaryauthorization.v1beta1.PkixPublicKey")
	proto.RegisterType((*AttestorPublicKey)(nil), "google.cloud.binaryauthorization.v1beta1.AttestorPublicKey")
}

func init() {
	proto.RegisterFile("google/cloud/binaryauthorization/v1beta1/resources.proto", fileDescriptor_1b83e716c45ff98c)
}

var fileDescriptor_1b83e716c45ff98c = []byte{
	// 1324 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xa4, 0x57, 0xcf, 0x53, 0x1b, 0xc7,
	0x12, 0x66, 0x57, 0xfc, 0xb0, 0x5b, 0x20, 0xe4, 0xb1, 0x79, 0x08, 0x3d, 0xfc, 0xcc, 0x53, 0x92,
	0x0a, 0x4e, 0x2a, 0x92, 0x11, 0x60, 0x13, 0xbb, 0xca, 0xe5, 0x95, 0xb4, 0x80, 0x82, 0x90, 0x94,
	0x95, 0x64, 0x17, 0xc9, 0x61, 0x32, 0xda, 0x1d, 0xc4, 0x86, 0xdd, 0x9d, 0xcd, 0xec, 0x2e, 0x58,
	0x71, 0xf9, 0x90, 0x5b, 0x2a, 0xd7, 0x1c, 0x72, 0xc9, 0x1f, 0x97, 0xe4, 0xe8, 0x5b, 0x2a, 0x95,
	0xaa, 0x1c, 0x53, 0xfb, 0x0b, 0x49, 0x20, 0x1c, 0x70, 0x6e, 0x3b, 0xfd, 0x75, 0x7f, 0xfd, 0xcd,
	0x4c, 0x77, 0x8f, 0x04, 0x5b, 0x3d, 0xc6, 0x7a, 0x06, 0x2d, 0xa8, 0x06, 0xf3, 0xb4, 0x42, 0x57,
	0xb7, 0x08, 0xef, 0x13, 0xcf, 0x3d, 0x62, 0x5c, 0xff, 0x96, 0xb8, 0x3a, 0xb3, 0x0a, 0x27, 0x6b,
	0x5d, 0xea, 0x92, 0xb5, 0x02, 0xa7, 0x0e, 0xf3, 0xb8, 0x4a, 0x9d, 0xbc, 0xcd, 0x99, 0xcb, 0xd0,
	0x6a, 0x18, 0x99, 0x0f, 0x22, 0xf3, 0x63, 0x22, 0xf3, 0x51, 0x64, 0xf6, 0x5e, 0x94, 0x83, 0xd8,
	0x7a, 0xe1, 0x50, 0xa7, 0x86, 0x86, 0xbb, 0xf4, 0x88, 0x9c, 0xe8, 0x8c, 0x87, 0x54, 0xd9, 0xa5,
	0x21, 0x87, 0x38, 0x4d, 0x04, 0xc5, 0xb1, 0xc1, 0xaa, 0xeb, 0x1d, 0x16, 0x5c, 0xdd, 0xa4, 0x8e,
	0x4b, 0x4c, 0x3b, 0x72, 0x58, 0x1e, 0x8a, 0x25, 0x96, 0xc5, 0xdc, 0x20, 0x77, 0x24, 0x32, 0xf7,
	0xeb, 0x0c, 0x4c, 0x37, 0x99, 0xa1, 0xab, 0x7d, 0xb4, 0x08, 0x93, 0x16, 0x31, 0x69, 0x46, 0x58,
	0x11, 0x56, 0x6f, 0x96, 0x12, 0xbf, 0x48, 0x09, 0x25, 0x30, 0xa0, 0x0f, 0x20, 0xa9, 0x51, 0x47,
	0xe5, 0xba, 0xed, 0x47, 0x66, 0xa6, 0x63, 0x5c, 0x50, 0x86, 0xed, 0xe8, 0x47, 0x01, 0xee, 0xf6,
	0x0c, 0xd6, 0x25, 0x06, 0xb6, 0x03, 0x46, 0x4c, 0x4f, 0x88, 0xe1, 0x05, 0xe9, 0xb0, 0xc9, 0x34,
	0x9a, 0x99, 0x59, 0x11, 0x56, 0x53, 0xc5, 0xbd, 0xfc, 0x55, 0x0f, 0x26, 0x1f, 0x2a, 0xcb, 0xef,
	0x04, 0xac, 0xe1, 0x42, 0x3e, 0xe3, 0xdc, 0x67, 0x1a, 0x0d, 0x65, 0x64, 0x7b, 0x97, 0x3a, 0xa0,
	0x1f, 0x04, 0x58, 0x26, 0x9a, 0xa9, 0x3b, 0x8e, 0x2f, 0xe3, 0xf4, 0x48, 0x77, 0xa9, 0xa1, 0x3b,
	0x2e, 0xb6, 0x89, 0xeb, 0x52, 0x6e, 0x39, 0x19, 0x71, 0x25, 0xb1, 0x9a, 0x2c, 0x96, 0xaf, 0x2e,
	0x4a, 0x8a, 0xd9, 0x5e, 0xc4, 0x64, 0xcd, 0x90, 0x2b, 0x12, 0x43, 0x2e, 0xc3, 0x1d, 0xf4, 0xbd,
	0x00, 0x8b, 0xaa, 0xe1, 0x39, 0x2e, 0xe5, 0x78, 0x20, 0x8a, 0x7b, 0x06, 0x75, 0x32, 0x89, 0x40,
	0xc7, 0xf5, 0x0f, 0xa7, 0x1c, 0xf2, 0x9d, 0xa9, 0x52, 0x7c, 0x36, 0xd9, 0x72, 0x79, 0x3f, 0xd4,
	0xb3, 0xa0, 0x8e, 0x73, 0x40, 0x1c, 0xfe, 0xa3, 0xd1, 0x43, 0xe2, 0x19, 0xee, 0x39, 0x25, 0x99,
	0xc9, 0x15, 0x61, 0x35, 0x59, 0x7c, 0xf4, 0x0e, 0x07, 0xe2, 0x33, 0xfb, 0x49, 0x45, 0xe5, 0x4e,
	0xc4, 0x3d, 0x02, 0xa1, 0x67, 0x90, 0xf4, 0x6c, 0x8d, 0xb8, 0x14, 0xfb, 0x45, 0x9a, 0x99, 0x0a,
	0x12, 0x65, 0xe3, 0x44, 0x71, 0x05, 0xe7, 0xdb, 0x71, 0x05, 0x87, 0x45, 0x08, 0x61, 0x8c, 0x6f,
	0xcd, 0x7e, 0x27, 0x40, 0xf6, 0xf2, 0x0d, 0xa3, 0x34, 0x24, 0x8e, 0x69, 0x3f, 0xac, 0x60, 0xc5,
	0xff, 0x44, 0xfb, 0x30, 0xe5, 0xd7, 0x03, 0xcd, 0x88, 0xff, 0x6a, 0x57, 0x4a, 0xc8, 0xf2, 0x58,
	0xdc, 0x12, 0x72, 0x1a, 0x64, 0x2f, 0x2f, 0x48, 0xf4, 0x09, 0xdc, 0xdf, 0xa9, 0x35, 0x4a, 0x52,
	0x0d, 0x37, 0x1b, 0xb5, 0x6a, 0xf9, 0x00, 0xcb, 0xcf, 0xa5, 0x5a, 0x47, 0x6a, 0x57, 0x1b, 0x75,
	0xbc, 0xdf, 0xa8, 0xc8, 0xb8, 0x53, 0x6f, 0x35, 0xe5, 0x72, 0x75, 0xbb, 0x2a, 0x57, 0xd2, 0x13,
	0x08, 0x60, 0x5a, 0xae, 0x4b, 0xa5, 0x9a, 0x9c, 0x16, 0x50, 0x12, 0x66, 0x2a, 0xd5, 0x56, 0xb0,
	0x10, 0x1f, 0x57, 0xdf, 0x48, 0xdb, 0x70, 0x7f, 0x9c, 0xc0, 0x70, 0x07, 0xc4, 0xd6, 0x9d, 0xbc,
	0xca, 0xcc, 0x42, 0xd4, 0xbd, 0x4b, 0x36, 0x67, 0x5f, 0x53, 0xd5, 0x75, 0x0a, 0xaf, 0xa2, 0xaf,
	0xd7, 0x85, 0xb0, 0x0d, 0x73, 0x4f, 0x61, 0xe9, 0xd2, 0x9a, 0x45, 0xff, 0x87, 0x59, 0xbf, 0xc9,
	0xe3, 0x7e, 0x88, 0xce, 0x2e, 0xe9, 0xdb, 0x22, 0x97, 0xdc, 0xcf, 0x93, 0x30, 0x37, 0x7a, 0x91,
	0x2e, 0xcc, 0x9f, 0xef, 0x6d, 0x21, 0xe8, 0xed, 0xed, 0x77, 0x3c, 0xdf, 0xfc, 0xc5, 0xb6, 0x16,
	0x95, 0x14, 0x1d, 0x3d, 0xda, 0x27, 0xb0, 0xc8, 0xe9, 0x37, 0x9e, 0xce, 0x29, 0xf6, 0x95, 0x39,
	0xd1, 0x24, 0xc3, 0xdd, 0x7e, 0xd0, 0xc4, 0xd1, 0x4c, 0x5a, 0x88, 0x7c, 0xa4, 0x21, 0x97, 0x52,
	0x1f, 0x9d, 0x42, 0x9a, 0x5a, 0x87, 0x8c, 0xab, 0xd4, 0xa4, 0x96, 0x1b, 0x6a, 0x4e, 0x04, 0x9a,
	0x77, 0xde, 0x59, 0xf3, 0x80, 0x6f, 0x20, 0x7a, 0x9e, 0x8e, 0x5a, 0x73, 0x26, 0xa4, 0xce, 0x95,
	0xc8, 0x3d, 0xf8, 0xef, 0xdb, 0x8b, 0x22, 0x0d, 0xb3, 0x52, 0xed, 0x85, 0x74, 0xd0, 0xc2, 0x52,
	0xad, 0xd6, 0x78, 0x91, 0x16, 0xd0, 0x22, 0xdc, 0x56, 0xe4, 0xcf, 0x3b, 0x55, 0x45, 0xc6, 0x52,
	0xbb, 0x2d, 0xb7, 0xda, 0x41, 0x6c, 0x5a, 0x44, 0xf3, 0x90, 0x8c, 0x5c, 0x2b, 0x72, 0xfd, 0x20,
	0x9d, 0xc8, 0xd9, 0x30, 0x7f, 0x4e, 0x17, 0x5a, 0x81, 0x65, 0xb9, 0xbe, 0xdd, 0x50, 0xca, 0xf2,
	0xbe, 0x5c, 0x6f, 0x8f, 0x4b, 0x38, 0xf0, 0xa8, 0xe0, 0x52, 0xad, 0x51, 0xde, 0xc3, 0x52, 0xbd,
	0x82, 0xa5, 0x4e, 0xa5, 0xda, 0xc6, 0xb5, 0xc6, 0x4e, 0x5a, 0x40, 0x4b, 0xb0, 0x50, 0x51, 0x0e,
	0x94, 0x4e, 0x7d, 0x60, 0xc5, 0x8d, 0x7a, 0xed, 0x20, 0x2d, 0xe6, 0x7e, 0x17, 0xe1, 0x46, 0x78,
	0xd8, 0x8c, 0x5f, 0x7c, 0x44, 0xc4, 0xeb, 0x3d, 0x22, 0xa7, 0xb0, 0xe8, 0x39, 0x94, 0x63, 0x76,
	0x6a, 0x51, 0x0d, 0x6b, 0xbc, 0xaf, 0x31, 0xf5, 0x18, 0x5b, 0xcc, 0x0d, 0x6f, 0x2b, 0x59, 0x7c,
	0x7a, 0xf5, 0xdb, 0xea, 0x38, 0x94, 0x37, 0x7c, 0x9e, 0x4a, 0x48, 0x53, 0x67, 0x2e, 0xdd, 0x9d,
	0x50, 0xee, 0x78, 0x63, 0xec, 0xe7, 0x67, 0xd3, 0xe4, 0xb5, 0x67, 0xd3, 0xe3, 0x83, 0x37, 0xd2,
	0x73, 0xf8, 0xf8, 0x0a, 0x1d, 0x7b, 0x76, 0x58, 0x1f, 0x8e, 0xe9, 0x59, 0x12, 0x81, 0x4e, 0xe1,
	0x55, 0xfc, 0xf9, 0xba, 0x34, 0x0f, 0x73, 0xf1, 0x02, 0xbb, 0x7d, 0x9b, 0xe6, 0xfe, 0x10, 0xe0,
	0xce, 0xb8, 0xed, 0xa1, 0x8f, 0x20, 0xe5, 0x1f, 0x16, 0xe6, 0xf4, 0x90, 0x72, 0x6a, 0xa9, 0x23,
	0x37, 0x31, 0xe7, 0x43, 0x4a, 0x8c, 0x20, 0x02, 0x49, 0xdb, 0xeb, 0x1a, 0xba, 0x8a, 0x8f, 0x69,
	0x3f, 0x7e, 0x08, 0x9f, 0x5c, 0xa3, 0x1b, 0x22, 0x49, 0xcd, 0x80, 0x64, 0x8f, 0x46, 0x0f, 0x0e,
	0xd8, 0xf1, 0xda, 0x41, 0x35, 0x58, 0xd1, 0xa8, 0x41, 0x7b, 0xe1, 0xa0, 0x70, 0x28, 0x3f, 0xd1,
	0x55, 0x8a, 0x89, 0xaa, 0x32, 0xcf, 0x72, 0x31, 0x35, 0x89, 0x6e, 0x04, 0xf7, 0x1a, 0xfd, 0xde,
	0xb8, 0x3b, 0x70, 0x6e, 0x85, 0xbe, 0x52, 0xe8, 0x2a, 0xfb, 0x9e, 0xb9, 0x9f, 0x26, 0x61, 0xae,
	0x79, 0xac, 0xbf, 0x3c, 0x4b, 0x88, 0xde, 0x87, 0xd4, 0x60, 0x0b, 0xd8, 0xa6, 0x66, 0x34, 0xbf,
	0x66, 0xcf, 0x34, 0x34, 0xa9, 0x89, 0x5e, 0xc1, 0x6d, 0x47, 0xef, 0x59, 0xc4, 0xf5, 0xfc, 0xd1,
	0x61, 0xf4, 0x18, 0xd7, 0xdd, 0x23, 0x33, 0x78, 0x12, 0x52, 0xc5, 0xcf, 0xae, 0xf1, 0xe2, 0x0e,
	0xe7, 0xce, 0xb7, 0x62, 0x4a, 0x29, 0x66, 0x54, 0x90, 0x73, 0xc1, 0x96, 0xfb, 0x4d, 0x04, 0x74,
	0xd1, 0x15, 0xbd, 0x07, 0xf7, 0x5a, 0xd5, 0x9d, 0xba, 0xd4, 0xee, 0xf8, 0x3d, 0x5d, 0xdb, 0x69,
	0x28, 0xd5, 0xf6, 0xee, 0xfe, 0xb9, 0xbe, 0xf4, 0xdb, 0xbe, 0x25, 0xe1, 0x66, 0xab, 0x85, 0x8b,
	0x0f, 0x36, 0xb6, 0x70, 0x6b, 0x57, 0x2a, 0x6e, 0x3e, 0x8c, 0xe6, 0x41, 0x04, 0xac, 0x3f, 0x78,
	0x54, 0x8c, 0x01, 0x71, 0x18, 0xd8, 0x78, 0xf0, 0xe9, 0xc3, 0x18, 0x48, 0x8c, 0x03, 0x36, 0xd7,
	0x8a, 0xe9, 0x49, 0xf4, 0x3f, 0xc8, 0xfa, 0x80, 0x2f, 0x06, 0x37, 0xf7, 0xca, 0xad, 0xb5, 0x91,
	0x54, 0x53, 0x63, 0xf0, 0xe1, 0x8c, 0xd3, 0x63, 0xf0, 0xe1, 0xc4, 0x33, 0x6f, 0xc1, 0xfd, 0xfc,
	0x37, 0xd0, 0x02, 0xdc, 0x92, 0xcb, 0x15, 0x5f, 0x5a, 0x71, 0xf3, 0x2c, 0xec, 0xe6, 0x90, 0x79,
	0x7d, 0x6b, 0xc3, 0x37, 0xaf, 0x6f, 0x6d, 0xa4, 0x61, 0xc8, 0xbc, 0x59, 0x5c, 0x8b, 0x49, 0x92,
	0xb9, 0x3f, 0x05, 0xb8, 0x75, 0xa1, 0x1c, 0xd1, 0x5d, 0x98, 0x51, 0x99, 0xe9, 0xcf, 0xc1, 0x41,
	0x17, 0x08, 0x4a, 0x6c, 0x43, 0x29, 0x10, 0x75, 0x2d, 0xa8, 0x82, 0x9b, 0x8a, 0xa8, 0x6b, 0xe8,
	0x19, 0x2c, 0x13, 0x47, 0xd5, 0x75, 0x4c, 0xb8, 0xc9, 0x38, 0xd5, 0xb0, 0xdd, 0xb3, 0xf1, 0xa0,
	0xbc, 0xc2, 0x42, 0xdd, 0x9d, 0x50, 0x32, 0x81, 0x97, 0x14, 0x3a, 0x35, 0x7b, 0xf6, 0x20, 0x21,
	0x81, 0x79, 0xfb, 0x58, 0x7f, 0x39, 0x1c, 0x34, 0x75, 0xdd, 0xdf, 0x1d, 0x23, 0x45, 0xb6, 0x3b,
	0xa1, 0xcc, 0xd9, 0xc3, 0x86, 0xd2, 0x2c, 0xc0, 0x80, 0xbd, 0xf4, 0xd5, 0x17, 0x5f, 0x46, 0xc4,
	0x3d, 0x66, 0x10, 0xab, 0x97, 0x67, 0xbc, 0x57, 0xe8, 0x51, 0x2b, 0x98, 0x57, 0x85, 0xc1, 0xdc,
	0xf9, 0xe7, 0xbf, 0x2f, 0x4f, 0xc6, 0x60, 0x7f, 0x09, 0x42, 0x77, 0x3a, 0xa0, 0x5a, 0xff, 0x3b,
	0x00, 0x00, 0xff, 0xff, 0x61, 0x0c, 0x65, 0x18, 0x08, 0x0d, 0x00, 0x00,
}
