package databox

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/databox/mgmt/2019-09-01/databox"

// AccessProtocol enumerates the values for access protocol.
type AccessProtocol string

const (
	// NFS Network File System protocol(NFS).
	NFS AccessProtocol = "NFS"
	// SMB Server Message Block protocol(SMB).
	SMB AccessProtocol = "SMB"
)

// PossibleAccessProtocolValues returns an array of possible values for the AccessProtocol const type.
func PossibleAccessProtocolValues() []AccessProtocol {
	return []AccessProtocol{NFS, SMB}
}

// AddressType enumerates the values for address type.
type AddressType string

const (
	// Commercial Commercial Address.
	Commercial AddressType = "Commercial"
	// None Address type not known.
	None AddressType = "None"
	// Residential Residential Address.
	Residential AddressType = "Residential"
)

// PossibleAddressTypeValues returns an array of possible values for the AddressType const type.
func PossibleAddressTypeValues() []AddressType {
	return []AddressType{Commercial, None, Residential}
}

// AddressValidationStatus enumerates the values for address validation status.
type AddressValidationStatus string

const (
	// Ambiguous Address provided is ambiguous, please choose one of the alternate addresses returned.
	Ambiguous AddressValidationStatus = "Ambiguous"
	// Invalid Address provided is invalid or not supported.
	Invalid AddressValidationStatus = "Invalid"
	// Valid Address provided is valid.
	Valid AddressValidationStatus = "Valid"
)

// PossibleAddressValidationStatusValues returns an array of possible values for the AddressValidationStatus const type.
func PossibleAddressValidationStatusValues() []AddressValidationStatus {
	return []AddressValidationStatus{Ambiguous, Invalid, Valid}
}

// CopyLogDetailsType enumerates the values for copy log details type.
type CopyLogDetailsType string

const (
	// CopyLogDetailsTypeCopyLogDetails ...
	CopyLogDetailsTypeCopyLogDetails CopyLogDetailsType = "CopyLogDetails"
	// CopyLogDetailsTypeDataBox ...
	CopyLogDetailsTypeDataBox CopyLogDetailsType = "DataBox"
	// CopyLogDetailsTypeDataBoxDisk ...
	CopyLogDetailsTypeDataBoxDisk CopyLogDetailsType = "DataBoxDisk"
	// CopyLogDetailsTypeDataBoxHeavy ...
	CopyLogDetailsTypeDataBoxHeavy CopyLogDetailsType = "DataBoxHeavy"
)

// PossibleCopyLogDetailsTypeValues returns an array of possible values for the CopyLogDetailsType const type.
func PossibleCopyLogDetailsTypeValues() []CopyLogDetailsType {
	return []CopyLogDetailsType{CopyLogDetailsTypeCopyLogDetails, CopyLogDetailsTypeDataBox, CopyLogDetailsTypeDataBoxDisk, CopyLogDetailsTypeDataBoxHeavy}
}

// CopyStatus enumerates the values for copy status.
type CopyStatus string

const (
	// Completed Data copy completed.
	Completed CopyStatus = "Completed"
	// CompletedWithErrors Data copy completed with errors.
	CompletedWithErrors CopyStatus = "CompletedWithErrors"
	// DeviceFormatted Data copy failed. The Device was formatted by user.
	DeviceFormatted CopyStatus = "DeviceFormatted"
	// DeviceMetadataModified Data copy failed. Device metadata was modified by user.
	DeviceMetadataModified CopyStatus = "DeviceMetadataModified"
	// Failed Data copy failed. No data was copied.
	Failed CopyStatus = "Failed"
	// HardwareError The Device has hit hardware issues.
	HardwareError CopyStatus = "HardwareError"
	// InProgress Data copy is in progress.
	InProgress CopyStatus = "InProgress"
	// NotReturned No copy triggered as device was not returned.
	NotReturned CopyStatus = "NotReturned"
	// NotStarted Data copy hasn't started yet.
	NotStarted CopyStatus = "NotStarted"
	// StorageAccountNotAccessible Data copy failed. Storage Account was not accessible during copy.
	StorageAccountNotAccessible CopyStatus = "StorageAccountNotAccessible"
	// UnsupportedData Data copy failed. The Device data content is not supported.
	UnsupportedData CopyStatus = "UnsupportedData"
)

// PossibleCopyStatusValues returns an array of possible values for the CopyStatus const type.
func PossibleCopyStatusValues() []CopyStatus {
	return []CopyStatus{Completed, CompletedWithErrors, DeviceFormatted, DeviceMetadataModified, Failed, HardwareError, InProgress, NotReturned, NotStarted, StorageAccountNotAccessible, UnsupportedData}
}

// DataDestinationType enumerates the values for data destination type.
type DataDestinationType string

const (
	// ManagedDisk Azure Managed disk storage.
	ManagedDisk DataDestinationType = "ManagedDisk"
	// StorageAccount Storage Accounts .
	StorageAccount DataDestinationType = "StorageAccount"
)

// PossibleDataDestinationTypeValues returns an array of possible values for the DataDestinationType const type.
func PossibleDataDestinationTypeValues() []DataDestinationType {
	return []DataDestinationType{ManagedDisk, StorageAccount}
}

// DataDestinationTypeBasicDestinationAccountDetails enumerates the values for data destination type basic
// destination account details.
type DataDestinationTypeBasicDestinationAccountDetails string

const (
	// DataDestinationTypeDestinationAccountDetails ...
	DataDestinationTypeDestinationAccountDetails DataDestinationTypeBasicDestinationAccountDetails = "DestinationAccountDetails"
	// DataDestinationTypeManagedDisk ...
	DataDestinationTypeManagedDisk DataDestinationTypeBasicDestinationAccountDetails = "ManagedDisk"
	// DataDestinationTypeStorageAccount ...
	DataDestinationTypeStorageAccount DataDestinationTypeBasicDestinationAccountDetails = "StorageAccount"
)

// PossibleDataDestinationTypeBasicDestinationAccountDetailsValues returns an array of possible values for the DataDestinationTypeBasicDestinationAccountDetails const type.
func PossibleDataDestinationTypeBasicDestinationAccountDetailsValues() []DataDestinationTypeBasicDestinationAccountDetails {
	return []DataDestinationTypeBasicDestinationAccountDetails{DataDestinationTypeDestinationAccountDetails, DataDestinationTypeManagedDisk, DataDestinationTypeStorageAccount}
}

// JobDeliveryType enumerates the values for job delivery type.
type JobDeliveryType string

const (
	// NonScheduled Non Scheduled job.
	NonScheduled JobDeliveryType = "NonScheduled"
	// Scheduled Scheduled job.
	Scheduled JobDeliveryType = "Scheduled"
)

// PossibleJobDeliveryTypeValues returns an array of possible values for the JobDeliveryType const type.
func PossibleJobDeliveryTypeValues() []JobDeliveryType {
	return []JobDeliveryType{NonScheduled, Scheduled}
}

// JobDetailsTypeEnum enumerates the values for job details type enum.
type JobDetailsTypeEnum string

const (
	// JobDetailsTypeDataBox ...
	JobDetailsTypeDataBox JobDetailsTypeEnum = "DataBox"
	// JobDetailsTypeDataBoxDisk ...
	JobDetailsTypeDataBoxDisk JobDetailsTypeEnum = "DataBoxDisk"
	// JobDetailsTypeDataBoxHeavy ...
	JobDetailsTypeDataBoxHeavy JobDetailsTypeEnum = "DataBoxHeavy"
	// JobDetailsTypeJobDetails ...
	JobDetailsTypeJobDetails JobDetailsTypeEnum = "JobDetails"
)

// PossibleJobDetailsTypeEnumValues returns an array of possible values for the JobDetailsTypeEnum const type.
func PossibleJobDetailsTypeEnumValues() []JobDetailsTypeEnum {
	return []JobDetailsTypeEnum{JobDetailsTypeDataBox, JobDetailsTypeDataBoxDisk, JobDetailsTypeDataBoxHeavy, JobDetailsTypeJobDetails}
}

// JobSecretsTypeEnum enumerates the values for job secrets type enum.
type JobSecretsTypeEnum string

const (
	// JobSecretsTypeDataBox ...
	JobSecretsTypeDataBox JobSecretsTypeEnum = "DataBox"
	// JobSecretsTypeDataBoxDisk ...
	JobSecretsTypeDataBoxDisk JobSecretsTypeEnum = "DataBoxDisk"
	// JobSecretsTypeDataBoxHeavy ...
	JobSecretsTypeDataBoxHeavy JobSecretsTypeEnum = "DataBoxHeavy"
	// JobSecretsTypeJobSecrets ...
	JobSecretsTypeJobSecrets JobSecretsTypeEnum = "JobSecrets"
)

// PossibleJobSecretsTypeEnumValues returns an array of possible values for the JobSecretsTypeEnum const type.
func PossibleJobSecretsTypeEnumValues() []JobSecretsTypeEnum {
	return []JobSecretsTypeEnum{JobSecretsTypeDataBox, JobSecretsTypeDataBoxDisk, JobSecretsTypeDataBoxHeavy, JobSecretsTypeJobSecrets}
}

// NotificationStageName enumerates the values for notification stage name.
type NotificationStageName string

const (
	// AtAzureDC Notification at device received at azure datacenter stage.
	AtAzureDC NotificationStageName = "AtAzureDC"
	// DataCopy Notification at data copy started stage.
	DataCopy NotificationStageName = "DataCopy"
	// Delivered Notification at device delivered stage.
	Delivered NotificationStageName = "Delivered"
	// DevicePrepared Notification at device prepared stage.
	DevicePrepared NotificationStageName = "DevicePrepared"
	// Dispatched Notification at device dispatched stage.
	Dispatched NotificationStageName = "Dispatched"
	// PickedUp Notification at device picked up from user stage.
	PickedUp NotificationStageName = "PickedUp"
)

// PossibleNotificationStageNameValues returns an array of possible values for the NotificationStageName const type.
func PossibleNotificationStageNameValues() []NotificationStageName {
	return []NotificationStageName{AtAzureDC, DataCopy, Delivered, DevicePrepared, Dispatched, PickedUp}
}

// OverallValidationStatus enumerates the values for overall validation status.
type OverallValidationStatus string

const (
	// AllValidToProceed Every input request is valid.
	AllValidToProceed OverallValidationStatus = "AllValidToProceed"
	// CertainInputValidationsSkipped Certain input validations skipped.
	CertainInputValidationsSkipped OverallValidationStatus = "CertainInputValidationsSkipped"
	// InputsRevisitRequired Some input requests are not valid.
	InputsRevisitRequired OverallValidationStatus = "InputsRevisitRequired"
)

// PossibleOverallValidationStatusValues returns an array of possible values for the OverallValidationStatus const type.
func PossibleOverallValidationStatusValues() []OverallValidationStatus {
	return []OverallValidationStatus{AllValidToProceed, CertainInputValidationsSkipped, InputsRevisitRequired}
}

// ShareDestinationFormatType enumerates the values for share destination format type.
type ShareDestinationFormatType string

const (
	// ShareDestinationFormatTypeAzureFile Azure storage file format.
	ShareDestinationFormatTypeAzureFile ShareDestinationFormatType = "AzureFile"
	// ShareDestinationFormatTypeBlockBlob Azure storage block blob format.
	ShareDestinationFormatTypeBlockBlob ShareDestinationFormatType = "BlockBlob"
	// ShareDestinationFormatTypeHCS Storsimple data format.
	ShareDestinationFormatTypeHCS ShareDestinationFormatType = "HCS"
	// ShareDestinationFormatTypeManagedDisk Azure Compute Disk.
	ShareDestinationFormatTypeManagedDisk ShareDestinationFormatType = "ManagedDisk"
	// ShareDestinationFormatTypePageBlob Azure storage page blob format.
	ShareDestinationFormatTypePageBlob ShareDestinationFormatType = "PageBlob"
	// ShareDestinationFormatTypeUnknownType Unknown format.
	ShareDestinationFormatTypeUnknownType ShareDestinationFormatType = "UnknownType"
)

// PossibleShareDestinationFormatTypeValues returns an array of possible values for the ShareDestinationFormatType const type.
func PossibleShareDestinationFormatTypeValues() []ShareDestinationFormatType {
	return []ShareDestinationFormatType{ShareDestinationFormatTypeAzureFile, ShareDestinationFormatTypeBlockBlob, ShareDestinationFormatTypeHCS, ShareDestinationFormatTypeManagedDisk, ShareDestinationFormatTypePageBlob, ShareDestinationFormatTypeUnknownType}
}

// SkuDisabledReason enumerates the values for sku disabled reason.
type SkuDisabledReason string

const (
	// SkuDisabledReasonCountry SKU is not available in the requested country.
	SkuDisabledReasonCountry SkuDisabledReason = "Country"
	// SkuDisabledReasonFeature Required features are not enabled for the SKU.
	SkuDisabledReasonFeature SkuDisabledReason = "Feature"
	// SkuDisabledReasonNone SKU is not disabled.
	SkuDisabledReasonNone SkuDisabledReason = "None"
	// SkuDisabledReasonNoSubscriptionInfo Subscription has not registered to Microsoft.DataBox and Service
	// does not have the subscription notification.
	SkuDisabledReasonNoSubscriptionInfo SkuDisabledReason = "NoSubscriptionInfo"
	// SkuDisabledReasonOfferType Subscription does not have required offer types for the SKU.
	SkuDisabledReasonOfferType SkuDisabledReason = "OfferType"
	// SkuDisabledReasonRegion SKU is not available to push data to the requested Azure region.
	SkuDisabledReasonRegion SkuDisabledReason = "Region"
)

// PossibleSkuDisabledReasonValues returns an array of possible values for the SkuDisabledReason const type.
func PossibleSkuDisabledReasonValues() []SkuDisabledReason {
	return []SkuDisabledReason{SkuDisabledReasonCountry, SkuDisabledReasonFeature, SkuDisabledReasonNone, SkuDisabledReasonNoSubscriptionInfo, SkuDisabledReasonOfferType, SkuDisabledReasonRegion}
}

// SkuName enumerates the values for sku name.
type SkuName string

const (
	// DataBox Databox.
	DataBox SkuName = "DataBox"
	// DataBoxDisk DataboxDisk.
	DataBoxDisk SkuName = "DataBoxDisk"
	// DataBoxHeavy DataboxHeavy.
	DataBoxHeavy SkuName = "DataBoxHeavy"
)

// PossibleSkuNameValues returns an array of possible values for the SkuName const type.
func PossibleSkuNameValues() []SkuName {
	return []SkuName{DataBox, DataBoxDisk, DataBoxHeavy}
}

// SkuNameBasicScheduleAvailabilityRequest enumerates the values for sku name basic schedule availability
// request.
type SkuNameBasicScheduleAvailabilityRequest string

const (
	// SkuNameDataBox ...
	SkuNameDataBox SkuNameBasicScheduleAvailabilityRequest = "DataBox"
	// SkuNameDataBoxDisk ...
	SkuNameDataBoxDisk SkuNameBasicScheduleAvailabilityRequest = "DataBoxDisk"
	// SkuNameDataBoxHeavy ...
	SkuNameDataBoxHeavy SkuNameBasicScheduleAvailabilityRequest = "DataBoxHeavy"
	// SkuNameScheduleAvailabilityRequest ...
	SkuNameScheduleAvailabilityRequest SkuNameBasicScheduleAvailabilityRequest = "ScheduleAvailabilityRequest"
)

// PossibleSkuNameBasicScheduleAvailabilityRequestValues returns an array of possible values for the SkuNameBasicScheduleAvailabilityRequest const type.
func PossibleSkuNameBasicScheduleAvailabilityRequestValues() []SkuNameBasicScheduleAvailabilityRequest {
	return []SkuNameBasicScheduleAvailabilityRequest{SkuNameDataBox, SkuNameDataBoxDisk, SkuNameDataBoxHeavy, SkuNameScheduleAvailabilityRequest}
}

// StageName enumerates the values for stage name.
type StageName string

const (
	// StageNameAborted Order has been aborted.
	StageNameAborted StageName = "Aborted"
	// StageNameAtAzureDC Device has been received at azure datacenter from the user.
	StageNameAtAzureDC StageName = "AtAzureDC"
	// StageNameCancelled Order has been cancelled.
	StageNameCancelled StageName = "Cancelled"
	// StageNameCompleted Order has completed.
	StageNameCompleted StageName = "Completed"
	// StageNameCompletedWithErrors Order has completed with errors.
	StageNameCompletedWithErrors StageName = "CompletedWithErrors"
	// StageNameCompletedWithWarnings Order has completed with warnings.
	StageNameCompletedWithWarnings StageName = "CompletedWithWarnings"
	// StageNameDataCopy Data copy from the device at azure datacenter.
	StageNameDataCopy StageName = "DataCopy"
	// StageNameDelivered Device has been delivered to the user of the order.
	StageNameDelivered StageName = "Delivered"
	// StageNameDeviceOrdered An order has been created.
	StageNameDeviceOrdered StageName = "DeviceOrdered"
	// StageNameDevicePrepared A device has been prepared for the order.
	StageNameDevicePrepared StageName = "DevicePrepared"
	// StageNameDispatched Device has been dispatched to the user of the order.
	StageNameDispatched StageName = "Dispatched"
	// StageNameFailedIssueDetectedAtAzureDC Order has failed due to issue detected at azure datacenter.
	StageNameFailedIssueDetectedAtAzureDC StageName = "Failed_IssueDetectedAtAzureDC"
	// StageNameFailedIssueReportedAtCustomer Order has failed due to issue reported by user.
	StageNameFailedIssueReportedAtCustomer StageName = "Failed_IssueReportedAtCustomer"
	// StageNamePickedUp Device has been picked up from user and in transit to azure datacenter.
	StageNamePickedUp StageName = "PickedUp"
	// StageNameReadyToDispatchFromAzureDC Device is ready to be handed to customer from Azure DC.
	StageNameReadyToDispatchFromAzureDC StageName = "ReadyToDispatchFromAzureDC"
	// StageNameReadyToReceiveAtAzureDC Device can be dropped off at Azure DC.
	StageNameReadyToReceiveAtAzureDC StageName = "ReadyToReceiveAtAzureDC"
)

// PossibleStageNameValues returns an array of possible values for the StageName const type.
func PossibleStageNameValues() []StageName {
	return []StageName{StageNameAborted, StageNameAtAzureDC, StageNameCancelled, StageNameCompleted, StageNameCompletedWithErrors, StageNameCompletedWithWarnings, StageNameDataCopy, StageNameDelivered, StageNameDeviceOrdered, StageNameDevicePrepared, StageNameDispatched, StageNameFailedIssueDetectedAtAzureDC, StageNameFailedIssueReportedAtCustomer, StageNamePickedUp, StageNameReadyToDispatchFromAzureDC, StageNameReadyToReceiveAtAzureDC}
}

// StageStatus enumerates the values for stage status.
type StageStatus string

const (
	// StageStatusCancelled Stage has been cancelled.
	StageStatusCancelled StageStatus = "Cancelled"
	// StageStatusCancelling Stage is cancelling.
	StageStatusCancelling StageStatus = "Cancelling"
	// StageStatusFailed Stage has failed.
	StageStatusFailed StageStatus = "Failed"
	// StageStatusInProgress Stage is in progress.
	StageStatusInProgress StageStatus = "InProgress"
	// StageStatusNone No status available yet.
	StageStatusNone StageStatus = "None"
	// StageStatusSucceeded Stage has succeeded.
	StageStatusSucceeded StageStatus = "Succeeded"
	// StageStatusSucceededWithErrors Stage has succeeded with errors.
	StageStatusSucceededWithErrors StageStatus = "SucceededWithErrors"
)

// PossibleStageStatusValues returns an array of possible values for the StageStatus const type.
func PossibleStageStatusValues() []StageStatus {
	return []StageStatus{StageStatusCancelled, StageStatusCancelling, StageStatusFailed, StageStatusInProgress, StageStatusNone, StageStatusSucceeded, StageStatusSucceededWithErrors}
}

// TransportShipmentTypes enumerates the values for transport shipment types.
type TransportShipmentTypes string

const (
	// CustomerManaged Shipment Logistics is handled by the customer.
	CustomerManaged TransportShipmentTypes = "CustomerManaged"
	// MicrosoftManaged Shipment Logistics is handled by Microsoft.
	MicrosoftManaged TransportShipmentTypes = "MicrosoftManaged"
)

// PossibleTransportShipmentTypesValues returns an array of possible values for the TransportShipmentTypes const type.
func PossibleTransportShipmentTypesValues() []TransportShipmentTypes {
	return []TransportShipmentTypes{CustomerManaged, MicrosoftManaged}
}

// ValidationCategory enumerates the values for validation category.
type ValidationCategory string

const (
	// ValidationCategoryJobCreationValidation ...
	ValidationCategoryJobCreationValidation ValidationCategory = "JobCreationValidation"
	// ValidationCategoryValidationRequest ...
	ValidationCategoryValidationRequest ValidationCategory = "ValidationRequest"
)

// PossibleValidationCategoryValues returns an array of possible values for the ValidationCategory const type.
func PossibleValidationCategoryValues() []ValidationCategory {
	return []ValidationCategory{ValidationCategoryJobCreationValidation, ValidationCategoryValidationRequest}
}

// ValidationStatus enumerates the values for validation status.
type ValidationStatus string

const (
	// ValidationStatusInvalid Validation is not successful
	ValidationStatusInvalid ValidationStatus = "Invalid"
	// ValidationStatusSkipped Validation is skipped
	ValidationStatusSkipped ValidationStatus = "Skipped"
	// ValidationStatusValid Validation is successful
	ValidationStatusValid ValidationStatus = "Valid"
)

// PossibleValidationStatusValues returns an array of possible values for the ValidationStatus const type.
func PossibleValidationStatusValues() []ValidationStatus {
	return []ValidationStatus{ValidationStatusInvalid, ValidationStatusSkipped, ValidationStatusValid}
}

// ValidationType enumerates the values for validation type.
type ValidationType string

const (
	// ValidationTypeValidateAddress ...
	ValidationTypeValidateAddress ValidationType = "ValidateAddress"
	// ValidationTypeValidateCreateOrderLimit ...
	ValidationTypeValidateCreateOrderLimit ValidationType = "ValidateCreateOrderLimit"
	// ValidationTypeValidateDataDestinationDetails ...
	ValidationTypeValidateDataDestinationDetails ValidationType = "ValidateDataDestinationDetails"
	// ValidationTypeValidatePreferences ...
	ValidationTypeValidatePreferences ValidationType = "ValidatePreferences"
	// ValidationTypeValidateSkuAvailability ...
	ValidationTypeValidateSkuAvailability ValidationType = "ValidateSkuAvailability"
	// ValidationTypeValidateSubscriptionIsAllowedToCreateJob ...
	ValidationTypeValidateSubscriptionIsAllowedToCreateJob ValidationType = "ValidateSubscriptionIsAllowedToCreateJob"
	// ValidationTypeValidationInputRequest ...
	ValidationTypeValidationInputRequest ValidationType = "ValidationInputRequest"
)

// PossibleValidationTypeValues returns an array of possible values for the ValidationType const type.
func PossibleValidationTypeValues() []ValidationType {
	return []ValidationType{ValidationTypeValidateAddress, ValidationTypeValidateCreateOrderLimit, ValidationTypeValidateDataDestinationDetails, ValidationTypeValidatePreferences, ValidationTypeValidateSkuAvailability, ValidationTypeValidateSubscriptionIsAllowedToCreateJob, ValidationTypeValidationInputRequest}
}

// ValidationTypeBasicValidationInputResponse enumerates the values for validation type basic validation input
// response.
type ValidationTypeBasicValidationInputResponse string

const (
	// ValidationTypeBasicValidationInputResponseValidationTypeValidateAddress ...
	ValidationTypeBasicValidationInputResponseValidationTypeValidateAddress ValidationTypeBasicValidationInputResponse = "ValidateAddress"
	// ValidationTypeBasicValidationInputResponseValidationTypeValidateCreateOrderLimit ...
	ValidationTypeBasicValidationInputResponseValidationTypeValidateCreateOrderLimit ValidationTypeBasicValidationInputResponse = "ValidateCreateOrderLimit"
	// ValidationTypeBasicValidationInputResponseValidationTypeValidateDataDestinationDetails ...
	ValidationTypeBasicValidationInputResponseValidationTypeValidateDataDestinationDetails ValidationTypeBasicValidationInputResponse = "ValidateDataDestinationDetails"
	// ValidationTypeBasicValidationInputResponseValidationTypeValidatePreferences ...
	ValidationTypeBasicValidationInputResponseValidationTypeValidatePreferences ValidationTypeBasicValidationInputResponse = "ValidatePreferences"
	// ValidationTypeBasicValidationInputResponseValidationTypeValidateSkuAvailability ...
	ValidationTypeBasicValidationInputResponseValidationTypeValidateSkuAvailability ValidationTypeBasicValidationInputResponse = "ValidateSkuAvailability"
	// ValidationTypeBasicValidationInputResponseValidationTypeValidateSubscriptionIsAllowedToCreateJob ...
	ValidationTypeBasicValidationInputResponseValidationTypeValidateSubscriptionIsAllowedToCreateJob ValidationTypeBasicValidationInputResponse = "ValidateSubscriptionIsAllowedToCreateJob"
	// ValidationTypeBasicValidationInputResponseValidationTypeValidationInputResponse ...
	ValidationTypeBasicValidationInputResponseValidationTypeValidationInputResponse ValidationTypeBasicValidationInputResponse = "ValidationInputResponse"
)

// PossibleValidationTypeBasicValidationInputResponseValues returns an array of possible values for the ValidationTypeBasicValidationInputResponse const type.
func PossibleValidationTypeBasicValidationInputResponseValues() []ValidationTypeBasicValidationInputResponse {
	return []ValidationTypeBasicValidationInputResponse{ValidationTypeBasicValidationInputResponseValidationTypeValidateAddress, ValidationTypeBasicValidationInputResponseValidationTypeValidateCreateOrderLimit, ValidationTypeBasicValidationInputResponseValidationTypeValidateDataDestinationDetails, ValidationTypeBasicValidationInputResponseValidationTypeValidatePreferences, ValidationTypeBasicValidationInputResponseValidationTypeValidateSkuAvailability, ValidationTypeBasicValidationInputResponseValidationTypeValidateSubscriptionIsAllowedToCreateJob, ValidationTypeBasicValidationInputResponseValidationTypeValidationInputResponse}
}

// AccountCopyLogDetails copy log details for a storage account of a DataBox job
type AccountCopyLogDetails struct {
	// AccountName - READ-ONLY; Destination account name.
	AccountName *string `json:"accountName,omitempty"`
	// CopyLogLink - READ-ONLY; Link for copy logs.
	CopyLogLink *string `json:"copyLogLink,omitempty"`
	// CopyLogDetailsType - Possible values include: 'CopyLogDetailsTypeCopyLogDetails', 'CopyLogDetailsTypeDataBox', 'CopyLogDetailsTypeDataBoxDisk', 'CopyLogDetailsTypeDataBoxHeavy'
	CopyLogDetailsType CopyLogDetailsType `json:"copyLogDetailsType,omitempty"`
}

// MarshalJSON is the custom marshaler for AccountCopyLogDetails.
func (acld AccountCopyLogDetails) MarshalJSON() ([]byte, error) {
	acld.CopyLogDetailsType = CopyLogDetailsTypeDataBox
	objectMap := make(map[string]interface{})
	if acld.CopyLogDetailsType != "" {
		objectMap["copyLogDetailsType"] = acld.CopyLogDetailsType
	}
	return json.Marshal(objectMap)
}

// AsAccountCopyLogDetails is the BasicCopyLogDetails implementation for AccountCopyLogDetails.
func (acld AccountCopyLogDetails) AsAccountCopyLogDetails() (*AccountCopyLogDetails, bool) {
	return &acld, true
}

// AsDiskCopyLogDetails is the BasicCopyLogDetails implementation for AccountCopyLogDetails.
func (acld AccountCopyLogDetails) AsDiskCopyLogDetails() (*DiskCopyLogDetails, bool) {
	return nil, false
}

// AsHeavyAccountCopyLogDetails is the BasicCopyLogDetails implementation for AccountCopyLogDetails.
func (acld AccountCopyLogDetails) AsHeavyAccountCopyLogDetails() (*HeavyAccountCopyLogDetails, bool) {
	return nil, false
}

// AsCopyLogDetails is the BasicCopyLogDetails implementation for AccountCopyLogDetails.
func (acld AccountCopyLogDetails) AsCopyLogDetails() (*CopyLogDetails, bool) {
	return nil, false
}

// AsBasicCopyLogDetails is the BasicCopyLogDetails implementation for AccountCopyLogDetails.
func (acld AccountCopyLogDetails) AsBasicCopyLogDetails() (BasicCopyLogDetails, bool) {
	return &acld, true
}

// AccountCredentialDetails credential details of the account.
type AccountCredentialDetails struct {
	// AccountName - READ-ONLY; Name of the account.
	AccountName *string `json:"accountName,omitempty"`
	// DataDestinationType - READ-ONLY; Data Destination Type. Possible values include: 'StorageAccount', 'ManagedDisk'
	DataDestinationType DataDestinationType `json:"dataDestinationType,omitempty"`
	// AccountConnectionString - READ-ONLY; Connection string of the account endpoint to use the account as a storage endpoint on the device.
	AccountConnectionString *string `json:"accountConnectionString,omitempty"`
	// ShareCredentialDetails - READ-ONLY; Per share level unencrypted access credentials.
	ShareCredentialDetails *[]ShareCredentialDetails `json:"shareCredentialDetails,omitempty"`
}

// AddressValidationOutput output of the address validation api.
type AddressValidationOutput struct {
	autorest.Response `json:"-"`
	// AddressValidationProperties - READ-ONLY; The address validation properties.
	*AddressValidationProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for AddressValidationOutput.
func (avo AddressValidationOutput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AddressValidationOutput struct.
func (avo *AddressValidationOutput) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var addressValidationProperties AddressValidationProperties
				err = json.Unmarshal(*v, &addressValidationProperties)
				if err != nil {
					return err
				}
				avo.AddressValidationProperties = &addressValidationProperties
			}
		}
	}

	return nil
}

// AddressValidationProperties the address validation output.
type AddressValidationProperties struct {
	// ValidationStatus - READ-ONLY; The address validation status. Possible values include: 'Valid', 'Invalid', 'Ambiguous'
	ValidationStatus AddressValidationStatus `json:"validationStatus,omitempty"`
	// AlternateAddresses - READ-ONLY; List of alternate addresses.
	AlternateAddresses *[]ShippingAddress `json:"alternateAddresses,omitempty"`
	// Error - READ-ONLY; Error code and message of validation response.
	Error *Error `json:"error,omitempty"`
	// ValidationType - Possible values include: 'ValidationTypeBasicValidationInputResponseValidationTypeValidationInputResponse', 'ValidationTypeBasicValidationInputResponseValidationTypeValidateAddress', 'ValidationTypeBasicValidationInputResponseValidationTypeValidateCreateOrderLimit', 'ValidationTypeBasicValidationInputResponseValidationTypeValidateDataDestinationDetails', 'ValidationTypeBasicValidationInputResponseValidationTypeValidatePreferences', 'ValidationTypeBasicValidationInputResponseValidationTypeValidateSkuAvailability', 'ValidationTypeBasicValidationInputResponseValidationTypeValidateSubscriptionIsAllowedToCreateJob'
	ValidationType ValidationTypeBasicValidationInputResponse `json:"validationType,omitempty"`
}

// MarshalJSON is the custom marshaler for AddressValidationProperties.
func (avp AddressValidationProperties) MarshalJSON() ([]byte, error) {
	avp.ValidationType = ValidationTypeBasicValidationInputResponseValidationTypeValidateAddress
	objectMap := make(map[string]interface{})
	if avp.ValidationType != "" {
		objectMap["validationType"] = avp.ValidationType
	}
	return json.Marshal(objectMap)
}

// AsAddressValidationProperties is the BasicValidationInputResponse implementation for AddressValidationProperties.
func (avp AddressValidationProperties) AsAddressValidationProperties() (*AddressValidationProperties, bool) {
	return &avp, true
}

// AsCreateOrderLimitForSubscriptionValidationResponseProperties is the BasicValidationInputResponse implementation for AddressValidationProperties.
func (avp AddressValidationProperties) AsCreateOrderLimitForSubscriptionValidationResponseProperties() (*CreateOrderLimitForSubscriptionValidationResponseProperties, bool) {
	return nil, false
}

// AsDataDestinationDetailsValidationResponseProperties is the BasicValidationInputResponse implementation for AddressValidationProperties.
func (avp AddressValidationProperties) AsDataDestinationDetailsValidationResponseProperties() (*DataDestinationDetailsValidationResponseProperties, bool) {
	return nil, false
}

// AsPreferencesValidationResponseProperties is the BasicValidationInputResponse implementation for AddressValidationProperties.
func (avp AddressValidationProperties) AsPreferencesValidationResponseProperties() (*PreferencesValidationResponseProperties, bool) {
	return nil, false
}

// AsSkuAvailabilityValidationResponseProperties is the BasicValidationInputResponse implementation for AddressValidationProperties.
func (avp AddressValidationProperties) AsSkuAvailabilityValidationResponseProperties() (*SkuAvailabilityValidationResponseProperties, bool) {
	return nil, false
}

// AsSubscriptionIsAllowedToCreateJobValidationResponseProperties is the BasicValidationInputResponse implementation for AddressValidationProperties.
func (avp AddressValidationProperties) AsSubscriptionIsAllowedToCreateJobValidationResponseProperties() (*SubscriptionIsAllowedToCreateJobValidationResponseProperties, bool) {
	return nil, false
}

// AsValidationInputResponse is the BasicValidationInputResponse implementation for AddressValidationProperties.
func (avp AddressValidationProperties) AsValidationInputResponse() (*ValidationInputResponse, bool) {
	return nil, false
}

// AsBasicValidationInputResponse is the BasicValidationInputResponse implementation for AddressValidationProperties.
func (avp AddressValidationProperties) AsBasicValidationInputResponse() (BasicValidationInputResponse, bool) {
	return &avp, true
}

// ApplianceNetworkConfiguration the Network Adapter configuration of a DataBox.
type ApplianceNetworkConfiguration struct {
	// Name - READ-ONLY; Name of the network.
	Name *string `json:"name,omitempty"`
	// MacAddress - READ-ONLY; Mac Address.
	MacAddress *string `json:"macAddress,omitempty"`
}

// ArmBaseObject base class for all objects under resource.
type ArmBaseObject struct {
	// Name - READ-ONLY; Name of the object.
	Name *string `json:"name,omitempty"`
	// ID - READ-ONLY; Id of the object.
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; Type of the object.
	Type *string `json:"type,omitempty"`
}

// AvailableSkuRequest the filters for showing the available skus.
type AvailableSkuRequest struct {
	// TransferType - Type of the transfer.
	TransferType *string `json:"transferType,omitempty"`
	// Country - ISO country code. Country for hardware shipment. For codes check: https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2#Officially_assigned_code_elements
	Country *string `json:"country,omitempty"`
	// Location - Location for data transfer. For locations check: https://management.azure.com/subscriptions/SUBSCRIPTIONID/locations?api-version=2018-01-01
	Location *string `json:"location,omitempty"`
	// SkuNames - Sku Names to filter for available skus
	SkuNames *[]SkuName `json:"skuNames,omitempty"`
}

// AvailableSkusResult the available skus operation response.
type AvailableSkusResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of available skus.
	Value *[]SkuInformation `json:"value,omitempty"`
	// NextLink - Link for the next set of skus.
	NextLink *string `json:"nextLink,omitempty"`
}

// AvailableSkusResultIterator provides access to a complete listing of SkuInformation values.
type AvailableSkusResultIterator struct {
	i    int
	page AvailableSkusResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AvailableSkusResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AvailableSkusResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AvailableSkusResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AvailableSkusResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AvailableSkusResultIterator) Response() AvailableSkusResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AvailableSkusResultIterator) Value() SkuInformation {
	if !iter.page.NotDone() {
		return SkuInformation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AvailableSkusResultIterator type.
func NewAvailableSkusResultIterator(page AvailableSkusResultPage) AvailableSkusResultIterator {
	return AvailableSkusResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (asr AvailableSkusResult) IsEmpty() bool {
	return asr.Value == nil || len(*asr.Value) == 0
}

// availableSkusResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (asr AvailableSkusResult) availableSkusResultPreparer(ctx context.Context) (*http.Request, error) {
	if asr.NextLink == nil || len(to.String(asr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(asr.NextLink)))
}

// AvailableSkusResultPage contains a page of SkuInformation values.
type AvailableSkusResultPage struct {
	fn  func(context.Context, AvailableSkusResult) (AvailableSkusResult, error)
	asr AvailableSkusResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AvailableSkusResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AvailableSkusResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.asr)
	if err != nil {
		return err
	}
	page.asr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AvailableSkusResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AvailableSkusResultPage) NotDone() bool {
	return !page.asr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AvailableSkusResultPage) Response() AvailableSkusResult {
	return page.asr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AvailableSkusResultPage) Values() []SkuInformation {
	if page.asr.IsEmpty() {
		return nil
	}
	return *page.asr.Value
}

// Creates a new instance of the AvailableSkusResultPage type.
func NewAvailableSkusResultPage(getNextPage func(context.Context, AvailableSkusResult) (AvailableSkusResult, error)) AvailableSkusResultPage {
	return AvailableSkusResultPage{fn: getNextPage}
}

// CancellationReason reason for cancellation.
type CancellationReason struct {
	// Reason - Reason for cancellation.
	Reason *string `json:"reason,omitempty"`
}

// CloudError the error information object.
type CloudError struct {
	// Code - READ-ONLY; Error code string.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; Descriptive error information.
	Message *string `json:"message,omitempty"`
	// Target - Error target
	Target *string `json:"target,omitempty"`
	// Details - More detailed error information.
	Details *[]CloudError `json:"details,omitempty"`
}

// ContactDetails contact Details.
type ContactDetails struct {
	// ContactName - Contact name of the person.
	ContactName *string `json:"contactName,omitempty"`
	// Phone - Phone number of the contact person.
	Phone *string `json:"phone,omitempty"`
	// PhoneExtension - Phone extension number of the contact person.
	PhoneExtension *string `json:"phoneExtension,omitempty"`
	// Mobile - Mobile number of the contact person.
	Mobile *string `json:"mobile,omitempty"`
	// EmailList - List of Email-ids to be notified about job progress.
	EmailList *[]string `json:"emailList,omitempty"`
	// NotificationPreference - Notification preference for a job stage.
	NotificationPreference *[]NotificationPreference `json:"notificationPreference,omitempty"`
}

// BasicCopyLogDetails details for log generated during copy.
type BasicCopyLogDetails interface {
	AsAccountCopyLogDetails() (*AccountCopyLogDetails, bool)
	AsDiskCopyLogDetails() (*DiskCopyLogDetails, bool)
	AsHeavyAccountCopyLogDetails() (*HeavyAccountCopyLogDetails, bool)
	AsCopyLogDetails() (*CopyLogDetails, bool)
}

// CopyLogDetails details for log generated during copy.
type CopyLogDetails struct {
	// CopyLogDetailsType - Possible values include: 'CopyLogDetailsTypeCopyLogDetails', 'CopyLogDetailsTypeDataBox', 'CopyLogDetailsTypeDataBoxDisk', 'CopyLogDetailsTypeDataBoxHeavy'
	CopyLogDetailsType CopyLogDetailsType `json:"copyLogDetailsType,omitempty"`
}

func unmarshalBasicCopyLogDetails(body []byte) (BasicCopyLogDetails, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["copyLogDetailsType"] {
	case string(CopyLogDetailsTypeDataBox):
		var acld AccountCopyLogDetails
		err := json.Unmarshal(body, &acld)
		return acld, err
	case string(CopyLogDetailsTypeDataBoxDisk):
		var dcld DiskCopyLogDetails
		err := json.Unmarshal(body, &dcld)
		return dcld, err
	case string(CopyLogDetailsTypeDataBoxHeavy):
		var hacld HeavyAccountCopyLogDetails
		err := json.Unmarshal(body, &hacld)
		return hacld, err
	default:
		var cld CopyLogDetails
		err := json.Unmarshal(body, &cld)
		return cld, err
	}
}
func unmarshalBasicCopyLogDetailsArray(body []byte) ([]BasicCopyLogDetails, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	cldArray := make([]BasicCopyLogDetails, len(rawMessages))

	for index, rawMessage := range rawMessages {
		cld, err := unmarshalBasicCopyLogDetails(*rawMessage)
		if err != nil {
			return nil, err
		}
		cldArray[index] = cld
	}
	return cldArray, nil
}

// MarshalJSON is the custom marshaler for CopyLogDetails.
func (cld CopyLogDetails) MarshalJSON() ([]byte, error) {
	cld.CopyLogDetailsType = CopyLogDetailsTypeCopyLogDetails
	objectMap := make(map[string]interface{})
	if cld.CopyLogDetailsType != "" {
		objectMap["copyLogDetailsType"] = cld.CopyLogDetailsType
	}
	return json.Marshal(objectMap)
}

// AsAccountCopyLogDetails is the BasicCopyLogDetails implementation for CopyLogDetails.
func (cld CopyLogDetails) AsAccountCopyLogDetails() (*AccountCopyLogDetails, bool) {
	return nil, false
}

// AsDiskCopyLogDetails is the BasicCopyLogDetails implementation for CopyLogDetails.
func (cld CopyLogDetails) AsDiskCopyLogDetails() (*DiskCopyLogDetails, bool) {
	return nil, false
}

// AsHeavyAccountCopyLogDetails is the BasicCopyLogDetails implementation for CopyLogDetails.
func (cld CopyLogDetails) AsHeavyAccountCopyLogDetails() (*HeavyAccountCopyLogDetails, bool) {
	return nil, false
}

// AsCopyLogDetails is the BasicCopyLogDetails implementation for CopyLogDetails.
func (cld CopyLogDetails) AsCopyLogDetails() (*CopyLogDetails, bool) {
	return &cld, true
}

// AsBasicCopyLogDetails is the BasicCopyLogDetails implementation for CopyLogDetails.
func (cld CopyLogDetails) AsBasicCopyLogDetails() (BasicCopyLogDetails, bool) {
	return &cld, true
}

// CopyProgress copy progress.
type CopyProgress struct {
	// StorageAccountName - READ-ONLY; Name of the storage account where the data needs to be uploaded.
	StorageAccountName *string `json:"storageAccountName,omitempty"`
	// DataDestinationType - READ-ONLY; Data Destination Type. Possible values include: 'StorageAccount', 'ManagedDisk'
	DataDestinationType DataDestinationType `json:"dataDestinationType,omitempty"`
	// AccountID - READ-ONLY; Id of the account where the data needs to be uploaded.
	AccountID *string `json:"accountId,omitempty"`
	// BytesSentToCloud - READ-ONLY; Amount of data uploaded by the job as of now.
	BytesSentToCloud *int64 `json:"bytesSentToCloud,omitempty"`
	// TotalBytesToProcess - READ-ONLY; Total amount of data to be processed by the job.
	TotalBytesToProcess *int64 `json:"totalBytesToProcess,omitempty"`
	// FilesProcessed - READ-ONLY; Number of files processed by the job as of now.
	FilesProcessed *int64 `json:"filesProcessed,omitempty"`
	// TotalFilesToProcess - READ-ONLY; Total number of files to be processed by the job.
	TotalFilesToProcess *int64 `json:"totalFilesToProcess,omitempty"`
	// InvalidFilesProcessed - READ-ONLY; Number of files not adhering to azure naming conventions which were processed by automatic renaming
	InvalidFilesProcessed *int64 `json:"invalidFilesProcessed,omitempty"`
	// InvalidFileBytesUploaded - READ-ONLY; Total amount of data not adhering to azure naming conventions which were processed by automatic renaming
	InvalidFileBytesUploaded *int64 `json:"invalidFileBytesUploaded,omitempty"`
	// RenamedContainerCount - READ-ONLY; Number of folders not adhering to azure naming conventions which were processed by automatic renaming
	RenamedContainerCount *int64 `json:"renamedContainerCount,omitempty"`
	// FilesErroredOut - READ-ONLY; Number of files which could not be copied
	FilesErroredOut *int64 `json:"filesErroredOut,omitempty"`
}

// CreateJobValidations it does all pre-job creation validations.
type CreateJobValidations struct {
	// IndividualRequestDetails - List of request details contain validationType and its request as key and value respectively.
	IndividualRequestDetails *[]BasicValidationInputRequest `json:"individualRequestDetails,omitempty"`
	// ValidationCategory - Possible values include: 'ValidationCategoryValidationRequest', 'ValidationCategoryJobCreationValidation'
	ValidationCategory ValidationCategory `json:"validationCategory,omitempty"`
}

// MarshalJSON is the custom marshaler for CreateJobValidations.
func (cjv CreateJobValidations) MarshalJSON() ([]byte, error) {
	cjv.ValidationCategory = ValidationCategoryJobCreationValidation
	objectMap := make(map[string]interface{})
	if cjv.IndividualRequestDetails != nil {
		objectMap["individualRequestDetails"] = cjv.IndividualRequestDetails
	}
	if cjv.ValidationCategory != "" {
		objectMap["validationCategory"] = cjv.ValidationCategory
	}
	return json.Marshal(objectMap)
}

// AsCreateJobValidations is the BasicValidationRequest implementation for CreateJobValidations.
func (cjv CreateJobValidations) AsCreateJobValidations() (*CreateJobValidations, bool) {
	return &cjv, true
}

// AsValidationRequest is the BasicValidationRequest implementation for CreateJobValidations.
func (cjv CreateJobValidations) AsValidationRequest() (*ValidationRequest, bool) {
	return nil, false
}

// AsBasicValidationRequest is the BasicValidationRequest implementation for CreateJobValidations.
func (cjv CreateJobValidations) AsBasicValidationRequest() (BasicValidationRequest, bool) {
	return &cjv, true
}

// UnmarshalJSON is the custom unmarshaler for CreateJobValidations struct.
func (cjv *CreateJobValidations) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "individualRequestDetails":
			if v != nil {
				individualRequestDetails, err := unmarshalBasicValidationInputRequestArray(*v)
				if err != nil {
					return err
				}
				cjv.IndividualRequestDetails = &individualRequestDetails
			}
		case "validationCategory":
			if v != nil {
				var validationCategory ValidationCategory
				err = json.Unmarshal(*v, &validationCategory)
				if err != nil {
					return err
				}
				cjv.ValidationCategory = validationCategory
			}
		}
	}

	return nil
}

// CreateOrderLimitForSubscriptionValidationRequest request to validate create order limit for current
// subscription.
type CreateOrderLimitForSubscriptionValidationRequest struct {
	// DeviceType - Device type to be used for the job. Possible values include: 'DataBox', 'DataBoxDisk', 'DataBoxHeavy'
	DeviceType SkuName `json:"deviceType,omitempty"`
	// ValidationType - Possible values include: 'ValidationTypeValidationInputRequest', 'ValidationTypeValidateCreateOrderLimit', 'ValidationTypeValidateDataDestinationDetails', 'ValidationTypeValidatePreferences', 'ValidationTypeValidateSkuAvailability', 'ValidationTypeValidateSubscriptionIsAllowedToCreateJob', 'ValidationTypeValidateAddress'
	ValidationType ValidationType `json:"validationType,omitempty"`
}

// MarshalJSON is the custom marshaler for CreateOrderLimitForSubscriptionValidationRequest.
func (colfsvr CreateOrderLimitForSubscriptionValidationRequest) MarshalJSON() ([]byte, error) {
	colfsvr.ValidationType = ValidationTypeValidateCreateOrderLimit
	objectMap := make(map[string]interface{})
	if colfsvr.DeviceType != "" {
		objectMap["deviceType"] = colfsvr.DeviceType
	}
	if colfsvr.ValidationType != "" {
		objectMap["validationType"] = colfsvr.ValidationType
	}
	return json.Marshal(objectMap)
}

// AsCreateOrderLimitForSubscriptionValidationRequest is the BasicValidationInputRequest implementation for CreateOrderLimitForSubscriptionValidationRequest.
func (colfsvr CreateOrderLimitForSubscriptionValidationRequest) AsCreateOrderLimitForSubscriptionValidationRequest() (*CreateOrderLimitForSubscriptionValidationRequest, bool) {
	return &colfsvr, true
}

// AsDataDestinationDetailsValidationRequest is the BasicValidationInputRequest implementation for CreateOrderLimitForSubscriptionValidationRequest.
func (colfsvr CreateOrderLimitForSubscriptionValidationRequest) AsDataDestinationDetailsValidationRequest() (*DataDestinationDetailsValidationRequest, bool) {
	return nil, false
}

// AsPreferencesValidationRequest is the BasicValidationInputRequest implementation for CreateOrderLimitForSubscriptionValidationRequest.
func (colfsvr CreateOrderLimitForSubscriptionValidationRequest) AsPreferencesValidationRequest() (*PreferencesValidationRequest, bool) {
	return nil, false
}

// AsSkuAvailabilityValidationRequest is the BasicValidationInputRequest implementation for CreateOrderLimitForSubscriptionValidationRequest.
func (colfsvr CreateOrderLimitForSubscriptionValidationRequest) AsSkuAvailabilityValidationRequest() (*SkuAvailabilityValidationRequest, bool) {
	return nil, false
}

// AsSubscriptionIsAllowedToCreateJobValidationRequest is the BasicValidationInputRequest implementation for CreateOrderLimitForSubscriptionValidationRequest.
func (colfsvr CreateOrderLimitForSubscriptionValidationRequest) AsSubscriptionIsAllowedToCreateJobValidationRequest() (*SubscriptionIsAllowedToCreateJobValidationRequest, bool) {
	return nil, false
}

// AsValidateAddress is the BasicValidationInputRequest implementation for CreateOrderLimitForSubscriptionValidationRequest.
func (colfsvr CreateOrderLimitForSubscriptionValidationRequest) AsValidateAddress() (*ValidateAddress, bool) {
	return nil, false
}

// AsValidationInputRequest is the BasicValidationInputRequest implementation for CreateOrderLimitForSubscriptionValidationRequest.
func (colfsvr CreateOrderLimitForSubscriptionValidationRequest) AsValidationInputRequest() (*ValidationInputRequest, bool) {
	return nil, false
}

// AsBasicValidationInputRequest is the BasicValidationInputRequest implementation for CreateOrderLimitForSubscriptionValidationRequest.
func (colfsvr CreateOrderLimitForSubscriptionValidationRequest) AsBasicValidationInputRequest() (BasicValidationInputRequest, bool) {
	return &colfsvr, true
}

// CreateOrderLimitForSubscriptionValidationResponseProperties properties of create order limit for
// subscription validation response.
type CreateOrderLimitForSubscriptionValidationResponseProperties struct {
	// Status - READ-ONLY; Create order limit validation status. Possible values include: 'ValidationStatusValid', 'ValidationStatusInvalid', 'ValidationStatusSkipped'
	Status ValidationStatus `json:"status,omitempty"`
	// Error - READ-ONLY; Error code and message of validation response.
	Error *Error `json:"error,omitempty"`
	// ValidationType - Possible values include: 'ValidationTypeBasicValidationInputResponseValidationTypeValidationInputResponse', 'ValidationTypeBasicValidationInputResponseValidationTypeValidateAddress', 'ValidationTypeBasicValidationInputResponseValidationTypeValidateCreateOrderLimit', 'ValidationTypeBasicValidationInputResponseValidationTypeValidateDataDestinationDetails', 'ValidationTypeBasicValidationInputResponseValidationTypeValidatePreferences', 'ValidationTypeBasicValidationInputResponseValidationTypeValidateSkuAvailability', 'ValidationTypeBasicValidationInputResponseValidationTypeValidateSubscriptionIsAllowedToCreateJob'
	ValidationType ValidationTypeBasicValidationInputResponse `json:"validationType,omitempty"`
}

// MarshalJSON is the custom marshaler for CreateOrderLimitForSubscriptionValidationResponseProperties.
func (colfsvrp CreateOrderLimitForSubscriptionValidationResponseProperties) MarshalJSON() ([]byte, error) {
	colfsvrp.ValidationType = ValidationTypeBasicValidationInputResponseValidationTypeValidateCreateOrderLimit
	objectMap := make(map[string]interface{})
	if colfsvrp.ValidationType != "" {
		objectMap["validationType"] = colfsvrp.ValidationType
	}
	return json.Marshal(objectMap)
}

// AsAddressValidationProperties is the BasicValidationInputResponse implementation for CreateOrderLimitForSubscriptionValidationResponseProperties.
func (colfsvrp CreateOrderLimitForSubscriptionValidationResponseProperties) AsAddressValidationProperties() (*AddressValidationProperties, bool) {
	return nil, false
}

// AsCreateOrderLimitForSubscriptionValidationResponseProperties is the BasicValidationInputResponse implementation for CreateOrderLimitForSubscriptionValidationResponseProperties.
func (colfsvrp CreateOrderLimitForSubscriptionValidationResponseProperties) AsCreateOrderLimitForSubscriptionValidationResponseProperties() (*CreateOrderLimitForSubscriptionValidationResponseProperties, bool) {
	return &colfsvrp, true
}

// AsDataDestinationDetailsValidationResponseProperties is the BasicValidationInputResponse implementation for CreateOrderLimitForSubscriptionValidationResponseProperties.
func (colfsvrp CreateOrderLimitForSubscriptionValidationResponseProperties) AsDataDestinationDetailsValidationResponseProperties() (*DataDestinationDetailsValidationResponseProperties, bool) {
	return nil, false
}

// AsPreferencesValidationResponseProperties is the BasicValidationInputResponse implementation for CreateOrderLimitForSubscriptionValidationResponseProperties.
func (colfsvrp CreateOrderLimitForSubscriptionValidationResponseProperties) AsPreferencesValidationResponseProperties() (*PreferencesValidationResponseProperties, bool) {
	return nil, false
}

// AsSkuAvailabilityValidationResponseProperties is the BasicValidationInputResponse implementation for CreateOrderLimitForSubscriptionValidationResponseProperties.
func (colfsvrp CreateOrderLimitForSubscriptionValidationResponseProperties) AsSkuAvailabilityValidationResponseProperties() (*SkuAvailabilityValidationResponseProperties, bool) {
	return nil, false
}

// AsSubscriptionIsAllowedToCreateJobValidationResponseProperties is the BasicValidationInputResponse implementation for CreateOrderLimitForSubscriptionValidationResponseProperties.
func (colfsvrp CreateOrderLimitForSubscriptionValidationResponseProperties) AsSubscriptionIsAllowedToCreateJobValidationResponseProperties() (*SubscriptionIsAllowedToCreateJobValidationResponseProperties, bool) {
	return nil, false
}

// AsValidationInputResponse is the BasicValidationInputResponse implementation for CreateOrderLimitForSubscriptionValidationResponseProperties.
func (colfsvrp CreateOrderLimitForSubscriptionValidationResponseProperties) AsValidationInputResponse() (*ValidationInputResponse, bool) {
	return nil, false
}

// AsBasicValidationInputResponse is the BasicValidationInputResponse implementation for CreateOrderLimitForSubscriptionValidationResponseProperties.
func (colfsvrp CreateOrderLimitForSubscriptionValidationResponseProperties) AsBasicValidationInputResponse() (BasicValidationInputResponse, bool) {
	return &colfsvrp, true
}

// DataDestinationDetailsValidationRequest request to validate data destination details.
type DataDestinationDetailsValidationRequest struct {
	// DestinationAccountDetails - Destination account details list.
	DestinationAccountDetails *[]BasicDestinationAccountDetails `json:"destinationAccountDetails,omitempty"`
	// Location - Location of stamp or geo.
	Location *string `json:"location,omitempty"`
	// ValidationType - Possible values include: 'ValidationTypeValidationInputRequest', 'ValidationTypeValidateCreateOrderLimit', 'ValidationTypeValidateDataDestinationDetails', 'ValidationTypeValidatePreferences', 'ValidationTypeValidateSkuAvailability', 'ValidationTypeValidateSubscriptionIsAllowedToCreateJob', 'ValidationTypeValidateAddress'
	ValidationType ValidationType `json:"validationType,omitempty"`
}

// MarshalJSON is the custom marshaler for DataDestinationDetailsValidationRequest.
func (dddvr DataDestinationDetailsValidationRequest) MarshalJSON() ([]byte, error) {
	dddvr.ValidationType = ValidationTypeValidateDataDestinationDetails
	objectMap := make(map[string]interface{})
	if dddvr.DestinationAccountDetails != nil {
		objectMap["destinationAccountDetails"] = dddvr.DestinationAccountDetails
	}
	if dddvr.Location != nil {
		objectMap["location"] = dddvr.Location
	}
	if dddvr.ValidationType != "" {
		objectMap["validationType"] = dddvr.ValidationType
	}
	return json.Marshal(objectMap)
}

// AsCreateOrderLimitForSubscriptionValidationRequest is the BasicValidationInputRequest implementation for DataDestinationDetailsValidationRequest.
func (dddvr DataDestinationDetailsValidationRequest) AsCreateOrderLimitForSubscriptionValidationRequest() (*CreateOrderLimitForSubscriptionValidationRequest, bool) {
	return nil, false
}

// AsDataDestinationDetailsValidationRequest is the BasicValidationInputRequest implementation for DataDestinationDetailsValidationRequest.
func (dddvr DataDestinationDetailsValidationRequest) AsDataDestinationDetailsValidationRequest() (*DataDestinationDetailsValidationRequest, bool) {
	return &dddvr, true
}

// AsPreferencesValidationRequest is the BasicValidationInputRequest implementation for DataDestinationDetailsValidationRequest.
func (dddvr DataDestinationDetailsValidationRequest) AsPreferencesValidationRequest() (*PreferencesValidationRequest, bool) {
	return nil, false
}

// AsSkuAvailabilityValidationRequest is the BasicValidationInputRequest implementation for DataDestinationDetailsValidationRequest.
func (dddvr DataDestinationDetailsValidationRequest) AsSkuAvailabilityValidationRequest() (*SkuAvailabilityValidationRequest, bool) {
	return nil, false
}

// AsSubscriptionIsAllowedToCreateJobValidationRequest is the BasicValidationInputRequest implementation for DataDestinationDetailsValidationRequest.
func (dddvr DataDestinationDetailsValidationRequest) AsSubscriptionIsAllowedToCreateJobValidationRequest() (*SubscriptionIsAllowedToCreateJobValidationRequest, bool) {
	return nil, false
}

// AsValidateAddress is the BasicValidationInputRequest implementation for DataDestinationDetailsValidationRequest.
func (dddvr DataDestinationDetailsValidationRequest) AsValidateAddress() (*ValidateAddress, bool) {
	return nil, false
}

// AsValidationInputRequest is the BasicValidationInputRequest implementation for DataDestinationDetailsValidationRequest.
func (dddvr DataDestinationDetailsValidationRequest) AsValidationInputRequest() (*ValidationInputRequest, bool) {
	return nil, false
}

// AsBasicValidationInputRequest is the BasicValidationInputRequest implementation for DataDestinationDetailsValidationRequest.
func (dddvr DataDestinationDetailsValidationRequest) AsBasicValidationInputRequest() (BasicValidationInputRequest, bool) {
	return &dddvr, true
}

// UnmarshalJSON is the custom unmarshaler for DataDestinationDetailsValidationRequest struct.
func (dddvr *DataDestinationDetailsValidationRequest) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "destinationAccountDetails":
			if v != nil {
				destinationAccountDetails, err := unmarshalBasicDestinationAccountDetailsArray(*v)
				if err != nil {
					return err
				}
				dddvr.DestinationAccountDetails = &destinationAccountDetails
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				dddvr.Location = &location
			}
		case "validationType":
			if v != nil {
				var validationType ValidationType
				err = json.Unmarshal(*v, &validationType)
				if err != nil {
					return err
				}
				dddvr.ValidationType = validationType
			}
		}
	}

	return nil
}

// DataDestinationDetailsValidationResponseProperties properties of data destination details validation
// response.
type DataDestinationDetailsValidationResponseProperties struct {
	// Status - READ-ONLY; Data destination details validation status. Possible values include: 'ValidationStatusValid', 'ValidationStatusInvalid', 'ValidationStatusSkipped'
	Status ValidationStatus `json:"status,omitempty"`
	// Error - READ-ONLY; Error code and message of validation response.
	Error *Error `json:"error,omitempty"`
	// ValidationType - Possible values include: 'ValidationTypeBasicValidationInputResponseValidationTypeValidationInputResponse', 'ValidationTypeBasicValidationInputResponseValidationTypeValidateAddress', 'ValidationTypeBasicValidationInputResponseValidationTypeValidateCreateOrderLimit', 'ValidationTypeBasicValidationInputResponseValidationTypeValidateDataDestinationDetails', 'ValidationTypeBasicValidationInputResponseValidationTypeValidatePreferences', 'ValidationTypeBasicValidationInputResponseValidationTypeValidateSkuAvailability', 'ValidationTypeBasicValidationInputResponseValidationTypeValidateSubscriptionIsAllowedToCreateJob'
	ValidationType ValidationTypeBasicValidationInputResponse `json:"validationType,omitempty"`
}

// MarshalJSON is the custom marshaler for DataDestinationDetailsValidationResponseProperties.
func (dddvrp DataDestinationDetailsValidationResponseProperties) MarshalJSON() ([]byte, error) {
	dddvrp.ValidationType = ValidationTypeBasicValidationInputResponseValidationTypeValidateDataDestinationDetails
	objectMap := make(map[string]interface{})
	if dddvrp.ValidationType != "" {
		objectMap["validationType"] = dddvrp.ValidationType
	}
	return json.Marshal(objectMap)
}

// AsAddressValidationProperties is the BasicValidationInputResponse implementation for DataDestinationDetailsValidationResponseProperties.
func (dddvrp DataDestinationDetailsValidationResponseProperties) AsAddressValidationProperties() (*AddressValidationProperties, bool) {
	return nil, false
}

// AsCreateOrderLimitForSubscriptionValidationResponseProperties is the BasicValidationInputResponse implementation for DataDestinationDetailsValidationResponseProperties.
func (dddvrp DataDestinationDetailsValidationResponseProperties) AsCreateOrderLimitForSubscriptionValidationResponseProperties() (*CreateOrderLimitForSubscriptionValidationResponseProperties, bool) {
	return nil, false
}

// AsDataDestinationDetailsValidationResponseProperties is the BasicValidationInputResponse implementation for DataDestinationDetailsValidationResponseProperties.
func (dddvrp DataDestinationDetailsValidationResponseProperties) AsDataDestinationDetailsValidationResponseProperties() (*DataDestinationDetailsValidationResponseProperties, bool) {
	return &dddvrp, true
}

// AsPreferencesValidationResponseProperties is the BasicValidationInputResponse implementation for DataDestinationDetailsValidationResponseProperties.
func (dddvrp DataDestinationDetailsValidationResponseProperties) AsPreferencesValidationResponseProperties() (*PreferencesValidationResponseProperties, bool) {
	return nil, false
}

// AsSkuAvailabilityValidationResponseProperties is the BasicValidationInputResponse implementation for DataDestinationDetailsValidationResponseProperties.
func (dddvrp DataDestinationDetailsValidationResponseProperties) AsSkuAvailabilityValidationResponseProperties() (*SkuAvailabilityValidationResponseProperties, bool) {
	return nil, false
}

// AsSubscriptionIsAllowedToCreateJobValidationResponseProperties is the BasicValidationInputResponse implementation for DataDestinationDetailsValidationResponseProperties.
func (dddvrp DataDestinationDetailsValidationResponseProperties) AsSubscriptionIsAllowedToCreateJobValidationResponseProperties() (*SubscriptionIsAllowedToCreateJobValidationResponseProperties, bool) {
	return nil, false
}

// AsValidationInputResponse is the BasicValidationInputResponse implementation for DataDestinationDetailsValidationResponseProperties.
func (dddvrp DataDestinationDetailsValidationResponseProperties) AsValidationInputResponse() (*ValidationInputResponse, bool) {
	return nil, false
}

// AsBasicValidationInputResponse is the BasicValidationInputResponse implementation for DataDestinationDetailsValidationResponseProperties.
func (dddvrp DataDestinationDetailsValidationResponseProperties) AsBasicValidationInputResponse() (BasicValidationInputResponse, bool) {
	return &dddvrp, true
}

// DcAccessSecurityCode dc Access Security code for device.
type DcAccessSecurityCode struct {
	// ForwardDcAccessCode - Dc Access Code for dispatching from DC.
	ForwardDcAccessCode *string `json:"forwardDcAccessCode,omitempty"`
	// ReverseDcAccessCode - Dc Access code for dropping off at DC.
	ReverseDcAccessCode *string `json:"reverseDcAccessCode,omitempty"`
}

// BasicDestinationAccountDetails details of the destination storage accounts.
type BasicDestinationAccountDetails interface {
	AsDestinationManagedDiskDetails() (*DestinationManagedDiskDetails, bool)
	AsDestinationStorageAccountDetails() (*DestinationStorageAccountDetails, bool)
	AsDestinationAccountDetails() (*DestinationAccountDetails, bool)
}

// DestinationAccountDetails details of the destination storage accounts.
type DestinationAccountDetails struct {
	// AccountID - Arm Id of the destination where the data has to be moved.
	AccountID *string `json:"accountId,omitempty"`
	// SharePassword - Share password to be shared by all shares in SA.
	SharePassword *string `json:"sharePassword,omitempty"`
	// DataDestinationType - Possible values include: 'DataDestinationTypeDestinationAccountDetails', 'DataDestinationTypeManagedDisk', 'DataDestinationTypeStorageAccount'
	DataDestinationType DataDestinationTypeBasicDestinationAccountDetails `json:"dataDestinationType,omitempty"`
}

func unmarshalBasicDestinationAccountDetails(body []byte) (BasicDestinationAccountDetails, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["dataDestinationType"] {
	case string(DataDestinationTypeManagedDisk):
		var dmdd DestinationManagedDiskDetails
		err := json.Unmarshal(body, &dmdd)
		return dmdd, err
	case string(DataDestinationTypeStorageAccount):
		var dsad DestinationStorageAccountDetails
		err := json.Unmarshal(body, &dsad)
		return dsad, err
	default:
		var dad DestinationAccountDetails
		err := json.Unmarshal(body, &dad)
		return dad, err
	}
}
func unmarshalBasicDestinationAccountDetailsArray(body []byte) ([]BasicDestinationAccountDetails, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	dadArray := make([]BasicDestinationAccountDetails, len(rawMessages))

	for index, rawMessage := range rawMessages {
		dad, err := unmarshalBasicDestinationAccountDetails(*rawMessage)
		if err != nil {
			return nil, err
		}
		dadArray[index] = dad
	}
	return dadArray, nil
}

// MarshalJSON is the custom marshaler for DestinationAccountDetails.
func (dad DestinationAccountDetails) MarshalJSON() ([]byte, error) {
	dad.DataDestinationType = DataDestinationTypeDestinationAccountDetails
	objectMap := make(map[string]interface{})
	if dad.AccountID != nil {
		objectMap["accountId"] = dad.AccountID
	}
	if dad.SharePassword != nil {
		objectMap["sharePassword"] = dad.SharePassword
	}
	if dad.DataDestinationType != "" {
		objectMap["dataDestinationType"] = dad.DataDestinationType
	}
	return json.Marshal(objectMap)
}

// AsDestinationManagedDiskDetails is the BasicDestinationAccountDetails implementation for DestinationAccountDetails.
func (dad DestinationAccountDetails) AsDestinationManagedDiskDetails() (*DestinationManagedDiskDetails, bool) {
	return nil, false
}

// AsDestinationStorageAccountDetails is the BasicDestinationAccountDetails implementation for DestinationAccountDetails.
func (dad DestinationAccountDetails) AsDestinationStorageAccountDetails() (*DestinationStorageAccountDetails, bool) {
	return nil, false
}

// AsDestinationAccountDetails is the BasicDestinationAccountDetails implementation for DestinationAccountDetails.
func (dad DestinationAccountDetails) AsDestinationAccountDetails() (*DestinationAccountDetails, bool) {
	return &dad, true
}

// AsBasicDestinationAccountDetails is the BasicDestinationAccountDetails implementation for DestinationAccountDetails.
func (dad DestinationAccountDetails) AsBasicDestinationAccountDetails() (BasicDestinationAccountDetails, bool) {
	return &dad, true
}

// DestinationManagedDiskDetails details for the destination compute disks.
type DestinationManagedDiskDetails struct {
	// ResourceGroupID - Destination Resource Group Id where the Compute disks should be created.
	ResourceGroupID *string `json:"resourceGroupId,omitempty"`
	// StagingStorageAccountID - Arm Id of the storage account that can be used to copy the vhd for staging.
	StagingStorageAccountID *string `json:"stagingStorageAccountId,omitempty"`
	// AccountID - Arm Id of the destination where the data has to be moved.
	AccountID *string `json:"accountId,omitempty"`
	// SharePassword - Share password to be shared by all shares in SA.
	SharePassword *string `json:"sharePassword,omitempty"`
	// DataDestinationType - Possible values include: 'DataDestinationTypeDestinationAccountDetails', 'DataDestinationTypeManagedDisk', 'DataDestinationTypeStorageAccount'
	DataDestinationType DataDestinationTypeBasicDestinationAccountDetails `json:"dataDestinationType,omitempty"`
}

// MarshalJSON is the custom marshaler for DestinationManagedDiskDetails.
func (dmdd DestinationManagedDiskDetails) MarshalJSON() ([]byte, error) {
	dmdd.DataDestinationType = DataDestinationTypeManagedDisk
	objectMap := make(map[string]interface{})
	if dmdd.ResourceGroupID != nil {
		objectMap["resourceGroupId"] = dmdd.ResourceGroupID
	}
	if dmdd.StagingStorageAccountID != nil {
		objectMap["stagingStorageAccountId"] = dmdd.StagingStorageAccountID
	}
	if dmdd.AccountID != nil {
		objectMap["accountId"] = dmdd.AccountID
	}
	if dmdd.SharePassword != nil {
		objectMap["sharePassword"] = dmdd.SharePassword
	}
	if dmdd.DataDestinationType != "" {
		objectMap["dataDestinationType"] = dmdd.DataDestinationType
	}
	return json.Marshal(objectMap)
}

// AsDestinationManagedDiskDetails is the BasicDestinationAccountDetails implementation for DestinationManagedDiskDetails.
func (dmdd DestinationManagedDiskDetails) AsDestinationManagedDiskDetails() (*DestinationManagedDiskDetails, bool) {
	return &dmdd, true
}

// AsDestinationStorageAccountDetails is the BasicDestinationAccountDetails implementation for DestinationManagedDiskDetails.
func (dmdd DestinationManagedDiskDetails) AsDestinationStorageAccountDetails() (*DestinationStorageAccountDetails, bool) {
	return nil, false
}

// AsDestinationAccountDetails is the BasicDestinationAccountDetails implementation for DestinationManagedDiskDetails.
func (dmdd DestinationManagedDiskDetails) AsDestinationAccountDetails() (*DestinationAccountDetails, bool) {
	return nil, false
}

// AsBasicDestinationAccountDetails is the BasicDestinationAccountDetails implementation for DestinationManagedDiskDetails.
func (dmdd DestinationManagedDiskDetails) AsBasicDestinationAccountDetails() (BasicDestinationAccountDetails, bool) {
	return &dmdd, true
}

// DestinationStorageAccountDetails details for the destination storage account.
type DestinationStorageAccountDetails struct {
	// StorageAccountID - Destination Storage Account Arm Id.
	StorageAccountID *string `json:"storageAccountId,omitempty"`
	// AccountID - Arm Id of the destination where the data has to be moved.
	AccountID *string `json:"accountId,omitempty"`
	// SharePassword - Share password to be shared by all shares in SA.
	SharePassword *string `json:"sharePassword,omitempty"`
	// DataDestinationType - Possible values include: 'DataDestinationTypeDestinationAccountDetails', 'DataDestinationTypeManagedDisk', 'DataDestinationTypeStorageAccount'
	DataDestinationType DataDestinationTypeBasicDestinationAccountDetails `json:"dataDestinationType,omitempty"`
}

// MarshalJSON is the custom marshaler for DestinationStorageAccountDetails.
func (dsad DestinationStorageAccountDetails) MarshalJSON() ([]byte, error) {
	dsad.DataDestinationType = DataDestinationTypeStorageAccount
	objectMap := make(map[string]interface{})
	if dsad.StorageAccountID != nil {
		objectMap["storageAccountId"] = dsad.StorageAccountID
	}
	if dsad.AccountID != nil {
		objectMap["accountId"] = dsad.AccountID
	}
	if dsad.SharePassword != nil {
		objectMap["sharePassword"] = dsad.SharePassword
	}
	if dsad.DataDestinationType != "" {
		objectMap["dataDestinationType"] = dsad.DataDestinationType
	}
	return json.Marshal(objectMap)
}

// AsDestinationManagedDiskDetails is the BasicDestinationAccountDetails implementation for DestinationStorageAccountDetails.
func (dsad DestinationStorageAccountDetails) AsDestinationManagedDiskDetails() (*DestinationManagedDiskDetails, bool) {
	return nil, false
}

// AsDestinationStorageAccountDetails is the BasicDestinationAccountDetails implementation for DestinationStorageAccountDetails.
func (dsad DestinationStorageAccountDetails) AsDestinationStorageAccountDetails() (*DestinationStorageAccountDetails, bool) {
	return &dsad, true
}

// AsDestinationAccountDetails is the BasicDestinationAccountDetails implementation for DestinationStorageAccountDetails.
func (dsad DestinationStorageAccountDetails) AsDestinationAccountDetails() (*DestinationAccountDetails, bool) {
	return nil, false
}

// AsBasicDestinationAccountDetails is the BasicDestinationAccountDetails implementation for DestinationStorageAccountDetails.
func (dsad DestinationStorageAccountDetails) AsBasicDestinationAccountDetails() (BasicDestinationAccountDetails, bool) {
	return &dsad, true
}

// DestinationToServiceLocationMap map of destination location to service location.
type DestinationToServiceLocationMap struct {
	// DestinationLocation - READ-ONLY; Location of the destination.
	DestinationLocation *string `json:"destinationLocation,omitempty"`
	// ServiceLocation - READ-ONLY; Location of the service.
	ServiceLocation *string `json:"serviceLocation,omitempty"`
}

// DiskCopyLogDetails copy Log Details for a disk
type DiskCopyLogDetails struct {
	// DiskSerialNumber - READ-ONLY; Disk Serial Number.
	DiskSerialNumber *string `json:"diskSerialNumber,omitempty"`
	// ErrorLogLink - READ-ONLY; Link for copy error logs.
	ErrorLogLink *string `json:"errorLogLink,omitempty"`
	// VerboseLogLink - READ-ONLY; Link for copy verbose logs.
	VerboseLogLink *string `json:"verboseLogLink,omitempty"`
	// CopyLogDetailsType - Possible values include: 'CopyLogDetailsTypeCopyLogDetails', 'CopyLogDetailsTypeDataBox', 'CopyLogDetailsTypeDataBoxDisk', 'CopyLogDetailsTypeDataBoxHeavy'
	CopyLogDetailsType CopyLogDetailsType `json:"copyLogDetailsType,omitempty"`
}

// MarshalJSON is the custom marshaler for DiskCopyLogDetails.
func (dcld DiskCopyLogDetails) MarshalJSON() ([]byte, error) {
	dcld.CopyLogDetailsType = CopyLogDetailsTypeDataBoxDisk
	objectMap := make(map[string]interface{})
	if dcld.CopyLogDetailsType != "" {
		objectMap["copyLogDetailsType"] = dcld.CopyLogDetailsType
	}
	return json.Marshal(objectMap)
}

// AsAccountCopyLogDetails is the BasicCopyLogDetails implementation for DiskCopyLogDetails.
func (dcld DiskCopyLogDetails) AsAccountCopyLogDetails() (*AccountCopyLogDetails, bool) {
	return nil, false
}

// AsDiskCopyLogDetails is the BasicCopyLogDetails implementation for DiskCopyLogDetails.
func (dcld DiskCopyLogDetails) AsDiskCopyLogDetails() (*DiskCopyLogDetails, bool) {
	return &dcld, true
}

// AsHeavyAccountCopyLogDetails is the BasicCopyLogDetails implementation for DiskCopyLogDetails.
func (dcld DiskCopyLogDetails) AsHeavyAccountCopyLogDetails() (*HeavyAccountCopyLogDetails, bool) {
	return nil, false
}

// AsCopyLogDetails is the BasicCopyLogDetails implementation for DiskCopyLogDetails.
func (dcld DiskCopyLogDetails) AsCopyLogDetails() (*CopyLogDetails, bool) {
	return nil, false
}

// AsBasicCopyLogDetails is the BasicCopyLogDetails implementation for DiskCopyLogDetails.
func (dcld DiskCopyLogDetails) AsBasicCopyLogDetails() (BasicCopyLogDetails, bool) {
	return &dcld, true
}

// DiskCopyProgress dataBox Disk Copy Progress
type DiskCopyProgress struct {
	// SerialNumber - READ-ONLY; The serial number of the disk
	SerialNumber *string `json:"serialNumber,omitempty"`
	// BytesCopied - READ-ONLY; Bytes copied during the copy of disk.
	BytesCopied *int64 `json:"bytesCopied,omitempty"`
	// PercentComplete - READ-ONLY; Indicates the percentage completed for the copy of the disk.
	PercentComplete *int32 `json:"percentComplete,omitempty"`
	// Status - READ-ONLY; The Status of the copy. Possible values include: 'NotStarted', 'InProgress', 'Completed', 'CompletedWithErrors', 'Failed', 'NotReturned', 'HardwareError', 'DeviceFormatted', 'DeviceMetadataModified', 'StorageAccountNotAccessible', 'UnsupportedData'
	Status CopyStatus `json:"status,omitempty"`
}

// DiskJobDetails dataBox Disk Job Details.
type DiskJobDetails struct {
	// PreferredDisks - User preference on what size disks are needed for the job. The map is from the disk size in TB to the count. Eg. {2,5} means 5 disks of 2 TB size. Key is string but will be checked against an int.
	PreferredDisks map[string]*int32 `json:"preferredDisks"`
	// CopyProgress - READ-ONLY; Copy progress per disk.
	CopyProgress *[]DiskCopyProgress `json:"copyProgress,omitempty"`
	// DisksAndSizeDetails - READ-ONLY; Contains the map of disk serial number to the disk size being used for the job. Is returned only after the disks are shipped to the customer.
	DisksAndSizeDetails map[string]*int32 `json:"disksAndSizeDetails"`
	// Passkey - User entered passkey for DataBox Disk job.
	Passkey *string `json:"passkey,omitempty"`
	// ExpectedDataSizeInTerabytes - The expected size of the data, which needs to be transferred in this job, in terabytes.
	ExpectedDataSizeInTerabytes *int32 `json:"expectedDataSizeInTerabytes,omitempty"`
	// JobStages - READ-ONLY; List of stages that run in the job.
	JobStages *[]JobStages `json:"jobStages,omitempty"`
	// ContactDetails - Contact details for notification and shipping.
	ContactDetails *ContactDetails `json:"contactDetails,omitempty"`
	// ShippingAddress - Shipping address of the customer.
	ShippingAddress *ShippingAddress `json:"shippingAddress,omitempty"`
	// DeliveryPackage - READ-ONLY; Delivery package shipping details.
	DeliveryPackage *PackageShippingDetails `json:"deliveryPackage,omitempty"`
	// ReturnPackage - READ-ONLY; Return package shipping details.
	ReturnPackage *PackageShippingDetails `json:"returnPackage,omitempty"`
	// DestinationAccountDetails - Destination account details.
	DestinationAccountDetails *[]BasicDestinationAccountDetails `json:"destinationAccountDetails,omitempty"`
	// ErrorDetails - READ-ONLY; Error details for failure. This is optional.
	ErrorDetails *[]JobErrorDetails `json:"errorDetails,omitempty"`
	// Preferences - Preferences for the order.
	Preferences *Preferences `json:"preferences,omitempty"`
	// CopyLogDetails - READ-ONLY; List of copy log details.
	CopyLogDetails *[]BasicCopyLogDetails `json:"copyLogDetails,omitempty"`
	// ReverseShipmentLabelSasKey - READ-ONLY; Shared access key to download the return shipment label
	ReverseShipmentLabelSasKey *string `json:"reverseShipmentLabelSasKey,omitempty"`
	// ChainOfCustodySasKey - READ-ONLY; Shared access key to download the chain of custody logs
	ChainOfCustodySasKey *string `json:"chainOfCustodySasKey,omitempty"`
	// JobDetailsType - Possible values include: 'JobDetailsTypeJobDetails', 'JobDetailsTypeDataBoxDisk', 'JobDetailsTypeDataBoxHeavy', 'JobDetailsTypeDataBox'
	JobDetailsType JobDetailsTypeEnum `json:"jobDetailsType,omitempty"`
}

// MarshalJSON is the custom marshaler for DiskJobDetails.
func (djd DiskJobDetails) MarshalJSON() ([]byte, error) {
	djd.JobDetailsType = JobDetailsTypeDataBoxDisk
	objectMap := make(map[string]interface{})
	if djd.PreferredDisks != nil {
		objectMap["preferredDisks"] = djd.PreferredDisks
	}
	if djd.Passkey != nil {
		objectMap["passkey"] = djd.Passkey
	}
	if djd.ExpectedDataSizeInTerabytes != nil {
		objectMap["expectedDataSizeInTerabytes"] = djd.ExpectedDataSizeInTerabytes
	}
	if djd.ContactDetails != nil {
		objectMap["contactDetails"] = djd.ContactDetails
	}
	if djd.ShippingAddress != nil {
		objectMap["shippingAddress"] = djd.ShippingAddress
	}
	if djd.DestinationAccountDetails != nil {
		objectMap["destinationAccountDetails"] = djd.DestinationAccountDetails
	}
	if djd.Preferences != nil {
		objectMap["preferences"] = djd.Preferences
	}
	if djd.JobDetailsType != "" {
		objectMap["jobDetailsType"] = djd.JobDetailsType
	}
	return json.Marshal(objectMap)
}

// AsDiskJobDetails is the BasicJobDetails implementation for DiskJobDetails.
func (djd DiskJobDetails) AsDiskJobDetails() (*DiskJobDetails, bool) {
	return &djd, true
}

// AsHeavyJobDetails is the BasicJobDetails implementation for DiskJobDetails.
func (djd DiskJobDetails) AsHeavyJobDetails() (*HeavyJobDetails, bool) {
	return nil, false
}

// AsJobDetailsType is the BasicJobDetails implementation for DiskJobDetails.
func (djd DiskJobDetails) AsJobDetailsType() (*JobDetailsType, bool) {
	return nil, false
}

// AsJobDetails is the BasicJobDetails implementation for DiskJobDetails.
func (djd DiskJobDetails) AsJobDetails() (*JobDetails, bool) {
	return nil, false
}

// AsBasicJobDetails is the BasicJobDetails implementation for DiskJobDetails.
func (djd DiskJobDetails) AsBasicJobDetails() (BasicJobDetails, bool) {
	return &djd, true
}

// UnmarshalJSON is the custom unmarshaler for DiskJobDetails struct.
func (djd *DiskJobDetails) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "preferredDisks":
			if v != nil {
				var preferredDisks map[string]*int32
				err = json.Unmarshal(*v, &preferredDisks)
				if err != nil {
					return err
				}
				djd.PreferredDisks = preferredDisks
			}
		case "copyProgress":
			if v != nil {
				var copyProgress []DiskCopyProgress
				err = json.Unmarshal(*v, &copyProgress)
				if err != nil {
					return err
				}
				djd.CopyProgress = &copyProgress
			}
		case "disksAndSizeDetails":
			if v != nil {
				var disksAndSizeDetails map[string]*int32
				err = json.Unmarshal(*v, &disksAndSizeDetails)
				if err != nil {
					return err
				}
				djd.DisksAndSizeDetails = disksAndSizeDetails
			}
		case "passkey":
			if v != nil {
				var passkey string
				err = json.Unmarshal(*v, &passkey)
				if err != nil {
					return err
				}
				djd.Passkey = &passkey
			}
		case "expectedDataSizeInTerabytes":
			if v != nil {
				var expectedDataSizeInTerabytes int32
				err = json.Unmarshal(*v, &expectedDataSizeInTerabytes)
				if err != nil {
					return err
				}
				djd.ExpectedDataSizeInTerabytes = &expectedDataSizeInTerabytes
			}
		case "jobStages":
			if v != nil {
				var jobStages []JobStages
				err = json.Unmarshal(*v, &jobStages)
				if err != nil {
					return err
				}
				djd.JobStages = &jobStages
			}
		case "contactDetails":
			if v != nil {
				var contactDetails ContactDetails
				err = json.Unmarshal(*v, &contactDetails)
				if err != nil {
					return err
				}
				djd.ContactDetails = &contactDetails
			}
		case "shippingAddress":
			if v != nil {
				var shippingAddress ShippingAddress
				err = json.Unmarshal(*v, &shippingAddress)
				if err != nil {
					return err
				}
				djd.ShippingAddress = &shippingAddress
			}
		case "deliveryPackage":
			if v != nil {
				var deliveryPackage PackageShippingDetails
				err = json.Unmarshal(*v, &deliveryPackage)
				if err != nil {
					return err
				}
				djd.DeliveryPackage = &deliveryPackage
			}
		case "returnPackage":
			if v != nil {
				var returnPackage PackageShippingDetails
				err = json.Unmarshal(*v, &returnPackage)
				if err != nil {
					return err
				}
				djd.ReturnPackage = &returnPackage
			}
		case "destinationAccountDetails":
			if v != nil {
				destinationAccountDetails, err := unmarshalBasicDestinationAccountDetailsArray(*v)
				if err != nil {
					return err
				}
				djd.DestinationAccountDetails = &destinationAccountDetails
			}
		case "errorDetails":
			if v != nil {
				var errorDetails []JobErrorDetails
				err = json.Unmarshal(*v, &errorDetails)
				if err != nil {
					return err
				}
				djd.ErrorDetails = &errorDetails
			}
		case "preferences":
			if v != nil {
				var preferences Preferences
				err = json.Unmarshal(*v, &preferences)
				if err != nil {
					return err
				}
				djd.Preferences = &preferences
			}
		case "copyLogDetails":
			if v != nil {
				copyLogDetails, err := unmarshalBasicCopyLogDetailsArray(*v)
				if err != nil {
					return err
				}
				djd.CopyLogDetails = &copyLogDetails
			}
		case "reverseShipmentLabelSasKey":
			if v != nil {
				var reverseShipmentLabelSasKey string
				err = json.Unmarshal(*v, &reverseShipmentLabelSasKey)
				if err != nil {
					return err
				}
				djd.ReverseShipmentLabelSasKey = &reverseShipmentLabelSasKey
			}
		case "chainOfCustodySasKey":
			if v != nil {
				var chainOfCustodySasKey string
				err = json.Unmarshal(*v, &chainOfCustodySasKey)
				if err != nil {
					return err
				}
				djd.ChainOfCustodySasKey = &chainOfCustodySasKey
			}
		case "jobDetailsType":
			if v != nil {
				var jobDetailsType JobDetailsTypeEnum
				err = json.Unmarshal(*v, &jobDetailsType)
				if err != nil {
					return err
				}
				djd.JobDetailsType = jobDetailsType
			}
		}
	}

	return nil
}

// DiskJobSecrets the secrets related to disk job.
type DiskJobSecrets struct {
	// DiskSecrets - READ-ONLY; Contains the list of secrets object for that device.
	DiskSecrets *[]DiskSecret `json:"diskSecrets,omitempty"`
	// PassKey - READ-ONLY; PassKey for the disk Job.
	PassKey *string `json:"passKey,omitempty"`
	// IsPasskeyUserDefined - READ-ONLY; Whether passkey was provided by user.
	IsPasskeyUserDefined *bool `json:"isPasskeyUserDefined,omitempty"`
	// DcAccessSecurityCode - Dc Access Security Code for Customer Managed Shipping
	DcAccessSecurityCode *DcAccessSecurityCode `json:"dcAccessSecurityCode,omitempty"`
	// JobSecretsType - Possible values include: 'JobSecretsTypeJobSecrets', 'JobSecretsTypeDataBoxDisk', 'JobSecretsTypeDataBoxHeavy', 'JobSecretsTypeDataBox'
	JobSecretsType JobSecretsTypeEnum `json:"jobSecretsType,omitempty"`
}

// MarshalJSON is the custom marshaler for DiskJobSecrets.
func (djs DiskJobSecrets) MarshalJSON() ([]byte, error) {
	djs.JobSecretsType = JobSecretsTypeDataBoxDisk
	objectMap := make(map[string]interface{})
	if djs.DcAccessSecurityCode != nil {
		objectMap["dcAccessSecurityCode"] = djs.DcAccessSecurityCode
	}
	if djs.JobSecretsType != "" {
		objectMap["jobSecretsType"] = djs.JobSecretsType
	}
	return json.Marshal(objectMap)
}

// AsDiskJobSecrets is the BasicJobSecrets implementation for DiskJobSecrets.
func (djs DiskJobSecrets) AsDiskJobSecrets() (*DiskJobSecrets, bool) {
	return &djs, true
}

// AsHeavyJobSecrets is the BasicJobSecrets implementation for DiskJobSecrets.
func (djs DiskJobSecrets) AsHeavyJobSecrets() (*HeavyJobSecrets, bool) {
	return nil, false
}

// AsJobSecretsType is the BasicJobSecrets implementation for DiskJobSecrets.
func (djs DiskJobSecrets) AsJobSecretsType() (*JobSecretsType, bool) {
	return nil, false
}

// AsJobSecrets is the BasicJobSecrets implementation for DiskJobSecrets.
func (djs DiskJobSecrets) AsJobSecrets() (*JobSecrets, bool) {
	return nil, false
}

// AsBasicJobSecrets is the BasicJobSecrets implementation for DiskJobSecrets.
func (djs DiskJobSecrets) AsBasicJobSecrets() (BasicJobSecrets, bool) {
	return &djs, true
}

// DiskScheduleAvailabilityRequest request body to get the availability for scheduling disk orders.
type DiskScheduleAvailabilityRequest struct {
	// ExpectedDataSizeInTerabytes - The expected size of the data, which needs to be transferred in this job, in terabytes.
	ExpectedDataSizeInTerabytes *int32 `json:"expectedDataSizeInTerabytes,omitempty"`
	// StorageLocation - Location for data transfer.
	// For locations check: https://management.azure.com/subscriptions/SUBSCRIPTIONID/locations?api-version=2018-01-01
	StorageLocation *string `json:"storageLocation,omitempty"`
	// SkuName - Possible values include: 'SkuNameScheduleAvailabilityRequest', 'SkuNameDataBox', 'SkuNameDataBoxDisk', 'SkuNameDataBoxHeavy'
	SkuName SkuNameBasicScheduleAvailabilityRequest `json:"skuName,omitempty"`
}

// MarshalJSON is the custom marshaler for DiskScheduleAvailabilityRequest.
func (dsar DiskScheduleAvailabilityRequest) MarshalJSON() ([]byte, error) {
	dsar.SkuName = SkuNameDataBoxDisk
	objectMap := make(map[string]interface{})
	if dsar.ExpectedDataSizeInTerabytes != nil {
		objectMap["expectedDataSizeInTerabytes"] = dsar.ExpectedDataSizeInTerabytes
	}
	if dsar.StorageLocation != nil {
		objectMap["storageLocation"] = dsar.StorageLocation
	}
	if dsar.SkuName != "" {
		objectMap["skuName"] = dsar.SkuName
	}
	return json.Marshal(objectMap)
}

// AsScheduleAvailabilityRequestType is the BasicScheduleAvailabilityRequest implementation for DiskScheduleAvailabilityRequest.
func (dsar DiskScheduleAvailabilityRequest) AsScheduleAvailabilityRequestType() (*ScheduleAvailabilityRequestType, bool) {
	return nil, false
}

// AsDiskScheduleAvailabilityRequest is the BasicScheduleAvailabilityRequest implementation for DiskScheduleAvailabilityRequest.
func (dsar DiskScheduleAvailabilityRequest) AsDiskScheduleAvailabilityRequest() (*DiskScheduleAvailabilityRequest, bool) {
	return &dsar, true
}

// AsHeavyScheduleAvailabilityRequest is the BasicScheduleAvailabilityRequest implementation for DiskScheduleAvailabilityRequest.
func (dsar DiskScheduleAvailabilityRequest) AsHeavyScheduleAvailabilityRequest() (*HeavyScheduleAvailabilityRequest, bool) {
	return nil, false
}

// AsScheduleAvailabilityRequest is the BasicScheduleAvailabilityRequest implementation for DiskScheduleAvailabilityRequest.
func (dsar DiskScheduleAvailabilityRequest) AsScheduleAvailabilityRequest() (*ScheduleAvailabilityRequest, bool) {
	return nil, false
}

// AsBasicScheduleAvailabilityRequest is the BasicScheduleAvailabilityRequest implementation for DiskScheduleAvailabilityRequest.
func (dsar DiskScheduleAvailabilityRequest) AsBasicScheduleAvailabilityRequest() (BasicScheduleAvailabilityRequest, bool) {
	return &dsar, true
}

// DiskSecret contains all the secrets of a Disk.
type DiskSecret struct {
	// DiskSerialNumber - READ-ONLY; Serial number of the assigned disk.
	DiskSerialNumber *string `json:"diskSerialNumber,omitempty"`
	// BitLockerKey - READ-ONLY; Bit Locker key of the disk which can be used to unlock the disk to copy data.
	BitLockerKey *string `json:"bitLockerKey,omitempty"`
}

// Error top level error for the job.
type Error struct {
	// Code - READ-ONLY; Error code that can be used to programmatically identify the error.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; Describes the error in detail and provides debugging information.
	Message *string `json:"message,omitempty"`
}

// HeavyAccountCopyLogDetails copy log details for a storage account for Databox heavy
type HeavyAccountCopyLogDetails struct {
	// AccountName - READ-ONLY; Destination account name.
	AccountName *string `json:"accountName,omitempty"`
	// CopyLogLink - READ-ONLY; Link for copy logs.
	CopyLogLink *[]string `json:"copyLogLink,omitempty"`
	// CopyLogDetailsType - Possible values include: 'CopyLogDetailsTypeCopyLogDetails', 'CopyLogDetailsTypeDataBox', 'CopyLogDetailsTypeDataBoxDisk', 'CopyLogDetailsTypeDataBoxHeavy'
	CopyLogDetailsType CopyLogDetailsType `json:"copyLogDetailsType,omitempty"`
}

// MarshalJSON is the custom marshaler for HeavyAccountCopyLogDetails.
func (hacld HeavyAccountCopyLogDetails) MarshalJSON() ([]byte, error) {
	hacld.CopyLogDetailsType = CopyLogDetailsTypeDataBoxHeavy
	objectMap := make(map[string]interface{})
	if hacld.CopyLogDetailsType != "" {
		objectMap["copyLogDetailsType"] = hacld.CopyLogDetailsType
	}
	return json.Marshal(objectMap)
}

// AsAccountCopyLogDetails is the BasicCopyLogDetails implementation for HeavyAccountCopyLogDetails.
func (hacld HeavyAccountCopyLogDetails) AsAccountCopyLogDetails() (*AccountCopyLogDetails, bool) {
	return nil, false
}

// AsDiskCopyLogDetails is the BasicCopyLogDetails implementation for HeavyAccountCopyLogDetails.
func (hacld HeavyAccountCopyLogDetails) AsDiskCopyLogDetails() (*DiskCopyLogDetails, bool) {
	return nil, false
}

// AsHeavyAccountCopyLogDetails is the BasicCopyLogDetails implementation for HeavyAccountCopyLogDetails.
func (hacld HeavyAccountCopyLogDetails) AsHeavyAccountCopyLogDetails() (*HeavyAccountCopyLogDetails, bool) {
	return &hacld, true
}

// AsCopyLogDetails is the BasicCopyLogDetails implementation for HeavyAccountCopyLogDetails.
func (hacld HeavyAccountCopyLogDetails) AsCopyLogDetails() (*CopyLogDetails, bool) {
	return nil, false
}

// AsBasicCopyLogDetails is the BasicCopyLogDetails implementation for HeavyAccountCopyLogDetails.
func (hacld HeavyAccountCopyLogDetails) AsBasicCopyLogDetails() (BasicCopyLogDetails, bool) {
	return &hacld, true
}

// HeavyJobDetails databox Heavy Device Job Details
type HeavyJobDetails struct {
	// CopyProgress - READ-ONLY; Copy progress per account.
	CopyProgress *[]CopyProgress `json:"copyProgress,omitempty"`
	// DevicePassword - Set Device password for unlocking Databox Heavy
	DevicePassword *string `json:"devicePassword,omitempty"`
	// ExpectedDataSizeInTerabytes - The expected size of the data, which needs to be transferred in this job, in terabytes.
	ExpectedDataSizeInTerabytes *int32 `json:"expectedDataSizeInTerabytes,omitempty"`
	// JobStages - READ-ONLY; List of stages that run in the job.
	JobStages *[]JobStages `json:"jobStages,omitempty"`
	// ContactDetails - Contact details for notification and shipping.
	ContactDetails *ContactDetails `json:"contactDetails,omitempty"`
	// ShippingAddress - Shipping address of the customer.
	ShippingAddress *ShippingAddress `json:"shippingAddress,omitempty"`
	// DeliveryPackage - READ-ONLY; Delivery package shipping details.
	DeliveryPackage *PackageShippingDetails `json:"deliveryPackage,omitempty"`
	// ReturnPackage - READ-ONLY; Return package shipping details.
	ReturnPackage *PackageShippingDetails `json:"returnPackage,omitempty"`
	// DestinationAccountDetails - Destination account details.
	DestinationAccountDetails *[]BasicDestinationAccountDetails `json:"destinationAccountDetails,omitempty"`
	// ErrorDetails - READ-ONLY; Error details for failure. This is optional.
	ErrorDetails *[]JobErrorDetails `json:"errorDetails,omitempty"`
	// Preferences - Preferences for the order.
	Preferences *Preferences `json:"preferences,omitempty"`
	// CopyLogDetails - READ-ONLY; List of copy log details.
	CopyLogDetails *[]BasicCopyLogDetails `json:"copyLogDetails,omitempty"`
	// ReverseShipmentLabelSasKey - READ-ONLY; Shared access key to download the return shipment label
	ReverseShipmentLabelSasKey *string `json:"reverseShipmentLabelSasKey,omitempty"`
	// ChainOfCustodySasKey - READ-ONLY; Shared access key to download the chain of custody logs
	ChainOfCustodySasKey *string `json:"chainOfCustodySasKey,omitempty"`
	// JobDetailsType - Possible values include: 'JobDetailsTypeJobDetails', 'JobDetailsTypeDataBoxDisk', 'JobDetailsTypeDataBoxHeavy', 'JobDetailsTypeDataBox'
	JobDetailsType JobDetailsTypeEnum `json:"jobDetailsType,omitempty"`
}

// MarshalJSON is the custom marshaler for HeavyJobDetails.
func (hjd HeavyJobDetails) MarshalJSON() ([]byte, error) {
	hjd.JobDetailsType = JobDetailsTypeDataBoxHeavy
	objectMap := make(map[string]interface{})
	if hjd.DevicePassword != nil {
		objectMap["devicePassword"] = hjd.DevicePassword
	}
	if hjd.ExpectedDataSizeInTerabytes != nil {
		objectMap["expectedDataSizeInTerabytes"] = hjd.ExpectedDataSizeInTerabytes
	}
	if hjd.ContactDetails != nil {
		objectMap["contactDetails"] = hjd.ContactDetails
	}
	if hjd.ShippingAddress != nil {
		objectMap["shippingAddress"] = hjd.ShippingAddress
	}
	if hjd.DestinationAccountDetails != nil {
		objectMap["destinationAccountDetails"] = hjd.DestinationAccountDetails
	}
	if hjd.Preferences != nil {
		objectMap["preferences"] = hjd.Preferences
	}
	if hjd.JobDetailsType != "" {
		objectMap["jobDetailsType"] = hjd.JobDetailsType
	}
	return json.Marshal(objectMap)
}

// AsDiskJobDetails is the BasicJobDetails implementation for HeavyJobDetails.
func (hjd HeavyJobDetails) AsDiskJobDetails() (*DiskJobDetails, bool) {
	return nil, false
}

// AsHeavyJobDetails is the BasicJobDetails implementation for HeavyJobDetails.
func (hjd HeavyJobDetails) AsHeavyJobDetails() (*HeavyJobDetails, bool) {
	return &hjd, true
}

// AsJobDetailsType is the BasicJobDetails implementation for HeavyJobDetails.
func (hjd HeavyJobDetails) AsJobDetailsType() (*JobDetailsType, bool) {
	return nil, false
}

// AsJobDetails is the BasicJobDetails implementation for HeavyJobDetails.
func (hjd HeavyJobDetails) AsJobDetails() (*JobDetails, bool) {
	return nil, false
}

// AsBasicJobDetails is the BasicJobDetails implementation for HeavyJobDetails.
func (hjd HeavyJobDetails) AsBasicJobDetails() (BasicJobDetails, bool) {
	return &hjd, true
}

// UnmarshalJSON is the custom unmarshaler for HeavyJobDetails struct.
func (hjd *HeavyJobDetails) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "copyProgress":
			if v != nil {
				var copyProgress []CopyProgress
				err = json.Unmarshal(*v, &copyProgress)
				if err != nil {
					return err
				}
				hjd.CopyProgress = &copyProgress
			}
		case "devicePassword":
			if v != nil {
				var devicePassword string
				err = json.Unmarshal(*v, &devicePassword)
				if err != nil {
					return err
				}
				hjd.DevicePassword = &devicePassword
			}
		case "expectedDataSizeInTerabytes":
			if v != nil {
				var expectedDataSizeInTerabytes int32
				err = json.Unmarshal(*v, &expectedDataSizeInTerabytes)
				if err != nil {
					return err
				}
				hjd.ExpectedDataSizeInTerabytes = &expectedDataSizeInTerabytes
			}
		case "jobStages":
			if v != nil {
				var jobStages []JobStages
				err = json.Unmarshal(*v, &jobStages)
				if err != nil {
					return err
				}
				hjd.JobStages = &jobStages
			}
		case "contactDetails":
			if v != nil {
				var contactDetails ContactDetails
				err = json.Unmarshal(*v, &contactDetails)
				if err != nil {
					return err
				}
				hjd.ContactDetails = &contactDetails
			}
		case "shippingAddress":
			if v != nil {
				var shippingAddress ShippingAddress
				err = json.Unmarshal(*v, &shippingAddress)
				if err != nil {
					return err
				}
				hjd.ShippingAddress = &shippingAddress
			}
		case "deliveryPackage":
			if v != nil {
				var deliveryPackage PackageShippingDetails
				err = json.Unmarshal(*v, &deliveryPackage)
				if err != nil {
					return err
				}
				hjd.DeliveryPackage = &deliveryPackage
			}
		case "returnPackage":
			if v != nil {
				var returnPackage PackageShippingDetails
				err = json.Unmarshal(*v, &returnPackage)
				if err != nil {
					return err
				}
				hjd.ReturnPackage = &returnPackage
			}
		case "destinationAccountDetails":
			if v != nil {
				destinationAccountDetails, err := unmarshalBasicDestinationAccountDetailsArray(*v)
				if err != nil {
					return err
				}
				hjd.DestinationAccountDetails = &destinationAccountDetails
			}
		case "errorDetails":
			if v != nil {
				var errorDetails []JobErrorDetails
				err = json.Unmarshal(*v, &errorDetails)
				if err != nil {
					return err
				}
				hjd.ErrorDetails = &errorDetails
			}
		case "preferences":
			if v != nil {
				var preferences Preferences
				err = json.Unmarshal(*v, &preferences)
				if err != nil {
					return err
				}
				hjd.Preferences = &preferences
			}
		case "copyLogDetails":
			if v != nil {
				copyLogDetails, err := unmarshalBasicCopyLogDetailsArray(*v)
				if err != nil {
					return err
				}
				hjd.CopyLogDetails = &copyLogDetails
			}
		case "reverseShipmentLabelSasKey":
			if v != nil {
				var reverseShipmentLabelSasKey string
				err = json.Unmarshal(*v, &reverseShipmentLabelSasKey)
				if err != nil {
					return err
				}
				hjd.ReverseShipmentLabelSasKey = &reverseShipmentLabelSasKey
			}
		case "chainOfCustodySasKey":
			if v != nil {
				var chainOfCustodySasKey string
				err = json.Unmarshal(*v, &chainOfCustodySasKey)
				if err != nil {
					return err
				}
				hjd.ChainOfCustodySasKey = &chainOfCustodySasKey
			}
		case "jobDetailsType":
			if v != nil {
				var jobDetailsType JobDetailsTypeEnum
				err = json.Unmarshal(*v, &jobDetailsType)
				if err != nil {
					return err
				}
				hjd.JobDetailsType = jobDetailsType
			}
		}
	}

	return nil
}

// HeavyJobSecrets the secrets related to a databox heavy job.
type HeavyJobSecrets struct {
	// CabinetPodSecrets - READ-ONLY; Contains the list of secret objects for a databox heavy job.
	CabinetPodSecrets *[]HeavySecret `json:"cabinetPodSecrets,omitempty"`
	// DcAccessSecurityCode - Dc Access Security Code for Customer Managed Shipping
	DcAccessSecurityCode *DcAccessSecurityCode `json:"dcAccessSecurityCode,omitempty"`
	// JobSecretsType - Possible values include: 'JobSecretsTypeJobSecrets', 'JobSecretsTypeDataBoxDisk', 'JobSecretsTypeDataBoxHeavy', 'JobSecretsTypeDataBox'
	JobSecretsType JobSecretsTypeEnum `json:"jobSecretsType,omitempty"`
}

// MarshalJSON is the custom marshaler for HeavyJobSecrets.
func (hjs HeavyJobSecrets) MarshalJSON() ([]byte, error) {
	hjs.JobSecretsType = JobSecretsTypeDataBoxHeavy
	objectMap := make(map[string]interface{})
	if hjs.DcAccessSecurityCode != nil {
		objectMap["dcAccessSecurityCode"] = hjs.DcAccessSecurityCode
	}
	if hjs.JobSecretsType != "" {
		objectMap["jobSecretsType"] = hjs.JobSecretsType
	}
	return json.Marshal(objectMap)
}

// AsDiskJobSecrets is the BasicJobSecrets implementation for HeavyJobSecrets.
func (hjs HeavyJobSecrets) AsDiskJobSecrets() (*DiskJobSecrets, bool) {
	return nil, false
}

// AsHeavyJobSecrets is the BasicJobSecrets implementation for HeavyJobSecrets.
func (hjs HeavyJobSecrets) AsHeavyJobSecrets() (*HeavyJobSecrets, bool) {
	return &hjs, true
}

// AsJobSecretsType is the BasicJobSecrets implementation for HeavyJobSecrets.
func (hjs HeavyJobSecrets) AsJobSecretsType() (*JobSecretsType, bool) {
	return nil, false
}

// AsJobSecrets is the BasicJobSecrets implementation for HeavyJobSecrets.
func (hjs HeavyJobSecrets) AsJobSecrets() (*JobSecrets, bool) {
	return nil, false
}

// AsBasicJobSecrets is the BasicJobSecrets implementation for HeavyJobSecrets.
func (hjs HeavyJobSecrets) AsBasicJobSecrets() (BasicJobSecrets, bool) {
	return &hjs, true
}

// HeavyScheduleAvailabilityRequest request body to get the availability for scheduling heavy orders.
type HeavyScheduleAvailabilityRequest struct {
	// StorageLocation - Location for data transfer.
	// For locations check: https://management.azure.com/subscriptions/SUBSCRIPTIONID/locations?api-version=2018-01-01
	StorageLocation *string `json:"storageLocation,omitempty"`
	// SkuName - Possible values include: 'SkuNameScheduleAvailabilityRequest', 'SkuNameDataBox', 'SkuNameDataBoxDisk', 'SkuNameDataBoxHeavy'
	SkuName SkuNameBasicScheduleAvailabilityRequest `json:"skuName,omitempty"`
}

// MarshalJSON is the custom marshaler for HeavyScheduleAvailabilityRequest.
func (hsar HeavyScheduleAvailabilityRequest) MarshalJSON() ([]byte, error) {
	hsar.SkuName = SkuNameDataBoxHeavy
	objectMap := make(map[string]interface{})
	if hsar.StorageLocation != nil {
		objectMap["storageLocation"] = hsar.StorageLocation
	}
	if hsar.SkuName != "" {
		objectMap["skuName"] = hsar.SkuName
	}
	return json.Marshal(objectMap)
}

// AsScheduleAvailabilityRequestType is the BasicScheduleAvailabilityRequest implementation for HeavyScheduleAvailabilityRequest.
func (hsar HeavyScheduleAvailabilityRequest) AsScheduleAvailabilityRequestType() (*ScheduleAvailabilityRequestType, bool) {
	return nil, false
}

// AsDiskScheduleAvailabilityRequest is the BasicScheduleAvailabilityRequest implementation for HeavyScheduleAvailabilityRequest.
func (hsar HeavyScheduleAvailabilityRequest) AsDiskScheduleAvailabilityRequest() (*DiskScheduleAvailabilityRequest, bool) {
	return nil, false
}

// AsHeavyScheduleAvailabilityRequest is the BasicScheduleAvailabilityRequest implementation for HeavyScheduleAvailabilityRequest.
func (hsar HeavyScheduleAvailabilityRequest) AsHeavyScheduleAvailabilityRequest() (*HeavyScheduleAvailabilityRequest, bool) {
	return &hsar, true
}

// AsScheduleAvailabilityRequest is the BasicScheduleAvailabilityRequest implementation for HeavyScheduleAvailabilityRequest.
func (hsar HeavyScheduleAvailabilityRequest) AsScheduleAvailabilityRequest() (*ScheduleAvailabilityRequest, bool) {
	return nil, false
}

// AsBasicScheduleAvailabilityRequest is the BasicScheduleAvailabilityRequest implementation for HeavyScheduleAvailabilityRequest.
func (hsar HeavyScheduleAvailabilityRequest) AsBasicScheduleAvailabilityRequest() (BasicScheduleAvailabilityRequest, bool) {
	return &hsar, true
}

// HeavySecret the secrets related to a databox heavy.
type HeavySecret struct {
	// DeviceSerialNumber - READ-ONLY; Serial number of the assigned device.
	DeviceSerialNumber *string `json:"deviceSerialNumber,omitempty"`
	// DevicePassword - READ-ONLY; Password for out of the box experience on device.
	DevicePassword *string `json:"devicePassword,omitempty"`
	// NetworkConfigurations - READ-ONLY; Network configuration of the appliance.
	NetworkConfigurations *[]ApplianceNetworkConfiguration `json:"networkConfigurations,omitempty"`
	// EncodedValidationCertPubKey - READ-ONLY; The base 64 encoded public key to authenticate with the device
	EncodedValidationCertPubKey *string `json:"encodedValidationCertPubKey,omitempty"`
	// AccountCredentialDetails - READ-ONLY; Per account level access credentials.
	AccountCredentialDetails *[]AccountCredentialDetails `json:"accountCredentialDetails,omitempty"`
}

// JobDeliveryInfo additional delivery info.
type JobDeliveryInfo struct {
	// ScheduledDateTime - Scheduled date time.
	ScheduledDateTime *date.Time `json:"scheduledDateTime,omitempty"`
}

// BasicJobDetails job details.
type BasicJobDetails interface {
	AsDiskJobDetails() (*DiskJobDetails, bool)
	AsHeavyJobDetails() (*HeavyJobDetails, bool)
	AsJobDetailsType() (*JobDetailsType, bool)
	AsJobDetails() (*JobDetails, bool)
}

// JobDetails job details.
type JobDetails struct {
	// ExpectedDataSizeInTerabytes - The expected size of the data, which needs to be transferred in this job, in terabytes.
	ExpectedDataSizeInTerabytes *int32 `json:"expectedDataSizeInTerabytes,omitempty"`
	// JobStages - READ-ONLY; List of stages that run in the job.
	JobStages *[]JobStages `json:"jobStages,omitempty"`
	// ContactDetails - Contact details for notification and shipping.
	ContactDetails *ContactDetails `json:"contactDetails,omitempty"`
	// ShippingAddress - Shipping address of the customer.
	ShippingAddress *ShippingAddress `json:"shippingAddress,omitempty"`
	// DeliveryPackage - READ-ONLY; Delivery package shipping details.
	DeliveryPackage *PackageShippingDetails `json:"deliveryPackage,omitempty"`
	// ReturnPackage - READ-ONLY; Return package shipping details.
	ReturnPackage *PackageShippingDetails `json:"returnPackage,omitempty"`
	// DestinationAccountDetails - Destination account details.
	DestinationAccountDetails *[]BasicDestinationAccountDetails `json:"destinationAccountDetails,omitempty"`
	// ErrorDetails - READ-ONLY; Error details for failure. This is optional.
	ErrorDetails *[]JobErrorDetails `json:"errorDetails,omitempty"`
	// Preferences - Preferences for the order.
	Preferences *Preferences `json:"preferences,omitempty"`
	// CopyLogDetails - READ-ONLY; List of copy log details.
	CopyLogDetails *[]BasicCopyLogDetails `json:"copyLogDetails,omitempty"`
	// ReverseShipmentLabelSasKey - READ-ONLY; Shared access key to download the return shipment label
	ReverseShipmentLabelSasKey *string `json:"reverseShipmentLabelSasKey,omitempty"`
	// ChainOfCustodySasKey - READ-ONLY; Shared access key to download the chain of custody logs
	ChainOfCustodySasKey *string `json:"chainOfCustodySasKey,omitempty"`
	// JobDetailsType - Possible values include: 'JobDetailsTypeJobDetails', 'JobDetailsTypeDataBoxDisk', 'JobDetailsTypeDataBoxHeavy', 'JobDetailsTypeDataBox'
	JobDetailsType JobDetailsTypeEnum `json:"jobDetailsType,omitempty"`
}

func unmarshalBasicJobDetails(body []byte) (BasicJobDetails, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["jobDetailsType"] {
	case string(JobDetailsTypeDataBoxDisk):
		var djd DiskJobDetails
		err := json.Unmarshal(body, &djd)
		return djd, err
	case string(JobDetailsTypeDataBoxHeavy):
		var hjd HeavyJobDetails
		err := json.Unmarshal(body, &hjd)
		return hjd, err
	case string(JobDetailsTypeDataBox):
		var jdt JobDetailsType
		err := json.Unmarshal(body, &jdt)
		return jdt, err
	default:
		var jd JobDetails
		err := json.Unmarshal(body, &jd)
		return jd, err
	}
}
func unmarshalBasicJobDetailsArray(body []byte) ([]BasicJobDetails, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	jdArray := make([]BasicJobDetails, len(rawMessages))

	for index, rawMessage := range rawMessages {
		jd, err := unmarshalBasicJobDetails(*rawMessage)
		if err != nil {
			return nil, err
		}
		jdArray[index] = jd
	}
	return jdArray, nil
}

// MarshalJSON is the custom marshaler for JobDetails.
func (jd JobDetails) MarshalJSON() ([]byte, error) {
	jd.JobDetailsType = JobDetailsTypeJobDetails
	objectMap := make(map[string]interface{})
	if jd.ExpectedDataSizeInTerabytes != nil {
		objectMap["expectedDataSizeInTerabytes"] = jd.ExpectedDataSizeInTerabytes
	}
	if jd.ContactDetails != nil {
		objectMap["contactDetails"] = jd.ContactDetails
	}
	if jd.ShippingAddress != nil {
		objectMap["shippingAddress"] = jd.ShippingAddress
	}
	if jd.DestinationAccountDetails != nil {
		objectMap["destinationAccountDetails"] = jd.DestinationAccountDetails
	}
	if jd.Preferences != nil {
		objectMap["preferences"] = jd.Preferences
	}
	if jd.JobDetailsType != "" {
		objectMap["jobDetailsType"] = jd.JobDetailsType
	}
	return json.Marshal(objectMap)
}

// AsDiskJobDetails is the BasicJobDetails implementation for JobDetails.
func (jd JobDetails) AsDiskJobDetails() (*DiskJobDetails, bool) {
	return nil, false
}

// AsHeavyJobDetails is the BasicJobDetails implementation for JobDetails.
func (jd JobDetails) AsHeavyJobDetails() (*HeavyJobDetails, bool) {
	return nil, false
}

// AsJobDetailsType is the BasicJobDetails implementation for JobDetails.
func (jd JobDetails) AsJobDetailsType() (*JobDetailsType, bool) {
	return nil, false
}

// AsJobDetails is the BasicJobDetails implementation for JobDetails.
func (jd JobDetails) AsJobDetails() (*JobDetails, bool) {
	return &jd, true
}

// AsBasicJobDetails is the BasicJobDetails implementation for JobDetails.
func (jd JobDetails) AsBasicJobDetails() (BasicJobDetails, bool) {
	return &jd, true
}

// UnmarshalJSON is the custom unmarshaler for JobDetails struct.
func (jd *JobDetails) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "expectedDataSizeInTerabytes":
			if v != nil {
				var expectedDataSizeInTerabytes int32
				err = json.Unmarshal(*v, &expectedDataSizeInTerabytes)
				if err != nil {
					return err
				}
				jd.ExpectedDataSizeInTerabytes = &expectedDataSizeInTerabytes
			}
		case "jobStages":
			if v != nil {
				var jobStages []JobStages
				err = json.Unmarshal(*v, &jobStages)
				if err != nil {
					return err
				}
				jd.JobStages = &jobStages
			}
		case "contactDetails":
			if v != nil {
				var contactDetails ContactDetails
				err = json.Unmarshal(*v, &contactDetails)
				if err != nil {
					return err
				}
				jd.ContactDetails = &contactDetails
			}
		case "shippingAddress":
			if v != nil {
				var shippingAddress ShippingAddress
				err = json.Unmarshal(*v, &shippingAddress)
				if err != nil {
					return err
				}
				jd.ShippingAddress = &shippingAddress
			}
		case "deliveryPackage":
			if v != nil {
				var deliveryPackage PackageShippingDetails
				err = json.Unmarshal(*v, &deliveryPackage)
				if err != nil {
					return err
				}
				jd.DeliveryPackage = &deliveryPackage
			}
		case "returnPackage":
			if v != nil {
				var returnPackage PackageShippingDetails
				err = json.Unmarshal(*v, &returnPackage)
				if err != nil {
					return err
				}
				jd.ReturnPackage = &returnPackage
			}
		case "destinationAccountDetails":
			if v != nil {
				destinationAccountDetails, err := unmarshalBasicDestinationAccountDetailsArray(*v)
				if err != nil {
					return err
				}
				jd.DestinationAccountDetails = &destinationAccountDetails
			}
		case "errorDetails":
			if v != nil {
				var errorDetails []JobErrorDetails
				err = json.Unmarshal(*v, &errorDetails)
				if err != nil {
					return err
				}
				jd.ErrorDetails = &errorDetails
			}
		case "preferences":
			if v != nil {
				var preferences Preferences
				err = json.Unmarshal(*v, &preferences)
				if err != nil {
					return err
				}
				jd.Preferences = &preferences
			}
		case "copyLogDetails":
			if v != nil {
				copyLogDetails, err := unmarshalBasicCopyLogDetailsArray(*v)
				if err != nil {
					return err
				}
				jd.CopyLogDetails = &copyLogDetails
			}
		case "reverseShipmentLabelSasKey":
			if v != nil {
				var reverseShipmentLabelSasKey string
				err = json.Unmarshal(*v, &reverseShipmentLabelSasKey)
				if err != nil {
					return err
				}
				jd.ReverseShipmentLabelSasKey = &reverseShipmentLabelSasKey
			}
		case "chainOfCustodySasKey":
			if v != nil {
				var chainOfCustodySasKey string
				err = json.Unmarshal(*v, &chainOfCustodySasKey)
				if err != nil {
					return err
				}
				jd.ChainOfCustodySasKey = &chainOfCustodySasKey
			}
		case "jobDetailsType":
			if v != nil {
				var jobDetailsType JobDetailsTypeEnum
				err = json.Unmarshal(*v, &jobDetailsType)
				if err != nil {
					return err
				}
				jd.JobDetailsType = jobDetailsType
			}
		}
	}

	return nil
}

// JobDetailsType databox Job Details
type JobDetailsType struct {
	// CopyProgress - READ-ONLY; Copy progress per storage account.
	CopyProgress *[]CopyProgress `json:"copyProgress,omitempty"`
	// DevicePassword - Set Device password for unlocking Databox
	DevicePassword *string `json:"devicePassword,omitempty"`
	// ExpectedDataSizeInTerabytes - The expected size of the data, which needs to be transferred in this job, in terabytes.
	ExpectedDataSizeInTerabytes *int32 `json:"expectedDataSizeInTerabytes,omitempty"`
	// JobStages - READ-ONLY; List of stages that run in the job.
	JobStages *[]JobStages `json:"jobStages,omitempty"`
	// ContactDetails - Contact details for notification and shipping.
	ContactDetails *ContactDetails `json:"contactDetails,omitempty"`
	// ShippingAddress - Shipping address of the customer.
	ShippingAddress *ShippingAddress `json:"shippingAddress,omitempty"`
	// DeliveryPackage - READ-ONLY; Delivery package shipping details.
	DeliveryPackage *PackageShippingDetails `json:"deliveryPackage,omitempty"`
	// ReturnPackage - READ-ONLY; Return package shipping details.
	ReturnPackage *PackageShippingDetails `json:"returnPackage,omitempty"`
	// DestinationAccountDetails - Destination account details.
	DestinationAccountDetails *[]BasicDestinationAccountDetails `json:"destinationAccountDetails,omitempty"`
	// ErrorDetails - READ-ONLY; Error details for failure. This is optional.
	ErrorDetails *[]JobErrorDetails `json:"errorDetails,omitempty"`
	// Preferences - Preferences for the order.
	Preferences *Preferences `json:"preferences,omitempty"`
	// CopyLogDetails - READ-ONLY; List of copy log details.
	CopyLogDetails *[]BasicCopyLogDetails `json:"copyLogDetails,omitempty"`
	// ReverseShipmentLabelSasKey - READ-ONLY; Shared access key to download the return shipment label
	ReverseShipmentLabelSasKey *string `json:"reverseShipmentLabelSasKey,omitempty"`
	// ChainOfCustodySasKey - READ-ONLY; Shared access key to download the chain of custody logs
	ChainOfCustodySasKey *string `json:"chainOfCustodySasKey,omitempty"`
	// JobDetailsType - Possible values include: 'JobDetailsTypeJobDetails', 'JobDetailsTypeDataBoxDisk', 'JobDetailsTypeDataBoxHeavy', 'JobDetailsTypeDataBox'
	JobDetailsType JobDetailsTypeEnum `json:"jobDetailsType,omitempty"`
}

// MarshalJSON is the custom marshaler for JobDetailsType.
func (jdt JobDetailsType) MarshalJSON() ([]byte, error) {
	jdt.JobDetailsType = JobDetailsTypeDataBox
	objectMap := make(map[string]interface{})
	if jdt.DevicePassword != nil {
		objectMap["devicePassword"] = jdt.DevicePassword
	}
	if jdt.ExpectedDataSizeInTerabytes != nil {
		objectMap["expectedDataSizeInTerabytes"] = jdt.ExpectedDataSizeInTerabytes
	}
	if jdt.ContactDetails != nil {
		objectMap["contactDetails"] = jdt.ContactDetails
	}
	if jdt.ShippingAddress != nil {
		objectMap["shippingAddress"] = jdt.ShippingAddress
	}
	if jdt.DestinationAccountDetails != nil {
		objectMap["destinationAccountDetails"] = jdt.DestinationAccountDetails
	}
	if jdt.Preferences != nil {
		objectMap["preferences"] = jdt.Preferences
	}
	if jdt.JobDetailsType != "" {
		objectMap["jobDetailsType"] = jdt.JobDetailsType
	}
	return json.Marshal(objectMap)
}

// AsDiskJobDetails is the BasicJobDetails implementation for JobDetailsType.
func (jdt JobDetailsType) AsDiskJobDetails() (*DiskJobDetails, bool) {
	return nil, false
}

// AsHeavyJobDetails is the BasicJobDetails implementation for JobDetailsType.
func (jdt JobDetailsType) AsHeavyJobDetails() (*HeavyJobDetails, bool) {
	return nil, false
}

// AsJobDetailsType is the BasicJobDetails implementation for JobDetailsType.
func (jdt JobDetailsType) AsJobDetailsType() (*JobDetailsType, bool) {
	return &jdt, true
}

// AsJobDetails is the BasicJobDetails implementation for JobDetailsType.
func (jdt JobDetailsType) AsJobDetails() (*JobDetails, bool) {
	return nil, false
}

// AsBasicJobDetails is the BasicJobDetails implementation for JobDetailsType.
func (jdt JobDetailsType) AsBasicJobDetails() (BasicJobDetails, bool) {
	return &jdt, true
}

// UnmarshalJSON is the custom unmarshaler for JobDetailsType struct.
func (jdt *JobDetailsType) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "copyProgress":
			if v != nil {
				var copyProgress []CopyProgress
				err = json.Unmarshal(*v, &copyProgress)
				if err != nil {
					return err
				}
				jdt.CopyProgress = &copyProgress
			}
		case "devicePassword":
			if v != nil {
				var devicePassword string
				err = json.Unmarshal(*v, &devicePassword)
				if err != nil {
					return err
				}
				jdt.DevicePassword = &devicePassword
			}
		case "expectedDataSizeInTerabytes":
			if v != nil {
				var expectedDataSizeInTerabytes int32
				err = json.Unmarshal(*v, &expectedDataSizeInTerabytes)
				if err != nil {
					return err
				}
				jdt.ExpectedDataSizeInTerabytes = &expectedDataSizeInTerabytes
			}
		case "jobStages":
			if v != nil {
				var jobStages []JobStages
				err = json.Unmarshal(*v, &jobStages)
				if err != nil {
					return err
				}
				jdt.JobStages = &jobStages
			}
		case "contactDetails":
			if v != nil {
				var contactDetails ContactDetails
				err = json.Unmarshal(*v, &contactDetails)
				if err != nil {
					return err
				}
				jdt.ContactDetails = &contactDetails
			}
		case "shippingAddress":
			if v != nil {
				var shippingAddress ShippingAddress
				err = json.Unmarshal(*v, &shippingAddress)
				if err != nil {
					return err
				}
				jdt.ShippingAddress = &shippingAddress
			}
		case "deliveryPackage":
			if v != nil {
				var deliveryPackage PackageShippingDetails
				err = json.Unmarshal(*v, &deliveryPackage)
				if err != nil {
					return err
				}
				jdt.DeliveryPackage = &deliveryPackage
			}
		case "returnPackage":
			if v != nil {
				var returnPackage PackageShippingDetails
				err = json.Unmarshal(*v, &returnPackage)
				if err != nil {
					return err
				}
				jdt.ReturnPackage = &returnPackage
			}
		case "destinationAccountDetails":
			if v != nil {
				destinationAccountDetails, err := unmarshalBasicDestinationAccountDetailsArray(*v)
				if err != nil {
					return err
				}
				jdt.DestinationAccountDetails = &destinationAccountDetails
			}
		case "errorDetails":
			if v != nil {
				var errorDetails []JobErrorDetails
				err = json.Unmarshal(*v, &errorDetails)
				if err != nil {
					return err
				}
				jdt.ErrorDetails = &errorDetails
			}
		case "preferences":
			if v != nil {
				var preferences Preferences
				err = json.Unmarshal(*v, &preferences)
				if err != nil {
					return err
				}
				jdt.Preferences = &preferences
			}
		case "copyLogDetails":
			if v != nil {
				copyLogDetails, err := unmarshalBasicCopyLogDetailsArray(*v)
				if err != nil {
					return err
				}
				jdt.CopyLogDetails = &copyLogDetails
			}
		case "reverseShipmentLabelSasKey":
			if v != nil {
				var reverseShipmentLabelSasKey string
				err = json.Unmarshal(*v, &reverseShipmentLabelSasKey)
				if err != nil {
					return err
				}
				jdt.ReverseShipmentLabelSasKey = &reverseShipmentLabelSasKey
			}
		case "chainOfCustodySasKey":
			if v != nil {
				var chainOfCustodySasKey string
				err = json.Unmarshal(*v, &chainOfCustodySasKey)
				if err != nil {
					return err
				}
				jdt.ChainOfCustodySasKey = &chainOfCustodySasKey
			}
		case "jobDetailsType":
			if v != nil {
				var jobDetailsType JobDetailsTypeEnum
				err = json.Unmarshal(*v, &jobDetailsType)
				if err != nil {
					return err
				}
				jdt.JobDetailsType = jobDetailsType
			}
		}
	}

	return nil
}

// JobErrorDetails job Error Details for providing the information and recommended action.
type JobErrorDetails struct {
	// ErrorMessage - READ-ONLY; Message for the error.
	ErrorMessage *string `json:"errorMessage,omitempty"`
	// ErrorCode - READ-ONLY; Code for the error.
	ErrorCode *int32 `json:"errorCode,omitempty"`
	// RecommendedAction - READ-ONLY; Recommended action for the error.
	RecommendedAction *string `json:"recommendedAction,omitempty"`
	// ExceptionMessage - READ-ONLY; Contains the non localized exception message
	ExceptionMessage *string `json:"exceptionMessage,omitempty"`
}

// JobProperties job Properties
type JobProperties struct {
	// IsCancellable - READ-ONLY; Describes whether the job is cancellable or not.
	IsCancellable *bool `json:"isCancellable,omitempty"`
	// IsDeletable - READ-ONLY; Describes whether the job is deletable or not.
	IsDeletable *bool `json:"isDeletable,omitempty"`
	// IsShippingAddressEditable - READ-ONLY; Describes whether the shipping address is editable or not.
	IsShippingAddressEditable *bool `json:"isShippingAddressEditable,omitempty"`
	// Status - READ-ONLY; Name of the stage which is in progress. Possible values include: 'StageNameDeviceOrdered', 'StageNameDevicePrepared', 'StageNameDispatched', 'StageNameDelivered', 'StageNamePickedUp', 'StageNameAtAzureDC', 'StageNameDataCopy', 'StageNameCompleted', 'StageNameCompletedWithErrors', 'StageNameCancelled', 'StageNameFailedIssueReportedAtCustomer', 'StageNameFailedIssueDetectedAtAzureDC', 'StageNameAborted', 'StageNameCompletedWithWarnings', 'StageNameReadyToDispatchFromAzureDC', 'StageNameReadyToReceiveAtAzureDC'
	Status StageName `json:"status,omitempty"`
	// StartTime - READ-ONLY; Time at which the job was started in UTC ISO 8601 format.
	StartTime *date.Time `json:"startTime,omitempty"`
	// Error - READ-ONLY; Top level error for the job.
	Error *Error `json:"error,omitempty"`
	// Details - Details of a job run. This field will only be sent for expand details filter.
	Details BasicJobDetails `json:"details,omitempty"`
	// CancellationReason - READ-ONLY; Reason for cancellation.
	CancellationReason *string `json:"cancellationReason,omitempty"`
	// DeliveryType - Delivery type of Job. Possible values include: 'NonScheduled', 'Scheduled'
	DeliveryType JobDeliveryType `json:"deliveryType,omitempty"`
	// DeliveryInfo - Delivery Info of Job.
	DeliveryInfo *JobDeliveryInfo `json:"deliveryInfo,omitempty"`
	// IsCancellableWithoutFee - READ-ONLY; Flag to indicate cancellation of scheduled job.
	IsCancellableWithoutFee *bool `json:"isCancellableWithoutFee,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for JobProperties struct.
func (jp *JobProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "isCancellable":
			if v != nil {
				var isCancellable bool
				err = json.Unmarshal(*v, &isCancellable)
				if err != nil {
					return err
				}
				jp.IsCancellable = &isCancellable
			}
		case "isDeletable":
			if v != nil {
				var isDeletable bool
				err = json.Unmarshal(*v, &isDeletable)
				if err != nil {
					return err
				}
				jp.IsDeletable = &isDeletable
			}
		case "isShippingAddressEditable":
			if v != nil {
				var isShippingAddressEditable bool
				err = json.Unmarshal(*v, &isShippingAddressEditable)
				if err != nil {
					return err
				}
				jp.IsShippingAddressEditable = &isShippingAddressEditable
			}
		case "status":
			if v != nil {
				var status StageName
				err = json.Unmarshal(*v, &status)
				if err != nil {
					return err
				}
				jp.Status = status
			}
		case "startTime":
			if v != nil {
				var startTime date.Time
				err = json.Unmarshal(*v, &startTime)
				if err != nil {
					return err
				}
				jp.StartTime = &startTime
			}
		case "error":
			if v != nil {
				var errorVar Error
				err = json.Unmarshal(*v, &errorVar)
				if err != nil {
					return err
				}
				jp.Error = &errorVar
			}
		case "details":
			if v != nil {
				details, err := unmarshalBasicJobDetails(*v)
				if err != nil {
					return err
				}
				jp.Details = details
			}
		case "cancellationReason":
			if v != nil {
				var cancellationReason string
				err = json.Unmarshal(*v, &cancellationReason)
				if err != nil {
					return err
				}
				jp.CancellationReason = &cancellationReason
			}
		case "deliveryType":
			if v != nil {
				var deliveryType JobDeliveryType
				err = json.Unmarshal(*v, &deliveryType)
				if err != nil {
					return err
				}
				jp.DeliveryType = deliveryType
			}
		case "deliveryInfo":
			if v != nil {
				var deliveryInfo JobDeliveryInfo
				err = json.Unmarshal(*v, &deliveryInfo)
				if err != nil {
					return err
				}
				jp.DeliveryInfo = &deliveryInfo
			}
		case "isCancellableWithoutFee":
			if v != nil {
				var isCancellableWithoutFee bool
				err = json.Unmarshal(*v, &isCancellableWithoutFee)
				if err != nil {
					return err
				}
				jp.IsCancellableWithoutFee = &isCancellableWithoutFee
			}
		}
	}

	return nil
}

// JobResource job Resource.
type JobResource struct {
	autorest.Response `json:"-"`
	// JobProperties - Properties of a job.
	*JobProperties `json:"properties,omitempty"`
	// Name - READ-ONLY; Name of the object.
	Name *string `json:"name,omitempty"`
	// ID - READ-ONLY; Id of the object.
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; Type of the object.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource. This will be one of the supported and registered Azure Regions (e.g. West US, East US, Southeast Asia, etc.). The region of a resource cannot be changed once it is created, but if an identical region is specified on update the request will succeed.
	Location *string `json:"location,omitempty"`
	// Tags - The list of key value pairs that describe the resource. These tags can be used in viewing and grouping this resource (across resource groups).
	Tags map[string]*string `json:"tags"`
	// Sku - The sku type.
	Sku *Sku `json:"sku,omitempty"`
}

// MarshalJSON is the custom marshaler for JobResource.
func (jr JobResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if jr.JobProperties != nil {
		objectMap["properties"] = jr.JobProperties
	}
	if jr.Location != nil {
		objectMap["location"] = jr.Location
	}
	if jr.Tags != nil {
		objectMap["tags"] = jr.Tags
	}
	if jr.Sku != nil {
		objectMap["sku"] = jr.Sku
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for JobResource struct.
func (jr *JobResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var jobProperties JobProperties
				err = json.Unmarshal(*v, &jobProperties)
				if err != nil {
					return err
				}
				jr.JobProperties = &jobProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				jr.Name = &name
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				jr.ID = &ID
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				jr.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				jr.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				jr.Tags = tags
			}
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				jr.Sku = &sku
			}
		}
	}

	return nil
}

// JobResourceList job Resource Collection
type JobResourceList struct {
	autorest.Response `json:"-"`
	// Value - List of job resources.
	Value *[]JobResource `json:"value,omitempty"`
	// NextLink - Link for the next set of job resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// JobResourceListIterator provides access to a complete listing of JobResource values.
type JobResourceListIterator struct {
	i    int
	page JobResourceListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *JobResourceListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobResourceListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *JobResourceListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter JobResourceListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter JobResourceListIterator) Response() JobResourceList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter JobResourceListIterator) Value() JobResource {
	if !iter.page.NotDone() {
		return JobResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the JobResourceListIterator type.
func NewJobResourceListIterator(page JobResourceListPage) JobResourceListIterator {
	return JobResourceListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (jrl JobResourceList) IsEmpty() bool {
	return jrl.Value == nil || len(*jrl.Value) == 0
}

// jobResourceListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (jrl JobResourceList) jobResourceListPreparer(ctx context.Context) (*http.Request, error) {
	if jrl.NextLink == nil || len(to.String(jrl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(jrl.NextLink)))
}

// JobResourceListPage contains a page of JobResource values.
type JobResourceListPage struct {
	fn  func(context.Context, JobResourceList) (JobResourceList, error)
	jrl JobResourceList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *JobResourceListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobResourceListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.jrl)
	if err != nil {
		return err
	}
	page.jrl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *JobResourceListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page JobResourceListPage) NotDone() bool {
	return !page.jrl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page JobResourceListPage) Response() JobResourceList {
	return page.jrl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page JobResourceListPage) Values() []JobResource {
	if page.jrl.IsEmpty() {
		return nil
	}
	return *page.jrl.Value
}

// Creates a new instance of the JobResourceListPage type.
func NewJobResourceListPage(getNextPage func(context.Context, JobResourceList) (JobResourceList, error)) JobResourceListPage {
	return JobResourceListPage{fn: getNextPage}
}

// JobResourceUpdateParameter the JobResourceUpdateParameter.
type JobResourceUpdateParameter struct {
	// UpdateJobProperties - Properties of a job to be updated.
	*UpdateJobProperties `json:"properties,omitempty"`
	// Tags - The list of key value pairs that describe the resource. These tags can be used in viewing and grouping this resource (across resource groups).
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for JobResourceUpdateParameter.
func (jrup JobResourceUpdateParameter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if jrup.UpdateJobProperties != nil {
		objectMap["properties"] = jrup.UpdateJobProperties
	}
	if jrup.Tags != nil {
		objectMap["tags"] = jrup.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for JobResourceUpdateParameter struct.
func (jrup *JobResourceUpdateParameter) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var updateJobProperties UpdateJobProperties
				err = json.Unmarshal(*v, &updateJobProperties)
				if err != nil {
					return err
				}
				jrup.UpdateJobProperties = &updateJobProperties
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				jrup.Tags = tags
			}
		}
	}

	return nil
}

// JobsCreateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type JobsCreateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *JobsCreateFuture) Result(client JobsClient) (jr JobResource, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "databox.JobsCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("databox.JobsCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if jr.Response.Response, err = future.GetResult(sender); err == nil && jr.Response.Response.StatusCode != http.StatusNoContent {
		jr, err = client.CreateResponder(jr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "databox.JobsCreateFuture", "Result", jr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// JobsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type JobsDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *JobsDeleteFuture) Result(client JobsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "databox.JobsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("databox.JobsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// BasicJobSecrets the base class for the secrets
type BasicJobSecrets interface {
	AsDiskJobSecrets() (*DiskJobSecrets, bool)
	AsHeavyJobSecrets() (*HeavyJobSecrets, bool)
	AsJobSecretsType() (*JobSecretsType, bool)
	AsJobSecrets() (*JobSecrets, bool)
}

// JobSecrets the base class for the secrets
type JobSecrets struct {
	// DcAccessSecurityCode - Dc Access Security Code for Customer Managed Shipping
	DcAccessSecurityCode *DcAccessSecurityCode `json:"dcAccessSecurityCode,omitempty"`
	// JobSecretsType - Possible values include: 'JobSecretsTypeJobSecrets', 'JobSecretsTypeDataBoxDisk', 'JobSecretsTypeDataBoxHeavy', 'JobSecretsTypeDataBox'
	JobSecretsType JobSecretsTypeEnum `json:"jobSecretsType,omitempty"`
}

func unmarshalBasicJobSecrets(body []byte) (BasicJobSecrets, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["jobSecretsType"] {
	case string(JobSecretsTypeDataBoxDisk):
		var djs DiskJobSecrets
		err := json.Unmarshal(body, &djs)
		return djs, err
	case string(JobSecretsTypeDataBoxHeavy):
		var hjs HeavyJobSecrets
		err := json.Unmarshal(body, &hjs)
		return hjs, err
	case string(JobSecretsTypeDataBox):
		var jst JobSecretsType
		err := json.Unmarshal(body, &jst)
		return jst, err
	default:
		var js JobSecrets
		err := json.Unmarshal(body, &js)
		return js, err
	}
}
func unmarshalBasicJobSecretsArray(body []byte) ([]BasicJobSecrets, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	jsArray := make([]BasicJobSecrets, len(rawMessages))

	for index, rawMessage := range rawMessages {
		js, err := unmarshalBasicJobSecrets(*rawMessage)
		if err != nil {
			return nil, err
		}
		jsArray[index] = js
	}
	return jsArray, nil
}

// MarshalJSON is the custom marshaler for JobSecrets.
func (js JobSecrets) MarshalJSON() ([]byte, error) {
	js.JobSecretsType = JobSecretsTypeJobSecrets
	objectMap := make(map[string]interface{})
	if js.DcAccessSecurityCode != nil {
		objectMap["dcAccessSecurityCode"] = js.DcAccessSecurityCode
	}
	if js.JobSecretsType != "" {
		objectMap["jobSecretsType"] = js.JobSecretsType
	}
	return json.Marshal(objectMap)
}

// AsDiskJobSecrets is the BasicJobSecrets implementation for JobSecrets.
func (js JobSecrets) AsDiskJobSecrets() (*DiskJobSecrets, bool) {
	return nil, false
}

// AsHeavyJobSecrets is the BasicJobSecrets implementation for JobSecrets.
func (js JobSecrets) AsHeavyJobSecrets() (*HeavyJobSecrets, bool) {
	return nil, false
}

// AsJobSecretsType is the BasicJobSecrets implementation for JobSecrets.
func (js JobSecrets) AsJobSecretsType() (*JobSecretsType, bool) {
	return nil, false
}

// AsJobSecrets is the BasicJobSecrets implementation for JobSecrets.
func (js JobSecrets) AsJobSecrets() (*JobSecrets, bool) {
	return &js, true
}

// AsBasicJobSecrets is the BasicJobSecrets implementation for JobSecrets.
func (js JobSecrets) AsBasicJobSecrets() (BasicJobSecrets, bool) {
	return &js, true
}

// JobSecretsType the secrets related to a databox job.
type JobSecretsType struct {
	// PodSecrets - Contains the list of secret objects for a job.
	PodSecrets *[]Secret `json:"podSecrets,omitempty"`
	// DcAccessSecurityCode - Dc Access Security Code for Customer Managed Shipping
	DcAccessSecurityCode *DcAccessSecurityCode `json:"dcAccessSecurityCode,omitempty"`
	// JobSecretsType - Possible values include: 'JobSecretsTypeJobSecrets', 'JobSecretsTypeDataBoxDisk', 'JobSecretsTypeDataBoxHeavy', 'JobSecretsTypeDataBox'
	JobSecretsType JobSecretsTypeEnum `json:"jobSecretsType,omitempty"`
}

// MarshalJSON is the custom marshaler for JobSecretsType.
func (jst JobSecretsType) MarshalJSON() ([]byte, error) {
	jst.JobSecretsType = JobSecretsTypeDataBox
	objectMap := make(map[string]interface{})
	if jst.PodSecrets != nil {
		objectMap["podSecrets"] = jst.PodSecrets
	}
	if jst.DcAccessSecurityCode != nil {
		objectMap["dcAccessSecurityCode"] = jst.DcAccessSecurityCode
	}
	if jst.JobSecretsType != "" {
		objectMap["jobSecretsType"] = jst.JobSecretsType
	}
	return json.Marshal(objectMap)
}

// AsDiskJobSecrets is the BasicJobSecrets implementation for JobSecretsType.
func (jst JobSecretsType) AsDiskJobSecrets() (*DiskJobSecrets, bool) {
	return nil, false
}

// AsHeavyJobSecrets is the BasicJobSecrets implementation for JobSecretsType.
func (jst JobSecretsType) AsHeavyJobSecrets() (*HeavyJobSecrets, bool) {
	return nil, false
}

// AsJobSecretsType is the BasicJobSecrets implementation for JobSecretsType.
func (jst JobSecretsType) AsJobSecretsType() (*JobSecretsType, bool) {
	return &jst, true
}

// AsJobSecrets is the BasicJobSecrets implementation for JobSecretsType.
func (jst JobSecretsType) AsJobSecrets() (*JobSecrets, bool) {
	return nil, false
}

// AsBasicJobSecrets is the BasicJobSecrets implementation for JobSecretsType.
func (jst JobSecretsType) AsBasicJobSecrets() (BasicJobSecrets, bool) {
	return &jst, true
}

// JobStages job stages.
type JobStages struct {
	// StageName - READ-ONLY; Name of the job stage. Possible values include: 'StageNameDeviceOrdered', 'StageNameDevicePrepared', 'StageNameDispatched', 'StageNameDelivered', 'StageNamePickedUp', 'StageNameAtAzureDC', 'StageNameDataCopy', 'StageNameCompleted', 'StageNameCompletedWithErrors', 'StageNameCancelled', 'StageNameFailedIssueReportedAtCustomer', 'StageNameFailedIssueDetectedAtAzureDC', 'StageNameAborted', 'StageNameCompletedWithWarnings', 'StageNameReadyToDispatchFromAzureDC', 'StageNameReadyToReceiveAtAzureDC'
	StageName StageName `json:"stageName,omitempty"`
	// DisplayName - READ-ONLY; Display name of the job stage.
	DisplayName *string `json:"displayName,omitempty"`
	// StageStatus - READ-ONLY; Status of the job stage. Possible values include: 'StageStatusNone', 'StageStatusInProgress', 'StageStatusSucceeded', 'StageStatusFailed', 'StageStatusCancelled', 'StageStatusCancelling', 'StageStatusSucceededWithErrors'
	StageStatus StageStatus `json:"stageStatus,omitempty"`
	// StageTime - READ-ONLY; Time for the job stage in UTC ISO 8601 format.
	StageTime *date.Time `json:"stageTime,omitempty"`
	// JobStageDetails - READ-ONLY; Job Stage Details
	JobStageDetails interface{} `json:"jobStageDetails,omitempty"`
	// ErrorDetails - READ-ONLY; Error details for the stage.
	ErrorDetails *[]JobErrorDetails `json:"errorDetails,omitempty"`
}

// JobsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type JobsUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *JobsUpdateFuture) Result(client JobsClient) (jr JobResource, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "databox.JobsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("databox.JobsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if jr.Response.Response, err = future.GetResult(sender); err == nil && jr.Response.Response.StatusCode != http.StatusNoContent {
		jr, err = client.UpdateResponder(jr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "databox.JobsUpdateFuture", "Result", jr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// NotificationPreference notification preference for a job stage.
type NotificationPreference struct {
	// StageName - Name of the stage. Possible values include: 'DevicePrepared', 'Dispatched', 'Delivered', 'PickedUp', 'AtAzureDC', 'DataCopy'
	StageName NotificationStageName `json:"stageName,omitempty"`
	// SendNotification - Notification is required or not.
	SendNotification *bool `json:"sendNotification,omitempty"`
}

// Operation operation entity.
type Operation struct {
	// Name - READ-ONLY; Name of the operation. Format: {resourceProviderNamespace}/{resourceType}/{read|write|delete|action}
	Name *string `json:"name,omitempty"`
	// Display - READ-ONLY; Operation display values.
	Display *OperationDisplay `json:"display,omitempty"`
	// Properties - READ-ONLY; Operation properties.
	Properties interface{} `json:"properties,omitempty"`
	// Origin - READ-ONLY; Origin of the operation. Can be : user|system|user,system
	Origin *string `json:"origin,omitempty"`
}

// OperationDisplay operation display
type OperationDisplay struct {
	// Provider - Provider name.
	Provider *string `json:"provider,omitempty"`
	// Resource - Resource name.
	Resource *string `json:"resource,omitempty"`
	// Operation - Localized name of the operation for display purpose.
	Operation *string `json:"operation,omitempty"`
	// Description - Localized description of the operation for display purpose.
	Description *string `json:"description,omitempty"`
}

// OperationList operation Collection.
type OperationList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of operations.
	Value *[]Operation `json:"value,omitempty"`
	// NextLink - Link for the next set of operations.
	NextLink *string `json:"nextLink,omitempty"`
}

// OperationListIterator provides access to a complete listing of Operation values.
type OperationListIterator struct {
	i    int
	page OperationListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListIterator) Response() OperationList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationListIterator type.
func NewOperationListIterator(page OperationListPage) OperationListIterator {
	return OperationListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ol OperationList) IsEmpty() bool {
	return ol.Value == nil || len(*ol.Value) == 0
}

// operationListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ol OperationList) operationListPreparer(ctx context.Context) (*http.Request, error) {
	if ol.NextLink == nil || len(to.String(ol.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ol.NextLink)))
}

// OperationListPage contains a page of Operation values.
type OperationListPage struct {
	fn func(context.Context, OperationList) (OperationList, error)
	ol OperationList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.ol)
	if err != nil {
		return err
	}
	page.ol = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListPage) NotDone() bool {
	return !page.ol.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListPage) Response() OperationList {
	return page.ol
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListPage) Values() []Operation {
	if page.ol.IsEmpty() {
		return nil
	}
	return *page.ol.Value
}

// Creates a new instance of the OperationListPage type.
func NewOperationListPage(getNextPage func(context.Context, OperationList) (OperationList, error)) OperationListPage {
	return OperationListPage{fn: getNextPage}
}

// PackageShippingDetails shipping details.
type PackageShippingDetails struct {
	// CarrierName - READ-ONLY; Name of the carrier.
	CarrierName *string `json:"carrierName,omitempty"`
	// TrackingID - READ-ONLY; Tracking Id of shipment.
	TrackingID *string `json:"trackingId,omitempty"`
	// TrackingURL - READ-ONLY; Url where shipment can be tracked.
	TrackingURL *string `json:"trackingUrl,omitempty"`
}

// Preferences preferences related to the order
type Preferences struct {
	// PreferredDataCenterRegion - Preferred Data Center Region.
	PreferredDataCenterRegion *[]string `json:"preferredDataCenterRegion,omitempty"`
	// TransportPreferences - Preferences related to the shipment logistics of the sku.
	TransportPreferences *TransportPreferences `json:"transportPreferences,omitempty"`
}

// PreferencesValidationRequest request to validate preference of transport and data center.
type PreferencesValidationRequest struct {
	// Preference - Preference requested with respect to transport type and data center
	Preference *Preferences `json:"preference,omitempty"`
	// DeviceType - Device type to be used for the job. Possible values include: 'DataBox', 'DataBoxDisk', 'DataBoxHeavy'
	DeviceType SkuName `json:"deviceType,omitempty"`
	// ValidationType - Possible values include: 'ValidationTypeValidationInputRequest', 'ValidationTypeValidateCreateOrderLimit', 'ValidationTypeValidateDataDestinationDetails', 'ValidationTypeValidatePreferences', 'ValidationTypeValidateSkuAvailability', 'ValidationTypeValidateSubscriptionIsAllowedToCreateJob', 'ValidationTypeValidateAddress'
	ValidationType ValidationType `json:"validationType,omitempty"`
}

// MarshalJSON is the custom marshaler for PreferencesValidationRequest.
func (pvr PreferencesValidationRequest) MarshalJSON() ([]byte, error) {
	pvr.ValidationType = ValidationTypeValidatePreferences
	objectMap := make(map[string]interface{})
	if pvr.Preference != nil {
		objectMap["preference"] = pvr.Preference
	}
	if pvr.DeviceType != "" {
		objectMap["deviceType"] = pvr.DeviceType
	}
	if pvr.ValidationType != "" {
		objectMap["validationType"] = pvr.ValidationType
	}
	return json.Marshal(objectMap)
}

// AsCreateOrderLimitForSubscriptionValidationRequest is the BasicValidationInputRequest implementation for PreferencesValidationRequest.
func (pvr PreferencesValidationRequest) AsCreateOrderLimitForSubscriptionValidationRequest() (*CreateOrderLimitForSubscriptionValidationRequest, bool) {
	return nil, false
}

// AsDataDestinationDetailsValidationRequest is the BasicValidationInputRequest implementation for PreferencesValidationRequest.
func (pvr PreferencesValidationRequest) AsDataDestinationDetailsValidationRequest() (*DataDestinationDetailsValidationRequest, bool) {
	return nil, false
}

// AsPreferencesValidationRequest is the BasicValidationInputRequest implementation for PreferencesValidationRequest.
func (pvr PreferencesValidationRequest) AsPreferencesValidationRequest() (*PreferencesValidationRequest, bool) {
	return &pvr, true
}

// AsSkuAvailabilityValidationRequest is the BasicValidationInputRequest implementation for PreferencesValidationRequest.
func (pvr PreferencesValidationRequest) AsSkuAvailabilityValidationRequest() (*SkuAvailabilityValidationRequest, bool) {
	return nil, false
}

// AsSubscriptionIsAllowedToCreateJobValidationRequest is the BasicValidationInputRequest implementation for PreferencesValidationRequest.
func (pvr PreferencesValidationRequest) AsSubscriptionIsAllowedToCreateJobValidationRequest() (*SubscriptionIsAllowedToCreateJobValidationRequest, bool) {
	return nil, false
}

// AsValidateAddress is the BasicValidationInputRequest implementation for PreferencesValidationRequest.
func (pvr PreferencesValidationRequest) AsValidateAddress() (*ValidateAddress, bool) {
	return nil, false
}

// AsValidationInputRequest is the BasicValidationInputRequest implementation for PreferencesValidationRequest.
func (pvr PreferencesValidationRequest) AsValidationInputRequest() (*ValidationInputRequest, bool) {
	return nil, false
}

// AsBasicValidationInputRequest is the BasicValidationInputRequest implementation for PreferencesValidationRequest.
func (pvr PreferencesValidationRequest) AsBasicValidationInputRequest() (BasicValidationInputRequest, bool) {
	return &pvr, true
}

// PreferencesValidationResponseProperties properties of data center and transport preference validation
// response.
type PreferencesValidationResponseProperties struct {
	// Status - READ-ONLY; Validation status of requested data center and transport. Possible values include: 'ValidationStatusValid', 'ValidationStatusInvalid', 'ValidationStatusSkipped'
	Status ValidationStatus `json:"status,omitempty"`
	// Error - READ-ONLY; Error code and message of validation response.
	Error *Error `json:"error,omitempty"`
	// ValidationType - Possible values include: 'ValidationTypeBasicValidationInputResponseValidationTypeValidationInputResponse', 'ValidationTypeBasicValidationInputResponseValidationTypeValidateAddress', 'ValidationTypeBasicValidationInputResponseValidationTypeValidateCreateOrderLimit', 'ValidationTypeBasicValidationInputResponseValidationTypeValidateDataDestinationDetails', 'ValidationTypeBasicValidationInputResponseValidationTypeValidatePreferences', 'ValidationTypeBasicValidationInputResponseValidationTypeValidateSkuAvailability', 'ValidationTypeBasicValidationInputResponseValidationTypeValidateSubscriptionIsAllowedToCreateJob'
	ValidationType ValidationTypeBasicValidationInputResponse `json:"validationType,omitempty"`
}

// MarshalJSON is the custom marshaler for PreferencesValidationResponseProperties.
func (pvrp PreferencesValidationResponseProperties) MarshalJSON() ([]byte, error) {
	pvrp.ValidationType = ValidationTypeBasicValidationInputResponseValidationTypeValidatePreferences
	objectMap := make(map[string]interface{})
	if pvrp.ValidationType != "" {
		objectMap["validationType"] = pvrp.ValidationType
	}
	return json.Marshal(objectMap)
}

// AsAddressValidationProperties is the BasicValidationInputResponse implementation for PreferencesValidationResponseProperties.
func (pvrp PreferencesValidationResponseProperties) AsAddressValidationProperties() (*AddressValidationProperties, bool) {
	return nil, false
}

// AsCreateOrderLimitForSubscriptionValidationResponseProperties is the BasicValidationInputResponse implementation for PreferencesValidationResponseProperties.
func (pvrp PreferencesValidationResponseProperties) AsCreateOrderLimitForSubscriptionValidationResponseProperties() (*CreateOrderLimitForSubscriptionValidationResponseProperties, bool) {
	return nil, false
}

// AsDataDestinationDetailsValidationResponseProperties is the BasicValidationInputResponse implementation for PreferencesValidationResponseProperties.
func (pvrp PreferencesValidationResponseProperties) AsDataDestinationDetailsValidationResponseProperties() (*DataDestinationDetailsValidationResponseProperties, bool) {
	return nil, false
}

// AsPreferencesValidationResponseProperties is the BasicValidationInputResponse implementation for PreferencesValidationResponseProperties.
func (pvrp PreferencesValidationResponseProperties) AsPreferencesValidationResponseProperties() (*PreferencesValidationResponseProperties, bool) {
	return &pvrp, true
}

// AsSkuAvailabilityValidationResponseProperties is the BasicValidationInputResponse implementation for PreferencesValidationResponseProperties.
func (pvrp PreferencesValidationResponseProperties) AsSkuAvailabilityValidationResponseProperties() (*SkuAvailabilityValidationResponseProperties, bool) {
	return nil, false
}

// AsSubscriptionIsAllowedToCreateJobValidationResponseProperties is the BasicValidationInputResponse implementation for PreferencesValidationResponseProperties.
func (pvrp PreferencesValidationResponseProperties) AsSubscriptionIsAllowedToCreateJobValidationResponseProperties() (*SubscriptionIsAllowedToCreateJobValidationResponseProperties, bool) {
	return nil, false
}

// AsValidationInputResponse is the BasicValidationInputResponse implementation for PreferencesValidationResponseProperties.
func (pvrp PreferencesValidationResponseProperties) AsValidationInputResponse() (*ValidationInputResponse, bool) {
	return nil, false
}

// AsBasicValidationInputResponse is the BasicValidationInputResponse implementation for PreferencesValidationResponseProperties.
func (pvrp PreferencesValidationResponseProperties) AsBasicValidationInputResponse() (BasicValidationInputResponse, bool) {
	return &pvrp, true
}

// RegionConfigurationRequest request body to get the configuration for the region.
type RegionConfigurationRequest struct {
	// ScheduleAvailabilityRequest - Request body to get the availability for scheduling orders.
	ScheduleAvailabilityRequest BasicScheduleAvailabilityRequest `json:"scheduleAvailabilityRequest,omitempty"`
	// TransportAvailabilityRequest - Request body to get the transport availability for given sku.
	TransportAvailabilityRequest *TransportAvailabilityRequest `json:"transportAvailabilityRequest,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for RegionConfigurationRequest struct.
func (rcr *RegionConfigurationRequest) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "scheduleAvailabilityRequest":
			if v != nil {
				scheduleAvailabilityRequest, err := unmarshalBasicScheduleAvailabilityRequest(*v)
				if err != nil {
					return err
				}
				rcr.ScheduleAvailabilityRequest = scheduleAvailabilityRequest
			}
		case "transportAvailabilityRequest":
			if v != nil {
				var transportAvailabilityRequest TransportAvailabilityRequest
				err = json.Unmarshal(*v, &transportAvailabilityRequest)
				if err != nil {
					return err
				}
				rcr.TransportAvailabilityRequest = &transportAvailabilityRequest
			}
		}
	}

	return nil
}

// RegionConfigurationResponse configuration response specific to a region.
type RegionConfigurationResponse struct {
	autorest.Response `json:"-"`
	// ScheduleAvailabilityResponse - READ-ONLY; Schedule availability for given sku in a region.
	ScheduleAvailabilityResponse *ScheduleAvailabilityResponse `json:"scheduleAvailabilityResponse,omitempty"`
	// TransportAvailabilityResponse - READ-ONLY; Transport options available for given sku in a region.
	TransportAvailabilityResponse *TransportAvailabilityResponse `json:"transportAvailabilityResponse,omitempty"`
}

// Resource model of the Resource.
type Resource struct {
	// Location - The location of the resource. This will be one of the supported and registered Azure Regions (e.g. West US, East US, Southeast Asia, etc.). The region of a resource cannot be changed once it is created, but if an identical region is specified on update the request will succeed.
	Location *string `json:"location,omitempty"`
	// Tags - The list of key value pairs that describe the resource. These tags can be used in viewing and grouping this resource (across resource groups).
	Tags map[string]*string `json:"tags"`
	// Sku - The sku type.
	Sku *Sku `json:"sku,omitempty"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.Location != nil {
		objectMap["location"] = r.Location
	}
	if r.Tags != nil {
		objectMap["tags"] = r.Tags
	}
	if r.Sku != nil {
		objectMap["sku"] = r.Sku
	}
	return json.Marshal(objectMap)
}

// BasicScheduleAvailabilityRequest request body to get the availability for scheduling orders.
type BasicScheduleAvailabilityRequest interface {
	AsScheduleAvailabilityRequestType() (*ScheduleAvailabilityRequestType, bool)
	AsDiskScheduleAvailabilityRequest() (*DiskScheduleAvailabilityRequest, bool)
	AsHeavyScheduleAvailabilityRequest() (*HeavyScheduleAvailabilityRequest, bool)
	AsScheduleAvailabilityRequest() (*ScheduleAvailabilityRequest, bool)
}

// ScheduleAvailabilityRequest request body to get the availability for scheduling orders.
type ScheduleAvailabilityRequest struct {
	// StorageLocation - Location for data transfer.
	// For locations check: https://management.azure.com/subscriptions/SUBSCRIPTIONID/locations?api-version=2018-01-01
	StorageLocation *string `json:"storageLocation,omitempty"`
	// SkuName - Possible values include: 'SkuNameScheduleAvailabilityRequest', 'SkuNameDataBox', 'SkuNameDataBoxDisk', 'SkuNameDataBoxHeavy'
	SkuName SkuNameBasicScheduleAvailabilityRequest `json:"skuName,omitempty"`
}

func unmarshalBasicScheduleAvailabilityRequest(body []byte) (BasicScheduleAvailabilityRequest, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["skuName"] {
	case string(SkuNameDataBox):
		var sart ScheduleAvailabilityRequestType
		err := json.Unmarshal(body, &sart)
		return sart, err
	case string(SkuNameDataBoxDisk):
		var dsar DiskScheduleAvailabilityRequest
		err := json.Unmarshal(body, &dsar)
		return dsar, err
	case string(SkuNameDataBoxHeavy):
		var hsar HeavyScheduleAvailabilityRequest
		err := json.Unmarshal(body, &hsar)
		return hsar, err
	default:
		var sar ScheduleAvailabilityRequest
		err := json.Unmarshal(body, &sar)
		return sar, err
	}
}
func unmarshalBasicScheduleAvailabilityRequestArray(body []byte) ([]BasicScheduleAvailabilityRequest, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	sarArray := make([]BasicScheduleAvailabilityRequest, len(rawMessages))

	for index, rawMessage := range rawMessages {
		sar, err := unmarshalBasicScheduleAvailabilityRequest(*rawMessage)
		if err != nil {
			return nil, err
		}
		sarArray[index] = sar
	}
	return sarArray, nil
}

// MarshalJSON is the custom marshaler for ScheduleAvailabilityRequest.
func (sar ScheduleAvailabilityRequest) MarshalJSON() ([]byte, error) {
	sar.SkuName = SkuNameScheduleAvailabilityRequest
	objectMap := make(map[string]interface{})
	if sar.StorageLocation != nil {
		objectMap["storageLocation"] = sar.StorageLocation
	}
	if sar.SkuName != "" {
		objectMap["skuName"] = sar.SkuName
	}
	return json.Marshal(objectMap)
}

// AsScheduleAvailabilityRequestType is the BasicScheduleAvailabilityRequest implementation for ScheduleAvailabilityRequest.
func (sar ScheduleAvailabilityRequest) AsScheduleAvailabilityRequestType() (*ScheduleAvailabilityRequestType, bool) {
	return nil, false
}

// AsDiskScheduleAvailabilityRequest is the BasicScheduleAvailabilityRequest implementation for ScheduleAvailabilityRequest.
func (sar ScheduleAvailabilityRequest) AsDiskScheduleAvailabilityRequest() (*DiskScheduleAvailabilityRequest, bool) {
	return nil, false
}

// AsHeavyScheduleAvailabilityRequest is the BasicScheduleAvailabilityRequest implementation for ScheduleAvailabilityRequest.
func (sar ScheduleAvailabilityRequest) AsHeavyScheduleAvailabilityRequest() (*HeavyScheduleAvailabilityRequest, bool) {
	return nil, false
}

// AsScheduleAvailabilityRequest is the BasicScheduleAvailabilityRequest implementation for ScheduleAvailabilityRequest.
func (sar ScheduleAvailabilityRequest) AsScheduleAvailabilityRequest() (*ScheduleAvailabilityRequest, bool) {
	return &sar, true
}

// AsBasicScheduleAvailabilityRequest is the BasicScheduleAvailabilityRequest implementation for ScheduleAvailabilityRequest.
func (sar ScheduleAvailabilityRequest) AsBasicScheduleAvailabilityRequest() (BasicScheduleAvailabilityRequest, bool) {
	return &sar, true
}

// ScheduleAvailabilityRequestType request body to get the availability for scheduling data box orders
// orders.
type ScheduleAvailabilityRequestType struct {
	// StorageLocation - Location for data transfer.
	// For locations check: https://management.azure.com/subscriptions/SUBSCRIPTIONID/locations?api-version=2018-01-01
	StorageLocation *string `json:"storageLocation,omitempty"`
	// SkuName - Possible values include: 'SkuNameScheduleAvailabilityRequest', 'SkuNameDataBox', 'SkuNameDataBoxDisk', 'SkuNameDataBoxHeavy'
	SkuName SkuNameBasicScheduleAvailabilityRequest `json:"skuName,omitempty"`
}

// MarshalJSON is the custom marshaler for ScheduleAvailabilityRequestType.
func (sart ScheduleAvailabilityRequestType) MarshalJSON() ([]byte, error) {
	sart.SkuName = SkuNameDataBox
	objectMap := make(map[string]interface{})
	if sart.StorageLocation != nil {
		objectMap["storageLocation"] = sart.StorageLocation
	}
	if sart.SkuName != "" {
		objectMap["skuName"] = sart.SkuName
	}
	return json.Marshal(objectMap)
}

// AsScheduleAvailabilityRequestType is the BasicScheduleAvailabilityRequest implementation for ScheduleAvailabilityRequestType.
func (sart ScheduleAvailabilityRequestType) AsScheduleAvailabilityRequestType() (*ScheduleAvailabilityRequestType, bool) {
	return &sart, true
}

// AsDiskScheduleAvailabilityRequest is the BasicScheduleAvailabilityRequest implementation for ScheduleAvailabilityRequestType.
func (sart ScheduleAvailabilityRequestType) AsDiskScheduleAvailabilityRequest() (*DiskScheduleAvailabilityRequest, bool) {
	return nil, false
}

// AsHeavyScheduleAvailabilityRequest is the BasicScheduleAvailabilityRequest implementation for ScheduleAvailabilityRequestType.
func (sart ScheduleAvailabilityRequestType) AsHeavyScheduleAvailabilityRequest() (*HeavyScheduleAvailabilityRequest, bool) {
	return nil, false
}

// AsScheduleAvailabilityRequest is the BasicScheduleAvailabilityRequest implementation for ScheduleAvailabilityRequestType.
func (sart ScheduleAvailabilityRequestType) AsScheduleAvailabilityRequest() (*ScheduleAvailabilityRequest, bool) {
	return nil, false
}

// AsBasicScheduleAvailabilityRequest is the BasicScheduleAvailabilityRequest implementation for ScheduleAvailabilityRequestType.
func (sart ScheduleAvailabilityRequestType) AsBasicScheduleAvailabilityRequest() (BasicScheduleAvailabilityRequest, bool) {
	return &sart, true
}

// ScheduleAvailabilityResponse schedule availability response for given sku in a region.
type ScheduleAvailabilityResponse struct {
	// AvailableDates - READ-ONLY; List of dates available to schedule
	AvailableDates *[]date.Time `json:"availableDates,omitempty"`
}

// Secret the secrets related to a DataBox.
type Secret struct {
	// DeviceSerialNumber - READ-ONLY; Serial number of the assigned device.
	DeviceSerialNumber *string `json:"deviceSerialNumber,omitempty"`
	// DevicePassword - READ-ONLY; Password for out of the box experience on device.
	DevicePassword *string `json:"devicePassword,omitempty"`
	// NetworkConfigurations - READ-ONLY; Network configuration of the appliance.
	NetworkConfigurations *[]ApplianceNetworkConfiguration `json:"networkConfigurations,omitempty"`
	// EncodedValidationCertPubKey - READ-ONLY; The base 64 encoded public key to authenticate with the device
	EncodedValidationCertPubKey *string `json:"encodedValidationCertPubKey,omitempty"`
	// AccountCredentialDetails - READ-ONLY; Per account level access credentials.
	AccountCredentialDetails *[]AccountCredentialDetails `json:"accountCredentialDetails,omitempty"`
}

// ShareCredentialDetails credential details of the shares in account.
type ShareCredentialDetails struct {
	// ShareName - READ-ONLY; Name of the share.
	ShareName *string `json:"shareName,omitempty"`
	// ShareType - READ-ONLY; Type of the share. Possible values include: 'ShareDestinationFormatTypeUnknownType', 'ShareDestinationFormatTypeHCS', 'ShareDestinationFormatTypeBlockBlob', 'ShareDestinationFormatTypePageBlob', 'ShareDestinationFormatTypeAzureFile', 'ShareDestinationFormatTypeManagedDisk'
	ShareType ShareDestinationFormatType `json:"shareType,omitempty"`
	// UserName - READ-ONLY; User name for the share.
	UserName *string `json:"userName,omitempty"`
	// Password - READ-ONLY; Password for the share.
	Password *string `json:"password,omitempty"`
	// SupportedAccessProtocols - READ-ONLY; Access protocols supported on the device.
	SupportedAccessProtocols *[]AccessProtocol `json:"supportedAccessProtocols,omitempty"`
}

// ShipmentPickUpRequest shipment pick up request details.
type ShipmentPickUpRequest struct {
	// StartTime - Minimum date after which the pick up should commence, this must be in local time of pick up area.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - Maximum date before which the pick up should commence, this must be in local time of pick up area.
	EndTime *date.Time `json:"endTime,omitempty"`
	// ShipmentLocation - Shipment Location in the pickup place. Eg.front desk
	ShipmentLocation *string `json:"shipmentLocation,omitempty"`
}

// ShipmentPickUpResponse shipment pick up response.
type ShipmentPickUpResponse struct {
	autorest.Response `json:"-"`
	// ConfirmationNumber - READ-ONLY; Confirmation number for the pick up request.
	ConfirmationNumber *string `json:"confirmationNumber,omitempty"`
	// ReadyByTime - READ-ONLY; Time by which shipment should be ready for pick up, this is in local time of pick up area.
	ReadyByTime *date.Time `json:"readyByTime,omitempty"`
}

// ShippingAddress shipping address where customer wishes to receive the device.
type ShippingAddress struct {
	// StreetAddress1 - Street Address line 1.
	StreetAddress1 *string `json:"streetAddress1,omitempty"`
	// StreetAddress2 - Street Address line 2.
	StreetAddress2 *string `json:"streetAddress2,omitempty"`
	// StreetAddress3 - Street Address line 3.
	StreetAddress3 *string `json:"streetAddress3,omitempty"`
	// City - Name of the City.
	City *string `json:"city,omitempty"`
	// StateOrProvince - Name of the State or Province.
	StateOrProvince *string `json:"stateOrProvince,omitempty"`
	// Country - Name of the Country.
	Country *string `json:"country,omitempty"`
	// PostalCode - Postal code.
	PostalCode *string `json:"postalCode,omitempty"`
	// ZipExtendedCode - Extended Zip Code.
	ZipExtendedCode *string `json:"zipExtendedCode,omitempty"`
	// CompanyName - Name of the company.
	CompanyName *string `json:"companyName,omitempty"`
	// AddressType - Type of address. Possible values include: 'None', 'Residential', 'Commercial'
	AddressType AddressType `json:"addressType,omitempty"`
}

// Sku the Sku.
type Sku struct {
	// Name - The sku name. Possible values include: 'DataBox', 'DataBoxDisk', 'DataBoxHeavy'
	Name SkuName `json:"name,omitempty"`
	// DisplayName - The display name of the sku.
	DisplayName *string `json:"displayName,omitempty"`
	// Family - The sku family.
	Family *string `json:"family,omitempty"`
}

// SkuAvailabilityValidationRequest request to validate sku availability.
type SkuAvailabilityValidationRequest struct {
	// DeviceType - Device type to be used for the job. Possible values include: 'DataBox', 'DataBoxDisk', 'DataBoxHeavy'
	DeviceType SkuName `json:"deviceType,omitempty"`
	// TransferType - Type of the transfer.
	TransferType *string `json:"transferType,omitempty"`
	// Country - ISO country code. Country for hardware shipment. For codes check: https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2#Officially_assigned_code_elements
	Country *string `json:"country,omitempty"`
	// Location - Location for data transfer. For locations check: https://management.azure.com/subscriptions/SUBSCRIPTIONID/locations?api-version=2018-01-01
	Location *string `json:"location,omitempty"`
	// ValidationType - Possible values include: 'ValidationTypeValidationInputRequest', 'ValidationTypeValidateCreateOrderLimit', 'ValidationTypeValidateDataDestinationDetails', 'ValidationTypeValidatePreferences', 'ValidationTypeValidateSkuAvailability', 'ValidationTypeValidateSubscriptionIsAllowedToCreateJob', 'ValidationTypeValidateAddress'
	ValidationType ValidationType `json:"validationType,omitempty"`
}

// MarshalJSON is the custom marshaler for SkuAvailabilityValidationRequest.
func (savr SkuAvailabilityValidationRequest) MarshalJSON() ([]byte, error) {
	savr.ValidationType = ValidationTypeValidateSkuAvailability
	objectMap := make(map[string]interface{})
	if savr.DeviceType != "" {
		objectMap["deviceType"] = savr.DeviceType
	}
	if savr.TransferType != nil {
		objectMap["transferType"] = savr.TransferType
	}
	if savr.Country != nil {
		objectMap["country"] = savr.Country
	}
	if savr.Location != nil {
		objectMap["location"] = savr.Location
	}
	if savr.ValidationType != "" {
		objectMap["validationType"] = savr.ValidationType
	}
	return json.Marshal(objectMap)
}

// AsCreateOrderLimitForSubscriptionValidationRequest is the BasicValidationInputRequest implementation for SkuAvailabilityValidationRequest.
func (savr SkuAvailabilityValidationRequest) AsCreateOrderLimitForSubscriptionValidationRequest() (*CreateOrderLimitForSubscriptionValidationRequest, bool) {
	return nil, false
}

// AsDataDestinationDetailsValidationRequest is the BasicValidationInputRequest implementation for SkuAvailabilityValidationRequest.
func (savr SkuAvailabilityValidationRequest) AsDataDestinationDetailsValidationRequest() (*DataDestinationDetailsValidationRequest, bool) {
	return nil, false
}

// AsPreferencesValidationRequest is the BasicValidationInputRequest implementation for SkuAvailabilityValidationRequest.
func (savr SkuAvailabilityValidationRequest) AsPreferencesValidationRequest() (*PreferencesValidationRequest, bool) {
	return nil, false
}

// AsSkuAvailabilityValidationRequest is the BasicValidationInputRequest implementation for SkuAvailabilityValidationRequest.
func (savr SkuAvailabilityValidationRequest) AsSkuAvailabilityValidationRequest() (*SkuAvailabilityValidationRequest, bool) {
	return &savr, true
}

// AsSubscriptionIsAllowedToCreateJobValidationRequest is the BasicValidationInputRequest implementation for SkuAvailabilityValidationRequest.
func (savr SkuAvailabilityValidationRequest) AsSubscriptionIsAllowedToCreateJobValidationRequest() (*SubscriptionIsAllowedToCreateJobValidationRequest, bool) {
	return nil, false
}

// AsValidateAddress is the BasicValidationInputRequest implementation for SkuAvailabilityValidationRequest.
func (savr SkuAvailabilityValidationRequest) AsValidateAddress() (*ValidateAddress, bool) {
	return nil, false
}

// AsValidationInputRequest is the BasicValidationInputRequest implementation for SkuAvailabilityValidationRequest.
func (savr SkuAvailabilityValidationRequest) AsValidationInputRequest() (*ValidationInputRequest, bool) {
	return nil, false
}

// AsBasicValidationInputRequest is the BasicValidationInputRequest implementation for SkuAvailabilityValidationRequest.
func (savr SkuAvailabilityValidationRequest) AsBasicValidationInputRequest() (BasicValidationInputRequest, bool) {
	return &savr, true
}

// SkuAvailabilityValidationResponseProperties properties of sku availability validation response.
type SkuAvailabilityValidationResponseProperties struct {
	// Status - READ-ONLY; Sku availability validation status. Possible values include: 'ValidationStatusValid', 'ValidationStatusInvalid', 'ValidationStatusSkipped'
	Status ValidationStatus `json:"status,omitempty"`
	// Error - READ-ONLY; Error code and message of validation response.
	Error *Error `json:"error,omitempty"`
	// ValidationType - Possible values include: 'ValidationTypeBasicValidationInputResponseValidationTypeValidationInputResponse', 'ValidationTypeBasicValidationInputResponseValidationTypeValidateAddress', 'ValidationTypeBasicValidationInputResponseValidationTypeValidateCreateOrderLimit', 'ValidationTypeBasicValidationInputResponseValidationTypeValidateDataDestinationDetails', 'ValidationTypeBasicValidationInputResponseValidationTypeValidatePreferences', 'ValidationTypeBasicValidationInputResponseValidationTypeValidateSkuAvailability', 'ValidationTypeBasicValidationInputResponseValidationTypeValidateSubscriptionIsAllowedToCreateJob'
	ValidationType ValidationTypeBasicValidationInputResponse `json:"validationType,omitempty"`
}

// MarshalJSON is the custom marshaler for SkuAvailabilityValidationResponseProperties.
func (savrp SkuAvailabilityValidationResponseProperties) MarshalJSON() ([]byte, error) {
	savrp.ValidationType = ValidationTypeBasicValidationInputResponseValidationTypeValidateSkuAvailability
	objectMap := make(map[string]interface{})
	if savrp.ValidationType != "" {
		objectMap["validationType"] = savrp.ValidationType
	}
	return json.Marshal(objectMap)
}

// AsAddressValidationProperties is the BasicValidationInputResponse implementation for SkuAvailabilityValidationResponseProperties.
func (savrp SkuAvailabilityValidationResponseProperties) AsAddressValidationProperties() (*AddressValidationProperties, bool) {
	return nil, false
}

// AsCreateOrderLimitForSubscriptionValidationResponseProperties is the BasicValidationInputResponse implementation for SkuAvailabilityValidationResponseProperties.
func (savrp SkuAvailabilityValidationResponseProperties) AsCreateOrderLimitForSubscriptionValidationResponseProperties() (*CreateOrderLimitForSubscriptionValidationResponseProperties, bool) {
	return nil, false
}

// AsDataDestinationDetailsValidationResponseProperties is the BasicValidationInputResponse implementation for SkuAvailabilityValidationResponseProperties.
func (savrp SkuAvailabilityValidationResponseProperties) AsDataDestinationDetailsValidationResponseProperties() (*DataDestinationDetailsValidationResponseProperties, bool) {
	return nil, false
}

// AsPreferencesValidationResponseProperties is the BasicValidationInputResponse implementation for SkuAvailabilityValidationResponseProperties.
func (savrp SkuAvailabilityValidationResponseProperties) AsPreferencesValidationResponseProperties() (*PreferencesValidationResponseProperties, bool) {
	return nil, false
}

// AsSkuAvailabilityValidationResponseProperties is the BasicValidationInputResponse implementation for SkuAvailabilityValidationResponseProperties.
func (savrp SkuAvailabilityValidationResponseProperties) AsSkuAvailabilityValidationResponseProperties() (*SkuAvailabilityValidationResponseProperties, bool) {
	return &savrp, true
}

// AsSubscriptionIsAllowedToCreateJobValidationResponseProperties is the BasicValidationInputResponse implementation for SkuAvailabilityValidationResponseProperties.
func (savrp SkuAvailabilityValidationResponseProperties) AsSubscriptionIsAllowedToCreateJobValidationResponseProperties() (*SubscriptionIsAllowedToCreateJobValidationResponseProperties, bool) {
	return nil, false
}

// AsValidationInputResponse is the BasicValidationInputResponse implementation for SkuAvailabilityValidationResponseProperties.
func (savrp SkuAvailabilityValidationResponseProperties) AsValidationInputResponse() (*ValidationInputResponse, bool) {
	return nil, false
}

// AsBasicValidationInputResponse is the BasicValidationInputResponse implementation for SkuAvailabilityValidationResponseProperties.
func (savrp SkuAvailabilityValidationResponseProperties) AsBasicValidationInputResponse() (BasicValidationInputResponse, bool) {
	return &savrp, true
}

// SkuCapacity capacity of the sku.
type SkuCapacity struct {
	// Usable - READ-ONLY; Usable capacity in TB.
	Usable *string `json:"usable,omitempty"`
	// Maximum - READ-ONLY; Maximum capacity in TB.
	Maximum *string `json:"maximum,omitempty"`
}

// SkuCost describes metadata for retrieving price info.
type SkuCost struct {
	// MeterID - READ-ONLY; Meter id of the Sku.
	MeterID *string `json:"meterId,omitempty"`
	// MeterType - READ-ONLY; The type of the meter.
	MeterType *string `json:"meterType,omitempty"`
}

// SkuInformation information of the sku.
type SkuInformation struct {
	// Sku - READ-ONLY; The Sku.
	Sku *Sku `json:"sku,omitempty"`
	// Enabled - READ-ONLY; The sku is enabled or not.
	Enabled *bool `json:"enabled,omitempty"`
	// SkuProperties - READ-ONLY; Properties of the sku.
	*SkuProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for SkuInformation.
func (si SkuInformation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SkuInformation struct.
func (si *SkuInformation) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				si.Sku = &sku
			}
		case "enabled":
			if v != nil {
				var enabled bool
				err = json.Unmarshal(*v, &enabled)
				if err != nil {
					return err
				}
				si.Enabled = &enabled
			}
		case "properties":
			if v != nil {
				var skuProperties SkuProperties
				err = json.Unmarshal(*v, &skuProperties)
				if err != nil {
					return err
				}
				si.SkuProperties = &skuProperties
			}
		}
	}

	return nil
}

// SkuProperties properties of the sku.
type SkuProperties struct {
	// DestinationToServiceLocationMap - READ-ONLY; The map of destination location to service location.
	DestinationToServiceLocationMap *[]DestinationToServiceLocationMap `json:"destinationToServiceLocationMap,omitempty"`
	// Capacity - READ-ONLY; Capacity of the Sku.
	Capacity *SkuCapacity `json:"capacity,omitempty"`
	// Costs - READ-ONLY; Cost of the Sku.
	Costs *[]SkuCost `json:"costs,omitempty"`
	// APIVersions - READ-ONLY; Api versions that support this Sku.
	APIVersions *[]string `json:"apiVersions,omitempty"`
	// DisabledReason - READ-ONLY; Reason why the Sku is disabled. Possible values include: 'SkuDisabledReasonNone', 'SkuDisabledReasonCountry', 'SkuDisabledReasonRegion', 'SkuDisabledReasonFeature', 'SkuDisabledReasonOfferType', 'SkuDisabledReasonNoSubscriptionInfo'
	DisabledReason SkuDisabledReason `json:"disabledReason,omitempty"`
	// DisabledReasonMessage - READ-ONLY; Message for why the Sku is disabled.
	DisabledReasonMessage *string `json:"disabledReasonMessage,omitempty"`
	// RequiredFeature - READ-ONLY; Required feature to access the sku.
	RequiredFeature *string `json:"requiredFeature,omitempty"`
}

// SubscriptionIsAllowedToCreateJobValidationRequest request to validate subscription permission to create
// jobs.
type SubscriptionIsAllowedToCreateJobValidationRequest struct {
	// ValidationType - Possible values include: 'ValidationTypeValidationInputRequest', 'ValidationTypeValidateCreateOrderLimit', 'ValidationTypeValidateDataDestinationDetails', 'ValidationTypeValidatePreferences', 'ValidationTypeValidateSkuAvailability', 'ValidationTypeValidateSubscriptionIsAllowedToCreateJob', 'ValidationTypeValidateAddress'
	ValidationType ValidationType `json:"validationType,omitempty"`
}

// MarshalJSON is the custom marshaler for SubscriptionIsAllowedToCreateJobValidationRequest.
func (siatcjvr SubscriptionIsAllowedToCreateJobValidationRequest) MarshalJSON() ([]byte, error) {
	siatcjvr.ValidationType = ValidationTypeValidateSubscriptionIsAllowedToCreateJob
	objectMap := make(map[string]interface{})
	if siatcjvr.ValidationType != "" {
		objectMap["validationType"] = siatcjvr.ValidationType
	}
	return json.Marshal(objectMap)
}

// AsCreateOrderLimitForSubscriptionValidationRequest is the BasicValidationInputRequest implementation for SubscriptionIsAllowedToCreateJobValidationRequest.
func (siatcjvr SubscriptionIsAllowedToCreateJobValidationRequest) AsCreateOrderLimitForSubscriptionValidationRequest() (*CreateOrderLimitForSubscriptionValidationRequest, bool) {
	return nil, false
}

// AsDataDestinationDetailsValidationRequest is the BasicValidationInputRequest implementation for SubscriptionIsAllowedToCreateJobValidationRequest.
func (siatcjvr SubscriptionIsAllowedToCreateJobValidationRequest) AsDataDestinationDetailsValidationRequest() (*DataDestinationDetailsValidationRequest, bool) {
	return nil, false
}

// AsPreferencesValidationRequest is the BasicValidationInputRequest implementation for SubscriptionIsAllowedToCreateJobValidationRequest.
func (siatcjvr SubscriptionIsAllowedToCreateJobValidationRequest) AsPreferencesValidationRequest() (*PreferencesValidationRequest, bool) {
	return nil, false
}

// AsSkuAvailabilityValidationRequest is the BasicValidationInputRequest implementation for SubscriptionIsAllowedToCreateJobValidationRequest.
func (siatcjvr SubscriptionIsAllowedToCreateJobValidationRequest) AsSkuAvailabilityValidationRequest() (*SkuAvailabilityValidationRequest, bool) {
	return nil, false
}

// AsSubscriptionIsAllowedToCreateJobValidationRequest is the BasicValidationInputRequest implementation for SubscriptionIsAllowedToCreateJobValidationRequest.
func (siatcjvr SubscriptionIsAllowedToCreateJobValidationRequest) AsSubscriptionIsAllowedToCreateJobValidationRequest() (*SubscriptionIsAllowedToCreateJobValidationRequest, bool) {
	return &siatcjvr, true
}

// AsValidateAddress is the BasicValidationInputRequest implementation for SubscriptionIsAllowedToCreateJobValidationRequest.
func (siatcjvr SubscriptionIsAllowedToCreateJobValidationRequest) AsValidateAddress() (*ValidateAddress, bool) {
	return nil, false
}

// AsValidationInputRequest is the BasicValidationInputRequest implementation for SubscriptionIsAllowedToCreateJobValidationRequest.
func (siatcjvr SubscriptionIsAllowedToCreateJobValidationRequest) AsValidationInputRequest() (*ValidationInputRequest, bool) {
	return nil, false
}

// AsBasicValidationInputRequest is the BasicValidationInputRequest implementation for SubscriptionIsAllowedToCreateJobValidationRequest.
func (siatcjvr SubscriptionIsAllowedToCreateJobValidationRequest) AsBasicValidationInputRequest() (BasicValidationInputRequest, bool) {
	return &siatcjvr, true
}

// SubscriptionIsAllowedToCreateJobValidationResponseProperties properties of subscription permission to
// create job validation response.
type SubscriptionIsAllowedToCreateJobValidationResponseProperties struct {
	// Status - READ-ONLY; Validation status of subscription permission to create job. Possible values include: 'ValidationStatusValid', 'ValidationStatusInvalid', 'ValidationStatusSkipped'
	Status ValidationStatus `json:"status,omitempty"`
	// Error - READ-ONLY; Error code and message of validation response.
	Error *Error `json:"error,omitempty"`
	// ValidationType - Possible values include: 'ValidationTypeBasicValidationInputResponseValidationTypeValidationInputResponse', 'ValidationTypeBasicValidationInputResponseValidationTypeValidateAddress', 'ValidationTypeBasicValidationInputResponseValidationTypeValidateCreateOrderLimit', 'ValidationTypeBasicValidationInputResponseValidationTypeValidateDataDestinationDetails', 'ValidationTypeBasicValidationInputResponseValidationTypeValidatePreferences', 'ValidationTypeBasicValidationInputResponseValidationTypeValidateSkuAvailability', 'ValidationTypeBasicValidationInputResponseValidationTypeValidateSubscriptionIsAllowedToCreateJob'
	ValidationType ValidationTypeBasicValidationInputResponse `json:"validationType,omitempty"`
}

// MarshalJSON is the custom marshaler for SubscriptionIsAllowedToCreateJobValidationResponseProperties.
func (siatcjvrp SubscriptionIsAllowedToCreateJobValidationResponseProperties) MarshalJSON() ([]byte, error) {
	siatcjvrp.ValidationType = ValidationTypeBasicValidationInputResponseValidationTypeValidateSubscriptionIsAllowedToCreateJob
	objectMap := make(map[string]interface{})
	if siatcjvrp.ValidationType != "" {
		objectMap["validationType"] = siatcjvrp.ValidationType
	}
	return json.Marshal(objectMap)
}

// AsAddressValidationProperties is the BasicValidationInputResponse implementation for SubscriptionIsAllowedToCreateJobValidationResponseProperties.
func (siatcjvrp SubscriptionIsAllowedToCreateJobValidationResponseProperties) AsAddressValidationProperties() (*AddressValidationProperties, bool) {
	return nil, false
}

// AsCreateOrderLimitForSubscriptionValidationResponseProperties is the BasicValidationInputResponse implementation for SubscriptionIsAllowedToCreateJobValidationResponseProperties.
func (siatcjvrp SubscriptionIsAllowedToCreateJobValidationResponseProperties) AsCreateOrderLimitForSubscriptionValidationResponseProperties() (*CreateOrderLimitForSubscriptionValidationResponseProperties, bool) {
	return nil, false
}

// AsDataDestinationDetailsValidationResponseProperties is the BasicValidationInputResponse implementation for SubscriptionIsAllowedToCreateJobValidationResponseProperties.
func (siatcjvrp SubscriptionIsAllowedToCreateJobValidationResponseProperties) AsDataDestinationDetailsValidationResponseProperties() (*DataDestinationDetailsValidationResponseProperties, bool) {
	return nil, false
}

// AsPreferencesValidationResponseProperties is the BasicValidationInputResponse implementation for SubscriptionIsAllowedToCreateJobValidationResponseProperties.
func (siatcjvrp SubscriptionIsAllowedToCreateJobValidationResponseProperties) AsPreferencesValidationResponseProperties() (*PreferencesValidationResponseProperties, bool) {
	return nil, false
}

// AsSkuAvailabilityValidationResponseProperties is the BasicValidationInputResponse implementation for SubscriptionIsAllowedToCreateJobValidationResponseProperties.
func (siatcjvrp SubscriptionIsAllowedToCreateJobValidationResponseProperties) AsSkuAvailabilityValidationResponseProperties() (*SkuAvailabilityValidationResponseProperties, bool) {
	return nil, false
}

// AsSubscriptionIsAllowedToCreateJobValidationResponseProperties is the BasicValidationInputResponse implementation for SubscriptionIsAllowedToCreateJobValidationResponseProperties.
func (siatcjvrp SubscriptionIsAllowedToCreateJobValidationResponseProperties) AsSubscriptionIsAllowedToCreateJobValidationResponseProperties() (*SubscriptionIsAllowedToCreateJobValidationResponseProperties, bool) {
	return &siatcjvrp, true
}

// AsValidationInputResponse is the BasicValidationInputResponse implementation for SubscriptionIsAllowedToCreateJobValidationResponseProperties.
func (siatcjvrp SubscriptionIsAllowedToCreateJobValidationResponseProperties) AsValidationInputResponse() (*ValidationInputResponse, bool) {
	return nil, false
}

// AsBasicValidationInputResponse is the BasicValidationInputResponse implementation for SubscriptionIsAllowedToCreateJobValidationResponseProperties.
func (siatcjvrp SubscriptionIsAllowedToCreateJobValidationResponseProperties) AsBasicValidationInputResponse() (BasicValidationInputResponse, bool) {
	return &siatcjvrp, true
}

// TransportAvailabilityDetails transport options availability details for given region.
type TransportAvailabilityDetails struct {
	// ShipmentType - READ-ONLY; Transport Shipment Type supported for given region. Possible values include: 'CustomerManaged', 'MicrosoftManaged'
	ShipmentType TransportShipmentTypes `json:"shipmentType,omitempty"`
}

// TransportAvailabilityRequest request body to get the transport availability for given sku.
type TransportAvailabilityRequest struct {
	// SkuName - Type of the device. Possible values include: 'DataBox', 'DataBoxDisk', 'DataBoxHeavy'
	SkuName SkuName `json:"skuName,omitempty"`
}

// TransportAvailabilityResponse transport options available for given sku in a region.
type TransportAvailabilityResponse struct {
	// TransportAvailabilityDetails - READ-ONLY; List of transport availability details for given region
	TransportAvailabilityDetails *[]TransportAvailabilityDetails `json:"transportAvailabilityDetails,omitempty"`
}

// TransportPreferences preferences related to the shipment logistics of the sku
type TransportPreferences struct {
	// PreferredShipmentType - Indicates Shipment Logistics type that the customer preferred. Possible values include: 'CustomerManaged', 'MicrosoftManaged'
	PreferredShipmentType TransportShipmentTypes `json:"preferredShipmentType,omitempty"`
}

// UnencryptedCredentials unencrypted credentials for accessing device.
type UnencryptedCredentials struct {
	// JobName - READ-ONLY; Name of the job.
	JobName *string `json:"jobName,omitempty"`
	// JobSecrets - READ-ONLY; Secrets related to this job.
	JobSecrets BasicJobSecrets `json:"jobSecrets,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for UnencryptedCredentials struct.
func (uc *UnencryptedCredentials) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "jobName":
			if v != nil {
				var jobName string
				err = json.Unmarshal(*v, &jobName)
				if err != nil {
					return err
				}
				uc.JobName = &jobName
			}
		case "jobSecrets":
			if v != nil {
				jobSecrets, err := unmarshalBasicJobSecrets(*v)
				if err != nil {
					return err
				}
				uc.JobSecrets = jobSecrets
			}
		}
	}

	return nil
}

// UnencryptedCredentialsList list of unencrypted credentials for accessing device.
type UnencryptedCredentialsList struct {
	autorest.Response `json:"-"`
	// Value - List of unencrypted credentials.
	Value *[]UnencryptedCredentials `json:"value,omitempty"`
	// NextLink - Link for the next set of unencrypted credentials.
	NextLink *string `json:"nextLink,omitempty"`
}

// UpdateJobDetails job details for update.
type UpdateJobDetails struct {
	// ContactDetails - Contact details for notification and shipping.
	ContactDetails *ContactDetails `json:"contactDetails,omitempty"`
	// ShippingAddress - Shipping address of the customer.
	ShippingAddress *ShippingAddress `json:"shippingAddress,omitempty"`
}

// UpdateJobProperties job Properties for update
type UpdateJobProperties struct {
	// Details - Details of a job to be updated.
	Details *UpdateJobDetails `json:"details,omitempty"`
	// DestinationAccountDetails - Destination account details.
	DestinationAccountDetails *[]BasicDestinationAccountDetails `json:"destinationAccountDetails,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for UpdateJobProperties struct.
func (ujp *UpdateJobProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "details":
			if v != nil {
				var details UpdateJobDetails
				err = json.Unmarshal(*v, &details)
				if err != nil {
					return err
				}
				ujp.Details = &details
			}
		case "destinationAccountDetails":
			if v != nil {
				destinationAccountDetails, err := unmarshalBasicDestinationAccountDetailsArray(*v)
				if err != nil {
					return err
				}
				ujp.DestinationAccountDetails = &destinationAccountDetails
			}
		}
	}

	return nil
}

// ValidateAddress the requirements to validate customer address where the device needs to be shipped.
type ValidateAddress struct {
	// ShippingAddress - Shipping address of the customer.
	ShippingAddress *ShippingAddress `json:"shippingAddress,omitempty"`
	// DeviceType - Device type to be used for the job. Possible values include: 'DataBox', 'DataBoxDisk', 'DataBoxHeavy'
	DeviceType SkuName `json:"deviceType,omitempty"`
	// TransportPreferences - Preferences related to the shipment logistics of the sku.
	TransportPreferences *TransportPreferences `json:"transportPreferences,omitempty"`
	// ValidationType - Possible values include: 'ValidationTypeValidationInputRequest', 'ValidationTypeValidateCreateOrderLimit', 'ValidationTypeValidateDataDestinationDetails', 'ValidationTypeValidatePreferences', 'ValidationTypeValidateSkuAvailability', 'ValidationTypeValidateSubscriptionIsAllowedToCreateJob', 'ValidationTypeValidateAddress'
	ValidationType ValidationType `json:"validationType,omitempty"`
}

// MarshalJSON is the custom marshaler for ValidateAddress.
func (va ValidateAddress) MarshalJSON() ([]byte, error) {
	va.ValidationType = ValidationTypeValidateAddress
	objectMap := make(map[string]interface{})
	if va.ShippingAddress != nil {
		objectMap["shippingAddress"] = va.ShippingAddress
	}
	if va.DeviceType != "" {
		objectMap["deviceType"] = va.DeviceType
	}
	if va.TransportPreferences != nil {
		objectMap["transportPreferences"] = va.TransportPreferences
	}
	if va.ValidationType != "" {
		objectMap["validationType"] = va.ValidationType
	}
	return json.Marshal(objectMap)
}

// AsCreateOrderLimitForSubscriptionValidationRequest is the BasicValidationInputRequest implementation for ValidateAddress.
func (va ValidateAddress) AsCreateOrderLimitForSubscriptionValidationRequest() (*CreateOrderLimitForSubscriptionValidationRequest, bool) {
	return nil, false
}

// AsDataDestinationDetailsValidationRequest is the BasicValidationInputRequest implementation for ValidateAddress.
func (va ValidateAddress) AsDataDestinationDetailsValidationRequest() (*DataDestinationDetailsValidationRequest, bool) {
	return nil, false
}

// AsPreferencesValidationRequest is the BasicValidationInputRequest implementation for ValidateAddress.
func (va ValidateAddress) AsPreferencesValidationRequest() (*PreferencesValidationRequest, bool) {
	return nil, false
}

// AsSkuAvailabilityValidationRequest is the BasicValidationInputRequest implementation for ValidateAddress.
func (va ValidateAddress) AsSkuAvailabilityValidationRequest() (*SkuAvailabilityValidationRequest, bool) {
	return nil, false
}

// AsSubscriptionIsAllowedToCreateJobValidationRequest is the BasicValidationInputRequest implementation for ValidateAddress.
func (va ValidateAddress) AsSubscriptionIsAllowedToCreateJobValidationRequest() (*SubscriptionIsAllowedToCreateJobValidationRequest, bool) {
	return nil, false
}

// AsValidateAddress is the BasicValidationInputRequest implementation for ValidateAddress.
func (va ValidateAddress) AsValidateAddress() (*ValidateAddress, bool) {
	return &va, true
}

// AsValidationInputRequest is the BasicValidationInputRequest implementation for ValidateAddress.
func (va ValidateAddress) AsValidationInputRequest() (*ValidationInputRequest, bool) {
	return nil, false
}

// AsBasicValidationInputRequest is the BasicValidationInputRequest implementation for ValidateAddress.
func (va ValidateAddress) AsBasicValidationInputRequest() (BasicValidationInputRequest, bool) {
	return &va, true
}

// BasicValidationInputRequest minimum fields that must be present in any type of validation request.
type BasicValidationInputRequest interface {
	AsCreateOrderLimitForSubscriptionValidationRequest() (*CreateOrderLimitForSubscriptionValidationRequest, bool)
	AsDataDestinationDetailsValidationRequest() (*DataDestinationDetailsValidationRequest, bool)
	AsPreferencesValidationRequest() (*PreferencesValidationRequest, bool)
	AsSkuAvailabilityValidationRequest() (*SkuAvailabilityValidationRequest, bool)
	AsSubscriptionIsAllowedToCreateJobValidationRequest() (*SubscriptionIsAllowedToCreateJobValidationRequest, bool)
	AsValidateAddress() (*ValidateAddress, bool)
	AsValidationInputRequest() (*ValidationInputRequest, bool)
}

// ValidationInputRequest minimum fields that must be present in any type of validation request.
type ValidationInputRequest struct {
	// ValidationType - Possible values include: 'ValidationTypeValidationInputRequest', 'ValidationTypeValidateCreateOrderLimit', 'ValidationTypeValidateDataDestinationDetails', 'ValidationTypeValidatePreferences', 'ValidationTypeValidateSkuAvailability', 'ValidationTypeValidateSubscriptionIsAllowedToCreateJob', 'ValidationTypeValidateAddress'
	ValidationType ValidationType `json:"validationType,omitempty"`
}

func unmarshalBasicValidationInputRequest(body []byte) (BasicValidationInputRequest, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["validationType"] {
	case string(ValidationTypeValidateCreateOrderLimit):
		var colfsvr CreateOrderLimitForSubscriptionValidationRequest
		err := json.Unmarshal(body, &colfsvr)
		return colfsvr, err
	case string(ValidationTypeValidateDataDestinationDetails):
		var dddvr DataDestinationDetailsValidationRequest
		err := json.Unmarshal(body, &dddvr)
		return dddvr, err
	case string(ValidationTypeValidatePreferences):
		var pvr PreferencesValidationRequest
		err := json.Unmarshal(body, &pvr)
		return pvr, err
	case string(ValidationTypeValidateSkuAvailability):
		var savr SkuAvailabilityValidationRequest
		err := json.Unmarshal(body, &savr)
		return savr, err
	case string(ValidationTypeValidateSubscriptionIsAllowedToCreateJob):
		var siatcjvr SubscriptionIsAllowedToCreateJobValidationRequest
		err := json.Unmarshal(body, &siatcjvr)
		return siatcjvr, err
	case string(ValidationTypeValidateAddress):
		var va ValidateAddress
		err := json.Unmarshal(body, &va)
		return va, err
	default:
		var vir ValidationInputRequest
		err := json.Unmarshal(body, &vir)
		return vir, err
	}
}
func unmarshalBasicValidationInputRequestArray(body []byte) ([]BasicValidationInputRequest, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	virArray := make([]BasicValidationInputRequest, len(rawMessages))

	for index, rawMessage := range rawMessages {
		vir, err := unmarshalBasicValidationInputRequest(*rawMessage)
		if err != nil {
			return nil, err
		}
		virArray[index] = vir
	}
	return virArray, nil
}

// MarshalJSON is the custom marshaler for ValidationInputRequest.
func (vir ValidationInputRequest) MarshalJSON() ([]byte, error) {
	vir.ValidationType = ValidationTypeValidationInputRequest
	objectMap := make(map[string]interface{})
	if vir.ValidationType != "" {
		objectMap["validationType"] = vir.ValidationType
	}
	return json.Marshal(objectMap)
}

// AsCreateOrderLimitForSubscriptionValidationRequest is the BasicValidationInputRequest implementation for ValidationInputRequest.
func (vir ValidationInputRequest) AsCreateOrderLimitForSubscriptionValidationRequest() (*CreateOrderLimitForSubscriptionValidationRequest, bool) {
	return nil, false
}

// AsDataDestinationDetailsValidationRequest is the BasicValidationInputRequest implementation for ValidationInputRequest.
func (vir ValidationInputRequest) AsDataDestinationDetailsValidationRequest() (*DataDestinationDetailsValidationRequest, bool) {
	return nil, false
}

// AsPreferencesValidationRequest is the BasicValidationInputRequest implementation for ValidationInputRequest.
func (vir ValidationInputRequest) AsPreferencesValidationRequest() (*PreferencesValidationRequest, bool) {
	return nil, false
}

// AsSkuAvailabilityValidationRequest is the BasicValidationInputRequest implementation for ValidationInputRequest.
func (vir ValidationInputRequest) AsSkuAvailabilityValidationRequest() (*SkuAvailabilityValidationRequest, bool) {
	return nil, false
}

// AsSubscriptionIsAllowedToCreateJobValidationRequest is the BasicValidationInputRequest implementation for ValidationInputRequest.
func (vir ValidationInputRequest) AsSubscriptionIsAllowedToCreateJobValidationRequest() (*SubscriptionIsAllowedToCreateJobValidationRequest, bool) {
	return nil, false
}

// AsValidateAddress is the BasicValidationInputRequest implementation for ValidationInputRequest.
func (vir ValidationInputRequest) AsValidateAddress() (*ValidateAddress, bool) {
	return nil, false
}

// AsValidationInputRequest is the BasicValidationInputRequest implementation for ValidationInputRequest.
func (vir ValidationInputRequest) AsValidationInputRequest() (*ValidationInputRequest, bool) {
	return &vir, true
}

// AsBasicValidationInputRequest is the BasicValidationInputRequest implementation for ValidationInputRequest.
func (vir ValidationInputRequest) AsBasicValidationInputRequest() (BasicValidationInputRequest, bool) {
	return &vir, true
}

// BasicValidationInputResponse minimum properties that should be present in each individual validation response.
type BasicValidationInputResponse interface {
	AsAddressValidationProperties() (*AddressValidationProperties, bool)
	AsCreateOrderLimitForSubscriptionValidationResponseProperties() (*CreateOrderLimitForSubscriptionValidationResponseProperties, bool)
	AsDataDestinationDetailsValidationResponseProperties() (*DataDestinationDetailsValidationResponseProperties, bool)
	AsPreferencesValidationResponseProperties() (*PreferencesValidationResponseProperties, bool)
	AsSkuAvailabilityValidationResponseProperties() (*SkuAvailabilityValidationResponseProperties, bool)
	AsSubscriptionIsAllowedToCreateJobValidationResponseProperties() (*SubscriptionIsAllowedToCreateJobValidationResponseProperties, bool)
	AsValidationInputResponse() (*ValidationInputResponse, bool)
}

// ValidationInputResponse minimum properties that should be present in each individual validation response.
type ValidationInputResponse struct {
	// Error - READ-ONLY; Error code and message of validation response.
	Error *Error `json:"error,omitempty"`
	// ValidationType - Possible values include: 'ValidationTypeBasicValidationInputResponseValidationTypeValidationInputResponse', 'ValidationTypeBasicValidationInputResponseValidationTypeValidateAddress', 'ValidationTypeBasicValidationInputResponseValidationTypeValidateCreateOrderLimit', 'ValidationTypeBasicValidationInputResponseValidationTypeValidateDataDestinationDetails', 'ValidationTypeBasicValidationInputResponseValidationTypeValidatePreferences', 'ValidationTypeBasicValidationInputResponseValidationTypeValidateSkuAvailability', 'ValidationTypeBasicValidationInputResponseValidationTypeValidateSubscriptionIsAllowedToCreateJob'
	ValidationType ValidationTypeBasicValidationInputResponse `json:"validationType,omitempty"`
}

func unmarshalBasicValidationInputResponse(body []byte) (BasicValidationInputResponse, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["validationType"] {
	case string(ValidationTypeBasicValidationInputResponseValidationTypeValidateAddress):
		var avp AddressValidationProperties
		err := json.Unmarshal(body, &avp)
		return avp, err
	case string(ValidationTypeBasicValidationInputResponseValidationTypeValidateCreateOrderLimit):
		var colfsvrp CreateOrderLimitForSubscriptionValidationResponseProperties
		err := json.Unmarshal(body, &colfsvrp)
		return colfsvrp, err
	case string(ValidationTypeBasicValidationInputResponseValidationTypeValidateDataDestinationDetails):
		var dddvrp DataDestinationDetailsValidationResponseProperties
		err := json.Unmarshal(body, &dddvrp)
		return dddvrp, err
	case string(ValidationTypeBasicValidationInputResponseValidationTypeValidatePreferences):
		var pvrp PreferencesValidationResponseProperties
		err := json.Unmarshal(body, &pvrp)
		return pvrp, err
	case string(ValidationTypeBasicValidationInputResponseValidationTypeValidateSkuAvailability):
		var savrp SkuAvailabilityValidationResponseProperties
		err := json.Unmarshal(body, &savrp)
		return savrp, err
	case string(ValidationTypeBasicValidationInputResponseValidationTypeValidateSubscriptionIsAllowedToCreateJob):
		var siatcjvrp SubscriptionIsAllowedToCreateJobValidationResponseProperties
		err := json.Unmarshal(body, &siatcjvrp)
		return siatcjvrp, err
	default:
		var vir ValidationInputResponse
		err := json.Unmarshal(body, &vir)
		return vir, err
	}
}
func unmarshalBasicValidationInputResponseArray(body []byte) ([]BasicValidationInputResponse, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	virArray := make([]BasicValidationInputResponse, len(rawMessages))

	for index, rawMessage := range rawMessages {
		vir, err := unmarshalBasicValidationInputResponse(*rawMessage)
		if err != nil {
			return nil, err
		}
		virArray[index] = vir
	}
	return virArray, nil
}

// MarshalJSON is the custom marshaler for ValidationInputResponse.
func (vir ValidationInputResponse) MarshalJSON() ([]byte, error) {
	vir.ValidationType = ValidationTypeBasicValidationInputResponseValidationTypeValidationInputResponse
	objectMap := make(map[string]interface{})
	if vir.ValidationType != "" {
		objectMap["validationType"] = vir.ValidationType
	}
	return json.Marshal(objectMap)
}

// AsAddressValidationProperties is the BasicValidationInputResponse implementation for ValidationInputResponse.
func (vir ValidationInputResponse) AsAddressValidationProperties() (*AddressValidationProperties, bool) {
	return nil, false
}

// AsCreateOrderLimitForSubscriptionValidationResponseProperties is the BasicValidationInputResponse implementation for ValidationInputResponse.
func (vir ValidationInputResponse) AsCreateOrderLimitForSubscriptionValidationResponseProperties() (*CreateOrderLimitForSubscriptionValidationResponseProperties, bool) {
	return nil, false
}

// AsDataDestinationDetailsValidationResponseProperties is the BasicValidationInputResponse implementation for ValidationInputResponse.
func (vir ValidationInputResponse) AsDataDestinationDetailsValidationResponseProperties() (*DataDestinationDetailsValidationResponseProperties, bool) {
	return nil, false
}

// AsPreferencesValidationResponseProperties is the BasicValidationInputResponse implementation for ValidationInputResponse.
func (vir ValidationInputResponse) AsPreferencesValidationResponseProperties() (*PreferencesValidationResponseProperties, bool) {
	return nil, false
}

// AsSkuAvailabilityValidationResponseProperties is the BasicValidationInputResponse implementation for ValidationInputResponse.
func (vir ValidationInputResponse) AsSkuAvailabilityValidationResponseProperties() (*SkuAvailabilityValidationResponseProperties, bool) {
	return nil, false
}

// AsSubscriptionIsAllowedToCreateJobValidationResponseProperties is the BasicValidationInputResponse implementation for ValidationInputResponse.
func (vir ValidationInputResponse) AsSubscriptionIsAllowedToCreateJobValidationResponseProperties() (*SubscriptionIsAllowedToCreateJobValidationResponseProperties, bool) {
	return nil, false
}

// AsValidationInputResponse is the BasicValidationInputResponse implementation for ValidationInputResponse.
func (vir ValidationInputResponse) AsValidationInputResponse() (*ValidationInputResponse, bool) {
	return &vir, true
}

// AsBasicValidationInputResponse is the BasicValidationInputResponse implementation for ValidationInputResponse.
func (vir ValidationInputResponse) AsBasicValidationInputResponse() (BasicValidationInputResponse, bool) {
	return &vir, true
}

// BasicValidationRequest input request for all pre job creation validation.
type BasicValidationRequest interface {
	AsCreateJobValidations() (*CreateJobValidations, bool)
	AsValidationRequest() (*ValidationRequest, bool)
}

// ValidationRequest input request for all pre job creation validation.
type ValidationRequest struct {
	// IndividualRequestDetails - List of request details contain validationType and its request as key and value respectively.
	IndividualRequestDetails *[]BasicValidationInputRequest `json:"individualRequestDetails,omitempty"`
	// ValidationCategory - Possible values include: 'ValidationCategoryValidationRequest', 'ValidationCategoryJobCreationValidation'
	ValidationCategory ValidationCategory `json:"validationCategory,omitempty"`
}

func unmarshalBasicValidationRequest(body []byte) (BasicValidationRequest, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["validationCategory"] {
	case string(ValidationCategoryJobCreationValidation):
		var cjv CreateJobValidations
		err := json.Unmarshal(body, &cjv)
		return cjv, err
	default:
		var vr ValidationRequest
		err := json.Unmarshal(body, &vr)
		return vr, err
	}
}
func unmarshalBasicValidationRequestArray(body []byte) ([]BasicValidationRequest, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	vrArray := make([]BasicValidationRequest, len(rawMessages))

	for index, rawMessage := range rawMessages {
		vr, err := unmarshalBasicValidationRequest(*rawMessage)
		if err != nil {
			return nil, err
		}
		vrArray[index] = vr
	}
	return vrArray, nil
}

// MarshalJSON is the custom marshaler for ValidationRequest.
func (vr ValidationRequest) MarshalJSON() ([]byte, error) {
	vr.ValidationCategory = ValidationCategoryValidationRequest
	objectMap := make(map[string]interface{})
	if vr.IndividualRequestDetails != nil {
		objectMap["individualRequestDetails"] = vr.IndividualRequestDetails
	}
	if vr.ValidationCategory != "" {
		objectMap["validationCategory"] = vr.ValidationCategory
	}
	return json.Marshal(objectMap)
}

// AsCreateJobValidations is the BasicValidationRequest implementation for ValidationRequest.
func (vr ValidationRequest) AsCreateJobValidations() (*CreateJobValidations, bool) {
	return nil, false
}

// AsValidationRequest is the BasicValidationRequest implementation for ValidationRequest.
func (vr ValidationRequest) AsValidationRequest() (*ValidationRequest, bool) {
	return &vr, true
}

// AsBasicValidationRequest is the BasicValidationRequest implementation for ValidationRequest.
func (vr ValidationRequest) AsBasicValidationRequest() (BasicValidationRequest, bool) {
	return &vr, true
}

// UnmarshalJSON is the custom unmarshaler for ValidationRequest struct.
func (vr *ValidationRequest) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "individualRequestDetails":
			if v != nil {
				individualRequestDetails, err := unmarshalBasicValidationInputRequestArray(*v)
				if err != nil {
					return err
				}
				vr.IndividualRequestDetails = &individualRequestDetails
			}
		case "validationCategory":
			if v != nil {
				var validationCategory ValidationCategory
				err = json.Unmarshal(*v, &validationCategory)
				if err != nil {
					return err
				}
				vr.ValidationCategory = validationCategory
			}
		}
	}

	return nil
}

// ValidationResponse response of pre job creation validations.
type ValidationResponse struct {
	autorest.Response `json:"-"`
	// ValidationResponseProperties - READ-ONLY; Properties of pre job creation validation response.
	*ValidationResponseProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for ValidationResponse.
func (vr ValidationResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ValidationResponse struct.
func (vr *ValidationResponse) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var validationResponseProperties ValidationResponseProperties
				err = json.Unmarshal(*v, &validationResponseProperties)
				if err != nil {
					return err
				}
				vr.ValidationResponseProperties = &validationResponseProperties
			}
		}
	}

	return nil
}

// ValidationResponseProperties properties of pre job creation validation response.
type ValidationResponseProperties struct {
	// Status - READ-ONLY; Overall validation status. Possible values include: 'AllValidToProceed', 'InputsRevisitRequired', 'CertainInputValidationsSkipped'
	Status OverallValidationStatus `json:"status,omitempty"`
	// IndividualResponseDetails - READ-ONLY; List of response details contain validationType and its response as key and value respectively.
	IndividualResponseDetails *[]BasicValidationInputResponse `json:"individualResponseDetails,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for ValidationResponseProperties struct.
func (vrp *ValidationResponseProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "status":
			if v != nil {
				var status OverallValidationStatus
				err = json.Unmarshal(*v, &status)
				if err != nil {
					return err
				}
				vrp.Status = status
			}
		case "individualResponseDetails":
			if v != nil {
				individualResponseDetails, err := unmarshalBasicValidationInputResponseArray(*v)
				if err != nil {
					return err
				}
				vrp.IndividualResponseDetails = &individualResponseDetails
			}
		}
	}

	return nil
}
