// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package quicksight

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opCancelIngestion = "CancelIngestion"

// CancelIngestionRequest generates a "aws/request.Request" representing the
// client's request for the CancelIngestion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelIngestion for more information on using the CancelIngestion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CancelIngestionRequest method.
//    req, resp := client.CancelIngestionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CancelIngestion
func (c *QuickSight) CancelIngestionRequest(input *CancelIngestionInput) (req *request.Request, output *CancelIngestionOutput) {
	op := &request.Operation{
		Name:       opCancelIngestion,
		HTTPMethod: "DELETE",
		HTTPPath:   "/accounts/{AwsAccountId}/data-sets/{DataSetId}/ingestions/{IngestionId}",
	}

	if input == nil {
		input = &CancelIngestionInput{}
	}

	output = &CancelIngestionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CancelIngestion API operation for Amazon QuickSight.
//
// Cancels an ongoing ingestion of data into SPICE.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation CancelIngestion for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You don't have access to this. The provided credentials couldn't be validated.
//   You might not be authorized to carry out the request. Ensure that your account
//   is authorized to use the Amazon QuickSight service, that your policies have
//   the correct permissions, and that you are using the correct access keys.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One or more parameters don't have a valid value.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   One or more resources can't be found.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   Access is throttled.
//
//   * ErrCodeResourceExistsException "ResourceExistsException"
//   The resource specified already exists.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CancelIngestion
func (c *QuickSight) CancelIngestion(input *CancelIngestionInput) (*CancelIngestionOutput, error) {
	req, out := c.CancelIngestionRequest(input)
	return out, req.Send()
}

// CancelIngestionWithContext is the same as CancelIngestion with the addition of
// the ability to pass a context and additional request options.
//
// See CancelIngestion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) CancelIngestionWithContext(ctx aws.Context, input *CancelIngestionInput, opts ...request.Option) (*CancelIngestionOutput, error) {
	req, out := c.CancelIngestionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDashboard = "CreateDashboard"

// CreateDashboardRequest generates a "aws/request.Request" representing the
// client's request for the CreateDashboard operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDashboard for more information on using the CreateDashboard
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDashboardRequest method.
//    req, resp := client.CreateDashboardRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateDashboard
func (c *QuickSight) CreateDashboardRequest(input *CreateDashboardInput) (req *request.Request, output *CreateDashboardOutput) {
	op := &request.Operation{
		Name:       opCreateDashboard,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{AwsAccountId}/dashboards/{DashboardId}",
	}

	if input == nil {
		input = &CreateDashboardInput{}
	}

	output = &CreateDashboardOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDashboard API operation for Amazon QuickSight.
//
// Creates a dashboard from a template. To first create a template, see the
// CreateTemplate API.
//
// A dashboard is an entity in QuickSight which identifies Quicksight reports,
// created from analyses. QuickSight dashboards are sharable. With the right
// permissions, you can create scheduled email reports from them. The CreateDashboard,
// DescribeDashboard and ListDashboardsByUser APIs act on the dashboard entity.
// If you have the correct permissions, you can create a dashboard from a template
// that exists in a different AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation CreateDashboard for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   One or more resources can't be found.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One or more parameters don't have a valid value.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   Access is throttled.
//
//   * ErrCodeResourceExistsException "ResourceExistsException"
//   The resource specified already exists.
//
//   * ErrCodeConflictException "ConflictException"
//   Updating or deleting a resource can cause an inconsistent state.
//
//   * ErrCodeUnsupportedUserEditionException "UnsupportedUserEditionException"
//   This error indicates that you are calling an operation on an Amazon QuickSight
//   subscription where the edition doesn't include support for that operation.
//   Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//   Not every operation and capability is available in every edition.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateDashboard
func (c *QuickSight) CreateDashboard(input *CreateDashboardInput) (*CreateDashboardOutput, error) {
	req, out := c.CreateDashboardRequest(input)
	return out, req.Send()
}

// CreateDashboardWithContext is the same as CreateDashboard with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDashboard for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) CreateDashboardWithContext(ctx aws.Context, input *CreateDashboardInput, opts ...request.Option) (*CreateDashboardOutput, error) {
	req, out := c.CreateDashboardRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDataSet = "CreateDataSet"

// CreateDataSetRequest generates a "aws/request.Request" representing the
// client's request for the CreateDataSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDataSet for more information on using the CreateDataSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDataSetRequest method.
//    req, resp := client.CreateDataSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateDataSet
func (c *QuickSight) CreateDataSetRequest(input *CreateDataSetInput) (req *request.Request, output *CreateDataSetOutput) {
	op := &request.Operation{
		Name:       opCreateDataSet,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{AwsAccountId}/data-sets",
	}

	if input == nil {
		input = &CreateDataSetInput{}
	}

	output = &CreateDataSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDataSet API operation for Amazon QuickSight.
//
// Creates a dataset.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation CreateDataSet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You don't have access to this. The provided credentials couldn't be validated.
//   You might not be authorized to carry out the request. Ensure that your account
//   is authorized to use the Amazon QuickSight service, that your policies have
//   the correct permissions, and that you are using the correct access keys.
//
//   * ErrCodeConflictException "ConflictException"
//   Updating or deleting a resource can cause an inconsistent state.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One or more parameters don't have a valid value.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   A limit is exceeded.
//
//   * ErrCodeResourceExistsException "ResourceExistsException"
//   The resource specified already exists.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   One or more resources can't be found.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   Access is throttled.
//
//   * ErrCodeUnsupportedUserEditionException "UnsupportedUserEditionException"
//   This error indicates that you are calling an operation on an Amazon QuickSight
//   subscription where the edition doesn't include support for that operation.
//   Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//   Not every operation and capability is available in every edition.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateDataSet
func (c *QuickSight) CreateDataSet(input *CreateDataSetInput) (*CreateDataSetOutput, error) {
	req, out := c.CreateDataSetRequest(input)
	return out, req.Send()
}

// CreateDataSetWithContext is the same as CreateDataSet with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDataSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) CreateDataSetWithContext(ctx aws.Context, input *CreateDataSetInput, opts ...request.Option) (*CreateDataSetOutput, error) {
	req, out := c.CreateDataSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDataSource = "CreateDataSource"

// CreateDataSourceRequest generates a "aws/request.Request" representing the
// client's request for the CreateDataSource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDataSource for more information on using the CreateDataSource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDataSourceRequest method.
//    req, resp := client.CreateDataSourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateDataSource
func (c *QuickSight) CreateDataSourceRequest(input *CreateDataSourceInput) (req *request.Request, output *CreateDataSourceOutput) {
	op := &request.Operation{
		Name:       opCreateDataSource,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{AwsAccountId}/data-sources",
	}

	if input == nil {
		input = &CreateDataSourceInput{}
	}

	output = &CreateDataSourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDataSource API operation for Amazon QuickSight.
//
// Creates a data source.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation CreateDataSource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You don't have access to this. The provided credentials couldn't be validated.
//   You might not be authorized to carry out the request. Ensure that your account
//   is authorized to use the Amazon QuickSight service, that your policies have
//   the correct permissions, and that you are using the correct access keys.
//
//   * ErrCodeConflictException "ConflictException"
//   Updating or deleting a resource can cause an inconsistent state.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One or more parameters don't have a valid value.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   A limit is exceeded.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   One or more resources can't be found.
//
//   * ErrCodeResourceExistsException "ResourceExistsException"
//   The resource specified already exists.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   Access is throttled.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateDataSource
func (c *QuickSight) CreateDataSource(input *CreateDataSourceInput) (*CreateDataSourceOutput, error) {
	req, out := c.CreateDataSourceRequest(input)
	return out, req.Send()
}

// CreateDataSourceWithContext is the same as CreateDataSource with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDataSource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) CreateDataSourceWithContext(ctx aws.Context, input *CreateDataSourceInput, opts ...request.Option) (*CreateDataSourceOutput, error) {
	req, out := c.CreateDataSourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateGroup = "CreateGroup"

// CreateGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateGroup for more information on using the CreateGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateGroupRequest method.
//    req, resp := client.CreateGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateGroup
func (c *QuickSight) CreateGroupRequest(input *CreateGroupInput) (req *request.Request, output *CreateGroupOutput) {
	op := &request.Operation{
		Name:       opCreateGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/groups",
	}

	if input == nil {
		input = &CreateGroupInput{}
	}

	output = &CreateGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateGroup API operation for Amazon QuickSight.
//
// Creates an Amazon QuickSight group.
//
// The permissions resource is arn:aws:quicksight:us-east-1:<relevant-aws-account-id>:group/default/<group-name> .
//
// The response is a group object.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation CreateGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You don't have access to this. The provided credentials couldn't be validated.
//   You might not be authorized to carry out the request. Ensure that your account
//   is authorized to use the Amazon QuickSight service, that your policies have
//   the correct permissions, and that you are using the correct access keys.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One or more parameters don't have a valid value.
//
//   * ErrCodeResourceExistsException "ResourceExistsException"
//   The resource specified already exists.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   One or more resources can't be found.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   Access is throttled.
//
//   * ErrCodePreconditionNotMetException "PreconditionNotMetException"
//   One or more preconditions aren't met.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   A limit is exceeded.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal failure occurred.
//
//   * ErrCodeResourceUnavailableException "ResourceUnavailableException"
//   This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateGroup
func (c *QuickSight) CreateGroup(input *CreateGroupInput) (*CreateGroupOutput, error) {
	req, out := c.CreateGroupRequest(input)
	return out, req.Send()
}

// CreateGroupWithContext is the same as CreateGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) CreateGroupWithContext(ctx aws.Context, input *CreateGroupInput, opts ...request.Option) (*CreateGroupOutput, error) {
	req, out := c.CreateGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateGroupMembership = "CreateGroupMembership"

// CreateGroupMembershipRequest generates a "aws/request.Request" representing the
// client's request for the CreateGroupMembership operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateGroupMembership for more information on using the CreateGroupMembership
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateGroupMembershipRequest method.
//    req, resp := client.CreateGroupMembershipRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateGroupMembership
func (c *QuickSight) CreateGroupMembershipRequest(input *CreateGroupMembershipInput) (req *request.Request, output *CreateGroupMembershipOutput) {
	op := &request.Operation{
		Name:       opCreateGroupMembership,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/groups/{GroupName}/members/{MemberName}",
	}

	if input == nil {
		input = &CreateGroupMembershipInput{}
	}

	output = &CreateGroupMembershipOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateGroupMembership API operation for Amazon QuickSight.
//
// Adds an Amazon QuickSight user to an Amazon QuickSight group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation CreateGroupMembership for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You don't have access to this. The provided credentials couldn't be validated.
//   You might not be authorized to carry out the request. Ensure that your account
//   is authorized to use the Amazon QuickSight service, that your policies have
//   the correct permissions, and that you are using the correct access keys.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One or more parameters don't have a valid value.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   One or more resources can't be found.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   Access is throttled.
//
//   * ErrCodePreconditionNotMetException "PreconditionNotMetException"
//   One or more preconditions aren't met.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal failure occurred.
//
//   * ErrCodeResourceUnavailableException "ResourceUnavailableException"
//   This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateGroupMembership
func (c *QuickSight) CreateGroupMembership(input *CreateGroupMembershipInput) (*CreateGroupMembershipOutput, error) {
	req, out := c.CreateGroupMembershipRequest(input)
	return out, req.Send()
}

// CreateGroupMembershipWithContext is the same as CreateGroupMembership with the addition of
// the ability to pass a context and additional request options.
//
// See CreateGroupMembership for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) CreateGroupMembershipWithContext(ctx aws.Context, input *CreateGroupMembershipInput, opts ...request.Option) (*CreateGroupMembershipOutput, error) {
	req, out := c.CreateGroupMembershipRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateIAMPolicyAssignment = "CreateIAMPolicyAssignment"

// CreateIAMPolicyAssignmentRequest generates a "aws/request.Request" representing the
// client's request for the CreateIAMPolicyAssignment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateIAMPolicyAssignment for more information on using the CreateIAMPolicyAssignment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateIAMPolicyAssignmentRequest method.
//    req, resp := client.CreateIAMPolicyAssignmentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateIAMPolicyAssignment
func (c *QuickSight) CreateIAMPolicyAssignmentRequest(input *CreateIAMPolicyAssignmentInput) (req *request.Request, output *CreateIAMPolicyAssignmentOutput) {
	op := &request.Operation{
		Name:       opCreateIAMPolicyAssignment,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/iam-policy-assignments/",
	}

	if input == nil {
		input = &CreateIAMPolicyAssignmentInput{}
	}

	output = &CreateIAMPolicyAssignmentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateIAMPolicyAssignment API operation for Amazon QuickSight.
//
// Creates an assignment with one specified IAM policy Amazon Resource Name
// (ARN) and will assigned to specified groups or users of QuickSight. Users
// and groups need to be in the same namespace.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation CreateIAMPolicyAssignment for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You don't have access to this. The provided credentials couldn't be validated.
//   You might not be authorized to carry out the request. Ensure that your account
//   is authorized to use the Amazon QuickSight service, that your policies have
//   the correct permissions, and that you are using the correct access keys.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One or more parameters don't have a valid value.
//
//   * ErrCodeResourceExistsException "ResourceExistsException"
//   The resource specified already exists.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   One or more resources can't be found.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   Access is throttled.
//
//   * ErrCodeConcurrentUpdatingException "ConcurrentUpdatingException"
//   A resource is already in an "actionable" state that must complete before
//   a new update can be applied.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateIAMPolicyAssignment
func (c *QuickSight) CreateIAMPolicyAssignment(input *CreateIAMPolicyAssignmentInput) (*CreateIAMPolicyAssignmentOutput, error) {
	req, out := c.CreateIAMPolicyAssignmentRequest(input)
	return out, req.Send()
}

// CreateIAMPolicyAssignmentWithContext is the same as CreateIAMPolicyAssignment with the addition of
// the ability to pass a context and additional request options.
//
// See CreateIAMPolicyAssignment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) CreateIAMPolicyAssignmentWithContext(ctx aws.Context, input *CreateIAMPolicyAssignmentInput, opts ...request.Option) (*CreateIAMPolicyAssignmentOutput, error) {
	req, out := c.CreateIAMPolicyAssignmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateIngestion = "CreateIngestion"

// CreateIngestionRequest generates a "aws/request.Request" representing the
// client's request for the CreateIngestion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateIngestion for more information on using the CreateIngestion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateIngestionRequest method.
//    req, resp := client.CreateIngestionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateIngestion
func (c *QuickSight) CreateIngestionRequest(input *CreateIngestionInput) (req *request.Request, output *CreateIngestionOutput) {
	op := &request.Operation{
		Name:       opCreateIngestion,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{AwsAccountId}/data-sets/{DataSetId}/ingestions/{IngestionId}",
	}

	if input == nil {
		input = &CreateIngestionInput{}
	}

	output = &CreateIngestionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateIngestion API operation for Amazon QuickSight.
//
// Creates and starts a new SPICE ingestion on a dataset
//
// Any ingestions operating on tagged datasets inherit the same tags automatically
// for use in access control. For an example, see How do I create an IAM policy
// to control access to Amazon EC2 resources using tags? (https://aws.example.com/premiumsupport/knowledge-center/iam-ec2-resource-tags/)
// in the AWS Knowledge Center. Tags are visible on the tagged dataset, but
// not on the ingestion resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation CreateIngestion for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You don't have access to this. The provided credentials couldn't be validated.
//   You might not be authorized to carry out the request. Ensure that your account
//   is authorized to use the Amazon QuickSight service, that your policies have
//   the correct permissions, and that you are using the correct access keys.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One or more parameters don't have a valid value.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   One or more resources can't be found.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   Access is throttled.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   A limit is exceeded.
//
//   * ErrCodeResourceExistsException "ResourceExistsException"
//   The resource specified already exists.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateIngestion
func (c *QuickSight) CreateIngestion(input *CreateIngestionInput) (*CreateIngestionOutput, error) {
	req, out := c.CreateIngestionRequest(input)
	return out, req.Send()
}

// CreateIngestionWithContext is the same as CreateIngestion with the addition of
// the ability to pass a context and additional request options.
//
// See CreateIngestion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) CreateIngestionWithContext(ctx aws.Context, input *CreateIngestionInput, opts ...request.Option) (*CreateIngestionOutput, error) {
	req, out := c.CreateIngestionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTemplate = "CreateTemplate"

// CreateTemplateRequest generates a "aws/request.Request" representing the
// client's request for the CreateTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTemplate for more information on using the CreateTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateTemplateRequest method.
//    req, resp := client.CreateTemplateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateTemplate
func (c *QuickSight) CreateTemplateRequest(input *CreateTemplateInput) (req *request.Request, output *CreateTemplateOutput) {
	op := &request.Operation{
		Name:       opCreateTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{AwsAccountId}/templates/{TemplateId}",
	}

	if input == nil {
		input = &CreateTemplateInput{}
	}

	output = &CreateTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateTemplate API operation for Amazon QuickSight.
//
// Creates a template from an existing QuickSight analysis or template. The
// resulting template can be used to create a dashboard.
//
// A template is an entity in QuickSight which encapsulates the metadata required
// to create an analysis that can be used to create dashboard. It adds a layer
// of abstraction by use placeholders to replace the dataset associated with
// the analysis. You can use templates to create dashboards by replacing dataset
// placeholders with datasets which follow the same schema that was used to
// create the source analysis and template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation CreateTemplate for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One or more parameters don't have a valid value.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You don't have access to this. The provided credentials couldn't be validated.
//   You might not be authorized to carry out the request. Ensure that your account
//   is authorized to use the Amazon QuickSight service, that your policies have
//   the correct permissions, and that you are using the correct access keys.
//
//   * ErrCodeResourceExistsException "ResourceExistsException"
//   The resource specified already exists.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   One or more resources can't be found.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   Access is throttled.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   A limit is exceeded.
//
//   * ErrCodeUnsupportedUserEditionException "UnsupportedUserEditionException"
//   This error indicates that you are calling an operation on an Amazon QuickSight
//   subscription where the edition doesn't include support for that operation.
//   Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//   Not every operation and capability is available in every edition.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateTemplate
func (c *QuickSight) CreateTemplate(input *CreateTemplateInput) (*CreateTemplateOutput, error) {
	req, out := c.CreateTemplateRequest(input)
	return out, req.Send()
}

// CreateTemplateWithContext is the same as CreateTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) CreateTemplateWithContext(ctx aws.Context, input *CreateTemplateInput, opts ...request.Option) (*CreateTemplateOutput, error) {
	req, out := c.CreateTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTemplateAlias = "CreateTemplateAlias"

// CreateTemplateAliasRequest generates a "aws/request.Request" representing the
// client's request for the CreateTemplateAlias operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTemplateAlias for more information on using the CreateTemplateAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateTemplateAliasRequest method.
//    req, resp := client.CreateTemplateAliasRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateTemplateAlias
func (c *QuickSight) CreateTemplateAliasRequest(input *CreateTemplateAliasInput) (req *request.Request, output *CreateTemplateAliasOutput) {
	op := &request.Operation{
		Name:       opCreateTemplateAlias,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{AwsAccountId}/templates/{TemplateId}/aliases/{AliasName}",
	}

	if input == nil {
		input = &CreateTemplateAliasInput{}
	}

	output = &CreateTemplateAliasOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateTemplateAlias API operation for Amazon QuickSight.
//
// Creates a template alias for a template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation CreateTemplateAlias for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeThrottlingException "ThrottlingException"
//   Access is throttled.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   One or more resources can't be found.
//
//   * ErrCodeConflictException "ConflictException"
//   Updating or deleting a resource can cause an inconsistent state.
//
//   * ErrCodeResourceExistsException "ResourceExistsException"
//   The resource specified already exists.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   A limit is exceeded.
//
//   * ErrCodeUnsupportedUserEditionException "UnsupportedUserEditionException"
//   This error indicates that you are calling an operation on an Amazon QuickSight
//   subscription where the edition doesn't include support for that operation.
//   Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//   Not every operation and capability is available in every edition.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateTemplateAlias
func (c *QuickSight) CreateTemplateAlias(input *CreateTemplateAliasInput) (*CreateTemplateAliasOutput, error) {
	req, out := c.CreateTemplateAliasRequest(input)
	return out, req.Send()
}

// CreateTemplateAliasWithContext is the same as CreateTemplateAlias with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTemplateAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) CreateTemplateAliasWithContext(ctx aws.Context, input *CreateTemplateAliasInput, opts ...request.Option) (*CreateTemplateAliasOutput, error) {
	req, out := c.CreateTemplateAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDashboard = "DeleteDashboard"

// DeleteDashboardRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDashboard operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDashboard for more information on using the DeleteDashboard
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDashboardRequest method.
//    req, resp := client.DeleteDashboardRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteDashboard
func (c *QuickSight) DeleteDashboardRequest(input *DeleteDashboardInput) (req *request.Request, output *DeleteDashboardOutput) {
	op := &request.Operation{
		Name:       opDeleteDashboard,
		HTTPMethod: "DELETE",
		HTTPPath:   "/accounts/{AwsAccountId}/dashboards/{DashboardId}",
	}

	if input == nil {
		input = &DeleteDashboardInput{}
	}

	output = &DeleteDashboardOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteDashboard API operation for Amazon QuickSight.
//
// Deletes a dashboard.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DeleteDashboard for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeThrottlingException "ThrottlingException"
//   Access is throttled.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One or more parameters don't have a valid value.
//
//   * ErrCodeConflictException "ConflictException"
//   Updating or deleting a resource can cause an inconsistent state.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   One or more resources can't be found.
//
//   * ErrCodeUnsupportedUserEditionException "UnsupportedUserEditionException"
//   This error indicates that you are calling an operation on an Amazon QuickSight
//   subscription where the edition doesn't include support for that operation.
//   Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//   Not every operation and capability is available in every edition.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteDashboard
func (c *QuickSight) DeleteDashboard(input *DeleteDashboardInput) (*DeleteDashboardOutput, error) {
	req, out := c.DeleteDashboardRequest(input)
	return out, req.Send()
}

// DeleteDashboardWithContext is the same as DeleteDashboard with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDashboard for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DeleteDashboardWithContext(ctx aws.Context, input *DeleteDashboardInput, opts ...request.Option) (*DeleteDashboardOutput, error) {
	req, out := c.DeleteDashboardRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDataSet = "DeleteDataSet"

// DeleteDataSetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDataSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDataSet for more information on using the DeleteDataSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDataSetRequest method.
//    req, resp := client.DeleteDataSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteDataSet
func (c *QuickSight) DeleteDataSetRequest(input *DeleteDataSetInput) (req *request.Request, output *DeleteDataSetOutput) {
	op := &request.Operation{
		Name:       opDeleteDataSet,
		HTTPMethod: "DELETE",
		HTTPPath:   "/accounts/{AwsAccountId}/data-sets/{DataSetId}",
	}

	if input == nil {
		input = &DeleteDataSetInput{}
	}

	output = &DeleteDataSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteDataSet API operation for Amazon QuickSight.
//
// Deletes a dataset.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DeleteDataSet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You don't have access to this. The provided credentials couldn't be validated.
//   You might not be authorized to carry out the request. Ensure that your account
//   is authorized to use the Amazon QuickSight service, that your policies have
//   the correct permissions, and that you are using the correct access keys.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One or more parameters don't have a valid value.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   Access is throttled.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   One or more resources can't be found.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteDataSet
func (c *QuickSight) DeleteDataSet(input *DeleteDataSetInput) (*DeleteDataSetOutput, error) {
	req, out := c.DeleteDataSetRequest(input)
	return out, req.Send()
}

// DeleteDataSetWithContext is the same as DeleteDataSet with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDataSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DeleteDataSetWithContext(ctx aws.Context, input *DeleteDataSetInput, opts ...request.Option) (*DeleteDataSetOutput, error) {
	req, out := c.DeleteDataSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDataSource = "DeleteDataSource"

// DeleteDataSourceRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDataSource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDataSource for more information on using the DeleteDataSource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDataSourceRequest method.
//    req, resp := client.DeleteDataSourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteDataSource
func (c *QuickSight) DeleteDataSourceRequest(input *DeleteDataSourceInput) (req *request.Request, output *DeleteDataSourceOutput) {
	op := &request.Operation{
		Name:       opDeleteDataSource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/accounts/{AwsAccountId}/data-sources/{DataSourceId}",
	}

	if input == nil {
		input = &DeleteDataSourceInput{}
	}

	output = &DeleteDataSourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteDataSource API operation for Amazon QuickSight.
//
// Deletes the data source permanently. This action breaks all the datasets
// that reference the deleted data source.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DeleteDataSource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You don't have access to this. The provided credentials couldn't be validated.
//   You might not be authorized to carry out the request. Ensure that your account
//   is authorized to use the Amazon QuickSight service, that your policies have
//   the correct permissions, and that you are using the correct access keys.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One or more parameters don't have a valid value.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   Access is throttled.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   One or more resources can't be found.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteDataSource
func (c *QuickSight) DeleteDataSource(input *DeleteDataSourceInput) (*DeleteDataSourceOutput, error) {
	req, out := c.DeleteDataSourceRequest(input)
	return out, req.Send()
}

// DeleteDataSourceWithContext is the same as DeleteDataSource with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDataSource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DeleteDataSourceWithContext(ctx aws.Context, input *DeleteDataSourceInput, opts ...request.Option) (*DeleteDataSourceOutput, error) {
	req, out := c.DeleteDataSourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteGroup = "DeleteGroup"

// DeleteGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteGroup for more information on using the DeleteGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteGroupRequest method.
//    req, resp := client.DeleteGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteGroup
func (c *QuickSight) DeleteGroupRequest(input *DeleteGroupInput) (req *request.Request, output *DeleteGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteGroup,
		HTTPMethod: "DELETE",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/groups/{GroupName}",
	}

	if input == nil {
		input = &DeleteGroupInput{}
	}

	output = &DeleteGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteGroup API operation for Amazon QuickSight.
//
// Removes a user group from Amazon QuickSight.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DeleteGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You don't have access to this. The provided credentials couldn't be validated.
//   You might not be authorized to carry out the request. Ensure that your account
//   is authorized to use the Amazon QuickSight service, that your policies have
//   the correct permissions, and that you are using the correct access keys.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One or more parameters don't have a valid value.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   One or more resources can't be found.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   Access is throttled.
//
//   * ErrCodePreconditionNotMetException "PreconditionNotMetException"
//   One or more preconditions aren't met.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal failure occurred.
//
//   * ErrCodeResourceUnavailableException "ResourceUnavailableException"
//   This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteGroup
func (c *QuickSight) DeleteGroup(input *DeleteGroupInput) (*DeleteGroupOutput, error) {
	req, out := c.DeleteGroupRequest(input)
	return out, req.Send()
}

// DeleteGroupWithContext is the same as DeleteGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DeleteGroupWithContext(ctx aws.Context, input *DeleteGroupInput, opts ...request.Option) (*DeleteGroupOutput, error) {
	req, out := c.DeleteGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteGroupMembership = "DeleteGroupMembership"

// DeleteGroupMembershipRequest generates a "aws/request.Request" representing the
// client's request for the DeleteGroupMembership operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteGroupMembership for more information on using the DeleteGroupMembership
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteGroupMembershipRequest method.
//    req, resp := client.DeleteGroupMembershipRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteGroupMembership
func (c *QuickSight) DeleteGroupMembershipRequest(input *DeleteGroupMembershipInput) (req *request.Request, output *DeleteGroupMembershipOutput) {
	op := &request.Operation{
		Name:       opDeleteGroupMembership,
		HTTPMethod: "DELETE",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/groups/{GroupName}/members/{MemberName}",
	}

	if input == nil {
		input = &DeleteGroupMembershipInput{}
	}

	output = &DeleteGroupMembershipOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteGroupMembership API operation for Amazon QuickSight.
//
// Removes a user from a group so that the user is no longer a member of the
// group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DeleteGroupMembership for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You don't have access to this. The provided credentials couldn't be validated.
//   You might not be authorized to carry out the request. Ensure that your account
//   is authorized to use the Amazon QuickSight service, that your policies have
//   the correct permissions, and that you are using the correct access keys.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One or more parameters don't have a valid value.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   One or more resources can't be found.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   Access is throttled.
//
//   * ErrCodePreconditionNotMetException "PreconditionNotMetException"
//   One or more preconditions aren't met.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal failure occurred.
//
//   * ErrCodeResourceUnavailableException "ResourceUnavailableException"
//   This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteGroupMembership
func (c *QuickSight) DeleteGroupMembership(input *DeleteGroupMembershipInput) (*DeleteGroupMembershipOutput, error) {
	req, out := c.DeleteGroupMembershipRequest(input)
	return out, req.Send()
}

// DeleteGroupMembershipWithContext is the same as DeleteGroupMembership with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteGroupMembership for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DeleteGroupMembershipWithContext(ctx aws.Context, input *DeleteGroupMembershipInput, opts ...request.Option) (*DeleteGroupMembershipOutput, error) {
	req, out := c.DeleteGroupMembershipRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteIAMPolicyAssignment = "DeleteIAMPolicyAssignment"

// DeleteIAMPolicyAssignmentRequest generates a "aws/request.Request" representing the
// client's request for the DeleteIAMPolicyAssignment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteIAMPolicyAssignment for more information on using the DeleteIAMPolicyAssignment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteIAMPolicyAssignmentRequest method.
//    req, resp := client.DeleteIAMPolicyAssignmentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteIAMPolicyAssignment
func (c *QuickSight) DeleteIAMPolicyAssignmentRequest(input *DeleteIAMPolicyAssignmentInput) (req *request.Request, output *DeleteIAMPolicyAssignmentOutput) {
	op := &request.Operation{
		Name:       opDeleteIAMPolicyAssignment,
		HTTPMethod: "DELETE",
		HTTPPath:   "/accounts/{AwsAccountId}/namespace/{Namespace}/iam-policy-assignments/{AssignmentName}",
	}

	if input == nil {
		input = &DeleteIAMPolicyAssignmentInput{}
	}

	output = &DeleteIAMPolicyAssignmentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteIAMPolicyAssignment API operation for Amazon QuickSight.
//
// Deletes an existing assignment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DeleteIAMPolicyAssignment for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You don't have access to this. The provided credentials couldn't be validated.
//   You might not be authorized to carry out the request. Ensure that your account
//   is authorized to use the Amazon QuickSight service, that your policies have
//   the correct permissions, and that you are using the correct access keys.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One or more parameters don't have a valid value.
//
//   * ErrCodeResourceExistsException "ResourceExistsException"
//   The resource specified already exists.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   One or more resources can't be found.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   Access is throttled.
//
//   * ErrCodeConcurrentUpdatingException "ConcurrentUpdatingException"
//   A resource is already in an "actionable" state that must complete before
//   a new update can be applied.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteIAMPolicyAssignment
func (c *QuickSight) DeleteIAMPolicyAssignment(input *DeleteIAMPolicyAssignmentInput) (*DeleteIAMPolicyAssignmentOutput, error) {
	req, out := c.DeleteIAMPolicyAssignmentRequest(input)
	return out, req.Send()
}

// DeleteIAMPolicyAssignmentWithContext is the same as DeleteIAMPolicyAssignment with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteIAMPolicyAssignment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DeleteIAMPolicyAssignmentWithContext(ctx aws.Context, input *DeleteIAMPolicyAssignmentInput, opts ...request.Option) (*DeleteIAMPolicyAssignmentOutput, error) {
	req, out := c.DeleteIAMPolicyAssignmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTemplate = "DeleteTemplate"

// DeleteTemplateRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTemplate for more information on using the DeleteTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteTemplateRequest method.
//    req, resp := client.DeleteTemplateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteTemplate
func (c *QuickSight) DeleteTemplateRequest(input *DeleteTemplateInput) (req *request.Request, output *DeleteTemplateOutput) {
	op := &request.Operation{
		Name:       opDeleteTemplate,
		HTTPMethod: "DELETE",
		HTTPPath:   "/accounts/{AwsAccountId}/templates/{TemplateId}",
	}

	if input == nil {
		input = &DeleteTemplateInput{}
	}

	output = &DeleteTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteTemplate API operation for Amazon QuickSight.
//
// Deletes a template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DeleteTemplate for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One or more parameters don't have a valid value.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   One or more resources can't be found.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   Access is throttled.
//
//   * ErrCodeConflictException "ConflictException"
//   Updating or deleting a resource can cause an inconsistent state.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   A limit is exceeded.
//
//   * ErrCodeUnsupportedUserEditionException "UnsupportedUserEditionException"
//   This error indicates that you are calling an operation on an Amazon QuickSight
//   subscription where the edition doesn't include support for that operation.
//   Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//   Not every operation and capability is available in every edition.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteTemplate
func (c *QuickSight) DeleteTemplate(input *DeleteTemplateInput) (*DeleteTemplateOutput, error) {
	req, out := c.DeleteTemplateRequest(input)
	return out, req.Send()
}

// DeleteTemplateWithContext is the same as DeleteTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DeleteTemplateWithContext(ctx aws.Context, input *DeleteTemplateInput, opts ...request.Option) (*DeleteTemplateOutput, error) {
	req, out := c.DeleteTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTemplateAlias = "DeleteTemplateAlias"

// DeleteTemplateAliasRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTemplateAlias operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTemplateAlias for more information on using the DeleteTemplateAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteTemplateAliasRequest method.
//    req, resp := client.DeleteTemplateAliasRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteTemplateAlias
func (c *QuickSight) DeleteTemplateAliasRequest(input *DeleteTemplateAliasInput) (req *request.Request, output *DeleteTemplateAliasOutput) {
	op := &request.Operation{
		Name:       opDeleteTemplateAlias,
		HTTPMethod: "DELETE",
		HTTPPath:   "/accounts/{AwsAccountId}/templates/{TemplateId}/aliases/{AliasName}",
	}

	if input == nil {
		input = &DeleteTemplateAliasInput{}
	}

	output = &DeleteTemplateAliasOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteTemplateAlias API operation for Amazon QuickSight.
//
// Update template alias of given template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DeleteTemplateAlias for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeThrottlingException "ThrottlingException"
//   Access is throttled.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   One or more resources can't be found.
//
//   * ErrCodeUnsupportedUserEditionException "UnsupportedUserEditionException"
//   This error indicates that you are calling an operation on an Amazon QuickSight
//   subscription where the edition doesn't include support for that operation.
//   Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//   Not every operation and capability is available in every edition.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteTemplateAlias
func (c *QuickSight) DeleteTemplateAlias(input *DeleteTemplateAliasInput) (*DeleteTemplateAliasOutput, error) {
	req, out := c.DeleteTemplateAliasRequest(input)
	return out, req.Send()
}

// DeleteTemplateAliasWithContext is the same as DeleteTemplateAlias with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTemplateAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DeleteTemplateAliasWithContext(ctx aws.Context, input *DeleteTemplateAliasInput, opts ...request.Option) (*DeleteTemplateAliasOutput, error) {
	req, out := c.DeleteTemplateAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteUser = "DeleteUser"

// DeleteUserRequest generates a "aws/request.Request" representing the
// client's request for the DeleteUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteUser for more information on using the DeleteUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteUserRequest method.
//    req, resp := client.DeleteUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteUser
func (c *QuickSight) DeleteUserRequest(input *DeleteUserInput) (req *request.Request, output *DeleteUserOutput) {
	op := &request.Operation{
		Name:       opDeleteUser,
		HTTPMethod: "DELETE",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/users/{UserName}",
	}

	if input == nil {
		input = &DeleteUserInput{}
	}

	output = &DeleteUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteUser API operation for Amazon QuickSight.
//
// Deletes the Amazon QuickSight user that is associated with the identity of
// the AWS Identity and Access Management (IAM) user or role that's making the
// call. The IAM user isn't deleted as a result of this call.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DeleteUser for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You don't have access to this. The provided credentials couldn't be validated.
//   You might not be authorized to carry out the request. Ensure that your account
//   is authorized to use the Amazon QuickSight service, that your policies have
//   the correct permissions, and that you are using the correct access keys.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One or more parameters don't have a valid value.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   One or more resources can't be found.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   Access is throttled.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal failure occurred.
//
//   * ErrCodeResourceUnavailableException "ResourceUnavailableException"
//   This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteUser
func (c *QuickSight) DeleteUser(input *DeleteUserInput) (*DeleteUserOutput, error) {
	req, out := c.DeleteUserRequest(input)
	return out, req.Send()
}

// DeleteUserWithContext is the same as DeleteUser with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DeleteUserWithContext(ctx aws.Context, input *DeleteUserInput, opts ...request.Option) (*DeleteUserOutput, error) {
	req, out := c.DeleteUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteUserByPrincipalId = "DeleteUserByPrincipalId"

// DeleteUserByPrincipalIdRequest generates a "aws/request.Request" representing the
// client's request for the DeleteUserByPrincipalId operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteUserByPrincipalId for more information on using the DeleteUserByPrincipalId
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteUserByPrincipalIdRequest method.
//    req, resp := client.DeleteUserByPrincipalIdRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteUserByPrincipalId
func (c *QuickSight) DeleteUserByPrincipalIdRequest(input *DeleteUserByPrincipalIdInput) (req *request.Request, output *DeleteUserByPrincipalIdOutput) {
	op := &request.Operation{
		Name:       opDeleteUserByPrincipalId,
		HTTPMethod: "DELETE",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/user-principals/{PrincipalId}",
	}

	if input == nil {
		input = &DeleteUserByPrincipalIdInput{}
	}

	output = &DeleteUserByPrincipalIdOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteUserByPrincipalId API operation for Amazon QuickSight.
//
// Deletes a user identified by its principal ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DeleteUserByPrincipalId for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You don't have access to this. The provided credentials couldn't be validated.
//   You might not be authorized to carry out the request. Ensure that your account
//   is authorized to use the Amazon QuickSight service, that your policies have
//   the correct permissions, and that you are using the correct access keys.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One or more parameters don't have a valid value.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   One or more resources can't be found.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   Access is throttled.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal failure occurred.
//
//   * ErrCodeResourceUnavailableException "ResourceUnavailableException"
//   This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteUserByPrincipalId
func (c *QuickSight) DeleteUserByPrincipalId(input *DeleteUserByPrincipalIdInput) (*DeleteUserByPrincipalIdOutput, error) {
	req, out := c.DeleteUserByPrincipalIdRequest(input)
	return out, req.Send()
}

// DeleteUserByPrincipalIdWithContext is the same as DeleteUserByPrincipalId with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteUserByPrincipalId for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DeleteUserByPrincipalIdWithContext(ctx aws.Context, input *DeleteUserByPrincipalIdInput, opts ...request.Option) (*DeleteUserByPrincipalIdOutput, error) {
	req, out := c.DeleteUserByPrincipalIdRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDashboard = "DescribeDashboard"

// DescribeDashboardRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDashboard operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDashboard for more information on using the DescribeDashboard
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDashboardRequest method.
//    req, resp := client.DescribeDashboardRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDashboard
func (c *QuickSight) DescribeDashboardRequest(input *DescribeDashboardInput) (req *request.Request, output *DescribeDashboardOutput) {
	op := &request.Operation{
		Name:       opDescribeDashboard,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/dashboards/{DashboardId}",
	}

	if input == nil {
		input = &DescribeDashboardInput{}
	}

	output = &DescribeDashboardOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDashboard API operation for Amazon QuickSight.
//
// Provides a summary for a dashboard.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeDashboard for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One or more parameters don't have a valid value.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   One or more resources can't be found.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You don't have access to this. The provided credentials couldn't be validated.
//   You might not be authorized to carry out the request. Ensure that your account
//   is authorized to use the Amazon QuickSight service, that your policies have
//   the correct permissions, and that you are using the correct access keys.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   Access is throttled.
//
//   * ErrCodeUnsupportedUserEditionException "UnsupportedUserEditionException"
//   This error indicates that you are calling an operation on an Amazon QuickSight
//   subscription where the edition doesn't include support for that operation.
//   Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//   Not every operation and capability is available in every edition.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDashboard
func (c *QuickSight) DescribeDashboard(input *DescribeDashboardInput) (*DescribeDashboardOutput, error) {
	req, out := c.DescribeDashboardRequest(input)
	return out, req.Send()
}

// DescribeDashboardWithContext is the same as DescribeDashboard with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDashboard for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeDashboardWithContext(ctx aws.Context, input *DescribeDashboardInput, opts ...request.Option) (*DescribeDashboardOutput, error) {
	req, out := c.DescribeDashboardRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDashboardPermissions = "DescribeDashboardPermissions"

// DescribeDashboardPermissionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDashboardPermissions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDashboardPermissions for more information on using the DescribeDashboardPermissions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDashboardPermissionsRequest method.
//    req, resp := client.DescribeDashboardPermissionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDashboardPermissions
func (c *QuickSight) DescribeDashboardPermissionsRequest(input *DescribeDashboardPermissionsInput) (req *request.Request, output *DescribeDashboardPermissionsOutput) {
	op := &request.Operation{
		Name:       opDescribeDashboardPermissions,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/dashboards/{DashboardId}/permissions",
	}

	if input == nil {
		input = &DescribeDashboardPermissionsInput{}
	}

	output = &DescribeDashboardPermissionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDashboardPermissions API operation for Amazon QuickSight.
//
// Describes read and write permissions on a dashboard.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeDashboardPermissions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One or more parameters don't have a valid value.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   One or more resources can't be found.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   Access is throttled.
//
//   * ErrCodeUnsupportedUserEditionException "UnsupportedUserEditionException"
//   This error indicates that you are calling an operation on an Amazon QuickSight
//   subscription where the edition doesn't include support for that operation.
//   Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//   Not every operation and capability is available in every edition.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDashboardPermissions
func (c *QuickSight) DescribeDashboardPermissions(input *DescribeDashboardPermissionsInput) (*DescribeDashboardPermissionsOutput, error) {
	req, out := c.DescribeDashboardPermissionsRequest(input)
	return out, req.Send()
}

// DescribeDashboardPermissionsWithContext is the same as DescribeDashboardPermissions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDashboardPermissions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeDashboardPermissionsWithContext(ctx aws.Context, input *DescribeDashboardPermissionsInput, opts ...request.Option) (*DescribeDashboardPermissionsOutput, error) {
	req, out := c.DescribeDashboardPermissionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDataSet = "DescribeDataSet"

// DescribeDataSetRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDataSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDataSet for more information on using the DescribeDataSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDataSetRequest method.
//    req, resp := client.DescribeDataSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDataSet
func (c *QuickSight) DescribeDataSetRequest(input *DescribeDataSetInput) (req *request.Request, output *DescribeDataSetOutput) {
	op := &request.Operation{
		Name:       opDescribeDataSet,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/data-sets/{DataSetId}",
	}

	if input == nil {
		input = &DescribeDataSetInput{}
	}

	output = &DescribeDataSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDataSet API operation for Amazon QuickSight.
//
// Describes a dataset.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeDataSet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You don't have access to this. The provided credentials couldn't be validated.
//   You might not be authorized to carry out the request. Ensure that your account
//   is authorized to use the Amazon QuickSight service, that your policies have
//   the correct permissions, and that you are using the correct access keys.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One or more parameters don't have a valid value.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   Access is throttled.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   One or more resources can't be found.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDataSet
func (c *QuickSight) DescribeDataSet(input *DescribeDataSetInput) (*DescribeDataSetOutput, error) {
	req, out := c.DescribeDataSetRequest(input)
	return out, req.Send()
}

// DescribeDataSetWithContext is the same as DescribeDataSet with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDataSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeDataSetWithContext(ctx aws.Context, input *DescribeDataSetInput, opts ...request.Option) (*DescribeDataSetOutput, error) {
	req, out := c.DescribeDataSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDataSetPermissions = "DescribeDataSetPermissions"

// DescribeDataSetPermissionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDataSetPermissions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDataSetPermissions for more information on using the DescribeDataSetPermissions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDataSetPermissionsRequest method.
//    req, resp := client.DescribeDataSetPermissionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDataSetPermissions
func (c *QuickSight) DescribeDataSetPermissionsRequest(input *DescribeDataSetPermissionsInput) (req *request.Request, output *DescribeDataSetPermissionsOutput) {
	op := &request.Operation{
		Name:       opDescribeDataSetPermissions,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/data-sets/{DataSetId}/permissions",
	}

	if input == nil {
		input = &DescribeDataSetPermissionsInput{}
	}

	output = &DescribeDataSetPermissionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDataSetPermissions API operation for Amazon QuickSight.
//
// Describes the permissions on a dataset.
//
// The permissions resource is arn:aws:quicksight:region:aws-account-id:dataset/data-set-id.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeDataSetPermissions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You don't have access to this. The provided credentials couldn't be validated.
//   You might not be authorized to carry out the request. Ensure that your account
//   is authorized to use the Amazon QuickSight service, that your policies have
//   the correct permissions, and that you are using the correct access keys.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One or more parameters don't have a valid value.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   Access is throttled.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   One or more resources can't be found.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDataSetPermissions
func (c *QuickSight) DescribeDataSetPermissions(input *DescribeDataSetPermissionsInput) (*DescribeDataSetPermissionsOutput, error) {
	req, out := c.DescribeDataSetPermissionsRequest(input)
	return out, req.Send()
}

// DescribeDataSetPermissionsWithContext is the same as DescribeDataSetPermissions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDataSetPermissions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeDataSetPermissionsWithContext(ctx aws.Context, input *DescribeDataSetPermissionsInput, opts ...request.Option) (*DescribeDataSetPermissionsOutput, error) {
	req, out := c.DescribeDataSetPermissionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDataSource = "DescribeDataSource"

// DescribeDataSourceRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDataSource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDataSource for more information on using the DescribeDataSource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDataSourceRequest method.
//    req, resp := client.DescribeDataSourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDataSource
func (c *QuickSight) DescribeDataSourceRequest(input *DescribeDataSourceInput) (req *request.Request, output *DescribeDataSourceOutput) {
	op := &request.Operation{
		Name:       opDescribeDataSource,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/data-sources/{DataSourceId}",
	}

	if input == nil {
		input = &DescribeDataSourceInput{}
	}

	output = &DescribeDataSourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDataSource API operation for Amazon QuickSight.
//
// Describes a data source.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeDataSource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You don't have access to this. The provided credentials couldn't be validated.
//   You might not be authorized to carry out the request. Ensure that your account
//   is authorized to use the Amazon QuickSight service, that your policies have
//   the correct permissions, and that you are using the correct access keys.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One or more parameters don't have a valid value.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   Access is throttled.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   One or more resources can't be found.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDataSource
func (c *QuickSight) DescribeDataSource(input *DescribeDataSourceInput) (*DescribeDataSourceOutput, error) {
	req, out := c.DescribeDataSourceRequest(input)
	return out, req.Send()
}

// DescribeDataSourceWithContext is the same as DescribeDataSource with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDataSource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeDataSourceWithContext(ctx aws.Context, input *DescribeDataSourceInput, opts ...request.Option) (*DescribeDataSourceOutput, error) {
	req, out := c.DescribeDataSourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDataSourcePermissions = "DescribeDataSourcePermissions"

// DescribeDataSourcePermissionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDataSourcePermissions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDataSourcePermissions for more information on using the DescribeDataSourcePermissions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDataSourcePermissionsRequest method.
//    req, resp := client.DescribeDataSourcePermissionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDataSourcePermissions
func (c *QuickSight) DescribeDataSourcePermissionsRequest(input *DescribeDataSourcePermissionsInput) (req *request.Request, output *DescribeDataSourcePermissionsOutput) {
	op := &request.Operation{
		Name:       opDescribeDataSourcePermissions,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/data-sources/{DataSourceId}/permissions",
	}

	if input == nil {
		input = &DescribeDataSourcePermissionsInput{}
	}

	output = &DescribeDataSourcePermissionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDataSourcePermissions API operation for Amazon QuickSight.
//
// Describes the resource permissions for a data source.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeDataSourcePermissions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You don't have access to this. The provided credentials couldn't be validated.
//   You might not be authorized to carry out the request. Ensure that your account
//   is authorized to use the Amazon QuickSight service, that your policies have
//   the correct permissions, and that you are using the correct access keys.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One or more parameters don't have a valid value.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   Access is throttled.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   One or more resources can't be found.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDataSourcePermissions
func (c *QuickSight) DescribeDataSourcePermissions(input *DescribeDataSourcePermissionsInput) (*DescribeDataSourcePermissionsOutput, error) {
	req, out := c.DescribeDataSourcePermissionsRequest(input)
	return out, req.Send()
}

// DescribeDataSourcePermissionsWithContext is the same as DescribeDataSourcePermissions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDataSourcePermissions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeDataSourcePermissionsWithContext(ctx aws.Context, input *DescribeDataSourcePermissionsInput, opts ...request.Option) (*DescribeDataSourcePermissionsOutput, error) {
	req, out := c.DescribeDataSourcePermissionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeGroup = "DescribeGroup"

// DescribeGroupRequest generates a "aws/request.Request" representing the
// client's request for the DescribeGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeGroup for more information on using the DescribeGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeGroupRequest method.
//    req, resp := client.DescribeGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeGroup
func (c *QuickSight) DescribeGroupRequest(input *DescribeGroupInput) (req *request.Request, output *DescribeGroupOutput) {
	op := &request.Operation{
		Name:       opDescribeGroup,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/groups/{GroupName}",
	}

	if input == nil {
		input = &DescribeGroupInput{}
	}

	output = &DescribeGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeGroup API operation for Amazon QuickSight.
//
// Returns an Amazon QuickSight group's description and Amazon Resource Name
// (ARN).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You don't have access to this. The provided credentials couldn't be validated.
//   You might not be authorized to carry out the request. Ensure that your account
//   is authorized to use the Amazon QuickSight service, that your policies have
//   the correct permissions, and that you are using the correct access keys.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One or more parameters don't have a valid value.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   One or more resources can't be found.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   Access is throttled.
//
//   * ErrCodePreconditionNotMetException "PreconditionNotMetException"
//   One or more preconditions aren't met.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal failure occurred.
//
//   * ErrCodeResourceUnavailableException "ResourceUnavailableException"
//   This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeGroup
func (c *QuickSight) DescribeGroup(input *DescribeGroupInput) (*DescribeGroupOutput, error) {
	req, out := c.DescribeGroupRequest(input)
	return out, req.Send()
}

// DescribeGroupWithContext is the same as DescribeGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeGroupWithContext(ctx aws.Context, input *DescribeGroupInput, opts ...request.Option) (*DescribeGroupOutput, error) {
	req, out := c.DescribeGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeIAMPolicyAssignment = "DescribeIAMPolicyAssignment"

// DescribeIAMPolicyAssignmentRequest generates a "aws/request.Request" representing the
// client's request for the DescribeIAMPolicyAssignment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeIAMPolicyAssignment for more information on using the DescribeIAMPolicyAssignment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeIAMPolicyAssignmentRequest method.
//    req, resp := client.DescribeIAMPolicyAssignmentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeIAMPolicyAssignment
func (c *QuickSight) DescribeIAMPolicyAssignmentRequest(input *DescribeIAMPolicyAssignmentInput) (req *request.Request, output *DescribeIAMPolicyAssignmentOutput) {
	op := &request.Operation{
		Name:       opDescribeIAMPolicyAssignment,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/iam-policy-assignments/{AssignmentName}",
	}

	if input == nil {
		input = &DescribeIAMPolicyAssignmentInput{}
	}

	output = &DescribeIAMPolicyAssignmentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeIAMPolicyAssignment API operation for Amazon QuickSight.
//
// Describes an existing IAMPolicy Assignment by specified assignment name.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeIAMPolicyAssignment for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You don't have access to this. The provided credentials couldn't be validated.
//   You might not be authorized to carry out the request. Ensure that your account
//   is authorized to use the Amazon QuickSight service, that your policies have
//   the correct permissions, and that you are using the correct access keys.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One or more parameters don't have a valid value.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   One or more resources can't be found.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   Access is throttled.
//
//   * ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//   The NextToken value isn't valid.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeIAMPolicyAssignment
func (c *QuickSight) DescribeIAMPolicyAssignment(input *DescribeIAMPolicyAssignmentInput) (*DescribeIAMPolicyAssignmentOutput, error) {
	req, out := c.DescribeIAMPolicyAssignmentRequest(input)
	return out, req.Send()
}

// DescribeIAMPolicyAssignmentWithContext is the same as DescribeIAMPolicyAssignment with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeIAMPolicyAssignment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeIAMPolicyAssignmentWithContext(ctx aws.Context, input *DescribeIAMPolicyAssignmentInput, opts ...request.Option) (*DescribeIAMPolicyAssignmentOutput, error) {
	req, out := c.DescribeIAMPolicyAssignmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeIngestion = "DescribeIngestion"

// DescribeIngestionRequest generates a "aws/request.Request" representing the
// client's request for the DescribeIngestion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeIngestion for more information on using the DescribeIngestion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeIngestionRequest method.
//    req, resp := client.DescribeIngestionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeIngestion
func (c *QuickSight) DescribeIngestionRequest(input *DescribeIngestionInput) (req *request.Request, output *DescribeIngestionOutput) {
	op := &request.Operation{
		Name:       opDescribeIngestion,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/data-sets/{DataSetId}/ingestions/{IngestionId}",
	}

	if input == nil {
		input = &DescribeIngestionInput{}
	}

	output = &DescribeIngestionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeIngestion API operation for Amazon QuickSight.
//
// Describes a SPICE ingestion.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeIngestion for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You don't have access to this. The provided credentials couldn't be validated.
//   You might not be authorized to carry out the request. Ensure that your account
//   is authorized to use the Amazon QuickSight service, that your policies have
//   the correct permissions, and that you are using the correct access keys.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One or more parameters don't have a valid value.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   One or more resources can't be found.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   Access is throttled.
//
//   * ErrCodeResourceExistsException "ResourceExistsException"
//   The resource specified already exists.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeIngestion
func (c *QuickSight) DescribeIngestion(input *DescribeIngestionInput) (*DescribeIngestionOutput, error) {
	req, out := c.DescribeIngestionRequest(input)
	return out, req.Send()
}

// DescribeIngestionWithContext is the same as DescribeIngestion with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeIngestion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeIngestionWithContext(ctx aws.Context, input *DescribeIngestionInput, opts ...request.Option) (*DescribeIngestionOutput, error) {
	req, out := c.DescribeIngestionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeTemplate = "DescribeTemplate"

// DescribeTemplateRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeTemplate for more information on using the DescribeTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeTemplateRequest method.
//    req, resp := client.DescribeTemplateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeTemplate
func (c *QuickSight) DescribeTemplateRequest(input *DescribeTemplateInput) (req *request.Request, output *DescribeTemplateOutput) {
	op := &request.Operation{
		Name:       opDescribeTemplate,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/templates/{TemplateId}",
	}

	if input == nil {
		input = &DescribeTemplateInput{}
	}

	output = &DescribeTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeTemplate API operation for Amazon QuickSight.
//
// Describes a template's metadata.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeTemplate for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One or more parameters don't have a valid value.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You don't have access to this. The provided credentials couldn't be validated.
//   You might not be authorized to carry out the request. Ensure that your account
//   is authorized to use the Amazon QuickSight service, that your policies have
//   the correct permissions, and that you are using the correct access keys.
//
//   * ErrCodeResourceExistsException "ResourceExistsException"
//   The resource specified already exists.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   One or more resources can't be found.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   Access is throttled.
//
//   * ErrCodeConflictException "ConflictException"
//   Updating or deleting a resource can cause an inconsistent state.
//
//   * ErrCodeUnsupportedUserEditionException "UnsupportedUserEditionException"
//   This error indicates that you are calling an operation on an Amazon QuickSight
//   subscription where the edition doesn't include support for that operation.
//   Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//   Not every operation and capability is available in every edition.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeTemplate
func (c *QuickSight) DescribeTemplate(input *DescribeTemplateInput) (*DescribeTemplateOutput, error) {
	req, out := c.DescribeTemplateRequest(input)
	return out, req.Send()
}

// DescribeTemplateWithContext is the same as DescribeTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeTemplateWithContext(ctx aws.Context, input *DescribeTemplateInput, opts ...request.Option) (*DescribeTemplateOutput, error) {
	req, out := c.DescribeTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeTemplateAlias = "DescribeTemplateAlias"

// DescribeTemplateAliasRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTemplateAlias operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeTemplateAlias for more information on using the DescribeTemplateAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeTemplateAliasRequest method.
//    req, resp := client.DescribeTemplateAliasRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeTemplateAlias
func (c *QuickSight) DescribeTemplateAliasRequest(input *DescribeTemplateAliasInput) (req *request.Request, output *DescribeTemplateAliasOutput) {
	op := &request.Operation{
		Name:       opDescribeTemplateAlias,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/templates/{TemplateId}/aliases/{AliasName}",
	}

	if input == nil {
		input = &DescribeTemplateAliasInput{}
	}

	output = &DescribeTemplateAliasOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeTemplateAlias API operation for Amazon QuickSight.
//
// Describes the template aliases of a template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeTemplateAlias for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeThrottlingException "ThrottlingException"
//   Access is throttled.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   One or more resources can't be found.
//
//   * ErrCodeUnsupportedUserEditionException "UnsupportedUserEditionException"
//   This error indicates that you are calling an operation on an Amazon QuickSight
//   subscription where the edition doesn't include support for that operation.
//   Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//   Not every operation and capability is available in every edition.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeTemplateAlias
func (c *QuickSight) DescribeTemplateAlias(input *DescribeTemplateAliasInput) (*DescribeTemplateAliasOutput, error) {
	req, out := c.DescribeTemplateAliasRequest(input)
	return out, req.Send()
}

// DescribeTemplateAliasWithContext is the same as DescribeTemplateAlias with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTemplateAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeTemplateAliasWithContext(ctx aws.Context, input *DescribeTemplateAliasInput, opts ...request.Option) (*DescribeTemplateAliasOutput, error) {
	req, out := c.DescribeTemplateAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeTemplatePermissions = "DescribeTemplatePermissions"

// DescribeTemplatePermissionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTemplatePermissions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeTemplatePermissions for more information on using the DescribeTemplatePermissions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeTemplatePermissionsRequest method.
//    req, resp := client.DescribeTemplatePermissionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeTemplatePermissions
func (c *QuickSight) DescribeTemplatePermissionsRequest(input *DescribeTemplatePermissionsInput) (req *request.Request, output *DescribeTemplatePermissionsOutput) {
	op := &request.Operation{
		Name:       opDescribeTemplatePermissions,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/templates/{TemplateId}/permissions",
	}

	if input == nil {
		input = &DescribeTemplatePermissionsInput{}
	}

	output = &DescribeTemplatePermissionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeTemplatePermissions API operation for Amazon QuickSight.
//
// Describes read and write permissions on a template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeTemplatePermissions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeThrottlingException "ThrottlingException"
//   Access is throttled.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One or more parameters don't have a valid value.
//
//   * ErrCodeConflictException "ConflictException"
//   Updating or deleting a resource can cause an inconsistent state.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   One or more resources can't be found.
//
//   * ErrCodeUnsupportedUserEditionException "UnsupportedUserEditionException"
//   This error indicates that you are calling an operation on an Amazon QuickSight
//   subscription where the edition doesn't include support for that operation.
//   Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//   Not every operation and capability is available in every edition.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeTemplatePermissions
func (c *QuickSight) DescribeTemplatePermissions(input *DescribeTemplatePermissionsInput) (*DescribeTemplatePermissionsOutput, error) {
	req, out := c.DescribeTemplatePermissionsRequest(input)
	return out, req.Send()
}

// DescribeTemplatePermissionsWithContext is the same as DescribeTemplatePermissions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTemplatePermissions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeTemplatePermissionsWithContext(ctx aws.Context, input *DescribeTemplatePermissionsInput, opts ...request.Option) (*DescribeTemplatePermissionsOutput, error) {
	req, out := c.DescribeTemplatePermissionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeUser = "DescribeUser"

// DescribeUserRequest generates a "aws/request.Request" representing the
// client's request for the DescribeUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeUser for more information on using the DescribeUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeUserRequest method.
//    req, resp := client.DescribeUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeUser
func (c *QuickSight) DescribeUserRequest(input *DescribeUserInput) (req *request.Request, output *DescribeUserOutput) {
	op := &request.Operation{
		Name:       opDescribeUser,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/users/{UserName}",
	}

	if input == nil {
		input = &DescribeUserInput{}
	}

	output = &DescribeUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeUser API operation for Amazon QuickSight.
//
// Returns information about a user, given the user name.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeUser for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You don't have access to this. The provided credentials couldn't be validated.
//   You might not be authorized to carry out the request. Ensure that your account
//   is authorized to use the Amazon QuickSight service, that your policies have
//   the correct permissions, and that you are using the correct access keys.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One or more parameters don't have a valid value.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   One or more resources can't be found.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   Access is throttled.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal failure occurred.
//
//   * ErrCodeResourceUnavailableException "ResourceUnavailableException"
//   This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeUser
func (c *QuickSight) DescribeUser(input *DescribeUserInput) (*DescribeUserOutput, error) {
	req, out := c.DescribeUserRequest(input)
	return out, req.Send()
}

// DescribeUserWithContext is the same as DescribeUser with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeUserWithContext(ctx aws.Context, input *DescribeUserInput, opts ...request.Option) (*DescribeUserOutput, error) {
	req, out := c.DescribeUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDashboardEmbedUrl = "GetDashboardEmbedUrl"

// GetDashboardEmbedUrlRequest generates a "aws/request.Request" representing the
// client's request for the GetDashboardEmbedUrl operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDashboardEmbedUrl for more information on using the GetDashboardEmbedUrl
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDashboardEmbedUrlRequest method.
//    req, resp := client.GetDashboardEmbedUrlRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/GetDashboardEmbedUrl
func (c *QuickSight) GetDashboardEmbedUrlRequest(input *GetDashboardEmbedUrlInput) (req *request.Request, output *GetDashboardEmbedUrlOutput) {
	op := &request.Operation{
		Name:       opGetDashboardEmbedUrl,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/dashboards/{DashboardId}/embed-url",
	}

	if input == nil {
		input = &GetDashboardEmbedUrlInput{}
	}

	output = &GetDashboardEmbedUrlOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDashboardEmbedUrl API operation for Amazon QuickSight.
//
// Generates a server-side embeddable URL and authorization code. Before this
// can work properly, first you need to configure the dashboards and user permissions.
// For more information, see the Amazon QuickSight User Guide section on Embedding
// Amazon QuickSight Dashboards (https://docs.aws.amazon.com/quicksight/latest/user/embedding-dashboards.html)
// or see the Amazon QuickSight API Reference section on Embedding Amazon QuickSight
// Dashboards (https://docs.aws.amazon.com/quicksight/latest/APIReference/qs-dev-embedded-dashboards.html) .
//
// Currently, you can use GetDashboardEmbedURL only from the server, not from
// the user’s browser.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation GetDashboardEmbedUrl for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You don't have access to this. The provided credentials couldn't be validated.
//   You might not be authorized to carry out the request. Ensure that your account
//   is authorized to use the Amazon QuickSight service, that your policies have
//   the correct permissions, and that you are using the correct access keys.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One or more parameters don't have a valid value.
//
//   * ErrCodeResourceExistsException "ResourceExistsException"
//   The resource specified already exists.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   One or more resources can't be found.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   Access is throttled.
//
//   * ErrCodeDomainNotWhitelistedException "DomainNotWhitelistedException"
//   The domain specified is not on the allowlist. All domains for embedded dashboards
//   must be added to the approved list by an Amazon QuickSight admin.
//
//   * ErrCodeUserNotFoundException "QuickSightUserNotFoundException"
//   The user is not found. This error can happen in any operation that requires
//   finding a user based on a provided user name, such as DeleteUser, DescribeUser,
//   and so on.
//
//   * ErrCodeIdentityTypeNotSupportedException "IdentityTypeNotSupportedException"
//   The identity type specified is not supported. Supported identity types include
//   IAM and QUICKSIGHT.
//
//   * ErrCodeSessionLifetimeInMinutesInvalidException "SessionLifetimeInMinutesInvalidException"
//   The number of minutes specified for the lifetime of a session is not valid.
//   The session lifetime must be from 15 to 600 minutes.
//
//   * ErrCodeUnsupportedUserEditionException "UnsupportedUserEditionException"
//   This error indicates that you are calling an operation on an Amazon QuickSight
//   subscription where the edition doesn't include support for that operation.
//   Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//   Not every operation and capability is available in every edition.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/GetDashboardEmbedUrl
func (c *QuickSight) GetDashboardEmbedUrl(input *GetDashboardEmbedUrlInput) (*GetDashboardEmbedUrlOutput, error) {
	req, out := c.GetDashboardEmbedUrlRequest(input)
	return out, req.Send()
}

// GetDashboardEmbedUrlWithContext is the same as GetDashboardEmbedUrl with the addition of
// the ability to pass a context and additional request options.
//
// See GetDashboardEmbedUrl for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) GetDashboardEmbedUrlWithContext(ctx aws.Context, input *GetDashboardEmbedUrlInput, opts ...request.Option) (*GetDashboardEmbedUrlOutput, error) {
	req, out := c.GetDashboardEmbedUrlRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListDashboardVersions = "ListDashboardVersions"

// ListDashboardVersionsRequest generates a "aws/request.Request" representing the
// client's request for the ListDashboardVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDashboardVersions for more information on using the ListDashboardVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDashboardVersionsRequest method.
//    req, resp := client.ListDashboardVersionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListDashboardVersions
func (c *QuickSight) ListDashboardVersionsRequest(input *ListDashboardVersionsInput) (req *request.Request, output *ListDashboardVersionsOutput) {
	op := &request.Operation{
		Name:       opListDashboardVersions,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/dashboards/{DashboardId}/versions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDashboardVersionsInput{}
	}

	output = &ListDashboardVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDashboardVersions API operation for Amazon QuickSight.
//
// Lists all the versions of the dashboards in the Quicksight subscription.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation ListDashboardVersions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One or more parameters don't have a valid value.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   One or more resources can't be found.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   Access is throttled.
//
//   * ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//   The NextToken value isn't valid.
//
//   * ErrCodeUnsupportedUserEditionException "UnsupportedUserEditionException"
//   This error indicates that you are calling an operation on an Amazon QuickSight
//   subscription where the edition doesn't include support for that operation.
//   Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//   Not every operation and capability is available in every edition.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListDashboardVersions
func (c *QuickSight) ListDashboardVersions(input *ListDashboardVersionsInput) (*ListDashboardVersionsOutput, error) {
	req, out := c.ListDashboardVersionsRequest(input)
	return out, req.Send()
}

// ListDashboardVersionsWithContext is the same as ListDashboardVersions with the addition of
// the ability to pass a context and additional request options.
//
// See ListDashboardVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListDashboardVersionsWithContext(ctx aws.Context, input *ListDashboardVersionsInput, opts ...request.Option) (*ListDashboardVersionsOutput, error) {
	req, out := c.ListDashboardVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDashboardVersionsPages iterates over the pages of a ListDashboardVersions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDashboardVersions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListDashboardVersions operation.
//    pageNum := 0
//    err := client.ListDashboardVersionsPages(params,
//        func(page *quicksight.ListDashboardVersionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *QuickSight) ListDashboardVersionsPages(input *ListDashboardVersionsInput, fn func(*ListDashboardVersionsOutput, bool) bool) error {
	return c.ListDashboardVersionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDashboardVersionsPagesWithContext same as ListDashboardVersionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListDashboardVersionsPagesWithContext(ctx aws.Context, input *ListDashboardVersionsInput, fn func(*ListDashboardVersionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDashboardVersionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDashboardVersionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDashboardVersionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListDashboards = "ListDashboards"

// ListDashboardsRequest generates a "aws/request.Request" representing the
// client's request for the ListDashboards operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDashboards for more information on using the ListDashboards
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDashboardsRequest method.
//    req, resp := client.ListDashboardsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListDashboards
func (c *QuickSight) ListDashboardsRequest(input *ListDashboardsInput) (req *request.Request, output *ListDashboardsOutput) {
	op := &request.Operation{
		Name:       opListDashboards,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/dashboards",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDashboardsInput{}
	}

	output = &ListDashboardsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDashboards API operation for Amazon QuickSight.
//
// Lists dashboards in the AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation ListDashboards for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeThrottlingException "ThrottlingException"
//   Access is throttled.
//
//   * ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//   The NextToken value isn't valid.
//
//   * ErrCodeUnsupportedUserEditionException "UnsupportedUserEditionException"
//   This error indicates that you are calling an operation on an Amazon QuickSight
//   subscription where the edition doesn't include support for that operation.
//   Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//   Not every operation and capability is available in every edition.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListDashboards
func (c *QuickSight) ListDashboards(input *ListDashboardsInput) (*ListDashboardsOutput, error) {
	req, out := c.ListDashboardsRequest(input)
	return out, req.Send()
}

// ListDashboardsWithContext is the same as ListDashboards with the addition of
// the ability to pass a context and additional request options.
//
// See ListDashboards for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListDashboardsWithContext(ctx aws.Context, input *ListDashboardsInput, opts ...request.Option) (*ListDashboardsOutput, error) {
	req, out := c.ListDashboardsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDashboardsPages iterates over the pages of a ListDashboards operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDashboards method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListDashboards operation.
//    pageNum := 0
//    err := client.ListDashboardsPages(params,
//        func(page *quicksight.ListDashboardsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *QuickSight) ListDashboardsPages(input *ListDashboardsInput, fn func(*ListDashboardsOutput, bool) bool) error {
	return c.ListDashboardsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDashboardsPagesWithContext same as ListDashboardsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListDashboardsPagesWithContext(ctx aws.Context, input *ListDashboardsInput, fn func(*ListDashboardsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDashboardsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDashboardsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDashboardsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListDataSets = "ListDataSets"

// ListDataSetsRequest generates a "aws/request.Request" representing the
// client's request for the ListDataSets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDataSets for more information on using the ListDataSets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDataSetsRequest method.
//    req, resp := client.ListDataSetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListDataSets
func (c *QuickSight) ListDataSetsRequest(input *ListDataSetsInput) (req *request.Request, output *ListDataSetsOutput) {
	op := &request.Operation{
		Name:       opListDataSets,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/data-sets",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDataSetsInput{}
	}

	output = &ListDataSetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDataSets API operation for Amazon QuickSight.
//
// Lists all of the datasets belonging to this account in an AWS region.
//
// The permissions resource is arn:aws:quicksight:region:aws-account-id:dataset/*.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation ListDataSets for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You don't have access to this. The provided credentials couldn't be validated.
//   You might not be authorized to carry out the request. Ensure that your account
//   is authorized to use the Amazon QuickSight service, that your policies have
//   the correct permissions, and that you are using the correct access keys.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One or more parameters don't have a valid value.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   Access is throttled.
//
//   * ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//   The NextToken value isn't valid.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListDataSets
func (c *QuickSight) ListDataSets(input *ListDataSetsInput) (*ListDataSetsOutput, error) {
	req, out := c.ListDataSetsRequest(input)
	return out, req.Send()
}

// ListDataSetsWithContext is the same as ListDataSets with the addition of
// the ability to pass a context and additional request options.
//
// See ListDataSets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListDataSetsWithContext(ctx aws.Context, input *ListDataSetsInput, opts ...request.Option) (*ListDataSetsOutput, error) {
	req, out := c.ListDataSetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDataSetsPages iterates over the pages of a ListDataSets operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDataSets method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListDataSets operation.
//    pageNum := 0
//    err := client.ListDataSetsPages(params,
//        func(page *quicksight.ListDataSetsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *QuickSight) ListDataSetsPages(input *ListDataSetsInput, fn func(*ListDataSetsOutput, bool) bool) error {
	return c.ListDataSetsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDataSetsPagesWithContext same as ListDataSetsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListDataSetsPagesWithContext(ctx aws.Context, input *ListDataSetsInput, fn func(*ListDataSetsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDataSetsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDataSetsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDataSetsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListDataSources = "ListDataSources"

// ListDataSourcesRequest generates a "aws/request.Request" representing the
// client's request for the ListDataSources operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDataSources for more information on using the ListDataSources
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDataSourcesRequest method.
//    req, resp := client.ListDataSourcesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListDataSources
func (c *QuickSight) ListDataSourcesRequest(input *ListDataSourcesInput) (req *request.Request, output *ListDataSourcesOutput) {
	op := &request.Operation{
		Name:       opListDataSources,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/data-sources",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDataSourcesInput{}
	}

	output = &ListDataSourcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDataSources API operation for Amazon QuickSight.
//
// Lists data sources in current AWS Region that belong to this AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation ListDataSources for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You don't have access to this. The provided credentials couldn't be validated.
//   You might not be authorized to carry out the request. Ensure that your account
//   is authorized to use the Amazon QuickSight service, that your policies have
//   the correct permissions, and that you are using the correct access keys.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One or more parameters don't have a valid value.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   Access is throttled.
//
//   * ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//   The NextToken value isn't valid.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListDataSources
func (c *QuickSight) ListDataSources(input *ListDataSourcesInput) (*ListDataSourcesOutput, error) {
	req, out := c.ListDataSourcesRequest(input)
	return out, req.Send()
}

// ListDataSourcesWithContext is the same as ListDataSources with the addition of
// the ability to pass a context and additional request options.
//
// See ListDataSources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListDataSourcesWithContext(ctx aws.Context, input *ListDataSourcesInput, opts ...request.Option) (*ListDataSourcesOutput, error) {
	req, out := c.ListDataSourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDataSourcesPages iterates over the pages of a ListDataSources operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDataSources method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListDataSources operation.
//    pageNum := 0
//    err := client.ListDataSourcesPages(params,
//        func(page *quicksight.ListDataSourcesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *QuickSight) ListDataSourcesPages(input *ListDataSourcesInput, fn func(*ListDataSourcesOutput, bool) bool) error {
	return c.ListDataSourcesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDataSourcesPagesWithContext same as ListDataSourcesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListDataSourcesPagesWithContext(ctx aws.Context, input *ListDataSourcesInput, fn func(*ListDataSourcesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDataSourcesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDataSourcesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDataSourcesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListGroupMemberships = "ListGroupMemberships"

// ListGroupMembershipsRequest generates a "aws/request.Request" representing the
// client's request for the ListGroupMemberships operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListGroupMemberships for more information on using the ListGroupMemberships
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListGroupMembershipsRequest method.
//    req, resp := client.ListGroupMembershipsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListGroupMemberships
func (c *QuickSight) ListGroupMembershipsRequest(input *ListGroupMembershipsInput) (req *request.Request, output *ListGroupMembershipsOutput) {
	op := &request.Operation{
		Name:       opListGroupMemberships,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/groups/{GroupName}/members",
	}

	if input == nil {
		input = &ListGroupMembershipsInput{}
	}

	output = &ListGroupMembershipsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListGroupMemberships API operation for Amazon QuickSight.
//
// Lists member users in a group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation ListGroupMemberships for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You don't have access to this. The provided credentials couldn't be validated.
//   You might not be authorized to carry out the request. Ensure that your account
//   is authorized to use the Amazon QuickSight service, that your policies have
//   the correct permissions, and that you are using the correct access keys.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One or more parameters don't have a valid value.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   One or more resources can't be found.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   Access is throttled.
//
//   * ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//   The NextToken value isn't valid.
//
//   * ErrCodePreconditionNotMetException "PreconditionNotMetException"
//   One or more preconditions aren't met.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal failure occurred.
//
//   * ErrCodeResourceUnavailableException "ResourceUnavailableException"
//   This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListGroupMemberships
func (c *QuickSight) ListGroupMemberships(input *ListGroupMembershipsInput) (*ListGroupMembershipsOutput, error) {
	req, out := c.ListGroupMembershipsRequest(input)
	return out, req.Send()
}

// ListGroupMembershipsWithContext is the same as ListGroupMemberships with the addition of
// the ability to pass a context and additional request options.
//
// See ListGroupMemberships for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListGroupMembershipsWithContext(ctx aws.Context, input *ListGroupMembershipsInput, opts ...request.Option) (*ListGroupMembershipsOutput, error) {
	req, out := c.ListGroupMembershipsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListGroups = "ListGroups"

// ListGroupsRequest generates a "aws/request.Request" representing the
// client's request for the ListGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListGroups for more information on using the ListGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListGroupsRequest method.
//    req, resp := client.ListGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListGroups
func (c *QuickSight) ListGroupsRequest(input *ListGroupsInput) (req *request.Request, output *ListGroupsOutput) {
	op := &request.Operation{
		Name:       opListGroups,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/groups",
	}

	if input == nil {
		input = &ListGroupsInput{}
	}

	output = &ListGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListGroups API operation for Amazon QuickSight.
//
// Lists all user groups in Amazon QuickSight.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation ListGroups for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You don't have access to this. The provided credentials couldn't be validated.
//   You might not be authorized to carry out the request. Ensure that your account
//   is authorized to use the Amazon QuickSight service, that your policies have
//   the correct permissions, and that you are using the correct access keys.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One or more parameters don't have a valid value.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   One or more resources can't be found.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   Access is throttled.
//
//   * ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//   The NextToken value isn't valid.
//
//   * ErrCodePreconditionNotMetException "PreconditionNotMetException"
//   One or more preconditions aren't met.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal failure occurred.
//
//   * ErrCodeResourceUnavailableException "ResourceUnavailableException"
//   This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListGroups
func (c *QuickSight) ListGroups(input *ListGroupsInput) (*ListGroupsOutput, error) {
	req, out := c.ListGroupsRequest(input)
	return out, req.Send()
}

// ListGroupsWithContext is the same as ListGroups with the addition of
// the ability to pass a context and additional request options.
//
// See ListGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListGroupsWithContext(ctx aws.Context, input *ListGroupsInput, opts ...request.Option) (*ListGroupsOutput, error) {
	req, out := c.ListGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListIAMPolicyAssignments = "ListIAMPolicyAssignments"

// ListIAMPolicyAssignmentsRequest generates a "aws/request.Request" representing the
// client's request for the ListIAMPolicyAssignments operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListIAMPolicyAssignments for more information on using the ListIAMPolicyAssignments
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListIAMPolicyAssignmentsRequest method.
//    req, resp := client.ListIAMPolicyAssignmentsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListIAMPolicyAssignments
func (c *QuickSight) ListIAMPolicyAssignmentsRequest(input *ListIAMPolicyAssignmentsInput) (req *request.Request, output *ListIAMPolicyAssignmentsOutput) {
	op := &request.Operation{
		Name:       opListIAMPolicyAssignments,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/iam-policy-assignments",
	}

	if input == nil {
		input = &ListIAMPolicyAssignmentsInput{}
	}

	output = &ListIAMPolicyAssignmentsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListIAMPolicyAssignments API operation for Amazon QuickSight.
//
// Lists assignments in current QuickSight account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation ListIAMPolicyAssignments for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You don't have access to this. The provided credentials couldn't be validated.
//   You might not be authorized to carry out the request. Ensure that your account
//   is authorized to use the Amazon QuickSight service, that your policies have
//   the correct permissions, and that you are using the correct access keys.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One or more parameters don't have a valid value.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   One or more resources can't be found.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   Access is throttled.
//
//   * ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//   The NextToken value isn't valid.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListIAMPolicyAssignments
func (c *QuickSight) ListIAMPolicyAssignments(input *ListIAMPolicyAssignmentsInput) (*ListIAMPolicyAssignmentsOutput, error) {
	req, out := c.ListIAMPolicyAssignmentsRequest(input)
	return out, req.Send()
}

// ListIAMPolicyAssignmentsWithContext is the same as ListIAMPolicyAssignments with the addition of
// the ability to pass a context and additional request options.
//
// See ListIAMPolicyAssignments for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListIAMPolicyAssignmentsWithContext(ctx aws.Context, input *ListIAMPolicyAssignmentsInput, opts ...request.Option) (*ListIAMPolicyAssignmentsOutput, error) {
	req, out := c.ListIAMPolicyAssignmentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListIAMPolicyAssignmentsForUser = "ListIAMPolicyAssignmentsForUser"

// ListIAMPolicyAssignmentsForUserRequest generates a "aws/request.Request" representing the
// client's request for the ListIAMPolicyAssignmentsForUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListIAMPolicyAssignmentsForUser for more information on using the ListIAMPolicyAssignmentsForUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListIAMPolicyAssignmentsForUserRequest method.
//    req, resp := client.ListIAMPolicyAssignmentsForUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListIAMPolicyAssignmentsForUser
func (c *QuickSight) ListIAMPolicyAssignmentsForUserRequest(input *ListIAMPolicyAssignmentsForUserInput) (req *request.Request, output *ListIAMPolicyAssignmentsForUserOutput) {
	op := &request.Operation{
		Name:       opListIAMPolicyAssignmentsForUser,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/users/{UserName}/iam-policy-assignments",
	}

	if input == nil {
		input = &ListIAMPolicyAssignmentsForUserInput{}
	}

	output = &ListIAMPolicyAssignmentsForUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListIAMPolicyAssignmentsForUser API operation for Amazon QuickSight.
//
// Lists all the assignments and the Amazon Resource Names (ARNs) for the associated
// IAM policies assigned to the specified user and the group or groups that
// the user belongs to.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation ListIAMPolicyAssignmentsForUser for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You don't have access to this. The provided credentials couldn't be validated.
//   You might not be authorized to carry out the request. Ensure that your account
//   is authorized to use the Amazon QuickSight service, that your policies have
//   the correct permissions, and that you are using the correct access keys.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One or more parameters don't have a valid value.
//
//   * ErrCodeResourceExistsException "ResourceExistsException"
//   The resource specified already exists.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   One or more resources can't be found.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   Access is throttled.
//
//   * ErrCodeConcurrentUpdatingException "ConcurrentUpdatingException"
//   A resource is already in an "actionable" state that must complete before
//   a new update can be applied.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListIAMPolicyAssignmentsForUser
func (c *QuickSight) ListIAMPolicyAssignmentsForUser(input *ListIAMPolicyAssignmentsForUserInput) (*ListIAMPolicyAssignmentsForUserOutput, error) {
	req, out := c.ListIAMPolicyAssignmentsForUserRequest(input)
	return out, req.Send()
}

// ListIAMPolicyAssignmentsForUserWithContext is the same as ListIAMPolicyAssignmentsForUser with the addition of
// the ability to pass a context and additional request options.
//
// See ListIAMPolicyAssignmentsForUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListIAMPolicyAssignmentsForUserWithContext(ctx aws.Context, input *ListIAMPolicyAssignmentsForUserInput, opts ...request.Option) (*ListIAMPolicyAssignmentsForUserOutput, error) {
	req, out := c.ListIAMPolicyAssignmentsForUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListIngestions = "ListIngestions"

// ListIngestionsRequest generates a "aws/request.Request" representing the
// client's request for the ListIngestions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListIngestions for more information on using the ListIngestions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListIngestionsRequest method.
//    req, resp := client.ListIngestionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListIngestions
func (c *QuickSight) ListIngestionsRequest(input *ListIngestionsInput) (req *request.Request, output *ListIngestionsOutput) {
	op := &request.Operation{
		Name:       opListIngestions,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/data-sets/{DataSetId}/ingestions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListIngestionsInput{}
	}

	output = &ListIngestionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListIngestions API operation for Amazon QuickSight.
//
// Lists the history of SPICE ingestions for a dataset.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation ListIngestions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You don't have access to this. The provided credentials couldn't be validated.
//   You might not be authorized to carry out the request. Ensure that your account
//   is authorized to use the Amazon QuickSight service, that your policies have
//   the correct permissions, and that you are using the correct access keys.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One or more parameters don't have a valid value.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   One or more resources can't be found.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   Access is throttled.
//
//   * ErrCodeResourceExistsException "ResourceExistsException"
//   The resource specified already exists.
//
//   * ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//   The NextToken value isn't valid.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListIngestions
func (c *QuickSight) ListIngestions(input *ListIngestionsInput) (*ListIngestionsOutput, error) {
	req, out := c.ListIngestionsRequest(input)
	return out, req.Send()
}

// ListIngestionsWithContext is the same as ListIngestions with the addition of
// the ability to pass a context and additional request options.
//
// See ListIngestions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListIngestionsWithContext(ctx aws.Context, input *ListIngestionsInput, opts ...request.Option) (*ListIngestionsOutput, error) {
	req, out := c.ListIngestionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListIngestionsPages iterates over the pages of a ListIngestions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListIngestions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListIngestions operation.
//    pageNum := 0
//    err := client.ListIngestionsPages(params,
//        func(page *quicksight.ListIngestionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *QuickSight) ListIngestionsPages(input *ListIngestionsInput, fn func(*ListIngestionsOutput, bool) bool) error {
	return c.ListIngestionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListIngestionsPagesWithContext same as ListIngestionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListIngestionsPagesWithContext(ctx aws.Context, input *ListIngestionsInput, fn func(*ListIngestionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListIngestionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListIngestionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListIngestionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListTagsForResource
func (c *QuickSight) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/resources/{ResourceArn}/tags",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon QuickSight.
//
// Lists the tags assigned to a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You don't have access to this. The provided credentials couldn't be validated.
//   You might not be authorized to carry out the request. Ensure that your account
//   is authorized to use the Amazon QuickSight service, that your policies have
//   the correct permissions, and that you are using the correct access keys.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One or more parameters don't have a valid value.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   One or more resources can't be found.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   Access is throttled.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListTagsForResource
func (c *QuickSight) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTemplateAliases = "ListTemplateAliases"

// ListTemplateAliasesRequest generates a "aws/request.Request" representing the
// client's request for the ListTemplateAliases operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTemplateAliases for more information on using the ListTemplateAliases
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTemplateAliasesRequest method.
//    req, resp := client.ListTemplateAliasesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListTemplateAliases
func (c *QuickSight) ListTemplateAliasesRequest(input *ListTemplateAliasesInput) (req *request.Request, output *ListTemplateAliasesOutput) {
	op := &request.Operation{
		Name:       opListTemplateAliases,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/templates/{TemplateId}/aliases",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTemplateAliasesInput{}
	}

	output = &ListTemplateAliasesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTemplateAliases API operation for Amazon QuickSight.
//
// Lists all the aliases of a template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation ListTemplateAliases for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeThrottlingException "ThrottlingException"
//   Access is throttled.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   One or more resources can't be found.
//
//   * ErrCodeUnsupportedUserEditionException "UnsupportedUserEditionException"
//   This error indicates that you are calling an operation on an Amazon QuickSight
//   subscription where the edition doesn't include support for that operation.
//   Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//   Not every operation and capability is available in every edition.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListTemplateAliases
func (c *QuickSight) ListTemplateAliases(input *ListTemplateAliasesInput) (*ListTemplateAliasesOutput, error) {
	req, out := c.ListTemplateAliasesRequest(input)
	return out, req.Send()
}

// ListTemplateAliasesWithContext is the same as ListTemplateAliases with the addition of
// the ability to pass a context and additional request options.
//
// See ListTemplateAliases for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListTemplateAliasesWithContext(ctx aws.Context, input *ListTemplateAliasesInput, opts ...request.Option) (*ListTemplateAliasesOutput, error) {
	req, out := c.ListTemplateAliasesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTemplateAliasesPages iterates over the pages of a ListTemplateAliases operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTemplateAliases method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListTemplateAliases operation.
//    pageNum := 0
//    err := client.ListTemplateAliasesPages(params,
//        func(page *quicksight.ListTemplateAliasesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *QuickSight) ListTemplateAliasesPages(input *ListTemplateAliasesInput, fn func(*ListTemplateAliasesOutput, bool) bool) error {
	return c.ListTemplateAliasesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTemplateAliasesPagesWithContext same as ListTemplateAliasesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListTemplateAliasesPagesWithContext(ctx aws.Context, input *ListTemplateAliasesInput, fn func(*ListTemplateAliasesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTemplateAliasesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTemplateAliasesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTemplateAliasesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTemplateVersions = "ListTemplateVersions"

// ListTemplateVersionsRequest generates a "aws/request.Request" representing the
// client's request for the ListTemplateVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTemplateVersions for more information on using the ListTemplateVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTemplateVersionsRequest method.
//    req, resp := client.ListTemplateVersionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListTemplateVersions
func (c *QuickSight) ListTemplateVersionsRequest(input *ListTemplateVersionsInput) (req *request.Request, output *ListTemplateVersionsOutput) {
	op := &request.Operation{
		Name:       opListTemplateVersions,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/templates/{TemplateId}/versions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTemplateVersionsInput{}
	}

	output = &ListTemplateVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTemplateVersions API operation for Amazon QuickSight.
//
// Lists all the versions of the templates in the Quicksight account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation ListTemplateVersions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeThrottlingException "ThrottlingException"
//   Access is throttled.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One or more parameters don't have a valid value.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   One or more resources can't be found.
//
//   * ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//   The NextToken value isn't valid.
//
//   * ErrCodeUnsupportedUserEditionException "UnsupportedUserEditionException"
//   This error indicates that you are calling an operation on an Amazon QuickSight
//   subscription where the edition doesn't include support for that operation.
//   Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//   Not every operation and capability is available in every edition.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListTemplateVersions
func (c *QuickSight) ListTemplateVersions(input *ListTemplateVersionsInput) (*ListTemplateVersionsOutput, error) {
	req, out := c.ListTemplateVersionsRequest(input)
	return out, req.Send()
}

// ListTemplateVersionsWithContext is the same as ListTemplateVersions with the addition of
// the ability to pass a context and additional request options.
//
// See ListTemplateVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListTemplateVersionsWithContext(ctx aws.Context, input *ListTemplateVersionsInput, opts ...request.Option) (*ListTemplateVersionsOutput, error) {
	req, out := c.ListTemplateVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTemplateVersionsPages iterates over the pages of a ListTemplateVersions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTemplateVersions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListTemplateVersions operation.
//    pageNum := 0
//    err := client.ListTemplateVersionsPages(params,
//        func(page *quicksight.ListTemplateVersionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *QuickSight) ListTemplateVersionsPages(input *ListTemplateVersionsInput, fn func(*ListTemplateVersionsOutput, bool) bool) error {
	return c.ListTemplateVersionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTemplateVersionsPagesWithContext same as ListTemplateVersionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListTemplateVersionsPagesWithContext(ctx aws.Context, input *ListTemplateVersionsInput, fn func(*ListTemplateVersionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTemplateVersionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTemplateVersionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTemplateVersionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTemplates = "ListTemplates"

// ListTemplatesRequest generates a "aws/request.Request" representing the
// client's request for the ListTemplates operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTemplates for more information on using the ListTemplates
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTemplatesRequest method.
//    req, resp := client.ListTemplatesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListTemplates
func (c *QuickSight) ListTemplatesRequest(input *ListTemplatesInput) (req *request.Request, output *ListTemplatesOutput) {
	op := &request.Operation{
		Name:       opListTemplates,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/templates",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTemplatesInput{}
	}

	output = &ListTemplatesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTemplates API operation for Amazon QuickSight.
//
// Lists all the templates in the QuickSight account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation ListTemplates for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeThrottlingException "ThrottlingException"
//   Access is throttled.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One or more parameters don't have a valid value.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   One or more resources can't be found.
//
//   * ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//   The NextToken value isn't valid.
//
//   * ErrCodeUnsupportedUserEditionException "UnsupportedUserEditionException"
//   This error indicates that you are calling an operation on an Amazon QuickSight
//   subscription where the edition doesn't include support for that operation.
//   Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//   Not every operation and capability is available in every edition.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListTemplates
func (c *QuickSight) ListTemplates(input *ListTemplatesInput) (*ListTemplatesOutput, error) {
	req, out := c.ListTemplatesRequest(input)
	return out, req.Send()
}

// ListTemplatesWithContext is the same as ListTemplates with the addition of
// the ability to pass a context and additional request options.
//
// See ListTemplates for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListTemplatesWithContext(ctx aws.Context, input *ListTemplatesInput, opts ...request.Option) (*ListTemplatesOutput, error) {
	req, out := c.ListTemplatesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTemplatesPages iterates over the pages of a ListTemplates operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTemplates method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListTemplates operation.
//    pageNum := 0
//    err := client.ListTemplatesPages(params,
//        func(page *quicksight.ListTemplatesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *QuickSight) ListTemplatesPages(input *ListTemplatesInput, fn func(*ListTemplatesOutput, bool) bool) error {
	return c.ListTemplatesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTemplatesPagesWithContext same as ListTemplatesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListTemplatesPagesWithContext(ctx aws.Context, input *ListTemplatesInput, fn func(*ListTemplatesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTemplatesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTemplatesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTemplatesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListUserGroups = "ListUserGroups"

// ListUserGroupsRequest generates a "aws/request.Request" representing the
// client's request for the ListUserGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListUserGroups for more information on using the ListUserGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListUserGroupsRequest method.
//    req, resp := client.ListUserGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListUserGroups
func (c *QuickSight) ListUserGroupsRequest(input *ListUserGroupsInput) (req *request.Request, output *ListUserGroupsOutput) {
	op := &request.Operation{
		Name:       opListUserGroups,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/users/{UserName}/groups",
	}

	if input == nil {
		input = &ListUserGroupsInput{}
	}

	output = &ListUserGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListUserGroups API operation for Amazon QuickSight.
//
// Lists the Amazon QuickSight groups that an Amazon QuickSight user is a member
// of.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation ListUserGroups for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You don't have access to this. The provided credentials couldn't be validated.
//   You might not be authorized to carry out the request. Ensure that your account
//   is authorized to use the Amazon QuickSight service, that your policies have
//   the correct permissions, and that you are using the correct access keys.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One or more parameters don't have a valid value.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   One or more resources can't be found.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   Access is throttled.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal failure occurred.
//
//   * ErrCodeResourceUnavailableException "ResourceUnavailableException"
//   This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListUserGroups
func (c *QuickSight) ListUserGroups(input *ListUserGroupsInput) (*ListUserGroupsOutput, error) {
	req, out := c.ListUserGroupsRequest(input)
	return out, req.Send()
}

// ListUserGroupsWithContext is the same as ListUserGroups with the addition of
// the ability to pass a context and additional request options.
//
// See ListUserGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListUserGroupsWithContext(ctx aws.Context, input *ListUserGroupsInput, opts ...request.Option) (*ListUserGroupsOutput, error) {
	req, out := c.ListUserGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListUsers = "ListUsers"

// ListUsersRequest generates a "aws/request.Request" representing the
// client's request for the ListUsers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListUsers for more information on using the ListUsers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListUsersRequest method.
//    req, resp := client.ListUsersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListUsers
func (c *QuickSight) ListUsersRequest(input *ListUsersInput) (req *request.Request, output *ListUsersOutput) {
	op := &request.Operation{
		Name:       opListUsers,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/users",
	}

	if input == nil {
		input = &ListUsersInput{}
	}

	output = &ListUsersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListUsers API operation for Amazon QuickSight.
//
// Returns a list of all of the Amazon QuickSight users belonging to this account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation ListUsers for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You don't have access to this. The provided credentials couldn't be validated.
//   You might not be authorized to carry out the request. Ensure that your account
//   is authorized to use the Amazon QuickSight service, that your policies have
//   the correct permissions, and that you are using the correct access keys.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One or more parameters don't have a valid value.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   One or more resources can't be found.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   Access is throttled.
//
//   * ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//   The NextToken value isn't valid.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal failure occurred.
//
//   * ErrCodeResourceUnavailableException "ResourceUnavailableException"
//   This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListUsers
func (c *QuickSight) ListUsers(input *ListUsersInput) (*ListUsersOutput, error) {
	req, out := c.ListUsersRequest(input)
	return out, req.Send()
}

// ListUsersWithContext is the same as ListUsers with the addition of
// the ability to pass a context and additional request options.
//
// See ListUsers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListUsersWithContext(ctx aws.Context, input *ListUsersInput, opts ...request.Option) (*ListUsersOutput, error) {
	req, out := c.ListUsersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRegisterUser = "RegisterUser"

// RegisterUserRequest generates a "aws/request.Request" representing the
// client's request for the RegisterUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RegisterUser for more information on using the RegisterUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RegisterUserRequest method.
//    req, resp := client.RegisterUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/RegisterUser
func (c *QuickSight) RegisterUserRequest(input *RegisterUserInput) (req *request.Request, output *RegisterUserOutput) {
	op := &request.Operation{
		Name:       opRegisterUser,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/users",
	}

	if input == nil {
		input = &RegisterUserInput{}
	}

	output = &RegisterUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RegisterUser API operation for Amazon QuickSight.
//
// Creates an Amazon QuickSight user, whose identity is associated with the
// AWS Identity and Access Management (IAM) identity or role specified in the
// request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation RegisterUser for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You don't have access to this. The provided credentials couldn't be validated.
//   You might not be authorized to carry out the request. Ensure that your account
//   is authorized to use the Amazon QuickSight service, that your policies have
//   the correct permissions, and that you are using the correct access keys.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One or more parameters don't have a valid value.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   One or more resources can't be found.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   Access is throttled.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   A limit is exceeded.
//
//   * ErrCodeResourceExistsException "ResourceExistsException"
//   The resource specified already exists.
//
//   * ErrCodePreconditionNotMetException "PreconditionNotMetException"
//   One or more preconditions aren't met.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal failure occurred.
//
//   * ErrCodeResourceUnavailableException "ResourceUnavailableException"
//   This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/RegisterUser
func (c *QuickSight) RegisterUser(input *RegisterUserInput) (*RegisterUserOutput, error) {
	req, out := c.RegisterUserRequest(input)
	return out, req.Send()
}

// RegisterUserWithContext is the same as RegisterUser with the addition of
// the ability to pass a context and additional request options.
//
// See RegisterUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) RegisterUserWithContext(ctx aws.Context, input *RegisterUserInput, opts ...request.Option) (*RegisterUserOutput, error) {
	req, out := c.RegisterUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/TagResource
func (c *QuickSight) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/resources/{ResourceArn}/tags",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// TagResource API operation for Amazon QuickSight.
//
// Assigns one or more tags (key-value pairs) to the specified QuickSight resource.
//
// Tags can help you organize and categorize your resources. You can also use
// them to scope user permissions, by granting a user permission to access or
// change only resources with certain tag values. You can use the TagResource
// operation with a resource that already has tags. If you specify a new tag
// key for the resource, this tag is appended to the list of tags associated
// with the resource. If you specify a tag key that is already associated with
// the resource, the new tag value that you specify replaces the previous value
// for that tag.
//
// You can associate as many as 50 tags with a resource. QuickSight supports
// tagging on data set, data source, dashboard, and template.
//
// Tagging for QuickSight works in a similar way to tagging for other AWS services,
// except for the following:
//
//    * You can't use tags to track AWS costs for QuickSight. This restriction
//    is because QuickSight costs are based on users and SPICE capacity, which
//    aren't taggable resources.
//
//    * QuickSight doesn't currently support the Tag Editor for AWS Resource
//    Groups.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation TagResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeLimitExceededException "LimitExceededException"
//   A limit is exceeded.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You don't have access to this. The provided credentials couldn't be validated.
//   You might not be authorized to carry out the request. Ensure that your account
//   is authorized to use the Amazon QuickSight service, that your policies have
//   the correct permissions, and that you are using the correct access keys.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One or more parameters don't have a valid value.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   One or more resources can't be found.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   Access is throttled.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/TagResource
func (c *QuickSight) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UntagResource
func (c *QuickSight) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/resources/{ResourceArn}/tags",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UntagResource API operation for Amazon QuickSight.
//
// Removes a tag or tags from a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation UntagResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You don't have access to this. The provided credentials couldn't be validated.
//   You might not be authorized to carry out the request. Ensure that your account
//   is authorized to use the Amazon QuickSight service, that your policies have
//   the correct permissions, and that you are using the correct access keys.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One or more parameters don't have a valid value.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   One or more resources can't be found.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   Access is throttled.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UntagResource
func (c *QuickSight) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDashboard = "UpdateDashboard"

// UpdateDashboardRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDashboard operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDashboard for more information on using the UpdateDashboard
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateDashboardRequest method.
//    req, resp := client.UpdateDashboardRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateDashboard
func (c *QuickSight) UpdateDashboardRequest(input *UpdateDashboardInput) (req *request.Request, output *UpdateDashboardOutput) {
	op := &request.Operation{
		Name:       opUpdateDashboard,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{AwsAccountId}/dashboards/{DashboardId}",
	}

	if input == nil {
		input = &UpdateDashboardInput{}
	}

	output = &UpdateDashboardOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateDashboard API operation for Amazon QuickSight.
//
// Updates a dashboard in the AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation UpdateDashboard for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeThrottlingException "ThrottlingException"
//   Access is throttled.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One or more parameters don't have a valid value.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   One or more resources can't be found.
//
//   * ErrCodeConflictException "ConflictException"
//   Updating or deleting a resource can cause an inconsistent state.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   A limit is exceeded.
//
//   * ErrCodeUnsupportedUserEditionException "UnsupportedUserEditionException"
//   This error indicates that you are calling an operation on an Amazon QuickSight
//   subscription where the edition doesn't include support for that operation.
//   Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//   Not every operation and capability is available in every edition.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateDashboard
func (c *QuickSight) UpdateDashboard(input *UpdateDashboardInput) (*UpdateDashboardOutput, error) {
	req, out := c.UpdateDashboardRequest(input)
	return out, req.Send()
}

// UpdateDashboardWithContext is the same as UpdateDashboard with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDashboard for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) UpdateDashboardWithContext(ctx aws.Context, input *UpdateDashboardInput, opts ...request.Option) (*UpdateDashboardOutput, error) {
	req, out := c.UpdateDashboardRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDashboardPermissions = "UpdateDashboardPermissions"

// UpdateDashboardPermissionsRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDashboardPermissions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDashboardPermissions for more information on using the UpdateDashboardPermissions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateDashboardPermissionsRequest method.
//    req, resp := client.UpdateDashboardPermissionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateDashboardPermissions
func (c *QuickSight) UpdateDashboardPermissionsRequest(input *UpdateDashboardPermissionsInput) (req *request.Request, output *UpdateDashboardPermissionsOutput) {
	op := &request.Operation{
		Name:       opUpdateDashboardPermissions,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{AwsAccountId}/dashboards/{DashboardId}/permissions",
	}

	if input == nil {
		input = &UpdateDashboardPermissionsInput{}
	}

	output = &UpdateDashboardPermissionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateDashboardPermissions API operation for Amazon QuickSight.
//
// Updates read and write permissions on a dashboard.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation UpdateDashboardPermissions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeThrottlingException "ThrottlingException"
//   Access is throttled.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One or more parameters don't have a valid value.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   One or more resources can't be found.
//
//   * ErrCodeUnsupportedUserEditionException "UnsupportedUserEditionException"
//   This error indicates that you are calling an operation on an Amazon QuickSight
//   subscription where the edition doesn't include support for that operation.
//   Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//   Not every operation and capability is available in every edition.
//
//   * ErrCodeConflictException "ConflictException"
//   Updating or deleting a resource can cause an inconsistent state.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateDashboardPermissions
func (c *QuickSight) UpdateDashboardPermissions(input *UpdateDashboardPermissionsInput) (*UpdateDashboardPermissionsOutput, error) {
	req, out := c.UpdateDashboardPermissionsRequest(input)
	return out, req.Send()
}

// UpdateDashboardPermissionsWithContext is the same as UpdateDashboardPermissions with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDashboardPermissions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) UpdateDashboardPermissionsWithContext(ctx aws.Context, input *UpdateDashboardPermissionsInput, opts ...request.Option) (*UpdateDashboardPermissionsOutput, error) {
	req, out := c.UpdateDashboardPermissionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDashboardPublishedVersion = "UpdateDashboardPublishedVersion"

// UpdateDashboardPublishedVersionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDashboardPublishedVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDashboardPublishedVersion for more information on using the UpdateDashboardPublishedVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateDashboardPublishedVersionRequest method.
//    req, resp := client.UpdateDashboardPublishedVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateDashboardPublishedVersion
func (c *QuickSight) UpdateDashboardPublishedVersionRequest(input *UpdateDashboardPublishedVersionInput) (req *request.Request, output *UpdateDashboardPublishedVersionOutput) {
	op := &request.Operation{
		Name:       opUpdateDashboardPublishedVersion,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{AwsAccountId}/dashboards/{DashboardId}/versions/{VersionNumber}",
	}

	if input == nil {
		input = &UpdateDashboardPublishedVersionInput{}
	}

	output = &UpdateDashboardPublishedVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateDashboardPublishedVersion API operation for Amazon QuickSight.
//
// Updates the published version of a dashboard.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation UpdateDashboardPublishedVersion for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One or more parameters don't have a valid value.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   Access is throttled.
//
//   * ErrCodeConflictException "ConflictException"
//   Updating or deleting a resource can cause an inconsistent state.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   One or more resources can't be found.
//
//   * ErrCodeUnsupportedUserEditionException "UnsupportedUserEditionException"
//   This error indicates that you are calling an operation on an Amazon QuickSight
//   subscription where the edition doesn't include support for that operation.
//   Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//   Not every operation and capability is available in every edition.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateDashboardPublishedVersion
func (c *QuickSight) UpdateDashboardPublishedVersion(input *UpdateDashboardPublishedVersionInput) (*UpdateDashboardPublishedVersionOutput, error) {
	req, out := c.UpdateDashboardPublishedVersionRequest(input)
	return out, req.Send()
}

// UpdateDashboardPublishedVersionWithContext is the same as UpdateDashboardPublishedVersion with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDashboardPublishedVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) UpdateDashboardPublishedVersionWithContext(ctx aws.Context, input *UpdateDashboardPublishedVersionInput, opts ...request.Option) (*UpdateDashboardPublishedVersionOutput, error) {
	req, out := c.UpdateDashboardPublishedVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDataSet = "UpdateDataSet"

// UpdateDataSetRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDataSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDataSet for more information on using the UpdateDataSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateDataSetRequest method.
//    req, resp := client.UpdateDataSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateDataSet
func (c *QuickSight) UpdateDataSetRequest(input *UpdateDataSetInput) (req *request.Request, output *UpdateDataSetOutput) {
	op := &request.Operation{
		Name:       opUpdateDataSet,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{AwsAccountId}/data-sets/{DataSetId}",
	}

	if input == nil {
		input = &UpdateDataSetInput{}
	}

	output = &UpdateDataSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateDataSet API operation for Amazon QuickSight.
//
// Updates a dataset.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation UpdateDataSet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You don't have access to this. The provided credentials couldn't be validated.
//   You might not be authorized to carry out the request. Ensure that your account
//   is authorized to use the Amazon QuickSight service, that your policies have
//   the correct permissions, and that you are using the correct access keys.
//
//   * ErrCodeConflictException "ConflictException"
//   Updating or deleting a resource can cause an inconsistent state.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One or more parameters don't have a valid value.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   A limit is exceeded.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   Access is throttled.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   One or more resources can't be found.
//
//   * ErrCodeUnsupportedUserEditionException "UnsupportedUserEditionException"
//   This error indicates that you are calling an operation on an Amazon QuickSight
//   subscription where the edition doesn't include support for that operation.
//   Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//   Not every operation and capability is available in every edition.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateDataSet
func (c *QuickSight) UpdateDataSet(input *UpdateDataSetInput) (*UpdateDataSetOutput, error) {
	req, out := c.UpdateDataSetRequest(input)
	return out, req.Send()
}

// UpdateDataSetWithContext is the same as UpdateDataSet with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDataSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) UpdateDataSetWithContext(ctx aws.Context, input *UpdateDataSetInput, opts ...request.Option) (*UpdateDataSetOutput, error) {
	req, out := c.UpdateDataSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDataSetPermissions = "UpdateDataSetPermissions"

// UpdateDataSetPermissionsRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDataSetPermissions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDataSetPermissions for more information on using the UpdateDataSetPermissions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateDataSetPermissionsRequest method.
//    req, resp := client.UpdateDataSetPermissionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateDataSetPermissions
func (c *QuickSight) UpdateDataSetPermissionsRequest(input *UpdateDataSetPermissionsInput) (req *request.Request, output *UpdateDataSetPermissionsOutput) {
	op := &request.Operation{
		Name:       opUpdateDataSetPermissions,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{AwsAccountId}/data-sets/{DataSetId}/permissions",
	}

	if input == nil {
		input = &UpdateDataSetPermissionsInput{}
	}

	output = &UpdateDataSetPermissionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateDataSetPermissions API operation for Amazon QuickSight.
//
// Updates the permissions on a dataset.
//
// The permissions resource is arn:aws:quicksight:region:aws-account-id:dataset/data-set-id.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation UpdateDataSetPermissions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You don't have access to this. The provided credentials couldn't be validated.
//   You might not be authorized to carry out the request. Ensure that your account
//   is authorized to use the Amazon QuickSight service, that your policies have
//   the correct permissions, and that you are using the correct access keys.
//
//   * ErrCodeConflictException "ConflictException"
//   Updating or deleting a resource can cause an inconsistent state.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One or more parameters don't have a valid value.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   One or more resources can't be found.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   Access is throttled.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateDataSetPermissions
func (c *QuickSight) UpdateDataSetPermissions(input *UpdateDataSetPermissionsInput) (*UpdateDataSetPermissionsOutput, error) {
	req, out := c.UpdateDataSetPermissionsRequest(input)
	return out, req.Send()
}

// UpdateDataSetPermissionsWithContext is the same as UpdateDataSetPermissions with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDataSetPermissions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) UpdateDataSetPermissionsWithContext(ctx aws.Context, input *UpdateDataSetPermissionsInput, opts ...request.Option) (*UpdateDataSetPermissionsOutput, error) {
	req, out := c.UpdateDataSetPermissionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDataSource = "UpdateDataSource"

// UpdateDataSourceRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDataSource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDataSource for more information on using the UpdateDataSource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateDataSourceRequest method.
//    req, resp := client.UpdateDataSourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateDataSource
func (c *QuickSight) UpdateDataSourceRequest(input *UpdateDataSourceInput) (req *request.Request, output *UpdateDataSourceOutput) {
	op := &request.Operation{
		Name:       opUpdateDataSource,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{AwsAccountId}/data-sources/{DataSourceId}",
	}

	if input == nil {
		input = &UpdateDataSourceInput{}
	}

	output = &UpdateDataSourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateDataSource API operation for Amazon QuickSight.
//
// Updates a data source.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation UpdateDataSource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You don't have access to this. The provided credentials couldn't be validated.
//   You might not be authorized to carry out the request. Ensure that your account
//   is authorized to use the Amazon QuickSight service, that your policies have
//   the correct permissions, and that you are using the correct access keys.
//
//   * ErrCodeConflictException "ConflictException"
//   Updating or deleting a resource can cause an inconsistent state.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One or more parameters don't have a valid value.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   Access is throttled.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   One or more resources can't be found.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateDataSource
func (c *QuickSight) UpdateDataSource(input *UpdateDataSourceInput) (*UpdateDataSourceOutput, error) {
	req, out := c.UpdateDataSourceRequest(input)
	return out, req.Send()
}

// UpdateDataSourceWithContext is the same as UpdateDataSource with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDataSource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) UpdateDataSourceWithContext(ctx aws.Context, input *UpdateDataSourceInput, opts ...request.Option) (*UpdateDataSourceOutput, error) {
	req, out := c.UpdateDataSourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDataSourcePermissions = "UpdateDataSourcePermissions"

// UpdateDataSourcePermissionsRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDataSourcePermissions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDataSourcePermissions for more information on using the UpdateDataSourcePermissions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateDataSourcePermissionsRequest method.
//    req, resp := client.UpdateDataSourcePermissionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateDataSourcePermissions
func (c *QuickSight) UpdateDataSourcePermissionsRequest(input *UpdateDataSourcePermissionsInput) (req *request.Request, output *UpdateDataSourcePermissionsOutput) {
	op := &request.Operation{
		Name:       opUpdateDataSourcePermissions,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{AwsAccountId}/data-sources/{DataSourceId}/permissions",
	}

	if input == nil {
		input = &UpdateDataSourcePermissionsInput{}
	}

	output = &UpdateDataSourcePermissionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateDataSourcePermissions API operation for Amazon QuickSight.
//
// Updates the permissions to a data source.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation UpdateDataSourcePermissions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You don't have access to this. The provided credentials couldn't be validated.
//   You might not be authorized to carry out the request. Ensure that your account
//   is authorized to use the Amazon QuickSight service, that your policies have
//   the correct permissions, and that you are using the correct access keys.
//
//   * ErrCodeConflictException "ConflictException"
//   Updating or deleting a resource can cause an inconsistent state.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One or more parameters don't have a valid value.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   One or more resources can't be found.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   Access is throttled.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateDataSourcePermissions
func (c *QuickSight) UpdateDataSourcePermissions(input *UpdateDataSourcePermissionsInput) (*UpdateDataSourcePermissionsOutput, error) {
	req, out := c.UpdateDataSourcePermissionsRequest(input)
	return out, req.Send()
}

// UpdateDataSourcePermissionsWithContext is the same as UpdateDataSourcePermissions with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDataSourcePermissions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) UpdateDataSourcePermissionsWithContext(ctx aws.Context, input *UpdateDataSourcePermissionsInput, opts ...request.Option) (*UpdateDataSourcePermissionsOutput, error) {
	req, out := c.UpdateDataSourcePermissionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateGroup = "UpdateGroup"

// UpdateGroupRequest generates a "aws/request.Request" representing the
// client's request for the UpdateGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateGroup for more information on using the UpdateGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateGroupRequest method.
//    req, resp := client.UpdateGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateGroup
func (c *QuickSight) UpdateGroupRequest(input *UpdateGroupInput) (req *request.Request, output *UpdateGroupOutput) {
	op := &request.Operation{
		Name:       opUpdateGroup,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/groups/{GroupName}",
	}

	if input == nil {
		input = &UpdateGroupInput{}
	}

	output = &UpdateGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateGroup API operation for Amazon QuickSight.
//
// Changes a group description.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation UpdateGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You don't have access to this. The provided credentials couldn't be validated.
//   You might not be authorized to carry out the request. Ensure that your account
//   is authorized to use the Amazon QuickSight service, that your policies have
//   the correct permissions, and that you are using the correct access keys.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One or more parameters don't have a valid value.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   One or more resources can't be found.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   Access is throttled.
//
//   * ErrCodePreconditionNotMetException "PreconditionNotMetException"
//   One or more preconditions aren't met.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal failure occurred.
//
//   * ErrCodeResourceUnavailableException "ResourceUnavailableException"
//   This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateGroup
func (c *QuickSight) UpdateGroup(input *UpdateGroupInput) (*UpdateGroupOutput, error) {
	req, out := c.UpdateGroupRequest(input)
	return out, req.Send()
}

// UpdateGroupWithContext is the same as UpdateGroup with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) UpdateGroupWithContext(ctx aws.Context, input *UpdateGroupInput, opts ...request.Option) (*UpdateGroupOutput, error) {
	req, out := c.UpdateGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateIAMPolicyAssignment = "UpdateIAMPolicyAssignment"

// UpdateIAMPolicyAssignmentRequest generates a "aws/request.Request" representing the
// client's request for the UpdateIAMPolicyAssignment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateIAMPolicyAssignment for more information on using the UpdateIAMPolicyAssignment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateIAMPolicyAssignmentRequest method.
//    req, resp := client.UpdateIAMPolicyAssignmentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateIAMPolicyAssignment
func (c *QuickSight) UpdateIAMPolicyAssignmentRequest(input *UpdateIAMPolicyAssignmentInput) (req *request.Request, output *UpdateIAMPolicyAssignmentOutput) {
	op := &request.Operation{
		Name:       opUpdateIAMPolicyAssignment,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/iam-policy-assignments/{AssignmentName}",
	}

	if input == nil {
		input = &UpdateIAMPolicyAssignmentInput{}
	}

	output = &UpdateIAMPolicyAssignmentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateIAMPolicyAssignment API operation for Amazon QuickSight.
//
// Updates an existing assignment. This operation updates only the optional
// parameter or parameters that are specified in the request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation UpdateIAMPolicyAssignment for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You don't have access to this. The provided credentials couldn't be validated.
//   You might not be authorized to carry out the request. Ensure that your account
//   is authorized to use the Amazon QuickSight service, that your policies have
//   the correct permissions, and that you are using the correct access keys.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One or more parameters don't have a valid value.
//
//   * ErrCodeResourceExistsException "ResourceExistsException"
//   The resource specified already exists.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   One or more resources can't be found.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   Access is throttled.
//
//   * ErrCodeConcurrentUpdatingException "ConcurrentUpdatingException"
//   A resource is already in an "actionable" state that must complete before
//   a new update can be applied.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateIAMPolicyAssignment
func (c *QuickSight) UpdateIAMPolicyAssignment(input *UpdateIAMPolicyAssignmentInput) (*UpdateIAMPolicyAssignmentOutput, error) {
	req, out := c.UpdateIAMPolicyAssignmentRequest(input)
	return out, req.Send()
}

// UpdateIAMPolicyAssignmentWithContext is the same as UpdateIAMPolicyAssignment with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateIAMPolicyAssignment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) UpdateIAMPolicyAssignmentWithContext(ctx aws.Context, input *UpdateIAMPolicyAssignmentInput, opts ...request.Option) (*UpdateIAMPolicyAssignmentOutput, error) {
	req, out := c.UpdateIAMPolicyAssignmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateTemplate = "UpdateTemplate"

// UpdateTemplateRequest generates a "aws/request.Request" representing the
// client's request for the UpdateTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateTemplate for more information on using the UpdateTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateTemplateRequest method.
//    req, resp := client.UpdateTemplateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateTemplate
func (c *QuickSight) UpdateTemplateRequest(input *UpdateTemplateInput) (req *request.Request, output *UpdateTemplateOutput) {
	op := &request.Operation{
		Name:       opUpdateTemplate,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{AwsAccountId}/templates/{TemplateId}",
	}

	if input == nil {
		input = &UpdateTemplateInput{}
	}

	output = &UpdateTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateTemplate API operation for Amazon QuickSight.
//
// Updates a template from an existing QuickSight analysis.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation UpdateTemplate for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One or more parameters don't have a valid value.
//
//   * ErrCodeResourceExistsException "ResourceExistsException"
//   The resource specified already exists.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   One or more resources can't be found.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   Access is throttled.
//
//   * ErrCodeConflictException "ConflictException"
//   Updating or deleting a resource can cause an inconsistent state.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   A limit is exceeded.
//
//   * ErrCodeUnsupportedUserEditionException "UnsupportedUserEditionException"
//   This error indicates that you are calling an operation on an Amazon QuickSight
//   subscription where the edition doesn't include support for that operation.
//   Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//   Not every operation and capability is available in every edition.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateTemplate
func (c *QuickSight) UpdateTemplate(input *UpdateTemplateInput) (*UpdateTemplateOutput, error) {
	req, out := c.UpdateTemplateRequest(input)
	return out, req.Send()
}

// UpdateTemplateWithContext is the same as UpdateTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) UpdateTemplateWithContext(ctx aws.Context, input *UpdateTemplateInput, opts ...request.Option) (*UpdateTemplateOutput, error) {
	req, out := c.UpdateTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateTemplateAlias = "UpdateTemplateAlias"

// UpdateTemplateAliasRequest generates a "aws/request.Request" representing the
// client's request for the UpdateTemplateAlias operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateTemplateAlias for more information on using the UpdateTemplateAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateTemplateAliasRequest method.
//    req, resp := client.UpdateTemplateAliasRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateTemplateAlias
func (c *QuickSight) UpdateTemplateAliasRequest(input *UpdateTemplateAliasInput) (req *request.Request, output *UpdateTemplateAliasOutput) {
	op := &request.Operation{
		Name:       opUpdateTemplateAlias,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{AwsAccountId}/templates/{TemplateId}/aliases/{AliasName}",
	}

	if input == nil {
		input = &UpdateTemplateAliasInput{}
	}

	output = &UpdateTemplateAliasOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateTemplateAlias API operation for Amazon QuickSight.
//
// Updates the template alias of a template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation UpdateTemplateAlias for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeThrottlingException "ThrottlingException"
//   Access is throttled.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   One or more resources can't be found.
//
//   * ErrCodeConflictException "ConflictException"
//   Updating or deleting a resource can cause an inconsistent state.
//
//   * ErrCodeUnsupportedUserEditionException "UnsupportedUserEditionException"
//   This error indicates that you are calling an operation on an Amazon QuickSight
//   subscription where the edition doesn't include support for that operation.
//   Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//   Not every operation and capability is available in every edition.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateTemplateAlias
func (c *QuickSight) UpdateTemplateAlias(input *UpdateTemplateAliasInput) (*UpdateTemplateAliasOutput, error) {
	req, out := c.UpdateTemplateAliasRequest(input)
	return out, req.Send()
}

// UpdateTemplateAliasWithContext is the same as UpdateTemplateAlias with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateTemplateAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) UpdateTemplateAliasWithContext(ctx aws.Context, input *UpdateTemplateAliasInput, opts ...request.Option) (*UpdateTemplateAliasOutput, error) {
	req, out := c.UpdateTemplateAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateTemplatePermissions = "UpdateTemplatePermissions"

// UpdateTemplatePermissionsRequest generates a "aws/request.Request" representing the
// client's request for the UpdateTemplatePermissions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateTemplatePermissions for more information on using the UpdateTemplatePermissions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateTemplatePermissionsRequest method.
//    req, resp := client.UpdateTemplatePermissionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateTemplatePermissions
func (c *QuickSight) UpdateTemplatePermissionsRequest(input *UpdateTemplatePermissionsInput) (req *request.Request, output *UpdateTemplatePermissionsOutput) {
	op := &request.Operation{
		Name:       opUpdateTemplatePermissions,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{AwsAccountId}/templates/{TemplateId}/permissions",
	}

	if input == nil {
		input = &UpdateTemplatePermissionsInput{}
	}

	output = &UpdateTemplatePermissionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateTemplatePermissions API operation for Amazon QuickSight.
//
// Updates the permissions on a template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation UpdateTemplatePermissions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeThrottlingException "ThrottlingException"
//   Access is throttled.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One or more parameters don't have a valid value.
//
//   * ErrCodeConflictException "ConflictException"
//   Updating or deleting a resource can cause an inconsistent state.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   One or more resources can't be found.
//
//   * ErrCodeUnsupportedUserEditionException "UnsupportedUserEditionException"
//   This error indicates that you are calling an operation on an Amazon QuickSight
//   subscription where the edition doesn't include support for that operation.
//   Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//   Not every operation and capability is available in every edition.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateTemplatePermissions
func (c *QuickSight) UpdateTemplatePermissions(input *UpdateTemplatePermissionsInput) (*UpdateTemplatePermissionsOutput, error) {
	req, out := c.UpdateTemplatePermissionsRequest(input)
	return out, req.Send()
}

// UpdateTemplatePermissionsWithContext is the same as UpdateTemplatePermissions with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateTemplatePermissions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) UpdateTemplatePermissionsWithContext(ctx aws.Context, input *UpdateTemplatePermissionsInput, opts ...request.Option) (*UpdateTemplatePermissionsOutput, error) {
	req, out := c.UpdateTemplatePermissionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateUser = "UpdateUser"

// UpdateUserRequest generates a "aws/request.Request" representing the
// client's request for the UpdateUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateUser for more information on using the UpdateUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateUserRequest method.
//    req, resp := client.UpdateUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateUser
func (c *QuickSight) UpdateUserRequest(input *UpdateUserInput) (req *request.Request, output *UpdateUserOutput) {
	op := &request.Operation{
		Name:       opUpdateUser,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/users/{UserName}",
	}

	if input == nil {
		input = &UpdateUserInput{}
	}

	output = &UpdateUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateUser API operation for Amazon QuickSight.
//
// Updates an Amazon QuickSight user.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation UpdateUser for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You don't have access to this. The provided credentials couldn't be validated.
//   You might not be authorized to carry out the request. Ensure that your account
//   is authorized to use the Amazon QuickSight service, that your policies have
//   the correct permissions, and that you are using the correct access keys.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One or more parameters don't have a valid value.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   One or more resources can't be found.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   Access is throttled.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal failure occurred.
//
//   * ErrCodeResourceUnavailableException "ResourceUnavailableException"
//   This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateUser
func (c *QuickSight) UpdateUser(input *UpdateUserInput) (*UpdateUserOutput, error) {
	req, out := c.UpdateUserRequest(input)
	return out, req.Send()
}

// UpdateUserWithContext is the same as UpdateUser with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) UpdateUserWithContext(ctx aws.Context, input *UpdateUserInput, opts ...request.Option) (*UpdateUserOutput, error) {
	req, out := c.UpdateUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// The active AWS Identity and Access Management (IAM) policy assignment.
type ActiveIAMPolicyAssignment struct {
	_ struct{} `type:"structure"`

	// A name for the IAM policy assignment.
	AssignmentName *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the resource.
	PolicyArn *string `type:"string"`
}

// String returns the string representation
func (s ActiveIAMPolicyAssignment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ActiveIAMPolicyAssignment) GoString() string {
	return s.String()
}

// SetAssignmentName sets the AssignmentName field's value.
func (s *ActiveIAMPolicyAssignment) SetAssignmentName(v string) *ActiveIAMPolicyAssignment {
	s.AssignmentName = &v
	return s
}

// SetPolicyArn sets the PolicyArn field's value.
func (s *ActiveIAMPolicyAssignment) SetPolicyArn(v string) *ActiveIAMPolicyAssignment {
	s.PolicyArn = &v
	return s
}

// Ad hoc (one-time) filtering option.
type AdHocFilteringOption struct {
	_ struct{} `type:"structure"`

	// Availability status.
	AvailabilityStatus *string `type:"string" enum:"DashboardBehavior"`
}

// String returns the string representation
func (s AdHocFilteringOption) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AdHocFilteringOption) GoString() string {
	return s.String()
}

// SetAvailabilityStatus sets the AvailabilityStatus field's value.
func (s *AdHocFilteringOption) SetAvailabilityStatus(v string) *AdHocFilteringOption {
	s.AvailabilityStatus = &v
	return s
}

// Amazon Elasticsearch Service parameters.
type AmazonElasticsearchParameters struct {
	_ struct{} `type:"structure"`

	// The Amazon Elasticsearch Service domain.
	//
	// Domain is a required field
	Domain *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AmazonElasticsearchParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AmazonElasticsearchParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AmazonElasticsearchParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AmazonElasticsearchParameters"}
	if s.Domain == nil {
		invalidParams.Add(request.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Domain", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomain sets the Domain field's value.
func (s *AmazonElasticsearchParameters) SetDomain(v string) *AmazonElasticsearchParameters {
	s.Domain = &v
	return s
}

// Amazon Athena parameters.
type AthenaParameters struct {
	_ struct{} `type:"structure"`

	// The workgroup that Amazon Athena uses.
	WorkGroup *string `min:"1" type:"string"`
}

// String returns the string representation
func (s AthenaParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AthenaParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AthenaParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AthenaParameters"}
	if s.WorkGroup != nil && len(*s.WorkGroup) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkGroup", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetWorkGroup sets the WorkGroup field's value.
func (s *AthenaParameters) SetWorkGroup(v string) *AthenaParameters {
	s.WorkGroup = &v
	return s
}

// Amazon Aurora parameters.
type AuroraParameters struct {
	_ struct{} `type:"structure"`

	// Database.
	//
	// Database is a required field
	Database *string `min:"1" type:"string" required:"true"`

	// Host.
	//
	// Host is a required field
	Host *string `min:"1" type:"string" required:"true"`

	// Port.
	//
	// Port is a required field
	Port *int64 `min:"1" type:"integer" required:"true"`
}

// String returns the string representation
func (s AuroraParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AuroraParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AuroraParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AuroraParameters"}
	if s.Database == nil {
		invalidParams.Add(request.NewErrParamRequired("Database"))
	}
	if s.Database != nil && len(*s.Database) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Database", 1))
	}
	if s.Host == nil {
		invalidParams.Add(request.NewErrParamRequired("Host"))
	}
	if s.Host != nil && len(*s.Host) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Host", 1))
	}
	if s.Port == nil {
		invalidParams.Add(request.NewErrParamRequired("Port"))
	}
	if s.Port != nil && *s.Port < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Port", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatabase sets the Database field's value.
func (s *AuroraParameters) SetDatabase(v string) *AuroraParameters {
	s.Database = &v
	return s
}

// SetHost sets the Host field's value.
func (s *AuroraParameters) SetHost(v string) *AuroraParameters {
	s.Host = &v
	return s
}

// SetPort sets the Port field's value.
func (s *AuroraParameters) SetPort(v int64) *AuroraParameters {
	s.Port = &v
	return s
}

// Amazon Aurora with PostgreSQL compatibility parameters.
type AuroraPostgreSqlParameters struct {
	_ struct{} `type:"structure"`

	// Database.
	//
	// Database is a required field
	Database *string `min:"1" type:"string" required:"true"`

	// Host.
	//
	// Host is a required field
	Host *string `min:"1" type:"string" required:"true"`

	// Port.
	//
	// Port is a required field
	Port *int64 `min:"1" type:"integer" required:"true"`
}

// String returns the string representation
func (s AuroraPostgreSqlParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AuroraPostgreSqlParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AuroraPostgreSqlParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AuroraPostgreSqlParameters"}
	if s.Database == nil {
		invalidParams.Add(request.NewErrParamRequired("Database"))
	}
	if s.Database != nil && len(*s.Database) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Database", 1))
	}
	if s.Host == nil {
		invalidParams.Add(request.NewErrParamRequired("Host"))
	}
	if s.Host != nil && len(*s.Host) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Host", 1))
	}
	if s.Port == nil {
		invalidParams.Add(request.NewErrParamRequired("Port"))
	}
	if s.Port != nil && *s.Port < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Port", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatabase sets the Database field's value.
func (s *AuroraPostgreSqlParameters) SetDatabase(v string) *AuroraPostgreSqlParameters {
	s.Database = &v
	return s
}

// SetHost sets the Host field's value.
func (s *AuroraPostgreSqlParameters) SetHost(v string) *AuroraPostgreSqlParameters {
	s.Host = &v
	return s
}

// SetPort sets the Port field's value.
func (s *AuroraPostgreSqlParameters) SetPort(v int64) *AuroraPostgreSqlParameters {
	s.Port = &v
	return s
}

// AWS IoT Analytics parameters.
type AwsIotAnalyticsParameters struct {
	_ struct{} `type:"structure"`

	// Dataset name.
	//
	// DataSetName is a required field
	DataSetName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AwsIotAnalyticsParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsIotAnalyticsParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AwsIotAnalyticsParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AwsIotAnalyticsParameters"}
	if s.DataSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSetName"))
	}
	if s.DataSetName != nil && len(*s.DataSetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataSetName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataSetName sets the DataSetName field's value.
func (s *AwsIotAnalyticsParameters) SetDataSetName(v string) *AwsIotAnalyticsParameters {
	s.DataSetName = &v
	return s
}

// A calculated column for a dataset.
type CalculatedColumn struct {
	_ struct{} `type:"structure"`

	// A unique ID to identify a calculated column. During dataset update, if the
	// column ID of a calculated column matches that of an existing calculated column,
	// QuickSight preserves the existing calculated column.
	//
	// ColumnId is a required field
	ColumnId *string `min:"1" type:"string" required:"true"`

	// Column name.
	//
	// ColumnName is a required field
	ColumnName *string `min:"1" type:"string" required:"true"`

	// An expression that defines the calculated column.
	//
	// Expression is a required field
	Expression *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CalculatedColumn) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CalculatedColumn) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CalculatedColumn) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CalculatedColumn"}
	if s.ColumnId == nil {
		invalidParams.Add(request.NewErrParamRequired("ColumnId"))
	}
	if s.ColumnId != nil && len(*s.ColumnId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ColumnId", 1))
	}
	if s.ColumnName == nil {
		invalidParams.Add(request.NewErrParamRequired("ColumnName"))
	}
	if s.ColumnName != nil && len(*s.ColumnName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ColumnName", 1))
	}
	if s.Expression == nil {
		invalidParams.Add(request.NewErrParamRequired("Expression"))
	}
	if s.Expression != nil && len(*s.Expression) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Expression", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetColumnId sets the ColumnId field's value.
func (s *CalculatedColumn) SetColumnId(v string) *CalculatedColumn {
	s.ColumnId = &v
	return s
}

// SetColumnName sets the ColumnName field's value.
func (s *CalculatedColumn) SetColumnName(v string) *CalculatedColumn {
	s.ColumnName = &v
	return s
}

// SetExpression sets the Expression field's value.
func (s *CalculatedColumn) SetExpression(v string) *CalculatedColumn {
	s.Expression = &v
	return s
}

type CancelIngestionInput struct {
	_ struct{} `type:"structure"`

	// The AWS account ID.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The ID of the dataset used in the ingestion.
	//
	// DataSetId is a required field
	DataSetId *string `location:"uri" locationName:"DataSetId" type:"string" required:"true"`

	// An ID for the ingestion.
	//
	// IngestionId is a required field
	IngestionId *string `location:"uri" locationName:"IngestionId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CancelIngestionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelIngestionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelIngestionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelIngestionInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.DataSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSetId"))
	}
	if s.DataSetId != nil && len(*s.DataSetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataSetId", 1))
	}
	if s.IngestionId == nil {
		invalidParams.Add(request.NewErrParamRequired("IngestionId"))
	}
	if s.IngestionId != nil && len(*s.IngestionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IngestionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *CancelIngestionInput) SetAwsAccountId(v string) *CancelIngestionInput {
	s.AwsAccountId = &v
	return s
}

// SetDataSetId sets the DataSetId field's value.
func (s *CancelIngestionInput) SetDataSetId(v string) *CancelIngestionInput {
	s.DataSetId = &v
	return s
}

// SetIngestionId sets the IngestionId field's value.
func (s *CancelIngestionInput) SetIngestionId(v string) *CancelIngestionInput {
	s.IngestionId = &v
	return s
}

type CancelIngestionOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the data ingestion.
	Arn *string `type:"string"`

	// An ID for the ingestion.
	IngestionId *string `min:"1" type:"string"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation
func (s CancelIngestionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelIngestionOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CancelIngestionOutput) SetArn(v string) *CancelIngestionOutput {
	s.Arn = &v
	return s
}

// SetIngestionId sets the IngestionId field's value.
func (s *CancelIngestionOutput) SetIngestionId(v string) *CancelIngestionOutput {
	s.IngestionId = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *CancelIngestionOutput) SetRequestId(v string) *CancelIngestionOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CancelIngestionOutput) SetStatus(v int64) *CancelIngestionOutput {
	s.Status = &v
	return s
}

// A transform operation that casts a column to a different type.
type CastColumnTypeOperation struct {
	_ struct{} `type:"structure"`

	// Column name.
	//
	// ColumnName is a required field
	ColumnName *string `min:"1" type:"string" required:"true"`

	// When casting a column from string to datetime type, you can supply a QuickSight
	// supported format string to denote the source data format.
	Format *string `type:"string"`

	// New column data type.
	//
	// NewColumnType is a required field
	NewColumnType *string `type:"string" required:"true" enum:"ColumnDataType"`
}

// String returns the string representation
func (s CastColumnTypeOperation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CastColumnTypeOperation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CastColumnTypeOperation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CastColumnTypeOperation"}
	if s.ColumnName == nil {
		invalidParams.Add(request.NewErrParamRequired("ColumnName"))
	}
	if s.ColumnName != nil && len(*s.ColumnName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ColumnName", 1))
	}
	if s.NewColumnType == nil {
		invalidParams.Add(request.NewErrParamRequired("NewColumnType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetColumnName sets the ColumnName field's value.
func (s *CastColumnTypeOperation) SetColumnName(v string) *CastColumnTypeOperation {
	s.ColumnName = &v
	return s
}

// SetFormat sets the Format field's value.
func (s *CastColumnTypeOperation) SetFormat(v string) *CastColumnTypeOperation {
	s.Format = &v
	return s
}

// SetNewColumnType sets the NewColumnType field's value.
func (s *CastColumnTypeOperation) SetNewColumnType(v string) *CastColumnTypeOperation {
	s.NewColumnType = &v
	return s
}

// Groupings of columns that work together in certain QuickSight features. This
// is a variant type structure. No more than one of the attributes should be
// non-null for this structure to be valid.
type ColumnGroup struct {
	_ struct{} `type:"structure"`

	// Geospatial column group that denotes a hierarchy.
	GeoSpatialColumnGroup *GeoSpatialColumnGroup `type:"structure"`
}

// String returns the string representation
func (s ColumnGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ColumnGroup) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ColumnGroup) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ColumnGroup"}
	if s.GeoSpatialColumnGroup != nil {
		if err := s.GeoSpatialColumnGroup.Validate(); err != nil {
			invalidParams.AddNested("GeoSpatialColumnGroup", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGeoSpatialColumnGroup sets the GeoSpatialColumnGroup field's value.
func (s *ColumnGroup) SetGeoSpatialColumnGroup(v *GeoSpatialColumnGroup) *ColumnGroup {
	s.GeoSpatialColumnGroup = v
	return s
}

// A structure describing the name, datatype, and geographic role of the columns.
type ColumnGroupColumnSchema struct {
	_ struct{} `type:"structure"`

	// The name of the column group's column schema.
	Name *string `type:"string"`
}

// String returns the string representation
func (s ColumnGroupColumnSchema) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ColumnGroupColumnSchema) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *ColumnGroupColumnSchema) SetName(v string) *ColumnGroupColumnSchema {
	s.Name = &v
	return s
}

// The column group schema.
type ColumnGroupSchema struct {
	_ struct{} `type:"structure"`

	// A structure containing the list of column group column schemas.
	ColumnGroupColumnSchemaList []*ColumnGroupColumnSchema `type:"list"`

	// The name of the column group schema.
	Name *string `type:"string"`
}

// String returns the string representation
func (s ColumnGroupSchema) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ColumnGroupSchema) GoString() string {
	return s.String()
}

// SetColumnGroupColumnSchemaList sets the ColumnGroupColumnSchemaList field's value.
func (s *ColumnGroupSchema) SetColumnGroupColumnSchemaList(v []*ColumnGroupColumnSchema) *ColumnGroupSchema {
	s.ColumnGroupColumnSchemaList = v
	return s
}

// SetName sets the Name field's value.
func (s *ColumnGroupSchema) SetName(v string) *ColumnGroupSchema {
	s.Name = &v
	return s
}

// The column schema.
type ColumnSchema struct {
	_ struct{} `type:"structure"`

	// The data type of the column schema.
	DataType *string `type:"string"`

	// The geographic role of the column schema.
	GeographicRole *string `type:"string"`

	// The name of the column schema.
	Name *string `type:"string"`
}

// String returns the string representation
func (s ColumnSchema) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ColumnSchema) GoString() string {
	return s.String()
}

// SetDataType sets the DataType field's value.
func (s *ColumnSchema) SetDataType(v string) *ColumnSchema {
	s.DataType = &v
	return s
}

// SetGeographicRole sets the GeographicRole field's value.
func (s *ColumnSchema) SetGeographicRole(v string) *ColumnSchema {
	s.GeographicRole = &v
	return s
}

// SetName sets the Name field's value.
func (s *ColumnSchema) SetName(v string) *ColumnSchema {
	s.Name = &v
	return s
}

// A tag for a column in a TagColumnOperation. This is a variant type structure.
// No more than one of the attributes should be non-null for this structure
// to be valid.
type ColumnTag struct {
	_ struct{} `type:"structure"`

	// A geospatial role for a column.
	ColumnGeographicRole *string `type:"string" enum:"GeoSpatialDataRole"`
}

// String returns the string representation
func (s ColumnTag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ColumnTag) GoString() string {
	return s.String()
}

// SetColumnGeographicRole sets the ColumnGeographicRole field's value.
func (s *ColumnTag) SetColumnGeographicRole(v string) *ColumnTag {
	s.ColumnGeographicRole = &v
	return s
}

// A transform operation that creates calculated columns. Columns created in
// one such operation form a lexical closure.
type CreateColumnsOperation struct {
	_ struct{} `type:"structure"`

	// Calculated columns to create.
	//
	// Columns is a required field
	Columns []*CalculatedColumn `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s CreateColumnsOperation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateColumnsOperation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateColumnsOperation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateColumnsOperation"}
	if s.Columns == nil {
		invalidParams.Add(request.NewErrParamRequired("Columns"))
	}
	if s.Columns != nil && len(s.Columns) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Columns", 1))
	}
	if s.Columns != nil {
		for i, v := range s.Columns {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Columns", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetColumns sets the Columns field's value.
func (s *CreateColumnsOperation) SetColumns(v []*CalculatedColumn) *CreateColumnsOperation {
	s.Columns = v
	return s
}

type CreateDashboardInput struct {
	_ struct{} `type:"structure"`

	// AWS account ID where you want to create the dashboard.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The ID for the dashboard, also added to IAM policy.
	//
	// DashboardId is a required field
	DashboardId *string `location:"uri" locationName:"DashboardId" min:"1" type:"string" required:"true"`

	// Publishing options when creating dashboard.
	//
	//    * AvailabilityStatus for AdHocFilteringOption - This can be either ENABLED
	//    or DISABLED. When This is set to set to DISABLED, QuickSight disables
	//    the left filter pane on the published dashboard, which can be used for
	//    AdHoc filtering. Enabled by default.
	//
	//    * AvailabilityStatus for ExportToCSVOption - This can be either ENABLED
	//    or DISABLED. The visual option to export data to CSV is disabled when
	//    this is set to DISABLED. Enabled by default.
	//
	//    * VisibilityState for SheetControlsOption - This can be either COLLAPSED
	//    or EXPANDED. The sheet controls pane is collapsed by default when set
	//    to true. Collapsed by default.
	DashboardPublishOptions *DashboardPublishOptions `type:"structure"`

	// The display name of the dashboard.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// A structure that contains the parameters of the dashboard. These are parameter
	// overrides for a dashboard. A dashboard can have any type of parameters and
	// some parameters might accept multiple values. You could use the following
	// structure to override two string parameters that accept multiple values:
	Parameters *Parameters `type:"structure"`

	// A structure that contains the permissions of the dashboard. You can use this
	// for granting permissions with principal and action information.
	Permissions []*ResourcePermission `min:"1" type:"list"`

	// Source entity from which the dashboard is created. The souce entity accepts
	// the Amazon Resource Name (ARN) of the source template or analysis and also
	// references the replacement datasets for the placeholders set when creating
	// the template. The replacement datasets need to follow the same schema as
	// the datasets for which placeholders were created when creating the template.
	//
	// If you are creating a dashboard from a source entity in a different AWS account,
	// use the ARN of the source template.
	//
	// SourceEntity is a required field
	SourceEntity *DashboardSourceEntity `type:"structure" required:"true"`

	// Contains a map of the key-value pairs for the resource tag or tags assigned
	// to the dashboard.
	Tags []*Tag `min:"1" type:"list"`

	// A description for the first version of the dashboard being created.
	VersionDescription *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CreateDashboardInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDashboardInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDashboardInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDashboardInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.DashboardId == nil {
		invalidParams.Add(request.NewErrParamRequired("DashboardId"))
	}
	if s.DashboardId != nil && len(*s.DashboardId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DashboardId", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Permissions != nil && len(s.Permissions) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Permissions", 1))
	}
	if s.SourceEntity == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceEntity"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.VersionDescription != nil && len(*s.VersionDescription) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VersionDescription", 1))
	}
	if s.Parameters != nil {
		if err := s.Parameters.Validate(); err != nil {
			invalidParams.AddNested("Parameters", err.(request.ErrInvalidParams))
		}
	}
	if s.Permissions != nil {
		for i, v := range s.Permissions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Permissions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.SourceEntity != nil {
		if err := s.SourceEntity.Validate(); err != nil {
			invalidParams.AddNested("SourceEntity", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *CreateDashboardInput) SetAwsAccountId(v string) *CreateDashboardInput {
	s.AwsAccountId = &v
	return s
}

// SetDashboardId sets the DashboardId field's value.
func (s *CreateDashboardInput) SetDashboardId(v string) *CreateDashboardInput {
	s.DashboardId = &v
	return s
}

// SetDashboardPublishOptions sets the DashboardPublishOptions field's value.
func (s *CreateDashboardInput) SetDashboardPublishOptions(v *DashboardPublishOptions) *CreateDashboardInput {
	s.DashboardPublishOptions = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateDashboardInput) SetName(v string) *CreateDashboardInput {
	s.Name = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *CreateDashboardInput) SetParameters(v *Parameters) *CreateDashboardInput {
	s.Parameters = v
	return s
}

// SetPermissions sets the Permissions field's value.
func (s *CreateDashboardInput) SetPermissions(v []*ResourcePermission) *CreateDashboardInput {
	s.Permissions = v
	return s
}

// SetSourceEntity sets the SourceEntity field's value.
func (s *CreateDashboardInput) SetSourceEntity(v *DashboardSourceEntity) *CreateDashboardInput {
	s.SourceEntity = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDashboardInput) SetTags(v []*Tag) *CreateDashboardInput {
	s.Tags = v
	return s
}

// SetVersionDescription sets the VersionDescription field's value.
func (s *CreateDashboardInput) SetVersionDescription(v string) *CreateDashboardInput {
	s.VersionDescription = &v
	return s
}

type CreateDashboardOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the dashboard.
	Arn *string `type:"string"`

	// The creation status of the dashboard create request.
	CreationStatus *string `type:"string" enum:"ResourceStatus"`

	// The ID for the dashboard.
	DashboardId *string `min:"1" type:"string"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`

	// The ARN of the dashboard, including the version number of the first version
	// that is created.
	VersionArn *string `type:"string"`
}

// String returns the string representation
func (s CreateDashboardOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDashboardOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateDashboardOutput) SetArn(v string) *CreateDashboardOutput {
	s.Arn = &v
	return s
}

// SetCreationStatus sets the CreationStatus field's value.
func (s *CreateDashboardOutput) SetCreationStatus(v string) *CreateDashboardOutput {
	s.CreationStatus = &v
	return s
}

// SetDashboardId sets the DashboardId field's value.
func (s *CreateDashboardOutput) SetDashboardId(v string) *CreateDashboardOutput {
	s.DashboardId = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *CreateDashboardOutput) SetRequestId(v string) *CreateDashboardOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateDashboardOutput) SetStatus(v int64) *CreateDashboardOutput {
	s.Status = &v
	return s
}

// SetVersionArn sets the VersionArn field's value.
func (s *CreateDashboardOutput) SetVersionArn(v string) *CreateDashboardOutput {
	s.VersionArn = &v
	return s
}

type CreateDataSetInput struct {
	_ struct{} `type:"structure"`

	// The AWS Account ID.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// Groupings of columns that work together in certain QuickSight features. Currently,
	// only geospatial hierarchy is supported.
	ColumnGroups []*ColumnGroup `min:"1" type:"list"`

	// An ID for the dataset that you want to create. This ID is unique per AWS
	// Region for each AWS account.
	//
	// DataSetId is a required field
	DataSetId *string `type:"string" required:"true"`

	// Indicates whether or not you want to import the data into SPICE.
	//
	// ImportMode is a required field
	ImportMode *string `type:"string" required:"true" enum:"DataSetImportMode"`

	// Configures the combination and transformation of the data from the physical
	// tables.
	LogicalTableMap map[string]*LogicalTable `min:"1" type:"map"`

	// The display name for the dataset.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// A list of resource permissions on the dataset.
	Permissions []*ResourcePermission `min:"1" type:"list"`

	// Declares the physical tables that are available in the underlying data sources.
	//
	// PhysicalTableMap is a required field
	PhysicalTableMap map[string]*PhysicalTable `min:"1" type:"map" required:"true"`

	// Row-level security configuration on the data you want to create.
	RowLevelPermissionDataSet *RowLevelPermissionDataSet `type:"structure"`

	// Contains a map of the key-value pairs for the resource tag or tags assigned
	// to the dataset.
	Tags []*Tag `min:"1" type:"list"`
}

// String returns the string representation
func (s CreateDataSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDataSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDataSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDataSetInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.ColumnGroups != nil && len(s.ColumnGroups) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ColumnGroups", 1))
	}
	if s.DataSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSetId"))
	}
	if s.ImportMode == nil {
		invalidParams.Add(request.NewErrParamRequired("ImportMode"))
	}
	if s.LogicalTableMap != nil && len(s.LogicalTableMap) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LogicalTableMap", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Permissions != nil && len(s.Permissions) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Permissions", 1))
	}
	if s.PhysicalTableMap == nil {
		invalidParams.Add(request.NewErrParamRequired("PhysicalTableMap"))
	}
	if s.PhysicalTableMap != nil && len(s.PhysicalTableMap) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PhysicalTableMap", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.ColumnGroups != nil {
		for i, v := range s.ColumnGroups {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ColumnGroups", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.LogicalTableMap != nil {
		for i, v := range s.LogicalTableMap {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "LogicalTableMap", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Permissions != nil {
		for i, v := range s.Permissions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Permissions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.PhysicalTableMap != nil {
		for i, v := range s.PhysicalTableMap {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "PhysicalTableMap", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.RowLevelPermissionDataSet != nil {
		if err := s.RowLevelPermissionDataSet.Validate(); err != nil {
			invalidParams.AddNested("RowLevelPermissionDataSet", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *CreateDataSetInput) SetAwsAccountId(v string) *CreateDataSetInput {
	s.AwsAccountId = &v
	return s
}

// SetColumnGroups sets the ColumnGroups field's value.
func (s *CreateDataSetInput) SetColumnGroups(v []*ColumnGroup) *CreateDataSetInput {
	s.ColumnGroups = v
	return s
}

// SetDataSetId sets the DataSetId field's value.
func (s *CreateDataSetInput) SetDataSetId(v string) *CreateDataSetInput {
	s.DataSetId = &v
	return s
}

// SetImportMode sets the ImportMode field's value.
func (s *CreateDataSetInput) SetImportMode(v string) *CreateDataSetInput {
	s.ImportMode = &v
	return s
}

// SetLogicalTableMap sets the LogicalTableMap field's value.
func (s *CreateDataSetInput) SetLogicalTableMap(v map[string]*LogicalTable) *CreateDataSetInput {
	s.LogicalTableMap = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateDataSetInput) SetName(v string) *CreateDataSetInput {
	s.Name = &v
	return s
}

// SetPermissions sets the Permissions field's value.
func (s *CreateDataSetInput) SetPermissions(v []*ResourcePermission) *CreateDataSetInput {
	s.Permissions = v
	return s
}

// SetPhysicalTableMap sets the PhysicalTableMap field's value.
func (s *CreateDataSetInput) SetPhysicalTableMap(v map[string]*PhysicalTable) *CreateDataSetInput {
	s.PhysicalTableMap = v
	return s
}

// SetRowLevelPermissionDataSet sets the RowLevelPermissionDataSet field's value.
func (s *CreateDataSetInput) SetRowLevelPermissionDataSet(v *RowLevelPermissionDataSet) *CreateDataSetInput {
	s.RowLevelPermissionDataSet = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDataSetInput) SetTags(v []*Tag) *CreateDataSetInput {
	s.Tags = v
	return s
}

type CreateDataSetOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the dataset.
	Arn *string `type:"string"`

	// The ID for the dataset that you want to create. This ID is unique per AWS
	// Region for each AWS account.
	DataSetId *string `type:"string"`

	// The ARN for the ingestion, which is triggered as a result of dataset creation
	// if the import mode is SPICE
	IngestionArn *string `type:"string"`

	// The ID of the ingestion, which is triggered as a result of dataset creation
	// if the import mode is SPICE
	IngestionId *string `type:"string"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation
func (s CreateDataSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDataSetOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateDataSetOutput) SetArn(v string) *CreateDataSetOutput {
	s.Arn = &v
	return s
}

// SetDataSetId sets the DataSetId field's value.
func (s *CreateDataSetOutput) SetDataSetId(v string) *CreateDataSetOutput {
	s.DataSetId = &v
	return s
}

// SetIngestionArn sets the IngestionArn field's value.
func (s *CreateDataSetOutput) SetIngestionArn(v string) *CreateDataSetOutput {
	s.IngestionArn = &v
	return s
}

// SetIngestionId sets the IngestionId field's value.
func (s *CreateDataSetOutput) SetIngestionId(v string) *CreateDataSetOutput {
	s.IngestionId = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *CreateDataSetOutput) SetRequestId(v string) *CreateDataSetOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateDataSetOutput) SetStatus(v int64) *CreateDataSetOutput {
	s.Status = &v
	return s
}

type CreateDataSourceInput struct {
	_ struct{} `type:"structure"`

	// The AWS account ID.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The credentials QuickSight that uses to connect to your underlying source.
	// Currently, only credentials based on user name and password are supported.
	Credentials *DataSourceCredentials `type:"structure" sensitive:"true"`

	// An ID for the data source. This ID is unique per AWS Region for each AWS
	// account.
	//
	// DataSourceId is a required field
	DataSourceId *string `type:"string" required:"true"`

	// The parameters that QuickSight uses to connect to your underlying source.
	DataSourceParameters *DataSourceParameters `type:"structure"`

	// A display name for the data source.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// A list of resource permissions on the data source.
	Permissions []*ResourcePermission `min:"1" type:"list"`

	// Secure Socket Layer (SSL) properties that apply when QuickSight connects
	// to your underlying source.
	SslProperties *SslProperties `type:"structure"`

	// Contains a map of the key-value pairs for the resource tag or tags assigned
	// to the data source.
	Tags []*Tag `min:"1" type:"list"`

	// The type of the data source. Currently, the supported types for this operation
	// are: ATHENA, AURORA, AURORA_POSTGRESQL, MARIADB, MYSQL, POSTGRESQL, PRESTO,
	// REDSHIFT, S3, SNOWFLAKE, SPARK, SQLSERVER, TERADATA. Use ListDataSources
	// to return a list of all data sources.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"DataSourceType"`

	// Use this parameter only when you want QuickSight to use a VPC connection
	// when connecting to your underlying source.
	VpcConnectionProperties *VpcConnectionProperties `type:"structure"`
}

// String returns the string representation
func (s CreateDataSourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDataSourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDataSourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDataSourceInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.DataSourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSourceId"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Permissions != nil && len(s.Permissions) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Permissions", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.Credentials != nil {
		if err := s.Credentials.Validate(); err != nil {
			invalidParams.AddNested("Credentials", err.(request.ErrInvalidParams))
		}
	}
	if s.DataSourceParameters != nil {
		if err := s.DataSourceParameters.Validate(); err != nil {
			invalidParams.AddNested("DataSourceParameters", err.(request.ErrInvalidParams))
		}
	}
	if s.Permissions != nil {
		for i, v := range s.Permissions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Permissions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.VpcConnectionProperties != nil {
		if err := s.VpcConnectionProperties.Validate(); err != nil {
			invalidParams.AddNested("VpcConnectionProperties", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *CreateDataSourceInput) SetAwsAccountId(v string) *CreateDataSourceInput {
	s.AwsAccountId = &v
	return s
}

// SetCredentials sets the Credentials field's value.
func (s *CreateDataSourceInput) SetCredentials(v *DataSourceCredentials) *CreateDataSourceInput {
	s.Credentials = v
	return s
}

// SetDataSourceId sets the DataSourceId field's value.
func (s *CreateDataSourceInput) SetDataSourceId(v string) *CreateDataSourceInput {
	s.DataSourceId = &v
	return s
}

// SetDataSourceParameters sets the DataSourceParameters field's value.
func (s *CreateDataSourceInput) SetDataSourceParameters(v *DataSourceParameters) *CreateDataSourceInput {
	s.DataSourceParameters = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateDataSourceInput) SetName(v string) *CreateDataSourceInput {
	s.Name = &v
	return s
}

// SetPermissions sets the Permissions field's value.
func (s *CreateDataSourceInput) SetPermissions(v []*ResourcePermission) *CreateDataSourceInput {
	s.Permissions = v
	return s
}

// SetSslProperties sets the SslProperties field's value.
func (s *CreateDataSourceInput) SetSslProperties(v *SslProperties) *CreateDataSourceInput {
	s.SslProperties = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDataSourceInput) SetTags(v []*Tag) *CreateDataSourceInput {
	s.Tags = v
	return s
}

// SetType sets the Type field's value.
func (s *CreateDataSourceInput) SetType(v string) *CreateDataSourceInput {
	s.Type = &v
	return s
}

// SetVpcConnectionProperties sets the VpcConnectionProperties field's value.
func (s *CreateDataSourceInput) SetVpcConnectionProperties(v *VpcConnectionProperties) *CreateDataSourceInput {
	s.VpcConnectionProperties = v
	return s
}

type CreateDataSourceOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the data source.
	Arn *string `type:"string"`

	// The status of creating the data source.
	CreationStatus *string `type:"string" enum:"ResourceStatus"`

	// The ID of the data source. This ID is unique per AWS Region for each AWS
	// account.
	DataSourceId *string `type:"string"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation
func (s CreateDataSourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDataSourceOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateDataSourceOutput) SetArn(v string) *CreateDataSourceOutput {
	s.Arn = &v
	return s
}

// SetCreationStatus sets the CreationStatus field's value.
func (s *CreateDataSourceOutput) SetCreationStatus(v string) *CreateDataSourceOutput {
	s.CreationStatus = &v
	return s
}

// SetDataSourceId sets the DataSourceId field's value.
func (s *CreateDataSourceOutput) SetDataSourceId(v string) *CreateDataSourceOutput {
	s.DataSourceId = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *CreateDataSourceOutput) SetRequestId(v string) *CreateDataSourceOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateDataSourceOutput) SetStatus(v int64) *CreateDataSourceOutput {
	s.Status = &v
	return s
}

// The request object for this operation.
type CreateGroupInput struct {
	_ struct{} `type:"structure"`

	// The ID for the AWS account that the group is in. Currently, you use the ID
	// for the AWS account that contains your Amazon QuickSight account.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// A description for the group that you want to create.
	Description *string `min:"1" type:"string"`

	// A name for the group that you want to create.
	//
	// GroupName is a required field
	GroupName *string `min:"1" type:"string" required:"true"`

	// The namespace. Currently, you should set this to default.
	//
	// Namespace is a required field
	Namespace *string `location:"uri" locationName:"Namespace" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateGroupInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.GroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupName"))
	}
	if s.GroupName != nil && len(*s.GroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupName", 1))
	}
	if s.Namespace == nil {
		invalidParams.Add(request.NewErrParamRequired("Namespace"))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *CreateGroupInput) SetAwsAccountId(v string) *CreateGroupInput {
	s.AwsAccountId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateGroupInput) SetDescription(v string) *CreateGroupInput {
	s.Description = &v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *CreateGroupInput) SetGroupName(v string) *CreateGroupInput {
	s.GroupName = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *CreateGroupInput) SetNamespace(v string) *CreateGroupInput {
	s.Namespace = &v
	return s
}

type CreateGroupMembershipInput struct {
	_ struct{} `type:"structure"`

	// The ID for the AWS account that the group is in. Currently, you use the ID
	// for the AWS account that contains your Amazon QuickSight account.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The name of the group that you want to add the user to.
	//
	// GroupName is a required field
	GroupName *string `location:"uri" locationName:"GroupName" min:"1" type:"string" required:"true"`

	// The name of the user that you want to add to the group membership.
	//
	// MemberName is a required field
	MemberName *string `location:"uri" locationName:"MemberName" min:"1" type:"string" required:"true"`

	// The namespace. Currently, you should set this to default.
	//
	// Namespace is a required field
	Namespace *string `location:"uri" locationName:"Namespace" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateGroupMembershipInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateGroupMembershipInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateGroupMembershipInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateGroupMembershipInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.GroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupName"))
	}
	if s.GroupName != nil && len(*s.GroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupName", 1))
	}
	if s.MemberName == nil {
		invalidParams.Add(request.NewErrParamRequired("MemberName"))
	}
	if s.MemberName != nil && len(*s.MemberName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MemberName", 1))
	}
	if s.Namespace == nil {
		invalidParams.Add(request.NewErrParamRequired("Namespace"))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *CreateGroupMembershipInput) SetAwsAccountId(v string) *CreateGroupMembershipInput {
	s.AwsAccountId = &v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *CreateGroupMembershipInput) SetGroupName(v string) *CreateGroupMembershipInput {
	s.GroupName = &v
	return s
}

// SetMemberName sets the MemberName field's value.
func (s *CreateGroupMembershipInput) SetMemberName(v string) *CreateGroupMembershipInput {
	s.MemberName = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *CreateGroupMembershipInput) SetNamespace(v string) *CreateGroupMembershipInput {
	s.Namespace = &v
	return s
}

type CreateGroupMembershipOutput struct {
	_ struct{} `type:"structure"`

	// The group member.
	GroupMember *GroupMember `type:"structure"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation
func (s CreateGroupMembershipOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateGroupMembershipOutput) GoString() string {
	return s.String()
}

// SetGroupMember sets the GroupMember field's value.
func (s *CreateGroupMembershipOutput) SetGroupMember(v *GroupMember) *CreateGroupMembershipOutput {
	s.GroupMember = v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *CreateGroupMembershipOutput) SetRequestId(v string) *CreateGroupMembershipOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateGroupMembershipOutput) SetStatus(v int64) *CreateGroupMembershipOutput {
	s.Status = &v
	return s
}

// The response object for this operation.
type CreateGroupOutput struct {
	_ struct{} `type:"structure"`

	// The name of the group.
	Group *Group `type:"structure"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation
func (s CreateGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateGroupOutput) GoString() string {
	return s.String()
}

// SetGroup sets the Group field's value.
func (s *CreateGroupOutput) SetGroup(v *Group) *CreateGroupOutput {
	s.Group = v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *CreateGroupOutput) SetRequestId(v string) *CreateGroupOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateGroupOutput) SetStatus(v int64) *CreateGroupOutput {
	s.Status = &v
	return s
}

type CreateIAMPolicyAssignmentInput struct {
	_ struct{} `type:"structure"`

	// The name of the assignment. It must be unique within an AWS account.
	//
	// AssignmentName is a required field
	AssignmentName *string `min:"1" type:"string" required:"true"`

	// The status of an assignment:
	//
	//    * ENABLED - Anything specified in this assignment is used while creating
	//    the data source.
	//
	//    * DISABLED - This assignment isn't used while creating the data source.
	//
	//    * DRAFT - Assignment is an unfinished draft and isn't used while creating
	//    the data source.
	//
	// AssignmentStatus is a required field
	AssignmentStatus *string `type:"string" required:"true" enum:"AssignmentStatus"`

	// The AWS Account ID where you want to assign QuickSight users or groups to
	// an IAM policy.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// QuickSight users and/or groups that you want to assign the policy to.
	Identities map[string][]*string `type:"map"`

	// The namespace that contains the assignment.
	//
	// Namespace is a required field
	Namespace *string `location:"uri" locationName:"Namespace" type:"string" required:"true"`

	// An IAM policy Amazon Resource Name (ARN) that you want to apply to the QuickSight
	// users and groups specified in this assignment.
	PolicyArn *string `type:"string"`
}

// String returns the string representation
func (s CreateIAMPolicyAssignmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateIAMPolicyAssignmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateIAMPolicyAssignmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateIAMPolicyAssignmentInput"}
	if s.AssignmentName == nil {
		invalidParams.Add(request.NewErrParamRequired("AssignmentName"))
	}
	if s.AssignmentName != nil && len(*s.AssignmentName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AssignmentName", 1))
	}
	if s.AssignmentStatus == nil {
		invalidParams.Add(request.NewErrParamRequired("AssignmentStatus"))
	}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.Namespace == nil {
		invalidParams.Add(request.NewErrParamRequired("Namespace"))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssignmentName sets the AssignmentName field's value.
func (s *CreateIAMPolicyAssignmentInput) SetAssignmentName(v string) *CreateIAMPolicyAssignmentInput {
	s.AssignmentName = &v
	return s
}

// SetAssignmentStatus sets the AssignmentStatus field's value.
func (s *CreateIAMPolicyAssignmentInput) SetAssignmentStatus(v string) *CreateIAMPolicyAssignmentInput {
	s.AssignmentStatus = &v
	return s
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *CreateIAMPolicyAssignmentInput) SetAwsAccountId(v string) *CreateIAMPolicyAssignmentInput {
	s.AwsAccountId = &v
	return s
}

// SetIdentities sets the Identities field's value.
func (s *CreateIAMPolicyAssignmentInput) SetIdentities(v map[string][]*string) *CreateIAMPolicyAssignmentInput {
	s.Identities = v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *CreateIAMPolicyAssignmentInput) SetNamespace(v string) *CreateIAMPolicyAssignmentInput {
	s.Namespace = &v
	return s
}

// SetPolicyArn sets the PolicyArn field's value.
func (s *CreateIAMPolicyAssignmentInput) SetPolicyArn(v string) *CreateIAMPolicyAssignmentInput {
	s.PolicyArn = &v
	return s
}

type CreateIAMPolicyAssignmentOutput struct {
	_ struct{} `type:"structure"`

	// An ID for the assignment.
	AssignmentId *string `type:"string"`

	// The name of the assignment. Must be unique within an AWS account.
	AssignmentName *string `min:"1" type:"string"`

	// The status of an assignment:
	//
	//    * ENABLED - Anything specified in this assignment is used while creating
	//    the data source.
	//
	//    * DISABLED - This assignment isn't used while creating the data source.
	//
	//    * DRAFT - Assignment is an unfinished draft and isn't used while creating
	//    the data source.
	AssignmentStatus *string `type:"string" enum:"AssignmentStatus"`

	// QuickSight users and/or groups that are assigned to the IAM policy.
	Identities map[string][]*string `type:"map"`

	// An IAM policy Amazon Resource Name (ARN) that is applied to the QuickSight
	// users and groups specified in this assignment.
	PolicyArn *string `type:"string"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation
func (s CreateIAMPolicyAssignmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateIAMPolicyAssignmentOutput) GoString() string {
	return s.String()
}

// SetAssignmentId sets the AssignmentId field's value.
func (s *CreateIAMPolicyAssignmentOutput) SetAssignmentId(v string) *CreateIAMPolicyAssignmentOutput {
	s.AssignmentId = &v
	return s
}

// SetAssignmentName sets the AssignmentName field's value.
func (s *CreateIAMPolicyAssignmentOutput) SetAssignmentName(v string) *CreateIAMPolicyAssignmentOutput {
	s.AssignmentName = &v
	return s
}

// SetAssignmentStatus sets the AssignmentStatus field's value.
func (s *CreateIAMPolicyAssignmentOutput) SetAssignmentStatus(v string) *CreateIAMPolicyAssignmentOutput {
	s.AssignmentStatus = &v
	return s
}

// SetIdentities sets the Identities field's value.
func (s *CreateIAMPolicyAssignmentOutput) SetIdentities(v map[string][]*string) *CreateIAMPolicyAssignmentOutput {
	s.Identities = v
	return s
}

// SetPolicyArn sets the PolicyArn field's value.
func (s *CreateIAMPolicyAssignmentOutput) SetPolicyArn(v string) *CreateIAMPolicyAssignmentOutput {
	s.PolicyArn = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *CreateIAMPolicyAssignmentOutput) SetRequestId(v string) *CreateIAMPolicyAssignmentOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateIAMPolicyAssignmentOutput) SetStatus(v int64) *CreateIAMPolicyAssignmentOutput {
	s.Status = &v
	return s
}

type CreateIngestionInput struct {
	_ struct{} `type:"structure"`

	// The AWS account ID.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The ID of the dataset used in the ingestion.
	//
	// DataSetId is a required field
	DataSetId *string `location:"uri" locationName:"DataSetId" type:"string" required:"true"`

	// An ID for the ingestion.
	//
	// IngestionId is a required field
	IngestionId *string `location:"uri" locationName:"IngestionId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateIngestionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateIngestionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateIngestionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateIngestionInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.DataSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSetId"))
	}
	if s.DataSetId != nil && len(*s.DataSetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataSetId", 1))
	}
	if s.IngestionId == nil {
		invalidParams.Add(request.NewErrParamRequired("IngestionId"))
	}
	if s.IngestionId != nil && len(*s.IngestionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IngestionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *CreateIngestionInput) SetAwsAccountId(v string) *CreateIngestionInput {
	s.AwsAccountId = &v
	return s
}

// SetDataSetId sets the DataSetId field's value.
func (s *CreateIngestionInput) SetDataSetId(v string) *CreateIngestionInput {
	s.DataSetId = &v
	return s
}

// SetIngestionId sets the IngestionId field's value.
func (s *CreateIngestionInput) SetIngestionId(v string) *CreateIngestionInput {
	s.IngestionId = &v
	return s
}

type CreateIngestionOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the data ingestion.
	Arn *string `type:"string"`

	// An ID for the ingestion.
	IngestionId *string `min:"1" type:"string"`

	// The ingestion status.
	IngestionStatus *string `type:"string" enum:"IngestionStatus"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation
func (s CreateIngestionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateIngestionOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateIngestionOutput) SetArn(v string) *CreateIngestionOutput {
	s.Arn = &v
	return s
}

// SetIngestionId sets the IngestionId field's value.
func (s *CreateIngestionOutput) SetIngestionId(v string) *CreateIngestionOutput {
	s.IngestionId = &v
	return s
}

// SetIngestionStatus sets the IngestionStatus field's value.
func (s *CreateIngestionOutput) SetIngestionStatus(v string) *CreateIngestionOutput {
	s.IngestionStatus = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *CreateIngestionOutput) SetRequestId(v string) *CreateIngestionOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateIngestionOutput) SetStatus(v int64) *CreateIngestionOutput {
	s.Status = &v
	return s
}

type CreateTemplateAliasInput struct {
	_ struct{} `type:"structure"`

	// The name that you want to give to the template alias that you're creating.
	// Aliases that start with $ are reserved by QuickSight.
	//
	// AliasName is a required field
	AliasName *string `location:"uri" locationName:"AliasName" min:"1" type:"string" required:"true"`

	// AWS account ID that contains the template you are aliasing.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// An ID for the template.
	//
	// TemplateId is a required field
	TemplateId *string `location:"uri" locationName:"TemplateId" min:"1" type:"string" required:"true"`

	// The version number of the template.
	//
	// TemplateVersionNumber is a required field
	TemplateVersionNumber *int64 `min:"1" type:"long" required:"true"`
}

// String returns the string representation
func (s CreateTemplateAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTemplateAliasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTemplateAliasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateTemplateAliasInput"}
	if s.AliasName == nil {
		invalidParams.Add(request.NewErrParamRequired("AliasName"))
	}
	if s.AliasName != nil && len(*s.AliasName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AliasName", 1))
	}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.TemplateId == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateId"))
	}
	if s.TemplateId != nil && len(*s.TemplateId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateId", 1))
	}
	if s.TemplateVersionNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateVersionNumber"))
	}
	if s.TemplateVersionNumber != nil && *s.TemplateVersionNumber < 1 {
		invalidParams.Add(request.NewErrParamMinValue("TemplateVersionNumber", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAliasName sets the AliasName field's value.
func (s *CreateTemplateAliasInput) SetAliasName(v string) *CreateTemplateAliasInput {
	s.AliasName = &v
	return s
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *CreateTemplateAliasInput) SetAwsAccountId(v string) *CreateTemplateAliasInput {
	s.AwsAccountId = &v
	return s
}

// SetTemplateId sets the TemplateId field's value.
func (s *CreateTemplateAliasInput) SetTemplateId(v string) *CreateTemplateAliasInput {
	s.TemplateId = &v
	return s
}

// SetTemplateVersionNumber sets the TemplateVersionNumber field's value.
func (s *CreateTemplateAliasInput) SetTemplateVersionNumber(v int64) *CreateTemplateAliasInput {
	s.TemplateVersionNumber = &v
	return s
}

type CreateTemplateAliasOutput struct {
	_ struct{} `type:"structure"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`

	// Information on the template alias.
	TemplateAlias *TemplateAlias `type:"structure"`
}

// String returns the string representation
func (s CreateTemplateAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTemplateAliasOutput) GoString() string {
	return s.String()
}

// SetRequestId sets the RequestId field's value.
func (s *CreateTemplateAliasOutput) SetRequestId(v string) *CreateTemplateAliasOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateTemplateAliasOutput) SetStatus(v int64) *CreateTemplateAliasOutput {
	s.Status = &v
	return s
}

// SetTemplateAlias sets the TemplateAlias field's value.
func (s *CreateTemplateAliasOutput) SetTemplateAlias(v *TemplateAlias) *CreateTemplateAliasOutput {
	s.TemplateAlias = v
	return s
}

type CreateTemplateInput struct {
	_ struct{} `type:"structure"`

	// The ID for the AWS account that the group is in. Currently, you use the ID
	// for the AWS account that contains your Amazon QuickSight account.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// A display name for the template.
	Name *string `min:"1" type:"string"`

	// A list of resource permissions to be set on the template.
	Permissions []*ResourcePermission `min:"1" type:"list"`

	// The Amazon Resource Name (ARN) of the source entity from which this template
	// is being created. Templates can be currently created from an analysis or
	// another template. If the ARN is for an analysis, you must include its dataset
	// references.
	//
	// SourceEntity is a required field
	SourceEntity *TemplateSourceEntity `type:"structure" required:"true"`

	// Contains a map of the key-value pairs for the resource tag or tags assigned
	// to the resource.
	Tags []*Tag `min:"1" type:"list"`

	// An ID for the template you want to create. This is unique per AWS region
	// per AWS account.
	//
	// TemplateId is a required field
	TemplateId *string `location:"uri" locationName:"TemplateId" min:"1" type:"string" required:"true"`

	// A description of the current template version being created. This API created
	// the first version of the template. Every time UpdateTemplate is called a
	// new version is created. Each version of the template maintains a description
	// of the version in the VersionDescription field.
	VersionDescription *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CreateTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateTemplateInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Permissions != nil && len(s.Permissions) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Permissions", 1))
	}
	if s.SourceEntity == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceEntity"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.TemplateId == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateId"))
	}
	if s.TemplateId != nil && len(*s.TemplateId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateId", 1))
	}
	if s.VersionDescription != nil && len(*s.VersionDescription) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VersionDescription", 1))
	}
	if s.Permissions != nil {
		for i, v := range s.Permissions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Permissions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.SourceEntity != nil {
		if err := s.SourceEntity.Validate(); err != nil {
			invalidParams.AddNested("SourceEntity", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *CreateTemplateInput) SetAwsAccountId(v string) *CreateTemplateInput {
	s.AwsAccountId = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateTemplateInput) SetName(v string) *CreateTemplateInput {
	s.Name = &v
	return s
}

// SetPermissions sets the Permissions field's value.
func (s *CreateTemplateInput) SetPermissions(v []*ResourcePermission) *CreateTemplateInput {
	s.Permissions = v
	return s
}

// SetSourceEntity sets the SourceEntity field's value.
func (s *CreateTemplateInput) SetSourceEntity(v *TemplateSourceEntity) *CreateTemplateInput {
	s.SourceEntity = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateTemplateInput) SetTags(v []*Tag) *CreateTemplateInput {
	s.Tags = v
	return s
}

// SetTemplateId sets the TemplateId field's value.
func (s *CreateTemplateInput) SetTemplateId(v string) *CreateTemplateInput {
	s.TemplateId = &v
	return s
}

// SetVersionDescription sets the VersionDescription field's value.
func (s *CreateTemplateInput) SetVersionDescription(v string) *CreateTemplateInput {
	s.VersionDescription = &v
	return s
}

type CreateTemplateOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the template.
	Arn *string `type:"string"`

	// The template creation status.
	CreationStatus *string `type:"string" enum:"ResourceStatus"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`

	// The ID of the template.
	TemplateId *string `min:"1" type:"string"`

	// The ARN for the template, including the version information of the first
	// version.
	VersionArn *string `type:"string"`
}

// String returns the string representation
func (s CreateTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTemplateOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateTemplateOutput) SetArn(v string) *CreateTemplateOutput {
	s.Arn = &v
	return s
}

// SetCreationStatus sets the CreationStatus field's value.
func (s *CreateTemplateOutput) SetCreationStatus(v string) *CreateTemplateOutput {
	s.CreationStatus = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *CreateTemplateOutput) SetRequestId(v string) *CreateTemplateOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateTemplateOutput) SetStatus(v int64) *CreateTemplateOutput {
	s.Status = &v
	return s
}

// SetTemplateId sets the TemplateId field's value.
func (s *CreateTemplateOutput) SetTemplateId(v string) *CreateTemplateOutput {
	s.TemplateId = &v
	return s
}

// SetVersionArn sets the VersionArn field's value.
func (s *CreateTemplateOutput) SetVersionArn(v string) *CreateTemplateOutput {
	s.VersionArn = &v
	return s
}

// The combination of username and password that are used as credentials.
type CredentialPair struct {
	_ struct{} `type:"structure"`

	// Password.
	//
	// Password is a required field
	Password *string `min:"1" type:"string" required:"true"`

	// Username.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CredentialPair) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CredentialPair) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CredentialPair) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CredentialPair"}
	if s.Password == nil {
		invalidParams.Add(request.NewErrParamRequired("Password"))
	}
	if s.Password != nil && len(*s.Password) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Password", 1))
	}
	if s.Username == nil {
		invalidParams.Add(request.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Username", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPassword sets the Password field's value.
func (s *CredentialPair) SetPassword(v string) *CredentialPair {
	s.Password = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *CredentialPair) SetUsername(v string) *CredentialPair {
	s.Username = &v
	return s
}

// A physical table type built from the results of the custom SQL query.
type CustomSql struct {
	_ struct{} `type:"structure"`

	// The column schema from the SQL query result set.
	Columns []*InputColumn `min:"1" type:"list"`

	// The Amazon Resource Name (ARN) of the data source.
	//
	// DataSourceArn is a required field
	DataSourceArn *string `type:"string" required:"true"`

	// A display name for the SQL query result.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The SQL query.
	//
	// SqlQuery is a required field
	SqlQuery *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CustomSql) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CustomSql) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CustomSql) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CustomSql"}
	if s.Columns != nil && len(s.Columns) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Columns", 1))
	}
	if s.DataSourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSourceArn"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.SqlQuery == nil {
		invalidParams.Add(request.NewErrParamRequired("SqlQuery"))
	}
	if s.SqlQuery != nil && len(*s.SqlQuery) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SqlQuery", 1))
	}
	if s.Columns != nil {
		for i, v := range s.Columns {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Columns", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetColumns sets the Columns field's value.
func (s *CustomSql) SetColumns(v []*InputColumn) *CustomSql {
	s.Columns = v
	return s
}

// SetDataSourceArn sets the DataSourceArn field's value.
func (s *CustomSql) SetDataSourceArn(v string) *CustomSql {
	s.DataSourceArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *CustomSql) SetName(v string) *CustomSql {
	s.Name = &v
	return s
}

// SetSqlQuery sets the SqlQuery field's value.
func (s *CustomSql) SetSqlQuery(v string) *CustomSql {
	s.SqlQuery = &v
	return s
}

// Dashboard.
type Dashboard struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource name (ARN) of the resource.
	Arn *string `type:"string"`

	// The time this was created.
	CreatedTime *time.Time `type:"timestamp"`

	// Dashboard ID.
	DashboardId *string `min:"1" type:"string"`

	// The last time this was published.
	LastPublishedTime *time.Time `type:"timestamp"`

	// The last time this was updated.
	LastUpdatedTime *time.Time `type:"timestamp"`

	// A display name for the dataset.
	Name *string `min:"1" type:"string"`

	// Version.
	Version *DashboardVersion `type:"structure"`
}

// String returns the string representation
func (s Dashboard) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Dashboard) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Dashboard) SetArn(v string) *Dashboard {
	s.Arn = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *Dashboard) SetCreatedTime(v time.Time) *Dashboard {
	s.CreatedTime = &v
	return s
}

// SetDashboardId sets the DashboardId field's value.
func (s *Dashboard) SetDashboardId(v string) *Dashboard {
	s.DashboardId = &v
	return s
}

// SetLastPublishedTime sets the LastPublishedTime field's value.
func (s *Dashboard) SetLastPublishedTime(v time.Time) *Dashboard {
	s.LastPublishedTime = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *Dashboard) SetLastUpdatedTime(v time.Time) *Dashboard {
	s.LastUpdatedTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *Dashboard) SetName(v string) *Dashboard {
	s.Name = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *Dashboard) SetVersion(v *DashboardVersion) *Dashboard {
	s.Version = v
	return s
}

// Dashboard error.
type DashboardError struct {
	_ struct{} `type:"structure"`

	// Message.
	Message *string `type:"string"`

	// Type.
	Type *string `type:"string" enum:"DashboardErrorType"`
}

// String returns the string representation
func (s DashboardError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DashboardError) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *DashboardError) SetMessage(v string) *DashboardError {
	s.Message = &v
	return s
}

// SetType sets the Type field's value.
func (s *DashboardError) SetType(v string) *DashboardError {
	s.Type = &v
	return s
}

// Dashboard publish options.
type DashboardPublishOptions struct {
	_ struct{} `type:"structure"`

	// Ad hoc filtering option.
	AdHocFilteringOption *AdHocFilteringOption `type:"structure"`

	// Export to CSV option.
	ExportToCSVOption *ExportToCSVOption `type:"structure"`

	// Sheet controls option.
	SheetControlsOption *SheetControlsOption `type:"structure"`
}

// String returns the string representation
func (s DashboardPublishOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DashboardPublishOptions) GoString() string {
	return s.String()
}

// SetAdHocFilteringOption sets the AdHocFilteringOption field's value.
func (s *DashboardPublishOptions) SetAdHocFilteringOption(v *AdHocFilteringOption) *DashboardPublishOptions {
	s.AdHocFilteringOption = v
	return s
}

// SetExportToCSVOption sets the ExportToCSVOption field's value.
func (s *DashboardPublishOptions) SetExportToCSVOption(v *ExportToCSVOption) *DashboardPublishOptions {
	s.ExportToCSVOption = v
	return s
}

// SetSheetControlsOption sets the SheetControlsOption field's value.
func (s *DashboardPublishOptions) SetSheetControlsOption(v *SheetControlsOption) *DashboardPublishOptions {
	s.SheetControlsOption = v
	return s
}

// Dashboard source entity.
type DashboardSourceEntity struct {
	_ struct{} `type:"structure"`

	// Source template.
	SourceTemplate *DashboardSourceTemplate `type:"structure"`
}

// String returns the string representation
func (s DashboardSourceEntity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DashboardSourceEntity) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DashboardSourceEntity) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DashboardSourceEntity"}
	if s.SourceTemplate != nil {
		if err := s.SourceTemplate.Validate(); err != nil {
			invalidParams.AddNested("SourceTemplate", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSourceTemplate sets the SourceTemplate field's value.
func (s *DashboardSourceEntity) SetSourceTemplate(v *DashboardSourceTemplate) *DashboardSourceEntity {
	s.SourceTemplate = v
	return s
}

// Dashboard source template.
type DashboardSourceTemplate struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource name (ARN) of the resource.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`

	// Dataset references.
	//
	// DataSetReferences is a required field
	DataSetReferences []*DataSetReference `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s DashboardSourceTemplate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DashboardSourceTemplate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DashboardSourceTemplate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DashboardSourceTemplate"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.DataSetReferences == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSetReferences"))
	}
	if s.DataSetReferences != nil && len(s.DataSetReferences) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataSetReferences", 1))
	}
	if s.DataSetReferences != nil {
		for i, v := range s.DataSetReferences {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DataSetReferences", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *DashboardSourceTemplate) SetArn(v string) *DashboardSourceTemplate {
	s.Arn = &v
	return s
}

// SetDataSetReferences sets the DataSetReferences field's value.
func (s *DashboardSourceTemplate) SetDataSetReferences(v []*DataSetReference) *DashboardSourceTemplate {
	s.DataSetReferences = v
	return s
}

// Dashboard summary.
type DashboardSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource name (ARN) of the resource.
	Arn *string `type:"string"`

	// The time this was created.
	CreatedTime *time.Time `type:"timestamp"`

	// Dashboard ID.
	DashboardId *string `min:"1" type:"string"`

	// The last time this was published.
	LastPublishedTime *time.Time `type:"timestamp"`

	// The last time this was updated.
	LastUpdatedTime *time.Time `type:"timestamp"`

	// A display name for the dataset.
	Name *string `min:"1" type:"string"`

	// Published version number.
	PublishedVersionNumber *int64 `min:"1" type:"long"`
}

// String returns the string representation
func (s DashboardSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DashboardSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DashboardSummary) SetArn(v string) *DashboardSummary {
	s.Arn = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *DashboardSummary) SetCreatedTime(v time.Time) *DashboardSummary {
	s.CreatedTime = &v
	return s
}

// SetDashboardId sets the DashboardId field's value.
func (s *DashboardSummary) SetDashboardId(v string) *DashboardSummary {
	s.DashboardId = &v
	return s
}

// SetLastPublishedTime sets the LastPublishedTime field's value.
func (s *DashboardSummary) SetLastPublishedTime(v time.Time) *DashboardSummary {
	s.LastPublishedTime = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *DashboardSummary) SetLastUpdatedTime(v time.Time) *DashboardSummary {
	s.LastUpdatedTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *DashboardSummary) SetName(v string) *DashboardSummary {
	s.Name = &v
	return s
}

// SetPublishedVersionNumber sets the PublishedVersionNumber field's value.
func (s *DashboardSummary) SetPublishedVersionNumber(v int64) *DashboardSummary {
	s.PublishedVersionNumber = &v
	return s
}

// Dashboard version.
type DashboardVersion struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource name (ARN) of the resource.
	Arn *string `type:"string"`

	// The time this was created.
	CreatedTime *time.Time `type:"timestamp"`

	// Description.
	Description *string `min:"1" type:"string"`

	// Errors.
	Errors []*DashboardError `min:"1" type:"list"`

	// Source entity ARN.
	SourceEntityArn *string `type:"string"`

	// The HTTP status of the request.
	Status *string `type:"string" enum:"ResourceStatus"`

	// Version number.
	VersionNumber *int64 `min:"1" type:"long"`
}

// String returns the string representation
func (s DashboardVersion) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DashboardVersion) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DashboardVersion) SetArn(v string) *DashboardVersion {
	s.Arn = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *DashboardVersion) SetCreatedTime(v time.Time) *DashboardVersion {
	s.CreatedTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DashboardVersion) SetDescription(v string) *DashboardVersion {
	s.Description = &v
	return s
}

// SetErrors sets the Errors field's value.
func (s *DashboardVersion) SetErrors(v []*DashboardError) *DashboardVersion {
	s.Errors = v
	return s
}

// SetSourceEntityArn sets the SourceEntityArn field's value.
func (s *DashboardVersion) SetSourceEntityArn(v string) *DashboardVersion {
	s.SourceEntityArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DashboardVersion) SetStatus(v string) *DashboardVersion {
	s.Status = &v
	return s
}

// SetVersionNumber sets the VersionNumber field's value.
func (s *DashboardVersion) SetVersionNumber(v int64) *DashboardVersion {
	s.VersionNumber = &v
	return s
}

// Dashboard version summary.
type DashboardVersionSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource name (ARN) of the resource.
	Arn *string `type:"string"`

	// The time this was created.
	CreatedTime *time.Time `type:"timestamp"`

	// Description.
	Description *string `min:"1" type:"string"`

	// Source entity ARN.
	SourceEntityArn *string `type:"string"`

	// The HTTP status of the request.
	Status *string `type:"string" enum:"ResourceStatus"`

	// Version number.
	VersionNumber *int64 `min:"1" type:"long"`
}

// String returns the string representation
func (s DashboardVersionSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DashboardVersionSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DashboardVersionSummary) SetArn(v string) *DashboardVersionSummary {
	s.Arn = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *DashboardVersionSummary) SetCreatedTime(v time.Time) *DashboardVersionSummary {
	s.CreatedTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DashboardVersionSummary) SetDescription(v string) *DashboardVersionSummary {
	s.Description = &v
	return s
}

// SetSourceEntityArn sets the SourceEntityArn field's value.
func (s *DashboardVersionSummary) SetSourceEntityArn(v string) *DashboardVersionSummary {
	s.SourceEntityArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DashboardVersionSummary) SetStatus(v string) *DashboardVersionSummary {
	s.Status = &v
	return s
}

// SetVersionNumber sets the VersionNumber field's value.
func (s *DashboardVersionSummary) SetVersionNumber(v int64) *DashboardVersionSummary {
	s.VersionNumber = &v
	return s
}

// Dataset.
type DataSet struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource name (ARN) of the resource.
	Arn *string `type:"string"`

	// Groupings of columns that work together in certain QuickSight features. Currently,
	// only geospatial hierarchy is supported.
	ColumnGroups []*ColumnGroup `min:"1" type:"list"`

	// The amount of SPICE capacity used by this dataset. This is 0 if the dataset
	// isn't imported into SPICE.
	ConsumedSpiceCapacityInBytes *int64 `type:"long"`

	// The time this was created.
	CreatedTime *time.Time `type:"timestamp"`

	// The ID of the dataset.
	DataSetId *string `type:"string"`

	// Indicates whether or not you want to import the data into SPICE.
	ImportMode *string `type:"string" enum:"DataSetImportMode"`

	// The last time this was updated.
	LastUpdatedTime *time.Time `type:"timestamp"`

	// Configures the combination and transformation of the data from the physical
	// tables.
	LogicalTableMap map[string]*LogicalTable `min:"1" type:"map"`

	// A display name for the dataset.
	Name *string `min:"1" type:"string"`

	// The list of columns after all transforms. These columns are available in
	// templates, analyses, and dashboards.
	OutputColumns []*OutputColumn `type:"list"`

	// Declares the physical tables that are available in the underlying data sources.
	PhysicalTableMap map[string]*PhysicalTable `min:"1" type:"map"`

	// Row-level security configuration on the dataset.
	RowLevelPermissionDataSet *RowLevelPermissionDataSet `type:"structure"`
}

// String returns the string representation
func (s DataSet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DataSet) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DataSet) SetArn(v string) *DataSet {
	s.Arn = &v
	return s
}

// SetColumnGroups sets the ColumnGroups field's value.
func (s *DataSet) SetColumnGroups(v []*ColumnGroup) *DataSet {
	s.ColumnGroups = v
	return s
}

// SetConsumedSpiceCapacityInBytes sets the ConsumedSpiceCapacityInBytes field's value.
func (s *DataSet) SetConsumedSpiceCapacityInBytes(v int64) *DataSet {
	s.ConsumedSpiceCapacityInBytes = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *DataSet) SetCreatedTime(v time.Time) *DataSet {
	s.CreatedTime = &v
	return s
}

// SetDataSetId sets the DataSetId field's value.
func (s *DataSet) SetDataSetId(v string) *DataSet {
	s.DataSetId = &v
	return s
}

// SetImportMode sets the ImportMode field's value.
func (s *DataSet) SetImportMode(v string) *DataSet {
	s.ImportMode = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *DataSet) SetLastUpdatedTime(v time.Time) *DataSet {
	s.LastUpdatedTime = &v
	return s
}

// SetLogicalTableMap sets the LogicalTableMap field's value.
func (s *DataSet) SetLogicalTableMap(v map[string]*LogicalTable) *DataSet {
	s.LogicalTableMap = v
	return s
}

// SetName sets the Name field's value.
func (s *DataSet) SetName(v string) *DataSet {
	s.Name = &v
	return s
}

// SetOutputColumns sets the OutputColumns field's value.
func (s *DataSet) SetOutputColumns(v []*OutputColumn) *DataSet {
	s.OutputColumns = v
	return s
}

// SetPhysicalTableMap sets the PhysicalTableMap field's value.
func (s *DataSet) SetPhysicalTableMap(v map[string]*PhysicalTable) *DataSet {
	s.PhysicalTableMap = v
	return s
}

// SetRowLevelPermissionDataSet sets the RowLevelPermissionDataSet field's value.
func (s *DataSet) SetRowLevelPermissionDataSet(v *RowLevelPermissionDataSet) *DataSet {
	s.RowLevelPermissionDataSet = v
	return s
}

// Dataset configuration.
type DataSetConfiguration struct {
	_ struct{} `type:"structure"`

	// A structure containing the list of column group schemas.
	ColumnGroupSchemaList []*ColumnGroupSchema `type:"list"`

	// Dataset schema.
	DataSetSchema *DataSetSchema `type:"structure"`

	// Placeholder.
	Placeholder *string `type:"string"`
}

// String returns the string representation
func (s DataSetConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DataSetConfiguration) GoString() string {
	return s.String()
}

// SetColumnGroupSchemaList sets the ColumnGroupSchemaList field's value.
func (s *DataSetConfiguration) SetColumnGroupSchemaList(v []*ColumnGroupSchema) *DataSetConfiguration {
	s.ColumnGroupSchemaList = v
	return s
}

// SetDataSetSchema sets the DataSetSchema field's value.
func (s *DataSetConfiguration) SetDataSetSchema(v *DataSetSchema) *DataSetConfiguration {
	s.DataSetSchema = v
	return s
}

// SetPlaceholder sets the Placeholder field's value.
func (s *DataSetConfiguration) SetPlaceholder(v string) *DataSetConfiguration {
	s.Placeholder = &v
	return s
}

// Dataset reference.
type DataSetReference struct {
	_ struct{} `type:"structure"`

	// Dataset ARN.
	//
	// DataSetArn is a required field
	DataSetArn *string `type:"string" required:"true"`

	// Dataset placeholder.
	//
	// DataSetPlaceholder is a required field
	DataSetPlaceholder *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DataSetReference) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DataSetReference) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DataSetReference) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DataSetReference"}
	if s.DataSetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSetArn"))
	}
	if s.DataSetPlaceholder == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSetPlaceholder"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataSetArn sets the DataSetArn field's value.
func (s *DataSetReference) SetDataSetArn(v string) *DataSetReference {
	s.DataSetArn = &v
	return s
}

// SetDataSetPlaceholder sets the DataSetPlaceholder field's value.
func (s *DataSetReference) SetDataSetPlaceholder(v string) *DataSetReference {
	s.DataSetPlaceholder = &v
	return s
}

// Dataset schema.
type DataSetSchema struct {
	_ struct{} `type:"structure"`

	// A structure containing the list of column schemas.
	ColumnSchemaList []*ColumnSchema `type:"list"`
}

// String returns the string representation
func (s DataSetSchema) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DataSetSchema) GoString() string {
	return s.String()
}

// SetColumnSchemaList sets the ColumnSchemaList field's value.
func (s *DataSetSchema) SetColumnSchemaList(v []*ColumnSchema) *DataSetSchema {
	s.ColumnSchemaList = v
	return s
}

// Dataset summary.
type DataSetSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource name (ARN) of the dataset.
	Arn *string `type:"string"`

	// The time this was created.
	CreatedTime *time.Time `type:"timestamp"`

	// The ID of the dataset.
	DataSetId *string `type:"string"`

	// Indicates whether or not you want to import the data into SPICE.
	ImportMode *string `type:"string" enum:"DataSetImportMode"`

	// The last time this was updated.
	LastUpdatedTime *time.Time `type:"timestamp"`

	// A display name for the dataset.
	Name *string `min:"1" type:"string"`

	// Row-level security configuration on the dataset.
	RowLevelPermissionDataSet *RowLevelPermissionDataSet `type:"structure"`
}

// String returns the string representation
func (s DataSetSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DataSetSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DataSetSummary) SetArn(v string) *DataSetSummary {
	s.Arn = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *DataSetSummary) SetCreatedTime(v time.Time) *DataSetSummary {
	s.CreatedTime = &v
	return s
}

// SetDataSetId sets the DataSetId field's value.
func (s *DataSetSummary) SetDataSetId(v string) *DataSetSummary {
	s.DataSetId = &v
	return s
}

// SetImportMode sets the ImportMode field's value.
func (s *DataSetSummary) SetImportMode(v string) *DataSetSummary {
	s.ImportMode = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *DataSetSummary) SetLastUpdatedTime(v time.Time) *DataSetSummary {
	s.LastUpdatedTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *DataSetSummary) SetName(v string) *DataSetSummary {
	s.Name = &v
	return s
}

// SetRowLevelPermissionDataSet sets the RowLevelPermissionDataSet field's value.
func (s *DataSetSummary) SetRowLevelPermissionDataSet(v *RowLevelPermissionDataSet) *DataSetSummary {
	s.RowLevelPermissionDataSet = v
	return s
}

// The structure of a data source.
type DataSource struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource name (ARN) of the data source.
	Arn *string `type:"string"`

	// The time this was created.
	CreatedTime *time.Time `type:"timestamp"`

	// The ID of the data source. This ID is unique per AWS Region for each AWS
	// account.
	DataSourceId *string `type:"string"`

	// The parameters that QuickSight uses to connect to your underlying source.
	// This is a variant type structure. At most one of the attributes should be
	// non-null for this structure to be valid.
	DataSourceParameters *DataSourceParameters `type:"structure"`

	// Error information from the last update or the creation of the data source.
	ErrorInfo *DataSourceErrorInfo `type:"structure"`

	// The last time this was updated.
	LastUpdatedTime *time.Time `type:"timestamp"`

	// A display name for the data source.
	Name *string `min:"1" type:"string"`

	// Secure Socket Layer (SSL) properties that apply when QuickSight connects
	// to your underlying source.
	SslProperties *SslProperties `type:"structure"`

	// The HTTP status of the request.
	Status *string `type:"string" enum:"ResourceStatus"`

	// The type of the data source. This indicates which database engine the data
	// source connects to.
	Type *string `type:"string" enum:"DataSourceType"`

	// The VPC connection information. You need to use this parameter only when
	// you want QuickSight to use a VPC connection when connecting to your underlying
	// source.
	VpcConnectionProperties *VpcConnectionProperties `type:"structure"`
}

// String returns the string representation
func (s DataSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DataSource) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DataSource) SetArn(v string) *DataSource {
	s.Arn = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *DataSource) SetCreatedTime(v time.Time) *DataSource {
	s.CreatedTime = &v
	return s
}

// SetDataSourceId sets the DataSourceId field's value.
func (s *DataSource) SetDataSourceId(v string) *DataSource {
	s.DataSourceId = &v
	return s
}

// SetDataSourceParameters sets the DataSourceParameters field's value.
func (s *DataSource) SetDataSourceParameters(v *DataSourceParameters) *DataSource {
	s.DataSourceParameters = v
	return s
}

// SetErrorInfo sets the ErrorInfo field's value.
func (s *DataSource) SetErrorInfo(v *DataSourceErrorInfo) *DataSource {
	s.ErrorInfo = v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *DataSource) SetLastUpdatedTime(v time.Time) *DataSource {
	s.LastUpdatedTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *DataSource) SetName(v string) *DataSource {
	s.Name = &v
	return s
}

// SetSslProperties sets the SslProperties field's value.
func (s *DataSource) SetSslProperties(v *SslProperties) *DataSource {
	s.SslProperties = v
	return s
}

// SetStatus sets the Status field's value.
func (s *DataSource) SetStatus(v string) *DataSource {
	s.Status = &v
	return s
}

// SetType sets the Type field's value.
func (s *DataSource) SetType(v string) *DataSource {
	s.Type = &v
	return s
}

// SetVpcConnectionProperties sets the VpcConnectionProperties field's value.
func (s *DataSource) SetVpcConnectionProperties(v *VpcConnectionProperties) *DataSource {
	s.VpcConnectionProperties = v
	return s
}

// Data source credentials.
type DataSourceCredentials struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// Credential pair.
	CredentialPair *CredentialPair `type:"structure"`
}

// String returns the string representation
func (s DataSourceCredentials) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DataSourceCredentials) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DataSourceCredentials) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DataSourceCredentials"}
	if s.CredentialPair != nil {
		if err := s.CredentialPair.Validate(); err != nil {
			invalidParams.AddNested("CredentialPair", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCredentialPair sets the CredentialPair field's value.
func (s *DataSourceCredentials) SetCredentialPair(v *CredentialPair) *DataSourceCredentials {
	s.CredentialPair = v
	return s
}

// Error information on data source creation or update.
type DataSourceErrorInfo struct {
	_ struct{} `type:"structure"`

	// Error message.
	Message *string `type:"string"`

	// Error type.
	Type *string `type:"string" enum:"DataSourceErrorInfoType"`
}

// String returns the string representation
func (s DataSourceErrorInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DataSourceErrorInfo) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *DataSourceErrorInfo) SetMessage(v string) *DataSourceErrorInfo {
	s.Message = &v
	return s
}

// SetType sets the Type field's value.
func (s *DataSourceErrorInfo) SetType(v string) *DataSourceErrorInfo {
	s.Type = &v
	return s
}

// The parameters that QuickSight uses to connect to your underlying source.
// This is a variant type structure. At most one of the attributes should be
// non-null for this structure to be valid.
type DataSourceParameters struct {
	_ struct{} `type:"structure"`

	// Amazon Elasticsearch parameters.
	AmazonElasticsearchParameters *AmazonElasticsearchParameters `type:"structure"`

	// Athena parameters.
	AthenaParameters *AthenaParameters `type:"structure"`

	// Aurora MySQL parameters.
	AuroraParameters *AuroraParameters `type:"structure"`

	// Aurora PostgreSQL parameters.
	AuroraPostgreSqlParameters *AuroraPostgreSqlParameters `type:"structure"`

	// AWS IoT Analytics parameters.
	AwsIotAnalyticsParameters *AwsIotAnalyticsParameters `type:"structure"`

	// Jira parameters.
	JiraParameters *JiraParameters `type:"structure"`

	// MariaDB parameters.
	MariaDbParameters *MariaDbParameters `type:"structure"`

	// MySQL parameters.
	MySqlParameters *MySqlParameters `type:"structure"`

	// PostgreSQL parameters.
	PostgreSqlParameters *PostgreSqlParameters `type:"structure"`

	// Presto parameters.
	PrestoParameters *PrestoParameters `type:"structure"`

	// RDS parameters.
	RdsParameters *RdsParameters `type:"structure"`

	// Redshift parameters.
	RedshiftParameters *RedshiftParameters `type:"structure"`

	// S3 parameters.
	S3Parameters *S3Parameters `type:"structure"`

	// ServiceNow parameters.
	ServiceNowParameters *ServiceNowParameters `type:"structure"`

	// Snowflake parameters.
	SnowflakeParameters *SnowflakeParameters `type:"structure"`

	// Spark parameters.
	SparkParameters *SparkParameters `type:"structure"`

	// SQL Server parameters.
	SqlServerParameters *SqlServerParameters `type:"structure"`

	// Teradata parameters.
	TeradataParameters *TeradataParameters `type:"structure"`

	// Twitter parameters.
	TwitterParameters *TwitterParameters `type:"structure"`
}

// String returns the string representation
func (s DataSourceParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DataSourceParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DataSourceParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DataSourceParameters"}
	if s.AmazonElasticsearchParameters != nil {
		if err := s.AmazonElasticsearchParameters.Validate(); err != nil {
			invalidParams.AddNested("AmazonElasticsearchParameters", err.(request.ErrInvalidParams))
		}
	}
	if s.AthenaParameters != nil {
		if err := s.AthenaParameters.Validate(); err != nil {
			invalidParams.AddNested("AthenaParameters", err.(request.ErrInvalidParams))
		}
	}
	if s.AuroraParameters != nil {
		if err := s.AuroraParameters.Validate(); err != nil {
			invalidParams.AddNested("AuroraParameters", err.(request.ErrInvalidParams))
		}
	}
	if s.AuroraPostgreSqlParameters != nil {
		if err := s.AuroraPostgreSqlParameters.Validate(); err != nil {
			invalidParams.AddNested("AuroraPostgreSqlParameters", err.(request.ErrInvalidParams))
		}
	}
	if s.AwsIotAnalyticsParameters != nil {
		if err := s.AwsIotAnalyticsParameters.Validate(); err != nil {
			invalidParams.AddNested("AwsIotAnalyticsParameters", err.(request.ErrInvalidParams))
		}
	}
	if s.JiraParameters != nil {
		if err := s.JiraParameters.Validate(); err != nil {
			invalidParams.AddNested("JiraParameters", err.(request.ErrInvalidParams))
		}
	}
	if s.MariaDbParameters != nil {
		if err := s.MariaDbParameters.Validate(); err != nil {
			invalidParams.AddNested("MariaDbParameters", err.(request.ErrInvalidParams))
		}
	}
	if s.MySqlParameters != nil {
		if err := s.MySqlParameters.Validate(); err != nil {
			invalidParams.AddNested("MySqlParameters", err.(request.ErrInvalidParams))
		}
	}
	if s.PostgreSqlParameters != nil {
		if err := s.PostgreSqlParameters.Validate(); err != nil {
			invalidParams.AddNested("PostgreSqlParameters", err.(request.ErrInvalidParams))
		}
	}
	if s.PrestoParameters != nil {
		if err := s.PrestoParameters.Validate(); err != nil {
			invalidParams.AddNested("PrestoParameters", err.(request.ErrInvalidParams))
		}
	}
	if s.RdsParameters != nil {
		if err := s.RdsParameters.Validate(); err != nil {
			invalidParams.AddNested("RdsParameters", err.(request.ErrInvalidParams))
		}
	}
	if s.RedshiftParameters != nil {
		if err := s.RedshiftParameters.Validate(); err != nil {
			invalidParams.AddNested("RedshiftParameters", err.(request.ErrInvalidParams))
		}
	}
	if s.S3Parameters != nil {
		if err := s.S3Parameters.Validate(); err != nil {
			invalidParams.AddNested("S3Parameters", err.(request.ErrInvalidParams))
		}
	}
	if s.ServiceNowParameters != nil {
		if err := s.ServiceNowParameters.Validate(); err != nil {
			invalidParams.AddNested("ServiceNowParameters", err.(request.ErrInvalidParams))
		}
	}
	if s.SnowflakeParameters != nil {
		if err := s.SnowflakeParameters.Validate(); err != nil {
			invalidParams.AddNested("SnowflakeParameters", err.(request.ErrInvalidParams))
		}
	}
	if s.SparkParameters != nil {
		if err := s.SparkParameters.Validate(); err != nil {
			invalidParams.AddNested("SparkParameters", err.(request.ErrInvalidParams))
		}
	}
	if s.SqlServerParameters != nil {
		if err := s.SqlServerParameters.Validate(); err != nil {
			invalidParams.AddNested("SqlServerParameters", err.(request.ErrInvalidParams))
		}
	}
	if s.TeradataParameters != nil {
		if err := s.TeradataParameters.Validate(); err != nil {
			invalidParams.AddNested("TeradataParameters", err.(request.ErrInvalidParams))
		}
	}
	if s.TwitterParameters != nil {
		if err := s.TwitterParameters.Validate(); err != nil {
			invalidParams.AddNested("TwitterParameters", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAmazonElasticsearchParameters sets the AmazonElasticsearchParameters field's value.
func (s *DataSourceParameters) SetAmazonElasticsearchParameters(v *AmazonElasticsearchParameters) *DataSourceParameters {
	s.AmazonElasticsearchParameters = v
	return s
}

// SetAthenaParameters sets the AthenaParameters field's value.
func (s *DataSourceParameters) SetAthenaParameters(v *AthenaParameters) *DataSourceParameters {
	s.AthenaParameters = v
	return s
}

// SetAuroraParameters sets the AuroraParameters field's value.
func (s *DataSourceParameters) SetAuroraParameters(v *AuroraParameters) *DataSourceParameters {
	s.AuroraParameters = v
	return s
}

// SetAuroraPostgreSqlParameters sets the AuroraPostgreSqlParameters field's value.
func (s *DataSourceParameters) SetAuroraPostgreSqlParameters(v *AuroraPostgreSqlParameters) *DataSourceParameters {
	s.AuroraPostgreSqlParameters = v
	return s
}

// SetAwsIotAnalyticsParameters sets the AwsIotAnalyticsParameters field's value.
func (s *DataSourceParameters) SetAwsIotAnalyticsParameters(v *AwsIotAnalyticsParameters) *DataSourceParameters {
	s.AwsIotAnalyticsParameters = v
	return s
}

// SetJiraParameters sets the JiraParameters field's value.
func (s *DataSourceParameters) SetJiraParameters(v *JiraParameters) *DataSourceParameters {
	s.JiraParameters = v
	return s
}

// SetMariaDbParameters sets the MariaDbParameters field's value.
func (s *DataSourceParameters) SetMariaDbParameters(v *MariaDbParameters) *DataSourceParameters {
	s.MariaDbParameters = v
	return s
}

// SetMySqlParameters sets the MySqlParameters field's value.
func (s *DataSourceParameters) SetMySqlParameters(v *MySqlParameters) *DataSourceParameters {
	s.MySqlParameters = v
	return s
}

// SetPostgreSqlParameters sets the PostgreSqlParameters field's value.
func (s *DataSourceParameters) SetPostgreSqlParameters(v *PostgreSqlParameters) *DataSourceParameters {
	s.PostgreSqlParameters = v
	return s
}

// SetPrestoParameters sets the PrestoParameters field's value.
func (s *DataSourceParameters) SetPrestoParameters(v *PrestoParameters) *DataSourceParameters {
	s.PrestoParameters = v
	return s
}

// SetRdsParameters sets the RdsParameters field's value.
func (s *DataSourceParameters) SetRdsParameters(v *RdsParameters) *DataSourceParameters {
	s.RdsParameters = v
	return s
}

// SetRedshiftParameters sets the RedshiftParameters field's value.
func (s *DataSourceParameters) SetRedshiftParameters(v *RedshiftParameters) *DataSourceParameters {
	s.RedshiftParameters = v
	return s
}

// SetS3Parameters sets the S3Parameters field's value.
func (s *DataSourceParameters) SetS3Parameters(v *S3Parameters) *DataSourceParameters {
	s.S3Parameters = v
	return s
}

// SetServiceNowParameters sets the ServiceNowParameters field's value.
func (s *DataSourceParameters) SetServiceNowParameters(v *ServiceNowParameters) *DataSourceParameters {
	s.ServiceNowParameters = v
	return s
}

// SetSnowflakeParameters sets the SnowflakeParameters field's value.
func (s *DataSourceParameters) SetSnowflakeParameters(v *SnowflakeParameters) *DataSourceParameters {
	s.SnowflakeParameters = v
	return s
}

// SetSparkParameters sets the SparkParameters field's value.
func (s *DataSourceParameters) SetSparkParameters(v *SparkParameters) *DataSourceParameters {
	s.SparkParameters = v
	return s
}

// SetSqlServerParameters sets the SqlServerParameters field's value.
func (s *DataSourceParameters) SetSqlServerParameters(v *SqlServerParameters) *DataSourceParameters {
	s.SqlServerParameters = v
	return s
}

// SetTeradataParameters sets the TeradataParameters field's value.
func (s *DataSourceParameters) SetTeradataParameters(v *TeradataParameters) *DataSourceParameters {
	s.TeradataParameters = v
	return s
}

// SetTwitterParameters sets the TwitterParameters field's value.
func (s *DataSourceParameters) SetTwitterParameters(v *TwitterParameters) *DataSourceParameters {
	s.TwitterParameters = v
	return s
}

// Date time parameter.
type DateTimeParameter struct {
	_ struct{} `type:"structure"`

	// A display name for the dataset.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// Values.
	//
	// Values is a required field
	Values []*time.Time `type:"list" required:"true"`
}

// String returns the string representation
func (s DateTimeParameter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DateTimeParameter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DateTimeParameter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DateTimeParameter"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DateTimeParameter) SetName(v string) *DateTimeParameter {
	s.Name = &v
	return s
}

// SetValues sets the Values field's value.
func (s *DateTimeParameter) SetValues(v []*time.Time) *DateTimeParameter {
	s.Values = v
	return s
}

// Decimal parameter.
type DecimalParameter struct {
	_ struct{} `type:"structure"`

	// A display name for the dataset.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// Values.
	//
	// Values is a required field
	Values []*float64 `type:"list" required:"true"`
}

// String returns the string representation
func (s DecimalParameter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DecimalParameter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DecimalParameter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DecimalParameter"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DecimalParameter) SetName(v string) *DecimalParameter {
	s.Name = &v
	return s
}

// SetValues sets the Values field's value.
func (s *DecimalParameter) SetValues(v []*float64) *DecimalParameter {
	s.Values = v
	return s
}

type DeleteDashboardInput struct {
	_ struct{} `type:"structure"`

	// AWS account ID that contains the dashboard you are deleting.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The ID for the dashboard.
	//
	// DashboardId is a required field
	DashboardId *string `location:"uri" locationName:"DashboardId" min:"1" type:"string" required:"true"`

	// The version number of the dashboard. If version number property is provided,
	// only the specified version of the dashboard is deleted.
	VersionNumber *int64 `location:"querystring" locationName:"version-number" min:"1" type:"long"`
}

// String returns the string representation
func (s DeleteDashboardInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDashboardInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDashboardInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDashboardInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.DashboardId == nil {
		invalidParams.Add(request.NewErrParamRequired("DashboardId"))
	}
	if s.DashboardId != nil && len(*s.DashboardId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DashboardId", 1))
	}
	if s.VersionNumber != nil && *s.VersionNumber < 1 {
		invalidParams.Add(request.NewErrParamMinValue("VersionNumber", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *DeleteDashboardInput) SetAwsAccountId(v string) *DeleteDashboardInput {
	s.AwsAccountId = &v
	return s
}

// SetDashboardId sets the DashboardId field's value.
func (s *DeleteDashboardInput) SetDashboardId(v string) *DeleteDashboardInput {
	s.DashboardId = &v
	return s
}

// SetVersionNumber sets the VersionNumber field's value.
func (s *DeleteDashboardInput) SetVersionNumber(v int64) *DeleteDashboardInput {
	s.VersionNumber = &v
	return s
}

type DeleteDashboardOutput struct {
	_ struct{} `type:"structure"`

	// The Secure Socket Layer (SSL) properties that apply. of the resource.
	Arn *string `type:"string"`

	// The ID of the dashboard.
	DashboardId *string `min:"1" type:"string"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation
func (s DeleteDashboardOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDashboardOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DeleteDashboardOutput) SetArn(v string) *DeleteDashboardOutput {
	s.Arn = &v
	return s
}

// SetDashboardId sets the DashboardId field's value.
func (s *DeleteDashboardOutput) SetDashboardId(v string) *DeleteDashboardOutput {
	s.DashboardId = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *DeleteDashboardOutput) SetRequestId(v string) *DeleteDashboardOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DeleteDashboardOutput) SetStatus(v int64) *DeleteDashboardOutput {
	s.Status = &v
	return s
}

type DeleteDataSetInput struct {
	_ struct{} `type:"structure"`

	// The AWS account ID.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The ID for the dataset that you want to create. This ID is unique per AWS
	// Region for each AWS account.
	//
	// DataSetId is a required field
	DataSetId *string `location:"uri" locationName:"DataSetId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDataSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDataSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDataSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDataSetInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.DataSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSetId"))
	}
	if s.DataSetId != nil && len(*s.DataSetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataSetId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *DeleteDataSetInput) SetAwsAccountId(v string) *DeleteDataSetInput {
	s.AwsAccountId = &v
	return s
}

// SetDataSetId sets the DataSetId field's value.
func (s *DeleteDataSetInput) SetDataSetId(v string) *DeleteDataSetInput {
	s.DataSetId = &v
	return s
}

type DeleteDataSetOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the dataset.
	Arn *string `type:"string"`

	// The ID for the dataset that you want to create. This ID is unique per AWS
	// Region for each AWS account.
	DataSetId *string `type:"string"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation
func (s DeleteDataSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDataSetOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DeleteDataSetOutput) SetArn(v string) *DeleteDataSetOutput {
	s.Arn = &v
	return s
}

// SetDataSetId sets the DataSetId field's value.
func (s *DeleteDataSetOutput) SetDataSetId(v string) *DeleteDataSetOutput {
	s.DataSetId = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *DeleteDataSetOutput) SetRequestId(v string) *DeleteDataSetOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DeleteDataSetOutput) SetStatus(v int64) *DeleteDataSetOutput {
	s.Status = &v
	return s
}

type DeleteDataSourceInput struct {
	_ struct{} `type:"structure"`

	// The AWS account ID.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The ID of the data source. This ID is unique per AWS Region for each AWS
	// account.
	//
	// DataSourceId is a required field
	DataSourceId *string `location:"uri" locationName:"DataSourceId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDataSourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDataSourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDataSourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDataSourceInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.DataSourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSourceId"))
	}
	if s.DataSourceId != nil && len(*s.DataSourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataSourceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *DeleteDataSourceInput) SetAwsAccountId(v string) *DeleteDataSourceInput {
	s.AwsAccountId = &v
	return s
}

// SetDataSourceId sets the DataSourceId field's value.
func (s *DeleteDataSourceInput) SetDataSourceId(v string) *DeleteDataSourceInput {
	s.DataSourceId = &v
	return s
}

type DeleteDataSourceOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the data source that you deleted.
	Arn *string `type:"string"`

	// The ID of the data source. This ID is unique per AWS Region for each AWS
	// account.
	DataSourceId *string `type:"string"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation
func (s DeleteDataSourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDataSourceOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DeleteDataSourceOutput) SetArn(v string) *DeleteDataSourceOutput {
	s.Arn = &v
	return s
}

// SetDataSourceId sets the DataSourceId field's value.
func (s *DeleteDataSourceOutput) SetDataSourceId(v string) *DeleteDataSourceOutput {
	s.DataSourceId = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *DeleteDataSourceOutput) SetRequestId(v string) *DeleteDataSourceOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DeleteDataSourceOutput) SetStatus(v int64) *DeleteDataSourceOutput {
	s.Status = &v
	return s
}

type DeleteGroupInput struct {
	_ struct{} `type:"structure"`

	// The ID for the AWS account that the group is in. Currently, you use the ID
	// for the AWS account that contains your Amazon QuickSight account.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The name of the group that you want to delete.
	//
	// GroupName is a required field
	GroupName *string `location:"uri" locationName:"GroupName" min:"1" type:"string" required:"true"`

	// The namespace. Currently, you should set this to default.
	//
	// Namespace is a required field
	Namespace *string `location:"uri" locationName:"Namespace" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteGroupInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.GroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupName"))
	}
	if s.GroupName != nil && len(*s.GroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupName", 1))
	}
	if s.Namespace == nil {
		invalidParams.Add(request.NewErrParamRequired("Namespace"))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *DeleteGroupInput) SetAwsAccountId(v string) *DeleteGroupInput {
	s.AwsAccountId = &v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *DeleteGroupInput) SetGroupName(v string) *DeleteGroupInput {
	s.GroupName = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *DeleteGroupInput) SetNamespace(v string) *DeleteGroupInput {
	s.Namespace = &v
	return s
}

type DeleteGroupMembershipInput struct {
	_ struct{} `type:"structure"`

	// The ID for the AWS account that the group is in. Currently, you use the ID
	// for the AWS account that contains your Amazon QuickSight account.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The name of the group that you want to delete the user from.
	//
	// GroupName is a required field
	GroupName *string `location:"uri" locationName:"GroupName" min:"1" type:"string" required:"true"`

	// The name of the user that you want to delete from the group membership.
	//
	// MemberName is a required field
	MemberName *string `location:"uri" locationName:"MemberName" min:"1" type:"string" required:"true"`

	// The namespace. Currently, you should set this to default.
	//
	// Namespace is a required field
	Namespace *string `location:"uri" locationName:"Namespace" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteGroupMembershipInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteGroupMembershipInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteGroupMembershipInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteGroupMembershipInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.GroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupName"))
	}
	if s.GroupName != nil && len(*s.GroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupName", 1))
	}
	if s.MemberName == nil {
		invalidParams.Add(request.NewErrParamRequired("MemberName"))
	}
	if s.MemberName != nil && len(*s.MemberName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MemberName", 1))
	}
	if s.Namespace == nil {
		invalidParams.Add(request.NewErrParamRequired("Namespace"))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *DeleteGroupMembershipInput) SetAwsAccountId(v string) *DeleteGroupMembershipInput {
	s.AwsAccountId = &v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *DeleteGroupMembershipInput) SetGroupName(v string) *DeleteGroupMembershipInput {
	s.GroupName = &v
	return s
}

// SetMemberName sets the MemberName field's value.
func (s *DeleteGroupMembershipInput) SetMemberName(v string) *DeleteGroupMembershipInput {
	s.MemberName = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *DeleteGroupMembershipInput) SetNamespace(v string) *DeleteGroupMembershipInput {
	s.Namespace = &v
	return s
}

type DeleteGroupMembershipOutput struct {
	_ struct{} `type:"structure"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation
func (s DeleteGroupMembershipOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteGroupMembershipOutput) GoString() string {
	return s.String()
}

// SetRequestId sets the RequestId field's value.
func (s *DeleteGroupMembershipOutput) SetRequestId(v string) *DeleteGroupMembershipOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DeleteGroupMembershipOutput) SetStatus(v int64) *DeleteGroupMembershipOutput {
	s.Status = &v
	return s
}

type DeleteGroupOutput struct {
	_ struct{} `type:"structure"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation
func (s DeleteGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteGroupOutput) GoString() string {
	return s.String()
}

// SetRequestId sets the RequestId field's value.
func (s *DeleteGroupOutput) SetRequestId(v string) *DeleteGroupOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DeleteGroupOutput) SetStatus(v int64) *DeleteGroupOutput {
	s.Status = &v
	return s
}

type DeleteIAMPolicyAssignmentInput struct {
	_ struct{} `type:"structure"`

	// The name of the assignment.
	//
	// AssignmentName is a required field
	AssignmentName *string `location:"uri" locationName:"AssignmentName" min:"1" type:"string" required:"true"`

	// The AWS account ID where you want to delete an IAM policy assignment.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The namespace that contains the assignment.
	//
	// Namespace is a required field
	Namespace *string `location:"uri" locationName:"Namespace" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteIAMPolicyAssignmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteIAMPolicyAssignmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteIAMPolicyAssignmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteIAMPolicyAssignmentInput"}
	if s.AssignmentName == nil {
		invalidParams.Add(request.NewErrParamRequired("AssignmentName"))
	}
	if s.AssignmentName != nil && len(*s.AssignmentName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AssignmentName", 1))
	}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.Namespace == nil {
		invalidParams.Add(request.NewErrParamRequired("Namespace"))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssignmentName sets the AssignmentName field's value.
func (s *DeleteIAMPolicyAssignmentInput) SetAssignmentName(v string) *DeleteIAMPolicyAssignmentInput {
	s.AssignmentName = &v
	return s
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *DeleteIAMPolicyAssignmentInput) SetAwsAccountId(v string) *DeleteIAMPolicyAssignmentInput {
	s.AwsAccountId = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *DeleteIAMPolicyAssignmentInput) SetNamespace(v string) *DeleteIAMPolicyAssignmentInput {
	s.Namespace = &v
	return s
}

type DeleteIAMPolicyAssignmentOutput struct {
	_ struct{} `type:"structure"`

	// The name of the assignment.
	AssignmentName *string `min:"1" type:"string"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation
func (s DeleteIAMPolicyAssignmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteIAMPolicyAssignmentOutput) GoString() string {
	return s.String()
}

// SetAssignmentName sets the AssignmentName field's value.
func (s *DeleteIAMPolicyAssignmentOutput) SetAssignmentName(v string) *DeleteIAMPolicyAssignmentOutput {
	s.AssignmentName = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *DeleteIAMPolicyAssignmentOutput) SetRequestId(v string) *DeleteIAMPolicyAssignmentOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DeleteIAMPolicyAssignmentOutput) SetStatus(v int64) *DeleteIAMPolicyAssignmentOutput {
	s.Status = &v
	return s
}

type DeleteTemplateAliasInput struct {
	_ struct{} `type:"structure"`

	// The alias of the template that you want to delete. If you provide a specific
	// alias, you delete the version that the alias points to. You can specify the
	// latest version of the template by providing the keyword $LATEST in the AliasName
	// parameter.
	//
	// AliasName is a required field
	AliasName *string `location:"uri" locationName:"AliasName" min:"1" type:"string" required:"true"`

	// AWS account ID that contains the template alias you are deleting.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// An ID for the template.
	//
	// TemplateId is a required field
	TemplateId *string `location:"uri" locationName:"TemplateId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteTemplateAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTemplateAliasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTemplateAliasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteTemplateAliasInput"}
	if s.AliasName == nil {
		invalidParams.Add(request.NewErrParamRequired("AliasName"))
	}
	if s.AliasName != nil && len(*s.AliasName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AliasName", 1))
	}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.TemplateId == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateId"))
	}
	if s.TemplateId != nil && len(*s.TemplateId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAliasName sets the AliasName field's value.
func (s *DeleteTemplateAliasInput) SetAliasName(v string) *DeleteTemplateAliasInput {
	s.AliasName = &v
	return s
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *DeleteTemplateAliasInput) SetAwsAccountId(v string) *DeleteTemplateAliasInput {
	s.AwsAccountId = &v
	return s
}

// SetTemplateId sets the TemplateId field's value.
func (s *DeleteTemplateAliasInput) SetTemplateId(v string) *DeleteTemplateAliasInput {
	s.TemplateId = &v
	return s
}

type DeleteTemplateAliasOutput struct {
	_ struct{} `type:"structure"`

	// The name of the alias.
	AliasName *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the resource.
	Arn *string `type:"string"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`

	// An ID for the template.
	TemplateId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DeleteTemplateAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTemplateAliasOutput) GoString() string {
	return s.String()
}

// SetAliasName sets the AliasName field's value.
func (s *DeleteTemplateAliasOutput) SetAliasName(v string) *DeleteTemplateAliasOutput {
	s.AliasName = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *DeleteTemplateAliasOutput) SetArn(v string) *DeleteTemplateAliasOutput {
	s.Arn = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *DeleteTemplateAliasOutput) SetRequestId(v string) *DeleteTemplateAliasOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DeleteTemplateAliasOutput) SetStatus(v int64) *DeleteTemplateAliasOutput {
	s.Status = &v
	return s
}

// SetTemplateId sets the TemplateId field's value.
func (s *DeleteTemplateAliasOutput) SetTemplateId(v string) *DeleteTemplateAliasOutput {
	s.TemplateId = &v
	return s
}

type DeleteTemplateInput struct {
	_ struct{} `type:"structure"`

	// AWS account ID that contains the template you are deleting.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// An ID for the template you want to delete.
	//
	// TemplateId is a required field
	TemplateId *string `location:"uri" locationName:"TemplateId" min:"1" type:"string" required:"true"`

	// Specifies the version of the template that you want to delete. If you don't
	// provide a version number, DeleteTemplate deletes all versions of the template.
	VersionNumber *int64 `location:"querystring" locationName:"version-number" min:"1" type:"long"`
}

// String returns the string representation
func (s DeleteTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteTemplateInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.TemplateId == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateId"))
	}
	if s.TemplateId != nil && len(*s.TemplateId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateId", 1))
	}
	if s.VersionNumber != nil && *s.VersionNumber < 1 {
		invalidParams.Add(request.NewErrParamMinValue("VersionNumber", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *DeleteTemplateInput) SetAwsAccountId(v string) *DeleteTemplateInput {
	s.AwsAccountId = &v
	return s
}

// SetTemplateId sets the TemplateId field's value.
func (s *DeleteTemplateInput) SetTemplateId(v string) *DeleteTemplateInput {
	s.TemplateId = &v
	return s
}

// SetVersionNumber sets the VersionNumber field's value.
func (s *DeleteTemplateInput) SetVersionNumber(v int64) *DeleteTemplateInput {
	s.VersionNumber = &v
	return s
}

type DeleteTemplateOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource.
	Arn *string `type:"string"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`

	// An ID for the template.
	TemplateId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DeleteTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTemplateOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DeleteTemplateOutput) SetArn(v string) *DeleteTemplateOutput {
	s.Arn = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *DeleteTemplateOutput) SetRequestId(v string) *DeleteTemplateOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DeleteTemplateOutput) SetStatus(v int64) *DeleteTemplateOutput {
	s.Status = &v
	return s
}

// SetTemplateId sets the TemplateId field's value.
func (s *DeleteTemplateOutput) SetTemplateId(v string) *DeleteTemplateOutput {
	s.TemplateId = &v
	return s
}

type DeleteUserByPrincipalIdInput struct {
	_ struct{} `type:"structure"`

	// The ID for the AWS account that the user is in. Currently, you use the ID
	// for the AWS account that contains your Amazon QuickSight account.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The namespace. Currently, you should set this to default.
	//
	// Namespace is a required field
	Namespace *string `location:"uri" locationName:"Namespace" type:"string" required:"true"`

	// The principal ID of the user.
	//
	// PrincipalId is a required field
	PrincipalId *string `location:"uri" locationName:"PrincipalId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteUserByPrincipalIdInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteUserByPrincipalIdInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteUserByPrincipalIdInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteUserByPrincipalIdInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.Namespace == nil {
		invalidParams.Add(request.NewErrParamRequired("Namespace"))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}
	if s.PrincipalId == nil {
		invalidParams.Add(request.NewErrParamRequired("PrincipalId"))
	}
	if s.PrincipalId != nil && len(*s.PrincipalId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PrincipalId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *DeleteUserByPrincipalIdInput) SetAwsAccountId(v string) *DeleteUserByPrincipalIdInput {
	s.AwsAccountId = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *DeleteUserByPrincipalIdInput) SetNamespace(v string) *DeleteUserByPrincipalIdInput {
	s.Namespace = &v
	return s
}

// SetPrincipalId sets the PrincipalId field's value.
func (s *DeleteUserByPrincipalIdInput) SetPrincipalId(v string) *DeleteUserByPrincipalIdInput {
	s.PrincipalId = &v
	return s
}

type DeleteUserByPrincipalIdOutput struct {
	_ struct{} `type:"structure"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation
func (s DeleteUserByPrincipalIdOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteUserByPrincipalIdOutput) GoString() string {
	return s.String()
}

// SetRequestId sets the RequestId field's value.
func (s *DeleteUserByPrincipalIdOutput) SetRequestId(v string) *DeleteUserByPrincipalIdOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DeleteUserByPrincipalIdOutput) SetStatus(v int64) *DeleteUserByPrincipalIdOutput {
	s.Status = &v
	return s
}

type DeleteUserInput struct {
	_ struct{} `type:"structure"`

	// The ID for the AWS account that the user is in. Currently, you use the ID
	// for the AWS account that contains your Amazon QuickSight account.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The namespace. Currently, you should set this to default.
	//
	// Namespace is a required field
	Namespace *string `location:"uri" locationName:"Namespace" type:"string" required:"true"`

	// The name of the user that you want to delete.
	//
	// UserName is a required field
	UserName *string `location:"uri" locationName:"UserName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteUserInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.Namespace == nil {
		invalidParams.Add(request.NewErrParamRequired("Namespace"))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}
	if s.UserName == nil {
		invalidParams.Add(request.NewErrParamRequired("UserName"))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *DeleteUserInput) SetAwsAccountId(v string) *DeleteUserInput {
	s.AwsAccountId = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *DeleteUserInput) SetNamespace(v string) *DeleteUserInput {
	s.Namespace = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *DeleteUserInput) SetUserName(v string) *DeleteUserInput {
	s.UserName = &v
	return s
}

type DeleteUserOutput struct {
	_ struct{} `type:"structure"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation
func (s DeleteUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteUserOutput) GoString() string {
	return s.String()
}

// SetRequestId sets the RequestId field's value.
func (s *DeleteUserOutput) SetRequestId(v string) *DeleteUserOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DeleteUserOutput) SetStatus(v int64) *DeleteUserOutput {
	s.Status = &v
	return s
}

type DescribeDashboardInput struct {
	_ struct{} `type:"structure"`

	// The alias name.
	AliasName *string `location:"querystring" locationName:"alias-name" min:"1" type:"string"`

	// AWS account ID that contains the dashboard you are describing.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The ID for the dashboard.
	//
	// DashboardId is a required field
	DashboardId *string `location:"uri" locationName:"DashboardId" min:"1" type:"string" required:"true"`

	// The version number for the dashboard. If version number isn’t passed the
	// latest published dashboard version is described.
	VersionNumber *int64 `location:"querystring" locationName:"version-number" min:"1" type:"long"`
}

// String returns the string representation
func (s DescribeDashboardInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDashboardInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDashboardInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDashboardInput"}
	if s.AliasName != nil && len(*s.AliasName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AliasName", 1))
	}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.DashboardId == nil {
		invalidParams.Add(request.NewErrParamRequired("DashboardId"))
	}
	if s.DashboardId != nil && len(*s.DashboardId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DashboardId", 1))
	}
	if s.VersionNumber != nil && *s.VersionNumber < 1 {
		invalidParams.Add(request.NewErrParamMinValue("VersionNumber", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAliasName sets the AliasName field's value.
func (s *DescribeDashboardInput) SetAliasName(v string) *DescribeDashboardInput {
	s.AliasName = &v
	return s
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *DescribeDashboardInput) SetAwsAccountId(v string) *DescribeDashboardInput {
	s.AwsAccountId = &v
	return s
}

// SetDashboardId sets the DashboardId field's value.
func (s *DescribeDashboardInput) SetDashboardId(v string) *DescribeDashboardInput {
	s.DashboardId = &v
	return s
}

// SetVersionNumber sets the VersionNumber field's value.
func (s *DescribeDashboardInput) SetVersionNumber(v int64) *DescribeDashboardInput {
	s.VersionNumber = &v
	return s
}

type DescribeDashboardOutput struct {
	_ struct{} `type:"structure"`

	// Information about the dashboard.
	Dashboard *Dashboard `type:"structure"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The http status of this request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation
func (s DescribeDashboardOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDashboardOutput) GoString() string {
	return s.String()
}

// SetDashboard sets the Dashboard field's value.
func (s *DescribeDashboardOutput) SetDashboard(v *Dashboard) *DescribeDashboardOutput {
	s.Dashboard = v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *DescribeDashboardOutput) SetRequestId(v string) *DescribeDashboardOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeDashboardOutput) SetStatus(v int64) *DescribeDashboardOutput {
	s.Status = &v
	return s
}

type DescribeDashboardPermissionsInput struct {
	_ struct{} `type:"structure"`

	// AWS account ID that contains the dashboard you are describing permissions
	// of.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The ID for the dashboard, also added to IAM policy.
	//
	// DashboardId is a required field
	DashboardId *string `location:"uri" locationName:"DashboardId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeDashboardPermissionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDashboardPermissionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDashboardPermissionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDashboardPermissionsInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.DashboardId == nil {
		invalidParams.Add(request.NewErrParamRequired("DashboardId"))
	}
	if s.DashboardId != nil && len(*s.DashboardId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DashboardId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *DescribeDashboardPermissionsInput) SetAwsAccountId(v string) *DescribeDashboardPermissionsInput {
	s.AwsAccountId = &v
	return s
}

// SetDashboardId sets the DashboardId field's value.
func (s *DescribeDashboardPermissionsInput) SetDashboardId(v string) *DescribeDashboardPermissionsInput {
	s.DashboardId = &v
	return s
}

type DescribeDashboardPermissionsOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the dashboard.
	DashboardArn *string `type:"string"`

	// The ID for the dashboard.
	DashboardId *string `min:"1" type:"string"`

	// A structure that contains the permissions of the dashboard.
	Permissions []*ResourcePermission `min:"1" type:"list"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation
func (s DescribeDashboardPermissionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDashboardPermissionsOutput) GoString() string {
	return s.String()
}

// SetDashboardArn sets the DashboardArn field's value.
func (s *DescribeDashboardPermissionsOutput) SetDashboardArn(v string) *DescribeDashboardPermissionsOutput {
	s.DashboardArn = &v
	return s
}

// SetDashboardId sets the DashboardId field's value.
func (s *DescribeDashboardPermissionsOutput) SetDashboardId(v string) *DescribeDashboardPermissionsOutput {
	s.DashboardId = &v
	return s
}

// SetPermissions sets the Permissions field's value.
func (s *DescribeDashboardPermissionsOutput) SetPermissions(v []*ResourcePermission) *DescribeDashboardPermissionsOutput {
	s.Permissions = v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *DescribeDashboardPermissionsOutput) SetRequestId(v string) *DescribeDashboardPermissionsOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeDashboardPermissionsOutput) SetStatus(v int64) *DescribeDashboardPermissionsOutput {
	s.Status = &v
	return s
}

type DescribeDataSetInput struct {
	_ struct{} `type:"structure"`

	// The AWS Account ID.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The ID for the dataset that you want to create. This ID is unique per AWS
	// Region for each AWS account.
	//
	// DataSetId is a required field
	DataSetId *string `location:"uri" locationName:"DataSetId" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeDataSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDataSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDataSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDataSetInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.DataSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSetId"))
	}
	if s.DataSetId != nil && len(*s.DataSetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataSetId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *DescribeDataSetInput) SetAwsAccountId(v string) *DescribeDataSetInput {
	s.AwsAccountId = &v
	return s
}

// SetDataSetId sets the DataSetId field's value.
func (s *DescribeDataSetInput) SetDataSetId(v string) *DescribeDataSetInput {
	s.DataSetId = &v
	return s
}

type DescribeDataSetOutput struct {
	_ struct{} `type:"structure"`

	// Information on the dataset.
	DataSet *DataSet `type:"structure"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation
func (s DescribeDataSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDataSetOutput) GoString() string {
	return s.String()
}

// SetDataSet sets the DataSet field's value.
func (s *DescribeDataSetOutput) SetDataSet(v *DataSet) *DescribeDataSetOutput {
	s.DataSet = v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *DescribeDataSetOutput) SetRequestId(v string) *DescribeDataSetOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeDataSetOutput) SetStatus(v int64) *DescribeDataSetOutput {
	s.Status = &v
	return s
}

type DescribeDataSetPermissionsInput struct {
	_ struct{} `type:"structure"`

	// The AWS Account ID.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The ID for the dataset that you want to create. This ID is unique per AWS
	// Region for each AWS account.
	//
	// DataSetId is a required field
	DataSetId *string `location:"uri" locationName:"DataSetId" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeDataSetPermissionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDataSetPermissionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDataSetPermissionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDataSetPermissionsInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.DataSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSetId"))
	}
	if s.DataSetId != nil && len(*s.DataSetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataSetId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *DescribeDataSetPermissionsInput) SetAwsAccountId(v string) *DescribeDataSetPermissionsInput {
	s.AwsAccountId = &v
	return s
}

// SetDataSetId sets the DataSetId field's value.
func (s *DescribeDataSetPermissionsInput) SetDataSetId(v string) *DescribeDataSetPermissionsInput {
	s.DataSetId = &v
	return s
}

type DescribeDataSetPermissionsOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the dataset.
	DataSetArn *string `type:"string"`

	// The ID for the dataset that you want to create. This ID is unique per AWS
	// Region for each AWS account.
	DataSetId *string `type:"string"`

	// A list of resource permissions on the dataset.
	Permissions []*ResourcePermission `min:"1" type:"list"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation
func (s DescribeDataSetPermissionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDataSetPermissionsOutput) GoString() string {
	return s.String()
}

// SetDataSetArn sets the DataSetArn field's value.
func (s *DescribeDataSetPermissionsOutput) SetDataSetArn(v string) *DescribeDataSetPermissionsOutput {
	s.DataSetArn = &v
	return s
}

// SetDataSetId sets the DataSetId field's value.
func (s *DescribeDataSetPermissionsOutput) SetDataSetId(v string) *DescribeDataSetPermissionsOutput {
	s.DataSetId = &v
	return s
}

// SetPermissions sets the Permissions field's value.
func (s *DescribeDataSetPermissionsOutput) SetPermissions(v []*ResourcePermission) *DescribeDataSetPermissionsOutput {
	s.Permissions = v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *DescribeDataSetPermissionsOutput) SetRequestId(v string) *DescribeDataSetPermissionsOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeDataSetPermissionsOutput) SetStatus(v int64) *DescribeDataSetPermissionsOutput {
	s.Status = &v
	return s
}

type DescribeDataSourceInput struct {
	_ struct{} `type:"structure"`

	// The AWS account ID.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The ID of the data source. This ID is unique per AWS Region for each AWS
	// account.
	//
	// DataSourceId is a required field
	DataSourceId *string `location:"uri" locationName:"DataSourceId" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeDataSourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDataSourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDataSourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDataSourceInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.DataSourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSourceId"))
	}
	if s.DataSourceId != nil && len(*s.DataSourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataSourceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *DescribeDataSourceInput) SetAwsAccountId(v string) *DescribeDataSourceInput {
	s.AwsAccountId = &v
	return s
}

// SetDataSourceId sets the DataSourceId field's value.
func (s *DescribeDataSourceInput) SetDataSourceId(v string) *DescribeDataSourceInput {
	s.DataSourceId = &v
	return s
}

type DescribeDataSourceOutput struct {
	_ struct{} `type:"structure"`

	// The information on the data source.
	DataSource *DataSource `type:"structure"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation
func (s DescribeDataSourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDataSourceOutput) GoString() string {
	return s.String()
}

// SetDataSource sets the DataSource field's value.
func (s *DescribeDataSourceOutput) SetDataSource(v *DataSource) *DescribeDataSourceOutput {
	s.DataSource = v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *DescribeDataSourceOutput) SetRequestId(v string) *DescribeDataSourceOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeDataSourceOutput) SetStatus(v int64) *DescribeDataSourceOutput {
	s.Status = &v
	return s
}

type DescribeDataSourcePermissionsInput struct {
	_ struct{} `type:"structure"`

	// The AWS account ID.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The ID of the data source. This ID is unique per AWS Region for each AWS
	// account.
	//
	// DataSourceId is a required field
	DataSourceId *string `location:"uri" locationName:"DataSourceId" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeDataSourcePermissionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDataSourcePermissionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDataSourcePermissionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDataSourcePermissionsInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.DataSourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSourceId"))
	}
	if s.DataSourceId != nil && len(*s.DataSourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataSourceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *DescribeDataSourcePermissionsInput) SetAwsAccountId(v string) *DescribeDataSourcePermissionsInput {
	s.AwsAccountId = &v
	return s
}

// SetDataSourceId sets the DataSourceId field's value.
func (s *DescribeDataSourcePermissionsInput) SetDataSourceId(v string) *DescribeDataSourcePermissionsInput {
	s.DataSourceId = &v
	return s
}

type DescribeDataSourcePermissionsOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the data source.
	DataSourceArn *string `type:"string"`

	// The ID of the data source. This ID is unique per AWS Region for each AWS
	// account.
	DataSourceId *string `type:"string"`

	// A list of resource permissions on the data source.
	Permissions []*ResourcePermission `min:"1" type:"list"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation
func (s DescribeDataSourcePermissionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDataSourcePermissionsOutput) GoString() string {
	return s.String()
}

// SetDataSourceArn sets the DataSourceArn field's value.
func (s *DescribeDataSourcePermissionsOutput) SetDataSourceArn(v string) *DescribeDataSourcePermissionsOutput {
	s.DataSourceArn = &v
	return s
}

// SetDataSourceId sets the DataSourceId field's value.
func (s *DescribeDataSourcePermissionsOutput) SetDataSourceId(v string) *DescribeDataSourcePermissionsOutput {
	s.DataSourceId = &v
	return s
}

// SetPermissions sets the Permissions field's value.
func (s *DescribeDataSourcePermissionsOutput) SetPermissions(v []*ResourcePermission) *DescribeDataSourcePermissionsOutput {
	s.Permissions = v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *DescribeDataSourcePermissionsOutput) SetRequestId(v string) *DescribeDataSourcePermissionsOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeDataSourcePermissionsOutput) SetStatus(v int64) *DescribeDataSourcePermissionsOutput {
	s.Status = &v
	return s
}

type DescribeGroupInput struct {
	_ struct{} `type:"structure"`

	// The ID for the AWS account that the group is in. Currently, you use the ID
	// for the AWS account that contains your Amazon QuickSight account.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The name of the group that you want to describe.
	//
	// GroupName is a required field
	GroupName *string `location:"uri" locationName:"GroupName" min:"1" type:"string" required:"true"`

	// The namespace. Currently, you should set this to default.
	//
	// Namespace is a required field
	Namespace *string `location:"uri" locationName:"Namespace" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeGroupInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.GroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupName"))
	}
	if s.GroupName != nil && len(*s.GroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupName", 1))
	}
	if s.Namespace == nil {
		invalidParams.Add(request.NewErrParamRequired("Namespace"))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *DescribeGroupInput) SetAwsAccountId(v string) *DescribeGroupInput {
	s.AwsAccountId = &v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *DescribeGroupInput) SetGroupName(v string) *DescribeGroupInput {
	s.GroupName = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *DescribeGroupInput) SetNamespace(v string) *DescribeGroupInput {
	s.Namespace = &v
	return s
}

type DescribeGroupOutput struct {
	_ struct{} `type:"structure"`

	// The name of the group.
	Group *Group `type:"structure"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation
func (s DescribeGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeGroupOutput) GoString() string {
	return s.String()
}

// SetGroup sets the Group field's value.
func (s *DescribeGroupOutput) SetGroup(v *Group) *DescribeGroupOutput {
	s.Group = v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *DescribeGroupOutput) SetRequestId(v string) *DescribeGroupOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeGroupOutput) SetStatus(v int64) *DescribeGroupOutput {
	s.Status = &v
	return s
}

type DescribeIAMPolicyAssignmentInput struct {
	_ struct{} `type:"structure"`

	// The name of the assignment.
	//
	// AssignmentName is a required field
	AssignmentName *string `location:"uri" locationName:"AssignmentName" min:"1" type:"string" required:"true"`

	// The AWS account ID that contains the assignment you want to describe.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The namespace that contains the assignment.
	//
	// Namespace is a required field
	Namespace *string `location:"uri" locationName:"Namespace" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeIAMPolicyAssignmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeIAMPolicyAssignmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeIAMPolicyAssignmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeIAMPolicyAssignmentInput"}
	if s.AssignmentName == nil {
		invalidParams.Add(request.NewErrParamRequired("AssignmentName"))
	}
	if s.AssignmentName != nil && len(*s.AssignmentName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AssignmentName", 1))
	}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.Namespace == nil {
		invalidParams.Add(request.NewErrParamRequired("Namespace"))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssignmentName sets the AssignmentName field's value.
func (s *DescribeIAMPolicyAssignmentInput) SetAssignmentName(v string) *DescribeIAMPolicyAssignmentInput {
	s.AssignmentName = &v
	return s
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *DescribeIAMPolicyAssignmentInput) SetAwsAccountId(v string) *DescribeIAMPolicyAssignmentInput {
	s.AwsAccountId = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *DescribeIAMPolicyAssignmentInput) SetNamespace(v string) *DescribeIAMPolicyAssignmentInput {
	s.Namespace = &v
	return s
}

type DescribeIAMPolicyAssignmentOutput struct {
	_ struct{} `type:"structure"`

	// Information describing the IAM policy assignment.
	IAMPolicyAssignment *IAMPolicyAssignment `type:"structure"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation
func (s DescribeIAMPolicyAssignmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeIAMPolicyAssignmentOutput) GoString() string {
	return s.String()
}

// SetIAMPolicyAssignment sets the IAMPolicyAssignment field's value.
func (s *DescribeIAMPolicyAssignmentOutput) SetIAMPolicyAssignment(v *IAMPolicyAssignment) *DescribeIAMPolicyAssignmentOutput {
	s.IAMPolicyAssignment = v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *DescribeIAMPolicyAssignmentOutput) SetRequestId(v string) *DescribeIAMPolicyAssignmentOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeIAMPolicyAssignmentOutput) SetStatus(v int64) *DescribeIAMPolicyAssignmentOutput {
	s.Status = &v
	return s
}

type DescribeIngestionInput struct {
	_ struct{} `type:"structure"`

	// The AWS account ID.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The ID of the dataset used in the ingestion.
	//
	// DataSetId is a required field
	DataSetId *string `location:"uri" locationName:"DataSetId" type:"string" required:"true"`

	// An ID for the ingestion.
	//
	// IngestionId is a required field
	IngestionId *string `location:"uri" locationName:"IngestionId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeIngestionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeIngestionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeIngestionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeIngestionInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.DataSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSetId"))
	}
	if s.DataSetId != nil && len(*s.DataSetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataSetId", 1))
	}
	if s.IngestionId == nil {
		invalidParams.Add(request.NewErrParamRequired("IngestionId"))
	}
	if s.IngestionId != nil && len(*s.IngestionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IngestionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *DescribeIngestionInput) SetAwsAccountId(v string) *DescribeIngestionInput {
	s.AwsAccountId = &v
	return s
}

// SetDataSetId sets the DataSetId field's value.
func (s *DescribeIngestionInput) SetDataSetId(v string) *DescribeIngestionInput {
	s.DataSetId = &v
	return s
}

// SetIngestionId sets the IngestionId field's value.
func (s *DescribeIngestionInput) SetIngestionId(v string) *DescribeIngestionInput {
	s.IngestionId = &v
	return s
}

type DescribeIngestionOutput struct {
	_ struct{} `type:"structure"`

	// Information about the ingestion.
	Ingestion *Ingestion `type:"structure"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation
func (s DescribeIngestionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeIngestionOutput) GoString() string {
	return s.String()
}

// SetIngestion sets the Ingestion field's value.
func (s *DescribeIngestionOutput) SetIngestion(v *Ingestion) *DescribeIngestionOutput {
	s.Ingestion = v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *DescribeIngestionOutput) SetRequestId(v string) *DescribeIngestionOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeIngestionOutput) SetStatus(v int64) *DescribeIngestionOutput {
	s.Status = &v
	return s
}

type DescribeTemplateAliasInput struct {
	_ struct{} `type:"structure"`

	// The alias of the template that you want to describe. If you provide a specific
	// alias, you describe the version that the alias points to. You can specify
	// the latest version of the template by providing the keyword $LATEST in the
	// AliasName parameter. The keyword $PUBLISHED doesn't apply to templates.
	//
	// AliasName is a required field
	AliasName *string `location:"uri" locationName:"AliasName" min:"1" type:"string" required:"true"`

	// AWS account ID that contains the template alias you are describing.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// An ID for the template.
	//
	// TemplateId is a required field
	TemplateId *string `location:"uri" locationName:"TemplateId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeTemplateAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTemplateAliasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTemplateAliasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeTemplateAliasInput"}
	if s.AliasName == nil {
		invalidParams.Add(request.NewErrParamRequired("AliasName"))
	}
	if s.AliasName != nil && len(*s.AliasName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AliasName", 1))
	}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.TemplateId == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateId"))
	}
	if s.TemplateId != nil && len(*s.TemplateId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAliasName sets the AliasName field's value.
func (s *DescribeTemplateAliasInput) SetAliasName(v string) *DescribeTemplateAliasInput {
	s.AliasName = &v
	return s
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *DescribeTemplateAliasInput) SetAwsAccountId(v string) *DescribeTemplateAliasInput {
	s.AwsAccountId = &v
	return s
}

// SetTemplateId sets the TemplateId field's value.
func (s *DescribeTemplateAliasInput) SetTemplateId(v string) *DescribeTemplateAliasInput {
	s.TemplateId = &v
	return s
}

type DescribeTemplateAliasOutput struct {
	_ struct{} `type:"structure"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`

	// Information about the template alias.
	TemplateAlias *TemplateAlias `type:"structure"`
}

// String returns the string representation
func (s DescribeTemplateAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTemplateAliasOutput) GoString() string {
	return s.String()
}

// SetRequestId sets the RequestId field's value.
func (s *DescribeTemplateAliasOutput) SetRequestId(v string) *DescribeTemplateAliasOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeTemplateAliasOutput) SetStatus(v int64) *DescribeTemplateAliasOutput {
	s.Status = &v
	return s
}

// SetTemplateAlias sets the TemplateAlias field's value.
func (s *DescribeTemplateAliasOutput) SetTemplateAlias(v *TemplateAlias) *DescribeTemplateAliasOutput {
	s.TemplateAlias = v
	return s
}

type DescribeTemplateInput struct {
	_ struct{} `type:"structure"`

	// The alias of the template that you want to describe. If you provide a specific
	// alias, you describe the version that the alias points to. You can specify
	// the latest version of the template by providing the keyword $LATEST in the
	// AliasName parameter. The keyword $PUBLISHED doesn't apply to templates.
	AliasName *string `location:"querystring" locationName:"alias-name" min:"1" type:"string"`

	// AWS account ID that contains the template you are describing.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// An ID for the template.
	//
	// TemplateId is a required field
	TemplateId *string `location:"uri" locationName:"TemplateId" min:"1" type:"string" required:"true"`

	// This is an optional field, when a version number is provided the corresponding
	// version is describe, if it's not provided the latest version of the template
	// is described.
	VersionNumber *int64 `location:"querystring" locationName:"version-number" min:"1" type:"long"`
}

// String returns the string representation
func (s DescribeTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeTemplateInput"}
	if s.AliasName != nil && len(*s.AliasName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AliasName", 1))
	}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.TemplateId == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateId"))
	}
	if s.TemplateId != nil && len(*s.TemplateId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateId", 1))
	}
	if s.VersionNumber != nil && *s.VersionNumber < 1 {
		invalidParams.Add(request.NewErrParamMinValue("VersionNumber", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAliasName sets the AliasName field's value.
func (s *DescribeTemplateInput) SetAliasName(v string) *DescribeTemplateInput {
	s.AliasName = &v
	return s
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *DescribeTemplateInput) SetAwsAccountId(v string) *DescribeTemplateInput {
	s.AwsAccountId = &v
	return s
}

// SetTemplateId sets the TemplateId field's value.
func (s *DescribeTemplateInput) SetTemplateId(v string) *DescribeTemplateInput {
	s.TemplateId = &v
	return s
}

// SetVersionNumber sets the VersionNumber field's value.
func (s *DescribeTemplateInput) SetVersionNumber(v int64) *DescribeTemplateInput {
	s.VersionNumber = &v
	return s
}

type DescribeTemplateOutput struct {
	_ struct{} `type:"structure"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`

	// The template structure of the object you want to describe.
	Template *Template `type:"structure"`
}

// String returns the string representation
func (s DescribeTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTemplateOutput) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *DescribeTemplateOutput) SetStatus(v int64) *DescribeTemplateOutput {
	s.Status = &v
	return s
}

// SetTemplate sets the Template field's value.
func (s *DescribeTemplateOutput) SetTemplate(v *Template) *DescribeTemplateOutput {
	s.Template = v
	return s
}

type DescribeTemplatePermissionsInput struct {
	_ struct{} `type:"structure"`

	// AWS account ID that contains the template you are describing.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The ID for the template.
	//
	// TemplateId is a required field
	TemplateId *string `location:"uri" locationName:"TemplateId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeTemplatePermissionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTemplatePermissionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTemplatePermissionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeTemplatePermissionsInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.TemplateId == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateId"))
	}
	if s.TemplateId != nil && len(*s.TemplateId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *DescribeTemplatePermissionsInput) SetAwsAccountId(v string) *DescribeTemplatePermissionsInput {
	s.AwsAccountId = &v
	return s
}

// SetTemplateId sets the TemplateId field's value.
func (s *DescribeTemplatePermissionsInput) SetTemplateId(v string) *DescribeTemplatePermissionsInput {
	s.TemplateId = &v
	return s
}

type DescribeTemplatePermissionsOutput struct {
	_ struct{} `type:"structure"`

	// A list of resource permissions to be set on the template.
	Permissions []*ResourcePermission `min:"1" type:"list"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`

	// The Amazon Resource Name (ARN) of the template.
	TemplateArn *string `type:"string"`

	// The ID for the template.
	TemplateId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeTemplatePermissionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTemplatePermissionsOutput) GoString() string {
	return s.String()
}

// SetPermissions sets the Permissions field's value.
func (s *DescribeTemplatePermissionsOutput) SetPermissions(v []*ResourcePermission) *DescribeTemplatePermissionsOutput {
	s.Permissions = v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *DescribeTemplatePermissionsOutput) SetRequestId(v string) *DescribeTemplatePermissionsOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeTemplatePermissionsOutput) SetStatus(v int64) *DescribeTemplatePermissionsOutput {
	s.Status = &v
	return s
}

// SetTemplateArn sets the TemplateArn field's value.
func (s *DescribeTemplatePermissionsOutput) SetTemplateArn(v string) *DescribeTemplatePermissionsOutput {
	s.TemplateArn = &v
	return s
}

// SetTemplateId sets the TemplateId field's value.
func (s *DescribeTemplatePermissionsOutput) SetTemplateId(v string) *DescribeTemplatePermissionsOutput {
	s.TemplateId = &v
	return s
}

type DescribeUserInput struct {
	_ struct{} `type:"structure"`

	// The ID for the AWS account that the user is in. Currently, you use the ID
	// for the AWS account that contains your Amazon QuickSight account.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The namespace. Currently, you should set this to default.
	//
	// Namespace is a required field
	Namespace *string `location:"uri" locationName:"Namespace" type:"string" required:"true"`

	// The name of the user that you want to describe.
	//
	// UserName is a required field
	UserName *string `location:"uri" locationName:"UserName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeUserInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.Namespace == nil {
		invalidParams.Add(request.NewErrParamRequired("Namespace"))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}
	if s.UserName == nil {
		invalidParams.Add(request.NewErrParamRequired("UserName"))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *DescribeUserInput) SetAwsAccountId(v string) *DescribeUserInput {
	s.AwsAccountId = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *DescribeUserInput) SetNamespace(v string) *DescribeUserInput {
	s.Namespace = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *DescribeUserInput) SetUserName(v string) *DescribeUserInput {
	s.UserName = &v
	return s
}

type DescribeUserOutput struct {
	_ struct{} `type:"structure"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`

	// The user name.
	User *User `type:"structure"`
}

// String returns the string representation
func (s DescribeUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeUserOutput) GoString() string {
	return s.String()
}

// SetRequestId sets the RequestId field's value.
func (s *DescribeUserOutput) SetRequestId(v string) *DescribeUserOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeUserOutput) SetStatus(v int64) *DescribeUserOutput {
	s.Status = &v
	return s
}

// SetUser sets the User field's value.
func (s *DescribeUserOutput) SetUser(v *User) *DescribeUserOutput {
	s.User = v
	return s
}

// Error information on a data set SPICE ingestion.
type ErrorInfo struct {
	_ struct{} `type:"structure"`

	// Error essage.
	Message *string `type:"string"`

	// Error type.
	Type *string `type:"string" enum:"IngestionErrorType"`
}

// String returns the string representation
func (s ErrorInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ErrorInfo) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *ErrorInfo) SetMessage(v string) *ErrorInfo {
	s.Message = &v
	return s
}

// SetType sets the Type field's value.
func (s *ErrorInfo) SetType(v string) *ErrorInfo {
	s.Type = &v
	return s
}

// Export to CSV option.
type ExportToCSVOption struct {
	_ struct{} `type:"structure"`

	// Availability status.
	AvailabilityStatus *string `type:"string" enum:"DashboardBehavior"`
}

// String returns the string representation
func (s ExportToCSVOption) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExportToCSVOption) GoString() string {
	return s.String()
}

// SetAvailabilityStatus sets the AvailabilityStatus field's value.
func (s *ExportToCSVOption) SetAvailabilityStatus(v string) *ExportToCSVOption {
	s.AvailabilityStatus = &v
	return s
}

// A transform operation that filters rows based on some condition.
type FilterOperation struct {
	_ struct{} `type:"structure"`

	// An expression that must evaluate to a boolean value. Rows for which the expression
	// is evaluated to true are kept in the dataset.
	//
	// ConditionExpression is a required field
	ConditionExpression *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s FilterOperation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FilterOperation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FilterOperation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FilterOperation"}
	if s.ConditionExpression == nil {
		invalidParams.Add(request.NewErrParamRequired("ConditionExpression"))
	}
	if s.ConditionExpression != nil && len(*s.ConditionExpression) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConditionExpression", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConditionExpression sets the ConditionExpression field's value.
func (s *FilterOperation) SetConditionExpression(v string) *FilterOperation {
	s.ConditionExpression = &v
	return s
}

// Geospatial column group that denotes a hierarchy.
type GeoSpatialColumnGroup struct {
	_ struct{} `type:"structure"`

	// Columns in this hierarchy.
	//
	// Columns is a required field
	Columns []*string `min:"1" type:"list" required:"true"`

	// Country code.
	//
	// CountryCode is a required field
	CountryCode *string `type:"string" required:"true" enum:"GeoSpatialCountryCode"`

	// A display name for the hierarchy.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GeoSpatialColumnGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GeoSpatialColumnGroup) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GeoSpatialColumnGroup) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GeoSpatialColumnGroup"}
	if s.Columns == nil {
		invalidParams.Add(request.NewErrParamRequired("Columns"))
	}
	if s.Columns != nil && len(s.Columns) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Columns", 1))
	}
	if s.CountryCode == nil {
		invalidParams.Add(request.NewErrParamRequired("CountryCode"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetColumns sets the Columns field's value.
func (s *GeoSpatialColumnGroup) SetColumns(v []*string) *GeoSpatialColumnGroup {
	s.Columns = v
	return s
}

// SetCountryCode sets the CountryCode field's value.
func (s *GeoSpatialColumnGroup) SetCountryCode(v string) *GeoSpatialColumnGroup {
	s.CountryCode = &v
	return s
}

// SetName sets the Name field's value.
func (s *GeoSpatialColumnGroup) SetName(v string) *GeoSpatialColumnGroup {
	s.Name = &v
	return s
}

type GetDashboardEmbedUrlInput struct {
	_ struct{} `type:"structure"`

	// AWS account ID that contains the dashboard you are embedding.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The ID for the dashboard, also added to IAM policy
	//
	// DashboardId is a required field
	DashboardId *string `location:"uri" locationName:"DashboardId" min:"1" type:"string" required:"true"`

	// The authentication method the user uses to sign in.
	//
	// IdentityType is a required field
	IdentityType *string `location:"querystring" locationName:"creds-type" type:"string" required:"true" enum:"IdentityType"`

	// Remove the reset button on embedded dashboard. The default is FALSE, which
	// allows the reset button.
	ResetDisabled *bool `location:"querystring" locationName:"reset-disabled" type:"boolean"`

	// How many minutes the session is valid. The session lifetime must be between
	// 15 and 600 minutes.
	SessionLifetimeInMinutes *int64 `location:"querystring" locationName:"session-lifetime" min:"15" type:"long"`

	// Remove the undo/redo button on embedded dashboard. The default is FALSE,
	// which enables the undo/redo button.
	UndoRedoDisabled *bool `location:"querystring" locationName:"undo-redo-disabled" type:"boolean"`

	// The Amazon QuickSight user's Amazon Resource Name (ARN), for use with QUICKSIGHT
	// identity type. You can use this for any Amazon QuickSight users in your account
	// (readers, authors, or admins) authenticated as one of the following:
	//
	//    * Active Directory (AD) users or group members
	//
	//    * Invited non-federated users
	//
	//    * IAM users and IAM role-based sessions authenticated through Federated
	//    Single Sign-On using SAML, OpenID Connect, or IAM Federation
	UserArn *string `location:"querystring" locationName:"user-arn" type:"string"`
}

// String returns the string representation
func (s GetDashboardEmbedUrlInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDashboardEmbedUrlInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDashboardEmbedUrlInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDashboardEmbedUrlInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.DashboardId == nil {
		invalidParams.Add(request.NewErrParamRequired("DashboardId"))
	}
	if s.DashboardId != nil && len(*s.DashboardId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DashboardId", 1))
	}
	if s.IdentityType == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityType"))
	}
	if s.SessionLifetimeInMinutes != nil && *s.SessionLifetimeInMinutes < 15 {
		invalidParams.Add(request.NewErrParamMinValue("SessionLifetimeInMinutes", 15))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *GetDashboardEmbedUrlInput) SetAwsAccountId(v string) *GetDashboardEmbedUrlInput {
	s.AwsAccountId = &v
	return s
}

// SetDashboardId sets the DashboardId field's value.
func (s *GetDashboardEmbedUrlInput) SetDashboardId(v string) *GetDashboardEmbedUrlInput {
	s.DashboardId = &v
	return s
}

// SetIdentityType sets the IdentityType field's value.
func (s *GetDashboardEmbedUrlInput) SetIdentityType(v string) *GetDashboardEmbedUrlInput {
	s.IdentityType = &v
	return s
}

// SetResetDisabled sets the ResetDisabled field's value.
func (s *GetDashboardEmbedUrlInput) SetResetDisabled(v bool) *GetDashboardEmbedUrlInput {
	s.ResetDisabled = &v
	return s
}

// SetSessionLifetimeInMinutes sets the SessionLifetimeInMinutes field's value.
func (s *GetDashboardEmbedUrlInput) SetSessionLifetimeInMinutes(v int64) *GetDashboardEmbedUrlInput {
	s.SessionLifetimeInMinutes = &v
	return s
}

// SetUndoRedoDisabled sets the UndoRedoDisabled field's value.
func (s *GetDashboardEmbedUrlInput) SetUndoRedoDisabled(v bool) *GetDashboardEmbedUrlInput {
	s.UndoRedoDisabled = &v
	return s
}

// SetUserArn sets the UserArn field's value.
func (s *GetDashboardEmbedUrlInput) SetUserArn(v string) *GetDashboardEmbedUrlInput {
	s.UserArn = &v
	return s
}

type GetDashboardEmbedUrlOutput struct {
	_ struct{} `type:"structure"`

	// URL that you can put into your server-side webpage to embed your dashboard.
	// This URL is valid for 5 minutes, and the resulting session is valid for 10
	// hours. The API provides the URL with an auth_code that enables a single-signon
	// session.
	EmbedUrl *string `type:"string" sensitive:"true"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation
func (s GetDashboardEmbedUrlOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDashboardEmbedUrlOutput) GoString() string {
	return s.String()
}

// SetEmbedUrl sets the EmbedUrl field's value.
func (s *GetDashboardEmbedUrlOutput) SetEmbedUrl(v string) *GetDashboardEmbedUrlOutput {
	s.EmbedUrl = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *GetDashboardEmbedUrlOutput) SetRequestId(v string) *GetDashboardEmbedUrlOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetDashboardEmbedUrlOutput) SetStatus(v int64) *GetDashboardEmbedUrlOutput {
	s.Status = &v
	return s
}

// A group in Amazon QuickSight consists of a set of users. You can use groups
// to make it easier to manage access and security. Currently, an Amazon QuickSight
// subscription can't contain more than 500 Amazon QuickSight groups.
type Group struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource name (ARN) for the group.
	Arn *string `type:"string"`

	// The group description.
	Description *string `min:"1" type:"string"`

	// The name of the group.
	GroupName *string `min:"1" type:"string"`

	// The principal ID of the group.
	PrincipalId *string `type:"string"`
}

// String returns the string representation
func (s Group) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Group) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Group) SetArn(v string) *Group {
	s.Arn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Group) SetDescription(v string) *Group {
	s.Description = &v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *Group) SetGroupName(v string) *Group {
	s.GroupName = &v
	return s
}

// SetPrincipalId sets the PrincipalId field's value.
func (s *Group) SetPrincipalId(v string) *Group {
	s.PrincipalId = &v
	return s
}

// A member of an Amazon QuickSight group. Currently, group members must be
// users. Groups can't be members of another group. .
type GroupMember struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource name (ARN) for the group member (user).
	Arn *string `type:"string"`

	// The name of the group member (user).
	MemberName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GroupMember) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GroupMember) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GroupMember) SetArn(v string) *GroupMember {
	s.Arn = &v
	return s
}

// SetMemberName sets the MemberName field's value.
func (s *GroupMember) SetMemberName(v string) *GroupMember {
	s.MemberName = &v
	return s
}

// IAM policy assignment.
type IAMPolicyAssignment struct {
	_ struct{} `type:"structure"`

	// Assignment ID.
	AssignmentId *string `type:"string"`

	// Assignment name.
	AssignmentName *string `min:"1" type:"string"`

	// Assignment status.
	AssignmentStatus *string `type:"string" enum:"AssignmentStatus"`

	// AWS account ID.
	AwsAccountId *string `min:"12" type:"string"`

	// Identities.
	Identities map[string][]*string `type:"map"`

	// Policy Amazon Resource Name (ARN).
	PolicyArn *string `type:"string"`
}

// String returns the string representation
func (s IAMPolicyAssignment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IAMPolicyAssignment) GoString() string {
	return s.String()
}

// SetAssignmentId sets the AssignmentId field's value.
func (s *IAMPolicyAssignment) SetAssignmentId(v string) *IAMPolicyAssignment {
	s.AssignmentId = &v
	return s
}

// SetAssignmentName sets the AssignmentName field's value.
func (s *IAMPolicyAssignment) SetAssignmentName(v string) *IAMPolicyAssignment {
	s.AssignmentName = &v
	return s
}

// SetAssignmentStatus sets the AssignmentStatus field's value.
func (s *IAMPolicyAssignment) SetAssignmentStatus(v string) *IAMPolicyAssignment {
	s.AssignmentStatus = &v
	return s
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *IAMPolicyAssignment) SetAwsAccountId(v string) *IAMPolicyAssignment {
	s.AwsAccountId = &v
	return s
}

// SetIdentities sets the Identities field's value.
func (s *IAMPolicyAssignment) SetIdentities(v map[string][]*string) *IAMPolicyAssignment {
	s.Identities = v
	return s
}

// SetPolicyArn sets the PolicyArn field's value.
func (s *IAMPolicyAssignment) SetPolicyArn(v string) *IAMPolicyAssignment {
	s.PolicyArn = &v
	return s
}

// IAM policy assignment Summary.
type IAMPolicyAssignmentSummary struct {
	_ struct{} `type:"structure"`

	// Assignment name.
	AssignmentName *string `min:"1" type:"string"`

	// Assignment status.
	AssignmentStatus *string `type:"string" enum:"AssignmentStatus"`
}

// String returns the string representation
func (s IAMPolicyAssignmentSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IAMPolicyAssignmentSummary) GoString() string {
	return s.String()
}

// SetAssignmentName sets the AssignmentName field's value.
func (s *IAMPolicyAssignmentSummary) SetAssignmentName(v string) *IAMPolicyAssignmentSummary {
	s.AssignmentName = &v
	return s
}

// SetAssignmentStatus sets the AssignmentStatus field's value.
func (s *IAMPolicyAssignmentSummary) SetAssignmentStatus(v string) *IAMPolicyAssignmentSummary {
	s.AssignmentStatus = &v
	return s
}

// Information on the SPICE ingestion for a dataset.
type Ingestion struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource name (ARN) of the resource.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`

	// The time this ingestion started.
	//
	// CreatedTime is a required field
	CreatedTime *time.Time `type:"timestamp" required:"true"`

	// Error information for this ingestion.
	ErrorInfo *ErrorInfo `type:"structure"`

	// Ingestion ID.
	IngestionId *string `min:"1" type:"string"`

	// Size of the data ingested in bytes.
	IngestionSizeInBytes *int64 `type:"long"`

	// Ingestion status.
	//
	// IngestionStatus is a required field
	IngestionStatus *string `type:"string" required:"true" enum:"IngestionStatus"`

	// The time this ingestion took, measured in seconds.
	IngestionTimeInSeconds *int64 `type:"long"`

	// Information on queued dataset SPICE ingestion.
	QueueInfo *QueueInfo `type:"structure"`

	// Event source for this ingestion.
	RequestSource *string `type:"string" enum:"IngestionRequestSource"`

	// Type of this ingestion.
	RequestType *string `type:"string" enum:"IngestionRequestType"`

	// Information on rows during a data set SPICE ingestion.
	RowInfo *RowInfo `type:"structure"`
}

// String returns the string representation
func (s Ingestion) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Ingestion) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Ingestion) SetArn(v string) *Ingestion {
	s.Arn = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *Ingestion) SetCreatedTime(v time.Time) *Ingestion {
	s.CreatedTime = &v
	return s
}

// SetErrorInfo sets the ErrorInfo field's value.
func (s *Ingestion) SetErrorInfo(v *ErrorInfo) *Ingestion {
	s.ErrorInfo = v
	return s
}

// SetIngestionId sets the IngestionId field's value.
func (s *Ingestion) SetIngestionId(v string) *Ingestion {
	s.IngestionId = &v
	return s
}

// SetIngestionSizeInBytes sets the IngestionSizeInBytes field's value.
func (s *Ingestion) SetIngestionSizeInBytes(v int64) *Ingestion {
	s.IngestionSizeInBytes = &v
	return s
}

// SetIngestionStatus sets the IngestionStatus field's value.
func (s *Ingestion) SetIngestionStatus(v string) *Ingestion {
	s.IngestionStatus = &v
	return s
}

// SetIngestionTimeInSeconds sets the IngestionTimeInSeconds field's value.
func (s *Ingestion) SetIngestionTimeInSeconds(v int64) *Ingestion {
	s.IngestionTimeInSeconds = &v
	return s
}

// SetQueueInfo sets the QueueInfo field's value.
func (s *Ingestion) SetQueueInfo(v *QueueInfo) *Ingestion {
	s.QueueInfo = v
	return s
}

// SetRequestSource sets the RequestSource field's value.
func (s *Ingestion) SetRequestSource(v string) *Ingestion {
	s.RequestSource = &v
	return s
}

// SetRequestType sets the RequestType field's value.
func (s *Ingestion) SetRequestType(v string) *Ingestion {
	s.RequestType = &v
	return s
}

// SetRowInfo sets the RowInfo field's value.
func (s *Ingestion) SetRowInfo(v *RowInfo) *Ingestion {
	s.RowInfo = v
	return s
}

// Metadata on a column that is used as the input of a transform operation.
type InputColumn struct {
	_ struct{} `type:"structure"`

	// The name of this column in the underlying data source.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The data type of the column.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"InputColumnDataType"`
}

// String returns the string representation
func (s InputColumn) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InputColumn) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InputColumn) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InputColumn"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *InputColumn) SetName(v string) *InputColumn {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *InputColumn) SetType(v string) *InputColumn {
	s.Type = &v
	return s
}

// Integer parameter.
type IntegerParameter struct {
	_ struct{} `type:"structure"`

	// A display name for the dataset.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// Values.
	//
	// Values is a required field
	Values []*int64 `type:"list" required:"true"`
}

// String returns the string representation
func (s IntegerParameter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IntegerParameter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IntegerParameter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "IntegerParameter"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *IntegerParameter) SetName(v string) *IntegerParameter {
	s.Name = &v
	return s
}

// SetValues sets the Values field's value.
func (s *IntegerParameter) SetValues(v []*int64) *IntegerParameter {
	s.Values = v
	return s
}

// Jira parameters.
type JiraParameters struct {
	_ struct{} `type:"structure"`

	// The base URL of the Jira site.
	//
	// SiteBaseUrl is a required field
	SiteBaseUrl *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s JiraParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s JiraParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *JiraParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "JiraParameters"}
	if s.SiteBaseUrl == nil {
		invalidParams.Add(request.NewErrParamRequired("SiteBaseUrl"))
	}
	if s.SiteBaseUrl != nil && len(*s.SiteBaseUrl) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SiteBaseUrl", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSiteBaseUrl sets the SiteBaseUrl field's value.
func (s *JiraParameters) SetSiteBaseUrl(v string) *JiraParameters {
	s.SiteBaseUrl = &v
	return s
}

// Join instruction.
type JoinInstruction struct {
	_ struct{} `type:"structure"`

	// Left operand.
	//
	// LeftOperand is a required field
	LeftOperand *string `min:"1" type:"string" required:"true"`

	// On Clause.
	//
	// OnClause is a required field
	OnClause *string `min:"1" type:"string" required:"true"`

	// Right operand.
	//
	// RightOperand is a required field
	RightOperand *string `min:"1" type:"string" required:"true"`

	// Type.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"JoinType"`
}

// String returns the string representation
func (s JoinInstruction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s JoinInstruction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *JoinInstruction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "JoinInstruction"}
	if s.LeftOperand == nil {
		invalidParams.Add(request.NewErrParamRequired("LeftOperand"))
	}
	if s.LeftOperand != nil && len(*s.LeftOperand) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LeftOperand", 1))
	}
	if s.OnClause == nil {
		invalidParams.Add(request.NewErrParamRequired("OnClause"))
	}
	if s.OnClause != nil && len(*s.OnClause) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OnClause", 1))
	}
	if s.RightOperand == nil {
		invalidParams.Add(request.NewErrParamRequired("RightOperand"))
	}
	if s.RightOperand != nil && len(*s.RightOperand) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RightOperand", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLeftOperand sets the LeftOperand field's value.
func (s *JoinInstruction) SetLeftOperand(v string) *JoinInstruction {
	s.LeftOperand = &v
	return s
}

// SetOnClause sets the OnClause field's value.
func (s *JoinInstruction) SetOnClause(v string) *JoinInstruction {
	s.OnClause = &v
	return s
}

// SetRightOperand sets the RightOperand field's value.
func (s *JoinInstruction) SetRightOperand(v string) *JoinInstruction {
	s.RightOperand = &v
	return s
}

// SetType sets the Type field's value.
func (s *JoinInstruction) SetType(v string) *JoinInstruction {
	s.Type = &v
	return s
}

type ListDashboardVersionsInput struct {
	_ struct{} `type:"structure"`

	// AWS account ID that contains the dashboard you are listing.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The ID for the dashboard.
	//
	// DashboardId is a required field
	DashboardId *string `location:"uri" locationName:"DashboardId" min:"1" type:"string" required:"true"`

	// The maximum number of results to be returned per request.
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// The token for the next set of results, or null if there are no more results.
	NextToken *string `location:"querystring" locationName:"next-token" type:"string"`
}

// String returns the string representation
func (s ListDashboardVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDashboardVersionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDashboardVersionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDashboardVersionsInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.DashboardId == nil {
		invalidParams.Add(request.NewErrParamRequired("DashboardId"))
	}
	if s.DashboardId != nil && len(*s.DashboardId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DashboardId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *ListDashboardVersionsInput) SetAwsAccountId(v string) *ListDashboardVersionsInput {
	s.AwsAccountId = &v
	return s
}

// SetDashboardId sets the DashboardId field's value.
func (s *ListDashboardVersionsInput) SetDashboardId(v string) *ListDashboardVersionsInput {
	s.DashboardId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDashboardVersionsInput) SetMaxResults(v int64) *ListDashboardVersionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDashboardVersionsInput) SetNextToken(v string) *ListDashboardVersionsInput {
	s.NextToken = &v
	return s
}

type ListDashboardVersionsOutput struct {
	_ struct{} `type:"structure"`

	// A structure that contains information about each version of the dashboard.
	DashboardVersionSummaryList []*DashboardVersionSummary `type:"list"`

	// The token for the next set of results, or null if there are no more results.
	NextToken *string `type:"string"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation
func (s ListDashboardVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDashboardVersionsOutput) GoString() string {
	return s.String()
}

// SetDashboardVersionSummaryList sets the DashboardVersionSummaryList field's value.
func (s *ListDashboardVersionsOutput) SetDashboardVersionSummaryList(v []*DashboardVersionSummary) *ListDashboardVersionsOutput {
	s.DashboardVersionSummaryList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDashboardVersionsOutput) SetNextToken(v string) *ListDashboardVersionsOutput {
	s.NextToken = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *ListDashboardVersionsOutput) SetRequestId(v string) *ListDashboardVersionsOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListDashboardVersionsOutput) SetStatus(v int64) *ListDashboardVersionsOutput {
	s.Status = &v
	return s
}

type ListDashboardsInput struct {
	_ struct{} `type:"structure"`

	// AWS account ID that contains the dashboards you are listing.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The maximum number of results to be returned per request.
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// The token for the next set of results, or null if there are no more results.
	NextToken *string `location:"querystring" locationName:"next-token" type:"string"`
}

// String returns the string representation
func (s ListDashboardsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDashboardsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDashboardsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDashboardsInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *ListDashboardsInput) SetAwsAccountId(v string) *ListDashboardsInput {
	s.AwsAccountId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDashboardsInput) SetMaxResults(v int64) *ListDashboardsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDashboardsInput) SetNextToken(v string) *ListDashboardsInput {
	s.NextToken = &v
	return s
}

type ListDashboardsOutput struct {
	_ struct{} `type:"structure"`

	// A structure that contains all of the dashboards shared with the user. Provides
	// basic information about the dashboards.
	DashboardSummaryList []*DashboardSummary `type:"list"`

	// The token for the next set of results, or null if there are no more results.
	NextToken *string `type:"string"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation
func (s ListDashboardsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDashboardsOutput) GoString() string {
	return s.String()
}

// SetDashboardSummaryList sets the DashboardSummaryList field's value.
func (s *ListDashboardsOutput) SetDashboardSummaryList(v []*DashboardSummary) *ListDashboardsOutput {
	s.DashboardSummaryList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDashboardsOutput) SetNextToken(v string) *ListDashboardsOutput {
	s.NextToken = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *ListDashboardsOutput) SetRequestId(v string) *ListDashboardsOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListDashboardsOutput) SetStatus(v int64) *ListDashboardsOutput {
	s.Status = &v
	return s
}

type ListDataSetsInput struct {
	_ struct{} `type:"structure"`

	// The AWS Account ID.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The maximum number of results to be returned per request.
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// The token for the next set of results, or null if there are no more results.
	NextToken *string `location:"querystring" locationName:"next-token" type:"string"`
}

// String returns the string representation
func (s ListDataSetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDataSetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDataSetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDataSetsInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *ListDataSetsInput) SetAwsAccountId(v string) *ListDataSetsInput {
	s.AwsAccountId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDataSetsInput) SetMaxResults(v int64) *ListDataSetsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDataSetsInput) SetNextToken(v string) *ListDataSetsInput {
	s.NextToken = &v
	return s
}

type ListDataSetsOutput struct {
	_ struct{} `type:"structure"`

	// The list of dataset summaries.
	DataSetSummaries []*DataSetSummary `type:"list"`

	// The token for the next set of results, or null if there are no more results.
	NextToken *string `type:"string"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation
func (s ListDataSetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDataSetsOutput) GoString() string {
	return s.String()
}

// SetDataSetSummaries sets the DataSetSummaries field's value.
func (s *ListDataSetsOutput) SetDataSetSummaries(v []*DataSetSummary) *ListDataSetsOutput {
	s.DataSetSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDataSetsOutput) SetNextToken(v string) *ListDataSetsOutput {
	s.NextToken = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *ListDataSetsOutput) SetRequestId(v string) *ListDataSetsOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListDataSetsOutput) SetStatus(v int64) *ListDataSetsOutput {
	s.Status = &v
	return s
}

type ListDataSourcesInput struct {
	_ struct{} `type:"structure"`

	// The AWS account ID.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The maximum number of results to be returned per request.
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// The token for the next set of results, or null if there are no more results.
	NextToken *string `location:"querystring" locationName:"next-token" type:"string"`
}

// String returns the string representation
func (s ListDataSourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDataSourcesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDataSourcesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDataSourcesInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *ListDataSourcesInput) SetAwsAccountId(v string) *ListDataSourcesInput {
	s.AwsAccountId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDataSourcesInput) SetMaxResults(v int64) *ListDataSourcesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDataSourcesInput) SetNextToken(v string) *ListDataSourcesInput {
	s.NextToken = &v
	return s
}

type ListDataSourcesOutput struct {
	_ struct{} `type:"structure"`

	// A list of data sources.
	DataSources []*DataSource `type:"list"`

	// The token for the next set of results, or null if there are no more results.
	NextToken *string `type:"string"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation
func (s ListDataSourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDataSourcesOutput) GoString() string {
	return s.String()
}

// SetDataSources sets the DataSources field's value.
func (s *ListDataSourcesOutput) SetDataSources(v []*DataSource) *ListDataSourcesOutput {
	s.DataSources = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDataSourcesOutput) SetNextToken(v string) *ListDataSourcesOutput {
	s.NextToken = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *ListDataSourcesOutput) SetRequestId(v string) *ListDataSourcesOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListDataSourcesOutput) SetStatus(v int64) *ListDataSourcesOutput {
	s.Status = &v
	return s
}

type ListGroupMembershipsInput struct {
	_ struct{} `type:"structure"`

	// The ID for the AWS account that the group is in. Currently, you use the ID
	// for the AWS account that contains your Amazon QuickSight account.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The name of the group that you want to see a membership list of.
	//
	// GroupName is a required field
	GroupName *string `location:"uri" locationName:"GroupName" min:"1" type:"string" required:"true"`

	// The maximum number of results to return from this request.
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// The namespace. Currently, you should set this to default.
	//
	// Namespace is a required field
	Namespace *string `location:"uri" locationName:"Namespace" type:"string" required:"true"`

	// A pagination token that can be used in a subsequent request.
	NextToken *string `location:"querystring" locationName:"next-token" type:"string"`
}

// String returns the string representation
func (s ListGroupMembershipsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListGroupMembershipsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListGroupMembershipsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListGroupMembershipsInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.GroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupName"))
	}
	if s.GroupName != nil && len(*s.GroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Namespace == nil {
		invalidParams.Add(request.NewErrParamRequired("Namespace"))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *ListGroupMembershipsInput) SetAwsAccountId(v string) *ListGroupMembershipsInput {
	s.AwsAccountId = &v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *ListGroupMembershipsInput) SetGroupName(v string) *ListGroupMembershipsInput {
	s.GroupName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListGroupMembershipsInput) SetMaxResults(v int64) *ListGroupMembershipsInput {
	s.MaxResults = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *ListGroupMembershipsInput) SetNamespace(v string) *ListGroupMembershipsInput {
	s.Namespace = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListGroupMembershipsInput) SetNextToken(v string) *ListGroupMembershipsInput {
	s.NextToken = &v
	return s
}

type ListGroupMembershipsOutput struct {
	_ struct{} `type:"structure"`

	// The list of the members of the group.
	GroupMemberList []*GroupMember `type:"list"`

	// A pagination token that can be used in a subsequent request.
	NextToken *string `type:"string"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation
func (s ListGroupMembershipsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListGroupMembershipsOutput) GoString() string {
	return s.String()
}

// SetGroupMemberList sets the GroupMemberList field's value.
func (s *ListGroupMembershipsOutput) SetGroupMemberList(v []*GroupMember) *ListGroupMembershipsOutput {
	s.GroupMemberList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListGroupMembershipsOutput) SetNextToken(v string) *ListGroupMembershipsOutput {
	s.NextToken = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *ListGroupMembershipsOutput) SetRequestId(v string) *ListGroupMembershipsOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListGroupMembershipsOutput) SetStatus(v int64) *ListGroupMembershipsOutput {
	s.Status = &v
	return s
}

type ListGroupsInput struct {
	_ struct{} `type:"structure"`

	// The ID for the AWS account that the group is in. Currently, you use the ID
	// for the AWS account that contains your Amazon QuickSight account.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The maximum number of results to return.
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// The namespace. Currently, you should set this to default.
	//
	// Namespace is a required field
	Namespace *string `location:"uri" locationName:"Namespace" type:"string" required:"true"`

	// A pagination token that can be used in a subsequent request.
	NextToken *string `location:"querystring" locationName:"next-token" type:"string"`
}

// String returns the string representation
func (s ListGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListGroupsInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Namespace == nil {
		invalidParams.Add(request.NewErrParamRequired("Namespace"))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *ListGroupsInput) SetAwsAccountId(v string) *ListGroupsInput {
	s.AwsAccountId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListGroupsInput) SetMaxResults(v int64) *ListGroupsInput {
	s.MaxResults = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *ListGroupsInput) SetNamespace(v string) *ListGroupsInput {
	s.Namespace = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListGroupsInput) SetNextToken(v string) *ListGroupsInput {
	s.NextToken = &v
	return s
}

type ListGroupsOutput struct {
	_ struct{} `type:"structure"`

	// The list of the groups.
	GroupList []*Group `type:"list"`

	// A pagination token that can be used in a subsequent request.
	NextToken *string `type:"string"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation
func (s ListGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListGroupsOutput) GoString() string {
	return s.String()
}

// SetGroupList sets the GroupList field's value.
func (s *ListGroupsOutput) SetGroupList(v []*Group) *ListGroupsOutput {
	s.GroupList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListGroupsOutput) SetNextToken(v string) *ListGroupsOutput {
	s.NextToken = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *ListGroupsOutput) SetRequestId(v string) *ListGroupsOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListGroupsOutput) SetStatus(v int64) *ListGroupsOutput {
	s.Status = &v
	return s
}

type ListIAMPolicyAssignmentsForUserInput struct {
	_ struct{} `type:"structure"`

	// The AWS account ID that contains the assignment.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The maximum number of results to be returned per request.
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// The namespace of the assignment.
	//
	// Namespace is a required field
	Namespace *string `location:"uri" locationName:"Namespace" type:"string" required:"true"`

	// The token for the next set of results, or null if there are no more results.
	NextToken *string `location:"querystring" locationName:"next-token" type:"string"`

	// The name of the user.
	//
	// UserName is a required field
	UserName *string `location:"uri" locationName:"UserName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListIAMPolicyAssignmentsForUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListIAMPolicyAssignmentsForUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListIAMPolicyAssignmentsForUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListIAMPolicyAssignmentsForUserInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Namespace == nil {
		invalidParams.Add(request.NewErrParamRequired("Namespace"))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}
	if s.UserName == nil {
		invalidParams.Add(request.NewErrParamRequired("UserName"))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *ListIAMPolicyAssignmentsForUserInput) SetAwsAccountId(v string) *ListIAMPolicyAssignmentsForUserInput {
	s.AwsAccountId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListIAMPolicyAssignmentsForUserInput) SetMaxResults(v int64) *ListIAMPolicyAssignmentsForUserInput {
	s.MaxResults = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *ListIAMPolicyAssignmentsForUserInput) SetNamespace(v string) *ListIAMPolicyAssignmentsForUserInput {
	s.Namespace = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListIAMPolicyAssignmentsForUserInput) SetNextToken(v string) *ListIAMPolicyAssignmentsForUserInput {
	s.NextToken = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *ListIAMPolicyAssignmentsForUserInput) SetUserName(v string) *ListIAMPolicyAssignmentsForUserInput {
	s.UserName = &v
	return s
}

type ListIAMPolicyAssignmentsForUserOutput struct {
	_ struct{} `type:"structure"`

	// Active assignments for this user.
	ActiveAssignments []*ActiveIAMPolicyAssignment `type:"list"`

	// The token for the next set of results, or null if there are no more results.
	NextToken *string `type:"string"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation
func (s ListIAMPolicyAssignmentsForUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListIAMPolicyAssignmentsForUserOutput) GoString() string {
	return s.String()
}

// SetActiveAssignments sets the ActiveAssignments field's value.
func (s *ListIAMPolicyAssignmentsForUserOutput) SetActiveAssignments(v []*ActiveIAMPolicyAssignment) *ListIAMPolicyAssignmentsForUserOutput {
	s.ActiveAssignments = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListIAMPolicyAssignmentsForUserOutput) SetNextToken(v string) *ListIAMPolicyAssignmentsForUserOutput {
	s.NextToken = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *ListIAMPolicyAssignmentsForUserOutput) SetRequestId(v string) *ListIAMPolicyAssignmentsForUserOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListIAMPolicyAssignmentsForUserOutput) SetStatus(v int64) *ListIAMPolicyAssignmentsForUserOutput {
	s.Status = &v
	return s
}

type ListIAMPolicyAssignmentsInput struct {
	_ struct{} `type:"structure"`

	// The status of the assignment.
	AssignmentStatus *string `type:"string" enum:"AssignmentStatus"`

	// The AWS account ID that contains this IAM policy assignment.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The maximum number of results to be returned per request.
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// The namespace for this assignment.
	//
	// Namespace is a required field
	Namespace *string `location:"uri" locationName:"Namespace" type:"string" required:"true"`

	// The token for the next set of results, or null if there are no more results.
	NextToken *string `location:"querystring" locationName:"next-token" type:"string"`
}

// String returns the string representation
func (s ListIAMPolicyAssignmentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListIAMPolicyAssignmentsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListIAMPolicyAssignmentsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListIAMPolicyAssignmentsInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Namespace == nil {
		invalidParams.Add(request.NewErrParamRequired("Namespace"))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssignmentStatus sets the AssignmentStatus field's value.
func (s *ListIAMPolicyAssignmentsInput) SetAssignmentStatus(v string) *ListIAMPolicyAssignmentsInput {
	s.AssignmentStatus = &v
	return s
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *ListIAMPolicyAssignmentsInput) SetAwsAccountId(v string) *ListIAMPolicyAssignmentsInput {
	s.AwsAccountId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListIAMPolicyAssignmentsInput) SetMaxResults(v int64) *ListIAMPolicyAssignmentsInput {
	s.MaxResults = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *ListIAMPolicyAssignmentsInput) SetNamespace(v string) *ListIAMPolicyAssignmentsInput {
	s.Namespace = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListIAMPolicyAssignmentsInput) SetNextToken(v string) *ListIAMPolicyAssignmentsInput {
	s.NextToken = &v
	return s
}

type ListIAMPolicyAssignmentsOutput struct {
	_ struct{} `type:"structure"`

	// Information describing the IAM policy assignments.
	IAMPolicyAssignments []*IAMPolicyAssignmentSummary `type:"list"`

	// The token for the next set of results, or null if there are no more results.
	NextToken *string `type:"string"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation
func (s ListIAMPolicyAssignmentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListIAMPolicyAssignmentsOutput) GoString() string {
	return s.String()
}

// SetIAMPolicyAssignments sets the IAMPolicyAssignments field's value.
func (s *ListIAMPolicyAssignmentsOutput) SetIAMPolicyAssignments(v []*IAMPolicyAssignmentSummary) *ListIAMPolicyAssignmentsOutput {
	s.IAMPolicyAssignments = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListIAMPolicyAssignmentsOutput) SetNextToken(v string) *ListIAMPolicyAssignmentsOutput {
	s.NextToken = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *ListIAMPolicyAssignmentsOutput) SetRequestId(v string) *ListIAMPolicyAssignmentsOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListIAMPolicyAssignmentsOutput) SetStatus(v int64) *ListIAMPolicyAssignmentsOutput {
	s.Status = &v
	return s
}

type ListIngestionsInput struct {
	_ struct{} `type:"structure"`

	// The AWS account ID.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The ID of the dataset used in the ingestion.
	//
	// DataSetId is a required field
	DataSetId *string `location:"uri" locationName:"DataSetId" type:"string" required:"true"`

	// The maximum number of results to be returned per request.
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// The token for the next set of results, or null if there are no more results.
	NextToken *string `location:"querystring" locationName:"next-token" type:"string"`
}

// String returns the string representation
func (s ListIngestionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListIngestionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListIngestionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListIngestionsInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.DataSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSetId"))
	}
	if s.DataSetId != nil && len(*s.DataSetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataSetId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *ListIngestionsInput) SetAwsAccountId(v string) *ListIngestionsInput {
	s.AwsAccountId = &v
	return s
}

// SetDataSetId sets the DataSetId field's value.
func (s *ListIngestionsInput) SetDataSetId(v string) *ListIngestionsInput {
	s.DataSetId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListIngestionsInput) SetMaxResults(v int64) *ListIngestionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListIngestionsInput) SetNextToken(v string) *ListIngestionsInput {
	s.NextToken = &v
	return s
}

type ListIngestionsOutput struct {
	_ struct{} `type:"structure"`

	// A list of the ingestions.
	Ingestions []*Ingestion `type:"list"`

	// The token for the next set of results, or null if there are no more results.
	NextToken *string `type:"string"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation
func (s ListIngestionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListIngestionsOutput) GoString() string {
	return s.String()
}

// SetIngestions sets the Ingestions field's value.
func (s *ListIngestionsOutput) SetIngestions(v []*Ingestion) *ListIngestionsOutput {
	s.Ingestions = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListIngestionsOutput) SetNextToken(v string) *ListIngestionsOutput {
	s.NextToken = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *ListIngestionsOutput) SetRequestId(v string) *ListIngestionsOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListIngestionsOutput) SetStatus(v int64) *ListIngestionsOutput {
	s.Status = &v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource that you want a list of tags
	// for.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"ResourceArn" type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`

	// Contains a map of the key-value pairs for the resource tag or tags assigned
	// to the resource.
	Tags []*Tag `min:"1" type:"list"`
}

// String returns the string representation
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetRequestId sets the RequestId field's value.
func (s *ListTagsForResourceOutput) SetRequestId(v string) *ListTagsForResourceOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListTagsForResourceOutput) SetStatus(v int64) *ListTagsForResourceOutput {
	s.Status = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v []*Tag) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

type ListTemplateAliasesInput struct {
	_ struct{} `type:"structure"`

	// AWS account ID that contains the template aliases you are listing.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The maximum number of results to be returned per request.
	MaxResults *int64 `location:"querystring" locationName:"max-result" min:"1" type:"integer"`

	// The token for the next set of results, or null if there are no more results.
	NextToken *string `location:"querystring" locationName:"next-token" type:"string"`

	// The ID for the template.
	//
	// TemplateId is a required field
	TemplateId *string `location:"uri" locationName:"TemplateId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListTemplateAliasesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTemplateAliasesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTemplateAliasesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTemplateAliasesInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.TemplateId == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateId"))
	}
	if s.TemplateId != nil && len(*s.TemplateId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *ListTemplateAliasesInput) SetAwsAccountId(v string) *ListTemplateAliasesInput {
	s.AwsAccountId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTemplateAliasesInput) SetMaxResults(v int64) *ListTemplateAliasesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTemplateAliasesInput) SetNextToken(v string) *ListTemplateAliasesInput {
	s.NextToken = &v
	return s
}

// SetTemplateId sets the TemplateId field's value.
func (s *ListTemplateAliasesInput) SetTemplateId(v string) *ListTemplateAliasesInput {
	s.TemplateId = &v
	return s
}

type ListTemplateAliasesOutput struct {
	_ struct{} `type:"structure"`

	// The token for the next set of results, or null if there are no more results.
	NextToken *string `type:"string"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`

	// A structure containing the list of the template's aliases.
	TemplateAliasList []*TemplateAlias `type:"list"`
}

// String returns the string representation
func (s ListTemplateAliasesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTemplateAliasesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTemplateAliasesOutput) SetNextToken(v string) *ListTemplateAliasesOutput {
	s.NextToken = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *ListTemplateAliasesOutput) SetRequestId(v string) *ListTemplateAliasesOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListTemplateAliasesOutput) SetStatus(v int64) *ListTemplateAliasesOutput {
	s.Status = &v
	return s
}

// SetTemplateAliasList sets the TemplateAliasList field's value.
func (s *ListTemplateAliasesOutput) SetTemplateAliasList(v []*TemplateAlias) *ListTemplateAliasesOutput {
	s.TemplateAliasList = v
	return s
}

type ListTemplateVersionsInput struct {
	_ struct{} `type:"structure"`

	// AWS account ID that contains the templates you are listing.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The maximum number of results to be returned per request.
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// The token for the next set of results, or null if there are no more results.
	NextToken *string `location:"querystring" locationName:"next-token" type:"string"`

	// The ID for the template.
	//
	// TemplateId is a required field
	TemplateId *string `location:"uri" locationName:"TemplateId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListTemplateVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTemplateVersionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTemplateVersionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTemplateVersionsInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.TemplateId == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateId"))
	}
	if s.TemplateId != nil && len(*s.TemplateId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *ListTemplateVersionsInput) SetAwsAccountId(v string) *ListTemplateVersionsInput {
	s.AwsAccountId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTemplateVersionsInput) SetMaxResults(v int64) *ListTemplateVersionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTemplateVersionsInput) SetNextToken(v string) *ListTemplateVersionsInput {
	s.NextToken = &v
	return s
}

// SetTemplateId sets the TemplateId field's value.
func (s *ListTemplateVersionsInput) SetTemplateId(v string) *ListTemplateVersionsInput {
	s.TemplateId = &v
	return s
}

type ListTemplateVersionsOutput struct {
	_ struct{} `type:"structure"`

	// The token for the next set of results, or null if there are no more results.
	NextToken *string `type:"string"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`

	// A structure containing a list of all the versions of the specified template.
	TemplateVersionSummaryList []*TemplateVersionSummary `type:"list"`
}

// String returns the string representation
func (s ListTemplateVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTemplateVersionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTemplateVersionsOutput) SetNextToken(v string) *ListTemplateVersionsOutput {
	s.NextToken = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *ListTemplateVersionsOutput) SetRequestId(v string) *ListTemplateVersionsOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListTemplateVersionsOutput) SetStatus(v int64) *ListTemplateVersionsOutput {
	s.Status = &v
	return s
}

// SetTemplateVersionSummaryList sets the TemplateVersionSummaryList field's value.
func (s *ListTemplateVersionsOutput) SetTemplateVersionSummaryList(v []*TemplateVersionSummary) *ListTemplateVersionsOutput {
	s.TemplateVersionSummaryList = v
	return s
}

type ListTemplatesInput struct {
	_ struct{} `type:"structure"`

	// AWS account ID that contains the templates you are listing.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The maximum number of results to be returned per request.
	MaxResults *int64 `location:"querystring" locationName:"max-result" min:"1" type:"integer"`

	// The token for the next set of results, or null if there are no more results.
	NextToken *string `location:"querystring" locationName:"next-token" type:"string"`
}

// String returns the string representation
func (s ListTemplatesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTemplatesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTemplatesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTemplatesInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *ListTemplatesInput) SetAwsAccountId(v string) *ListTemplatesInput {
	s.AwsAccountId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTemplatesInput) SetMaxResults(v int64) *ListTemplatesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTemplatesInput) SetNextToken(v string) *ListTemplatesInput {
	s.NextToken = &v
	return s
}

type ListTemplatesOutput struct {
	_ struct{} `type:"structure"`

	// The token for the next set of results, or null if there are no more results.
	NextToken *string `type:"string"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`

	// A structure containing information about the templates in the list.
	TemplateSummaryList []*TemplateSummary `type:"list"`
}

// String returns the string representation
func (s ListTemplatesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTemplatesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTemplatesOutput) SetNextToken(v string) *ListTemplatesOutput {
	s.NextToken = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *ListTemplatesOutput) SetRequestId(v string) *ListTemplatesOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListTemplatesOutput) SetStatus(v int64) *ListTemplatesOutput {
	s.Status = &v
	return s
}

// SetTemplateSummaryList sets the TemplateSummaryList field's value.
func (s *ListTemplatesOutput) SetTemplateSummaryList(v []*TemplateSummary) *ListTemplatesOutput {
	s.TemplateSummaryList = v
	return s
}

type ListUserGroupsInput struct {
	_ struct{} `type:"structure"`

	// The AWS Account ID that the user is in. Currently, you use the ID for the
	// AWS account that contains your Amazon QuickSight account.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The maximum number of results to return from this request.
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// The namespace. Currently, you should set this to default.
	//
	// Namespace is a required field
	Namespace *string `location:"uri" locationName:"Namespace" type:"string" required:"true"`

	// A pagination token that can be used in a subsequent request.
	NextToken *string `location:"querystring" locationName:"next-token" type:"string"`

	// The Amazon QuickSight user name that you want to list group memberships for.
	//
	// UserName is a required field
	UserName *string `location:"uri" locationName:"UserName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListUserGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListUserGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListUserGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListUserGroupsInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Namespace == nil {
		invalidParams.Add(request.NewErrParamRequired("Namespace"))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}
	if s.UserName == nil {
		invalidParams.Add(request.NewErrParamRequired("UserName"))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *ListUserGroupsInput) SetAwsAccountId(v string) *ListUserGroupsInput {
	s.AwsAccountId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListUserGroupsInput) SetMaxResults(v int64) *ListUserGroupsInput {
	s.MaxResults = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *ListUserGroupsInput) SetNamespace(v string) *ListUserGroupsInput {
	s.Namespace = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListUserGroupsInput) SetNextToken(v string) *ListUserGroupsInput {
	s.NextToken = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *ListUserGroupsInput) SetUserName(v string) *ListUserGroupsInput {
	s.UserName = &v
	return s
}

type ListUserGroupsOutput struct {
	_ struct{} `type:"structure"`

	// The list of groups the user is a member of.
	GroupList []*Group `type:"list"`

	// A pagination token that can be used in a subsequent request.
	NextToken *string `type:"string"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation
func (s ListUserGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListUserGroupsOutput) GoString() string {
	return s.String()
}

// SetGroupList sets the GroupList field's value.
func (s *ListUserGroupsOutput) SetGroupList(v []*Group) *ListUserGroupsOutput {
	s.GroupList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListUserGroupsOutput) SetNextToken(v string) *ListUserGroupsOutput {
	s.NextToken = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *ListUserGroupsOutput) SetRequestId(v string) *ListUserGroupsOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListUserGroupsOutput) SetStatus(v int64) *ListUserGroupsOutput {
	s.Status = &v
	return s
}

type ListUsersInput struct {
	_ struct{} `type:"structure"`

	// The ID for the AWS account that the user is in. Currently, you use the ID
	// for the AWS account that contains your Amazon QuickSight account.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The maximum number of results to return from this request.
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// The namespace. Currently, you should set this to default.
	//
	// Namespace is a required field
	Namespace *string `location:"uri" locationName:"Namespace" type:"string" required:"true"`

	// A pagination token that can be used in a subsequent request.
	NextToken *string `location:"querystring" locationName:"next-token" type:"string"`
}

// String returns the string representation
func (s ListUsersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListUsersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListUsersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListUsersInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Namespace == nil {
		invalidParams.Add(request.NewErrParamRequired("Namespace"))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *ListUsersInput) SetAwsAccountId(v string) *ListUsersInput {
	s.AwsAccountId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListUsersInput) SetMaxResults(v int64) *ListUsersInput {
	s.MaxResults = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *ListUsersInput) SetNamespace(v string) *ListUsersInput {
	s.Namespace = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListUsersInput) SetNextToken(v string) *ListUsersInput {
	s.NextToken = &v
	return s
}

type ListUsersOutput struct {
	_ struct{} `type:"structure"`

	// A pagination token that can be used in a subsequent request.
	NextToken *string `type:"string"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`

	// The list of users.
	UserList []*User `type:"list"`
}

// String returns the string representation
func (s ListUsersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListUsersOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListUsersOutput) SetNextToken(v string) *ListUsersOutput {
	s.NextToken = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *ListUsersOutput) SetRequestId(v string) *ListUsersOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListUsersOutput) SetStatus(v int64) *ListUsersOutput {
	s.Status = &v
	return s
}

// SetUserList sets the UserList field's value.
func (s *ListUsersOutput) SetUserList(v []*User) *ListUsersOutput {
	s.UserList = v
	return s
}

// A unit that joins and data transformations operate on. A logical table has
// a source, which can be either a physical table or result of a join. When
// it points to a physical table, a logical table acts as a mutable copy of
// that table through transform operations.
type LogicalTable struct {
	_ struct{} `type:"structure"`

	// A display name for the logical table.
	//
	// Alias is a required field
	Alias *string `min:"1" type:"string" required:"true"`

	// Transform operations that act on this logical table.
	DataTransforms []*TransformOperation `min:"1" type:"list"`

	// Source of this logical table.
	//
	// Source is a required field
	Source *LogicalTableSource `type:"structure" required:"true"`
}

// String returns the string representation
func (s LogicalTable) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LogicalTable) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LogicalTable) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LogicalTable"}
	if s.Alias == nil {
		invalidParams.Add(request.NewErrParamRequired("Alias"))
	}
	if s.Alias != nil && len(*s.Alias) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Alias", 1))
	}
	if s.DataTransforms != nil && len(s.DataTransforms) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataTransforms", 1))
	}
	if s.Source == nil {
		invalidParams.Add(request.NewErrParamRequired("Source"))
	}
	if s.DataTransforms != nil {
		for i, v := range s.DataTransforms {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DataTransforms", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Source != nil {
		if err := s.Source.Validate(); err != nil {
			invalidParams.AddNested("Source", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlias sets the Alias field's value.
func (s *LogicalTable) SetAlias(v string) *LogicalTable {
	s.Alias = &v
	return s
}

// SetDataTransforms sets the DataTransforms field's value.
func (s *LogicalTable) SetDataTransforms(v []*TransformOperation) *LogicalTable {
	s.DataTransforms = v
	return s
}

// SetSource sets the Source field's value.
func (s *LogicalTable) SetSource(v *LogicalTableSource) *LogicalTable {
	s.Source = v
	return s
}

// Information on the source of a logical table. This is a variant type structure.
// No more than one of the attributes should be non-null for this structure
// to be valid.
type LogicalTableSource struct {
	_ struct{} `type:"structure"`

	// Specifies the result of a join of two logical tables.
	JoinInstruction *JoinInstruction `type:"structure"`

	// Physical table ID.
	PhysicalTableId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s LogicalTableSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LogicalTableSource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LogicalTableSource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LogicalTableSource"}
	if s.PhysicalTableId != nil && len(*s.PhysicalTableId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PhysicalTableId", 1))
	}
	if s.JoinInstruction != nil {
		if err := s.JoinInstruction.Validate(); err != nil {
			invalidParams.AddNested("JoinInstruction", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJoinInstruction sets the JoinInstruction field's value.
func (s *LogicalTableSource) SetJoinInstruction(v *JoinInstruction) *LogicalTableSource {
	s.JoinInstruction = v
	return s
}

// SetPhysicalTableId sets the PhysicalTableId field's value.
func (s *LogicalTableSource) SetPhysicalTableId(v string) *LogicalTableSource {
	s.PhysicalTableId = &v
	return s
}

// Amazon S3 manifest file location.
type ManifestFileLocation struct {
	_ struct{} `type:"structure"`

	// Amazon S3 bucket.
	//
	// Bucket is a required field
	Bucket *string `min:"1" type:"string" required:"true"`

	// Amazon S3 key that identifies an object.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ManifestFileLocation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ManifestFileLocation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ManifestFileLocation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ManifestFileLocation"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *ManifestFileLocation) SetBucket(v string) *ManifestFileLocation {
	s.Bucket = &v
	return s
}

// SetKey sets the Key field's value.
func (s *ManifestFileLocation) SetKey(v string) *ManifestFileLocation {
	s.Key = &v
	return s
}

// MariaDB parameters.
type MariaDbParameters struct {
	_ struct{} `type:"structure"`

	// Database.
	//
	// Database is a required field
	Database *string `min:"1" type:"string" required:"true"`

	// Host.
	//
	// Host is a required field
	Host *string `min:"1" type:"string" required:"true"`

	// Port.
	//
	// Port is a required field
	Port *int64 `min:"1" type:"integer" required:"true"`
}

// String returns the string representation
func (s MariaDbParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MariaDbParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MariaDbParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MariaDbParameters"}
	if s.Database == nil {
		invalidParams.Add(request.NewErrParamRequired("Database"))
	}
	if s.Database != nil && len(*s.Database) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Database", 1))
	}
	if s.Host == nil {
		invalidParams.Add(request.NewErrParamRequired("Host"))
	}
	if s.Host != nil && len(*s.Host) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Host", 1))
	}
	if s.Port == nil {
		invalidParams.Add(request.NewErrParamRequired("Port"))
	}
	if s.Port != nil && *s.Port < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Port", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatabase sets the Database field's value.
func (s *MariaDbParameters) SetDatabase(v string) *MariaDbParameters {
	s.Database = &v
	return s
}

// SetHost sets the Host field's value.
func (s *MariaDbParameters) SetHost(v string) *MariaDbParameters {
	s.Host = &v
	return s
}

// SetPort sets the Port field's value.
func (s *MariaDbParameters) SetPort(v int64) *MariaDbParameters {
	s.Port = &v
	return s
}

// MySQL parameters.
type MySqlParameters struct {
	_ struct{} `type:"structure"`

	// Database.
	//
	// Database is a required field
	Database *string `min:"1" type:"string" required:"true"`

	// Host.
	//
	// Host is a required field
	Host *string `min:"1" type:"string" required:"true"`

	// Port.
	//
	// Port is a required field
	Port *int64 `min:"1" type:"integer" required:"true"`
}

// String returns the string representation
func (s MySqlParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MySqlParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MySqlParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MySqlParameters"}
	if s.Database == nil {
		invalidParams.Add(request.NewErrParamRequired("Database"))
	}
	if s.Database != nil && len(*s.Database) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Database", 1))
	}
	if s.Host == nil {
		invalidParams.Add(request.NewErrParamRequired("Host"))
	}
	if s.Host != nil && len(*s.Host) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Host", 1))
	}
	if s.Port == nil {
		invalidParams.Add(request.NewErrParamRequired("Port"))
	}
	if s.Port != nil && *s.Port < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Port", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatabase sets the Database field's value.
func (s *MySqlParameters) SetDatabase(v string) *MySqlParameters {
	s.Database = &v
	return s
}

// SetHost sets the Host field's value.
func (s *MySqlParameters) SetHost(v string) *MySqlParameters {
	s.Host = &v
	return s
}

// SetPort sets the Port field's value.
func (s *MySqlParameters) SetPort(v int64) *MySqlParameters {
	s.Port = &v
	return s
}

// Output column.
type OutputColumn struct {
	_ struct{} `type:"structure"`

	// A display name for the dataset.
	Name *string `min:"1" type:"string"`

	// Type.
	Type *string `type:"string" enum:"ColumnDataType"`
}

// String returns the string representation
func (s OutputColumn) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OutputColumn) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *OutputColumn) SetName(v string) *OutputColumn {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *OutputColumn) SetType(v string) *OutputColumn {
	s.Type = &v
	return s
}

// Parameters.
type Parameters struct {
	_ struct{} `type:"structure"`

	// DateTime parameters.
	DateTimeParameters []*DateTimeParameter `type:"list"`

	// Decimal parameters.
	DecimalParameters []*DecimalParameter `type:"list"`

	// Integer parameters.
	IntegerParameters []*IntegerParameter `type:"list"`

	// String parameters.
	StringParameters []*StringParameter `type:"list"`
}

// String returns the string representation
func (s Parameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Parameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Parameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Parameters"}
	if s.DateTimeParameters != nil {
		for i, v := range s.DateTimeParameters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DateTimeParameters", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.DecimalParameters != nil {
		for i, v := range s.DecimalParameters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DecimalParameters", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.IntegerParameters != nil {
		for i, v := range s.IntegerParameters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "IntegerParameters", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.StringParameters != nil {
		for i, v := range s.StringParameters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "StringParameters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDateTimeParameters sets the DateTimeParameters field's value.
func (s *Parameters) SetDateTimeParameters(v []*DateTimeParameter) *Parameters {
	s.DateTimeParameters = v
	return s
}

// SetDecimalParameters sets the DecimalParameters field's value.
func (s *Parameters) SetDecimalParameters(v []*DecimalParameter) *Parameters {
	s.DecimalParameters = v
	return s
}

// SetIntegerParameters sets the IntegerParameters field's value.
func (s *Parameters) SetIntegerParameters(v []*IntegerParameter) *Parameters {
	s.IntegerParameters = v
	return s
}

// SetStringParameters sets the StringParameters field's value.
func (s *Parameters) SetStringParameters(v []*StringParameter) *Parameters {
	s.StringParameters = v
	return s
}

// A view of a data source. Contains information on the shape of the data in
// the underlying source. This is a variant type structure. No more than one
// of the attributes can be non-null for this structure to be valid.
type PhysicalTable struct {
	_ struct{} `type:"structure"`

	// A physical table type built from the results of the custom SQL query.
	CustomSql *CustomSql `type:"structure"`

	// A physical table type for relational data sources.
	RelationalTable *RelationalTable `type:"structure"`

	// A physical table type for as S3 data source.
	S3Source *S3Source `type:"structure"`
}

// String returns the string representation
func (s PhysicalTable) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PhysicalTable) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PhysicalTable) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PhysicalTable"}
	if s.CustomSql != nil {
		if err := s.CustomSql.Validate(); err != nil {
			invalidParams.AddNested("CustomSql", err.(request.ErrInvalidParams))
		}
	}
	if s.RelationalTable != nil {
		if err := s.RelationalTable.Validate(); err != nil {
			invalidParams.AddNested("RelationalTable", err.(request.ErrInvalidParams))
		}
	}
	if s.S3Source != nil {
		if err := s.S3Source.Validate(); err != nil {
			invalidParams.AddNested("S3Source", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCustomSql sets the CustomSql field's value.
func (s *PhysicalTable) SetCustomSql(v *CustomSql) *PhysicalTable {
	s.CustomSql = v
	return s
}

// SetRelationalTable sets the RelationalTable field's value.
func (s *PhysicalTable) SetRelationalTable(v *RelationalTable) *PhysicalTable {
	s.RelationalTable = v
	return s
}

// SetS3Source sets the S3Source field's value.
func (s *PhysicalTable) SetS3Source(v *S3Source) *PhysicalTable {
	s.S3Source = v
	return s
}

// PostgreSQL parameters.
type PostgreSqlParameters struct {
	_ struct{} `type:"structure"`

	// Database.
	//
	// Database is a required field
	Database *string `min:"1" type:"string" required:"true"`

	// Host.
	//
	// Host is a required field
	Host *string `min:"1" type:"string" required:"true"`

	// Port.
	//
	// Port is a required field
	Port *int64 `min:"1" type:"integer" required:"true"`
}

// String returns the string representation
func (s PostgreSqlParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PostgreSqlParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PostgreSqlParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PostgreSqlParameters"}
	if s.Database == nil {
		invalidParams.Add(request.NewErrParamRequired("Database"))
	}
	if s.Database != nil && len(*s.Database) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Database", 1))
	}
	if s.Host == nil {
		invalidParams.Add(request.NewErrParamRequired("Host"))
	}
	if s.Host != nil && len(*s.Host) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Host", 1))
	}
	if s.Port == nil {
		invalidParams.Add(request.NewErrParamRequired("Port"))
	}
	if s.Port != nil && *s.Port < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Port", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatabase sets the Database field's value.
func (s *PostgreSqlParameters) SetDatabase(v string) *PostgreSqlParameters {
	s.Database = &v
	return s
}

// SetHost sets the Host field's value.
func (s *PostgreSqlParameters) SetHost(v string) *PostgreSqlParameters {
	s.Host = &v
	return s
}

// SetPort sets the Port field's value.
func (s *PostgreSqlParameters) SetPort(v int64) *PostgreSqlParameters {
	s.Port = &v
	return s
}

// Presto parameters.
type PrestoParameters struct {
	_ struct{} `type:"structure"`

	// Catalog.
	//
	// Catalog is a required field
	Catalog *string `type:"string" required:"true"`

	// Host.
	//
	// Host is a required field
	Host *string `min:"1" type:"string" required:"true"`

	// Port.
	//
	// Port is a required field
	Port *int64 `min:"1" type:"integer" required:"true"`
}

// String returns the string representation
func (s PrestoParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PrestoParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PrestoParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PrestoParameters"}
	if s.Catalog == nil {
		invalidParams.Add(request.NewErrParamRequired("Catalog"))
	}
	if s.Host == nil {
		invalidParams.Add(request.NewErrParamRequired("Host"))
	}
	if s.Host != nil && len(*s.Host) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Host", 1))
	}
	if s.Port == nil {
		invalidParams.Add(request.NewErrParamRequired("Port"))
	}
	if s.Port != nil && *s.Port < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Port", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalog sets the Catalog field's value.
func (s *PrestoParameters) SetCatalog(v string) *PrestoParameters {
	s.Catalog = &v
	return s
}

// SetHost sets the Host field's value.
func (s *PrestoParameters) SetHost(v string) *PrestoParameters {
	s.Host = &v
	return s
}

// SetPort sets the Port field's value.
func (s *PrestoParameters) SetPort(v int64) *PrestoParameters {
	s.Port = &v
	return s
}

// A transform operation that projects columns. Operations that come after a
// projection can only refer to projected columns.
type ProjectOperation struct {
	_ struct{} `type:"structure"`

	// Projected columns.
	//
	// ProjectedColumns is a required field
	ProjectedColumns []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s ProjectOperation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ProjectOperation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ProjectOperation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ProjectOperation"}
	if s.ProjectedColumns == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectedColumns"))
	}
	if s.ProjectedColumns != nil && len(s.ProjectedColumns) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectedColumns", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetProjectedColumns sets the ProjectedColumns field's value.
func (s *ProjectOperation) SetProjectedColumns(v []*string) *ProjectOperation {
	s.ProjectedColumns = v
	return s
}

// Information on queued dataset SPICE ingestion.
type QueueInfo struct {
	_ struct{} `type:"structure"`

	// The ID of the ongoing ingestion. The queued ingestion is waiting for the
	// ongoing ingestion to complete.
	//
	// QueuedIngestion is a required field
	QueuedIngestion *string `type:"string" required:"true"`

	// The ID of the queued ingestion.
	//
	// WaitingOnIngestion is a required field
	WaitingOnIngestion *string `type:"string" required:"true"`
}

// String returns the string representation
func (s QueueInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s QueueInfo) GoString() string {
	return s.String()
}

// SetQueuedIngestion sets the QueuedIngestion field's value.
func (s *QueueInfo) SetQueuedIngestion(v string) *QueueInfo {
	s.QueuedIngestion = &v
	return s
}

// SetWaitingOnIngestion sets the WaitingOnIngestion field's value.
func (s *QueueInfo) SetWaitingOnIngestion(v string) *QueueInfo {
	s.WaitingOnIngestion = &v
	return s
}

// RDS parameters.
type RdsParameters struct {
	_ struct{} `type:"structure"`

	// Database.
	//
	// Database is a required field
	Database *string `min:"1" type:"string" required:"true"`

	// Instance ID.
	//
	// InstanceId is a required field
	InstanceId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RdsParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RdsParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RdsParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RdsParameters"}
	if s.Database == nil {
		invalidParams.Add(request.NewErrParamRequired("Database"))
	}
	if s.Database != nil && len(*s.Database) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Database", 1))
	}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatabase sets the Database field's value.
func (s *RdsParameters) SetDatabase(v string) *RdsParameters {
	s.Database = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *RdsParameters) SetInstanceId(v string) *RdsParameters {
	s.InstanceId = &v
	return s
}

// Redshift parameters. The ClusterId field can be blank if Host and Port are
// both set, and the other way around.
type RedshiftParameters struct {
	_ struct{} `type:"structure"`

	// Cluster ID. This can be blank if the Host and Port are provided.
	ClusterId *string `min:"1" type:"string"`

	// Database.
	//
	// Database is a required field
	Database *string `min:"1" type:"string" required:"true"`

	// Host. This can be blank if the ClusterId is provided.
	Host *string `min:"1" type:"string"`

	// Port. This can be blank if the ClusterId is provided.
	Port *int64 `type:"integer"`
}

// String returns the string representation
func (s RedshiftParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RedshiftParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RedshiftParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RedshiftParameters"}
	if s.ClusterId != nil && len(*s.ClusterId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterId", 1))
	}
	if s.Database == nil {
		invalidParams.Add(request.NewErrParamRequired("Database"))
	}
	if s.Database != nil && len(*s.Database) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Database", 1))
	}
	if s.Host != nil && len(*s.Host) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Host", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterId sets the ClusterId field's value.
func (s *RedshiftParameters) SetClusterId(v string) *RedshiftParameters {
	s.ClusterId = &v
	return s
}

// SetDatabase sets the Database field's value.
func (s *RedshiftParameters) SetDatabase(v string) *RedshiftParameters {
	s.Database = &v
	return s
}

// SetHost sets the Host field's value.
func (s *RedshiftParameters) SetHost(v string) *RedshiftParameters {
	s.Host = &v
	return s
}

// SetPort sets the Port field's value.
func (s *RedshiftParameters) SetPort(v int64) *RedshiftParameters {
	s.Port = &v
	return s
}

type RegisterUserInput struct {
	_ struct{} `type:"structure"`

	// The ID for the AWS account that the user is in. Currently, you use the ID
	// for the AWS account that contains your Amazon QuickSight account.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The email address of the user that you want to register.
	//
	// Email is a required field
	Email *string `type:"string" required:"true"`

	// The ARN of the IAM user or role that you are registering with Amazon QuickSight.
	IamArn *string `type:"string"`

	// Amazon QuickSight supports several ways of managing the identity of users.
	// This parameter accepts two values:
	//
	//    * IAM: A user whose identity maps to an existing IAM user or role.
	//
	//    * QUICKSIGHT: A user whose identity is owned and managed internally by
	//    Amazon QuickSight.
	//
	// IdentityType is a required field
	IdentityType *string `type:"string" required:"true" enum:"IdentityType"`

	// The namespace. Currently, you should set this to default.
	//
	// Namespace is a required field
	Namespace *string `location:"uri" locationName:"Namespace" type:"string" required:"true"`

	// You need to use this parameter only when you register one or more users using
	// an assumed IAM role. You don't need to provide the session name for other
	// scenarios, for example when you are registering an IAM user or an Amazon
	// QuickSight user. You can register multiple users using the same IAM role
	// if each user has a different session name. For more information on assuming
	// IAM roles, see assume-role (https://docs.aws.example.com/cli/latest/reference/sts/assume-role.html)
	// in the AWS CLI Reference.
	SessionName *string `min:"2" type:"string"`

	// The Amazon QuickSight user name that you want to create for the user you
	// are registering.
	UserName *string `min:"1" type:"string"`

	// The Amazon QuickSight role for the user. The user role can be one of the
	// following:
	//
	//    * READER: A user who has read-only access to dashboards.
	//
	//    * AUTHOR: A user who can create data sources, datasets, analyses, and
	//    dashboards.
	//
	//    * ADMIN: A user who is an author, who can also manage Amazon QuickSight
	//    settings.
	//
	//    * RESTRICTED_READER: This role isn't currently available for use.
	//
	//    * RESTRICTED_AUTHOR: This role isn't currently available for use.
	//
	// UserRole is a required field
	UserRole *string `type:"string" required:"true" enum:"UserRole"`
}

// String returns the string representation
func (s RegisterUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegisterUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RegisterUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RegisterUserInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.Email == nil {
		invalidParams.Add(request.NewErrParamRequired("Email"))
	}
	if s.IdentityType == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityType"))
	}
	if s.Namespace == nil {
		invalidParams.Add(request.NewErrParamRequired("Namespace"))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}
	if s.SessionName != nil && len(*s.SessionName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("SessionName", 2))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserName", 1))
	}
	if s.UserRole == nil {
		invalidParams.Add(request.NewErrParamRequired("UserRole"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *RegisterUserInput) SetAwsAccountId(v string) *RegisterUserInput {
	s.AwsAccountId = &v
	return s
}

// SetEmail sets the Email field's value.
func (s *RegisterUserInput) SetEmail(v string) *RegisterUserInput {
	s.Email = &v
	return s
}

// SetIamArn sets the IamArn field's value.
func (s *RegisterUserInput) SetIamArn(v string) *RegisterUserInput {
	s.IamArn = &v
	return s
}

// SetIdentityType sets the IdentityType field's value.
func (s *RegisterUserInput) SetIdentityType(v string) *RegisterUserInput {
	s.IdentityType = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *RegisterUserInput) SetNamespace(v string) *RegisterUserInput {
	s.Namespace = &v
	return s
}

// SetSessionName sets the SessionName field's value.
func (s *RegisterUserInput) SetSessionName(v string) *RegisterUserInput {
	s.SessionName = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *RegisterUserInput) SetUserName(v string) *RegisterUserInput {
	s.UserName = &v
	return s
}

// SetUserRole sets the UserRole field's value.
func (s *RegisterUserInput) SetUserRole(v string) *RegisterUserInput {
	s.UserRole = &v
	return s
}

type RegisterUserOutput struct {
	_ struct{} `type:"structure"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`

	// The user name.
	User *User `type:"structure"`

	// The URL the user visits to complete registration and provide a password.
	// This is returned only for users with an identity type of QUICKSIGHT.
	UserInvitationUrl *string `type:"string"`
}

// String returns the string representation
func (s RegisterUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegisterUserOutput) GoString() string {
	return s.String()
}

// SetRequestId sets the RequestId field's value.
func (s *RegisterUserOutput) SetRequestId(v string) *RegisterUserOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *RegisterUserOutput) SetStatus(v int64) *RegisterUserOutput {
	s.Status = &v
	return s
}

// SetUser sets the User field's value.
func (s *RegisterUserOutput) SetUser(v *User) *RegisterUserOutput {
	s.User = v
	return s
}

// SetUserInvitationUrl sets the UserInvitationUrl field's value.
func (s *RegisterUserOutput) SetUserInvitationUrl(v string) *RegisterUserOutput {
	s.UserInvitationUrl = &v
	return s
}

// A physical table type for relational data sources.
type RelationalTable struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the data source.
	//
	// DataSourceArn is a required field
	DataSourceArn *string `type:"string" required:"true"`

	// The column schema of the table.
	//
	// InputColumns is a required field
	InputColumns []*InputColumn `min:"1" type:"list" required:"true"`

	// Name of the relational table.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The schema name. Applies to certain relational database engines.
	Schema *string `type:"string"`
}

// String returns the string representation
func (s RelationalTable) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RelationalTable) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RelationalTable) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RelationalTable"}
	if s.DataSourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSourceArn"))
	}
	if s.InputColumns == nil {
		invalidParams.Add(request.NewErrParamRequired("InputColumns"))
	}
	if s.InputColumns != nil && len(s.InputColumns) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InputColumns", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.InputColumns != nil {
		for i, v := range s.InputColumns {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "InputColumns", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataSourceArn sets the DataSourceArn field's value.
func (s *RelationalTable) SetDataSourceArn(v string) *RelationalTable {
	s.DataSourceArn = &v
	return s
}

// SetInputColumns sets the InputColumns field's value.
func (s *RelationalTable) SetInputColumns(v []*InputColumn) *RelationalTable {
	s.InputColumns = v
	return s
}

// SetName sets the Name field's value.
func (s *RelationalTable) SetName(v string) *RelationalTable {
	s.Name = &v
	return s
}

// SetSchema sets the Schema field's value.
func (s *RelationalTable) SetSchema(v string) *RelationalTable {
	s.Schema = &v
	return s
}

// A transform operation that renames a column.
type RenameColumnOperation struct {
	_ struct{} `type:"structure"`

	// Name of the column to be renamed.
	//
	// ColumnName is a required field
	ColumnName *string `min:"1" type:"string" required:"true"`

	// New name for the column.
	//
	// NewColumnName is a required field
	NewColumnName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RenameColumnOperation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RenameColumnOperation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RenameColumnOperation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RenameColumnOperation"}
	if s.ColumnName == nil {
		invalidParams.Add(request.NewErrParamRequired("ColumnName"))
	}
	if s.ColumnName != nil && len(*s.ColumnName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ColumnName", 1))
	}
	if s.NewColumnName == nil {
		invalidParams.Add(request.NewErrParamRequired("NewColumnName"))
	}
	if s.NewColumnName != nil && len(*s.NewColumnName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NewColumnName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetColumnName sets the ColumnName field's value.
func (s *RenameColumnOperation) SetColumnName(v string) *RenameColumnOperation {
	s.ColumnName = &v
	return s
}

// SetNewColumnName sets the NewColumnName field's value.
func (s *RenameColumnOperation) SetNewColumnName(v string) *RenameColumnOperation {
	s.NewColumnName = &v
	return s
}

// Permission for the resource.
type ResourcePermission struct {
	_ struct{} `type:"structure"`

	// The action to grant or revoke permissions on. For example, "quicksight:DescribeDashboard".
	//
	// Actions is a required field
	Actions []*string `min:"1" type:"list" required:"true"`

	// The Amazon Resource Name (ARN) of a QuickSight user or group, or an IAM ARN.
	// If you are using cross-account resource sharing, this is the IAM ARN of an
	// account root. Otherwise, it is the ARN of a QuickSight user or group. .
	//
	// Principal is a required field
	Principal *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ResourcePermission) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourcePermission) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResourcePermission) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResourcePermission"}
	if s.Actions == nil {
		invalidParams.Add(request.NewErrParamRequired("Actions"))
	}
	if s.Actions != nil && len(s.Actions) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Actions", 1))
	}
	if s.Principal == nil {
		invalidParams.Add(request.NewErrParamRequired("Principal"))
	}
	if s.Principal != nil && len(*s.Principal) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Principal", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActions sets the Actions field's value.
func (s *ResourcePermission) SetActions(v []*string) *ResourcePermission {
	s.Actions = v
	return s
}

// SetPrincipal sets the Principal field's value.
func (s *ResourcePermission) SetPrincipal(v string) *ResourcePermission {
	s.Principal = &v
	return s
}

// Information on rows during a data set SPICE ingestion.
type RowInfo struct {
	_ struct{} `type:"structure"`

	// The number of rows that were not ingested.
	RowsDropped *int64 `type:"long"`

	// The number of rows that were ingested.
	RowsIngested *int64 `type:"long"`
}

// String returns the string representation
func (s RowInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RowInfo) GoString() string {
	return s.String()
}

// SetRowsDropped sets the RowsDropped field's value.
func (s *RowInfo) SetRowsDropped(v int64) *RowInfo {
	s.RowsDropped = &v
	return s
}

// SetRowsIngested sets the RowsIngested field's value.
func (s *RowInfo) SetRowsIngested(v int64) *RowInfo {
	s.RowsIngested = &v
	return s
}

// Row-level security configuration on the dataset.
type RowLevelPermissionDataSet struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource name (ARN) of the permission dataset.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`

	// Permission policy.
	//
	// PermissionPolicy is a required field
	PermissionPolicy *string `type:"string" required:"true" enum:"RowLevelPermissionPolicy"`
}

// String returns the string representation
func (s RowLevelPermissionDataSet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RowLevelPermissionDataSet) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RowLevelPermissionDataSet) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RowLevelPermissionDataSet"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.PermissionPolicy == nil {
		invalidParams.Add(request.NewErrParamRequired("PermissionPolicy"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *RowLevelPermissionDataSet) SetArn(v string) *RowLevelPermissionDataSet {
	s.Arn = &v
	return s
}

// SetPermissionPolicy sets the PermissionPolicy field's value.
func (s *RowLevelPermissionDataSet) SetPermissionPolicy(v string) *RowLevelPermissionDataSet {
	s.PermissionPolicy = &v
	return s
}

// S3 parameters.
type S3Parameters struct {
	_ struct{} `type:"structure"`

	// Location of the Amazon S3 manifest file. This is NULL if the manifest file
	// was uploaded in the console.
	//
	// ManifestFileLocation is a required field
	ManifestFileLocation *ManifestFileLocation `type:"structure" required:"true"`
}

// String returns the string representation
func (s S3Parameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3Parameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3Parameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3Parameters"}
	if s.ManifestFileLocation == nil {
		invalidParams.Add(request.NewErrParamRequired("ManifestFileLocation"))
	}
	if s.ManifestFileLocation != nil {
		if err := s.ManifestFileLocation.Validate(); err != nil {
			invalidParams.AddNested("ManifestFileLocation", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetManifestFileLocation sets the ManifestFileLocation field's value.
func (s *S3Parameters) SetManifestFileLocation(v *ManifestFileLocation) *S3Parameters {
	s.ManifestFileLocation = v
	return s
}

// A physical table type for as S3 data source.
type S3Source struct {
	_ struct{} `type:"structure"`

	// Data source ARN.
	//
	// DataSourceArn is a required field
	DataSourceArn *string `type:"string" required:"true"`

	// A physical table type for as S3 data source.
	//
	// InputColumns is a required field
	InputColumns []*InputColumn `min:"1" type:"list" required:"true"`

	// Information on the S3 source file(s) format.
	UploadSettings *UploadSettings `type:"structure"`
}

// String returns the string representation
func (s S3Source) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3Source) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3Source) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3Source"}
	if s.DataSourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSourceArn"))
	}
	if s.InputColumns == nil {
		invalidParams.Add(request.NewErrParamRequired("InputColumns"))
	}
	if s.InputColumns != nil && len(s.InputColumns) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InputColumns", 1))
	}
	if s.InputColumns != nil {
		for i, v := range s.InputColumns {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "InputColumns", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.UploadSettings != nil {
		if err := s.UploadSettings.Validate(); err != nil {
			invalidParams.AddNested("UploadSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataSourceArn sets the DataSourceArn field's value.
func (s *S3Source) SetDataSourceArn(v string) *S3Source {
	s.DataSourceArn = &v
	return s
}

// SetInputColumns sets the InputColumns field's value.
func (s *S3Source) SetInputColumns(v []*InputColumn) *S3Source {
	s.InputColumns = v
	return s
}

// SetUploadSettings sets the UploadSettings field's value.
func (s *S3Source) SetUploadSettings(v *UploadSettings) *S3Source {
	s.UploadSettings = v
	return s
}

// ServiceNow parameters.
type ServiceNowParameters struct {
	_ struct{} `type:"structure"`

	// URL of the base site.
	//
	// SiteBaseUrl is a required field
	SiteBaseUrl *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ServiceNowParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServiceNowParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ServiceNowParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ServiceNowParameters"}
	if s.SiteBaseUrl == nil {
		invalidParams.Add(request.NewErrParamRequired("SiteBaseUrl"))
	}
	if s.SiteBaseUrl != nil && len(*s.SiteBaseUrl) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SiteBaseUrl", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSiteBaseUrl sets the SiteBaseUrl field's value.
func (s *ServiceNowParameters) SetSiteBaseUrl(v string) *ServiceNowParameters {
	s.SiteBaseUrl = &v
	return s
}

// Sheet controls option.
type SheetControlsOption struct {
	_ struct{} `type:"structure"`

	// Visibility state.
	VisibilityState *string `type:"string" enum:"DashboardUIState"`
}

// String returns the string representation
func (s SheetControlsOption) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SheetControlsOption) GoString() string {
	return s.String()
}

// SetVisibilityState sets the VisibilityState field's value.
func (s *SheetControlsOption) SetVisibilityState(v string) *SheetControlsOption {
	s.VisibilityState = &v
	return s
}

// Snowflake parameters.
type SnowflakeParameters struct {
	_ struct{} `type:"structure"`

	// Database.
	//
	// Database is a required field
	Database *string `min:"1" type:"string" required:"true"`

	// Host.
	//
	// Host is a required field
	Host *string `min:"1" type:"string" required:"true"`

	// Warehouse.
	//
	// Warehouse is a required field
	Warehouse *string `type:"string" required:"true"`
}

// String returns the string representation
func (s SnowflakeParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SnowflakeParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SnowflakeParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SnowflakeParameters"}
	if s.Database == nil {
		invalidParams.Add(request.NewErrParamRequired("Database"))
	}
	if s.Database != nil && len(*s.Database) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Database", 1))
	}
	if s.Host == nil {
		invalidParams.Add(request.NewErrParamRequired("Host"))
	}
	if s.Host != nil && len(*s.Host) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Host", 1))
	}
	if s.Warehouse == nil {
		invalidParams.Add(request.NewErrParamRequired("Warehouse"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatabase sets the Database field's value.
func (s *SnowflakeParameters) SetDatabase(v string) *SnowflakeParameters {
	s.Database = &v
	return s
}

// SetHost sets the Host field's value.
func (s *SnowflakeParameters) SetHost(v string) *SnowflakeParameters {
	s.Host = &v
	return s
}

// SetWarehouse sets the Warehouse field's value.
func (s *SnowflakeParameters) SetWarehouse(v string) *SnowflakeParameters {
	s.Warehouse = &v
	return s
}

// Spark parameters.
type SparkParameters struct {
	_ struct{} `type:"structure"`

	// Host.
	//
	// Host is a required field
	Host *string `min:"1" type:"string" required:"true"`

	// Port.
	//
	// Port is a required field
	Port *int64 `min:"1" type:"integer" required:"true"`
}

// String returns the string representation
func (s SparkParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SparkParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SparkParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SparkParameters"}
	if s.Host == nil {
		invalidParams.Add(request.NewErrParamRequired("Host"))
	}
	if s.Host != nil && len(*s.Host) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Host", 1))
	}
	if s.Port == nil {
		invalidParams.Add(request.NewErrParamRequired("Port"))
	}
	if s.Port != nil && *s.Port < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Port", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHost sets the Host field's value.
func (s *SparkParameters) SetHost(v string) *SparkParameters {
	s.Host = &v
	return s
}

// SetPort sets the Port field's value.
func (s *SparkParameters) SetPort(v int64) *SparkParameters {
	s.Port = &v
	return s
}

// SQL Server parameters.
type SqlServerParameters struct {
	_ struct{} `type:"structure"`

	// Database.
	//
	// Database is a required field
	Database *string `min:"1" type:"string" required:"true"`

	// Host.
	//
	// Host is a required field
	Host *string `min:"1" type:"string" required:"true"`

	// Port.
	//
	// Port is a required field
	Port *int64 `min:"1" type:"integer" required:"true"`
}

// String returns the string representation
func (s SqlServerParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SqlServerParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SqlServerParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SqlServerParameters"}
	if s.Database == nil {
		invalidParams.Add(request.NewErrParamRequired("Database"))
	}
	if s.Database != nil && len(*s.Database) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Database", 1))
	}
	if s.Host == nil {
		invalidParams.Add(request.NewErrParamRequired("Host"))
	}
	if s.Host != nil && len(*s.Host) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Host", 1))
	}
	if s.Port == nil {
		invalidParams.Add(request.NewErrParamRequired("Port"))
	}
	if s.Port != nil && *s.Port < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Port", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatabase sets the Database field's value.
func (s *SqlServerParameters) SetDatabase(v string) *SqlServerParameters {
	s.Database = &v
	return s
}

// SetHost sets the Host field's value.
func (s *SqlServerParameters) SetHost(v string) *SqlServerParameters {
	s.Host = &v
	return s
}

// SetPort sets the Port field's value.
func (s *SqlServerParameters) SetPort(v int64) *SqlServerParameters {
	s.Port = &v
	return s
}

// Secure Socket Layer (SSL) properties that apply when QuickSight connects
// to your underlying data source.
type SslProperties struct {
	_ struct{} `type:"structure"`

	// A boolean flag to control whether SSL should be disabled.
	DisableSsl *bool `type:"boolean"`
}

// String returns the string representation
func (s SslProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SslProperties) GoString() string {
	return s.String()
}

// SetDisableSsl sets the DisableSsl field's value.
func (s *SslProperties) SetDisableSsl(v bool) *SslProperties {
	s.DisableSsl = &v
	return s
}

// String parameter.
type StringParameter struct {
	_ struct{} `type:"structure"`

	// A display name for the dataset.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// Values.
	//
	// Values is a required field
	Values []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s StringParameter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StringParameter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StringParameter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StringParameter"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *StringParameter) SetName(v string) *StringParameter {
	s.Name = &v
	return s
}

// SetValues sets the Values field's value.
func (s *StringParameter) SetValues(v []*string) *StringParameter {
	s.Values = v
	return s
}

// The keys of the key-value pairs for the resource tag or tags assigned to
// the resource.
type Tag struct {
	_ struct{} `type:"structure"`

	// Tag key.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// Tag value.
	//
	// Value is a required field
	Value *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

// A transform operation that tags a column with additional information.
type TagColumnOperation struct {
	_ struct{} `type:"structure"`

	// The column that this operation acts on.
	//
	// ColumnName is a required field
	ColumnName *string `min:"1" type:"string" required:"true"`

	// The dataset column tag, currently only used for geospatial type tagging. .
	//
	// This is not tags for the AWS tagging feature. .
	//
	// Tags is a required field
	Tags []*ColumnTag `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s TagColumnOperation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagColumnOperation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagColumnOperation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagColumnOperation"}
	if s.ColumnName == nil {
		invalidParams.Add(request.NewErrParamRequired("ColumnName"))
	}
	if s.ColumnName != nil && len(*s.ColumnName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ColumnName", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetColumnName sets the ColumnName field's value.
func (s *TagColumnOperation) SetColumnName(v string) *TagColumnOperation {
	s.ColumnName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagColumnOperation) SetTags(v []*ColumnTag) *TagColumnOperation {
	s.Tags = v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource that you want to tag.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"ResourceArn" type:"string" required:"true"`

	// Contains a map of the key-value pairs for the resource tag or tags assigned
	// to the resource.
	//
	// Tags is a required field
	Tags []*Tag `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// SetRequestId sets the RequestId field's value.
func (s *TagResourceOutput) SetRequestId(v string) *TagResourceOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *TagResourceOutput) SetStatus(v int64) *TagResourceOutput {
	s.Status = &v
	return s
}

// A template object. A template is an entity in QuickSight which encapsulates
// the metadata required to create an analysis that can be used to create dashboard.
// It adds a layer of abstraction by replacing the dataset associated with the
// analysis with placeholders. Templates can be used to create dashboards by
// replacing dataset placeholders with datasets which follow the same schema
// that was used to create the source analysis and template.
//
// You can share templates across AWS accounts by allowing users in other AWS
// accounts to create a template or a dashboard from an existing template.
type Template struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the template.
	Arn *string `type:"string"`

	// Time when this was created.
	CreatedTime *time.Time `type:"timestamp"`

	// Time when this was last updated.
	LastUpdatedTime *time.Time `type:"timestamp"`

	// The display name of the template.
	Name *string `min:"1" type:"string"`

	// The ID for the template. This is unique per AWS Region for each AWS account.
	TemplateId *string `min:"1" type:"string"`

	// A structure describing the versions of the template.
	Version *TemplateVersion `type:"structure"`
}

// String returns the string representation
func (s Template) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Template) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Template) SetArn(v string) *Template {
	s.Arn = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *Template) SetCreatedTime(v time.Time) *Template {
	s.CreatedTime = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *Template) SetLastUpdatedTime(v time.Time) *Template {
	s.LastUpdatedTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *Template) SetName(v string) *Template {
	s.Name = &v
	return s
}

// SetTemplateId sets the TemplateId field's value.
func (s *Template) SetTemplateId(v string) *Template {
	s.TemplateId = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *Template) SetVersion(v *TemplateVersion) *Template {
	s.Version = v
	return s
}

// The template alias.
type TemplateAlias struct {
	_ struct{} `type:"structure"`

	// The display name of the template alias.
	AliasName *string `min:"1" type:"string"`

	// The ARN of the template alias.
	Arn *string `type:"string"`

	// The version number of the template alias.
	TemplateVersionNumber *int64 `min:"1" type:"long"`
}

// String returns the string representation
func (s TemplateAlias) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TemplateAlias) GoString() string {
	return s.String()
}

// SetAliasName sets the AliasName field's value.
func (s *TemplateAlias) SetAliasName(v string) *TemplateAlias {
	s.AliasName = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *TemplateAlias) SetArn(v string) *TemplateAlias {
	s.Arn = &v
	return s
}

// SetTemplateVersionNumber sets the TemplateVersionNumber field's value.
func (s *TemplateAlias) SetTemplateVersionNumber(v int64) *TemplateAlias {
	s.TemplateVersionNumber = &v
	return s
}

// List of errors that occurred when the template version creation failed.
type TemplateError struct {
	_ struct{} `type:"structure"`

	// Description of the error type.
	Message *string `type:"string"`

	// Type of error.
	Type *string `type:"string" enum:"TemplateErrorType"`
}

// String returns the string representation
func (s TemplateError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TemplateError) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *TemplateError) SetMessage(v string) *TemplateError {
	s.Message = &v
	return s
}

// SetType sets the Type field's value.
func (s *TemplateError) SetType(v string) *TemplateError {
	s.Type = &v
	return s
}

// The source analysis of the template.
type TemplateSourceAnalysis struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource name (ARN) of the resource.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`

	// A structure containing information about the dataset references used as placeholders
	// in the template.
	//
	// DataSetReferences is a required field
	DataSetReferences []*DataSetReference `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s TemplateSourceAnalysis) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TemplateSourceAnalysis) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TemplateSourceAnalysis) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TemplateSourceAnalysis"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.DataSetReferences == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSetReferences"))
	}
	if s.DataSetReferences != nil && len(s.DataSetReferences) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataSetReferences", 1))
	}
	if s.DataSetReferences != nil {
		for i, v := range s.DataSetReferences {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DataSetReferences", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *TemplateSourceAnalysis) SetArn(v string) *TemplateSourceAnalysis {
	s.Arn = &v
	return s
}

// SetDataSetReferences sets the DataSetReferences field's value.
func (s *TemplateSourceAnalysis) SetDataSetReferences(v []*DataSetReference) *TemplateSourceAnalysis {
	s.DataSetReferences = v
	return s
}

// The source entity of the template.
type TemplateSourceEntity struct {
	_ struct{} `type:"structure"`

	// The source analysis, if it is based on an analysis.
	SourceAnalysis *TemplateSourceAnalysis `type:"structure"`

	// The source template, if it is based on an template.
	SourceTemplate *TemplateSourceTemplate `type:"structure"`
}

// String returns the string representation
func (s TemplateSourceEntity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TemplateSourceEntity) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TemplateSourceEntity) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TemplateSourceEntity"}
	if s.SourceAnalysis != nil {
		if err := s.SourceAnalysis.Validate(); err != nil {
			invalidParams.AddNested("SourceAnalysis", err.(request.ErrInvalidParams))
		}
	}
	if s.SourceTemplate != nil {
		if err := s.SourceTemplate.Validate(); err != nil {
			invalidParams.AddNested("SourceTemplate", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSourceAnalysis sets the SourceAnalysis field's value.
func (s *TemplateSourceEntity) SetSourceAnalysis(v *TemplateSourceAnalysis) *TemplateSourceEntity {
	s.SourceAnalysis = v
	return s
}

// SetSourceTemplate sets the SourceTemplate field's value.
func (s *TemplateSourceEntity) SetSourceTemplate(v *TemplateSourceTemplate) *TemplateSourceEntity {
	s.SourceTemplate = v
	return s
}

// The source template of the template.
type TemplateSourceTemplate struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource name (ARN) of the resource.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s TemplateSourceTemplate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TemplateSourceTemplate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TemplateSourceTemplate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TemplateSourceTemplate"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *TemplateSourceTemplate) SetArn(v string) *TemplateSourceTemplate {
	s.Arn = &v
	return s
}

// The template summary.
type TemplateSummary struct {
	_ struct{} `type:"structure"`

	// A summary of a template.
	Arn *string `type:"string"`

	// The last time this was created.
	CreatedTime *time.Time `type:"timestamp"`

	// The last time this was updated.
	LastUpdatedTime *time.Time `type:"timestamp"`

	// A structure containing a list of version numbers for the template summary.
	LatestVersionNumber *int64 `min:"1" type:"long"`

	// A display name for the template.
	Name *string `min:"1" type:"string"`

	// The ID of the template. This is unique per AWS Region for each AWS account.
	TemplateId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s TemplateSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TemplateSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *TemplateSummary) SetArn(v string) *TemplateSummary {
	s.Arn = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *TemplateSummary) SetCreatedTime(v time.Time) *TemplateSummary {
	s.CreatedTime = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *TemplateSummary) SetLastUpdatedTime(v time.Time) *TemplateSummary {
	s.LastUpdatedTime = &v
	return s
}

// SetLatestVersionNumber sets the LatestVersionNumber field's value.
func (s *TemplateSummary) SetLatestVersionNumber(v int64) *TemplateSummary {
	s.LatestVersionNumber = &v
	return s
}

// SetName sets the Name field's value.
func (s *TemplateSummary) SetName(v string) *TemplateSummary {
	s.Name = &v
	return s
}

// SetTemplateId sets the TemplateId field's value.
func (s *TemplateSummary) SetTemplateId(v string) *TemplateSummary {
	s.TemplateId = &v
	return s
}

// A version of a template.
type TemplateVersion struct {
	_ struct{} `type:"structure"`

	// The time this was created.
	CreatedTime *time.Time `type:"timestamp"`

	// Schema of the dataset identified by the placeholder. The idea is that any
	// dashboard created from the template should be bound to new datasets matching
	// the same schema described through this API. .
	DataSetConfigurations []*DataSetConfiguration `type:"list"`

	// The description of the template.
	Description *string `min:"1" type:"string"`

	// Errors associated with the template.
	Errors []*TemplateError `min:"1" type:"list"`

	// The Amazon Resource Name (ARN) of the analysis or template which was used
	// to create this template.
	SourceEntityArn *string `type:"string"`

	// The HTTP status of the request.
	Status *string `type:"string" enum:"ResourceStatus"`

	// The version number of the template.
	VersionNumber *int64 `min:"1" type:"long"`
}

// String returns the string representation
func (s TemplateVersion) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TemplateVersion) GoString() string {
	return s.String()
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *TemplateVersion) SetCreatedTime(v time.Time) *TemplateVersion {
	s.CreatedTime = &v
	return s
}

// SetDataSetConfigurations sets the DataSetConfigurations field's value.
func (s *TemplateVersion) SetDataSetConfigurations(v []*DataSetConfiguration) *TemplateVersion {
	s.DataSetConfigurations = v
	return s
}

// SetDescription sets the Description field's value.
func (s *TemplateVersion) SetDescription(v string) *TemplateVersion {
	s.Description = &v
	return s
}

// SetErrors sets the Errors field's value.
func (s *TemplateVersion) SetErrors(v []*TemplateError) *TemplateVersion {
	s.Errors = v
	return s
}

// SetSourceEntityArn sets the SourceEntityArn field's value.
func (s *TemplateVersion) SetSourceEntityArn(v string) *TemplateVersion {
	s.SourceEntityArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *TemplateVersion) SetStatus(v string) *TemplateVersion {
	s.Status = &v
	return s
}

// SetVersionNumber sets the VersionNumber field's value.
func (s *TemplateVersion) SetVersionNumber(v int64) *TemplateVersion {
	s.VersionNumber = &v
	return s
}

// The template version.
type TemplateVersionSummary struct {
	_ struct{} `type:"structure"`

	// The ARN of the template version.
	Arn *string `type:"string"`

	// The time this was created.
	CreatedTime *time.Time `type:"timestamp"`

	// The desription of the template version.
	Description *string `min:"1" type:"string"`

	// The status of the template version.
	Status *string `type:"string" enum:"ResourceStatus"`

	// The version number of the template version.
	VersionNumber *int64 `min:"1" type:"long"`
}

// String returns the string representation
func (s TemplateVersionSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TemplateVersionSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *TemplateVersionSummary) SetArn(v string) *TemplateVersionSummary {
	s.Arn = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *TemplateVersionSummary) SetCreatedTime(v time.Time) *TemplateVersionSummary {
	s.CreatedTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *TemplateVersionSummary) SetDescription(v string) *TemplateVersionSummary {
	s.Description = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *TemplateVersionSummary) SetStatus(v string) *TemplateVersionSummary {
	s.Status = &v
	return s
}

// SetVersionNumber sets the VersionNumber field's value.
func (s *TemplateVersionSummary) SetVersionNumber(v int64) *TemplateVersionSummary {
	s.VersionNumber = &v
	return s
}

// Teradata parameters.
type TeradataParameters struct {
	_ struct{} `type:"structure"`

	// Database.
	//
	// Database is a required field
	Database *string `min:"1" type:"string" required:"true"`

	// Host.
	//
	// Host is a required field
	Host *string `min:"1" type:"string" required:"true"`

	// Port.
	//
	// Port is a required field
	Port *int64 `min:"1" type:"integer" required:"true"`
}

// String returns the string representation
func (s TeradataParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TeradataParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TeradataParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TeradataParameters"}
	if s.Database == nil {
		invalidParams.Add(request.NewErrParamRequired("Database"))
	}
	if s.Database != nil && len(*s.Database) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Database", 1))
	}
	if s.Host == nil {
		invalidParams.Add(request.NewErrParamRequired("Host"))
	}
	if s.Host != nil && len(*s.Host) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Host", 1))
	}
	if s.Port == nil {
		invalidParams.Add(request.NewErrParamRequired("Port"))
	}
	if s.Port != nil && *s.Port < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Port", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatabase sets the Database field's value.
func (s *TeradataParameters) SetDatabase(v string) *TeradataParameters {
	s.Database = &v
	return s
}

// SetHost sets the Host field's value.
func (s *TeradataParameters) SetHost(v string) *TeradataParameters {
	s.Host = &v
	return s
}

// SetPort sets the Port field's value.
func (s *TeradataParameters) SetPort(v int64) *TeradataParameters {
	s.Port = &v
	return s
}

// A data transformation on a logical table. This is a variant type structure.
// No more than one of the attributes should be non-null for this structure
// to be valid.
type TransformOperation struct {
	_ struct{} `type:"structure"`

	// A transform operation that casts a column to a different type.
	CastColumnTypeOperation *CastColumnTypeOperation `type:"structure"`

	// An operation that creates calculated columns. Columns created in one such
	// operation form a lexical closure.
	CreateColumnsOperation *CreateColumnsOperation `type:"structure"`

	// An operation that filters rows based on some condition.
	FilterOperation *FilterOperation `type:"structure"`

	// An operation that projects columns. Operations that come after a projection
	// can only refer to projected columns.
	ProjectOperation *ProjectOperation `type:"structure"`

	// An operation that renames a column.
	RenameColumnOperation *RenameColumnOperation `type:"structure"`

	// An operation that tags a column with additional information.
	TagColumnOperation *TagColumnOperation `type:"structure"`
}

// String returns the string representation
func (s TransformOperation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TransformOperation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TransformOperation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TransformOperation"}
	if s.CastColumnTypeOperation != nil {
		if err := s.CastColumnTypeOperation.Validate(); err != nil {
			invalidParams.AddNested("CastColumnTypeOperation", err.(request.ErrInvalidParams))
		}
	}
	if s.CreateColumnsOperation != nil {
		if err := s.CreateColumnsOperation.Validate(); err != nil {
			invalidParams.AddNested("CreateColumnsOperation", err.(request.ErrInvalidParams))
		}
	}
	if s.FilterOperation != nil {
		if err := s.FilterOperation.Validate(); err != nil {
			invalidParams.AddNested("FilterOperation", err.(request.ErrInvalidParams))
		}
	}
	if s.ProjectOperation != nil {
		if err := s.ProjectOperation.Validate(); err != nil {
			invalidParams.AddNested("ProjectOperation", err.(request.ErrInvalidParams))
		}
	}
	if s.RenameColumnOperation != nil {
		if err := s.RenameColumnOperation.Validate(); err != nil {
			invalidParams.AddNested("RenameColumnOperation", err.(request.ErrInvalidParams))
		}
	}
	if s.TagColumnOperation != nil {
		if err := s.TagColumnOperation.Validate(); err != nil {
			invalidParams.AddNested("TagColumnOperation", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCastColumnTypeOperation sets the CastColumnTypeOperation field's value.
func (s *TransformOperation) SetCastColumnTypeOperation(v *CastColumnTypeOperation) *TransformOperation {
	s.CastColumnTypeOperation = v
	return s
}

// SetCreateColumnsOperation sets the CreateColumnsOperation field's value.
func (s *TransformOperation) SetCreateColumnsOperation(v *CreateColumnsOperation) *TransformOperation {
	s.CreateColumnsOperation = v
	return s
}

// SetFilterOperation sets the FilterOperation field's value.
func (s *TransformOperation) SetFilterOperation(v *FilterOperation) *TransformOperation {
	s.FilterOperation = v
	return s
}

// SetProjectOperation sets the ProjectOperation field's value.
func (s *TransformOperation) SetProjectOperation(v *ProjectOperation) *TransformOperation {
	s.ProjectOperation = v
	return s
}

// SetRenameColumnOperation sets the RenameColumnOperation field's value.
func (s *TransformOperation) SetRenameColumnOperation(v *RenameColumnOperation) *TransformOperation {
	s.RenameColumnOperation = v
	return s
}

// SetTagColumnOperation sets the TagColumnOperation field's value.
func (s *TransformOperation) SetTagColumnOperation(v *TagColumnOperation) *TransformOperation {
	s.TagColumnOperation = v
	return s
}

// Twitter parameters.
type TwitterParameters struct {
	_ struct{} `type:"structure"`

	// Maximum number of rows to query Twitter.
	//
	// MaxRows is a required field
	MaxRows *int64 `min:"1" type:"integer" required:"true"`

	// Twitter query string.
	//
	// Query is a required field
	Query *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s TwitterParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TwitterParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TwitterParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TwitterParameters"}
	if s.MaxRows == nil {
		invalidParams.Add(request.NewErrParamRequired("MaxRows"))
	}
	if s.MaxRows != nil && *s.MaxRows < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxRows", 1))
	}
	if s.Query == nil {
		invalidParams.Add(request.NewErrParamRequired("Query"))
	}
	if s.Query != nil && len(*s.Query) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Query", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxRows sets the MaxRows field's value.
func (s *TwitterParameters) SetMaxRows(v int64) *TwitterParameters {
	s.MaxRows = &v
	return s
}

// SetQuery sets the Query field's value.
func (s *TwitterParameters) SetQuery(v string) *TwitterParameters {
	s.Query = &v
	return s
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource that you want to untag.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"ResourceArn" type:"string" required:"true"`

	// The keys of the key-value pairs for the resource tag or tags assigned to
	// the resource.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"keys" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}
	if s.TagKeys != nil && len(s.TagKeys) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagKeys", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

// SetRequestId sets the RequestId field's value.
func (s *UntagResourceOutput) SetRequestId(v string) *UntagResourceOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *UntagResourceOutput) SetStatus(v int64) *UntagResourceOutput {
	s.Status = &v
	return s
}

type UpdateDashboardInput struct {
	_ struct{} `type:"structure"`

	// AWS account ID that contains the dashboard you are updating.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The ID for the dashboard.
	//
	// DashboardId is a required field
	DashboardId *string `location:"uri" locationName:"DashboardId" min:"1" type:"string" required:"true"`

	// Publishing options when creating a dashboard.
	//
	//    * AvailabilityStatus for AdHocFilteringOption - This can be either ENABLED
	//    or DISABLED. When This is set to set to DISABLED, QuickSight disables
	//    the left filter pane on the published dashboard, which can be used for
	//    AdHoc filtering. Enabled by default.
	//
	//    * AvailabilityStatus for ExportToCSVOption - This can be either ENABLED
	//    or DISABLED. The visual option to export data to CSV is disabled when
	//    this is set to DISABLED. Enabled by default.
	//
	//    * VisibilityState for SheetControlsOption - This can be either COLLAPSED
	//    or EXPANDED. The sheet controls pane is collapsed by default when set
	//    to true. Collapsed by default.
	DashboardPublishOptions *DashboardPublishOptions `type:"structure"`

	// The display name of the dashboard.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// A structure that contains the parameters of the dashboard.
	Parameters *Parameters `type:"structure"`

	// The template or analysis from which the dashboard is created. The SouceTemplate
	// entity accepts the Arn of the template and also references to replacement
	// datasets for the placeholders set when creating the template. The replacement
	// datasets need to follow the same schema as the datasets for which placeholders
	// were created when creating the template.
	//
	// SourceEntity is a required field
	SourceEntity *DashboardSourceEntity `type:"structure" required:"true"`

	// A description for the first version of the dashboard being created.
	VersionDescription *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateDashboardInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDashboardInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDashboardInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDashboardInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.DashboardId == nil {
		invalidParams.Add(request.NewErrParamRequired("DashboardId"))
	}
	if s.DashboardId != nil && len(*s.DashboardId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DashboardId", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.SourceEntity == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceEntity"))
	}
	if s.VersionDescription != nil && len(*s.VersionDescription) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VersionDescription", 1))
	}
	if s.Parameters != nil {
		if err := s.Parameters.Validate(); err != nil {
			invalidParams.AddNested("Parameters", err.(request.ErrInvalidParams))
		}
	}
	if s.SourceEntity != nil {
		if err := s.SourceEntity.Validate(); err != nil {
			invalidParams.AddNested("SourceEntity", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *UpdateDashboardInput) SetAwsAccountId(v string) *UpdateDashboardInput {
	s.AwsAccountId = &v
	return s
}

// SetDashboardId sets the DashboardId field's value.
func (s *UpdateDashboardInput) SetDashboardId(v string) *UpdateDashboardInput {
	s.DashboardId = &v
	return s
}

// SetDashboardPublishOptions sets the DashboardPublishOptions field's value.
func (s *UpdateDashboardInput) SetDashboardPublishOptions(v *DashboardPublishOptions) *UpdateDashboardInput {
	s.DashboardPublishOptions = v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateDashboardInput) SetName(v string) *UpdateDashboardInput {
	s.Name = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *UpdateDashboardInput) SetParameters(v *Parameters) *UpdateDashboardInput {
	s.Parameters = v
	return s
}

// SetSourceEntity sets the SourceEntity field's value.
func (s *UpdateDashboardInput) SetSourceEntity(v *DashboardSourceEntity) *UpdateDashboardInput {
	s.SourceEntity = v
	return s
}

// SetVersionDescription sets the VersionDescription field's value.
func (s *UpdateDashboardInput) SetVersionDescription(v string) *UpdateDashboardInput {
	s.VersionDescription = &v
	return s
}

type UpdateDashboardOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource.
	Arn *string `type:"string"`

	// The creation status of the request.
	CreationStatus *string `type:"string" enum:"ResourceStatus"`

	// The ID for the dashboard.
	DashboardId *string `min:"1" type:"string"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `type:"integer"`

	// The ARN of the dashboard, including the version number.
	VersionArn *string `type:"string"`
}

// String returns the string representation
func (s UpdateDashboardOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDashboardOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *UpdateDashboardOutput) SetArn(v string) *UpdateDashboardOutput {
	s.Arn = &v
	return s
}

// SetCreationStatus sets the CreationStatus field's value.
func (s *UpdateDashboardOutput) SetCreationStatus(v string) *UpdateDashboardOutput {
	s.CreationStatus = &v
	return s
}

// SetDashboardId sets the DashboardId field's value.
func (s *UpdateDashboardOutput) SetDashboardId(v string) *UpdateDashboardOutput {
	s.DashboardId = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *UpdateDashboardOutput) SetRequestId(v string) *UpdateDashboardOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *UpdateDashboardOutput) SetStatus(v int64) *UpdateDashboardOutput {
	s.Status = &v
	return s
}

// SetVersionArn sets the VersionArn field's value.
func (s *UpdateDashboardOutput) SetVersionArn(v string) *UpdateDashboardOutput {
	s.VersionArn = &v
	return s
}

type UpdateDashboardPermissionsInput struct {
	_ struct{} `type:"structure"`

	// AWS account ID that contains the dashboard you are updating.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The ID for the dashboard.
	//
	// DashboardId is a required field
	DashboardId *string `location:"uri" locationName:"DashboardId" min:"1" type:"string" required:"true"`

	// The permissions that you want to grant on this resource.
	GrantPermissions []*ResourcePermission `min:"1" type:"list"`

	// The permissions that you want to revoke from this resource.
	RevokePermissions []*ResourcePermission `min:"1" type:"list"`
}

// String returns the string representation
func (s UpdateDashboardPermissionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDashboardPermissionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDashboardPermissionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDashboardPermissionsInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.DashboardId == nil {
		invalidParams.Add(request.NewErrParamRequired("DashboardId"))
	}
	if s.DashboardId != nil && len(*s.DashboardId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DashboardId", 1))
	}
	if s.GrantPermissions != nil && len(s.GrantPermissions) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GrantPermissions", 1))
	}
	if s.RevokePermissions != nil && len(s.RevokePermissions) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RevokePermissions", 1))
	}
	if s.GrantPermissions != nil {
		for i, v := range s.GrantPermissions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "GrantPermissions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.RevokePermissions != nil {
		for i, v := range s.RevokePermissions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "RevokePermissions", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *UpdateDashboardPermissionsInput) SetAwsAccountId(v string) *UpdateDashboardPermissionsInput {
	s.AwsAccountId = &v
	return s
}

// SetDashboardId sets the DashboardId field's value.
func (s *UpdateDashboardPermissionsInput) SetDashboardId(v string) *UpdateDashboardPermissionsInput {
	s.DashboardId = &v
	return s
}

// SetGrantPermissions sets the GrantPermissions field's value.
func (s *UpdateDashboardPermissionsInput) SetGrantPermissions(v []*ResourcePermission) *UpdateDashboardPermissionsInput {
	s.GrantPermissions = v
	return s
}

// SetRevokePermissions sets the RevokePermissions field's value.
func (s *UpdateDashboardPermissionsInput) SetRevokePermissions(v []*ResourcePermission) *UpdateDashboardPermissionsInput {
	s.RevokePermissions = v
	return s
}

type UpdateDashboardPermissionsOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the dashboard.
	DashboardArn *string `type:"string"`

	// The ID for the dashboard.
	DashboardId *string `min:"1" type:"string"`

	// Information about the permissions on the dashboard.
	Permissions []*ResourcePermission `min:"1" type:"list"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation
func (s UpdateDashboardPermissionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDashboardPermissionsOutput) GoString() string {
	return s.String()
}

// SetDashboardArn sets the DashboardArn field's value.
func (s *UpdateDashboardPermissionsOutput) SetDashboardArn(v string) *UpdateDashboardPermissionsOutput {
	s.DashboardArn = &v
	return s
}

// SetDashboardId sets the DashboardId field's value.
func (s *UpdateDashboardPermissionsOutput) SetDashboardId(v string) *UpdateDashboardPermissionsOutput {
	s.DashboardId = &v
	return s
}

// SetPermissions sets the Permissions field's value.
func (s *UpdateDashboardPermissionsOutput) SetPermissions(v []*ResourcePermission) *UpdateDashboardPermissionsOutput {
	s.Permissions = v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *UpdateDashboardPermissionsOutput) SetRequestId(v string) *UpdateDashboardPermissionsOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *UpdateDashboardPermissionsOutput) SetStatus(v int64) *UpdateDashboardPermissionsOutput {
	s.Status = &v
	return s
}

type UpdateDashboardPublishedVersionInput struct {
	_ struct{} `type:"structure"`

	// AWS account ID that contains the dashboard you are updating.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The ID for the dashboard.
	//
	// DashboardId is a required field
	DashboardId *string `location:"uri" locationName:"DashboardId" min:"1" type:"string" required:"true"`

	// The version number of the dashboard.
	//
	// VersionNumber is a required field
	VersionNumber *int64 `location:"uri" locationName:"VersionNumber" min:"1" type:"long" required:"true"`
}

// String returns the string representation
func (s UpdateDashboardPublishedVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDashboardPublishedVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDashboardPublishedVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDashboardPublishedVersionInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.DashboardId == nil {
		invalidParams.Add(request.NewErrParamRequired("DashboardId"))
	}
	if s.DashboardId != nil && len(*s.DashboardId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DashboardId", 1))
	}
	if s.VersionNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("VersionNumber"))
	}
	if s.VersionNumber != nil && *s.VersionNumber < 1 {
		invalidParams.Add(request.NewErrParamMinValue("VersionNumber", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *UpdateDashboardPublishedVersionInput) SetAwsAccountId(v string) *UpdateDashboardPublishedVersionInput {
	s.AwsAccountId = &v
	return s
}

// SetDashboardId sets the DashboardId field's value.
func (s *UpdateDashboardPublishedVersionInput) SetDashboardId(v string) *UpdateDashboardPublishedVersionInput {
	s.DashboardId = &v
	return s
}

// SetVersionNumber sets the VersionNumber field's value.
func (s *UpdateDashboardPublishedVersionInput) SetVersionNumber(v int64) *UpdateDashboardPublishedVersionInput {
	s.VersionNumber = &v
	return s
}

type UpdateDashboardPublishedVersionOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the dashboard.
	DashboardArn *string `type:"string"`

	// The ID for the dashboard.
	DashboardId *string `min:"1" type:"string"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation
func (s UpdateDashboardPublishedVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDashboardPublishedVersionOutput) GoString() string {
	return s.String()
}

// SetDashboardArn sets the DashboardArn field's value.
func (s *UpdateDashboardPublishedVersionOutput) SetDashboardArn(v string) *UpdateDashboardPublishedVersionOutput {
	s.DashboardArn = &v
	return s
}

// SetDashboardId sets the DashboardId field's value.
func (s *UpdateDashboardPublishedVersionOutput) SetDashboardId(v string) *UpdateDashboardPublishedVersionOutput {
	s.DashboardId = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *UpdateDashboardPublishedVersionOutput) SetRequestId(v string) *UpdateDashboardPublishedVersionOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *UpdateDashboardPublishedVersionOutput) SetStatus(v int64) *UpdateDashboardPublishedVersionOutput {
	s.Status = &v
	return s
}

type UpdateDataSetInput struct {
	_ struct{} `type:"structure"`

	// The AWS Account ID.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// Groupings of columns that work together in certain QuickSight features. Currently,
	// only geospatial hierarchy is supported.
	ColumnGroups []*ColumnGroup `min:"1" type:"list"`

	// The ID for the dataset that you want to create. This ID is unique per AWS
	// Region for each AWS account.
	//
	// DataSetId is a required field
	DataSetId *string `location:"uri" locationName:"DataSetId" type:"string" required:"true"`

	// Indicates whether or not you want to import the data into SPICE.
	//
	// ImportMode is a required field
	ImportMode *string `type:"string" required:"true" enum:"DataSetImportMode"`

	// Configures the combination and transformation of the data from the physical
	// tables.
	LogicalTableMap map[string]*LogicalTable `min:"1" type:"map"`

	// The display name for the dataset.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// Declares the physical tables that are available in the underlying data sources.
	//
	// PhysicalTableMap is a required field
	PhysicalTableMap map[string]*PhysicalTable `min:"1" type:"map" required:"true"`

	// Row-level security configuration on the data you want to create.
	RowLevelPermissionDataSet *RowLevelPermissionDataSet `type:"structure"`
}

// String returns the string representation
func (s UpdateDataSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDataSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDataSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDataSetInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.ColumnGroups != nil && len(s.ColumnGroups) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ColumnGroups", 1))
	}
	if s.DataSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSetId"))
	}
	if s.DataSetId != nil && len(*s.DataSetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataSetId", 1))
	}
	if s.ImportMode == nil {
		invalidParams.Add(request.NewErrParamRequired("ImportMode"))
	}
	if s.LogicalTableMap != nil && len(s.LogicalTableMap) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LogicalTableMap", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.PhysicalTableMap == nil {
		invalidParams.Add(request.NewErrParamRequired("PhysicalTableMap"))
	}
	if s.PhysicalTableMap != nil && len(s.PhysicalTableMap) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PhysicalTableMap", 1))
	}
	if s.ColumnGroups != nil {
		for i, v := range s.ColumnGroups {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ColumnGroups", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.LogicalTableMap != nil {
		for i, v := range s.LogicalTableMap {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "LogicalTableMap", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.PhysicalTableMap != nil {
		for i, v := range s.PhysicalTableMap {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "PhysicalTableMap", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.RowLevelPermissionDataSet != nil {
		if err := s.RowLevelPermissionDataSet.Validate(); err != nil {
			invalidParams.AddNested("RowLevelPermissionDataSet", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *UpdateDataSetInput) SetAwsAccountId(v string) *UpdateDataSetInput {
	s.AwsAccountId = &v
	return s
}

// SetColumnGroups sets the ColumnGroups field's value.
func (s *UpdateDataSetInput) SetColumnGroups(v []*ColumnGroup) *UpdateDataSetInput {
	s.ColumnGroups = v
	return s
}

// SetDataSetId sets the DataSetId field's value.
func (s *UpdateDataSetInput) SetDataSetId(v string) *UpdateDataSetInput {
	s.DataSetId = &v
	return s
}

// SetImportMode sets the ImportMode field's value.
func (s *UpdateDataSetInput) SetImportMode(v string) *UpdateDataSetInput {
	s.ImportMode = &v
	return s
}

// SetLogicalTableMap sets the LogicalTableMap field's value.
func (s *UpdateDataSetInput) SetLogicalTableMap(v map[string]*LogicalTable) *UpdateDataSetInput {
	s.LogicalTableMap = v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateDataSetInput) SetName(v string) *UpdateDataSetInput {
	s.Name = &v
	return s
}

// SetPhysicalTableMap sets the PhysicalTableMap field's value.
func (s *UpdateDataSetInput) SetPhysicalTableMap(v map[string]*PhysicalTable) *UpdateDataSetInput {
	s.PhysicalTableMap = v
	return s
}

// SetRowLevelPermissionDataSet sets the RowLevelPermissionDataSet field's value.
func (s *UpdateDataSetInput) SetRowLevelPermissionDataSet(v *RowLevelPermissionDataSet) *UpdateDataSetInput {
	s.RowLevelPermissionDataSet = v
	return s
}

type UpdateDataSetOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the dataset.
	Arn *string `type:"string"`

	// The ID for the dataset that you want to create. This ID is unique per AWS
	// Region for each AWS account.
	DataSetId *string `type:"string"`

	// The ARN for the ingestion, which is triggered as a result of dataset creation
	// if the import mode is SPICE
	IngestionArn *string `type:"string"`

	// The ID of the ingestion, which is triggered as a result of dataset creation
	// if the import mode is SPICE
	IngestionId *string `type:"string"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation
func (s UpdateDataSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDataSetOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *UpdateDataSetOutput) SetArn(v string) *UpdateDataSetOutput {
	s.Arn = &v
	return s
}

// SetDataSetId sets the DataSetId field's value.
func (s *UpdateDataSetOutput) SetDataSetId(v string) *UpdateDataSetOutput {
	s.DataSetId = &v
	return s
}

// SetIngestionArn sets the IngestionArn field's value.
func (s *UpdateDataSetOutput) SetIngestionArn(v string) *UpdateDataSetOutput {
	s.IngestionArn = &v
	return s
}

// SetIngestionId sets the IngestionId field's value.
func (s *UpdateDataSetOutput) SetIngestionId(v string) *UpdateDataSetOutput {
	s.IngestionId = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *UpdateDataSetOutput) SetRequestId(v string) *UpdateDataSetOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *UpdateDataSetOutput) SetStatus(v int64) *UpdateDataSetOutput {
	s.Status = &v
	return s
}

type UpdateDataSetPermissionsInput struct {
	_ struct{} `type:"structure"`

	// The AWS Account ID.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The ID for the dataset that you want to create. This ID is unique per AWS
	// Region for each AWS account.
	//
	// DataSetId is a required field
	DataSetId *string `location:"uri" locationName:"DataSetId" type:"string" required:"true"`

	// The resource permissions that you want to grant to the dataset.
	GrantPermissions []*ResourcePermission `min:"1" type:"list"`

	// The resource permissions that you want to revoke from the dataset.
	RevokePermissions []*ResourcePermission `min:"1" type:"list"`
}

// String returns the string representation
func (s UpdateDataSetPermissionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDataSetPermissionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDataSetPermissionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDataSetPermissionsInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.DataSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSetId"))
	}
	if s.DataSetId != nil && len(*s.DataSetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataSetId", 1))
	}
	if s.GrantPermissions != nil && len(s.GrantPermissions) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GrantPermissions", 1))
	}
	if s.RevokePermissions != nil && len(s.RevokePermissions) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RevokePermissions", 1))
	}
	if s.GrantPermissions != nil {
		for i, v := range s.GrantPermissions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "GrantPermissions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.RevokePermissions != nil {
		for i, v := range s.RevokePermissions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "RevokePermissions", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *UpdateDataSetPermissionsInput) SetAwsAccountId(v string) *UpdateDataSetPermissionsInput {
	s.AwsAccountId = &v
	return s
}

// SetDataSetId sets the DataSetId field's value.
func (s *UpdateDataSetPermissionsInput) SetDataSetId(v string) *UpdateDataSetPermissionsInput {
	s.DataSetId = &v
	return s
}

// SetGrantPermissions sets the GrantPermissions field's value.
func (s *UpdateDataSetPermissionsInput) SetGrantPermissions(v []*ResourcePermission) *UpdateDataSetPermissionsInput {
	s.GrantPermissions = v
	return s
}

// SetRevokePermissions sets the RevokePermissions field's value.
func (s *UpdateDataSetPermissionsInput) SetRevokePermissions(v []*ResourcePermission) *UpdateDataSetPermissionsInput {
	s.RevokePermissions = v
	return s
}

type UpdateDataSetPermissionsOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the dataset.
	DataSetArn *string `type:"string"`

	// The ID for the dataset that you want to create. This ID is unique per AWS
	// Region for each AWS account.
	DataSetId *string `type:"string"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation
func (s UpdateDataSetPermissionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDataSetPermissionsOutput) GoString() string {
	return s.String()
}

// SetDataSetArn sets the DataSetArn field's value.
func (s *UpdateDataSetPermissionsOutput) SetDataSetArn(v string) *UpdateDataSetPermissionsOutput {
	s.DataSetArn = &v
	return s
}

// SetDataSetId sets the DataSetId field's value.
func (s *UpdateDataSetPermissionsOutput) SetDataSetId(v string) *UpdateDataSetPermissionsOutput {
	s.DataSetId = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *UpdateDataSetPermissionsOutput) SetRequestId(v string) *UpdateDataSetPermissionsOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *UpdateDataSetPermissionsOutput) SetStatus(v int64) *UpdateDataSetPermissionsOutput {
	s.Status = &v
	return s
}

type UpdateDataSourceInput struct {
	_ struct{} `type:"structure"`

	// The AWS account ID.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The credentials that QuickSight that uses to connect to your underlying source.
	// Currently, only credentials based on user name and password are supported.
	Credentials *DataSourceCredentials `type:"structure" sensitive:"true"`

	// The ID of the data source. This ID is unique per AWS Region for each AWS
	// account.
	//
	// DataSourceId is a required field
	DataSourceId *string `location:"uri" locationName:"DataSourceId" type:"string" required:"true"`

	// The parameters that QuickSight uses to connect to your underlying source.
	DataSourceParameters *DataSourceParameters `type:"structure"`

	// A display name for the data source.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// Secure Socket Layer (SSL) properties that apply when QuickSight connects
	// to your underlying source.
	SslProperties *SslProperties `type:"structure"`

	// Use this parameter only when you want QuickSight to use a VPC connection
	// when connecting to your underlying source.
	VpcConnectionProperties *VpcConnectionProperties `type:"structure"`
}

// String returns the string representation
func (s UpdateDataSourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDataSourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDataSourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDataSourceInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.DataSourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSourceId"))
	}
	if s.DataSourceId != nil && len(*s.DataSourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataSourceId", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Credentials != nil {
		if err := s.Credentials.Validate(); err != nil {
			invalidParams.AddNested("Credentials", err.(request.ErrInvalidParams))
		}
	}
	if s.DataSourceParameters != nil {
		if err := s.DataSourceParameters.Validate(); err != nil {
			invalidParams.AddNested("DataSourceParameters", err.(request.ErrInvalidParams))
		}
	}
	if s.VpcConnectionProperties != nil {
		if err := s.VpcConnectionProperties.Validate(); err != nil {
			invalidParams.AddNested("VpcConnectionProperties", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *UpdateDataSourceInput) SetAwsAccountId(v string) *UpdateDataSourceInput {
	s.AwsAccountId = &v
	return s
}

// SetCredentials sets the Credentials field's value.
func (s *UpdateDataSourceInput) SetCredentials(v *DataSourceCredentials) *UpdateDataSourceInput {
	s.Credentials = v
	return s
}

// SetDataSourceId sets the DataSourceId field's value.
func (s *UpdateDataSourceInput) SetDataSourceId(v string) *UpdateDataSourceInput {
	s.DataSourceId = &v
	return s
}

// SetDataSourceParameters sets the DataSourceParameters field's value.
func (s *UpdateDataSourceInput) SetDataSourceParameters(v *DataSourceParameters) *UpdateDataSourceInput {
	s.DataSourceParameters = v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateDataSourceInput) SetName(v string) *UpdateDataSourceInput {
	s.Name = &v
	return s
}

// SetSslProperties sets the SslProperties field's value.
func (s *UpdateDataSourceInput) SetSslProperties(v *SslProperties) *UpdateDataSourceInput {
	s.SslProperties = v
	return s
}

// SetVpcConnectionProperties sets the VpcConnectionProperties field's value.
func (s *UpdateDataSourceInput) SetVpcConnectionProperties(v *VpcConnectionProperties) *UpdateDataSourceInput {
	s.VpcConnectionProperties = v
	return s
}

type UpdateDataSourceOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the data source.
	Arn *string `type:"string"`

	// The ID of the data source. This ID is unique per AWS Region for each AWS
	// account.
	DataSourceId *string `type:"string"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`

	// The update status of the data source's last update.
	UpdateStatus *string `type:"string" enum:"ResourceStatus"`
}

// String returns the string representation
func (s UpdateDataSourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDataSourceOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *UpdateDataSourceOutput) SetArn(v string) *UpdateDataSourceOutput {
	s.Arn = &v
	return s
}

// SetDataSourceId sets the DataSourceId field's value.
func (s *UpdateDataSourceOutput) SetDataSourceId(v string) *UpdateDataSourceOutput {
	s.DataSourceId = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *UpdateDataSourceOutput) SetRequestId(v string) *UpdateDataSourceOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *UpdateDataSourceOutput) SetStatus(v int64) *UpdateDataSourceOutput {
	s.Status = &v
	return s
}

// SetUpdateStatus sets the UpdateStatus field's value.
func (s *UpdateDataSourceOutput) SetUpdateStatus(v string) *UpdateDataSourceOutput {
	s.UpdateStatus = &v
	return s
}

type UpdateDataSourcePermissionsInput struct {
	_ struct{} `type:"structure"`

	// The AWS account ID.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The ID of the data source. This ID is unique per AWS Region for each AWS
	// account.
	//
	// DataSourceId is a required field
	DataSourceId *string `location:"uri" locationName:"DataSourceId" type:"string" required:"true"`

	// A list of resource permissions that you want to grant on the data source.
	GrantPermissions []*ResourcePermission `min:"1" type:"list"`

	// A list of resource permissions that you want to revoke on the data source.
	RevokePermissions []*ResourcePermission `min:"1" type:"list"`
}

// String returns the string representation
func (s UpdateDataSourcePermissionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDataSourcePermissionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDataSourcePermissionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDataSourcePermissionsInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.DataSourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSourceId"))
	}
	if s.DataSourceId != nil && len(*s.DataSourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataSourceId", 1))
	}
	if s.GrantPermissions != nil && len(s.GrantPermissions) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GrantPermissions", 1))
	}
	if s.RevokePermissions != nil && len(s.RevokePermissions) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RevokePermissions", 1))
	}
	if s.GrantPermissions != nil {
		for i, v := range s.GrantPermissions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "GrantPermissions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.RevokePermissions != nil {
		for i, v := range s.RevokePermissions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "RevokePermissions", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *UpdateDataSourcePermissionsInput) SetAwsAccountId(v string) *UpdateDataSourcePermissionsInput {
	s.AwsAccountId = &v
	return s
}

// SetDataSourceId sets the DataSourceId field's value.
func (s *UpdateDataSourcePermissionsInput) SetDataSourceId(v string) *UpdateDataSourcePermissionsInput {
	s.DataSourceId = &v
	return s
}

// SetGrantPermissions sets the GrantPermissions field's value.
func (s *UpdateDataSourcePermissionsInput) SetGrantPermissions(v []*ResourcePermission) *UpdateDataSourcePermissionsInput {
	s.GrantPermissions = v
	return s
}

// SetRevokePermissions sets the RevokePermissions field's value.
func (s *UpdateDataSourcePermissionsInput) SetRevokePermissions(v []*ResourcePermission) *UpdateDataSourcePermissionsInput {
	s.RevokePermissions = v
	return s
}

type UpdateDataSourcePermissionsOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the data source.
	DataSourceArn *string `type:"string"`

	// The ID of the data source. This ID is unique per AWS Region for each AWS
	// account.
	DataSourceId *string `type:"string"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation
func (s UpdateDataSourcePermissionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDataSourcePermissionsOutput) GoString() string {
	return s.String()
}

// SetDataSourceArn sets the DataSourceArn field's value.
func (s *UpdateDataSourcePermissionsOutput) SetDataSourceArn(v string) *UpdateDataSourcePermissionsOutput {
	s.DataSourceArn = &v
	return s
}

// SetDataSourceId sets the DataSourceId field's value.
func (s *UpdateDataSourcePermissionsOutput) SetDataSourceId(v string) *UpdateDataSourcePermissionsOutput {
	s.DataSourceId = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *UpdateDataSourcePermissionsOutput) SetRequestId(v string) *UpdateDataSourcePermissionsOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *UpdateDataSourcePermissionsOutput) SetStatus(v int64) *UpdateDataSourcePermissionsOutput {
	s.Status = &v
	return s
}

type UpdateGroupInput struct {
	_ struct{} `type:"structure"`

	// The ID for the AWS account that the group is in. Currently, you use the ID
	// for the AWS account that contains your Amazon QuickSight account.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The description for the group that you want to update.
	Description *string `min:"1" type:"string"`

	// The name of the group that you want to update.
	//
	// GroupName is a required field
	GroupName *string `location:"uri" locationName:"GroupName" min:"1" type:"string" required:"true"`

	// The namespace. Currently, you should set this to default.
	//
	// Namespace is a required field
	Namespace *string `location:"uri" locationName:"Namespace" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateGroupInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.GroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupName"))
	}
	if s.GroupName != nil && len(*s.GroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupName", 1))
	}
	if s.Namespace == nil {
		invalidParams.Add(request.NewErrParamRequired("Namespace"))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *UpdateGroupInput) SetAwsAccountId(v string) *UpdateGroupInput {
	s.AwsAccountId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateGroupInput) SetDescription(v string) *UpdateGroupInput {
	s.Description = &v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *UpdateGroupInput) SetGroupName(v string) *UpdateGroupInput {
	s.GroupName = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *UpdateGroupInput) SetNamespace(v string) *UpdateGroupInput {
	s.Namespace = &v
	return s
}

type UpdateGroupOutput struct {
	_ struct{} `type:"structure"`

	// The name of the group.
	Group *Group `type:"structure"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation
func (s UpdateGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateGroupOutput) GoString() string {
	return s.String()
}

// SetGroup sets the Group field's value.
func (s *UpdateGroupOutput) SetGroup(v *Group) *UpdateGroupOutput {
	s.Group = v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *UpdateGroupOutput) SetRequestId(v string) *UpdateGroupOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *UpdateGroupOutput) SetStatus(v int64) *UpdateGroupOutput {
	s.Status = &v
	return s
}

type UpdateIAMPolicyAssignmentInput struct {
	_ struct{} `type:"structure"`

	// The name of the assignment. It must be unique within an AWS account.
	//
	// AssignmentName is a required field
	AssignmentName *string `location:"uri" locationName:"AssignmentName" min:"1" type:"string" required:"true"`

	// The status of an assignment:
	//
	//    * ENABLED - Anything specified in this assignment is used while creating
	//    the data source.
	//
	//    * DISABLED - This assignment isn't used while creating the data source.
	//
	//    * DRAFT - Assignment is an unfinished draft and isn't used while creating
	//    the data source.
	AssignmentStatus *string `type:"string" enum:"AssignmentStatus"`

	// The AWS account ID that contains the IAM policy assignment.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// QuickSight users and/or groups that you want to assign to the specified IAM
	// policy.
	Identities map[string][]*string `type:"map"`

	// The namespace of the assignment.
	//
	// Namespace is a required field
	Namespace *string `location:"uri" locationName:"Namespace" type:"string" required:"true"`

	// An IAM policy Amazon Resource Name (ARN) that will be applied to specified
	// QuickSight users and groups in this assignment.
	PolicyArn *string `type:"string"`
}

// String returns the string representation
func (s UpdateIAMPolicyAssignmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateIAMPolicyAssignmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateIAMPolicyAssignmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateIAMPolicyAssignmentInput"}
	if s.AssignmentName == nil {
		invalidParams.Add(request.NewErrParamRequired("AssignmentName"))
	}
	if s.AssignmentName != nil && len(*s.AssignmentName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AssignmentName", 1))
	}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.Namespace == nil {
		invalidParams.Add(request.NewErrParamRequired("Namespace"))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssignmentName sets the AssignmentName field's value.
func (s *UpdateIAMPolicyAssignmentInput) SetAssignmentName(v string) *UpdateIAMPolicyAssignmentInput {
	s.AssignmentName = &v
	return s
}

// SetAssignmentStatus sets the AssignmentStatus field's value.
func (s *UpdateIAMPolicyAssignmentInput) SetAssignmentStatus(v string) *UpdateIAMPolicyAssignmentInput {
	s.AssignmentStatus = &v
	return s
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *UpdateIAMPolicyAssignmentInput) SetAwsAccountId(v string) *UpdateIAMPolicyAssignmentInput {
	s.AwsAccountId = &v
	return s
}

// SetIdentities sets the Identities field's value.
func (s *UpdateIAMPolicyAssignmentInput) SetIdentities(v map[string][]*string) *UpdateIAMPolicyAssignmentInput {
	s.Identities = v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *UpdateIAMPolicyAssignmentInput) SetNamespace(v string) *UpdateIAMPolicyAssignmentInput {
	s.Namespace = &v
	return s
}

// SetPolicyArn sets the PolicyArn field's value.
func (s *UpdateIAMPolicyAssignmentInput) SetPolicyArn(v string) *UpdateIAMPolicyAssignmentInput {
	s.PolicyArn = &v
	return s
}

type UpdateIAMPolicyAssignmentOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the assignment.
	AssignmentId *string `type:"string"`

	// The name of the assignment.
	AssignmentName *string `min:"1" type:"string"`

	// The status of the assignment:
	//
	//    * ENABLED - Anything specified in this assignment is used while creating
	//    the data source.
	//
	//    * DISABLED - This assignment isn't used while creating the data source.
	//
	//    * DRAFT - Assignment is an unfinished draft and isn't used while creating
	//    the data source.
	AssignmentStatus *string `type:"string" enum:"AssignmentStatus"`

	// QuickSight users and/or groups that are assigned to this IAM policy.
	Identities map[string][]*string `type:"map"`

	// The IAM policy ARN assigned to the QuickSight users and groups specified
	// in this request.
	PolicyArn *string `type:"string"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation
func (s UpdateIAMPolicyAssignmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateIAMPolicyAssignmentOutput) GoString() string {
	return s.String()
}

// SetAssignmentId sets the AssignmentId field's value.
func (s *UpdateIAMPolicyAssignmentOutput) SetAssignmentId(v string) *UpdateIAMPolicyAssignmentOutput {
	s.AssignmentId = &v
	return s
}

// SetAssignmentName sets the AssignmentName field's value.
func (s *UpdateIAMPolicyAssignmentOutput) SetAssignmentName(v string) *UpdateIAMPolicyAssignmentOutput {
	s.AssignmentName = &v
	return s
}

// SetAssignmentStatus sets the AssignmentStatus field's value.
func (s *UpdateIAMPolicyAssignmentOutput) SetAssignmentStatus(v string) *UpdateIAMPolicyAssignmentOutput {
	s.AssignmentStatus = &v
	return s
}

// SetIdentities sets the Identities field's value.
func (s *UpdateIAMPolicyAssignmentOutput) SetIdentities(v map[string][]*string) *UpdateIAMPolicyAssignmentOutput {
	s.Identities = v
	return s
}

// SetPolicyArn sets the PolicyArn field's value.
func (s *UpdateIAMPolicyAssignmentOutput) SetPolicyArn(v string) *UpdateIAMPolicyAssignmentOutput {
	s.PolicyArn = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *UpdateIAMPolicyAssignmentOutput) SetRequestId(v string) *UpdateIAMPolicyAssignmentOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *UpdateIAMPolicyAssignmentOutput) SetStatus(v int64) *UpdateIAMPolicyAssignmentOutput {
	s.Status = &v
	return s
}

type UpdateTemplateAliasInput struct {
	_ struct{} `type:"structure"`

	// The alias of the template that you want to update. If you provide a specific
	// alias, you update the version that the alias points to. You can specify the
	// latest version of the template by providing the keyword $LATEST in the AliasName
	// parameter. The keyword $PUBLISHED doesn't apply to templates.
	//
	// AliasName is a required field
	AliasName *string `location:"uri" locationName:"AliasName" min:"1" type:"string" required:"true"`

	// AWS account ID that contains the template aliases you are updating.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The ID for the template.
	//
	// TemplateId is a required field
	TemplateId *string `location:"uri" locationName:"TemplateId" min:"1" type:"string" required:"true"`

	// The version number of the template.
	//
	// TemplateVersionNumber is a required field
	TemplateVersionNumber *int64 `min:"1" type:"long" required:"true"`
}

// String returns the string representation
func (s UpdateTemplateAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateTemplateAliasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateTemplateAliasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateTemplateAliasInput"}
	if s.AliasName == nil {
		invalidParams.Add(request.NewErrParamRequired("AliasName"))
	}
	if s.AliasName != nil && len(*s.AliasName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AliasName", 1))
	}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.TemplateId == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateId"))
	}
	if s.TemplateId != nil && len(*s.TemplateId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateId", 1))
	}
	if s.TemplateVersionNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateVersionNumber"))
	}
	if s.TemplateVersionNumber != nil && *s.TemplateVersionNumber < 1 {
		invalidParams.Add(request.NewErrParamMinValue("TemplateVersionNumber", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAliasName sets the AliasName field's value.
func (s *UpdateTemplateAliasInput) SetAliasName(v string) *UpdateTemplateAliasInput {
	s.AliasName = &v
	return s
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *UpdateTemplateAliasInput) SetAwsAccountId(v string) *UpdateTemplateAliasInput {
	s.AwsAccountId = &v
	return s
}

// SetTemplateId sets the TemplateId field's value.
func (s *UpdateTemplateAliasInput) SetTemplateId(v string) *UpdateTemplateAliasInput {
	s.TemplateId = &v
	return s
}

// SetTemplateVersionNumber sets the TemplateVersionNumber field's value.
func (s *UpdateTemplateAliasInput) SetTemplateVersionNumber(v int64) *UpdateTemplateAliasInput {
	s.TemplateVersionNumber = &v
	return s
}

type UpdateTemplateAliasOutput struct {
	_ struct{} `type:"structure"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`

	// The template alias.
	TemplateAlias *TemplateAlias `type:"structure"`
}

// String returns the string representation
func (s UpdateTemplateAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateTemplateAliasOutput) GoString() string {
	return s.String()
}

// SetRequestId sets the RequestId field's value.
func (s *UpdateTemplateAliasOutput) SetRequestId(v string) *UpdateTemplateAliasOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *UpdateTemplateAliasOutput) SetStatus(v int64) *UpdateTemplateAliasOutput {
	s.Status = &v
	return s
}

// SetTemplateAlias sets the TemplateAlias field's value.
func (s *UpdateTemplateAliasOutput) SetTemplateAlias(v *TemplateAlias) *UpdateTemplateAliasOutput {
	s.TemplateAlias = v
	return s
}

type UpdateTemplateInput struct {
	_ struct{} `type:"structure"`

	// AWS account ID that contains the template you are updating.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The name for the template.
	Name *string `min:"1" type:"string"`

	// The source QuickSight entity from which this template is being created. Templates
	// can be currently created from an Analysis or another template.
	//
	// SourceEntity is a required field
	SourceEntity *TemplateSourceEntity `type:"structure" required:"true"`

	// The ID for the template.
	//
	// TemplateId is a required field
	TemplateId *string `location:"uri" locationName:"TemplateId" min:"1" type:"string" required:"true"`

	// A description of the current template version being updated. Every time you
	// cal UpdateTemplate you create a new version. Each version of the template
	// maintains a description of the version in the VersionDescription field.
	VersionDescription *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateTemplateInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.SourceEntity == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceEntity"))
	}
	if s.TemplateId == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateId"))
	}
	if s.TemplateId != nil && len(*s.TemplateId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateId", 1))
	}
	if s.VersionDescription != nil && len(*s.VersionDescription) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VersionDescription", 1))
	}
	if s.SourceEntity != nil {
		if err := s.SourceEntity.Validate(); err != nil {
			invalidParams.AddNested("SourceEntity", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *UpdateTemplateInput) SetAwsAccountId(v string) *UpdateTemplateInput {
	s.AwsAccountId = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateTemplateInput) SetName(v string) *UpdateTemplateInput {
	s.Name = &v
	return s
}

// SetSourceEntity sets the SourceEntity field's value.
func (s *UpdateTemplateInput) SetSourceEntity(v *TemplateSourceEntity) *UpdateTemplateInput {
	s.SourceEntity = v
	return s
}

// SetTemplateId sets the TemplateId field's value.
func (s *UpdateTemplateInput) SetTemplateId(v string) *UpdateTemplateInput {
	s.TemplateId = &v
	return s
}

// SetVersionDescription sets the VersionDescription field's value.
func (s *UpdateTemplateInput) SetVersionDescription(v string) *UpdateTemplateInput {
	s.VersionDescription = &v
	return s
}

type UpdateTemplateOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the template.
	Arn *string `type:"string"`

	// The creation status of the template.
	CreationStatus *string `type:"string" enum:"ResourceStatus"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`

	// The ID for the template.
	TemplateId *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) for the template, including the version information
	// of the first version.
	VersionArn *string `type:"string"`
}

// String returns the string representation
func (s UpdateTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateTemplateOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *UpdateTemplateOutput) SetArn(v string) *UpdateTemplateOutput {
	s.Arn = &v
	return s
}

// SetCreationStatus sets the CreationStatus field's value.
func (s *UpdateTemplateOutput) SetCreationStatus(v string) *UpdateTemplateOutput {
	s.CreationStatus = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *UpdateTemplateOutput) SetRequestId(v string) *UpdateTemplateOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *UpdateTemplateOutput) SetStatus(v int64) *UpdateTemplateOutput {
	s.Status = &v
	return s
}

// SetTemplateId sets the TemplateId field's value.
func (s *UpdateTemplateOutput) SetTemplateId(v string) *UpdateTemplateOutput {
	s.TemplateId = &v
	return s
}

// SetVersionArn sets the VersionArn field's value.
func (s *UpdateTemplateOutput) SetVersionArn(v string) *UpdateTemplateOutput {
	s.VersionArn = &v
	return s
}

type UpdateTemplatePermissionsInput struct {
	_ struct{} `type:"structure"`

	// AWS account ID that contains the template.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// A list of resource permissions to be granted on the template.
	GrantPermissions []*ResourcePermission `min:"1" type:"list"`

	// A list of resource permissions to be revoked from the template.
	RevokePermissions []*ResourcePermission `min:"1" type:"list"`

	// The ID for the template.
	//
	// TemplateId is a required field
	TemplateId *string `location:"uri" locationName:"TemplateId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateTemplatePermissionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateTemplatePermissionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateTemplatePermissionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateTemplatePermissionsInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.GrantPermissions != nil && len(s.GrantPermissions) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GrantPermissions", 1))
	}
	if s.RevokePermissions != nil && len(s.RevokePermissions) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RevokePermissions", 1))
	}
	if s.TemplateId == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateId"))
	}
	if s.TemplateId != nil && len(*s.TemplateId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateId", 1))
	}
	if s.GrantPermissions != nil {
		for i, v := range s.GrantPermissions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "GrantPermissions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.RevokePermissions != nil {
		for i, v := range s.RevokePermissions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "RevokePermissions", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *UpdateTemplatePermissionsInput) SetAwsAccountId(v string) *UpdateTemplatePermissionsInput {
	s.AwsAccountId = &v
	return s
}

// SetGrantPermissions sets the GrantPermissions field's value.
func (s *UpdateTemplatePermissionsInput) SetGrantPermissions(v []*ResourcePermission) *UpdateTemplatePermissionsInput {
	s.GrantPermissions = v
	return s
}

// SetRevokePermissions sets the RevokePermissions field's value.
func (s *UpdateTemplatePermissionsInput) SetRevokePermissions(v []*ResourcePermission) *UpdateTemplatePermissionsInput {
	s.RevokePermissions = v
	return s
}

// SetTemplateId sets the TemplateId field's value.
func (s *UpdateTemplatePermissionsInput) SetTemplateId(v string) *UpdateTemplatePermissionsInput {
	s.TemplateId = &v
	return s
}

type UpdateTemplatePermissionsOutput struct {
	_ struct{} `type:"structure"`

	// A list of resource permissions to be set on the template.
	Permissions []*ResourcePermission `min:"1" type:"list"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`

	// The Amazon Resource Name (ARN) of the template.
	TemplateArn *string `type:"string"`

	// The ID for the template.
	TemplateId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateTemplatePermissionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateTemplatePermissionsOutput) GoString() string {
	return s.String()
}

// SetPermissions sets the Permissions field's value.
func (s *UpdateTemplatePermissionsOutput) SetPermissions(v []*ResourcePermission) *UpdateTemplatePermissionsOutput {
	s.Permissions = v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *UpdateTemplatePermissionsOutput) SetRequestId(v string) *UpdateTemplatePermissionsOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *UpdateTemplatePermissionsOutput) SetStatus(v int64) *UpdateTemplatePermissionsOutput {
	s.Status = &v
	return s
}

// SetTemplateArn sets the TemplateArn field's value.
func (s *UpdateTemplatePermissionsOutput) SetTemplateArn(v string) *UpdateTemplatePermissionsOutput {
	s.TemplateArn = &v
	return s
}

// SetTemplateId sets the TemplateId field's value.
func (s *UpdateTemplatePermissionsOutput) SetTemplateId(v string) *UpdateTemplatePermissionsOutput {
	s.TemplateId = &v
	return s
}

type UpdateUserInput struct {
	_ struct{} `type:"structure"`

	// The ID for the AWS account that the user is in. Currently, you use the ID
	// for the AWS account that contains your Amazon QuickSight account.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The email address of the user that you want to update.
	//
	// Email is a required field
	Email *string `type:"string" required:"true"`

	// The namespace. Currently, you should set this to default.
	//
	// Namespace is a required field
	Namespace *string `location:"uri" locationName:"Namespace" type:"string" required:"true"`

	// The Amazon QuickSight role of the user. The user role can be one of the following:
	//
	//    * READER: A user who has read-only access to dashboards.
	//
	//    * AUTHOR: A user who can create data sources, datasets, analyses, and
	//    dashboards.
	//
	//    * ADMIN: A user who is an author, who can also manage Amazon QuickSight
	//    settings.
	//
	// Role is a required field
	Role *string `type:"string" required:"true" enum:"UserRole"`

	// The Amazon QuickSight user name that you want to update.
	//
	// UserName is a required field
	UserName *string `location:"uri" locationName:"UserName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateUserInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.Email == nil {
		invalidParams.Add(request.NewErrParamRequired("Email"))
	}
	if s.Namespace == nil {
		invalidParams.Add(request.NewErrParamRequired("Namespace"))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}
	if s.Role == nil {
		invalidParams.Add(request.NewErrParamRequired("Role"))
	}
	if s.UserName == nil {
		invalidParams.Add(request.NewErrParamRequired("UserName"))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *UpdateUserInput) SetAwsAccountId(v string) *UpdateUserInput {
	s.AwsAccountId = &v
	return s
}

// SetEmail sets the Email field's value.
func (s *UpdateUserInput) SetEmail(v string) *UpdateUserInput {
	s.Email = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *UpdateUserInput) SetNamespace(v string) *UpdateUserInput {
	s.Namespace = &v
	return s
}

// SetRole sets the Role field's value.
func (s *UpdateUserInput) SetRole(v string) *UpdateUserInput {
	s.Role = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *UpdateUserInput) SetUserName(v string) *UpdateUserInput {
	s.UserName = &v
	return s
}

type UpdateUserOutput struct {
	_ struct{} `type:"structure"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`

	// The Amazon QuickSight user.
	User *User `type:"structure"`
}

// String returns the string representation
func (s UpdateUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateUserOutput) GoString() string {
	return s.String()
}

// SetRequestId sets the RequestId field's value.
func (s *UpdateUserOutput) SetRequestId(v string) *UpdateUserOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *UpdateUserOutput) SetStatus(v int64) *UpdateUserOutput {
	s.Status = &v
	return s
}

// SetUser sets the User field's value.
func (s *UpdateUserOutput) SetUser(v *User) *UpdateUserOutput {
	s.User = v
	return s
}

// Information on source file(s) format.
type UploadSettings struct {
	_ struct{} `type:"structure"`

	// Whether or not the file(s) has a header row.
	ContainsHeader *bool `type:"boolean"`

	// The delimiter between values in the file.
	Delimiter *string `min:"1" type:"string"`

	// File format.
	Format *string `type:"string" enum:"FileFormat"`

	// A row number to start reading data from.
	StartFromRow *int64 `min:"1" type:"integer"`

	// Text qualifier.
	TextQualifier *string `type:"string" enum:"TextQualifier"`
}

// String returns the string representation
func (s UploadSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UploadSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UploadSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UploadSettings"}
	if s.Delimiter != nil && len(*s.Delimiter) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Delimiter", 1))
	}
	if s.StartFromRow != nil && *s.StartFromRow < 1 {
		invalidParams.Add(request.NewErrParamMinValue("StartFromRow", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContainsHeader sets the ContainsHeader field's value.
func (s *UploadSettings) SetContainsHeader(v bool) *UploadSettings {
	s.ContainsHeader = &v
	return s
}

// SetDelimiter sets the Delimiter field's value.
func (s *UploadSettings) SetDelimiter(v string) *UploadSettings {
	s.Delimiter = &v
	return s
}

// SetFormat sets the Format field's value.
func (s *UploadSettings) SetFormat(v string) *UploadSettings {
	s.Format = &v
	return s
}

// SetStartFromRow sets the StartFromRow field's value.
func (s *UploadSettings) SetStartFromRow(v int64) *UploadSettings {
	s.StartFromRow = &v
	return s
}

// SetTextQualifier sets the TextQualifier field's value.
func (s *UploadSettings) SetTextQualifier(v string) *UploadSettings {
	s.TextQualifier = &v
	return s
}

// A registered user of Amazon QuickSight. Currently, an Amazon QuickSight subscription
// can't contain more than 20 million users.
type User struct {
	_ struct{} `type:"structure"`

	// Active status of user. When you create an Amazon QuickSight user that’s
	// not an IAM user or an AD user, that user is inactive until they sign in and
	// provide a password.
	Active *bool `type:"boolean"`

	// The Amazon Resource name (ARN) for the user.
	Arn *string `type:"string"`

	// The user's email address.
	Email *string `type:"string"`

	// The type of identity authentication used by the user.
	IdentityType *string `type:"string" enum:"IdentityType"`

	// The principal ID of the user.
	PrincipalId *string `type:"string"`

	// The Amazon QuickSight role for the user. The user role can be one of the
	// following:.
	//
	//    * READER: A user who has read-only access to dashboards.
	//
	//    * AUTHOR: A user who can create data sources, datasets, analyses, and
	//    dashboards.
	//
	//    * ADMIN: A user who is an author, who can also manage Amazon QuickSight
	//    settings.
	//
	//    * RESTRICTED_READER: This role isn't currently available for use.
	//
	//    * RESTRICTED_AUTHOR: This role isn't currently available for use.
	Role *string `type:"string" enum:"UserRole"`

	// The user's user name.
	UserName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s User) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s User) GoString() string {
	return s.String()
}

// SetActive sets the Active field's value.
func (s *User) SetActive(v bool) *User {
	s.Active = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *User) SetArn(v string) *User {
	s.Arn = &v
	return s
}

// SetEmail sets the Email field's value.
func (s *User) SetEmail(v string) *User {
	s.Email = &v
	return s
}

// SetIdentityType sets the IdentityType field's value.
func (s *User) SetIdentityType(v string) *User {
	s.IdentityType = &v
	return s
}

// SetPrincipalId sets the PrincipalId field's value.
func (s *User) SetPrincipalId(v string) *User {
	s.PrincipalId = &v
	return s
}

// SetRole sets the Role field's value.
func (s *User) SetRole(v string) *User {
	s.Role = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *User) SetUserName(v string) *User {
	s.UserName = &v
	return s
}

// VPC connection properties.
type VpcConnectionProperties struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the VPC connection.
	//
	// VpcConnectionArn is a required field
	VpcConnectionArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s VpcConnectionProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VpcConnectionProperties) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VpcConnectionProperties) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VpcConnectionProperties"}
	if s.VpcConnectionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("VpcConnectionArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVpcConnectionArn sets the VpcConnectionArn field's value.
func (s *VpcConnectionProperties) SetVpcConnectionArn(v string) *VpcConnectionProperties {
	s.VpcConnectionArn = &v
	return s
}

const (
	// AssignmentStatusEnabled is a AssignmentStatus enum value
	AssignmentStatusEnabled = "ENABLED"

	// AssignmentStatusDraft is a AssignmentStatus enum value
	AssignmentStatusDraft = "DRAFT"

	// AssignmentStatusDisabled is a AssignmentStatus enum value
	AssignmentStatusDisabled = "DISABLED"
)

const (
	// ColumnDataTypeString is a ColumnDataType enum value
	ColumnDataTypeString = "STRING"

	// ColumnDataTypeInteger is a ColumnDataType enum value
	ColumnDataTypeInteger = "INTEGER"

	// ColumnDataTypeDecimal is a ColumnDataType enum value
	ColumnDataTypeDecimal = "DECIMAL"

	// ColumnDataTypeDatetime is a ColumnDataType enum value
	ColumnDataTypeDatetime = "DATETIME"
)

const (
	// DashboardBehaviorEnabled is a DashboardBehavior enum value
	DashboardBehaviorEnabled = "ENABLED"

	// DashboardBehaviorDisabled is a DashboardBehavior enum value
	DashboardBehaviorDisabled = "DISABLED"
)

const (
	// DashboardErrorTypeDataSetNotFound is a DashboardErrorType enum value
	DashboardErrorTypeDataSetNotFound = "DATA_SET_NOT_FOUND"

	// DashboardErrorTypeInternalFailure is a DashboardErrorType enum value
	DashboardErrorTypeInternalFailure = "INTERNAL_FAILURE"

	// DashboardErrorTypeParameterValueIncompatible is a DashboardErrorType enum value
	DashboardErrorTypeParameterValueIncompatible = "PARAMETER_VALUE_INCOMPATIBLE"

	// DashboardErrorTypeParameterTypeInvalid is a DashboardErrorType enum value
	DashboardErrorTypeParameterTypeInvalid = "PARAMETER_TYPE_INVALID"

	// DashboardErrorTypeParameterNotFound is a DashboardErrorType enum value
	DashboardErrorTypeParameterNotFound = "PARAMETER_NOT_FOUND"

	// DashboardErrorTypeColumnTypeMismatch is a DashboardErrorType enum value
	DashboardErrorTypeColumnTypeMismatch = "COLUMN_TYPE_MISMATCH"

	// DashboardErrorTypeColumnGeographicRoleMismatch is a DashboardErrorType enum value
	DashboardErrorTypeColumnGeographicRoleMismatch = "COLUMN_GEOGRAPHIC_ROLE_MISMATCH"

	// DashboardErrorTypeColumnReplacementMissing is a DashboardErrorType enum value
	DashboardErrorTypeColumnReplacementMissing = "COLUMN_REPLACEMENT_MISSING"
)

const (
	// DashboardUIStateExpanded is a DashboardUIState enum value
	DashboardUIStateExpanded = "EXPANDED"

	// DashboardUIStateCollapsed is a DashboardUIState enum value
	DashboardUIStateCollapsed = "COLLAPSED"
)

const (
	// DataSetImportModeSpice is a DataSetImportMode enum value
	DataSetImportModeSpice = "SPICE"

	// DataSetImportModeDirectQuery is a DataSetImportMode enum value
	DataSetImportModeDirectQuery = "DIRECT_QUERY"
)

const (
	// DataSourceErrorInfoTypeTimeout is a DataSourceErrorInfoType enum value
	DataSourceErrorInfoTypeTimeout = "TIMEOUT"

	// DataSourceErrorInfoTypeEngineVersionNotSupported is a DataSourceErrorInfoType enum value
	DataSourceErrorInfoTypeEngineVersionNotSupported = "ENGINE_VERSION_NOT_SUPPORTED"

	// DataSourceErrorInfoTypeUnknownHost is a DataSourceErrorInfoType enum value
	DataSourceErrorInfoTypeUnknownHost = "UNKNOWN_HOST"

	// DataSourceErrorInfoTypeGenericSqlFailure is a DataSourceErrorInfoType enum value
	DataSourceErrorInfoTypeGenericSqlFailure = "GENERIC_SQL_FAILURE"

	// DataSourceErrorInfoTypeConflict is a DataSourceErrorInfoType enum value
	DataSourceErrorInfoTypeConflict = "CONFLICT"

	// DataSourceErrorInfoTypeUnknown is a DataSourceErrorInfoType enum value
	DataSourceErrorInfoTypeUnknown = "UNKNOWN"
)

const (
	// DataSourceTypeAdobeAnalytics is a DataSourceType enum value
	DataSourceTypeAdobeAnalytics = "ADOBE_ANALYTICS"

	// DataSourceTypeAmazonElasticsearch is a DataSourceType enum value
	DataSourceTypeAmazonElasticsearch = "AMAZON_ELASTICSEARCH"

	// DataSourceTypeAthena is a DataSourceType enum value
	DataSourceTypeAthena = "ATHENA"

	// DataSourceTypeAurora is a DataSourceType enum value
	DataSourceTypeAurora = "AURORA"

	// DataSourceTypeAuroraPostgresql is a DataSourceType enum value
	DataSourceTypeAuroraPostgresql = "AURORA_POSTGRESQL"

	// DataSourceTypeAwsIotAnalytics is a DataSourceType enum value
	DataSourceTypeAwsIotAnalytics = "AWS_IOT_ANALYTICS"

	// DataSourceTypeGithub is a DataSourceType enum value
	DataSourceTypeGithub = "GITHUB"

	// DataSourceTypeJira is a DataSourceType enum value
	DataSourceTypeJira = "JIRA"

	// DataSourceTypeMariadb is a DataSourceType enum value
	DataSourceTypeMariadb = "MARIADB"

	// DataSourceTypeMysql is a DataSourceType enum value
	DataSourceTypeMysql = "MYSQL"

	// DataSourceTypePostgresql is a DataSourceType enum value
	DataSourceTypePostgresql = "POSTGRESQL"

	// DataSourceTypePresto is a DataSourceType enum value
	DataSourceTypePresto = "PRESTO"

	// DataSourceTypeRedshift is a DataSourceType enum value
	DataSourceTypeRedshift = "REDSHIFT"

	// DataSourceTypeS3 is a DataSourceType enum value
	DataSourceTypeS3 = "S3"

	// DataSourceTypeSalesforce is a DataSourceType enum value
	DataSourceTypeSalesforce = "SALESFORCE"

	// DataSourceTypeServicenow is a DataSourceType enum value
	DataSourceTypeServicenow = "SERVICENOW"

	// DataSourceTypeSnowflake is a DataSourceType enum value
	DataSourceTypeSnowflake = "SNOWFLAKE"

	// DataSourceTypeSpark is a DataSourceType enum value
	DataSourceTypeSpark = "SPARK"

	// DataSourceTypeSqlserver is a DataSourceType enum value
	DataSourceTypeSqlserver = "SQLSERVER"

	// DataSourceTypeTeradata is a DataSourceType enum value
	DataSourceTypeTeradata = "TERADATA"

	// DataSourceTypeTwitter is a DataSourceType enum value
	DataSourceTypeTwitter = "TWITTER"
)

const (
	// ExceptionResourceTypeUser is a ExceptionResourceType enum value
	ExceptionResourceTypeUser = "USER"

	// ExceptionResourceTypeGroup is a ExceptionResourceType enum value
	ExceptionResourceTypeGroup = "GROUP"

	// ExceptionResourceTypeNamespace is a ExceptionResourceType enum value
	ExceptionResourceTypeNamespace = "NAMESPACE"

	// ExceptionResourceTypeAccountSettings is a ExceptionResourceType enum value
	ExceptionResourceTypeAccountSettings = "ACCOUNT_SETTINGS"

	// ExceptionResourceTypeIampolicyAssignment is a ExceptionResourceType enum value
	ExceptionResourceTypeIampolicyAssignment = "IAMPOLICY_ASSIGNMENT"

	// ExceptionResourceTypeDataSource is a ExceptionResourceType enum value
	ExceptionResourceTypeDataSource = "DATA_SOURCE"

	// ExceptionResourceTypeDataSet is a ExceptionResourceType enum value
	ExceptionResourceTypeDataSet = "DATA_SET"

	// ExceptionResourceTypeVpcConnection is a ExceptionResourceType enum value
	ExceptionResourceTypeVpcConnection = "VPC_CONNECTION"

	// ExceptionResourceTypeIngestion is a ExceptionResourceType enum value
	ExceptionResourceTypeIngestion = "INGESTION"
)

const (
	// FileFormatCsv is a FileFormat enum value
	FileFormatCsv = "CSV"

	// FileFormatTsv is a FileFormat enum value
	FileFormatTsv = "TSV"

	// FileFormatClf is a FileFormat enum value
	FileFormatClf = "CLF"

	// FileFormatElf is a FileFormat enum value
	FileFormatElf = "ELF"

	// FileFormatXlsx is a FileFormat enum value
	FileFormatXlsx = "XLSX"

	// FileFormatJson is a FileFormat enum value
	FileFormatJson = "JSON"
)

const (
	// GeoSpatialCountryCodeUs is a GeoSpatialCountryCode enum value
	GeoSpatialCountryCodeUs = "US"
)

const (
	// GeoSpatialDataRoleCountry is a GeoSpatialDataRole enum value
	GeoSpatialDataRoleCountry = "COUNTRY"

	// GeoSpatialDataRoleState is a GeoSpatialDataRole enum value
	GeoSpatialDataRoleState = "STATE"

	// GeoSpatialDataRoleCounty is a GeoSpatialDataRole enum value
	GeoSpatialDataRoleCounty = "COUNTY"

	// GeoSpatialDataRoleCity is a GeoSpatialDataRole enum value
	GeoSpatialDataRoleCity = "CITY"

	// GeoSpatialDataRolePostcode is a GeoSpatialDataRole enum value
	GeoSpatialDataRolePostcode = "POSTCODE"

	// GeoSpatialDataRoleLongitude is a GeoSpatialDataRole enum value
	GeoSpatialDataRoleLongitude = "LONGITUDE"

	// GeoSpatialDataRoleLatitude is a GeoSpatialDataRole enum value
	GeoSpatialDataRoleLatitude = "LATITUDE"
)

const (
	// IdentityTypeIam is a IdentityType enum value
	IdentityTypeIam = "IAM"

	// IdentityTypeQuicksight is a IdentityType enum value
	IdentityTypeQuicksight = "QUICKSIGHT"
)

const (
	// IngestionErrorTypeFailureToAssumeRole is a IngestionErrorType enum value
	IngestionErrorTypeFailureToAssumeRole = "FAILURE_TO_ASSUME_ROLE"

	// IngestionErrorTypeIngestionSuperseded is a IngestionErrorType enum value
	IngestionErrorTypeIngestionSuperseded = "INGESTION_SUPERSEDED"

	// IngestionErrorTypeIngestionCanceled is a IngestionErrorType enum value
	IngestionErrorTypeIngestionCanceled = "INGESTION_CANCELED"

	// IngestionErrorTypeDataSetDeleted is a IngestionErrorType enum value
	IngestionErrorTypeDataSetDeleted = "DATA_SET_DELETED"

	// IngestionErrorTypeDataSetNotSpice is a IngestionErrorType enum value
	IngestionErrorTypeDataSetNotSpice = "DATA_SET_NOT_SPICE"

	// IngestionErrorTypeS3UploadedFileDeleted is a IngestionErrorType enum value
	IngestionErrorTypeS3UploadedFileDeleted = "S3_UPLOADED_FILE_DELETED"

	// IngestionErrorTypeS3ManifestError is a IngestionErrorType enum value
	IngestionErrorTypeS3ManifestError = "S3_MANIFEST_ERROR"

	// IngestionErrorTypeDataToleranceException is a IngestionErrorType enum value
	IngestionErrorTypeDataToleranceException = "DATA_TOLERANCE_EXCEPTION"

	// IngestionErrorTypeSpiceTableNotFound is a IngestionErrorType enum value
	IngestionErrorTypeSpiceTableNotFound = "SPICE_TABLE_NOT_FOUND"

	// IngestionErrorTypeDataSetSizeLimitExceeded is a IngestionErrorType enum value
	IngestionErrorTypeDataSetSizeLimitExceeded = "DATA_SET_SIZE_LIMIT_EXCEEDED"

	// IngestionErrorTypeRowSizeLimitExceeded is a IngestionErrorType enum value
	IngestionErrorTypeRowSizeLimitExceeded = "ROW_SIZE_LIMIT_EXCEEDED"

	// IngestionErrorTypeAccountCapacityLimitExceeded is a IngestionErrorType enum value
	IngestionErrorTypeAccountCapacityLimitExceeded = "ACCOUNT_CAPACITY_LIMIT_EXCEEDED"

	// IngestionErrorTypeCustomerError is a IngestionErrorType enum value
	IngestionErrorTypeCustomerError = "CUSTOMER_ERROR"

	// IngestionErrorTypeDataSourceNotFound is a IngestionErrorType enum value
	IngestionErrorTypeDataSourceNotFound = "DATA_SOURCE_NOT_FOUND"

	// IngestionErrorTypeIamRoleNotAvailable is a IngestionErrorType enum value
	IngestionErrorTypeIamRoleNotAvailable = "IAM_ROLE_NOT_AVAILABLE"

	// IngestionErrorTypeConnectionFailure is a IngestionErrorType enum value
	IngestionErrorTypeConnectionFailure = "CONNECTION_FAILURE"

	// IngestionErrorTypeSqlTableNotFound is a IngestionErrorType enum value
	IngestionErrorTypeSqlTableNotFound = "SQL_TABLE_NOT_FOUND"

	// IngestionErrorTypePermissionDenied is a IngestionErrorType enum value
	IngestionErrorTypePermissionDenied = "PERMISSION_DENIED"

	// IngestionErrorTypeSslCertificateValidationFailure is a IngestionErrorType enum value
	IngestionErrorTypeSslCertificateValidationFailure = "SSL_CERTIFICATE_VALIDATION_FAILURE"

	// IngestionErrorTypeOauthTokenFailure is a IngestionErrorType enum value
	IngestionErrorTypeOauthTokenFailure = "OAUTH_TOKEN_FAILURE"

	// IngestionErrorTypeSourceApiLimitExceededFailure is a IngestionErrorType enum value
	IngestionErrorTypeSourceApiLimitExceededFailure = "SOURCE_API_LIMIT_EXCEEDED_FAILURE"

	// IngestionErrorTypePasswordAuthenticationFailure is a IngestionErrorType enum value
	IngestionErrorTypePasswordAuthenticationFailure = "PASSWORD_AUTHENTICATION_FAILURE"

	// IngestionErrorTypeSqlSchemaMismatchError is a IngestionErrorType enum value
	IngestionErrorTypeSqlSchemaMismatchError = "SQL_SCHEMA_MISMATCH_ERROR"

	// IngestionErrorTypeInvalidDateFormat is a IngestionErrorType enum value
	IngestionErrorTypeInvalidDateFormat = "INVALID_DATE_FORMAT"

	// IngestionErrorTypeInvalidDataprepSyntax is a IngestionErrorType enum value
	IngestionErrorTypeInvalidDataprepSyntax = "INVALID_DATAPREP_SYNTAX"

	// IngestionErrorTypeSourceResourceLimitExceeded is a IngestionErrorType enum value
	IngestionErrorTypeSourceResourceLimitExceeded = "SOURCE_RESOURCE_LIMIT_EXCEEDED"

	// IngestionErrorTypeSqlInvalidParameterValue is a IngestionErrorType enum value
	IngestionErrorTypeSqlInvalidParameterValue = "SQL_INVALID_PARAMETER_VALUE"

	// IngestionErrorTypeQueryTimeout is a IngestionErrorType enum value
	IngestionErrorTypeQueryTimeout = "QUERY_TIMEOUT"

	// IngestionErrorTypeSqlNumericOverflow is a IngestionErrorType enum value
	IngestionErrorTypeSqlNumericOverflow = "SQL_NUMERIC_OVERFLOW"

	// IngestionErrorTypeUnresolvableHost is a IngestionErrorType enum value
	IngestionErrorTypeUnresolvableHost = "UNRESOLVABLE_HOST"

	// IngestionErrorTypeUnroutableHost is a IngestionErrorType enum value
	IngestionErrorTypeUnroutableHost = "UNROUTABLE_HOST"

	// IngestionErrorTypeSqlException is a IngestionErrorType enum value
	IngestionErrorTypeSqlException = "SQL_EXCEPTION"

	// IngestionErrorTypeS3FileInaccessible is a IngestionErrorType enum value
	IngestionErrorTypeS3FileInaccessible = "S3_FILE_INACCESSIBLE"

	// IngestionErrorTypeIotFileNotFound is a IngestionErrorType enum value
	IngestionErrorTypeIotFileNotFound = "IOT_FILE_NOT_FOUND"

	// IngestionErrorTypeIotDataSetFileEmpty is a IngestionErrorType enum value
	IngestionErrorTypeIotDataSetFileEmpty = "IOT_DATA_SET_FILE_EMPTY"

	// IngestionErrorTypeInvalidDataSourceConfig is a IngestionErrorType enum value
	IngestionErrorTypeInvalidDataSourceConfig = "INVALID_DATA_SOURCE_CONFIG"

	// IngestionErrorTypeDataSourceAuthFailed is a IngestionErrorType enum value
	IngestionErrorTypeDataSourceAuthFailed = "DATA_SOURCE_AUTH_FAILED"

	// IngestionErrorTypeDataSourceConnectionFailed is a IngestionErrorType enum value
	IngestionErrorTypeDataSourceConnectionFailed = "DATA_SOURCE_CONNECTION_FAILED"

	// IngestionErrorTypeFailureToProcessJsonFile is a IngestionErrorType enum value
	IngestionErrorTypeFailureToProcessJsonFile = "FAILURE_TO_PROCESS_JSON_FILE"

	// IngestionErrorTypeInternalServiceError is a IngestionErrorType enum value
	IngestionErrorTypeInternalServiceError = "INTERNAL_SERVICE_ERROR"
)

const (
	// IngestionRequestSourceManual is a IngestionRequestSource enum value
	IngestionRequestSourceManual = "MANUAL"

	// IngestionRequestSourceScheduled is a IngestionRequestSource enum value
	IngestionRequestSourceScheduled = "SCHEDULED"
)

const (
	// IngestionRequestTypeInitialIngestion is a IngestionRequestType enum value
	IngestionRequestTypeInitialIngestion = "INITIAL_INGESTION"

	// IngestionRequestTypeEdit is a IngestionRequestType enum value
	IngestionRequestTypeEdit = "EDIT"

	// IngestionRequestTypeIncrementalRefresh is a IngestionRequestType enum value
	IngestionRequestTypeIncrementalRefresh = "INCREMENTAL_REFRESH"

	// IngestionRequestTypeFullRefresh is a IngestionRequestType enum value
	IngestionRequestTypeFullRefresh = "FULL_REFRESH"
)

const (
	// IngestionStatusInitialized is a IngestionStatus enum value
	IngestionStatusInitialized = "INITIALIZED"

	// IngestionStatusQueued is a IngestionStatus enum value
	IngestionStatusQueued = "QUEUED"

	// IngestionStatusRunning is a IngestionStatus enum value
	IngestionStatusRunning = "RUNNING"

	// IngestionStatusFailed is a IngestionStatus enum value
	IngestionStatusFailed = "FAILED"

	// IngestionStatusCompleted is a IngestionStatus enum value
	IngestionStatusCompleted = "COMPLETED"

	// IngestionStatusCancelled is a IngestionStatus enum value
	IngestionStatusCancelled = "CANCELLED"
)

const (
	// InputColumnDataTypeString is a InputColumnDataType enum value
	InputColumnDataTypeString = "STRING"

	// InputColumnDataTypeInteger is a InputColumnDataType enum value
	InputColumnDataTypeInteger = "INTEGER"

	// InputColumnDataTypeDecimal is a InputColumnDataType enum value
	InputColumnDataTypeDecimal = "DECIMAL"

	// InputColumnDataTypeDatetime is a InputColumnDataType enum value
	InputColumnDataTypeDatetime = "DATETIME"

	// InputColumnDataTypeBit is a InputColumnDataType enum value
	InputColumnDataTypeBit = "BIT"

	// InputColumnDataTypeBoolean is a InputColumnDataType enum value
	InputColumnDataTypeBoolean = "BOOLEAN"

	// InputColumnDataTypeJson is a InputColumnDataType enum value
	InputColumnDataTypeJson = "JSON"
)

const (
	// JoinTypeInner is a JoinType enum value
	JoinTypeInner = "INNER"

	// JoinTypeOuter is a JoinType enum value
	JoinTypeOuter = "OUTER"

	// JoinTypeLeft is a JoinType enum value
	JoinTypeLeft = "LEFT"

	// JoinTypeRight is a JoinType enum value
	JoinTypeRight = "RIGHT"
)

const (
	// ResourceStatusCreationInProgress is a ResourceStatus enum value
	ResourceStatusCreationInProgress = "CREATION_IN_PROGRESS"

	// ResourceStatusCreationSuccessful is a ResourceStatus enum value
	ResourceStatusCreationSuccessful = "CREATION_SUCCESSFUL"

	// ResourceStatusCreationFailed is a ResourceStatus enum value
	ResourceStatusCreationFailed = "CREATION_FAILED"

	// ResourceStatusUpdateInProgress is a ResourceStatus enum value
	ResourceStatusUpdateInProgress = "UPDATE_IN_PROGRESS"

	// ResourceStatusUpdateSuccessful is a ResourceStatus enum value
	ResourceStatusUpdateSuccessful = "UPDATE_SUCCESSFUL"

	// ResourceStatusUpdateFailed is a ResourceStatus enum value
	ResourceStatusUpdateFailed = "UPDATE_FAILED"
)

const (
	// RowLevelPermissionPolicyGrantAccess is a RowLevelPermissionPolicy enum value
	RowLevelPermissionPolicyGrantAccess = "GRANT_ACCESS"

	// RowLevelPermissionPolicyDenyAccess is a RowLevelPermissionPolicy enum value
	RowLevelPermissionPolicyDenyAccess = "DENY_ACCESS"
)

const (
	// TemplateErrorTypeDataSetNotFound is a TemplateErrorType enum value
	TemplateErrorTypeDataSetNotFound = "DATA_SET_NOT_FOUND"

	// TemplateErrorTypeInternalFailure is a TemplateErrorType enum value
	TemplateErrorTypeInternalFailure = "INTERNAL_FAILURE"
)

const (
	// TextQualifierDoubleQuote is a TextQualifier enum value
	TextQualifierDoubleQuote = "DOUBLE_QUOTE"

	// TextQualifierSingleQuote is a TextQualifier enum value
	TextQualifierSingleQuote = "SINGLE_QUOTE"
)

const (
	// UserRoleAdmin is a UserRole enum value
	UserRoleAdmin = "ADMIN"

	// UserRoleAuthor is a UserRole enum value
	UserRoleAuthor = "AUTHOR"

	// UserRoleReader is a UserRole enum value
	UserRoleReader = "READER"

	// UserRoleRestrictedAuthor is a UserRole enum value
	UserRoleRestrictedAuthor = "RESTRICTED_AUTHOR"

	// UserRoleRestrictedReader is a UserRole enum value
	UserRoleRestrictedReader = "RESTRICTED_READER"
)
