## helm list

List releases

### Synopsis


This command lists all of the releases.

By default, it lists only releases that are deployed or failed. Flags like
'--deleted' and '--all' will alter this behavior. Such flags can be combined:
'--deleted --failed'.

By default, items are sorted alphabetically. Use the '-d' flag to sort by
release date.

If an argument is provided, it will be treated as a filter. Filters are
regular expressions (Perl compatible) that are applied to the list of releases.
Only items that match the filter will be returned.

	$ helm list 'ara[a-z]+'
	NAME            	UPDATED                 	CHART
	maudlin-arachnid	Mon May  9 16:07:08 2016	alpine-0.1.0

If no results are found, 'helm list' will exit 0, but with no output (or in
the case of no '-q' flag, only headers).

By default, up to 256 items may be returned. To limit this, use the '--max' flag.
Setting '--max' to 0 will not return all results. Rather, it will return the
server's default, which may be much higher than 256. Pairing the '--max'
flag with the '--offset' flag allows you to page through results.


```
helm list [flags] [FILTER]
```

### Options

```
  -a, --all                   Show all releases, not just the ones marked DEPLOYED
  -c, --chart-name            Sort by chart name
      --col-width uint        Specifies the max column width of output (default 60)
  -d, --date                  Sort by release date
      --deleted               Show deleted releases
      --deleting              Show releases that are currently being deleted
      --deployed              Show deployed releases. If no other is specified, this will be automatically enabled
      --failed                Show failed releases
  -h, --help                  help for list
  -m, --max int               Maximum number of releases to fetch (default 256)
      --namespace string      Show releases within a specific namespace
  -o, --offset string         Next release name in the list, used to offset from start value
      --output string         Output the specified format (json or yaml)
      --pending               Show pending releases
  -r, --reverse               Reverse the sort order
  -q, --short                 Output short (quiet) listing format
      --tls                   Enable TLS for request
      --tls-ca-cert string    Path to TLS CA certificate file (default "$HELM_HOME/ca.pem")
      --tls-cert string       Path to TLS certificate file (default "$HELM_HOME/cert.pem")
      --tls-hostname string   The server name used to verify the hostname on the returned certificates from the server
      --tls-key string        Path to TLS key file (default "$HELM_HOME/key.pem")
      --tls-verify            Enable TLS for request and verify remote
```

### Options inherited from parent commands

```
      --debug                           Enable verbose output
      --home string                     Location of your Helm config. Overrides $HELM_HOME (default "~/.helm")
      --host string                     Address of Tiller. Overrides $HELM_HOST
      --kube-context string             Name of the kubeconfig context to use
      --kubeconfig string               Absolute path of the kubeconfig file to be used
      --tiller-connection-timeout int   The duration (in seconds) Helm will wait to establish a connection to Tiller (default 300)
      --tiller-namespace string         Namespace of Tiller (default "kube-system")
```

### SEE ALSO

* [helm](helm.md)	 - The Helm package manager for Kubernetes.

###### Auto generated by spf13/cobra on 16-May-2019
