**Note:** Impatient readers may head straight to [Quick
Start](quick-start.md).

**Using Kubebuilder v1? Check the [legacy
documentation](https://book-v1.book.kubebuilder.io)**

## Who is this for

#### Users of Kubernetes

Users of Kubernetes will develop a deeper understanding of Kubernetes through learning
the fundamental concepts behind how APIs are designed and implemented.  This book
will teach readers how to develop their own Kubernetes APIs and the
principles from which the core Kubernetes APIs are designed.

Including:

- The structure of Kubernetes APIs and Resources
- API versioning semantics
- Self-healing
- Garbage Collection and Finalizers
- Declarative vs Imperative APIs
- Level-Based vs Edge-Base APIs
- Resources vs Subresources

#### Kubernetes API extension developers

API extension developers will learn the principals and concepts behind implementing canonical
Kubernetes APIs, as well as simple tools and libraries for rapid execution.  This
book covers pitfalls and misconceptions that extension developers commonly encounter.

Including:

- How to batch multiple events into a single reconciliation call
- How to configure periodic reconciliation
- *Forthcoming*
    - When to use the lister cache vs live lookups
    - Garbage Collection vs Finalizers
    - How to use Declarative vs Webhook Validation
    - How to implement API versioning

## Contribution

If you like to contribute to either this book or the code, please be so kind
to read our [Contribution](https://github.com/kubernetes-sigs/kubebuilder/blob/master/CONTRIBUTING.md) guidelines first.

## Resources

* Repository: [sigs.k8s.io/kubebuilder](https://sigs.k8s.io/kubebuilder)

* Slack channel: [#kubebuilder](http://slack.k8s.io/#kubebuilder)

* Google Group:
  [kubebuilder@googlegroups.com](https://groups.google.com/forum/#!forum/kubebuilder)
