# Kubebuilder v0 v.s. v1

Kubebuilder 1.0 adds a new flag `--project-version`, it accepts two different values, `v0` and `v1`. When `v0` is used, the kubebuilder behavior and workflow is the same as kubebuilder 0.*. When `v1` is specified, the generated v1 project layout is architecturally different from v0 project. v1 project uses [controller-runtime](https://github.com/kubernetes-sigs/controller-runtime) set of libraries for controller implementation and used tools under [controller-tools](https://github.com/kubernetes-sigs/controller-tools) for scaffolding and generation. 


## Command difference
  - kubebuilder v0 has `init`, `create controller`, `create resource`, `create config`, `generate` commands and the workflow is:

```
  kubebuilder init --domain example.com
  kubebuilder create resource --group <group> --version <version> --kind <Kind>
  GOBIN=${PWD}/bin go install ${PWD#$GOPATH/src/}/cmd/controller-manager
  bin/controller-manager --kubeconfig ~/.kube/config

  kubectl apply -f hack/sample/<resource>.yaml
  docker build -f Dockerfile.controller . -t <image:tag>
  docker push <image:tag>
  kubebuilder create config --controller-image <image:tag> --name <project-name>
  kubectl apply -f hack/install.yaml
```

  Every time the resource or controller is updated, users need to run `kubebuilder generate` to regenerate the project.
  - kubebuilder v1 has `init`, `create api` commands and the workflow is
  
```
  kubebuilder init --domain example.com --license apache2 --owner "The Kubernetes authors"
  kubebuilder create api --group ship --version v1beta1 --kind Frigate
  make install
  make run
```
  
  In a v1 project, there is no generate command. When the resource or controller is updated, users don't need to regenerate the project.

## Scaffolding difference

- v0 project contains a directory `pkg/client` while v1 project doesn't
- v0 project contains a directory `inject` while v1 project doesn't
- v0 project layout follows predefined directory layout `pkg/apis` and `pkg/controller` while v1 project accepts user specified path
- In v1 project, there is a `init()` function for every api and controller.
  
## Library difference
### Controller libraries
  - v0 projects import the controller library from kubebuilder `kubebuilder/pkg/controller`. It provides a `GenericController` type with a list of functions. 
  
  - v1 projects import the controller libraries from controller-runtime, such as `controller-runtime/pkg/controller`, `controller-runtime/pkg/reconcile`.
  
### Client libraries
  
  - In v0 projects, the client libraries is generated by `kubebuilder generate` under directory `pkg/client` and imported wherever they are used in the project.
  
  - v1 projects import the dynamic client library from controller-runtime `controller-runtime/pkg/client`.
    
## Wiring difference
Wiring refers to the mechanics of integrating controllers to controller-manager and injecting the dependencies in them. 
  - v0 projects have a `inject` package and it provides functions for adding the controller to controller-manager as well as registering CRDs.
  - v1 projects don't have a `inject` package, the controller is added to controller-manager by a `init` function inside add_<type>.go file inside the controller directory. The types are registered by a `init` function inside <type>_types.go file inside the apis directory.