# Resource Management With Kubectl

## Background Information

* [Getting Started with Kubectl](pages/kubectl_book/getting_started.md)
* [Resources + Controllers Overview](pages/kubectl_book/resources_and_controllers.md)

## App Management

* [Introduction](pages/app_management/introduction.md)
* [Apply](pages/app_management/apply.md)
* [Secrets and ConfigMaps](pages/app_management/secrets_and_configmaps.md)
* [Container Images](pages/app_management/container_images.md)      
* [Namespaces and Names](pages/app_management/namespaces_and_names.md)
* [Labels and Annotations](pages/app_management/labels_and_annotations.md)
* [Field Merge Semantics](pages/app_management/field_merge_semantics.md)

## Resource Printing

* [Summaries](pages/resource_printing/summaries.md)
* [Raw](pages/resource_printing/raw.md)
* [Fields](pages/resource_printing/fields.md)
* [Describe](pages/resource_printing/describe.md)
* [Queries and Options](pages/resource_printing/queries_and_options.md)
* [Watch](pages/resource_printing/watch.md)
* [Cluster Information](pages/resource_printing/cluster_information.md)

## Container Debugging

* [Container Logs](pages/container_debugging/container_logs.md)
* [Copying Container Files](pages/container_debugging/copying_container_files.md)
* [Executing a Command in a Container](pages/container_debugging/executing_a_command_in_a_container.md)
* [Port Forward to Pods](pages/container_debugging/port_forward_to_pods.md)
* [Proxying Traffic to Services](pages/container_debugging/proxying_traffic_to_services.md)

## App Customization

* [Introduction](pages/app_customization/introduction.md)
* [Bases and Variations](pages/app_customization/bases_and_variants.md)
* [Customizing Pod Templates](pages/app_customization/customizing_pod_templates.md)
* [Customizing Arbitrary Fields](pages/app_customization/customizing_arbitrary_fields.md)
* [Config Reflection](pages/app_customization/config_reflection.md)

## App Structure

* [Introduction](pages/app_composition_and_deployment/structure_introduction.md)
* [Directory Layout](pages/app_composition_and_deployment/structure_directories.md)
* [Branches Layout](pages/app_composition_and_deployment/structure_branches.md)
* [Repository Layout](pages/app_composition_and_deployment/structure_repositories.md)
* [Shared Base Layout](pages/app_composition_and_deployment/structure_multi_tier_apps.md)

## App Deployment

* [Diffing Local and Remote State](pages/app_composition_and_deployment/diffing_local_and_remote_resources.md)
* [Accessing Multiple Clusters](pages/app_composition_and_deployment/accessing_multiple_clusters.md)
* [Publishing Config](pages/app_composition_and_deployment/publishing_bases.md)

## Reference

* [kustomization.yaml](pages/reference/kustomize.md)

## Examples

* [kustomization.yaml](pages/examples/kustomize.md)

## Miscellaneous Imperative Commands

* [Introduction](pages/imperative_porcelain/introduction.md)
* [Creating Resources](pages/imperative_porcelain/creating_resources.md)
* [Setting Fields](pages/imperative_porcelain/setting_fields.md)
* [Editing Workloads](pages/imperative_porcelain/editing_workloads.md)