'use strict';var _path = require('path');var _path2 = _interopRequireDefault(_path);
var _readPkgUp = require('read-pkg-up');var _readPkgUp2 = _interopRequireDefault(_readPkgUp);

var _resolve = require('eslint-module-utils/resolve');var _resolve2 = _interopRequireDefault(_resolve);
var _moduleVisitor = require('eslint-module-utils/moduleVisitor');var _moduleVisitor2 = _interopRequireDefault(_moduleVisitor);
var _importType = require('../core/importType');var _importType2 = _interopRequireDefault(_importType);
var _docsUrl = require('../docsUrl');var _docsUrl2 = _interopRequireDefault(_docsUrl);function _interopRequireDefault(obj) {return obj && obj.__esModule ? obj : { default: obj };}

function findNamedPackage(filePath) {
  const found = _readPkgUp2.default.sync({ cwd: filePath, normalize: false });
  if (found.pkg && !found.pkg.name) {
    return findNamedPackage(_path2.default.join(found.path, '../..'));
  }
  return found;
}

function checkImportForRelativePackage(context, importPath, node) {
  const potentialViolationTypes = ['parent', 'index', 'sibling'];
  if (potentialViolationTypes.indexOf((0, _importType2.default)(importPath, context)) === -1) {
    return;
  }

  const resolvedImport = (0, _resolve2.default)(importPath, context);
  const resolvedContext = context.getFilename();

  if (!resolvedImport || !resolvedContext) {
    return;
  }

  const importPkg = findNamedPackage(resolvedImport);
  const contextPkg = findNamedPackage(resolvedContext);

  if (importPkg.pkg && contextPkg.pkg && importPkg.pkg.name !== contextPkg.pkg.name) {
    const importBaseName = _path2.default.basename(importPath);
    const importRoot = _path2.default.dirname(importPkg.path);
    const properPath = _path2.default.relative(importRoot, resolvedImport);
    const properImport = _path2.default.join(
    importPkg.pkg.name,
    _path2.default.dirname(properPath),
    importBaseName === _path2.default.basename(importRoot) ? '' : importBaseName);

    context.report({
      node,
      message: `Relative import from another package is not allowed. Use \`${properImport}\` instead of \`${importPath}\`` });

  }
}

module.exports = {
  meta: {
    type: 'suggestion',
    docs: {
      url: (0, _docsUrl2.default)('no-relative-packages') },

    schema: [(0, _moduleVisitor.makeOptionsSchema)()] },


  create(context) {
    return (0, _moduleVisitor2.default)(source => checkImportForRelativePackage(context, source.value, source), context.options[0]);
  } };
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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