function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

/**
 * Counterpart to `normalize` for a collection of rows. This method unravels the
 * normalization step that we use to build the given parameters in order to
 * return a natural interface to working with rows for a consumer.
 *
 * The default heuristic here is to map through all the row ids and return the
 * value of the row for the given id, in addition to adding a `cells` key that
 * contains the results of mapping over the rows cells and getting individual
 * cell info.
 *
 * @param {Array<string>} rowIds array of row ids in the table
 * @param {Object} rowsById object containing lookups for rows by id
 * @param {Object} cellsById object containing lookups for cells by id
 */
var denormalize = function denormalize(rowIds, rowsById, cellsById) {
  return rowIds.map(function (id) {
    return _extends({}, rowsById[id], {
      cells: rowsById[id].cells.map(function (cellId) {
        return cellsById[cellId];
      })
    });
  });
};

export default denormalize;