function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

import cx from 'classnames';
import PropTypes from 'prop-types';
import React from 'react';
import Downshift from 'downshift';
import ListBox from '../ListBox';
import Checkbox from '../Checkbox';
import Selection from '../../internal/Selection';
import { sortingPropTypes } from './MultiSelectPropTypes';
import { defaultItemToString } from './tools/itemToString';
import { defaultSortItems, defaultCompareItems } from './tools/sorting';
import { defaultFilterItems } from '../ComboBox/tools/filter';

var FilterableMultiSelect =
/*#__PURE__*/
function (_React$Component) {
  _inherits(FilterableMultiSelect, _React$Component);

  function FilterableMultiSelect(props) {
    var _this;

    _classCallCheck(this, FilterableMultiSelect);

    _this = _possibleConstructorReturn(this, (FilterableMultiSelect.__proto__ || Object.getPrototypeOf(FilterableMultiSelect)).call(this, props));
    Object.defineProperty(_assertThisInitialized(_this), "handleOnChange", {
      configurable: true,
      enumerable: true,
      writable: true,
      value: function value(changes) {
        if (_this.props.onChange) {
          _this.props.onChange(changes);
        }
      }
    });
    Object.defineProperty(_assertThisInitialized(_this), "handleOnToggleMenu", {
      configurable: true,
      enumerable: true,
      writable: true,
      value: function value() {
        _this.setState(function (state) {
          return {
            isOpen: !state.isOpen
          };
        });
      }
    });
    Object.defineProperty(_assertThisInitialized(_this), "handleOnOuterClick", {
      configurable: true,
      enumerable: true,
      writable: true,
      value: function value() {
        _this.setState({
          isOpen: false
        });
      }
    });
    Object.defineProperty(_assertThisInitialized(_this), "handleOnStateChange", {
      configurable: true,
      enumerable: true,
      writable: true,
      value: function value(changes) {
        var type = changes.type;

        switch (type) {
          case Downshift.stateChangeTypes.changeInput:
            _this.setState({
              inputValue: changes.inputValue
            });

            break;

          case Downshift.stateChangeTypes.keyDownArrowDown:
          case Downshift.stateChangeTypes.keyDownArrowUp:
          case Downshift.stateChangeTypes.itemMouseEnter:
            _this.setState({
              highlightedIndex: changes.highlightedIndex
            });

            break;

          case Downshift.stateChangeTypes.keyDownEscape:
          case Downshift.stateChangeTypes.mouseUp:
            _this.setState({
              isOpen: false
            });

            break;
          // Opt-in to some cases where we should be toggling the menu based on
          // a given key press or mouse handler
          // Reference: https://github.com/paypal/downshift/issues/206

          case Downshift.stateChangeTypes.clickButton:
          case Downshift.stateChangeTypes.keyDownSpaceButton:
            _this.setState(function () {
              var nextIsOpen = changes.isOpen;

              if (changes.isOpen === false) {
                // If Downshift is trying to close the menu, but we know the input
                // is the active element in thedocument, then keep the menu open
                if (_this.inputNode === document.activeElement) {
                  nextIsOpen = true;
                }
              }

              return {
                isOpen: nextIsOpen
              };
            });

            break;
        }
      }
    });
    Object.defineProperty(_assertThisInitialized(_this), "handleOnInputKeyDown", {
      configurable: true,
      enumerable: true,
      writable: true,
      value: function value(event) {
        event.stopPropagation();
      }
    });
    Object.defineProperty(_assertThisInitialized(_this), "handleOnInputValueChange", {
      configurable: true,
      enumerable: true,
      writable: true,
      value: function value(inputValue) {
        _this.setState(function () {
          if (Array.isArray(inputValue)) {
            return {
              inputValue: ''
            };
          }

          return {
            inputValue: inputValue || ''
          };
        });
      }
    });
    Object.defineProperty(_assertThisInitialized(_this), "clearInputValue", {
      configurable: true,
      enumerable: true,
      writable: true,
      value: function value(event) {
        event.stopPropagation();

        _this.setState({
          inputValue: ''
        });

        _this.inputNode && _this.inputNode.focus && _this.inputNode.focus();
      }
    });
    _this.state = {
      highlightedIndex: null,
      isOpen: false,
      inputValue: ''
    };
    return _this;
  }

  _createClass(FilterableMultiSelect, [{
    key: "render",
    value: function render() {
      var _this2 = this;

      var _state = this.state,
          highlightedIndex = _state.highlightedIndex,
          isOpen = _state.isOpen,
          inputValue = _state.inputValue;
      var _props = this.props,
          containerClassName = _props.className,
          disabled = _props.disabled,
          filterItems = _props.filterItems,
          items = _props.items,
          itemToString = _props.itemToString,
          initialSelectedItems = _props.initialSelectedItems,
          id = _props.id,
          locale = _props.locale,
          placeholder = _props.placeholder,
          sortItems = _props.sortItems,
          compareItems = _props.compareItems;
      var className = cx('bx--multi-select', 'bx--combo-box', containerClassName);
      return React.createElement(Selection, {
        onChange: this.handleOnChange,
        initialSelectedItems: initialSelectedItems,
        render: function render(_ref) {
          var selectedItems = _ref.selectedItems,
              onItemChange = _ref.onItemChange,
              clearSelection = _ref.clearSelection;
          return React.createElement(Downshift, {
            highlightedIndex: highlightedIndex,
            isOpen: isOpen,
            inputValue: inputValue,
            onInputValueChange: _this2.handleOnInputValueChange,
            onChange: onItemChange,
            itemToString: itemToString,
            onStateChange: _this2.handleOnStateChange,
            onOuterClick: _this2.handleOnOuterClick,
            selectedItem: selectedItems,
            render: function render(_ref2) {
              var getButtonProps = _ref2.getButtonProps,
                  getInputProps = _ref2.getInputProps,
                  getItemProps = _ref2.getItemProps,
                  getRootProps = _ref2.getRootProps,
                  isOpen = _ref2.isOpen,
                  inputValue = _ref2.inputValue,
                  selectedItem = _ref2.selectedItem;
              return React.createElement(ListBox, _extends({
                className: className,
                disabled: disabled
              }, getRootProps({
                refKey: 'innerRef'
              })), React.createElement(ListBox.Field, getButtonProps({
                disabled: disabled
              }), selectedItem.length > 0 && React.createElement(ListBox.Selection, {
                clearSelection: clearSelection,
                selectionCount: selectedItem.length
              }), React.createElement("input", _extends({
                className: "bx--text-input",
                ref: function ref(el) {
                  return _this2.inputNode = el;
                }
              }, getInputProps({
                disabled: disabled,
                id: id,
                placeholder: placeholder,
                onKeyDown: _this2.handleOnInputKeyDown
              }))), inputValue && isOpen && React.createElement(ListBox.Selection, {
                clearSelection: _this2.clearInputValue
              }), React.createElement(ListBox.MenuIcon, {
                isOpen: isOpen
              })), isOpen && React.createElement(ListBox.Menu, null, sortItems(filterItems(items, {
                itemToString: itemToString,
                inputValue: inputValue
              }), {
                selectedItems: selectedItems,
                itemToString: itemToString,
                compareItems: compareItems,
                locale: locale
              }).map(function (item, index) {
                var itemProps = getItemProps({
                  item: item
                });
                var itemText = itemToString(item);
                var isChecked = selectedItem.indexOf(item) !== -1;
                return React.createElement(ListBox.MenuItem, _extends({
                  key: itemProps.id,
                  isActive: selectedItem.indexOf(item) !== -1,
                  isHighlighted: highlightedIndex === index
                }, itemProps), React.createElement(Checkbox, {
                  id: itemProps.id,
                  name: itemText,
                  checked: isChecked,
                  readOnly: true,
                  tabIndex: "-1",
                  labelText: itemText
                }));
              })));
            }
          });
        }
      });
    }
  }]);

  return FilterableMultiSelect;
}(React.Component);

Object.defineProperty(FilterableMultiSelect, "propTypes", {
  configurable: true,
  enumerable: true,
  writable: true,
  value: _extends({}, sortingPropTypes, {
    /**
     * Disable the control
     */
    disabled: PropTypes.bool,

    /**
     * We try to stay as generic as possible here to allow individuals to pass
     * in a collection of whatever kind of data structure they prefer
     */
    items: PropTypes.array.isRequired,

    /**
     * Allow users to pass in arbitrary items from their collection that are
     * pre-selected
     */
    initialSelectedItems: PropTypes.array,

    /**
     * Helper function passed to downshift that allows the library to render a
     * given item to a string label. By default, it extracts the `label` field
     * from a given item to serve as the item label in the list.
     */
    itemToString: PropTypes.func,

    /**
     * Specify the locale of the control. Used for the default `compareItems`
     * used for sorting the list of items in the control.
     */
    locale: PropTypes.string,

    /**
     * `onChange` is a utility for this controlled component to communicate to a
     * consuming component what kind of internal state changes are occuring.
     */
    onChange: PropTypes.func,

    /**
     * Generic `placeholder` that will be used as the textual representation of
     * what this field is for
     */
    placeholder: PropTypes.string.isRequired
  })
});
Object.defineProperty(FilterableMultiSelect, "defaultProps", {
  configurable: true,
  enumerable: true,
  writable: true,
  value: {
    compareItems: defaultCompareItems,
    disabled: false,
    filterItems: defaultFilterItems,
    initialSelectedItems: [],
    itemToString: defaultItemToString,
    locale: 'en',
    sortItems: defaultSortItems
  }
});
export { FilterableMultiSelect as default };