function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

import PropTypes from 'prop-types';
import React, { Component } from 'react';
import classNames from 'classnames';
import ClickListener from '../../internal/ClickListener';
import FloatingMenu from '../../internal/FloatingMenu';
import OptimizedResize from '../../internal/OptimizedResize';
import Icon from '../Icon';
var matchesFuncName = typeof Element !== 'undefined' && ['matches', 'webkitMatchesSelector', 'msMatchesSelector'].filter(function (name) {
  return typeof Element.prototype[name] === 'function';
})[0];
/**
 * @param {Node} elem A DOM node.
 * @param {string} selector A CSS selector
 * @returns {boolean} `true` if the given DOM element is a element node and matches the given selector.
 * @private
 */

var matches = function matches(elem, selector) {
  return typeof elem[matchesFuncName] === 'function' && elem[matchesFuncName](selector);
};

var on = function on(element) {
  for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
    args[_key - 1] = arguments[_key];
  }

  element.addEventListener.apply(element, args);
  return {
    release: function release() {
      element.removeEventListener.apply(element, args);
      return null;
    }
  };
};
/**
 * @param {Element} menuBody The menu body with the menu arrow.
 * @returns {FloatingMenu~offset} The adjustment of the floating menu position, upon the position of the menu arrow.
 * @private
 */


var getMenuOffset = function getMenuOffset(menuBody) {
  var menuWidth = menuBody.offsetWidth;
  var arrowStyle = menuBody.ownerDocument.defaultView.getComputedStyle(menuBody, ':before');
  var values = ['top', 'left', 'width', 'height', 'border-top-width'].reduce(function (o, name) {
    return _extends({}, o, _defineProperty({}, name, Number((/^([\d-]+)px$/.exec(arrowStyle.getPropertyValue(name)) || [])[1])));
  }, {});

  if (Object.keys(values).every(function (name) {
    return !isNaN(values[name]);
  })) {
    var top = values.top,
        left = values.left,
        width = values.width,
        height = values.height,
        borderTopWidth = values['border-top-width'];
    return {
      left: menuWidth / 2 - (left + Math.sqrt(Math.pow(width, 2) + Math.pow(height, 2)) / 2),
      top: Math.sqrt(Math.pow(borderTopWidth, 2) * 2) - top
    };
  }
};

var OverflowMenu =
/*#__PURE__*/
function (_Component) {
  _inherits(OverflowMenu, _Component);

  function OverflowMenu() {
    var _ref;

    var _temp, _this;

    _classCallCheck(this, OverflowMenu);

    for (var _len2 = arguments.length, args = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
      args[_key2] = arguments[_key2];
    }

    return _possibleConstructorReturn(_this, (_temp = _this = _possibleConstructorReturn(this, (_ref = OverflowMenu.__proto__ || Object.getPrototypeOf(OverflowMenu)).call.apply(_ref, [this].concat(args))), Object.defineProperty(_assertThisInitialized(_this), "_hFocusIn", {
      configurable: true,
      enumerable: true,
      writable: true,
      value: null
    }), Object.defineProperty(_assertThisInitialized(_this), "state", {
      configurable: true,
      enumerable: true,
      writable: true,
      value: {
        /**
         * The open/closed state.
         * @type {boolean}
         */
        open: _this.props.open
      }
    }), Object.defineProperty(_assertThisInitialized(_this), "getMenuPosition", {
      configurable: true,
      enumerable: true,
      writable: true,
      value: function value() {
        if (_this.menuEl) {
          var menuPosition = _this.menuEl.getBoundingClientRect();

          _this.setState({
            menuPosition: menuPosition
          });
        }
      }
    }), Object.defineProperty(_assertThisInitialized(_this), "handleClick", {
      configurable: true,
      enumerable: true,
      writable: true,
      value: function value(evt) {
        _this.setState({
          open: !_this.state.open
        });

        _this.props.onClick(evt);
      }
    }), Object.defineProperty(_assertThisInitialized(_this), "handleKeyDown", {
      configurable: true,
      enumerable: true,
      writable: true,
      value: function value(evt) {
        if (evt.which === 40) {
          _this.setState({
            open: !_this.state.open
          });

          _this.props.onClick(evt);
        }
      }
    }), Object.defineProperty(_assertThisInitialized(_this), "handleKeyPress", {
      configurable: true,
      enumerable: true,
      writable: true,
      value: function value(evt) {
        // only respond to key events when the menu is closed, so that menu items still respond to key events
        if (!_this.state.open) {
          var key = evt.key || evt.which;

          if (key === 'Enter' || key === 13 || key === ' ' || key === 32) {
            _this.setState({
              open: true
            });
          }
        }
      }
    }), Object.defineProperty(_assertThisInitialized(_this), "handleClickOutside", {
      configurable: true,
      enumerable: true,
      writable: true,
      value: function value(evt) {
        if (!_this._menuBody || !_this._menuBody.contains(evt.target)) {
          _this.closeMenu();
        }
      }
    }), Object.defineProperty(_assertThisInitialized(_this), "closeMenu", {
      configurable: true,
      enumerable: true,
      writable: true,
      value: function value() {
        _this.setState({
          open: false
        });
      }
    }), Object.defineProperty(_assertThisInitialized(_this), "bindMenuEl", {
      configurable: true,
      enumerable: true,
      writable: true,
      value: function value(menuEl) {
        _this.menuEl = menuEl;
      }
    }), Object.defineProperty(_assertThisInitialized(_this), "_bindMenuBody", {
      configurable: true,
      enumerable: true,
      writable: true,
      value: function value(menuBody) {
        if (!menuBody) {
          _this._menuBody = menuBody;

          if (_this._hFocusIn) {
            _this._hFocusIn = _this._hFocusIn.release();
          }
        }
      }
    }), Object.defineProperty(_assertThisInitialized(_this), "_handlePlace", {
      configurable: true,
      enumerable: true,
      writable: true,
      value: function value(menuBody) {
        if (menuBody) {
          _this._menuBody = menuBody;
          (menuBody.querySelector('[data-floating-menu-primary-focus]') || menuBody).focus();
          var hasFocusin = 'onfocusin' in window;
          var focusinEventName = hasFocusin ? 'focusin' : 'focus';
          _this._hFocusIn = on(menuBody.ownerDocument, focusinEventName, function (event) {
            var target = event.target;

            if (!menuBody.contains(target)) {
              _this.closeMenu();

              if (_this.menuEl && !matches(target, '.bx--overflow-menu,.bx--overflow-menu-options')) {
                // Note:
                // The last focusable element in the page should NOT be the trigger button of overflow menu.
                // Doing so breaks the code that detects if floating menu losing focus, e.g. by keyboard events.
                _this.menuEl.focus();
              }
            }
          }, !hasFocusin);
        }
      }
    }), _temp));
  }

  _createClass(OverflowMenu, [{
    key: "shouldComponentUpdate",
    value: function shouldComponentUpdate(nextProps, nextState) {
      var _this2 = this;

      if (nextState.open && !this.state.open) {
        requestAnimationFrame(function () {
          _this2.getMenuPosition();
        });
        return false; // Let `.getMenuPosition()` cause render
      }

      return true;
    }
  }, {
    key: "componentDidMount",
    value: function componentDidMount() {
      var _this3 = this;

      requestAnimationFrame(function () {
        _this3.getMenuPosition();
      });
      this.hResize = OptimizedResize.add(function () {
        _this3.getMenuPosition();
      });
    }
  }, {
    key: "componentWillReceiveProps",
    value: function componentWillReceiveProps(nextProps) {
      if (nextProps.open !== this.props.open) {
        this.setState({
          open: nextProps.open
        });
      }
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      this.hResize.release();
    }
  }, {
    key: "render",
    value: function render() {
      var _this4 = this;

      var _props = this.props,
          id = _props.id,
          tabIndex = _props.tabIndex,
          ariaLabel = _props.ariaLabel,
          children = _props.children,
          iconDescription = _props.iconDescription,
          iconName = _props.iconName,
          flipped = _props.flipped,
          floatingMenu = _props.floatingMenu,
          menuOffset = _props.menuOffset,
          menuOffsetFlip = _props.menuOffsetFlip,
          iconClass = _props.iconClass,
          onClick = _props.onClick,
          renderIcon = _props.renderIcon,
          other = _objectWithoutProperties(_props, ["id", "tabIndex", "ariaLabel", "children", "iconDescription", "iconName", "flipped", "floatingMenu", "menuOffset", "menuOffsetFlip", "iconClass", "onClick", "renderIcon"]);

      var open = this.state.open;
      var overflowMenuClasses = classNames(this.props.className, 'bx--overflow-menu', {
        'bx--overflow-menu--open': open
      });
      var overflowMenuOptionsClasses = classNames('bx--overflow-menu-options', {
        'bx--overflow-menu--flip': this.props.flipped,
        'bx--overflow-menu-options--open': open
      });
      var overflowMenuIconClasses = classNames('bx--overflow-menu__icon', iconClass);
      var childrenWithProps = React.Children.toArray(children).map(function (child) {
        return React.cloneElement(child, {
          closeMenu: _this4.closeMenu
        });
      });
      var menuBody = React.createElement("ul", {
        className: overflowMenuOptionsClasses,
        tabIndex: "-1",
        ref: !floatingMenu && this._bindMenuBody
      }, childrenWithProps);
      var wrappedMenuBody = !floatingMenu ? menuBody : React.createElement("div", {
        role: "menuitem"
      }, React.createElement(FloatingMenu, {
        menuPosition: this.state.menuPosition,
        menuOffset: flipped ? menuOffsetFlip : menuOffset,
        menuRef: this._bindMenuBody,
        onPlace: this._handlePlace
      }, menuBody));
      var iconProps = {
        onClick: this.handleClick,
        onKeyDown: this.handleKeyDown,
        className: overflowMenuIconClasses,
        description: iconDescription,
        focusable: 'false' // Prevent `<svg>` in trigger icon from getting focus for IE11

      };
      return React.createElement(ClickListener, {
        onClickOutside: this.handleClickOutside
      }, React.createElement("div", _extends({}, other, {
        role: "button",
        "aria-haspopup": true,
        "aria-expanded": this.state.open,
        className: overflowMenuClasses,
        onKeyDown: this.handleKeyPress,
        "aria-label": ariaLabel,
        id: id,
        tabIndex: tabIndex,
        ref: this.bindMenuEl
      }), renderIcon ? renderIcon(iconProps) : React.createElement(Icon, _extends({}, iconProps, {
        name: iconName,
        style: {
          width: '100%'
        }
      })), open && wrappedMenuBody));
    }
  }]);

  return OverflowMenu;
}(Component);

Object.defineProperty(OverflowMenu, "propTypes", {
  configurable: true,
  enumerable: true,
  writable: true,
  value: {
    /**
     * `true` if the menu should be open.
     */
    open: PropTypes.bool,

    /**
     * `true` if the menu alignment should be flipped.
     */
    flipped: PropTypes.bool,

    /**
     * `true` if the menu should be floated, making the DOM of the menu body orphaned from the trigger button.
     * Useful when the container of the triggering element cannot have `overflow:visible` style, etc.
     */
    floatingMenu: PropTypes.bool,

    /**
     * The child nodes.
     */
    children: PropTypes.node,

    /**
     * The CSS class names.
     */
    className: PropTypes.string,

    /**
     * The `tabindex` attribute.
     */
    tabIndex: PropTypes.number,

    /**
     * The element ID.
     */
    id: PropTypes.string,

    /**
     * The ARIA label.
     */
    ariaLabel: PropTypes.string,

    /**
     * The event handler for the `click` event.
     */
    onClick: PropTypes.func,

    /**
     * The event handler for the `focus` event.
     */
    onFocus: PropTypes.func,

    /**
     * The event handler for the `keydown` event.
     */
    onKeyDown: PropTypes.func,

    /**
     * The icon description.
     */
    iconDescription: PropTypes.string.isRequired,

    /**
     * The icon name.
     */
    iconName: PropTypes.string,

    /**
     * The adjustment in position applied to the floating menu.
     */
    menuOffset: PropTypes.oneOfType([PropTypes.shape({
      top: PropTypes.number,
      left: PropTypes.number
    }), PropTypes.func]),

    /**
     * The adjustment in position applied to the floating menu.
     */
    menuOffsetFlip: PropTypes.oneOfType([PropTypes.shape({
      top: PropTypes.number,
      left: PropTypes.number
    }), PropTypes.func]),

    /**
     * The CSS class for the icon.
     */
    iconClass: PropTypes.string,

    /**
     * Function called to override icon rendering.
     */
    renderIcon: PropTypes.func
  }
});
Object.defineProperty(OverflowMenu, "defaultProps", {
  configurable: true,
  enumerable: true,
  writable: true,
  value: {
    ariaLabel: 'list of options',
    iconDescription: 'open and close list of options',
    iconName: 'overflow-menu',
    open: false,
    flipped: false,
    floatingMenu: false,
    onClick: function onClick() {},
    onKeyDown: function onKeyDown() {},
    tabIndex: 0,
    menuOffset: getMenuOffset,
    menuOffsetFlip: getMenuOffset
  }
});
export { OverflowMenu as default };