'use strict';

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _Card = require('../Card');

var _Card2 = _interopRequireDefault(_Card);

var _enzyme = require('enzyme');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

describe('Card', function () {
  describe('Renders as expected', function () {
    var wrapper = (0, _enzyme.shallow)(_react2.default.createElement(
      _Card2.default,
      { className: 'extra-class' },
      _react2.default.createElement(
        'div',
        { className: 'child' },
        'Test'
      )
    ));

    it('renders children as expected', function () {
      expect(wrapper.find('.child').length).toBe(1);
    });

    it('has the expected classes', function () {
      expect(wrapper.hasClass('bx--card')).toEqual(true);
    });

    it('renders extra classes passed in via className', function () {
      expect(wrapper.hasClass('extra-class')).toEqual(true);
    });

    it('has default tabIndex of 0', function () {
      expect(wrapper.props().tabIndex).toEqual(0);
    });
  });

  describe('Check that functions passed in as props are called', function () {
    var onClick = jest.fn();
    var wrapper = (0, _enzyme.mount)(_react2.default.createElement(_Card2.default, { onClick: onClick }));

    it('should call onClick', function () {
      wrapper.simulate('click');
      expect(onClick).toBeCalled();
    });
  });
});