'use strict';

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _ContentSwitcher = require('../ContentSwitcher');

var _ContentSwitcher2 = _interopRequireDefault(_ContentSwitcher);

var _Switch = require('../Switch');

var _Switch2 = _interopRequireDefault(_Switch);

var _enzyme = require('enzyme');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

describe('ContentSwitcher', function () {
  describe('component initial rendering', function () {
    var wrapper = (0, _enzyme.shallow)(_react2.default.createElement(
      _ContentSwitcher2.default,
      { onChange: function onChange() {}, className: 'extra-class' },
      _react2.default.createElement(_Switch2.default, { kind: 'anchor', text: 'one' }),
      _react2.default.createElement(_Switch2.default, { kind: 'anchor', text: 'two' })
    ));

    var children = wrapper.find(_Switch2.default);

    it('should have the correct class', function () {
      expect(wrapper.hasClass('bx--content-switcher')).toEqual(true);
    });

    it('should render children as expected', function () {
      expect(children.length).toEqual(2);
    });

    it('should default "selected" property to true on first child', function () {
      expect(children.first().props().selected).toEqual(true);
      expect(children.last().props().selected).toEqual(false);
    });

    it('should apply extra classes passed to it', function () {
      expect(wrapper.hasClass('extra-class')).toEqual(true);
    });
  });

  describe('Allow initial state to draw from props', function () {
    var wrapper = (0, _enzyme.shallow)(_react2.default.createElement(
      _ContentSwitcher2.default,
      {
        selectedIndex: 1,
        onChange: function onChange() {},
        className: 'extra-class' },
      _react2.default.createElement(_Switch2.default, { kind: 'anchor', text: 'one' }),
      _react2.default.createElement(_Switch2.default, { kind: 'anchor', text: 'two' })
    ));

    var children = wrapper.find(_Switch2.default);

    it('Should apply the selected property on the selected child', function () {
      expect(children.first().props().selected).toEqual(false);
      expect(children.last().props().selected).toEqual(true);
    });
  });

  describe('when child component onClick is invoked', function () {
    var onChange = jest.fn();
    var mockData = {
      index: 1
    };

    var wrapper = (0, _enzyme.mount)(_react2.default.createElement(
      _ContentSwitcher2.default,
      { onChange: onChange },
      _react2.default.createElement(_Switch2.default, { kind: 'anchor', text: 'one' }),
      _react2.default.createElement(_Switch2.default, { kind: 'anchor', text: 'two' })
    ));

    var children = wrapper.find(_Switch2.default);

    children.first().props().onClick(mockData);

    it('should invoke onChange', function () {
      expect(onChange).toBeCalledWith(mockData);
    });

    it('should set the correct selectedIndex', function () {
      expect(wrapper.state('selectedIndex')).toEqual(mockData.index);
    });

    it('should set selected to true on the correct child', function () {
      wrapper.update();
      var firstChild = wrapper.find(_Switch2.default).first();
      var secondChild = wrapper.find(_Switch2.default).last();
      expect(firstChild.props().selected).toEqual(false);
      expect(secondChild.props().selected).toEqual(true);
    });
  });

  describe('when child component onKeyDown is invoked', function () {
    var onChange = jest.fn();
    var mockData = {
      index: 1
    };

    var wrapper = (0, _enzyme.mount)(_react2.default.createElement(
      _ContentSwitcher2.default,
      { onChange: onChange },
      _react2.default.createElement(_Switch2.default, { kind: 'anchor', text: 'one' }),
      _react2.default.createElement(_Switch2.default, { kind: 'anchor', text: 'two' })
    ));

    var children = wrapper.find(_Switch2.default);

    children.first().props().onKeyDown(mockData);

    it('should invoke onChange', function () {
      expect(onChange).toBeCalledWith(mockData);
    });

    it('should set the correct selectedIndex', function () {
      expect(wrapper.state('selectedIndex')).toEqual(mockData.index);
    });

    it('should set selected to true on the correct child', function () {
      wrapper.update();
      var firstChild = wrapper.find(_Switch2.default).first();
      var secondChild = wrapper.find(_Switch2.default).last();
      expect(firstChild.props().selected).toEqual(false);
      expect(secondChild.props().selected).toEqual(true);
    });
  });
});