"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireWildcard(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

var _Icon = _interopRequireDefault(require("../Icon"));

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

var CopyButton =
/*#__PURE__*/
function (_Component) {
  _inherits(CopyButton, _Component);

  function CopyButton() {
    var _ref;

    var _temp, _this;

    _classCallCheck(this, CopyButton);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return _possibleConstructorReturn(_this, (_temp = _this = _possibleConstructorReturn(this, (_ref = CopyButton.__proto__ || Object.getPrototypeOf(CopyButton)).call.apply(_ref, [this].concat(args))), Object.defineProperty(_assertThisInitialized(_this), "state", {
      configurable: true,
      enumerable: true,
      writable: true,
      value: {
        showFeedback: false
      }
    }), Object.defineProperty(_assertThisInitialized(_this), "handleClick", {
      configurable: true,
      enumerable: true,
      writable: true,
      value: function value(evt) {
        _this.setState({
          showFeedback: true
        });

        _this.timeoutId = setTimeout(function () {
          _this.setState({
            showFeedback: false
          });
        }, _this.props.feedbackTimeout);

        _this.props.onClick(evt);
      }
    }), _temp));
  }

  _createClass(CopyButton, [{
    key: "componentWillUnmount",

    /* istanbul ignore next */
    value: function componentWillUnmount() {
      if (typeof this.timeoutId !== 'undefined') {
        clearTimeout(this.timeoutId);
        delete this.timeoutId;
      }
    }
  }, {
    key: "render",
    // eslint-disable-line no-unused-vars
    value: function render() {
      var _props = this.props,
          iconDescription = _props.iconDescription,
          className = _props.className,
          feedback = _props.feedback,
          feedbackTimeout = _props.feedbackTimeout,
          onClick = _props.onClick,
          other = _objectWithoutProperties(_props, ["iconDescription", "className", "feedback", "feedbackTimeout", "onClick"]);

      var classNames = (0, _classnames.default)('bx--snippet-button', className);
      var feedbackClassNames = (0, _classnames.default)('bx--btn--copy__feedback', {
        'bx--btn--copy__feedback--displayed': this.state.showFeedback
      });
      return _react.default.createElement("button", _extends({
        type: "button",
        className: classNames,
        onClick: this.handleClick
      }, other), _react.default.createElement(_Icon.default, {
        className: "bx--snippet__icon",
        name: "copy",
        description: iconDescription
      }), _react.default.createElement("div", {
        className: feedbackClassNames,
        "data-feedback": feedback
      }));
    }
  }]);

  return CopyButton;
}(_react.Component);

exports.default = CopyButton;
Object.defineProperty(CopyButton, "propTypes", {
  configurable: true,
  enumerable: true,
  writable: true,
  value: {
    children: _propTypes.default.node,
    className: _propTypes.default.string,
    iconDescription: _propTypes.default.string,
    feedback: _propTypes.default.string,
    feedbackTimeout: _propTypes.default.number,
    onClick: _propTypes.default.func
  }
});
Object.defineProperty(CopyButton, "defaultProps", {
  configurable: true,
  enumerable: true,
  writable: true,
  value: {
    iconDescription: 'Copy to clipboard',
    feedback: 'Copied!',
    feedbackTimeout: 2000,
    onClick: function onClick() {}
  }
});